/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.data.Study;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.editor.StudyListEditor;
import gov.fcc.tvstudy.util.DateCounter;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.QueryWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DbManager {
    public static final int DATABASE_VERSION = 103000;
    private static final String DEFAULT_HOST_KEY = "host";
    private static final String DEFAULT_USER_KEY = "user";
    private static final String DB_ID_KEY_PREFIX = "db_uuid_";
    private static HashMap<String, DbConnection> dbs;
    private static HashMap<String, HashMap<String, String>> propertyMaps;
    private static HashMap<String, HashMap<String, String>> changedPropertyMaps;
    private static HashMap<String, Long> lastPropertySyncTimes;
    private static final int PROPERTY_SYNC_INTERVAL = 600000;
    private static HashMap<String, StudyListEditor> editors;
    private static HashMap<String, ManagerDialog> managers;
    private static LoginDialog loginDialog;

    public static void showLogin(boolean bl) {
        if (null != loginDialog) {
            if (loginDialog.isVisible()) {
                return;
            }
        } else {
            dbs = new HashMap();
            propertyMaps = new HashMap();
            changedPropertyMaps = new HashMap();
            lastPropertySyncTimes = new HashMap();
            editors = new HashMap();
            managers = new HashMap();
            loginDialog = new LoginDialog();
        }
        loginDialog.quitButton.setEnabled(bl);
        AppManager.showWindow(loginDialog);
    }

    public static boolean isLoginWindow(Window window) {
        return window == loginDialog;
    }

    private static void openDb(DbInfo dbInfo) {
        if (null == dbInfo.db) {
            return;
        }
        dbs.put(dbInfo.dbID, dbInfo.db);
        propertyMaps.put(dbInfo.dbID, new HashMap());
        changedPropertyMaps.put(dbInfo.dbID, new HashMap());
        lastPropertySyncTimes.put(dbInfo.dbID, new Long(0L));
    }

    public static synchronized boolean isDbOpen(String string) {
        return dbs.containsKey(string);
    }

    public static synchronized DbConnection getDb(String string) {
        DbConnection dbConnection = dbs.get(string);
        if (null == dbConnection) {
            dbConnection = new DbConnection("", "", "", "");
        }
        return dbConnection;
    }

    public static String getDbHost(String string) {
        DbConnection dbConnection = dbs.get(string);
        if (null == dbConnection) {
            return "unknown";
        }
        return dbConnection.hostname;
    }

    private static void closeDb(String string) {
        DbManager.syncProperties(string, false);
        propertyMaps.remove(string);
        changedPropertyMaps.remove(string);
        lastPropertySyncTimes.remove(string);
        DbConnection dbConnection = dbs.remove(string);
        if (null != dbConnection) {
            dbConnection.close(false);
        }
    }

    public static boolean canOpenStudyListEditor(StudyListEditor studyListEditor) {
        return editors.containsValue(studyListEditor);
    }

    public static void didCloseStudyListEditor(StudyListEditor studyListEditor) {
        String string = studyListEditor.getDbID();
        editors.remove(string);
        DbManager.closeDb(string);
    }

    public static StudyListEditor getStudyListEditor(String string) {
        return editors.get(string);
    }

    public static double getTotalMemoryFraction() {
        double d = 0.0;
        for (StudyListEditor studyListEditor : editors.values()) {
            d += studyListEditor.getTotalMemoryFraction();
        }
        return d;
    }

    public static synchronized String getProperty(String string, String string2) {
        if (null == string || 0 == string.length()) {
            return AppManager.getProperty(string2);
        }
        HashMap<String, String> hashMap = propertyMaps.get(string);
        if (null == hashMap) {
            return null;
        }
        if (System.currentTimeMillis() - lastPropertySyncTimes.get(string) > 600000L) {
            DbManager.syncProperties(string, true);
            hashMap = propertyMaps.get(string);
        }
        return hashMap.get(string2);
    }

    public static synchronized void setProperty(String string, String string2, String string3) {
        if (null == string3) {
            return;
        }
        if (null == string || 0 == string.length()) {
            AppManager.setProperty(string2, string3);
            return;
        }
        HashMap<String, String> hashMap = propertyMaps.get(string);
        if (null == hashMap) {
            return;
        }
        String string4 = hashMap.put(string2, string3);
        if (null == string4 || !string3.equals(string4)) {
            changedPropertyMaps.get(string).put(string2, string3);
        }
        if (System.currentTimeMillis() - lastPropertySyncTimes.get(string) > 600000L) {
            DbManager.syncProperties(string, true);
        }
    }

    public static Boolean getBooleanProperty(String string, String string2) {
        String string3 = DbManager.getProperty(string, string2);
        Boolean bl = null;
        if (null != string3) {
            bl = Boolean.valueOf(string3);
        }
        return bl;
    }

    public static void setBooleanProperty(String string, String string2, Boolean bl) {
        DbManager.setProperty(string, string2, bl.toString());
    }

    public static Integer getIntegerProperty(String string, String string2) {
        String string3 = DbManager.getProperty(string, string2);
        Integer n = null;
        if (null != string3) {
            try {
                n = Integer.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static void setIntegerProperty(String string, String string2, Integer n) {
        DbManager.setProperty(string, string2, n.toString());
    }

    public static synchronized int deleteProperty(String string, String string2) {
        if (null == string || 0 == string.length()) {
            return 0;
        }
        DbConnection dbConnection = dbs.get(string);
        if (null == dbConnection) {
            return 0;
        }
        int n = 0;
        DbManager.syncProperties(string, false);
        dbConnection = dbConnection.copy();
        if (dbConnection.connect()) {
            try {
                n = dbConnection.update("DELETE FROM tvstudy.application_property WHERE name LIKE '" + string2 + "'");
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close(false);
        }
        return n;
    }

    private static synchronized void syncProperties(String string, boolean bl) {
        DbConnection dbConnection = dbs.get(string);
        if (null == dbConnection) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Long l = new Long(System.currentTimeMillis());
        HashMap<String, String> hashMap2 = changedPropertyMaps.get(string);
        if ((!hashMap2.isEmpty() || bl) && (dbConnection = dbConnection.copy()).connect()) {
            try {
                dbConnection.update("LOCK TABLES tvstudy.application_property WRITE");
                if (!hashMap2.isEmpty()) {
                    Iterator<Map.Entry<String, String>> iterator = hashMap2.entrySet().iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> entry = iterator.next();
                        String string2 = "'" + dbConnection.clean(entry.getKey()) + "'";
                        String string3 = "'" + dbConnection.clean(entry.getValue()) + "'";
                        n = dbConnection.update("UPDATE tvstudy.application_property SET value = " + string3 + " " + "WHERE " + "name = " + string2);
                        if (0 != n) continue;
                        dbConnection.update("INSERT INTO tvstudy.application_property (name, value) VALUES (" + string2 + ", " + string3 + ")");
                    }
                    hashMap2.clear();
                }
                if (bl) {
                    dbConnection.query("SELECT name, value FROM tvstudy.application_property");
                    while (dbConnection.next()) {
                        hashMap.put(dbConnection.getString("name"), dbConnection.getString("value"));
                    }
                }
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
                hashMap = null;
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close(false);
        }
        if (null != hashMap) {
            propertyMaps.put(string, hashMap);
            if (!bl) {
                l = new Long(0L);
            }
        }
        lastPropertySyncTimes.put(string, l);
    }

    public static void saveWindowLocation(Window window, String string, String string2) {
        DbManager.setIntegerProperty(string, string2 + ".x", window.getLocation().x);
        DbManager.setIntegerProperty(string, string2 + ".y", window.getLocation().y);
        boolean bl = false;
        if (window instanceof Frame) {
            bl = ((Frame)window).isResizable();
        } else if (window instanceof Dialog) {
            bl = ((Dialog)window).isResizable();
        }
        if (bl) {
            DbManager.setIntegerProperty(string, string2 + ".sizex", window.getWidth());
            DbManager.setIntegerProperty(string, string2 + ".sizey", window.getHeight());
        }
    }

    public static void restoreWindowLocation(Window window, String string, String string2, int n, int n2) {
        Integer n3 = DbManager.getIntegerProperty(string, string2 + ".x");
        Integer n4 = DbManager.getIntegerProperty(string, string2 + ".y");
        if (n3 != null && n4 != null) {
            n = n3;
            n2 = n4;
        }
        window.setLocation(n, n2);
        boolean bl = false;
        if (window instanceof Frame) {
            bl = ((Frame)window).isResizable();
        } else if (window instanceof Dialog) {
            bl = ((Dialog)window).isResizable();
        }
        if (bl) {
            n3 = DbManager.getIntegerProperty(string, string2 + ".sizex");
            n4 = DbManager.getIntegerProperty(string, string2 + ".sizey");
            if (n3 != null && n4 != null) {
                window.setSize(n3, n4);
            }
        }
    }

    public static void saveColumnWidths(String string, String string2, JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            DbManager.setIntegerProperty(string, string2 + "." + tableColumn.getIdentifier() + ".columnWidth", tableColumn.getWidth());
        }
    }

    public static void restoreColumnWidths(String string, String string2, JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            Integer n2 = DbManager.getIntegerProperty(string, string2 + "." + tableColumn.getIdentifier() + ".columnWidth");
            if (null == n2) continue;
            tableColumn.setPreferredWidth(n2);
        }
    }

    public static boolean checkStudyName(String string, String string2) {
        return DbManager.checkName(true, string, string2, null, null);
    }

    public static boolean checkStudyName(String string, String string2, ErrorReporter errorReporter) {
        return DbManager.checkName(true, string, string2, null, errorReporter);
    }

    public static boolean checkStudyName(String string, StudyEditData studyEditData) {
        return DbManager.checkName(true, string, studyEditData.dbID, studyEditData, null);
    }

    public static boolean checkStudyName(String string, StudyEditData studyEditData, ErrorReporter errorReporter) {
        return DbManager.checkName(true, string, studyEditData.dbID, studyEditData, errorReporter);
    }

    public static boolean checkScenarioName(String string, StudyEditData studyEditData) {
        return DbManager.checkName(false, string, studyEditData.dbID, studyEditData, null);
    }

    public static boolean checkScenarioName(String string, StudyEditData studyEditData, ErrorReporter errorReporter) {
        return DbManager.checkName(false, string, studyEditData.dbID, studyEditData, errorReporter);
    }

    private static boolean checkName(boolean bl, String string, String string2, StudyEditData studyEditData, ErrorReporter errorReporter) {
        int n;
        String string3 = bl ? "study" : "scenario";
        int n2 = string.length();
        if (0 == n2) {
            if (null != errorReporter) {
                errorReporter.reportValidationError("Please enter a name for the " + string3 + ".");
            }
            return false;
        }
        if (n2 > 255) {
            if (null != errorReporter) {
                errorReporter.reportValidationError("A " + string3 + " name cannot be more than 255 characters long.");
            }
            return false;
        }
        boolean bl2 = true;
        boolean bl3 = false;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if ('/' == c || '\\' == c || ':' == c) {
                bl3 = true;
                break;
            }
            if (!bl2 || Character.isDigit(c)) continue;
            bl2 = false;
        }
        if (bl3) {
            if (null != errorReporter) {
                errorReporter.reportValidationError("A " + string3 + " name cannot contain the characters '/', '\\', or ':'.");
            }
            return false;
        }
        if (bl2) {
            if (null != errorReporter) {
                errorReporter.reportValidationError("A " + string3 + " name must contain at least one non-digit character.");
            }
            return false;
        }
        if (bl) {
            int n3 = Study.getStudyKeyForName(DbManager.getDb(string2), errorReporter, string);
            if (n3 < 0) {
                return false;
            }
            n = n3 > 0 && (null == studyEditData || n3 != studyEditData.study.key) ? 1 : 0;
        } else {
            int n4 = n = null != studyEditData.scenarioModel.get(string) ? 1 : 0;
        }
        if (n != 0) {
            if (null != errorReporter) {
                errorReporter.reportValidationError("A " + string3 + " with that name already exists.");
            }
            return false;
        }
        return true;
    }

    private static void installDb(DbConnection dbConnection, QueryWorker queryWorker) throws SQLException {
        String string = UUID.randomUUID().toString();
        dbConnection.update("CREATE DATABASE tvstudy");
        dbConnection.update("CREATE TABLE tvstudy.version (version INT NOT NULL, uuid TEXT NOT NULL)");
        dbConnection.update("INSERT INTO tvstudy.version VALUES (0, '" + dbConnection.clean(string) + "')");
        ArrayList<String> arrayList = new ArrayList<String>();
        dbConnection.query("SHOW DATABASES LIKE 'tvstudy_%'");
        while (dbConnection.next()) {
            arrayList.add(dbConnection.getString(1));
        }
        for (String string2 : arrayList) {
            dbConnection.update("DROP DATABASE " + string2);
        }
        dbConnection.update("USE tvstudy");
        dbConnection.update("CREATE TABLE study (study_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,description TEXT NOT NULL,study_lock INT NOT NULL,lock_count INT NOT NULL,share_count INT NOT NULL,new_study BOOLEAN NOT NULL,needs_update BOOLEAN NOT NULL,template_key INT NOT NULL,cdbs_key INT NOT NULL,parameter_summary TEXT NOT NULL)");
        dbConnection.update("CREATE TABLE study_key_sequence (study_key INT NOT NULL)");
        dbConnection.update("INSERT INTO study_key_sequence VALUES (0)");
        dbConnection.update("CREATE TABLE cdbs (cdbs_key INT NOT NULL,id VARCHAR(255) NOT NULL,name VARCHAR(255) NOT NULL,use_count INT NOT NULL)");
        dbConnection.update("CREATE TABLE cdbs_key_sequence (cdbs_key INT NOT NULL)");
        dbConnection.update("INSERT INTO cdbs_key_sequence VALUES (0)");
        dbConnection.update("CREATE TABLE country (country_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,country_code CHAR(2) NOT NULL)");
        dbConnection.update("INSERT INTO country VALUES (1, 'U.S.', 'US'),(2, 'Canada', 'CA'),(3, 'Mexico', 'MX')");
        dbConnection.update("CREATE TABLE service_type (service_type_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,digital BOOLEAN NOT NULL,needs_emission_mask BOOLEAN NOT NULL)");
        dbConnection.update("INSERT INTO service_type VALUES (1, 'Full Service digital', true, false),(2, 'Full Service analog', false, false),(3, 'Class A digital', true, true),(4, 'Class A analog', false, false),(5, 'Low Power digital', true, true),(6, 'Low Power analog', false, false)");
        dbConnection.update("CREATE TABLE service (service_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,service_code CHAR(2) NOT NULL,service_type_key INT NOT NULL,is_dts BOOLEAN NOT NULL,is_operating BOOLEAN NOT NULL,preference_rank INT NOT NULL,digital_service_key INT NOT NULL)");
        dbConnection.update("INSERT INTO service VALUES (1, 'Digital TV', 'DT', 1, false, true, 170, 0),(2, 'Digital TV DTS', 'DD', 1, true, true, 180, 0),(3, 'Digital Class A', 'DC', 3, false, true, 150, 0),(4, 'Digital LPTV/Translator', 'LD', 5, false, true, 140, 0),(5, 'Digital STA', 'DS', 1, false, true, 160, 0),(6, 'Analog TV', 'TV', 2, false, true, 130, 1),(7, 'Analog Class A', 'CA', 4, false, true, 120, 3),(8, 'Analog LPTV/Translator', 'TX', 6, false, true, 110, 4),(9, 'Analog Booster', 'TB', 6, false, true, 100, 4),(10, 'DTV Auxiliary', 'DX', 1, false, false, 60, 0),(11, 'DTV Rulemaking', 'DR', 1, false, false, 90, 0),(12, 'DTV Channel Change', 'DM', 1, false, false, 80, 0),(13, 'DTV New Allotment', 'DN', 1, false, false, 70, 0),(14, 'TV Auxiliary', 'TS', 2, false, false, 10, 10),(15, 'TV Allotment', 'TA', 2, false, false, 50, 13),(16, 'TV Rulemaking', 'TR', 2, false, false, 40, 11),(17, 'TV Channel Change', 'NM', 2, false, false, 30, 12),(18, 'TV New Allotment', 'NN', 2, false, false, 20, 13)");
        dbConnection.update("CREATE TABLE channel_band (channel_band_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,first_channel INT NOT NULL,last_channel INT NOT NULL)");
        dbConnection.update("INSERT INTO channel_band VALUES (1, 'VHF', 2, 13),(2, 'UHF', 14, 51)");
        dbConnection.update("CREATE TABLE channel_delta (channel_delta_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,delta INT NOT NULL,analog_only BOOLEAN NOT NULL,maximum_distance FLOAT NOT NULL)");
        dbConnection.update("INSERT INTO channel_delta VALUES (1, '8 below', -8, true, 35),(2, '7 below', -7, true, 100),(3, '4 below', -4, true, 35),(4, '3 below', -3, true, 35),(5, '2 below', -2, true, 35),(6, '1 below', -1, false, 100),(7, 'co-channel', 0, false, 300),(8, '1 above', 1, false, 100),(9, '2 above', 2, true, 35),(10, '3 above', 3, true, 35),(11, '4 above', 4, true, 35),(12, '7 above', 7, true, 100),(13, '8 above', 8, true, 35),(14, '14 above', 14, true, 100),(15, '15 above', 15, true, 125)");
        dbConnection.update("CREATE TABLE emission_mask (emission_mask_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,emission_mask_code CHAR(1) NOT NULL,is_default BOOLEAN NOT NULL)");
        dbConnection.update("INSERT INTO emission_mask VALUES(1, 'Simple', 'S', true),(2, 'Stringent', 'T', false),(3, 'Full Service', 'F', false)");
        dbConnection.update("CREATE TABLE frequency_offset (frequency_offset_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,offset_code CHAR(1) NOT NULL)");
        dbConnection.update("INSERT INTO frequency_offset VALUES(1, 'Zero', 'Z'),(2, 'Plus', '+'),(3, 'Minus', '-')");
        dbConnection.update("CREATE TABLE zone (zone_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,zone_code CHAR(1) NOT NULL)");
        dbConnection.update("INSERT INTO zone VALUES(1, 'I', '1'),(2, 'II', '2'),(3, 'III', '3')");
        dbConnection.update("CREATE TABLE template (template_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,locked BOOLEAN NOT NULL,locked_in_study BOOLEAN NOT NULL,use_count INT NOT NULL)");
        dbConnection.update("INSERT INTO template VALUES (1, \"Default\", true, false, 0)");
        dbConnection.update("CREATE TABLE template_key_sequence (template_key INT NOT NULL)");
        dbConnection.update("INSERT INTO template_key_sequence VALUES (1)");
        dbConnection.update("CREATE TABLE template_parameter_data (template_key INT NOT NULL,parameter_key INT NOT NULL,value VARCHAR(255) NOT NULL,PRIMARY KEY (template_key, parameter_key))");
        dbConnection.update("CREATE TABLE template_ix_rule (template_key INT NOT NULL,ix_rule_key INT NOT NULL,country_key INT NOT NULL,service_type_key INT NOT NULL,undesired_service_type_key INT NOT NULL,channel_delta_key INT NOT NULL,channel_band_key INT NOT NULL,frequency_offset INT NOT NULL,emission_mask_key INT NOT NULL,distance FLOAT NOT NULL,required_du FLOAT NOT NULL,undesired_time INT NOT NULL,PRIMARY KEY (template_key, ix_rule_key))");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,   1, 1, 2, 2,  7, 0, 2, 0, 300.,  28., 10),(1,   2, 1, 2, 2,  7, 0, 1, 0, 300.,  45., 10),(1,   3, 1, 2, 2,  8, 0, 0, 0, 100., -13., 10),(1,   4, 1, 2, 2,  9, 2, 0, 0,  35., -29., 10),(1,   5, 1, 2, 2, 10, 2, 0, 0,  35., -34., 10),(1,   6, 1, 2, 2, 11, 2, 0, 0,  35., -23., 10),(1,   7, 1, 2, 2, 12, 2, 0, 0, 100., -33., 10),(1,   8, 1, 2, 2, 13, 2, 0, 0,  35., -41., 10),(1,   9, 1, 2, 2,  6, 0, 0, 0, 100.,  -3., 10),(1,  10, 1, 2, 2,  5, 2, 0, 0,  35., -26., 10),(1,  11, 1, 2, 2,  4, 2, 0, 0,  35., -33., 10),(1,  12, 1, 2, 2,  2, 2, 0, 0, 100., -30., 10),(1,  13, 1, 2, 2,  1, 2, 0, 0,  35., -32., 10),(1,  14, 1, 2, 2, 14, 2, 0, 0, 100., -25., 10),(1,  15, 1, 2, 2, 15, 2, 0, 0, 125.,  -9., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  16, 1, 2, 1,  7, 0, 0, 0, 300.,  34., 10),(1,  17, 1, 2, 1,  8, 0, 0, 0, 100., -17., 10),(1,  18, 1, 2, 1,  9, 2, 0, 0,  35., -28., 10),(1,  19, 1, 2, 1, 10, 2, 0, 0,  35., -34., 10),(1,  20, 1, 2, 1, 11, 2, 0, 0,  35., -25., 10),(1,  21, 1, 2, 1, 12, 2, 0, 0,  35., -43., 10),(1,  22, 1, 2, 1, 13, 2, 0, 0,  35., -43., 10),(1,  23, 1, 2, 1,  6, 0, 0, 0, 100., -14., 10),(1,  24, 1, 2, 1,  5, 2, 0, 0,  35., -24., 10),(1,  25, 1, 2, 1,  4, 2, 0, 0,  35., -30., 10),(1,  26, 1, 2, 1,  3, 2, 0, 0,  35., -34., 10),(1,  27, 1, 2, 1,  2, 2, 0, 0,  35., -35., 10),(1,  28, 1, 2, 1,  1, 2, 0, 0,  35., -32., 10),(1,  29, 1, 2, 1, 14, 2, 0, 0,  35., -33., 10),(1,  30, 1, 2, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  31, 1, 2, 4,  7, 0, 2, 0, 300.,  28., 10),(1,  32, 1, 2, 4,  7, 0, 1, 0, 300.,  45., 10),(1,  33, 1, 2, 4,  8, 1, 0, 0, 100., -12., 50),(1,  34, 1, 2, 4,  8, 2, 0, 0, 100., -15., 50),(1,  35, 1, 2, 4,  6, 1, 0, 0, 100.,  -6., 50),(1,  36, 1, 2, 4,  6, 2, 0, 0, 100., -15., 50),(1,  37, 1, 2, 4, 14, 2, 0, 0, 100., -23., 50),(1,  38, 1, 2, 4, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  39, 1, 2, 3,  7, 0, 0, 0, 300.,  34., 10),(1,  40, 1, 2, 3,  8, 0, 0, 1, 100.,  10., 10),(1,  41, 1, 2, 3,  8, 0, 0, 2, 100.,   0., 10),(1,  42, 1, 2, 3,  8, 0, 0, 3, 100., -17., 10),(1,  43, 1, 2, 3,  9, 2, 0, 0,  35., -28., 10),(1,  44, 1, 2, 3, 10, 2, 0, 0,  35., -34., 10),(1,  45, 1, 2, 3, 11, 2, 0, 0,  35., -25., 10),(1,  46, 1, 2, 3, 12, 2, 0, 0,  35., -43., 10),(1,  47, 1, 2, 3, 13, 2, 0, 0,  35., -43., 10),(1,  48, 1, 2, 3,  6, 0, 0, 1, 100.,  10., 10),(1,  49, 1, 2, 3,  6, 0, 0, 2, 100.,   0., 10),(1,  50, 1, 2, 3,  6, 0, 0, 3, 100., -14., 10),(1,  51, 1, 2, 3,  5, 2, 0, 0,  35., -24., 10),(1,  52, 1, 2, 3,  4, 2, 0, 0,  35., -30., 10),(1,  53, 1, 2, 3,  3, 2, 0, 0,  35., -34., 10),(1,  54, 1, 2, 3,  2, 2, 0, 0,  35., -35., 10),(1,  55, 1, 2, 3,  1, 2, 0, 0,  35., -32., 10),(1,  56, 1, 2, 3, 14, 2, 0, 0,  35., -33., 10),(1,  57, 1, 2, 3, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  58, 1, 2, 6,  7, 0, 2, 0, 300.,  28., 10),(1,  59, 1, 2, 6,  7, 0, 1, 0, 300.,  45., 10),(1,  60, 1, 2, 6,  8, 1, 0, 0, 100., -12., 50),(1,  61, 1, 2, 6,  8, 2, 0, 0, 100., -15., 50),(1,  62, 1, 2, 6,  6, 1, 0, 0, 100.,  -6., 50),(1,  63, 1, 2, 6,  6, 2, 0, 0, 100., -15., 50),(1,  64, 1, 2, 6, 14, 2, 0, 0, 100., -23., 50),(1,  65, 1, 2, 6, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  66, 1, 2, 5,  7, 0, 0, 0, 300.,  34., 10),(1,  67, 1, 2, 5,  8, 0, 0, 1, 100.,  10., 10),(1,  68, 1, 2, 5,  8, 0, 0, 2, 100.,   0., 10),(1,  69, 1, 2, 5,  8, 0, 0, 3, 100., -17., 10),(1,  70, 1, 2, 5,  9, 2, 0, 0,  35., -28., 10),(1,  71, 1, 2, 5, 10, 2, 0, 0,  35., -34., 10),(1,  72, 1, 2, 5, 11, 2, 0, 0,  35., -25., 10),(1,  73, 1, 2, 5, 12, 2, 0, 0,  35., -43., 10),(1,  74, 1, 2, 5, 13, 2, 0, 0,  35., -43., 10),(1,  75, 1, 2, 5,  6, 0, 0, 1, 100.,  10., 10),(1,  76, 1, 2, 5,  6, 0, 0, 2, 100.,   0., 10),(1,  77, 1, 2, 5,  6, 0, 0, 3, 100., -14., 10),(1,  78, 1, 2, 5,  5, 2, 0, 0,  35., -24., 10),(1,  79, 1, 2, 5,  4, 2, 0, 0,  35., -30., 10),(1,  80, 1, 2, 5,  3, 2, 0, 0,  35., -34., 10),(1,  81, 1, 2, 5,  2, 2, 0, 0,  35., -35., 10),(1,  82, 1, 2, 5,  1, 2, 0, 0,  35., -32., 10),(1,  83, 1, 2, 5, 14, 2, 0, 0,  35., -33., 10),(1,  84, 1, 2, 5, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  85, 1, 1, 2,  7, 0, 0, 0, 300.,   2., 10),(1,  86, 1, 1, 2,  8, 0, 0, 0, 100., -49., 10),(1,  87, 1, 1, 2,  6, 0, 0, 0, 100., -48., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  88, 1, 1, 1,  7, 0, 0, 0, 300.,  15., 10),(1,  89, 1, 1, 1,  8, 0, 0, 0, 100., -26., 10),(1,  90, 1, 1, 1,  6, 0, 0, 0, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  91, 1, 1, 4,  7, 0, 0, 0, 300.,   2., 10),(1,  92, 1, 1, 4,  8, 0, 0, 0, 100., -49., 10),(1,  93, 1, 1, 4,  6, 0, 0, 0, 100., -48., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  94, 1, 1, 3,  7, 0, 0, 0, 300.,  15., 10),(1,  95, 1, 1, 3,  8, 0, 0, 1, 100.,  -7., 10),(1,  96, 1, 1, 3,  8, 0, 0, 2, 100., -12., 10),(1,  97, 1, 1, 3,  8, 0, 0, 3, 100., -26., 10),(1,  98, 1, 1, 3,  6, 0, 0, 1, 100.,  -7., 10),(1,  99, 1, 1, 3,  6, 0, 0, 2, 100., -12., 10),(1, 100, 1, 1, 3,  6, 0, 0, 3, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 101, 1, 1, 6,  7, 0, 0, 0, 300.,   2., 10),(1, 102, 1, 1, 6,  8, 0, 0, 0, 100., -49., 50),(1, 103, 1, 1, 6,  6, 0, 0, 0, 100., -48., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 104, 1, 1, 5,  7, 0, 0, 0, 300.,  15., 10),(1, 105, 1, 1, 5,  8, 0, 0, 1, 100.,  -7., 10),(1, 106, 1, 1, 5,  8, 0, 0, 2, 100., -12., 10),(1, 107, 1, 1, 5,  8, 0, 0, 3, 100., -26., 10),(1, 108, 1, 1, 5,  6, 0, 0, 1, 100.,  -7., 10),(1, 109, 1, 1, 5,  6, 0, 0, 2, 100., -12., 10),(1, 110, 1, 1, 5,  6, 0, 0, 3, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 111, 1, 4, 2,  7, 0, 2, 0, 300.,  28., 10),(1, 112, 1, 4, 2,  7, 0, 1, 0, 300.,  45., 10),(1, 113, 1, 4, 2,  8, 1, 0, 0, 100., -12., 50),(1, 114, 1, 4, 2,  8, 2, 0, 0, 100., -15., 50),(1, 115, 1, 4, 2,  6, 1, 0, 0, 100.,  -6., 50),(1, 116, 1, 4, 2,  6, 2, 0, 0, 100., -15., 50),(1, 117, 1, 4, 2, 14, 2, 0, 0, 100., -23., 50),(1, 118, 1, 4, 2, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 119, 1, 4, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 120, 1, 4, 1,  8, 0, 0, 0, 100., -17., 10),(1, 121, 1, 4, 1,  9, 2, 0, 0,  35., -28., 10),(1, 122, 1, 4, 1, 10, 2, 0, 0,  35., -34., 10),(1, 123, 1, 4, 1, 11, 2, 0, 0,  35., -25., 10),(1, 124, 1, 4, 1, 12, 2, 0, 0,  35., -43., 10),(1, 125, 1, 4, 1, 13, 2, 0, 0,  35., -43., 10),(1, 126, 1, 4, 1,  6, 0, 0, 0, 100., -14., 10),(1, 127, 1, 4, 1,  5, 2, 0, 0,  35., -24., 10),(1, 128, 1, 4, 1,  4, 2, 0, 0,  35., -30., 10),(1, 129, 1, 4, 1,  3, 2, 0, 0,  35., -34., 10),(1, 130, 1, 4, 1,  2, 2, 0, 0,  35., -35., 10),(1, 131, 1, 4, 1,  1, 2, 0, 0,  35., -32., 10),(1, 132, 1, 4, 1, 14, 2, 0, 0,  35., -33., 10),(1, 133, 1, 4, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 134, 1, 4, 4,  7, 0, 2, 0, 300.,  28., 10),(1, 135, 1, 4, 4,  7, 0, 1, 0, 300.,  45., 10),(1, 136, 1, 4, 4,  8, 1, 0, 0, 100., -12., 50),(1, 137, 1, 4, 4,  8, 2, 0, 0, 100., -15., 50),(1, 138, 1, 4, 4,  6, 1, 0, 0, 100.,  -6., 50),(1, 139, 1, 4, 4,  6, 2, 0, 0, 100., -15., 50),(1, 140, 1, 4, 4, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 141, 1, 4, 3,  7, 0, 0, 0, 300.,  34., 10),(1, 142, 1, 4, 3,  8, 0, 0, 1, 100.,  10., 10),(1, 143, 1, 4, 3,  8, 0, 0, 2, 100.,   0., 10),(1, 144, 1, 4, 3,  8, 0, 0, 3, 100., -17., 10),(1, 145, 1, 4, 3,  9, 2, 0, 0,  35., -28., 10),(1, 146, 1, 4, 3, 10, 2, 0, 0,  35., -34., 10),(1, 147, 1, 4, 3, 11, 2, 0, 0,  35., -25., 10),(1, 148, 1, 4, 3, 12, 2, 0, 0,  35., -43., 10),(1, 149, 1, 4, 3, 13, 2, 0, 0,  35., -43., 10),(1, 150, 1, 4, 3,  6, 0, 0, 1, 100.,  10., 10),(1, 151, 1, 4, 3,  6, 0, 0, 2, 100.,   0., 10),(1, 152, 1, 4, 3,  6, 0, 0, 3, 100., -14., 10),(1, 153, 1, 4, 3,  5, 2, 0, 0,  35., -24., 10),(1, 154, 1, 4, 3,  4, 2, 0, 0,  35., -30., 10),(1, 155, 1, 4, 3,  3, 2, 0, 0,  35., -34., 10),(1, 156, 1, 4, 3,  2, 2, 0, 0,  35., -35., 10),(1, 157, 1, 4, 3,  1, 2, 0, 0,  35., -32., 10),(1, 158, 1, 4, 3, 14, 2, 0, 0,  35., -33., 10),(1, 159, 1, 4, 3, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 160, 1, 4, 6,  7, 0, 2, 0, 300.,  28., 10),(1, 161, 1, 4, 6,  7, 0, 1, 0, 300.,  45., 10),(1, 162, 1, 4, 6,  8, 1, 0, 0, 100., -12., 50),(1, 163, 1, 4, 6,  8, 2, 0, 0, 100., -15., 50),(1, 164, 1, 4, 6,  6, 1, 0, 0, 100.,  -6., 50),(1, 165, 1, 4, 6,  6, 2, 0, 0, 100., -15., 50),(1, 166, 1, 4, 6, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 167, 1, 4, 5,  7, 0, 0, 0, 300.,  34., 10),(1, 168, 1, 4, 5,  8, 0, 0, 1, 100.,  10., 10),(1, 169, 1, 4, 5,  8, 0, 0, 2, 100.,   0., 10),(1, 170, 1, 4, 5,  8, 0, 0, 3, 100., -17., 10),(1, 171, 1, 4, 5,  9, 2, 0, 0,  35., -28., 10),(1, 172, 1, 4, 5, 10, 2, 0, 0,  35., -34., 10),(1, 173, 1, 4, 5, 11, 2, 0, 0,  35., -25., 10),(1, 174, 1, 4, 5, 12, 2, 0, 0,  35., -43., 10),(1, 175, 1, 4, 5, 13, 2, 0, 0,  35., -43., 10),(1, 176, 1, 4, 5,  6, 0, 0, 1, 100.,  10., 10),(1, 177, 1, 4, 5,  6, 0, 0, 2, 100.,   0., 10),(1, 178, 1, 4, 5,  6, 0, 0, 3, 100., -14., 10),(1, 179, 1, 4, 5,  5, 2, 0, 0,  35., -24., 10),(1, 180, 1, 4, 5,  4, 2, 0, 0,  35., -30., 10),(1, 181, 1, 4, 5,  3, 2, 0, 0,  35., -34., 10),(1, 182, 1, 4, 5,  2, 2, 0, 0,  35., -35., 10),(1, 183, 1, 4, 5,  1, 2, 0, 0,  35., -32., 10),(1, 184, 1, 4, 5, 14, 2, 0, 0,  35., -33., 10),(1, 185, 1, 4, 5, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 186, 1, 3, 2,  7, 0, 0, 0, 300.,   2., 10),(1, 187, 1, 3, 2,  8, 0, 0, 0, 100., -49., 10),(1, 188, 1, 3, 2,  6, 0, 0, 0, 100., -48., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 189, 1, 3, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 190, 1, 3, 1,  8, 0, 0, 0, 100., -26., 10),(1, 191, 1, 3, 1,  6, 0, 0, 0, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 192, 1, 3, 4,  7, 0, 0, 0, 300.,   2., 10),(1, 193, 1, 3, 4,  8, 0, 0, 0, 100., -49., 50),(1, 194, 1, 3, 4,  6, 0, 0, 0, 100., -48., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 195, 1, 3, 3,  7, 0, 0, 0, 300.,  15., 10),(1, 196, 1, 3, 3,  8, 0, 0, 1, 100.,  -7., 10),(1, 197, 1, 3, 3,  8, 0, 0, 2, 100., -12., 10),(1, 198, 1, 3, 3,  8, 0, 0, 3, 100., -26., 10),(1, 199, 1, 3, 3,  6, 0, 0, 1, 100.,  -7., 10),(1, 200, 1, 3, 3,  6, 0, 0, 2, 100., -12., 10),(1, 201, 1, 3, 3,  6, 0, 0, 3, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 202, 1, 3, 6,  7, 0, 0, 0, 300.,   2., 10),(1, 203, 1, 3, 6,  8, 0, 0, 0, 100., -49., 50),(1, 204, 1, 3, 6,  6, 0, 0, 0, 100., -48., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 205, 1, 3, 5,  7, 0, 0, 0, 300.,  15., 10),(1, 206, 1, 3, 5,  8, 0, 0, 1, 100.,  -7., 10),(1, 207, 1, 3, 5,  8, 0, 0, 2, 100., -12., 10),(1, 208, 1, 3, 5,  8, 0, 0, 3, 100., -26., 10),(1, 209, 1, 3, 5,  6, 0, 0, 1, 100.,  -7., 10),(1, 210, 1, 3, 5,  6, 0, 0, 2, 100., -12., 10),(1, 211, 1, 3, 5,  6, 0, 0, 3, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 212, 1, 6, 2,  7, 0, 2, 0, 300.,  28., 10),(1, 213, 1, 6, 2,  7, 0, 1, 0, 300.,  45., 10),(1, 214, 1, 6, 2,  8, 1, 0, 0, 100., -12., 50),(1, 215, 1, 6, 2,  8, 2, 0, 0, 100., -15., 50),(1, 216, 1, 6, 2,  6, 1, 0, 0, 100.,  -6., 50),(1, 217, 1, 6, 2,  6, 2, 0, 0, 100., -15., 50),(1, 218, 1, 6, 2, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 219, 1, 6, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 220, 1, 6, 1,  8, 0, 0, 0, 100., -17., 50),(1, 221, 1, 6, 1,  6, 0, 0, 0, 100., -14., 50),(1, 222, 1, 6, 1, 15, 2, 0, 0,  35., -31., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 223, 1, 6, 4,  7, 0, 2, 0, 300.,  28., 10),(1, 224, 1, 6, 4,  7, 0, 1, 0, 300.,  45., 10),(1, 225, 1, 6, 4,  8, 1, 0, 0, 100., -12., 50),(1, 226, 1, 6, 4,  8, 2, 0, 0, 100., -15., 50),(1, 227, 1, 6, 4,  6, 1, 0, 0, 100.,  -6., 50),(1, 228, 1, 6, 4,  6, 2, 0, 0, 100., -15., 50),(1, 229, 1, 6, 4, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 230, 1, 6, 3,  7, 0, 0, 0, 300.,  34., 10),(1, 231, 1, 6, 3,  8, 0, 0, 1, 100.,  10., 10),(1, 232, 1, 6, 3,  8, 0, 0, 2, 100.,   0., 10),(1, 233, 1, 6, 3,  8, 0, 0, 3, 100., -17., 10),(1, 234, 1, 6, 3,  9, 2, 0, 0,  35., -28., 10),(1, 235, 1, 6, 3, 10, 2, 0, 0,  35., -34., 10),(1, 236, 1, 6, 3, 11, 2, 0, 0,  35., -25., 10),(1, 237, 1, 6, 3, 12, 2, 0, 0,  35., -43., 10),(1, 238, 1, 6, 3, 13, 2, 0, 0,  35., -43., 10),(1, 239, 1, 6, 3,  6, 0, 0, 1, 100.,  10., 10),(1, 240, 1, 6, 3,  6, 0, 0, 2, 100.,   0., 10),(1, 241, 1, 6, 3,  6, 0, 0, 3, 100., -14., 10),(1, 242, 1, 6, 3,  5, 2, 0, 0,  35., -24., 10),(1, 243, 1, 6, 3,  4, 2, 0, 0,  35., -30., 10),(1, 244, 1, 6, 3,  3, 2, 0, 0,  35., -34., 10),(1, 245, 1, 6, 3,  2, 2, 0, 0,  35., -35., 10),(1, 246, 1, 6, 3,  1, 2, 0, 0,  35., -32., 10),(1, 247, 1, 6, 3, 14, 2, 0, 0,  35., -33., 10),(1, 248, 1, 6, 3, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 249, 1, 6, 6,  7, 0, 2, 0, 300.,  28., 10),(1, 250, 1, 6, 6,  7, 0, 1, 0, 300.,  45., 10),(1, 251, 1, 6, 6,  8, 1, 0, 0, 100., -12., 50),(1, 252, 1, 6, 6,  8, 2, 0, 0, 100., -15., 50),(1, 253, 1, 6, 6,  6, 1, 0, 0, 100.,  -6., 50),(1, 254, 1, 6, 6,  6, 2, 0, 0, 100., -15., 50),(1, 255, 1, 6, 6, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 256, 1, 6, 5,  7, 0, 0, 0, 300.,  34., 10),(1, 257, 1, 6, 5,  8, 0, 0, 1, 100.,  10., 10),(1, 258, 1, 6, 5,  8, 0, 0, 2, 100.,   0., 10),(1, 259, 1, 6, 5,  8, 0, 0, 3, 100., -17., 10),(1, 260, 1, 6, 5,  9, 2, 0, 0,  35., -28., 10),(1, 261, 1, 6, 5, 10, 2, 0, 0,  35., -34., 10),(1, 262, 1, 6, 5, 11, 2, 0, 0,  35., -25., 10),(1, 263, 1, 6, 5, 12, 2, 0, 0,  35., -43., 10),(1, 264, 1, 6, 5, 13, 2, 0, 0,  35., -43., 10),(1, 265, 1, 6, 5,  6, 0, 0, 1, 100.,  10., 10),(1, 266, 1, 6, 5,  6, 0, 0, 2, 100.,   0., 10),(1, 267, 1, 6, 5,  6, 0, 0, 3, 100., -14., 10),(1, 268, 1, 6, 5,  5, 2, 0, 0,  35., -24., 10),(1, 269, 1, 6, 5,  4, 2, 0, 0,  35., -30., 10),(1, 270, 1, 6, 5,  3, 2, 0, 0,  35., -34., 10),(1, 271, 1, 6, 5,  2, 2, 0, 0,  35., -35., 10),(1, 272, 1, 6, 5,  1, 2, 0, 0,  35., -32., 10),(1, 273, 1, 6, 5, 14, 2, 0, 0,  35., -33., 10),(1, 274, 1, 6, 5, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 275, 1, 5, 2,  7, 0, 0, 0, 300.,   2., 10),(1, 276, 1, 5, 2,  8, 0, 0, 0, 100., -49., 10),(1, 277, 1, 5, 2,  6, 0, 0, 0, 100., -48., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 278, 1, 5, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 279, 1, 5, 1,  8, 0, 0, 0, 100., -26., 10),(1, 280, 1, 5, 1,  6, 0, 0, 0, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 281, 1, 5, 4,  7, 0, 0, 0, 300.,   2., 10),(1, 282, 1, 5, 4,  8, 0, 0, 0, 100., -49., 50),(1, 283, 1, 5, 4,  6, 0, 0, 0, 100., -48., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 284, 1, 5, 3,  7, 0, 0, 0, 300.,  15., 10),(1, 285, 1, 5, 3,  8, 0, 0, 1, 100.,  -7., 10),(1, 286, 1, 5, 3,  8, 0, 0, 2, 100., -12., 10),(1, 287, 1, 5, 3,  8, 0, 0, 3, 100., -26., 10),(1, 288, 1, 5, 3,  6, 0, 0, 1, 100.,  -7., 10),(1, 289, 1, 5, 3,  6, 0, 0, 2, 100., -12., 10),(1, 290, 1, 5, 3,  6, 0, 0, 3, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 291, 1, 5, 6,  7, 0, 0, 0, 300.,   2., 10),(1, 292, 1, 5, 6,  8, 0, 0, 0, 100., -49., 50),(1, 293, 1, 5, 6,  6, 0, 0, 0, 100., -48., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 294, 1, 5, 5,  7, 0, 0, 0, 300.,  15., 10),(1, 295, 1, 5, 5,  8, 0, 0, 1, 100.,  -7., 10),(1, 296, 1, 5, 5,  8, 0, 0, 2, 100., -12., 10),(1, 297, 1, 5, 5,  8, 0, 0, 3, 100., -26., 10),(1, 298, 1, 5, 5,  6, 0, 0, 1, 100.,  -7., 10),(1, 299, 1, 5, 5,  6, 0, 0, 2, 100., -12., 10),(1, 300, 1, 5, 5,  6, 0, 0, 3, 100., -26., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 301, 2, 2, 2,  7, 0, 2, 0, 300.,  28., 10),(1, 302, 2, 2, 2,  7, 0, 1, 0, 300.,  45., 10),(1, 303, 2, 2, 2,  8, 0, 0, 0, 100., -13., 10),(1, 304, 2, 2, 2,  9, 2, 0, 0,  35., -29., 10),(1, 305, 2, 2, 2, 10, 2, 0, 0,  35., -34., 10),(1, 306, 2, 2, 2, 11, 2, 0, 0,  35., -23., 10),(1, 307, 2, 2, 2, 12, 2, 0, 0, 100., -33., 10),(1, 308, 2, 2, 2, 13, 2, 0, 0,  35., -41., 10),(1, 309, 2, 2, 2,  6, 0, 0, 0, 100.,  -3., 10),(1, 310, 2, 2, 2,  5, 2, 0, 0,  35., -26., 10),(1, 311, 2, 2, 2,  4, 2, 0, 0,  35., -33., 10),(1, 312, 2, 2, 2,  2, 2, 0, 0, 100., -30., 10),(1, 313, 2, 2, 2,  1, 2, 0, 0,  35., -32., 10),(1, 314, 2, 2, 2, 14, 2, 0, 0, 100., -25., 10),(1, 315, 2, 2, 2, 15, 2, 0, 0, 125.,  -9., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 316, 2, 2, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 317, 2, 2, 1,  8, 0, 0, 0, 100., -17., 10),(1, 318, 2, 2, 1,  9, 2, 0, 0,  35., -28., 10),(1, 319, 2, 2, 1, 10, 2, 0, 0,  35., -34., 10),(1, 320, 2, 2, 1, 11, 2, 0, 0,  35., -25., 10),(1, 321, 2, 2, 1, 12, 2, 0, 0,  35., -43., 10),(1, 322, 2, 2, 1, 13, 2, 0, 0,  35., -43., 10),(1, 323, 2, 2, 1,  6, 0, 0, 0, 100., -14., 10),(1, 324, 2, 2, 1,  5, 2, 0, 0,  35., -24., 10),(1, 325, 2, 2, 1,  4, 2, 0, 0,  35., -30., 10),(1, 326, 2, 2, 1,  3, 2, 0, 0,  35., -34., 10),(1, 327, 2, 2, 1,  2, 2, 0, 0,  35., -35., 10),(1, 328, 2, 2, 1,  1, 2, 0, 0,  35., -32., 10),(1, 329, 2, 2, 1, 14, 2, 0, 0,  35., -33., 10),(1, 330, 2, 2, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 331, 2, 1, 2,  7, 0, 0, 0, 300.,   2., 10),(1, 332, 2, 1, 2,  8, 0, 0, 0, 100., -49., 10),(1, 333, 2, 1, 2,  6, 0, 0, 0, 100., -48., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 334, 2, 1, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 335, 2, 1, 1,  8, 0, 0, 0, 100., -26., 10),(1, 336, 2, 1, 1,  6, 0, 0, 0, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 337, 3, 2, 2,  7, 0, 2, 0, 300.,  28., 10),(1, 338, 3, 2, 2,  7, 0, 1, 0, 300.,  45., 10),(1, 339, 3, 2, 2,  8, 0, 0, 0, 100., -13., 10),(1, 340, 3, 2, 2,  9, 2, 0, 0,  35., -29., 10),(1, 341, 3, 2, 2, 10, 2, 0, 0,  35., -34., 10),(1, 342, 3, 2, 2, 11, 2, 0, 0,  35., -23., 10),(1, 343, 3, 2, 2, 12, 2, 0, 0, 100., -33., 10),(1, 344, 3, 2, 2, 13, 2, 0, 0,  35., -41., 10),(1, 345, 3, 2, 2,  6, 0, 0, 0, 100.,  -3., 10),(1, 346, 3, 2, 2,  5, 2, 0, 0,  35., -26., 10),(1, 347, 3, 2, 2,  4, 2, 0, 0,  35., -33., 10),(1, 348, 3, 2, 2,  2, 2, 0, 0, 100., -30., 10),(1, 349, 3, 2, 2,  1, 2, 0, 0,  35., -32., 10),(1, 350, 3, 2, 2, 14, 2, 0, 0, 100., -25., 10),(1, 351, 3, 2, 2, 15, 2, 0, 0, 125.,  -9., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 352, 3, 2, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 353, 3, 2, 1,  8, 0, 0, 0, 100., -17., 10),(1, 354, 3, 2, 1,  9, 2, 0, 0,  35., -28., 10),(1, 355, 3, 2, 1, 10, 2, 0, 0,  35., -34., 10),(1, 356, 3, 2, 1, 11, 2, 0, 0,  35., -25., 10),(1, 357, 3, 2, 1, 12, 2, 0, 0,  35., -43., 10),(1, 358, 3, 2, 1, 13, 2, 0, 0,  35., -43., 10),(1, 359, 3, 2, 1,  6, 0, 0, 0, 100., -14., 10),(1, 360, 3, 2, 1,  5, 2, 0, 0,  35., -24., 10),(1, 361, 3, 2, 1,  4, 2, 0, 0,  35., -30., 10),(1, 362, 3, 2, 1,  3, 2, 0, 0,  35., -34., 10),(1, 363, 3, 2, 1,  2, 2, 0, 0,  35., -35., 10),(1, 364, 3, 2, 1,  1, 2, 0, 0,  35., -32., 10),(1, 365, 3, 2, 1, 14, 2, 0, 0,  35., -33., 10),(1, 366, 3, 2, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 367, 3, 1, 2,  7, 0, 0, 0, 300.,   2., 10),(1, 368, 3, 1, 2,  8, 0, 0, 0, 100., -49., 10),(1, 369, 3, 1, 2,  6, 0, 0, 0, 100., -48., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 370, 3, 1, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 371, 3, 1, 1,  8, 0, 0, 0, 100., -26., 10),(1, 372, 3, 1, 1,  6, 0, 0, 0, 100., -28., 10)");
        dbConnection.update("CREATE TABLE parameter_group (group_key INT NOT NULL PRIMARY KEY,list_order INT NOT NULL,name VARCHAR(255) NOT NULL,enabling_parameter_key INT NOT NULL)");
        dbConnection.update("INSERT INTO parameter_group VALUES (1, 10, 'General', 0),(2, 20, 'CDBS', 0),(3, 30, 'Patterns', 0),(4, 40, 'Contours', 0),(5, 50, 'Replication', 0),(6, 60, 'Pathloss', 0),(7, 70, 'Service', 309),(8, 80, 'Clutter', 249)");
        dbConnection.update("CREATE TABLE parameter (parameter_key INT NOT NULL PRIMARY KEY,group_key INT NOT NULL,list_order INT NOT NULL,name VARCHAR(255) NOT NULL,type VARCHAR(255) NOT NULL,description TEXT NOT NULL,study_fixed BOOLEAN NOT NULL)");
        dbConnection.update("INSERT INTO parameter VALUES (2, 1, 20, 'Grid type', 'pickfrom:1:Local:2:Global', '<HTML>Type of study cell grid:<BR>Local - Each station has an independent grid used only for that station.<BR>Global - A single uniform grid is shared by all stations.</HTML>', false),(4, 1, 40, 'Cell size', 'decimal:0.1:10', '<HTML>Target size of study grid cells in kilometers.<BR>Actual size will vary, cell dimensions are always integral arc-seconds.</HTML>', false),(20, 1, 200, 'Average terrain database', 'pickfrom:1:1-second:2:3-second:3:30-second', '<HTML>Terrain database for average terrain calculations.</HTML>', false),(22, 1, 220, 'Average terrain profile resolution', 'decimal:0.1:50', '<HTML>Profile resolution in points/kilometer for average terrain calculations.</HTML>', false),(30, 1, 300, 'Path-loss terrain database', 'pickfrom:1:1-second:2:3-second:3:30-second', '<HTML>Terrain database for path-loss calculations.</HTML>', false),(32, 1, 320, 'Path-loss profile resolution', 'decimal:0.1:50', '<HTML>Profile resolution in points/kilometer for path-loss calculations.</HTML>', false),(40, 1, 400, 'U.S. population', 'pickfrom:2010:2010:2000:2000:0:None', '<HTML>U.S. Census population database.<BR>If \"None\" is selected, area will also not be reported separately.</HTML>', false),(42, 1, 420, 'Canadian population', 'pickfrom:2011:2011:2006:2006:0:None', '<HTML>Canadian Census population database.<BR>If \"None\" is selected, area will also not be reported separately.</HTML>', false),(44, 1, 440, 'Mexican population', 'pickfrom:2010:2010:0:None', '<HTML>Mexican Census population database.<BR>If \"None\" is selected, area will also not be reported separately.</HTML>', false),(46, 1, 460, 'Round population coordinates', 'option', '<HTML>Round all Census centroid coordinates to the nearest integer arc-second.</HTML>', false),(326, 1, 600, 'Check individual DTS transmitter distances', 'option', '<HTML>For distance checks involving a DTS station, use the coordinates of the nearest individal DTS transmitter.<BR>When not selected, distance checks always use the DTS reference point coordinates.</HTML>', true),(200, 1, 2000, 'Spherical earth distance', 'decimal:110:112', '<HTML>Spherical earth surface distance in kilometers per degree of arc length.</HTML>', true),(210, 1, 2100, 'Rule limit extra distance', 'decimal:50:200', '<HTML>Extra distance added to interference rule limits when performing initial station-to-station distance checks.<BR>Undesired stations beyond the distance are not checked for station-to-cell distance.</HTML>', true),(212, 1, 2120, 'Co-channel MX distance', 'decimal:0:100', '<HTML>Distance within which co-channel stations are considered mutually-exclusive regardless of other conditions.<BR>Set this to 0 to disable the co-channel distance check.</HTML>', true),(324, 1, 2200, 'First TV channel', 'integer:2:69', '<HTML>Lowest allowed TV channel number, database records below this are ignored.</HTML>', true),(325, 1, 2201, 'Last TV channel', 'integer:2:69', '<HTML>Highest allowed TV channel number, database records above this are ignored.</HTML>', true)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 2, '2'),(1, 4, '2'),(1, 20, '1'),(1, 22, '10'),(1, 30, '1'),(1, 32, '1'),(1, 40, '2010'),(1, 42, '2011'),(1, 44, '2010'),(1, 46, '0'),(1, 326, '0'),(1, 200, '111.15'),(1, 210, '162'),(1, 212, '30'),(1, 324, '2'),(1, 325, '51')");
        dbConnection.update("INSERT INTO parameter VALUES (18, 2, 180, 'Respect CDBS DA flag', 'option', '<HTML>Use directional pattern data only if the DA indicator flag is set.<BR>If not selected, pattern data is used if present regardless of the flag.</HTML>', true),(219, 2, 2190, 'Use generic patterns for Canadian records', 'option', '<HTML>Use OET-69 generic elevation patterns for Canadian records without actual pattern data.<BR>If not selected, Canadian records without a pattern are studied with no elevation pattern (omni in the elevation plane).</HTML>', true),(220, 2, 2200, 'Mexican digital ERP, VHF low', 'decimal:1:2000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for digital VHF low band.</HTML>', true),(221, 2, 2210, 'Mexican digital HAAT, VHF low', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for digital VHF low band.</HTML>', true),(222, 2, 2220, 'Mexican digital ERP, VHF high', 'decimal:1:2000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for digital VHF high band.</HTML>', true),(223, 2, 2230, 'Mexican digital HAAT, VHF high', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for digital VHF high band.</HTML>', true),(224, 2, 2240, 'Mexican digital ERP, UHF', 'decimal:1:2000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for digital UHF.</HTML>', true),(225, 2, 2250, 'Mexican digital HAAT, UHF', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for digital UHF.</HTML>', true),(226, 2, 2260, 'Mexican analog ERP, VHF low', 'decimal:1:6000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for analog VHF low band.</HTML>', true),(227, 2, 2270, 'Mexican analog HAAT, VHF low', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for analog VHF low band.</HTML>', true),(228, 2, 2280, 'Mexican analog ERP, VHF high', 'decimal:1:6000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for analog VHF high band.</HTML>', true),(229, 2, 2290, 'Mexican analog HAAT, VHF high', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for analog VHF high band.</HTML>', true),(230, 2, 2300, 'Mexican analog ERP, UHF', 'decimal:1:6000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for analog UHF.</HTML>', true),(231, 2, 2310, 'Mexican analog HAAT, UHF', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for analog UHF.</HTML>', true)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 18, '0'),(1, 219, '1'),(1, 220, '45'),(1, 221, '305'),(1, 222, '160'),(1, 223, '305'),(1, 224, '1000'),(1, 225, '365'),(1, 226, '100'),(1, 227, '305'),(1, 228, '316'),(1, 229, '305'),(1, 230, '5000'),(1, 231, '610')");
        dbConnection.update("INSERT INTO parameter VALUES (12, 3, 120, 'Depression angle method', 'pickfrom:1:Effective height:2:True geometry', '<HTML>Method of computing depression angle for elevation pattern lookup:<BR>Effective height - Use transmitter HAAT or height AGL with distance-squared approximation formula.<BR>True geometry - Compute exact angle from transmitter to receiver over curved earth.</HTML>', false),(14, 3, 140, 'Use mechanical beam tilt', 'pickfrom:0:Never:1:Always:2:Real patterns only', '<HTML>When to apply mechanical beam tilt to elevation patterns.<BR>Electrical beam tilt is always applied to real patterns.</HTML>', false),(15, 3, 150, 'Mirror generic patterns', 'option', '<HTML>Mirror generic patterns around the depression angle of the maximum.<BR>If not selected, pattern is 1.0 at angles above the maximum.<BR>Non-generic patterns are always mirrored if needed.</HTML>', false),(16, 3, 160, 'Beam tilt on generic patterns', 'pickfrom:0:None:1:Full:2:Offset', '<HTML>Amount of specified beam tilt applied to generic elevation patterns:<BR>None - Generic patterns have only inherent 0.75 degrees electrical tilt.<BR>Full - Apply the full amount of specified electrical tilt, and mechanical tilt if enabled.<BR>Offset - Apply specified electrical tilt with an offset of 0.75 degrees, and full mechanical tilt if enabled.</HTML>', false),(19, 3, 190, 'Invert negative tilts', 'option', '<HTML>Change all negative values for electrical and mechanical beam tilt to positive (use absolute value).</HTML>', false),(140, 3, 1400, 'Digital receive antenna f/b, VHF low', 'decimal:0:20', '<HTML>Receive antenna front-to-back ratio in dB, digital VHF low band.</HTML>', false),(142, 3, 1420, 'Digital receive antenna f/b, VHF high', 'decimal:0:20', '<HTML>Receive antenna front-to-back ratio in dB, digital VHF high band.</HTML>', false),(144, 3, 1440, 'Digital receive antenna f/b, UHF', 'decimal:0:20', '<HTML>Receive antenna front-to-back ratio in dB, digital UHF.</HTML>', false),(146, 3, 1460, 'Analog receive antenna f/b, VHF low', 'decimal:0:20', '<HTML>Receive antenna front-to-back ratio in dB, analog VHF low band.</HTML>', false),(148, 3, 1480, 'Analog receive antenna f/b, VHF high', 'decimal:0:20', '<HTML>Receive antenna front-to-back ratio in dB, analog VHF high band.</HTML>', false),(150, 3, 1500, 'Analog receive antenna f/b, UHF', 'decimal:0:20', '<HTML>Receive antenna front-to-back ratio in dB, analog UHF.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 12, '2'),(1, 14, '0'),(1, 15, '0'),(1, 16, '2'),(1, 19, '1'),(1, 140, '10'),(1, 142, '12'),(1, 144, '14'),(1, 146, '6'),(1, 148, '6'),(1, 150, '6')");
        dbConnection.update("INSERT INTO parameter VALUES (17, 4, 170, 'Use real elevation patterns for contours', 'option', '<HTML>Use real elevation patterns when available for projecting service contours.<BR>If not selected, contour projection will use generic patterns, or no elevation pattern, per other settings.<HTML>', false),(80, 4, 800, 'Digital full-service contour, VHF low', 'decimal:0:120', '<HTML>Service contour level in dBu, digital full-service VHF low band.</HTML>', false),(82, 4, 820, 'Digital full-service contour, VHF high', 'decimal:0:120', '<HTML>Service contour level in dBu, digital full-service VHF high band.</HTML>', false),(84, 4, 840, 'Digital full-service contour, UHF', 'decimal:0:120', '<HTML>Service contour level in dBu, digital full-service UHF (may be dipole-adjusted).</HTML>', false),(86, 4, 860, 'Digital Class A/LPTV contour, VHF low', 'decimal:0:120', '<HTML>Service contour level in dBu, digital LPTV/Class A VHF low band.</HTML>', false),(88, 4, 880, 'Digital Class A/LPTV contour, VHF high', 'decimal:0:120', '<HTML>Service contour level in dBu, digital LPTV/Class A VHF high band.</HTML>', false),(90, 4, 900, 'Digital Class A/LPTV contour, UHF', 'decimal:0:120', '<HTML>Service contour level in dBu, digital LPTV/Class A UHF (may be dipole-adjusted).</HTML>', false),(92, 4, 920, 'Analog full-service contour, VHF low', 'decimal:0:120', '<HTML>Service contour level in dBu, analog full-service VHF low band.</HTML>', false),(94, 4, 940, 'Analog full-service contour, VHF high', 'decimal:0:120', '<HTML>Service contour level in dBu, analog full-service VHF high band.</HTML>', false),(96, 4, 960, 'Analog full-service contour, UHF', 'decimal:0:120', '<HTML>Service contour level in dBu, analog full-service UHF (may be dipole-adjusted).</HTML>', false),(98, 4, 980, 'Analog Class A/LPTV contour, VHF low', 'decimal:0:120', '<HTML>Service contour level in dBu, analog LPTV/Class A VHF low band.</HTML>', false),(100, 4, 1000, 'Analog Class A/LPTV contour, VHF high', 'decimal:0:120', '<HTML>Service contour level in dBu, analog LPTV/Class A VHF high band.</HTML>', false),(102, 4, 1020, 'Analog Class A/LPTV contour, UHF', 'decimal:0:120', '<HTML>Service contour level in dBu, analog LPTV/Class A UHF (may be dipole-adjusted).</HTML>', false),(104, 4, 1040, 'Use UHF dipole adjustment', 'option', '<HTML>Apply dipole adjustment to UHF service contour levels.</HTML>', false),(106, 4, 1060, 'Dipole center frequency', 'decimal:470:700', '<HTML>Center frequency in MHz for dipole adjustment of UHF service contour levels.</HTML>', false),(107, 4, 1070, 'Propagation curve set, digital', 'pickfrom:1:F(50,50):2:F(50,10):3:F(50,90)', '<HTML>FCC propagation curve set for digital service contour projection.</HTML>', false),(108, 4, 1080, 'Propagation curve set, analog', 'pickfrom:1:F(50,50):2:F(50,10):3:F(50,90)', '<HTML>FCC propagation curve set for analog service contour projection.</HTML>', false),(110, 4, 1100, 'Truncate DTS service area', 'option', '<HTML>Truncate DTS service by the combined area of the pre-DTS service contour and a distance limit around the DTS reference point.</HTML>', false),(111, 4, 1110, 'DTS distance limit, VHF low Zone I', 'decimal:50:200', '<HTML>DTS distance limit, VHF low band in Zone I.</HTML>', false),(112, 4, 1120, 'DTS distance limit, VHF low Zone II/III', 'decimal:50:200', '<HTML>DTS distance limit, VHF low band in Zones II and III.</HTML>', false),(113, 4, 1130, 'DTS distance limit, VHF high Zone I', 'decimal:50:200', '<HTML>DTS distance limit, VHF high band in Zone I.</HTML>', false),(114, 4, 1140, 'DTS distance limit, VHF high Zone II/III', 'decimal:50:200', '<HTML>DTS distance limit, VHF high band in Zones II and III.</HTML>', false),(115, 4, 1150, 'DTS distance limit, UHF', 'decimal:50:200', '<HTML>DTS distance limit, UHF.</HTML>', false),(120, 4, 1200, 'HAAT radial count', 'integer:4:360', '<HTML>Number of radials for HAAT calculation during contour projection.<BR>If different than the number of contour projection radials, HAAT values are interpolated.</HTML>', false),(121, 4, 1210, 'Minimum HAAT', 'decimal:30.5:50', '<HTML>Minimum value for HAAT on any radial.</HTML>', false),(122, 4, 1220, 'Contour radial count', 'integer:4:360', '<HTML>Number of radials to use for contour projections.</HTML>', false),(124, 4, 1240, 'Service distance limit, VHF low', 'decimal:0:200', '<HTML>Maximum distance to any service cell in kilometers, VHF low band.  Use 0 for no limit.</HTML>', false),(126, 4, 1260, 'Service distance limit, VHF high', 'decimal:0:200', '<HTML>Maximum distance to any service cell in kilometers, VHF high band.  Use 0 for no limit.</HTML>', false),(128, 4, 1280, 'Service distance limit, UHF', 'decimal:0:200', '<HTML>Maximum distance to any service cell in kilometers, UHF.  Use 0 for no limit.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 17, '0'),(1, 80, '28'),(1, 82, '36'),(1, 84, '41'),(1, 86, '43'),(1, 88, '48'),(1, 90, '51'),(1, 92, '47'),(1, 94, '56'),(1, 96, '64'),(1, 98, '62'),(1, 100, '68'),(1, 102, '74'),(1, 104, '1'),(1, 106, '615'),(1, 107, '3'),(1, 108, '1'),(1, 110, '1'),(1, 111, '108'),(1, 112, '128'),(1, 113, '101'),(1, 114, '123'),(1, 115, '103'),(1, 120, '8'),(1, 121, '30.5'),(1, 122, '360'),(1, 124, '0'),(1, 126, '0'),(1, 128, '0')");
        dbConnection.update("INSERT INTO parameter VALUES (50, 5, 500, 'Replication method', 'pickfrom:1:Derive pattern:2:Equal area', '<HTML>Method for performing service area replication on an alternate channel:<BR>Derive pattern - Reverse-project contour points to derive a new azimuth pattern and peak ERP.<BR>Equal area - Adjust peak ERP to match contour area using the original azimuth pattern.</HTML>', false),(52, 5, 520, 'Digital full-service minimum ERP, VHF low', 'decimal:0:200', '<HTML>Minimum ERP in kW for digital full-service, VHF low band (applied after contour replication).</HTML>', false),(54, 5, 540, 'Digital full-service minimum ERP, VHF high', 'decimal:0:200', '<HTML>Minimum ERP in kW for digital full-service, VHF high band (applied after contour replication).</HTML>', false),(56, 5, 560, 'Digital full-service minimum ERP, UHF', 'decimal:0:200', '<HTML>Minimum ERP in kW for digital full-service, UHF (applied after contour replication).</HTML>', false),(58, 5, 580, 'Digital full-service maximum ERP, VHF low Zone I', 'decimal:0.001:2000', '<HTML>Maximum ERP in kW for digital full-service, VHF low band in Zone I (applied after contour replication).</HTML>', false),(60, 5, 600, 'Digital full-service maximum ERP, VHF low Zone II/III', 'decimal:0.001:2000', '<HTML>Maximum ERP in kW for digital full-service station, VHF low band in Zones II and III (applied after contour replication).</HTML>', false),(62, 5, 620, 'Digital full-service maximum ERP, VHF high Zone I', 'decimal:0.001:2000', '<HTML>Maximum ERP in kW for digital full-service station, VHF high band in Zone I (applied after contour replication).</HTML>', false),(64, 5, 640, 'Digital full-service maximum ERP, VHF high Zone II/III', 'decimal:0.001:2000', '<HTML>Maximum ERP in kW for digital full-service station, VHF high band in Zones II and III (applied after contour replication).</HTML>', false),(66, 5, 660, 'Digital full-service maximum ERP, UHF', 'decimal:0.001:2000', '<HTML>Maximum ERP in kW for digital full-service, UHF (applied after contour replication).</HTML>', false),(327, 5, 670, 'Digital Class A/LPTV minimum ERP, VHF', 'decimal:0.001:2000', '<HTML>Minimum ERP in kW for digital Class A/LPTV, VHF (applied after contour replication).</HTML>', false),(328, 5, 671, 'Digital Class A/LPTV minimum ERP, UHF', 'decimal:0.001:2000', '<HTML>Minimum ERP in kW for digital Class A/LPTV, UHF (applied after contour replication).</HTML>', false),(68, 5, 680, 'Digital Class A/LPTV maximum ERP, VHF', 'decimal:0.001:2000', '<HTML>Maximum ERP in kW for digital Class A/LPTV, VHF (applied after contour replication).</HTML>', false),(70, 5, 700, 'Digital Class A/LPTV maximum ERP, UHF', 'decimal:0.001:2000', '<HTML>Maximum ERP in kW for digital Class A/LPTV, UHF (applied after contour replication).</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 50, '2'),(1, 52, '1'),(1, 54, '3.2'),(1, 56, '50'),(1, 58, '10'),(1, 60, '45'),(1, 62, '30'),(1, 64, '160'),(1, 66, '1000'),(1, 327, '0.07'),(1, 328, '0.75'),(1, 68, '3'),(1, 70, '15')");
        dbConnection.update("INSERT INTO parameter VALUES (10, 6, 100, 'Longley-Rice error handling', 'pickfrom:1:Disregard:2:Assume service:3:Assume interference', '<HTML>Behavior when an error marker is returned from the Longely-Rice model:<BR>Disregard - Use returned path-loss regardless of error marker.<BR>Assume service - Error on desired is interference-free service, error on undesired is no interference.<BR>Assume interference - Error on desired is no service, error on undesired is interference.</HTML>', false),(130, 6, 1300, 'Receiver height AGL', 'decimal:0.5:50', '<HTML>Receiver antenna height above ground in meters.</HTML>', false),(132, 6, 1320, 'Minimum transmitter height AGL', 'decimal:0.5:50', '<HTML>Minimum transmitter height above ground in meters.<BR>Transmitter height AMSL is increased as needed to meet this minimum.</HTML>', false),(160, 6, 1600, 'Digital desired % location', 'integer:1:99', '<HTML>Path-loss model statistical parameter, % location for digital desired signals.</HTML>', false),(162, 6, 1620, 'Digital desired % time', 'integer:1:99', '<HTML>Path-loss model statistical parameter, % time for digital desired signals.</HTML>', false),(164, 6, 1640, 'Digital desired % confidence', 'integer:1:99', '<HTML>Path-loss model statistical parameter, % confidence for digital desired signals.</HTML>', false),(166, 6, 1660, 'Digital undesired % location', 'integer:1:99', '<HTML>Path-loss model statistical parameter, % location for digital undesired signals.<BR>(Undesired signal % time is defined by the applicable interference rule.)</HTML>', false),(168, 6, 1680, 'Digital undesired % confidence', 'integer:1:99', '<HTML>Path-loss model statistical parameter, % confidence for digital undesired signals.</HTML>', false),(170, 6, 1700, 'Analog desired % location', 'integer:1:99', '<HTML>Path-loss model statistical parameter, % location for analog desired signals.</HTML>', false),(172, 6, 1720, 'Analog desired % time', 'integer:1:99', '<HTML>Path-loss model statistical parameter, % time for analog desired signals.</HTML>', false),(174, 6, 1740, 'Analog desired % confidence', 'integer:1:99', '<HTML>Path-loss model statistical parameter, % confidence for analog desired signals.</HTML>', false),(176, 6, 1760, 'Analog undesired % location', 'integer:1:99', '<HTML>Path-loss model statistical parameter, % location for analog undesired signals.<BR>(Undesired signal % time is defined by the applicable interference rule.)</HTML>', false),(178, 6, 1780, 'Analog undesired % confidence', 'integer:1:99', '<HTML>Path-loss model statistical parameter, % confidence for analog undesired signals.</HTML>', false),(180, 6, 1800, 'Signal polarization', 'pickfrom:0:Horizontal:1:Vertical', '<HTML>Path-loss model signal polarization.</HTML>', false),(182, 6, 1820, 'Atmospheric refractivity', 'decimal:200:450', '<HTML>Path-loss model atmospheric refractivity referenced to mean sea level in N-units.</HTML>', false),(184, 6, 1840, 'Ground permittivity', 'decimal:1:5000', '<HTML>Path-loss model ground permittivity constant.', false),(186, 6, 1860, 'Ground conductivity', 'decimal:0.0001:1', '<HTML>Path-loss model ground conductivity in Siemens/meter.</HTML>', false),(190, 6, 1900, 'Longley-Rice service mode', 'pickfrom:0:Single-message:1:Individual:2:Mobile:3:Broadcast', '<HTML>Longley-Rice service mode.</HTML>', false),(192, 6, 1920, 'Longley-Rice climate type', 'pickfrom:1:Equatorial:2:Continental subtropical:3:Maritime subtropical:4:Desert:5:Continental temperate:6:Maritime temperate over land:7:Maritime temperate over sea', '<HTML>Longley-Rice climate type.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 10, '2'),(1, 130, '10'),(1, 132, '10'),(1, 160, '50'),(1, 162, '90'),(1, 164, '50'),(1, 166, '50'),(1, 168, '50'),(1, 170, '50'),(1, 172, '50'),(1, 174, '50'),(1, 176, '50'),(1, 178, '50'),(1, 180, '0'),(1, 182, '301'),(1, 184, '15'),(1, 186, '0.005'),(1, 190, '3'),(1, 192, '5')");
        dbConnection.update("INSERT INTO parameter VALUES (309, 7, 799, 'Set service thresholds', 'option', '<HTML>Independently set the terrain-sensitive service thresholds.<BR>If not selected, thresholds are the same as contour levels.</HTML>', false),(310, 7, 800, 'Digital full-service threshold, VHF low', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital full-service VHF low band.</HTML>', false),(311, 7, 820, 'Digital full-service threshold, VHF high', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital full-service VHF high band.</HTML>', false),(312, 7, 840, 'Digital full-service threshold, UHF', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital full-service UHF (may be dipole-adjusted).</HTML>', false),(313, 7, 860, 'Digital Class A/LPTV threshold, VHF low', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital LPTV/Class A VHF low band.</HTML>', false),(314, 7, 880, 'Digital Class A/LPTV threshold, VHF high', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital LPTV/Class A VHF high band.</HTML>', false),(315, 7, 900, 'Digital Class A/LPTV threshold, UHF', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital LPTV/Class A UHF (may be dipole-adjusted).</HTML>', false),(316, 7, 920, 'Analog full-service threshold, VHF low', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog full-service VHF low band.</HTML>', false),(317, 7, 940, 'Analog full-service threshold, VHF high', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog full-service VHF high band.</HTML>', false),(318, 7, 960, 'Analog full-service threshold, UHF', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog full-service UHF (may be dipole-adjusted).</HTML>', false),(319, 7, 980, 'Analog Class A/LPTV threshold, VHF low', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog LPTV/Class A VHF low band.</HTML>', false),(320, 7, 1000, 'Analog Class A/LPTV threshold, VHF high', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog LPTV/Class A VHF high band.</HTML>', false),(321, 7, 1020, 'Analog Class A/LPTV threshold, UHF', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog LPTV/Class A UHF (may be dipole-adjusted).</HTML>', false),(322, 7, 1040, 'Use UHF dipole adjustment', 'option', '<HTML>Apply dipole adjustment to UHF terrain-sensitive service threshold levels.</HTML>', false),(323, 7, 1060, 'Dipole center frequency', 'decimal:470:700', '<HTML>Center frequency in MHz for dipole adjustment of UHF terrain-sensitive service threshold levels.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 309, '0'),(1, 310, '28'),(1, 311, '36'),(1, 312, '41'),(1, 313, '43'),(1, 314, '48'),(1, 315, '51'),(1, 316, '47'),(1, 317, '56'),(1, 318, '64'),(1, 319, '62'),(1, 320, '68'),(1, 321, '74'),(1, 322, '1'),(1, 323, '615')");
        dbConnection.update("INSERT INTO parameter VALUES (249, 8, 2490, 'Apply clutter adjustments', 'option', '<HTML>Adjust field-strength values for receiver clutter type and channel band, based on land-cover category at study point.</HTML>', false),(250, 8, 2500, 'Open land, low VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(251, 8, 2510, 'Open land, high VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(252, 8, 2520, 'Open land, low UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(253, 8, 2530, 'Open land, high UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(254, 8, 2540, 'Agricultural, low VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(255, 8, 2550, 'Agricultural, high VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(256, 8, 2560, 'Agricultural, low UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(257, 8, 2570, 'Agricultural, high UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(258, 8, 2580, 'Rangeland, low VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(259, 8, 2590, 'Rangeland, high VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(260, 8, 2600, 'Rangeland, low UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(261, 8, 2610, 'Rangeland, high UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(262, 8, 2620, 'Water, low VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(263, 8, 2630, 'Water, high VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(264, 8, 2640, 'Water, low UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(265, 8, 2650, 'Water, high UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(266, 8, 2660, 'Forest land, low VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(267, 8, 2670, 'Forest land, high VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(268, 8, 2680, 'Forest land, low UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(269, 8, 2690, 'Forest land, high UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(270, 8, 2700, 'Wetland, low VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(271, 8, 2710, 'Wetland, high VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(272, 8, 2720, 'Wetland, low UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(273, 8, 2730, 'Wetland, high UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(274, 8, 2740, 'Residential, low VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(275, 8, 2750, 'Residential, high VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(276, 8, 2760, 'Residential, low UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(277, 8, 2770, 'Residential, high UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(278, 8, 2780, 'Mixed Urban / Buildings, low VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(279, 8, 2790, 'Mixed Urban / Buildings, high VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(280, 8, 2800, 'Mixed Urban / Buildings, low UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(281, 8, 2810, 'Mixed Urban / Buildings, high UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(282, 8, 2820, 'Commercial / Industrial, low VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(283, 8, 2830, 'Commercial / Industrial, high VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(284, 8, 2840, 'Commercial / Industrial, low UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(285, 8, 2850, 'Commercial / Industrial, high UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(286, 8, 2860, 'Snow and Ice, low VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(287, 8, 2870, 'Snow and Ice, high VHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(288, 8, 2880, 'Snow and Ice, low UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(289, 8, 2890, 'Snow and Ice, high UHF', 'decimal:-30:30', '<HTML>Clutter adjustment in dB for clutter type and channel band.<HTML>', false),(290, 8, 2900, 'Open water', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(291, 8, 2910, 'Perennial ice/snow', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(292, 8, 2920, 'Developed, open space', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(293, 8, 2930, 'Developed, low intensity', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(294, 8, 2940, 'Developed, medium intensity', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(295, 8, 2950, 'Developed, high intensity', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(296, 8, 2960, 'Barren land (rock/sand/clay)', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(297, 8, 2970, 'Deciduous forest', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(298, 8, 2980, 'Evergreen forest', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(299, 8, 2990, 'Mixed forest', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(300, 8, 3000, 'Shrub/scrub', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(301, 8, 3010, 'Grassland/herbaceous', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(302, 8, 3020, 'Pasture/hay', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(303, 8, 3030, 'Cultivated crops', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(304, 8, 3040, 'Woody wetlands', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false),(305, 8, 3050, 'Emergent herbaceous wetlands', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '<HTML>Clutter type for land-cover category.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 249, '0'),(1, 250, '0'),(1, 251, '0'),(1, 252, '-4'),(1, 253, '-5'),(1, 254, '0'),(1, 255, '0'),(1, 256, '-5'),(1, 257, '-6'),(1, 258, '0'),(1, 259, '0'),(1, 260, '-3'),(1, 261, '-6'),(1, 262, '0'),(1, 263, '0'),(1, 264, '0'),(1, 265, '0'),(1, 266, '0'),(1, 267, '0'),(1, 268, '-5'),(1, 269, '-8'),(1, 270, '0'),(1, 271, '0'),(1, 272, '0'),(1, 273, '0'),(1, 274, '0'),(1, 275, '0'),(1, 276, '-5'),(1, 277, '-7'),(1, 278, '0'),(1, 279, '0'),(1, 280, '-6'),(1, 281, '-6'),(1, 282, '0'),(1, 283, '0'),(1, 284, '-5'),(1, 285, '-6'),(1, 286, '0'),(1, 287, '0'),(1, 288, '0'),(1, 289, '0'),(1, 290, '4'),(1, 291, '10'),(1, 292, '1'),(1, 293, '7'),(1, 294, '7'),(1, 295, '8'),(1, 296, '1'),(1, 297, '5'),(1, 298, '5'),(1, 299, '5'),(1, 300, '3'),(1, 301, '3'),(1, 302, '2'),(1, 303, '2'),(1, 304, '5'),(1, 305, '6')");
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Loading U.S. 2000 Census data, please wait...");
        }
        dbConnection.update("CREATE TABLE pop_us_2000 (lat_index INT NOT NULL,lon_index INT NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,population INT NOT NULL,INDEX (lat_index),INDEX (lon_index))");
        dbConnection.update("LOAD DATA LOCAL INFILE 'data/pop_us_2000.dat' INTO TABLE pop_us_2000 FIELDS TERMINATED BY '|' LINES TERMINATED BY '\n'");
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Loading U.S. 2010 Census data, please wait...");
        }
        dbConnection.update("CREATE TABLE pop_us_2010 (lat_index INT NOT NULL,lon_index INT NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,population INT NOT NULL,INDEX (lat_index),INDEX (lon_index))");
        dbConnection.update("LOAD DATA LOCAL INFILE 'data/pop_us_2010.dat' INTO TABLE pop_us_2010 FIELDS TERMINATED BY '|' LINES TERMINATED BY '\n'");
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Loading Canadian Census data, please wait...");
        }
        dbConnection.update("CREATE TABLE pop_ca_2006 (lat_index INT NOT NULL,lon_index INT NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,population INT NOT NULL,INDEX (lat_index),INDEX (lon_index))");
        dbConnection.update("LOAD DATA LOCAL INFILE 'data/pop_ca_2006.dat' INTO TABLE pop_ca_2006 FIELDS TERMINATED BY '|' LINES TERMINATED BY '\n'");
        dbConnection.update("CREATE TABLE pop_ca_2011 (lat_index INT NOT NULL,lon_index INT NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,population INT NOT NULL,INDEX (lat_index),INDEX (lon_index))");
        dbConnection.update("LOAD DATA LOCAL INFILE 'data/pop_ca_2011.dat' INTO TABLE pop_ca_2011 FIELDS TERMINATED BY '|' LINES TERMINATED BY '\n'");
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Loading Mexican Census data, please wait...");
        }
        dbConnection.update("CREATE TABLE pop_mx_2010 (lat_index INT NOT NULL,lon_index INT NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,population INT NOT NULL,INDEX (lat_index),INDEX (lon_index))");
        dbConnection.update("LOAD DATA LOCAL INFILE 'data/pop_mx_2010.dat' INTO TABLE pop_mx_2010 FIELDS TERMINATED BY '|' LINES TERMINATED BY '\n'");
        dbConnection.update("CREATE TABLE country_poly (poly_seq INT NOT NULL,vertex_seq INT NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,country_key INT NOT NULL,PRIMARY KEY (poly_seq, vertex_seq))");
        dbConnection.update("LOAD DATA LOCAL INFILE 'data/country_poly.dat' INTO TABLE country_poly FIELDS TERMINATED BY '|' LINES TERMINATED BY '\n'");
        dbConnection.update("CREATE TABLE application_property (name VARCHAR(255) NOT NULL,value VARCHAR(255) NOT NULL)");
        dbConnection.update("UPDATE version SET version = 103000");
        AppManager.setProperty(DB_ID_KEY_PREFIX + dbConnection.hostname, string);
    }

    private static boolean canUpdateDb(int n) {
        switch (n) {
            case 101000: 
            case 102000: 
            case 102001: 
            case 102003: 
            case 102004: 
            case 102007: 
            case 102008: 
            case 102009: 
            case 102010: {
                return true;
            }
        }
        return false;
    }

    private static void updateDb(DbConnection dbConnection, int n, QueryWorker queryWorker) throws SQLException {
        switch (n) {
            case 101000: {
                DbManager.update102000(dbConnection, n, queryWorker);
            }
            case 102000: {
                DbManager.update102001(dbConnection, n, queryWorker);
            }
            case 102001: {
                DbManager.update102003(dbConnection, n, queryWorker);
            }
            case 102003: {
                DbManager.update102004(dbConnection, n, queryWorker);
            }
            case 102004: {
                DbManager.update102007(dbConnection, n, queryWorker);
            }
            case 102007: {
                DbManager.update102008(dbConnection, n, queryWorker);
            }
            case 102008: {
                DbManager.update102009(dbConnection, n, queryWorker);
            }
            case 102009: {
                DbManager.update102010(dbConnection, n, queryWorker);
            }
            case 102010: {
                DbManager.update103000(dbConnection, n, queryWorker);
                break;
            }
            default: {
                throw new SQLException("Unknown version number, cannot update database.");
            }
        }
        dbConnection.update("UPDATE tvstudy.version SET version = 103000");
    }

    private static void update102000(DbConnection dbConnection, int n, QueryWorker queryWorker) throws SQLException {
        String[] stringArray;
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Updating to version 102000, please wait...");
        }
        dbConnection.update("USE tvstudy");
        dbConnection.update("CREATE TABLE version (version INT NOT NULL)");
        dbConnection.update("INSERT INTO version (version) VALUES (0)");
        dbConnection.update("ALTER TABLE study DROP COLUMN version");
        dbConnection.update("CREATE TABLE study_key_sequence (study_key INT NOT NULL)");
        dbConnection.update("INSERT INTO study_key_sequence (study_key) SELECT MAX(study_key) FROM study");
        dbConnection.update("ALTER TABLE study ADD lock_count INT NOT NULL AFTER study_lock");
        dbConnection.update("ALTER TABLE study ADD share_count INT NOT NULL AFTER lock_count");
        dbConnection.update("ALTER TABLE study ADD template_key INT NOT NULL AFTER new_study");
        dbConnection.update("UPDATE study SET template_key = 1");
        dbConnection.update("ALTER TABLE study_template RENAME TO template");
        dbConnection.update("CREATE TABLE template_key_sequence (template_key INT NOT NULL)");
        dbConnection.update("INSERT INTO template_key_sequence (template_key) SELECT MAX(template_key) FROM template");
        dbConnection.update("ALTER TABLE template ADD locked BOOLEAN NOT NULL AFTER study_description");
        dbConnection.update("ALTER TABLE template ADD locked_in_study BOOLEAN NOT NULL AFTER locked");
        dbConnection.update("UPDATE template SET locked = true WHERE template_key = 1");
        dbConnection.update("ALTER TABLE template ADD use_count INT NOT NULL AFTER locked_in_study");
        dbConnection.update("UPDATE template SET use_count = (SELECT COUNT(*) FROM study) WHERE template_key = 1");
        dbConnection.update("DELETE FROM template_parameter_data WHERE template_key = 1");
        dbConnection.update("INSERT INTO template_parameter_data (template_key, parameter_key, value) SELECT 1 AS template_key, parameter_key, default_value FROM parameter");
        dbConnection.update("ALTER TABLE parameter DROP COLUMN default_value");
        dbConnection.update("ALTER TABLE study ADD cdbs_key INT NOT NULL AFTER template_key");
        dbConnection.update("CREATE TABLE cdbs (cdbs_key INT NOT NULL, name VARCHAR(255) NOT NULL, use_count INT NOT NULL)");
        dbConnection.update("CREATE TABLE cdbs_key_sequence (cdbs_key INT NOT NULL)");
        dbConnection.update("INSERT INTO cdbs_key_sequence (cdbs_key) VALUES (0)");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        dbConnection.query("SELECT study_key FROM study");
        while (dbConnection.next()) {
            arrayList.add(new Integer(dbConnection.getInt(1)));
        }
        if (!arrayList.isEmpty()) {
            stringArray = new String[]{"cdbs_application", "cdbs_facility", "cdbs_supp_facility", "cdbs_tv_eng_data", "cdbs_tv_app_indicators", "cdbs_dtv_channel_assignments", "cdbs_ant_make", "cdbs_ant_pattern", "cdbs_elevation_ant_make", "cdbs_elevation_pattern", "cdbs_elevation_pattern_addl"};
            String[] stringArray2 = new String[]{"last_change_date", "last_change_date", "last_update_date", "last_change_date", "last_change_date", "", "last_change_date", "last_change_date", "", "last_update_date", "last_update_date"};
            String[] stringArray3 = new String[]{"application", "facility", "supp_facility", "tv_eng_data", "tv_app_indicators", "dtv_channel_assignments", "ant_make", "ant_pattern", "elevation_ant_make", "elevation_pattern", "elevation_pattern_addl"};
            ArrayList<String> arrayList2 = new ArrayList<String>();
            DateCounter dateCounter = new DateCounter("MM/dd/yyyy");
            for (Integer n2 : arrayList) {
                int n3;
                dbConnection.update("USE tvstudy_" + n2);
                dbConnection.update("ALTER TABLE source ADD mod_count INT NOT NULL AFTER needs_update");
                dateCounter.reset();
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    if (0 == stringArray2[n3].length()) continue;
                    dbConnection.query("SELECT " + stringArray2[n3] + " FROM " + stringArray[n3] + " WHERE " + stringArray2[n3] + " <> ''");
                    while (dbConnection.next()) {
                        dateCounter.add(dbConnection.getString(1));
                    }
                }
                String string = dateCounter.toString();
                int n4 = arrayList2.indexOf(string);
                if (n4 < 0) {
                    arrayList2.add(string);
                    n4 = arrayList2.size();
                    dbConnection.update("INSERT INTO tvstudy.cdbs (cdbs_key, name, use_count) VALUES (" + n4 + ", '" + dbConnection.clean(string) + "', 1)");
                    dbConnection.update("CREATE DATABASE tvstudy_cdbs_" + n4);
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        dbConnection.update("RENAME TABLE " + stringArray[n3] + " TO tvstudy_cdbs_" + n4 + "." + stringArray3[n3]);
                    }
                } else {
                    dbConnection.update("UPDATE tvstudy.cdbs SET use_count = use_count + 1 WHERE cdbs_key = " + ++n4);
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        dbConnection.update("DROP TABLE " + stringArray[n3]);
                    }
                }
                dbConnection.update("UPDATE tvstudy.study SET cdbs_key = " + n4 + " WHERE study_key = " + n2);
            }
            dbConnection.update("UPDATE tvstudy.cdbs_key_sequence SET cdbs_key = " + arrayList2.size());
        }
        if ((stringArray = new File("cache")).exists() && stringArray.isDirectory()) {
            AppManager.deleteDirectoryAndContents((File)stringArray);
        }
    }

    private static void update102001(DbConnection dbConnection, int n, QueryWorker queryWorker) throws SQLException {
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Updating to version 102001, please wait...");
        }
        dbConnection.update("USE tvstudy");
        dbConnection.update("UPDATE parameter SET name = 'Digital receive antenna f/b, VHF low', description = '<HTML>Receive antenna front-to-back ratio in dB, digital VHF low band.</HTML>' WHERE parameter_key = 140");
        dbConnection.update("UPDATE parameter SET name = 'Digital receive antenna f/b, VHF high', description = '<HTML>Receive antenna front-to-back ratio in dB, digital VHF high band.</HTML>' WHERE parameter_key = 142");
        dbConnection.update("UPDATE parameter SET name = 'Digital receive antenna f/b, UHF', description = '<HTML>Receive antenna front-to-back ratio in dB, digital UHF.</HTML>' WHERE parameter_key = 144");
        dbConnection.update("UPDATE parameter SET name = 'Analog receive antenna f/b, VHF low', description = '<HTML>Receive antenna front-to-back ratio in dB, analog VHF low band.</HTML>' WHERE parameter_key = 146");
        dbConnection.update("UPDATE parameter SET name = 'Analog receive antenna f/b, VHF high', description = '<HTML>Receive antenna front-to-back ratio in dB, analog VHF high band.</HTML>' WHERE parameter_key = 148");
        dbConnection.update("UPDATE parameter SET name = 'Analog receive antenna f/b, UHF', description = '<HTML>Receive antenna front-to-back ratio in dB, analog UHF.</HTML>' WHERE parameter_key = 150");
        dbConnection.update("INSERT INTO parameter VALUES (17, 'Use generic patterns for contours', 'option', '<HTML>Always use generic elevation patterns to project contours, even when another pattern is available.</HTML>', false), (19, 'Invert negative tilts', 'option', '<HTML>Change all negative values for electrical and mechanical beam tilt to positive (use absolute value).</HTML>', false), (110, 'Truncate DTS service area', 'option', '<HTML>Truncate DTS service by the combined area of the pre-DTS service contour and a distance limit around the DTS reference point.</HTML>', false), (111, 'DTS distance limit, VHF low Zone I', 'decimal:50:200', '<HTML>DTS distance limit, VHF low band in Zone I.</HTML>', false), (112, 'DTS distance limit, VHF low Zone II/III', 'decimal:50:200', '<HTML>DTS distance limit, VHF low band in Zones II and III.</HTML>', false), (113, 'DTS distance limit, VHF high Zone I', 'decimal:50:200', '<HTML>DTS distance limit, VHF high band in Zone I.</HTML>', false), (114, 'DTS distance limit, VHF high Zone II/III', 'decimal:50:200', '<HTML>DTS distance limit, VHF high band in Zones II and III.</HTML>', false), (115, 'DTS distance limit, UHF', 'decimal:50:200', '<HTML>DTS distance limit, UHF.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 17, '1'), (1, 19, '1'), (1, 110, '1'), (1, 111, '108'), (1, 112, '128'), (1, 113, '101'), (1, 114, '123'), (1, 115, '103')");
        dbConnection.update("ALTER TABLE parameter ADD list_order INT NOT NULL AFTER parameter_key");
        dbConnection.update("UPDATE parameter SET list_order = parameter_key * 10");
        dbConnection.update("UPDATE template SET study_description = 'New study'");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        dbConnection.query("SELECT study_key FROM study");
        while (dbConnection.next()) {
            arrayList.add(new Integer(dbConnection.getInt(1)));
        }
        for (Integer n2 : arrayList) {
            dbConnection.update("USE tvstudy_" + n2);
            dbConnection.update("ALTER TABLE source ADD height_agl DOUBLE NOT NULL AFTER height_amsl");
            dbConnection.update("ALTER TABLE source ADD contour_erp DOUBLE NOT NULL AFTER peak_erp");
            dbConnection.update("UPDATE source SET contour_erp = 10.0 * LOG10(peak_erp), needs_update = true");
        }
    }

    private static void update102003(DbConnection dbConnection, int n, QueryWorker queryWorker) throws SQLException {
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Updating to version 102003, please wait...");
        }
        dbConnection.update("USE tvstudy");
        dbConnection.update("CREATE TABLE parameter_group (group_key INT NOT NULL PRIMARY KEY, list_order INT NOT NULL, name VARCHAR(255) NOT NULL, enabling_parameter_key INT NOT NULL)");
        dbConnection.update("INSERT INTO parameter_group VALUES (1, 10, 'General', 0), (2, 20, 'CDBS', 0), (3, 30, 'Patterns', 0), (4, 40, 'Contours', 0), (5, 50, 'Replication', 0), (6, 60, 'Pathloss', 0), (7, 70, 'Service', 309), (8, 80, 'Clutter', 249)");
        dbConnection.update("ALTER TABLE parameter ADD group_key INT NOT NULL AFTER parameter_key");
        dbConnection.update("UPDATE parameter SET group_key = 1");
        dbConnection.update("UPDATE parameter SET group_key = 2 WHERE parameter_key = 18");
        dbConnection.update("UPDATE parameter SET group_key = 3 WHERE parameter_key IN (12,14,16,19) OR parameter_key BETWEEN 140 AND 150");
        dbConnection.update("UPDATE parameter SET group_key = 4 WHERE parameter_key = 17 OR parameter_key BETWEEN 80 AND 128");
        dbConnection.update("UPDATE parameter SET group_key = 5 WHERE parameter_key BETWEEN 50 AND 70");
        dbConnection.update("UPDATE parameter SET group_key = 6 WHERE parameter_key IN (10,130,132) OR parameter_key BETWEEN 160 AND 192");
        dbConnection.update("UPDATE parameter SET group_key = 8 WHERE parameter_key BETWEEN 249 AND 305");
        dbConnection.update("INSERT INTO parameter VALUES (220, 2, 2200, 'Mexican digital ERP, VHF low', 'decimal:1:2000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for digital VHF low band.</HTML>', true), (221, 2, 2210, 'Mexican digital HAAT, VHF low', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for digital VHF low band.</HTML>', true), (222, 2, 2220, 'Mexican digital ERP, VHF high', 'decimal:1:2000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for digital VHF high band.</HTML>', true), (223, 2, 2230, 'Mexican digital HAAT, VHF high', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for digital VHF high band.</HTML>', true), (224, 2, 2240, 'Mexican digital ERP, UHF', 'decimal:1:2000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for digital UHF.</HTML>', true), (225, 2, 2250, 'Mexican digital HAAT, UHF', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for digital UHF.</HTML>', true), (226, 2, 2260, 'Mexican analog ERP, VHF low', 'decimal:1:6000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for analog VHF low band.</HTML>', true), (227, 2, 2270, 'Mexican analog HAAT, VHF low', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for analog VHF low band.</HTML>', true), (228, 2, 2280, 'Mexican analog ERP, VHF high', 'decimal:1:6000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for analog VHF high band.</HTML>', true), (229, 2, 2290, 'Mexican analog HAAT, VHF high', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for analog VHF high band.</HTML>', true), (230, 2, 2300, 'Mexican analog ERP, UHF', 'decimal:1:6000', '<HTML>Default for Mexican full-service records with missing data, ERP in kilowatts for analog UHF.</HTML>', true), (231, 2, 2310, 'Mexican analog HAAT, UHF', 'decimal:30:800', '<HTML>Default for Mexican full-service records with missing data, HAAT in meters for analog UHF.</HTML>', true)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 220, '45'), (1, 221, '305'), (1, 222, '160'), (1, 223, '305'), (1, 224, '1000'), (1, 225, '365'), (1, 226, '100'), (1, 227, '305'), (1, 228, '316'), (1, 229, '305'), (1, 230, '5000'), (1, 231, '610')");
        dbConnection.update("UPDATE parameter SET name = 'Digital full-service contour, VHF low', type = 'decimal:0:120' WHERE parameter_key = 80");
        dbConnection.update("UPDATE parameter SET name = 'Digital full-service contour, VHF high', type = 'decimal:0:120' WHERE parameter_key = 82");
        dbConnection.update("UPDATE parameter SET name = 'Digital full-service contour, UHF', type = 'decimal:0:120' WHERE parameter_key = 84");
        dbConnection.update("UPDATE parameter SET name = 'Digital Class A/LPTV contour, VHF low', type = 'decimal:0:120' WHERE parameter_key = 86");
        dbConnection.update("UPDATE parameter SET name = 'Digital Class A/LPTV contour, VHF high', type = 'decimal:0:120' WHERE parameter_key = 88");
        dbConnection.update("UPDATE parameter SET name = 'Digital Class A/LPTV contour, UHF', type = 'decimal:0:120' WHERE parameter_key = 90");
        dbConnection.update("UPDATE parameter SET name = 'Analog full-service contour, VHF low', type = 'decimal:0:120' WHERE parameter_key = 92");
        dbConnection.update("UPDATE parameter SET name = 'Analog full-service contour, VHF high', type = 'decimal:0:120' WHERE parameter_key = 94");
        dbConnection.update("UPDATE parameter SET name = 'Analog full-service contour, UHF', type = 'decimal:0:120' WHERE parameter_key = 96");
        dbConnection.update("UPDATE parameter SET name = 'Analog Class A/LPTV contour, VHF low', type = 'decimal:0:120' WHERE parameter_key = 98");
        dbConnection.update("UPDATE parameter SET name = 'Analog Class A/LPTV contour, VHF high', type = 'decimal:0:120' WHERE parameter_key = 100");
        dbConnection.update("UPDATE parameter SET name = 'Analog Class A/LPTV contour, UHF', type = 'decimal:0:120' WHERE parameter_key = 102");
        dbConnection.update("INSERT INTO parameter VALUES (107, 4, 1070, 'Propagation curve set, digital', 'pickfrom:1:F(50,50):2:F(50,10):3:F(50,90)', '<HTML>FCC propagation curve set for digital service contour projection.</HTML>', false), (108, 4, 1080, 'Propagation curve set, analog', 'pickfrom:1:F(50,50):2:F(50,10):3:F(50,90)', '<HTML>FCC propagation curve set for analog service contour projection.</HTML>', false), (309, 7, 799, 'Set service thresholds', 'option', '<HTML>Independently set the terrain-sensitive service thresholds.<BR>If not selected, thresholds are the same as contour levels.</HTML>', false), (310, 7, 800, 'Digital full-service threshold, VHF low', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital full-service VHF low band.</HTML>', false), (311, 7, 820, 'Digital full-service threshold, VHF high', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital full-service VHF high band.</HTML>', false), (312, 7, 840, 'Digital full-service threshold, UHF', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital full-service UHF (may be dipole-adjusted).</HTML>', false), (313, 7, 860, 'Digital Class A/LPTV threshold, VHF low', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital LPTV/Class A VHF low band.</HTML>', false), (314, 7, 880, 'Digital Class A/LPTV threshold, VHF high', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital LPTV/Class A VHF high band.</HTML>', false), (315, 7, 900, 'Digital Class A/LPTV threshold, UHF', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, digital LPTV/Class A UHF (may be dipole-adjusted).</HTML>', false), (316, 7, 920, 'Analog full-service threshold, VHF low', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog full-service VHF low band.</HTML>', false), (317, 7, 940, 'Analog full-service threshold, VHF high', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog full-service VHF high band.</HTML>', false), (318, 7, 960, 'Analog full-service threshold, UHF', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog full-service UHF (may be dipole-adjusted).</HTML>', false), (319, 7, 980, 'Analog Class A/LPTV threshold, VHF low', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog LPTV/Class A VHF low band.</HTML>', false), (320, 7, 1000, 'Analog Class A/LPTV threshold, VHF high', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog LPTV/Class A VHF high band.</HTML>', false), (321, 7, 1020, 'Analog Class A/LPTV threshold, UHF', 'decimal:0:120', '<HTML>Terrain-sensitive service threshold level in dBu, analog LPTV/Class A UHF (may be dipole-adjusted).</HTML>', false), (322, 7, 1040, 'Use UHF dipole adjustment', 'option', '<HTML>Apply dipole adjustment to UHF terrain-sensitive service threshold levels.</HTML>', false), (323, 7, 1060, 'Dipole center frequency', 'decimal:470:700', '<HTML>Center frequency in MHz for dipole adjustment of UHF terrain-sensitive service threshold levels.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 107, '3'), (1, 108, '1'), (1, 309, '0'), (1, 310, '28'), (1, 311, '36'), (1, 312, '41'), (1, 313, '43'), (1, 314, '48'), (1, 315, '51'), (1, 316, '47'), (1, 317, '56'), (1, 318, '64'), (1, 319, '62'), (1, 320, '68'), (1, 321, '74'), (1, 322, '1'), (1, 323, '617')");
    }

    private static void update102004(DbConnection dbConnection, int n, QueryWorker queryWorker) throws SQLException {
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Updating to version 102004, please wait...");
        }
        dbConnection.update("USE tvstudy");
        dbConnection.update("ALTER TABLE cdbs ADD COLUMN id VARCHAR(255) NOT NULL AFTER cdbs_key");
        dbConnection.update("UPDATE cdbs SET id = name, name = ''");
        dbConnection.update("ALTER TABLE template DROP COLUMN study_description");
        dbConnection.update("UPDATE template_parameter_data SET value = '365' WHERE parameter_key = 225 AND value = '610'");
        dbConnection.update("UPDATE template_parameter_data SET value = '2' WHERE parameter_key = 16 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '1' WHERE parameter_key = 19 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '1' WHERE parameter_key = 20 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '1' WHERE parameter_key = 30 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '1' WHERE parameter_key = 32 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '2' WHERE parameter_key = 50 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '615' WHERE parameter_key = 106 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '8' WHERE parameter_key = 120 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '30.5' WHERE parameter_key = 121 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '360' WHERE parameter_key = 122 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '30' WHERE parameter_key = 212 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '615' WHERE parameter_key = 323 AND template_key = 1");
        dbConnection.update("INSERT INTO parameter VALUES (15, 3, 150, 'Mirror generic patterns', 'option', '<HTML>Mirror generic patterns around the depression angle of the maximum.<BR>If not selected, pattern is 1.0 at angles above the maximum.<BR>Non-generic patterns are always mirrored if needed.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 15, '1')");
        dbConnection.update("INSERT INTO parameter VALUES (219, 2, 2190, 'Use generic patterns for Canadian records', 'option', '<HTML>Use OET-69 generic elevation patterns for Canadian CDBS records without elevation pattern data.<BR>If not selected, Canadian records without patterns will be omni in the elevation plane.</HTML>', true)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 219, '1')");
        dbConnection.update("UPDATE parameter SET name = 'Use real elevation patterns for contours', description = '<HTML>Use real elevation patterns when available for projecting service contours.<BR>If not selected, contour projection will use generic patterns, or no elevation pattern, per other settings.<HTML>' WHERE parameter_key = 17");
        dbConnection.update("UPDATE template_parameter_data SET value = (CASE WHEN value = '0' THEN '1' ELSE '0' END) WHERE parameter_key = 17");
        dbConnection.update("INSERT INTO parameter VALUES (324, 1, 2200, 'Minimum channel', 'integer:2:69', '<HTML>Lowest allowed TV channel number, database records below this are ignored.</HTML>', true), (325, 1, 2201, 'Maximum channel', 'integer:2:69', '<HTML>Highest allowed TV channel number, database records above this are ignored.</HTML>', true)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 324, '2'), (1, 325, '51')");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        dbConnection.query("SELECT study_key FROM study");
        while (dbConnection.next()) {
            arrayList.add(new Integer(dbConnection.getInt(1)));
        }
        for (Integer n2 : arrayList) {
            dbConnection.update("USE tvstudy_" + n2);
            dbConnection.update("UPDATE parameter_data SET value = (CASE WHEN value = '0' THEN '1' ELSE '0' END) WHERE parameter_key = 17");
            dbConnection.update("ALTER TABLE scenario_source ADD is_desired BOOLEAN NOT NULL AFTER source_key");
            dbConnection.update("ALTER TABLE scenario_source ADD is_undesired BOOLEAN NOT NULL AFTER is_desired");
            dbConnection.update("UPDATE scenario_source SET is_desired = do_study, is_undesired = true");
            dbConnection.update("ALTER TABLE scenario_source DROP COLUMN do_study");
            dbConnection.update("ALTER TABLE source ADD use_generic_vertical_pattern BOOLEAN NOT NULL AFTER matrix_pattern_name");
            dbConnection.update("UPDATE source SET use_generic_vertical_pattern = true");
        }
    }

    private static void update102007(DbConnection dbConnection, int n, QueryWorker queryWorker) throws SQLException {
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Updating to version 102007, please wait...");
        }
        if (101000 == n) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        dbConnection.query("SELECT cdbs_key FROM tvstudy.cdbs");
        while (dbConnection.next()) {
            arrayList.add(new Integer(dbConnection.getInt(1)));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Integer n2 : arrayList) {
            dbConnection.update("USE cdbs_" + n2);
            arrayList2.clear();
            dbConnection.query("SHOW TABLES");
            while (dbConnection.next()) {
                arrayList2.add(dbConnection.getString(1));
            }
            dbConnection.update("CREATE DATABASE tvstudy_cdbs_" + n2);
            for (String string : arrayList2) {
                dbConnection.update("RENAME TABLE " + string + " TO tvstudy_cdbs_" + n2 + "." + string);
            }
            dbConnection.update("DROP DATABASE cdbs_" + n2);
        }
    }

    private static void update102008(DbConnection dbConnection, int n, QueryWorker queryWorker) throws SQLException {
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Updating to version 102008, please wait...");
        }
        dbConnection.update("USE tvstudy");
        dbConnection.update("UPDATE parameter SET type = 'pickfrom:0:Never:1:Always:2:Real patterns only', description = '<HTML>When to apply mechanical beam tilt to elevation patterns.<BR>Electrical beam tilt is always applied to real patterns.</HTML>' WHERE parameter_key = 14");
    }

    private static void update102009(DbConnection dbConnection, int n, QueryWorker queryWorker) throws SQLException {
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Updating to version 102009, please wait...");
        }
        dbConnection.update("USE tvstudy");
        dbConnection.update("UPDATE template_parameter_data SET value = '2' WHERE parameter_key = 10 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '0' WHERE parameter_key = 15 AND template_key = 1");
        dbConnection.update("UPDATE template_parameter_data SET value = '160' WHERE parameter_key = 210 AND template_key = 1");
        dbConnection.update("INSERT INTO parameter VALUES (326, 1, 600, 'Check individual DTS transmitter distances', 'option', '<HTML>For distance checks involving a DTS station, use the coordinates of the nearest individal DTS transmitter.<BR>When not selected, distance checks always use the DTS reference point coordinates.</HTML>', true)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 326, '0')");
    }

    private static void update102010(DbConnection dbConnection, int n, QueryWorker queryWorker) throws SQLException {
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Updating to version 102010, please wait...");
        }
        dbConnection.update("USE tvstudy");
        dbConnection.update("ALTER TABLE version ADD COLUMN uuid TEXT NOT NULL");
        String string = UUID.randomUUID().toString();
        dbConnection.update("UPDATE version SET uuid = '" + dbConnection.clean(string) + "'");
        AppManager.setProperty(DB_ID_KEY_PREFIX + dbConnection.hostname, string);
        new File("cache" + File.separator + dbConnection.hostname).renameTo(new File("cache" + File.separator + string));
        dbConnection.update("INSERT INTO parameter VALUES (327, 5, 670, 'Digital Class A/LPTV minimum ERP, VHF', 'decimal:0.001:2000', '<HTML>Minimum ERP in kW for digital Class A/LPTV, VHF (applied after contour replication).</HTML>', false),(328, 5, 671, 'Digital Class A/LPTV minimum ERP, UHF', 'decimal:0.001:2000', '<HTML>Minimum ERP in kW for digital Class A/LPTV, UHF (applied after contour replication).</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 327, '0.07'),(1, 328, '0.75')");
        dbConnection.update("UPDATE template_parameter_data SET value = '162' WHERE parameter_key = 210 AND template_key = 1");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        dbConnection.query("SELECT study_key FROM study");
        while (dbConnection.next()) {
            arrayList.add(new Integer(dbConnection.getInt(1)));
        }
        for (Integer n2 : arrayList) {
            dbConnection.update("USE tvstudy_" + n2);
            dbConnection.update("ALTER TABLE source ADD COLUMN actual_height_amsl DOUBLE NOT NULL AFTER height_amsl");
            dbConnection.update("UPDATE source SET actual_height_amsl = height_amsl");
            dbConnection.update("ALTER TABLE source ADD COLUMN dts_contour_channel INT NOT NULL AFTER channel");
            dbConnection.update("UPDATE source SET dts_contour_channel = channel WHERE dts_latitude != 0.");
            dbConnection.update("ALTER TABLE source ADD COLUMN dts_maximum_distance DOUBLE NOT NULL AFTER dts_longitude");
            dbConnection.update("ALTER TABLE source ADD COLUMN antenna_id INT NOT NULL AFTER contour_erp");
        }
    }

    private static void update103000(DbConnection dbConnection, int n, QueryWorker queryWorker) throws SQLException {
        if (null != queryWorker) {
            queryWorker.setWaitMessage("Updating to version 103000, please wait...");
        }
        dbConnection.update("USE tvstudy");
        dbConnection.update("DELETE FROM pop_mx_2010");
        dbConnection.update("LOAD DATA LOCAL INFILE 'data/pop_mx_2010.dat' INTO TABLE pop_mx_2010 FIELDS TERMINATED BY '|' LINES TERMINATED BY '\n'");
        dbConnection.update("ALTER TABLE study ADD COLUMN needs_update BOOLEAN NOT NULL AFTER new_study");
        dbConnection.update("UPDATE study SET needs_update = true");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        dbConnection.query("SELECT study_key FROM study");
        while (dbConnection.next()) {
            arrayList.add(new Integer(dbConnection.getInt(1)));
        }
        for (Integer n2 : arrayList) {
            dbConnection.update("USE tvstudy_" + n2);
            dbConnection.update("ALTER TABLE source ADD COLUMN site_number INT NOT NULL AFTER application_id");
        }
    }

    private static class ManagerDialog
    extends AppDialog {
        private static final String WINDOW_TITLE = "Manage Database";
        private DbInfo dbInfo;
        private String originalDbID;
        private JLabel statusLabel;
        private JLabel cacheLabel;
        private JButton installButton;
        private JButton clearCacheButton;
        private JButton unlockAllButton;
        private JButton updateButton;
        private JButton openButton;

        private ManagerDialog(DbInfo dbInfo) {
            super(null, WINDOW_TITLE, Dialog.ModalityType.MODELESS);
            this.dbInfo = dbInfo;
            this.originalDbID = dbInfo.dbID;
            JLabel jLabel = new JLabel(this.dbInfo.dbHost);
            JLabel jLabel2 = new JLabel(this.dbInfo.userText);
            this.statusLabel = new JLabel("XXXXXXXXXXXXXXXXXXXX");
            this.cacheLabel = new JLabel("999.99 GB");
            this.installButton = new JButton("Uninstall");
            this.installButton.setFocusable(false);
            this.installButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ManagerDialog.this.dbInfo.hasRoot) {
                        ManagerDialog.this.doUninstall();
                    } else {
                        ManagerDialog.this.doInstall();
                    }
                }
            });
            this.clearCacheButton = new JButton("Clear Cache");
            this.clearCacheButton.setFocusable(false);
            this.clearCacheButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagerDialog.this.doClearCache();
                }
            });
            this.unlockAllButton = new JButton("Unlock All");
            this.unlockAllButton.setFocusable(false);
            this.unlockAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagerDialog.this.doUnlockAll();
                }
            });
            this.updateButton = new JButton("Update");
            this.updateButton.setFocusable(false);
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagerDialog.this.doUpdate();
                }
            });
            this.openButton = new JButton("Open");
            this.openButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagerDialog.this.doOpen();
                }
            });
            JButton jButton = new JButton("Done");
            jButton.setFocusable(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagerDialog.this.doCancel();
                }
            });
            JLabel jLabel3 = new JLabel("Host name:");
            JLabel jLabel4 = new JLabel("User name:");
            JLabel jLabel5 = new JLabel("Status:");
            JLabel jLabel6 = new JLabel("Cache size:");
            JPanel jPanel = new JPanel();
            GroupLayout groupLayout = new GroupLayout(jPanel);
            groupLayout.setAutoCreateGaps(true);
            groupLayout.setAutoCreateContainerGaps(true);
            jPanel.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel3).addComponent(jLabel4).addComponent(jLabel5).addComponent(jLabel6)).addGroup(groupLayout.createParallelGroup().addComponent(jLabel).addComponent(jLabel2).addComponent(this.statusLabel).addComponent(this.cacheLabel)));
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(jLabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(jLabel2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.statusLabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel6).addComponent(this.cacheLabel)));
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.unlockAllButton);
            jPanel2.add(this.updateButton);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(this.installButton);
            jPanel3.add(this.clearCacheButton);
            JPanel jPanel4 = new JPanel(new FlowLayout(2));
            jPanel4.add(jButton);
            jPanel4.add(this.openButton);
            Container container = this.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add(jPanel);
            container.add(jPanel2);
            container.add(jPanel3);
            container.add(jPanel4);
            this.getRootPane().setDefaultButton(this.openButton);
            this.pack();
            this.setMinimumSize(this.getSize());
            this.setResizable(true);
            this.setLocationSaved(true);
            this.updateControls();
        }

        private void updateControls() {
            this.statusLabel.setText(this.dbInfo.statusText);
            if (this.dbInfo.canInstall) {
                this.installButton.setText("Install");
                this.installButton.setEnabled(true);
            } else if (this.dbInfo.canUninstall) {
                this.installButton.setText("Uninstall");
                this.installButton.setEnabled(true);
            } else {
                this.installButton.setEnabled(false);
            }
            if (this.dbInfo.cacheSize > 0L) {
                if ((double)this.dbInfo.cacheSize >= 1.0E9) {
                    this.cacheLabel.setText(String.format("%.2f GB", (double)this.dbInfo.cacheSize / 1.0E9));
                } else if ((double)this.dbInfo.cacheSize >= 1000000.0) {
                    this.cacheLabel.setText(String.format("%.1f MB", (double)this.dbInfo.cacheSize / 1000000.0));
                } else {
                    this.cacheLabel.setText(String.format("%.0f kB", (double)this.dbInfo.cacheSize / 1000.0));
                }
                this.clearCacheButton.setEnabled(true);
            } else {
                this.cacheLabel.setText("Empty");
                this.clearCacheButton.setEnabled(false);
            }
            this.unlockAllButton.setEnabled(this.dbInfo.canUnlock);
            this.updateButton.setEnabled(this.dbInfo.canUpdate);
            this.openButton.setEnabled(this.dbInfo.canOpen);
            if (null != this.dbInfo.lookupErrorMessage) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AppManager.showMessage((Component)managers.get(ManagerDialog.this.originalDbID), ManagerDialog.this.dbInfo.lookupErrorMessage, ManagerDialog.WINDOW_TITLE, 0);
                        ManagerDialog.this.dbInfo.lookupErrorMessage = null;
                    }
                });
            }
        }

        private void doInstall() {
            if (!this.dbInfo.canInstall) {
                return;
            }
            String string = "Install Database";
            ErrorReporter errorReporter = new ErrorReporter(this, string);
            if (this.dbInfo.db.connect(errorReporter)) {
                QueryWorker<String> queryWorker = new QueryWorker<String>((Window)this, string, this.dbInfo.db, false){

                    @Override
                    protected String doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                        String string = null;
                        try {
                            DbManager.installDb(dbConnection, this);
                        }
                        catch (SQLException sQLException) {
                            string = "An error occurred while installing the root database.\nUninstall and try the installation again.  The error was:\n" + sQLException;
                            dbConnection.reportError(sQLException);
                        }
                        ManagerDialog.this.dbInfo.update();
                        return string;
                    }
                };
                String string2 = (String)queryWorker.runQuery("Installing database, please wait...", errorReporter);
                this.dbInfo.db.close();
                if (null != string2) {
                    errorReporter.reportError(string2);
                }
            }
            this.updateControls();
        }

        private void doUninstall() {
            if (!this.dbInfo.canUninstall) {
                return;
            }
            String string = "Uninstall Database";
            AppManager.beep();
            if (0 != JOptionPane.showConfirmDialog(this, "This will delete all TVStudy databases from the host, all studies\nand other saved data will be lost.  If other applications are\nstill using the database, those applications will fail.\n\nDo you want to continue?", string, 0, 2)) {
                return;
            }
            ErrorReporter errorReporter = new ErrorReporter(this, string);
            if (this.dbInfo.db.connect(errorReporter)) {
                QueryWorker<String> queryWorker = new QueryWorker<String>((Window)this, string, this.dbInfo.db, false){

                    @Override
                    protected String doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                        String string = null;
                        try {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            dbConnection.query("SHOW DATABASES LIKE 'tvstudy%'");
                            while (dbConnection.next()) {
                                arrayList.add(dbConnection.getString(1));
                            }
                            for (String string2 : arrayList) {
                                dbConnection.update("DROP DATABASE " + string2);
                            }
                        }
                        catch (SQLException sQLException) {
                            string = "An operation cannot be completed due to a database error:\n" + sQLException;
                            dbConnection.reportError(sQLException);
                        }
                        ManagerDialog.this.dbInfo.update();
                        Study.deleteStudyCache(ManagerDialog.this.dbInfo.dbID, 0);
                        ManagerDialog.this.dbInfo.cacheSize = Study.getStudyCacheSize(ManagerDialog.this.dbInfo.dbID, 0);
                        return string;
                    }
                };
                String string2 = (String)queryWorker.runQuery("Uninstalling database, please wait...", errorReporter);
                this.dbInfo.db.close();
                if (null != string2) {
                    errorReporter.reportError(string2);
                }
            }
            this.updateControls();
        }

        private void doClearCache() {
            if (this.dbInfo.cacheSize <= 0L) {
                return;
            }
            String string = "Clear Cache";
            ErrorReporter errorReporter = new ErrorReporter(this, string);
            QueryWorker<Object> queryWorker = new QueryWorker<Object>((Window)this, string){

                @Override
                protected String doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                    Study.deleteStudyCache(ManagerDialog.this.dbInfo.dbID, 0);
                    ManagerDialog.this.dbInfo.cacheSize = Study.getStudyCacheSize(ManagerDialog.this.dbInfo.dbID, 0);
                    return null;
                }
            };
            queryWorker.runQuery("Deleting cache files, please wait...", errorReporter);
            this.updateControls();
        }

        private void doUnlockAll() {
            if (!this.dbInfo.canUnlock) {
                return;
            }
            String string = "Unlock All Studies";
            AppManager.beep();
            if (0 != JOptionPane.showConfirmDialog(this, "This will clear locks on all studies.  Do this only if studies were\nnot closed properly due to application crashes or network failures;\nif this is done when other applications are still using any studies,\nthose applications will fail and databases could become corrupted.\n\nDo you want to continue?", string, 0, 2)) {
                return;
            }
            ErrorReporter errorReporter = new ErrorReporter(this, string);
            if (this.dbInfo.db.connect(errorReporter)) {
                try {
                    this.dbInfo.db.update("UPDATE tvstudy.study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0");
                }
                catch (SQLException sQLException) {
                    this.dbInfo.db.reportError(errorReporter, sQLException);
                }
                this.dbInfo.update();
                this.dbInfo.db.close();
            }
            this.updateControls();
        }

        private void doUpdate() {
            if (!this.dbInfo.canUpdate) {
                return;
            }
            String string = "Update Database";
            ErrorReporter errorReporter = new ErrorReporter(this, string);
            if (this.dbInfo.db.connect(errorReporter)) {
                QueryWorker<String> queryWorker = new QueryWorker<String>((Window)this, string, this.dbInfo.db, false){

                    @Override
                    protected String doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                        String string = null;
                        try {
                            dbConnection.update("USE tvstudy");
                            if (ManagerDialog.this.dbInfo.hasVersionTable) {
                                dbConnection.update("LOCK TABLES study WRITE, version WRITE");
                                dbConnection.query("SELECT version FROM version");
                            } else {
                                dbConnection.update("LOCK TABLES study WRITE");
                                dbConnection.query("SELECT MAX(version) FROM study");
                            }
                            dbConnection.next();
                            int n = dbConnection.getInt(1);
                            if (0 != n) {
                                if (DbManager.canUpdateDb(n)) {
                                    dbConnection.query("SELECT COUNT(*) FROM study WHERE study_lock <> 0");
                                    dbConnection.next();
                                    if (0 == dbConnection.getInt(1)) {
                                        if (ManagerDialog.this.dbInfo.hasVersionTable) {
                                            dbConnection.update("UPDATE version SET version = 0");
                                        } else {
                                            dbConnection.update("UPDATE study SET version = 0");
                                        }
                                        dbConnection.update("UNLOCK TABLES");
                                        DbManager.updateDb(dbConnection, n, this);
                                    } else {
                                        string = "The database cannot be updated, studies are currently in use.";
                                    }
                                } else {
                                    string = "The database version changed and cannot be updated.";
                                }
                            } else {
                                string = "Another application is already updating the database.";
                            }
                        }
                        catch (SQLException sQLException) {
                            dbConnection.reportError(sQLException);
                            string = "An error occurred while updating the database.  It must be\nrepaired manually, or uninstalled and re-installed.  The error was:\n" + sQLException;
                        }
                        try {
                            dbConnection.update("UNLOCK TABLES");
                        }
                        catch (SQLException sQLException) {
                            dbConnection.reportError(sQLException);
                        }
                        ManagerDialog.this.dbInfo.update();
                        return string;
                    }
                };
                String string2 = (String)queryWorker.runQuery("Updating database, please wait...", errorReporter);
                this.dbInfo.db.close();
                if (null != string2) {
                    errorReporter.reportError(string2);
                }
            }
            this.updateControls();
        }

        private void doOpen() {
            if (!this.dbInfo.canOpen) {
                return;
            }
            managers.remove(this.originalDbID);
            AppManager.hideWindow(this);
            StudyListEditor studyListEditor = new StudyListEditor(this.dbInfo.dbID);
            DbManager.openDb(this.dbInfo);
            editors.put(this.dbInfo.dbID, studyListEditor);
            AppManager.showWindow(studyListEditor);
            if (loginDialog.isVisible()) {
                AppManager.hideWindow(loginDialog);
            }
        }

        private void doCancel() {
            managers.remove(this.originalDbID);
            AppManager.hideWindow(this);
        }

        @Override
        public boolean windowShouldClose() {
            managers.remove(this.originalDbID);
            return true;
        }
    }

    private static class LoginDialog
    extends AppDialog {
        private static final String WINDOW_TITLE = "Open Database";
        private JTextField hostField;
        private JTextField userField;
        private JPasswordField passField;
        private JButton quitButton;

        private LoginDialog() {
            super(null, WINDOW_TITLE, Dialog.ModalityType.MODELESS);
            this.setDisposeOnClose(false);
            this.hostField = new JTextField(10);
            AppManager.fixKeyBindings(this.hostField);
            this.userField = new JTextField(10);
            AppManager.fixKeyBindings(this.userField);
            this.passField = new JPasswordField(10);
            AppManager.fixKeyBindings(this.passField);
            JButton jButton = new JButton("Open");
            jButton.setFocusable(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LoginDialog.this.doOpenDb(false);
                }
            });
            JButton jButton2 = new JButton("Manage");
            jButton2.setFocusable(false);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LoginDialog.this.doOpenDb(true);
                }
            });
            this.quitButton = new JButton("Quit");
            this.quitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (loginDialog.windowShouldClose()) {
                        AppManager.hideWindow(loginDialog);
                    }
                }
            });
            JLabel jLabel = new JLabel("Host name");
            JLabel jLabel2 = new JLabel("User name");
            JLabel jLabel3 = new JLabel("Password");
            JPanel jPanel = new JPanel();
            GroupLayout groupLayout = new GroupLayout(jPanel);
            groupLayout.setAutoCreateGaps(true);
            groupLayout.setAutoCreateContainerGaps(true);
            jPanel.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel).addComponent(jLabel2).addComponent(jLabel3)).addGroup(groupLayout.createParallelGroup().addComponent(this.hostField).addComponent(this.userField).addComponent(this.passField)));
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.hostField)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.userField)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.passField)));
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.add(jButton2);
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            jPanel3.add(this.quitButton);
            jPanel3.add(jButton);
            JPanel jPanel4 = new JPanel();
            jPanel4.add(jPanel2);
            jPanel4.add(jPanel3);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)jPanel, "Center");
            container.add((Component)jPanel4, "South");
            this.getRootPane().setDefaultButton(jButton);
            this.pack();
            this.setMinimumSize(this.getSize());
            this.setResizable(true);
            this.setLocationSaved(true);
        }

        private void doOpenDb(boolean bl) {
            ManagerDialog managerDialog;
            ErrorReporter errorReporter = new ErrorReporter(this, WINDOW_TITLE);
            final String string = new String(this.passField.getPassword());
            this.passField.setText("");
            final String string2 = this.hostField.getText().trim().toLowerCase();
            if (0 == string2.length()) {
                errorReporter.reportWarning("Please provide a database host name.");
                this.hostField.requestFocusInWindow();
                return;
            }
            final String string3 = this.userField.getText().trim();
            if (0 == string3.length() && !bl) {
                errorReporter.reportWarning("Please provide a user name.");
                this.userField.requestFocusInWindow();
                return;
            }
            if (0 == string.length() && !bl) {
                errorReporter.reportWarning("Please provide the password.\nBlank passwords are not allowed.");
                this.passField.requestFocusInWindow();
                return;
            }
            final boolean bl2 = bl;
            QueryWorker<DbInfo> queryWorker = new QueryWorker<DbInfo>((Window)this, WINDOW_TITLE){

                @Override
                protected DbInfo doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                    DbInfo dbInfo = new DbInfo(string2, string3, string);
                    if (bl2 || dbInfo.needsManage) {
                        dbInfo.cacheSize = Study.getStudyCacheSize(dbInfo.dbID, 0);
                    }
                    return dbInfo;
                }
            };
            DbInfo dbInfo = (DbInfo)queryWorker.runQuery("Connecting to database, please wait...", errorReporter);
            if (null == dbInfo || dbInfo.connectionFailed) {
                errorReporter.reportError("Cannot connect to the database.");
                if (null == dbInfo) {
                    return;
                }
            }
            if (null == (managerDialog = (ManagerDialog)managers.get(dbInfo.dbID))) {
                managerDialog = (ManagerDialog)managers.get(dbInfo.dbHost);
            }
            if (null != managerDialog) {
                managerDialog.toFront();
                return;
            }
            StudyListEditor studyListEditor = (StudyListEditor)editors.get(dbInfo.dbID);
            if (null != studyListEditor) {
                if (bl) {
                    errorReporter.reportWarning("All other windows for that database must be closed first.");
                }
                studyListEditor.toFront();
                AppManager.hideWindow(this);
                return;
            }
            if (bl || dbInfo.needsManage) {
                managerDialog = new ManagerDialog(dbInfo);
                managers.put(dbInfo.dbID, managerDialog);
                AppManager.showWindow(managerDialog);
                return;
            }
            if (dbInfo.canOpen) {
                DbManager.openDb(dbInfo);
                studyListEditor = new StudyListEditor(dbInfo.dbID);
                editors.put(dbInfo.dbID, studyListEditor);
                AppManager.showWindow(studyListEditor);
                AppManager.hideWindow(loginDialog);
                return;
            }
            this.passField.requestFocusInWindow();
        }

        @Override
        public void windowWillOpen() {
            String string = AppManager.getProperty(DbManager.DEFAULT_HOST_KEY);
            if (null == string) {
                string = "";
            }
            this.hostField.setText(string);
            String string2 = AppManager.getProperty(DbManager.DEFAULT_USER_KEY);
            if (null == string2) {
                string2 = "";
            }
            this.userField.setText(string2);
            this.passField.setText("");
            if (0 == string.length()) {
                this.hostField.requestFocusInWindow();
            } else if (0 == string2.length()) {
                this.userField.requestFocusInWindow();
            } else {
                this.passField.requestFocusInWindow();
            }
        }

        @Override
        public boolean windowShouldClose() {
            if (AppManager.hasOpenWindows()) {
                return true;
            }
            for (Window window : Window.getWindows()) {
                if (window == this || !window.isVisible()) continue;
                AppManager.showMessage(this, "Please close all other open windows first.", "Quit TVStudy", 1);
                window.toFront();
                return false;
            }
            return true;
        }
    }

    private static class DbInfo {
        private final String dbHost;
        private DbConnection db;
        private boolean hasRoot;
        private boolean hasVersionTable;
        private int version;
        private String dbID;
        private long cacheSize;
        private boolean connectionFailed;
        private String lookupErrorMessage;
        private String userText;
        private String statusText;
        private boolean needsManage;
        private boolean canInstall;
        private boolean canUninstall;
        private boolean canUnlock;
        private boolean canUpdate;
        private boolean canOpen;

        private DbInfo(String string, String string2, String string3) {
            this.dbHost = string;
            if (string2.length() > 0 && string3.length() > 0) {
                this.db = new DbConnection("jdbc:mysql:", string, string2, string3);
                if (this.db.connect(false)) {
                    this.userText = string2;
                    AppManager.setProperty(DbManager.DEFAULT_HOST_KEY, string);
                    AppManager.setProperty(DbManager.DEFAULT_USER_KEY, string2);
                } else {
                    this.db = null;
                    this.connectionFailed = true;
                    this.userText = "";
                    this.statusText = "Connection failed";
                }
            } else {
                this.userText = "";
                this.statusText = "No connection";
            }
            this.update();
            if (null != this.db) {
                this.db.close();
            }
        }

        private void update() {
            this.hasRoot = false;
            this.hasVersionTable = false;
            this.version = 0;
            this.dbID = this.dbHost;
            boolean bl = false;
            boolean bl2 = false;
            String string = AppManager.getProperty(DbManager.DB_ID_KEY_PREFIX + this.dbHost);
            if (null != string) {
                try {
                    UUID.fromString(string);
                    this.dbID = string;
                    bl = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.lookupErrorMessage = null;
            this.needsManage = true;
            this.canInstall = false;
            this.canUninstall = false;
            this.canUnlock = false;
            this.canUpdate = false;
            this.canOpen = false;
            if (null == this.db) {
                return;
            }
            try {
                int n = 0;
                this.db.query("SHOW DATABASES LIKE 'tvstudy'");
                this.hasRoot = this.db.next();
                if (this.hasRoot) {
                    this.version = -1;
                    this.db.update("USE tvstudy");
                    this.db.query("SHOW TABLES LIKE 'study'");
                    if (this.db.next()) {
                        this.db.query("SHOW CREATE TABLE study");
                        this.db.next();
                        String string2 = this.db.getString(2);
                        this.db.query("SHOW TABLES LIKE 'version'");
                        this.hasVersionTable = this.db.next();
                        if (this.hasVersionTable) {
                            this.db.query("SELECT * FROM version");
                            if (this.db.next()) {
                                this.version = this.db.getInt("version");
                                if (this.version >= 102010) {
                                    string = this.db.getString("uuid");
                                    if (!bl || !this.dbID.equals(string)) {
                                        try {
                                            UUID.fromString(string);
                                            this.dbID = string;
                                            bl = true;
                                            bl2 = true;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {}
                                    }
                                }
                            }
                        } else if (string2.contains("version")) {
                            this.db.query("SELECT MAX(version) FROM study");
                            if (this.db.next()) {
                                this.version = this.db.getInt(1);
                            }
                        }
                        if (string2.contains("study_lock")) {
                            this.db.query("SELECT COUNT(*) FROM study WHERE study_lock <> 0");
                            this.db.next();
                            n = this.db.getInt(1);
                        }
                    }
                }
                if (bl2) {
                    AppManager.setProperty(DbManager.DB_ID_KEY_PREFIX + this.dbHost, this.dbID);
                }
                if (this.hasRoot) {
                    this.canUninstall = true;
                    if (103000 == this.version && bl) {
                        this.statusText = "OK";
                        this.needsManage = false;
                        this.canUnlock = n > 0;
                        this.canOpen = true;
                    } else if (0 == this.version) {
                        this.statusText = "In update or install";
                    } else {
                        this.canUpdate = DbManager.canUpdateDb(this.version);
                        if (this.canUpdate) {
                            this.statusText = "Needs update";
                            if (n > 0) {
                                this.canUnlock = true;
                                this.canUpdate = false;
                            }
                        } else {
                            this.statusText = "Unsupported";
                        }
                    }
                } else {
                    this.statusText = "Not installed";
                    this.canInstall = true;
                }
            }
            catch (SQLException sQLException) {
                this.db.reportError(sQLException);
                this.lookupErrorMessage = "An operation cannot be completed due to a database error:\n" + sQLException;
                this.statusText = "Query error";
            }
        }
    }
}

