/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.editor.StudyListEditor;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.EditMenu;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.LogFormatter;
import gov.fcc.tvstudy.util.QueryWorker;
import gov.fcc.tvstudy.util.ToolRun;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.text.JTextComponent;

public class AppManager
implements WindowListener {
    public static final String APP_VERSION = "1.3";
    public static final double PI = Math.PI;
    public static final double TWO_PI = Math.PI * 2;
    public static final double RADIANS_TO_DEGREES = 57.29577951308232;
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public static boolean Debug;
    private static Logger logger;
    private static String DB_PROPS_FILE;
    private static Properties localProperties;
    private static AppManager manager;
    public static final int MENU_SHORTCUT_KEY_MASK;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int ERROR_MESSAGE = 0;
    public static final Color DISABLED_TEXT_BACKGROUND;
    private static Window currentWindow;
    private static ArrayList<AppFrame> windowList;
    private static boolean[] shortcutKeyInUse;
    private static boolean didInit;
    private static NumberFormat[] numberFormatters;
    private static NumberFormat minuteFormatter;
    private static Pattern latLonPattern;
    private static NumberFormat countFormatter;
    private static int fieldSizeBaseWidth;
    private static int fieldSizeWidthIncrement;
    private static int labelSizeWidthIncrement;
    private static int labelSizeHeight;
    private static int[] maps;
    private static KeyStroke[] keys;

    public static void main(String[] stringArray) {
        if (didInit) {
            return;
        }
        didInit = true;
        Debug = null != System.getProperty("DEBUG");
        logger = Logger.getLogger("TVStudy");
        logger.setLevel(Level.SEVERE);
        try {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new LogFormatter());
            logger.addHandler(consoleHandler);
            logger.setUseParentHandlers(false);
        }
        catch (Exception exception) {
            AppManager.log(Level.SEVERE, "Could not initialize logger: ", exception);
        }
        localProperties = new Properties();
        try {
            localProperties.load(new FileInputStream(DB_PROPS_FILE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new AppManager();
            }
        });
    }

    public static void log(Level level, String string) {
        logger.log(level, string);
    }

    public static void log(Level level, String string, Throwable throwable) {
        logger.log(level, string, throwable);
    }

    public static long sizeOfDirectoryContents(File file) {
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                l += AppManager.sizeOfDirectoryContents(fileArray[i]);
                continue;
            }
            l += fileArray[i].length();
        }
        return l;
    }

    public static boolean deleteDirectoryAndContents(File file) {
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                if (AppManager.deleteDirectoryAndContents(fileArray[i])) continue;
                bl = false;
                continue;
            }
            if (fileArray[i].delete()) continue;
            bl = false;
        }
        if (bl && !file.delete()) {
            bl = false;
        }
        return bl;
    }

    public static String getProperty(String string) {
        return localProperties.getProperty(string);
    }

    public static void setProperty(String string, String string2) {
        if (null == string2) {
            return;
        }
        localProperties.setProperty(string, string2);
    }

    public static String formatLatitude(double d) {
        if (d < 0.0) {
            return AppManager.formatLatLon(-d) + " S";
        }
        return AppManager.formatLatLon(d) + " N";
    }

    public static String formatLongitude(double d) {
        if (d < 0.0) {
            return AppManager.formatLatLon(-d) + " E";
        }
        return AppManager.formatLatLon(d) + " W";
    }

    private static String formatLatLon(double d) {
        int n = (int)d;
        int n2 = (int)((d - (double)n) * 60.0);
        double d2 = ((d - (double)n) * 60.0 - (double)n2) * 60.0;
        if (d2 >= 59.995) {
            d2 = 0.0;
            if (60 == ++n2) {
                n2 = 0;
                ++n;
            }
        }
        return String.valueOf(n) + " " + minuteFormatter.format(n2) + " " + numberFormatters[2].format(d2);
    }

    public static double parseLatitude(String string) {
        return AppManager.parseLatLon(string, -74.0, "S");
    }

    public static double parseLongitude(String string) {
        return AppManager.parseLatLon(string, -181.0, "E");
    }

    private static double parseLatLon(String string, double d, String string2) {
        double d2 = d;
        String[] stringArray = latLonPattern.split(string);
        if (1 == stringArray.length) {
            try {
                d2 = Double.parseDouble(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (3 == stringArray.length || 4 == stringArray.length) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                double d3 = Double.parseDouble(stringArray[2]);
                d2 = (double)n + (double)n2 / 60.0 + d3 / 3600.0;
                if (4 == stringArray.length && stringArray[3].equalsIgnoreCase(string2)) {
                    d2 = -d2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d2;
    }

    public static String formatSeconds(double d) {
        return numberFormatters[2].format(d);
    }

    public static String formatHeight(double d) {
        return numberFormatters[1].format(d);
    }

    public static String formatDistance(double d) {
        return numberFormatters[2].format(d);
    }

    public static String formatAzimuth(double d) {
        return numberFormatters[1].format(d);
    }

    public static String formatDepression(double d) {
        return numberFormatters[2].format(d);
    }

    public static String formatERP(double d) {
        if (d < 0.001) {
            return String.valueOf(d);
        }
        if (d < 0.9995) {
            return numberFormatters[3].format(d);
        }
        if (d < 9.995) {
            return numberFormatters[2].format(d);
        }
        if (d < 99.95) {
            return numberFormatters[1].format(d);
        }
        return numberFormatters[0].format(d);
    }

    public static String formatRelativeField(double d) {
        if (d < 0.001) {
            return String.valueOf(d);
        }
        return numberFormatters[3].format(d);
    }

    public static String formatField(double d) {
        return numberFormatters[1].format(d);
    }

    public static String formatDU(double d) {
        return numberFormatters[1].format(d);
    }

    public static String formatCount(int n) {
        return countFormatter.format(n);
    }

    public static String xmlclean(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static double computeDistance(double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7 = d * (Math.PI / 180);
        double d8 = d2 * (Math.PI / 180);
        double d9 = d3 * (Math.PI / 180);
        double d10 = d4 * (Math.PI / 180);
        for (d6 = d8 - d10; d6 < -Math.PI; d6 += Math.PI * 2) {
        }
        while (d6 > Math.PI) {
            d6 -= Math.PI * 2;
        }
        double d11 = Math.sin(d7) * Math.sin(d9) + Math.cos(d7) * Math.cos(d9) * Math.cos(d6);
        if (d11 < -1.0) {
            d11 = -1.0;
        }
        if (d11 > 1.0) {
            d11 = 1.0;
        }
        return Math.acos(d11) * 57.29577951308232 * d5;
    }

    public static void showWindow(Window window) {
        if (window instanceof StudyListEditor && !DbManager.canOpenStudyListEditor((StudyListEditor)window)) {
            return;
        }
        window.addWindowListener(manager);
        if (window instanceof JFrame) {
            ((JFrame)window).setDefaultCloseOperation(0);
        } else if (window instanceof JDialog) {
            ((JDialog)window).setDefaultCloseOperation(0);
        }
        if (window instanceof AppFrame) {
            AppFrame appFrame = (AppFrame)window;
            int n = -1;
            for (int i = 0; i < 10; ++i) {
                if (shortcutKeyInUse[i]) continue;
                n = i;
                AppManager.shortcutKeyInUse[i] = true;
                break;
            }
            appFrame.setShortcutKey(n);
            String string = appFrame.getBaseTitle();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (AppFrame appFrame2 : windowList) {
                if (!appFrame2.getBaseTitle().equals(string)) continue;
                arrayList.add(new Integer(appFrame2.getTitleKey()));
            }
            int n2 = appFrame.getLocation().x;
            int n3 = appFrame.getLocation().y;
            int n4 = appFrame.getTitleKey();
            if (arrayList.contains(new Integer(n4))) {
                n4 = 0;
                while (arrayList.contains(new Integer(n4))) {
                    ++n4;
                    n2 += 20;
                    n3 += 20;
                }
                appFrame.setTitleKey(n4);
            }
            if (appFrame.getLocationSaved()) {
                DbManager.restoreWindowLocation(appFrame, appFrame.getDbID(), appFrame.getKeyTitle(), n2, n3);
            }
            windowList.add(appFrame);
            appFrame.windowWillOpen();
        } else if (window instanceof AppDialog) {
            AppDialog appDialog = (AppDialog)window;
            if (appDialog.getLocationSaved()) {
                DbManager.restoreWindowLocation(appDialog, appDialog.getDbID(), appDialog.getKeyTitle(), appDialog.getLocation().x, appDialog.getLocation().y);
            }
            appDialog.windowWillOpen();
        }
        window.setVisible(true);
    }

    public static boolean hasOpenWindows() {
        return !windowList.isEmpty();
    }

    public static void hideWindow(Window window) {
        boolean bl = false;
        window.removeWindowListener(manager);
        if (window instanceof AppFrame) {
            AppFrame appFrame = (AppFrame)window;
            if (windowList.contains(appFrame)) {
                if (appFrame.getShortcutKey() >= 0) {
                    AppManager.shortcutKeyInUse[appFrame.getShortcutKey()] = false;
                }
                if (appFrame.getLocationSaved()) {
                    DbManager.saveWindowLocation(appFrame, appFrame.getDbID(), appFrame.getKeyTitle());
                }
                windowList.remove(appFrame);
                if (null != currentWindow && appFrame != currentWindow) {
                    manager.updateCurrentWindowMenu();
                }
                bl = windowList.isEmpty();
            }
            if (appFrame.getDisposeOnClose()) {
                appFrame.dispose();
            } else {
                appFrame.setVisible(false);
            }
        } else if (window instanceof AppDialog) {
            AppDialog appDialog = (AppDialog)window;
            if (appDialog.getLocationSaved()) {
                DbManager.saveWindowLocation(appDialog, appDialog.getDbID(), appDialog.getKeyTitle());
            }
            if (appDialog.getDisposeOnClose()) {
                appDialog.dispose();
            } else {
                appDialog.setVisible(false);
            }
        } else {
            window.setVisible(false);
        }
        if (window == currentWindow) {
            currentWindow = null;
        }
        if (window instanceof StudyListEditor) {
            DbManager.didCloseStudyListEditor((StudyListEditor)window);
        }
        if (bl) {
            DbManager.showLogin(true);
        } else if (DbManager.isLoginWindow(window) && windowList.isEmpty()) {
            try {
                localProperties.store(new FileOutputStream(DB_PROPS_FILE), "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public static void setComponentEnabled(Component component, boolean bl) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.setEditable(bl);
            if (bl) {
                jTextComponent.setBackground(Color.WHITE);
            } else {
                jTextComponent.setBackground(DISABLED_TEXT_BACKGROUND);
            }
        } else if (component instanceof JTable) {
            JTable jTable = (JTable)component;
            Container container = jTable.getParent();
            jTable.setEnabled(bl);
            if (bl) {
                container.setBackground(Color.WHITE);
                jTable.setBackground(Color.WHITE);
                jTable.setGridColor(Color.WHITE);
            } else {
                container.setBackground(DISABLED_TEXT_BACKGROUND);
                jTable.setBackground(DISABLED_TEXT_BACKGROUND);
                jTable.setGridColor(DISABLED_TEXT_BACKGROUND);
            }
        } else {
            component.setEnabled(bl);
        }
    }

    public static boolean isComponentEnabled(Component component) {
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).isEditable();
        }
        return component.isEnabled();
    }

    public static int getTextFieldWidth(int n) {
        if (0 == fieldSizeBaseWidth) {
            JTextField jTextField = new JTextField(1);
            JPanel jPanel = new JPanel();
            jPanel.add(jTextField);
            jPanel.doLayout();
            fieldSizeBaseWidth = jTextField.getWidth();
            jTextField.setColumns(2);
            jPanel.doLayout();
            fieldSizeWidthIncrement = jTextField.getWidth() - fieldSizeBaseWidth;
        }
        return fieldSizeBaseWidth + (n - 1) * fieldSizeWidthIncrement;
    }

    public static Dimension getLabelSize(int n) {
        if (0 == labelSizeWidthIncrement) {
            JLabel jLabel = new JLabel("XXXXXXXXXX");
            JPanel jPanel = new JPanel();
            jPanel.add(jLabel);
            jPanel.doLayout();
            labelSizeWidthIncrement = jLabel.getWidth() / 10;
            labelSizeHeight = jLabel.getHeight();
        }
        return new Dimension(n * labelSizeWidthIncrement, labelSizeHeight);
    }

    public static void fixKeyBindings(JComponent jComponent) {
        if (null == maps) {
            maps = new int[3];
            AppManager.maps[0] = 2;
            AppManager.maps[1] = 0;
            AppManager.maps[2] = 1;
            keys = new KeyStroke[4];
            AppManager.keys[0] = KeyStroke.getKeyStroke(9, 0);
            AppManager.keys[1] = KeyStroke.getKeyStroke(9, 1);
            AppManager.keys[2] = KeyStroke.getKeyStroke(38, MENU_SHORTCUT_KEY_MASK);
            AppManager.keys[3] = KeyStroke.getKeyStroke(40, MENU_SHORTCUT_KEY_MASK);
        }
        for (int n : maps) {
            for (InputMap inputMap = jComponent.getInputMap(n); null != inputMap; inputMap = inputMap.getParent()) {
                for (KeyStroke keyStroke : keys) {
                    inputMap.remove(keyStroke);
                }
            }
        }
        jComponent.setFocusTraversalKeys(0, null);
        jComponent.setFocusTraversalKeys(1, null);
    }

    public static void configureTable(JTable jTable) {
        AppManager.configureTable(jTable, null);
    }

    public static void configureTable(JTable jTable, EditMenu editMenu) {
        jTable.setFocusable(false);
        jTable.setColumnSelectionAllowed(false);
        jTable.getTableHeader().setReorderingAllowed(false);
        if (null != editMenu) {
            jTable.setSelectionMode(2);
            editMenu.setTargetTable(jTable);
        } else {
            jTable.setSelectionMode(0);
        }
    }

    public static JScrollPane createScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane(component, 22, 31);
        if (!(component instanceof JTable)) {
            jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        }
        return jScrollPane;
    }

    public static void showHelp() {
        try {
            Desktop.getDesktop().open(new File(System.getProperty("user.dir") + File.separator + "help" + File.separator + "manual.pdf"));
        }
        catch (Exception exception) {
            AppManager.showMessage("Cannot open the documentation file:\n" + exception.getMessage(), "Documentation Not Available", 0);
        }
    }

    public static void showAbout() {
        String string = "About TVStudy";
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        try {
            Process process = Runtime.getRuntime().exec(new String[]{System.getProperty("user.dir") + File.separator + "lib" + File.separator + "tvstudy", "-v"});
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string2 = bufferedReader.readLine();
            if (AppManager.convertVersionString(string2) < 0) {
                bl = true;
                string3 = "The engine process did not return a valid version number.";
            }
        }
        catch (Exception exception) {
            bl = true;
            string3 = exception.getMessage();
        }
        if (bl) {
            AppManager.showMessage("An error occurred while checking the study engine version:\n" + string3, string, 0);
            string2 = "(error)";
        }
        AppManager.showMessage("GUI Version 1.3\nEngine Version " + string2, string);
    }

    public static void showUpdate() {
        String string = "Check for Updates";
        QueryWorker<String> queryWorker = new QueryWorker<String>(null, string){

            @Override
            protected String doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                boolean bl = false;
                String string = "";
                String string2 = "";
                try {
                    URL uRL = new URL("http://data.fcc.gov/download/incentive-auctions/OET-69/version.txt");
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                    string = bufferedReader.readLine();
                    int n = AppManager.convertVersionString(string);
                    if (n < 0) {
                        bl = true;
                        string2 = "The update check did not return a valid version number.";
                    } else if (n <= AppManager.convertVersionString(AppManager.APP_VERSION)) {
                        string = "";
                    }
                }
                catch (Exception exception) {
                    bl = true;
                    string2 = exception.getMessage();
                }
                if (bl) {
                    errorReporter.reportWarning("An error occurred while checking for updates:\n" + string2 + "\nPlease check again later.");
                    return null;
                }
                return string;
            }
        };
        ErrorReporter errorReporter = new ErrorReporter(null, string);
        String string2 = (String)queryWorker.runQuery("Checking for updates, please wait...", errorReporter);
        if (null == string2) {
            return;
        }
        if (0 == string2.length()) {
            errorReporter.reportMessage("TVStudy is up to date.");
        } else {
            errorReporter.reportMessage("New version " + string2 + " of TVStudy is available.\n" + "Please visit the TVStudy website to download.");
        }
    }

    private static int convertVersionString(String string) {
        if (null == string || string.length() < 3) {
            return -1;
        }
        String[] stringArray = string.trim().split("\\.");
        if (stringArray.length < 2 || stringArray.length > 3) {
            return -1;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
            n2 = Integer.parseInt(stringArray[1]);
            if (stringArray.length > 2) {
                n3 = Integer.parseInt(stringArray[2]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (n < 1 || n2 < 0 || n2 > 99 || n3 < 0 || n3 > 999) {
            return -1;
        }
        return n * 100000 + n2 * 1000 + n3;
    }

    public static void checkInstall() {
        String string = System.getProperty("user.dir");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string + File.separator + "lib" + File.separator + "check_install");
        arrayList.add(string);
        AppManager.showWindow(new ToolRun("Installation Check", arrayList));
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void showMessage(Object object, String string) {
        AppManager.showMessage(null, object, string, 1);
    }

    public static void showMessage(Object object, String string, int n) {
        AppManager.showMessage(null, object, string, n);
    }

    public static void showMessage(Component component, Object object, String string) {
        AppManager.showMessage(component, object, string, 1);
    }

    public static void showMessage(Component component, Object object, String string, int n) {
        if (n != 1) {
            AppManager.beep();
        }
        JOptionPane.showMessageDialog(component, object, string, n);
    }

    public static void showLongMessage(String string, String string2) {
        AppManager.showLongMessage(null, string, string2, 1);
    }

    public static void showLongMessage(String string, String string2, int n) {
        AppManager.showLongMessage(null, string, string2, n);
    }

    public static void showLongMessage(Component component, String string, String string2) {
        AppManager.showLongMessage(component, string, string2, 1);
    }

    public static void showLongMessage(Component component, String string, String string2, int n) {
        JTextArea jTextArea = new JTextArea(15, 60);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        AppManager.setComponentEnabled(jTextArea, false);
        jTextArea.setText(string);
        AppManager.showMessage(component, AppManager.createScrollPane(jTextArea), string2, n);
    }

    private AppManager() {
        if (null != manager) {
            throw new RuntimeException("Application manager already exists");
        }
        manager = this;
        windowList = new ArrayList();
        shortcutKeyInUse = new boolean[10];
        for (int i = 0; i < 10; ++i) {
            AppManager.shortcutKeyInUse[i] = false;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (!keyEvent.isConsumed() && null != currentWindow && keyEvent.getID() == 401 && keyEvent.getModifiers() == MENU_SHORTCUT_KEY_MASK && keyEvent.getKeyCode() == 87) {
                    keyEvent.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            currentWindow.dispatchEvent(new WindowEvent(currentWindow, 201));
                        }
                    });
                    return true;
                }
                return false;
            }
        });
        ToolTipManager.sharedInstance().setDismissDelay(15000);
        if (Debug) {
            AppDialog appDialog = new AppDialog(null, "Debug Info", Dialog.ModalityType.MODELESS);
            Container container = appDialog.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add(new JLabel("maxMemory = " + Runtime.getRuntime().maxMemory()));
            final JLabel jLabel = new JLabel("totalMemory = ");
            container.add(jLabel);
            final JLabel jLabel2 = new JLabel("freeMemory = ");
            container.add(jLabel2);
            final JLabel jLabel3 = new JLabel("windowWidth = ");
            container.add(jLabel3);
            final JLabel jLabel4 = new JLabel("windowHeight = ");
            container.add(jLabel4);
            container.add(new JLabel("defaultCharset = " + Charset.defaultCharset().displayName()));
            appDialog.pack();
            AppManager.showWindow(appDialog);
            new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jLabel.setText("totalMemory = " + Runtime.getRuntime().totalMemory());
                    jLabel2.setText("freeMemory = " + Runtime.getRuntime().freeMemory());
                    Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                    if (null != window) {
                        jLabel3.setText("windowWidth = " + window.getWidth());
                        jLabel4.setText("windowHeight = " + window.getHeight());
                    }
                }
            }).start();
        }
        DbManager.showLogin(true);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window instanceof AppFrame && !((AppFrame)window).windowShouldClose() || window instanceof AppDialog && !((AppDialog)window).windowShouldClose()) {
            return;
        }
        AppManager.hideWindow(window);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        AppManager.hideWindow(windowEvent.getWindow());
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        currentWindow = windowEvent.getWindow();
        this.updateCurrentWindowMenu();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == currentWindow) {
            currentWindow = null;
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    private void updateCurrentWindowMenu() {
        if (!(currentWindow instanceof AppFrame)) {
            return;
        }
        JMenu jMenu = ((AppFrame)currentWindow).getWindowMenu();
        jMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Close Window");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null != currentWindow) {
                    currentWindow.dispatchEvent(new WindowEvent(currentWindow, 201));
                }
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, MENU_SHORTCUT_KEY_MASK));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Minimize");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null != currentWindow && currentWindow instanceof Frame) {
                    ((Frame)currentWindow).setExtendedState(1);
                }
            }
        });
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(77, MENU_SHORTCUT_KEY_MASK));
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Open Database...");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbManager.showLogin(false);
            }
        });
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(76, MENU_SHORTCUT_KEY_MASK));
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        for (AppFrame appFrame : windowList) {
            JMenuItem jMenuItem4;
            if (appFrame == currentWindow) {
                jMenuItem4 = new JCheckBoxMenuItem();
                jMenuItem4.setSelected(true);
            } else {
                jMenuItem4 = new JMenuItem();
            }
            appFrame.setWindowMenuItem(jMenuItem4);
            if (appFrame.getShortcutKey() >= 0) {
                jMenuItem4.setAccelerator(KeyStroke.getKeyStroke((int)Integer.toString(appFrame.getShortcutKey()).charAt(0), MENU_SHORTCUT_KEY_MASK));
            }
            final AppFrame appFrame2 = appFrame;
            jMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    appFrame2.toFront();
                }
            });
            jMenu.add(jMenuItem4);
        }
    }

    static {
        DB_PROPS_FILE = "lib" + File.separator + "tvstudy.props";
        manager = null;
        MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        DISABLED_TEXT_BACKGROUND = new Color(233, 233, 233);
        didInit = false;
        numberFormatters = new NumberFormat[4];
        minuteFormatter = null;
        for (int i = 0; i < 4; ++i) {
            AppManager.numberFormatters[i] = NumberFormat.getInstance();
            numberFormatters[i].setMinimumFractionDigits(i);
            numberFormatters[i].setMaximumFractionDigits(i);
            numberFormatters[i].setMinimumIntegerDigits(1);
            numberFormatters[i].setGroupingUsed(false);
        }
        minuteFormatter = NumberFormat.getInstance();
        minuteFormatter.setMinimumIntegerDigits(2);
        latLonPattern = Pattern.compile("\\s");
        countFormatter = null;
        countFormatter = NumberFormat.getIntegerInstance();
        countFormatter.setGroupingUsed(true);
        fieldSizeBaseWidth = 0;
        fieldSizeWidthIncrement = 0;
        labelSizeWidthIncrement = 0;
        labelSizeHeight = 0;
        maps = null;
        keys = null;
    }
}

