/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.util.EditMenu;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public abstract class AppFrame
extends JFrame {
    protected String baseTitle;
    protected int titleKey;
    protected String documentName;
    protected int shortcutKey;
    protected String keyTitle;
    protected String displayTitle;
    protected JMenu fileMenu;
    protected EditMenu editMenu;
    protected JMenu reportMenu;
    protected JMenu windowMenu;
    protected JMenu helpMenu;
    protected JMenuItem windowMenuItem;
    private boolean locationSaved;
    private boolean disposeOnClose;

    public AppFrame(String string) {
        super(string);
        this.baseTitle = string;
        this.shortcutKey = -1;
        this.keyTitle = string;
        this.displayTitle = string;
        if (this.showsFileMenu()) {
            this.fileMenu = new JMenu(this.getFileMenuName());
        }
        if (this.showsEditMenu()) {
            this.editMenu = new EditMenu();
        }
        if (this.showsReportMenu()) {
            this.reportMenu = new JMenu(this.getReportMenuName());
        }
        this.windowMenu = new JMenu("Window");
        this.helpMenu = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("About TVStudy");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(46, AppManager.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppManager.showAbout();
            }
        });
        this.helpMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Check for Updates");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppManager.showUpdate();
            }
        });
        this.helpMenu.add(jMenuItem2);
        this.helpMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Check Installation");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppManager.checkInstall();
            }
        });
        this.helpMenu.add(jMenuItem3);
        this.helpMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Documentation");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(47, AppManager.MENU_SHORTCUT_KEY_MASK));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppManager.showHelp();
            }
        });
        this.helpMenu.add(jMenuItem4);
        JMenuBar jMenuBar = new JMenuBar();
        if (null != this.fileMenu) {
            jMenuBar.add(this.fileMenu);
        }
        if (null != this.editMenu) {
            jMenuBar.add(this.editMenu);
        }
        if (null != this.reportMenu) {
            jMenuBar.add(this.reportMenu);
        }
        jMenuBar.add(this.windowMenu);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        this.locationSaved = true;
        this.disposeOnClose = true;
        this.setLocation(new Point(100, 40));
    }

    public String getDbID() {
        return null;
    }

    public String getBaseTitle() {
        return this.baseTitle;
    }

    public String getKeyTitle() {
        return this.keyTitle;
    }

    public String getDisplayTitle() {
        return this.displayTitle;
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public String getTitle() {
        return this.displayTitle;
    }

    public void setTitleKey(int n) {
        this.titleKey = n;
        this.updateTitles();
    }

    public int getTitleKey() {
        return this.titleKey;
    }

    public void setDocumentName(String string) {
        this.documentName = string;
        this.updateTitles();
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public void updateDocumentName() {
    }

    public void setShortcutKey(int n) {
        if (n < 0 || n > 9) {
            n = -1;
        }
        this.shortcutKey = n;
        this.updateTitles();
    }

    public int getShortcutKey() {
        return this.shortcutKey;
    }

    protected void updateTitles() {
        this.keyTitle = 0 == this.titleKey ? this.baseTitle : this.baseTitle + " " + this.titleKey;
        this.displayTitle = null == this.documentName || 0 == this.documentName.length() ? this.keyTitle : this.baseTitle + ": " + this.documentName;
        String string = this.displayTitle;
        if (this.shortcutKey >= 0) {
            string = 2 == AppManager.MENU_SHORTCUT_KEY_MASK ? string + "  Ctrl-" + this.shortcutKey : string + "  \u2318" + this.shortcutKey;
        }
        super.setTitle(string);
        if (null != this.windowMenuItem) {
            this.windowMenuItem.setText(this.displayTitle);
        }
    }

    protected boolean showsFileMenu() {
        return true;
    }

    protected String getFileMenuName() {
        return "File";
    }

    protected boolean showsEditMenu() {
        return true;
    }

    protected boolean showsReportMenu() {
        return false;
    }

    protected String getReportMenuName() {
        return "Report";
    }

    public JMenu getWindowMenu() {
        return this.windowMenu;
    }

    public void setWindowMenuItem(JMenuItem jMenuItem) {
        this.windowMenuItem = jMenuItem;
        if (null != jMenuItem) {
            jMenuItem.setText(this.displayTitle);
        }
    }

    public JMenuItem getWindowMenuItem() {
        return this.windowMenuItem;
    }

    public void setLocationSaved(boolean bl) {
        this.locationSaved = bl;
    }

    public boolean getLocationSaved() {
        return this.locationSaved;
    }

    public void setDisposeOnClose(boolean bl) {
        this.disposeOnClose = bl;
    }

    public boolean getDisposeOnClose() {
        return this.disposeOnClose;
    }

    public void windowWillOpen() {
    }

    public boolean windowShouldClose() {
        return true;
    }
}

