//
//  TVStudyServlet.java
//  TVStudy
//
//  Copyright (c) 2015 Hammett & Edison, Inc.  All rights reserved.

import gov.fcc.tvstudy.api.*;

import java.util.*;
import java.io.*;
import java.nio.file.*;

import javax.servlet.*;
import javax.servlet.http.*;


//=====================================================================================================================
// Java servlet interface to TVStudy.  See gov.fcc.tvstudy.core.APIOperation.java for details.

public class TVStudyServlet extends HttpServlet {


	//-----------------------------------------------------------------------------------------------------------------
	// When a servlet instance is started or stopped, inform APIOperation so it can do setup and tracking.  The
	// TVStudy core code needs the working directory path, the full TVStudy application is also installed in the
	// servlet installation directory.  The base directory for output files is the servlet public directory.

	public void init() throws ServletException {

		String basePath = getServletContext().getRealPath("/");
		if (basePath.endsWith(File.separator)) {
			basePath = basePath.substring(0, basePath.length() - File.separator.length());
		}
		String workPath = basePath + File.separator + "WEB-INF";

		String errorMessage = APIOperation.servletInit(this, workPath, basePath);
		if (null != errorMessage) {
			throw new ServletException(errorMessage);
		}
	}


	//-----------------------------------------------------------------------------------------------------------------

	public void destroy() {

		APIOperation.servletDestroy(this);
	}


	//-----------------------------------------------------------------------------------------------------------------
	// Handle an API request by GET or POST.  Create the operation, check status and send response accordingly.

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doGet(request, response);
    }

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {

		response.setContentType("text/html");
		PrintWriter out = response.getWriter();

		APIOperation operation = APIOperation.getOperation(request.getParameterMap());

		int status = APIOperation.STATUS_UNKNOWN;
		if (null != operation) {
			status = operation.getStatus();
			while (APIOperation.STATUS_CHAIN == status) {
				operation = operation.getChainOperation();
				if (null != operation) {
					status = operation.getStatus();
				} else {
					status = APIOperation.STATUS_UNKNOWN;
				}
			}
		}

		switch (status) {

			case APIOperation.STATUS_UNKNOWN:
			default: {
				out.write(APIOperation.makeErrorPage("Error: Could not determine operation status"));
				break;
			}

			case APIOperation.STATUS_ERROR: {
				out.write(APIOperation.makeErrorPage(operation.getErrorMessage()));
				break;
			}

			case APIOperation.STATUS_PAGE: {
				out.write(operation.getResultPage());
				break;
			}

			case APIOperation.STATUS_URL: {
				String theURL = operation.getResultURL();
				response.setHeader("Refresh", "0; url=" + theURL);
				out.write("<html>\n<head>\n<title>Request Submitted</title>\n</head>\n<body>\n<a href=\"" + theURL +
					"\">Result</a>\n</body>\n</html>\n");
				break;
			}
		}

		out.flush();
    }
}
