// fix_application.c
// 25Nov2014

// Fix an application.dat file downloaded prior to December, 2014 so it can be imported by TVStudy.  This simply adds
// one additional empty field just before the last_change_date field.  The new filed is app_code and indicates records
// added through LMS, but older downloads do not contain those records so the field should always be blank.  Takes the
// input and output file names on the command line, aborts on any error.

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

int main(int argc, char **argv) {

	FILE *in, *out;

	if (argc != 3) {
		fprintf(stderr, "usage: %s infile outfile\n", argv[0]);
		exit(1);
	}

	if (NULL == (in = fopen(argv[1], "r"))) {
		fprintf(stderr, "%s: cannot open input file '%s'\n", argv[0], argv[1]);
		exit(1);
	}

	if (NULL == (out = fopen(argv[2], "w"))) {
		fprintf(stderr, "%s: cannot open output file '%s'\n", argv[0], argv[2]);
		exit(1);
	}

	int c, nbar = 0;
	while (EOF != (c = getc(in))) {
		if (('\n' == c) || ('\r' == c)) {
			nbar = 0;
		} else {
			if ('|' == c) {
				if (24 == ++nbar) {
					putc('|', out);
				}
			}
		}
		putc(c, out);
	}

	fclose(in);
	fclose(out);

	exit(0);
}
