/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.dbutil;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.StatusLogger;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.Properties;

public class DbUtil {
    private static final int SHOW_STATUS = 1;
    private static final int INSTALL_DATABASE = 2;
    private static final int UPDATE_DATABASE = 3;
    private static final int RELOAD_ROOT_DATA = 4;
    private static final int UNINSTALL_DATABASE = 5;
    private static final int DOWNLOAD_DATA_SET = 6;
    private static final int IMPORT_DATA_SET = 7;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        int n;
        AppCore.initialize(System.getProperty("user.dir"), true, false);
        Properties properties = new Properties();
        try {
            properties.load(Files.newInputStream(AppCore.libDirectoryPath.resolve("dbutil.props"), new OpenOption[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = properties.getProperty("host");
        String string2 = properties.getProperty("name");
        String string3 = properties.getProperty("user");
        String string4 = properties.getProperty("password");
        if (null == string2 || 0 == string2.length()) {
            string2 = "tvstudy";
        }
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < stringArray.length && '-' == stringArray[n].charAt(0); ++n) {
            switch (stringArray[n].charAt(1)) {
                case 'h': {
                    if (++n < stringArray.length) {
                        string = stringArray[n];
                        break;
                    }
                    bl2 = true;
                    break;
                }
                case 'd': {
                    if (++n < stringArray.length) {
                        string2 = stringArray[n];
                        break;
                    }
                    bl2 = true;
                    break;
                }
                case 'u': {
                    if (++n < stringArray.length) {
                        string3 = stringArray[n];
                        break;
                    }
                    bl2 = true;
                    break;
                }
                case 'q': {
                    bl = true;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
            if (bl2) break;
        }
        int n2 = 0;
        if (!bl2) {
            if (n >= stringArray.length) {
                bl2 = true;
            } else if (stringArray[n].equalsIgnoreCase("status")) {
                n2 = 1;
            } else if (stringArray[n].equalsIgnoreCase("install")) {
                n2 = 2;
            } else if (stringArray[n].equalsIgnoreCase("update")) {
                n2 = 3;
            } else if (stringArray[n].equalsIgnoreCase("reloadroot")) {
                n2 = 4;
            } else if (stringArray[n].equalsIgnoreCase("uninstall")) {
                n2 = 5;
            } else if (stringArray[n].equalsIgnoreCase("download")) {
                n2 = 6;
            } else if (stringArray[n].equalsIgnoreCase("import")) {
                n2 = 7;
            } else {
                bl2 = true;
            }
        }
        int n3 = 0;
        if (!(bl2 || 6 != n2 && 7 != n2)) {
            if (++n >= stringArray.length) {
                bl2 = true;
            } else if (stringArray[n].equalsIgnoreCase("LMS") || stringArray[n].equalsIgnoreCase("LMSTV")) {
                n3 = 2;
            } else if (6 == n2) {
                bl2 = true;
            } else if (stringArray[n].equalsIgnoreCase("CDBSFM")) {
                n3 = 4;
            } else if (stringArray[n].equalsIgnoreCase("CDBSTV")) {
                n3 = 1;
            } else {
                bl2 = true;
            }
        }
        File file = null;
        if (!bl2 && 7 == n2) {
            if (++n >= stringArray.length) {
                bl2 = true;
            } else {
                file = new File(stringArray[n]);
            }
        }
        if (bl2) {
            if (bl) {
                System.out.print("ERROR: invalid command line format\n");
                return;
            }
            System.out.print("\nDbUtil v2.3.0 (PH1km1)\n\n");
            System.out.print("Usage:\n");
            System.out.print("  dbutil [ -h host ] [ -d name ] [ -u user ] [ -q ] command [ arguments ]\n\n");
            System.out.print("Options:\n");
            System.out.print("  -h host\n");
            System.out.print("    Set database server host name.\n");
            System.out.print("  -d name\n");
            System.out.print("    Set root database name.\n");
            System.out.print("  -u user\n");
            System.out.print("    Set login user name.\n");
            System.out.print("  -q\n");
            System.out.print("    Quiet mode, no status messages.\n\n");
            System.out.print("Host, name, user, and password may be specified in lib/dbutil.props file,\n");
            System.out.print("options will individually override properties.  If a password is not set\n");
            System.out.print("in properties an interactive prompt will appear.  Option -q prevents the\n");
            System.out.print("prompt so the password must be in properties.  Host, user, and password\n");
            System.out.print("must be provided.  If name is not provided a default is used.\n\n");
            System.out.print("Commands and arguments:\n");
            System.out.print("  status\n");
            System.out.print("    Show database status.\n");
            System.out.print("  install\n");
            System.out.print("    Install new database.\n");
            System.out.print("  update\n");
            System.out.print("    Update database.\n");
            System.out.print("  reloadroot\n");
            System.out.print("    Reload root database table data.\n");
            System.out.print("    Use this command only as instructed by technical support.\n");
            System.out.print("  uninstall\n");
            System.out.print("    Delete database and cache files.\n");
            System.out.print("  download type\n");
            System.out.print("    Download and import data set files.\n");
            System.out.print("    type: lms\n");
            System.out.print("  import type path\n");
            System.out.print("    Import data set files.\n");
            System.out.print("    type: lms cdbstv cdbsfm\n");
            System.out.print("    path: file directory or ZIP file\n");
            return;
        }
        if (null == string || null == string2 || null == string3) {
            System.out.print("ERROR: Missing database login information\n");
            return;
        }
        if (null == string4 && !bl && null != (object = System.console())) {
            string4 = new String(((Console)object).readPassword("Enter password:", new Object[0]));
        }
        if (null == string4) {
            System.out.print("ERROR: Missing database login information\n");
            return;
        }
        object = new ErrorLogger(new PrintStream(System.out));
        StatusLogger statusLogger = null;
        if (!bl) {
            statusLogger = new StatusLogger(){

                @Override
                public void reportStatus(String string) {
                    System.out.print(string + "\n");
                }

                @Override
                public void logMessage(String string) {
                    System.out.print(string + "\n");
                }

                @Override
                public void showMessage(String string) {
                }

                @Override
                public boolean isCanceled() {
                    return false;
                }
            };
        }
        DbCore.DbInfo dbInfo = new DbCore.DbInfo(string, string2, string3, string4, (ErrorLogger)object);
        if (dbInfo.connectionFailed) {
            if (!((ErrorLogger)object).hasErrors()) {
                System.out.print("ERROR: " + dbInfo.setupError + "\n");
            }
            return;
        }
        switch (n2) {
            case 1: {
                System.out.print("    Host: " + dbInfo.dbHostname + "\n");
                System.out.print("Database: " + dbInfo.dbName + "\n");
                System.out.print(" Version: " + AppCore.formatVersion(dbInfo.version) + "\n");
                System.out.print("  Status: " + dbInfo.statusText + "\n");
                dbInfo.updateCacheSize();
                String string5 = "Empty";
                if (dbInfo.cacheSize > 0L) {
                    string5 = (double)dbInfo.cacheSize >= 1.0E9 ? String.format(Locale.US, "%.2f GB", (double)dbInfo.cacheSize / 1.0E9) : ((double)dbInfo.cacheSize >= 1000000.0 ? String.format(Locale.US, "%.1f MB", (double)dbInfo.cacheSize / 1000000.0) : String.format(Locale.US, "%.0f kB", (double)dbInfo.cacheSize / 1000.0));
                }
                System.out.print("   Cache: " + string5 + "\n");
                break;
            }
            case 2: {
                if (dbInfo.canOpen) {
                    if (bl) break;
                    System.out.print("Database is already installed\n");
                    break;
                }
                if (!dbInfo.canInstall) {
                    System.out.print("ERROR: Database installed but not usable: " + dbInfo.setupError + "\n");
                    break;
                }
                DbCore.installDb(dbInfo, statusLogger, (ErrorLogger)object);
                break;
            }
            case 3: {
                if (dbInfo.canOpen) {
                    if (bl) break;
                    System.out.print("Database is up to date\n");
                    break;
                }
                if (!dbInfo.canUpdate) {
                    System.out.print("ERROR: Database cannot be updated: " + dbInfo.setupError + "\n");
                    break;
                }
                DbCore.updateDb(dbInfo, statusLogger, (ErrorLogger)object);
                break;
            }
            case 4: {
                if (!dbInfo.canOpen) {
                    System.out.print("ERROR: Root data cannot be reloaded: " + dbInfo.setupError + "\n");
                    break;
                }
                DbCore.updateRootData(dbInfo, (ErrorLogger)object);
                break;
            }
            case 5: {
                if (!dbInfo.canUninstall) {
                    if (bl) break;
                    System.out.print("Database is not installed\n");
                    break;
                }
                Console console = System.console();
                if (bl || null == console) {
                    System.out.print("ERROR: Uninstall command requires interactive confirmation\n");
                    break;
                }
                String string6 = console.readLine("Are you sure you want to uninstall database '%s' on '%s' <No>? ", dbInfo.dbName, dbInfo.dbHostname);
                if (!string6.startsWith("y") && !string6.startsWith("Y")) break;
                DbCore.uninstallDb(dbInfo, (ErrorLogger)object);
                break;
            }
            case 6: {
                if (!DbCore.registerDb(dbInfo, statusLogger, (ErrorLogger)object)) break;
                ExtDb.downloadDatabase(dbInfo.dbID, n3, "", statusLogger, (ErrorLogger)object);
                DbCore.closeDb(dbInfo.dbID, null);
                break;
            }
            case 7: {
                if (!DbCore.registerDb(dbInfo, statusLogger, (ErrorLogger)object)) break;
                ExtDb.createNewDatabase(dbInfo.dbID, n3, file, "", statusLogger, (ErrorLogger)object);
                DbCore.closeDb(dbInfo.dbID, null);
            }
        }
    }
}

