/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.run;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.BackgroundWorker;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.StudyLockHolder;
import gov.fcc.tvstudy.gui.StudyManager;
import gov.fcc.tvstudy.gui.run.RunPanel;
import gov.fcc.tvstudy.gui.run.RunPanelPairStudy;
import gov.fcc.tvstudy.gui.run.RunStart;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RunStartPairStudy
extends RunStart {
    public static final String WINDOW_TITLE = "Pair Study Run";
    private RunPanelPairStudy runPanel;
    private KeyedRecordMenu studyCountryMenu;
    private JTextField studyChannelsField;
    private JComboBox<String> runCountMenu;

    public RunStartPairStudy(StudyManager studyManager) {
        super(studyManager, WINDOW_TITLE);
        this.runPanel = new RunPanelPairStudy(studyManager, studyManager.getDbID());
        this.studyCountryMenu = new KeyedRecordMenu(Country.getCountries());
        this.studyCountryMenu.addItem(new KeyedRecord(0, "All countries"));
        this.studyChannelsField = new JTextField(20);
        AppController.fixKeyBindings(this.studyChannelsField);
        this.runCountMenu = new JComboBox();
        this.runCountMenu.setFocusable(false);
        this.runCountMenu.addItem("1");
        for (int i = 2; i <= AppCore.maxEngineProcessCount; ++i) {
            this.runCountMenu.addItem(String.valueOf(i));
        }
        JLabel jLabel = new JLabel("Study country");
        JLabel jLabel2 = new JLabel("Study channel(s)");
        JLabel jLabel3 = new JLabel("Max study processes");
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        jPanel.setLayout(groupLayout);
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup parallelGroup2 = groupLayout.createParallelGroup();
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        parallelGroup.addComponent(jLabel);
        parallelGroup2.addComponent(this.studyCountryMenu);
        sequentialGroup.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.studyCountryMenu));
        parallelGroup.addComponent(jLabel2);
        parallelGroup2.addComponent(this.studyChannelsField);
        sequentialGroup.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.studyChannelsField));
        parallelGroup.addComponent(jLabel3);
        parallelGroup2.addComponent(this.runCountMenu);
        sequentialGroup.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.runCountMenu));
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(parallelGroup).addGroup(parallelGroup2));
        groupLayout.setVerticalGroup(sequentialGroup);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel2);
        jPanel3.add(this.optionsPanel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel3, "Center");
        container.add((Component)this.buttonPanel, "South");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    @Override
    public boolean setStudy(int n, ErrorReporter errorReporter) {
        if (this.isVisible() || null != this.runPanel.studyBuild.baseStudy) {
            return false;
        }
        final int n2 = n;
        BackgroundWorker<Study> backgroundWorker = new BackgroundWorker<Study>((Window)this, WINDOW_TITLE){

            @Override
            protected Study doBackgroundWork(ErrorLogger errorLogger) {
                return Study.getStudy((String)RunStartPairStudy.this.getDbID(), (int)n2, (ErrorLogger)errorLogger);
            }
        };
        Study study = (Study)backgroundWorker.runWork("Opening study, please wait...", this.errorReporter);
        if (null == study) {
            return false;
        }
        this.runPanel.studyBuild.baseStudy = study;
        this.runPanel.studyKey = study.key;
        this.runPanel.studyName = study.name;
        this.runPanel.studyType = study.studyType;
        this.runPanel.studyLock = study.studyLock;
        this.runPanel.lockCount = study.lockCount;
        this.updateDocumentName();
        return true;
    }

    @Override
    public RunPanel getRunPanel() {
        return this.runPanel;
    }

    @Override
    public StudyLockHolder getStudyLockHolder() {
        return this.runPanel;
    }

    @Override
    protected void doReset() {
        super.doReset();
        this.studyCountryMenu.setSelectedIndex(0);
        this.studyChannelsField.setText("");
        this.runCountMenu.setSelectedIndex(0);
    }

    @Override
    protected boolean validateInput() {
        Object object;
        if (!super.validateInput()) {
            return false;
        }
        this.runPanel.fileOutputConfig = this.optionsPanel.fileOutputConfig;
        this.runPanel.mapOutputConfig = this.optionsPanel.mapOutputConfig;
        this.runPanel.studyBuild.studyCountry = 0 == this.studyCountryMenu.getSelectedKey() ? null : (Country)this.studyCountryMenu.getSelectedItem();
        boolean bl = false;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        String string = this.studyChannelsField.getText().trim();
        if (string.length() > 0) {
            object = string.split(",");
            String[] stringArray = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (String string2 : object) {
                if (string2.contains("-")) {
                    stringArray = string2.split("-");
                    if (2 == stringArray.length) {
                        try {
                            n2 = Integer.parseInt(stringArray[0].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = true;
                        }
                        if (bl) break;
                        if (n2 < 2 || n2 > 69) {
                            bl = true;
                            break;
                        }
                        try {
                            n3 = Integer.parseInt(stringArray[1].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = true;
                        }
                        if (bl) break;
                        if (n3 < 2 || n3 > 69) {
                            bl = true;
                            break;
                        }
                        if (n2 <= n3) {
                            for (n = n2; n <= n3; ++n) {
                                treeSet.add(n);
                            }
                            continue;
                        }
                        for (n = n3; n <= n2; ++n) {
                            treeSet.add(n);
                        }
                        continue;
                    }
                    bl = true;
                    break;
                }
                try {
                    n = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                if (bl) break;
                if (n < 2 || n > 69) {
                    bl = true;
                    break;
                }
                treeSet.add(n);
            }
        } else {
            bl = true;
        }
        if (bl || treeSet.isEmpty()) {
            this.errorReporter.reportWarning("Please enter valid study channels\nUse commas and dashes for multiple channels and ranges");
            return false;
        }
        this.runPanel.studyBuild.studyChannels = new int[treeSet.size()];
        object = treeSet.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.runPanel.studyBuild.studyChannels[n++] = (Integer)object.next();
        }
        this.runPanel.studyBuild.runCount = this.runCountMenu.getSelectedIndex() + 1;
        if (this.runPanel.studyBuild.runCount < 1) {
            this.runPanel.studyBuild.runCount = 1;
        }
        if (this.runPanel.memoryFraction < 1.0) {
            AppController.beep();
            if (0 != JOptionPane.showConfirmDialog(this, "Running a pair study with less than maximum memory is not recommended.\nThe memory use limit does not apply to the post-processing phase of the\nstudy.  If the study area is large, that phase may need all memory.\nDo you want to start this run anyway?", this.getBaseTitle(), 0, 2)) {
                return false;
            }
        }
        return true;
    }
}

