/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.run;

import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.OptionsPanel;
import gov.fcc.tvstudy.gui.StudyLockHolder;
import gov.fcc.tvstudy.gui.run.RunPanel;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class RunStart
extends AppDialog
implements StudyLockHolder {
    protected OptionsPanel optionsPanel = new OptionsPanel.RunStart(this);
    protected JPanel buttonPanel;

    protected RunStart(AppEditor appEditor, String string) {
        super(appEditor, null, string, Dialog.ModalityType.MODELESS);
        this.optionsPanel.setParent(this);
        JButton jButton = new JButton("Clear");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunStart.this.doReset();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunStart.this.cancel();
            }
        });
        JButton jButton3 = new JButton("Run");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunStart.this.doApply();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(jPanel);
        this.buttonPanel.add(jPanel2);
        this.getRootPane().setDefaultButton(jButton3);
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public void updateDocumentName() {
        StudyLockHolder studyLockHolder = this.getStudyLockHolder();
        String string = this.parent.getDocumentName();
        if (null != studyLockHolder && studyLockHolder.getStudyKey() > 0) {
            string = null == string ? studyLockHolder.getStudyName() : string + "/" + studyLockHolder.getStudyName();
        }
        this.setDocumentName(string);
    }

    public abstract boolean setStudy(int var1, ErrorReporter var2);

    public abstract RunPanel getRunPanel();

    public abstract StudyLockHolder getStudyLockHolder();

    @Override
    public int getStudyKey() {
        StudyLockHolder studyLockHolder = this.getStudyLockHolder();
        if (null != studyLockHolder) {
            return studyLockHolder.getStudyKey();
        }
        return 0;
    }

    @Override
    public String getStudyName() {
        StudyLockHolder studyLockHolder = this.getStudyLockHolder();
        if (null != studyLockHolder) {
            return studyLockHolder.getStudyName();
        }
        return "New study";
    }

    @Override
    public int getStudyLock() {
        StudyLockHolder studyLockHolder = this.getStudyLockHolder();
        if (null != studyLockHolder) {
            return studyLockHolder.getStudyLock();
        }
        return 0;
    }

    @Override
    public int getLockCount() {
        StudyLockHolder studyLockHolder = this.getStudyLockHolder();
        if (null != studyLockHolder) {
            return studyLockHolder.getLockCount();
        }
        return 0;
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    @Override
    public boolean closeWithoutSave() {
        return this.cancel();
    }

    @Override
    public boolean studyManagerClosing() {
        return false;
    }

    protected void doReset() {
        this.optionsPanel.clearFields();
    }

    protected boolean validateInput() {
        RunPanel runPanel = this.getRunPanel();
        if (null == runPanel || runPanel.isInitialized()) {
            return false;
        }
        if (!this.optionsPanel.validateInput()) {
            return false;
        }
        runPanel.memoryFraction = this.optionsPanel.memoryFraction;
        runPanel.runComment = this.optionsPanel.comment;
        return true;
    }

    protected void doApply() {
        if (!this.validateInput()) {
            return;
        }
        RunPanel runPanel = this.getRunPanel();
        if (!runPanel.initialize(this.errorReporter)) {
            this.cancel();
            return;
        }
        if (!runPanel.isDiskSpaceAvailable()) {
            AppController.beep();
            if (0 != JOptionPane.showConfirmDialog(this, "There may not be enough free disk space to complete this study run.\nDo you want to start this run anyway?", this.getBaseTitle(), 0, 2)) {
                return;
            }
        }
        if (this.parent.applyEditsFrom(this)) {
            AppController.hideWindow(this);
            return;
        }
        this.cancel();
    }

    @Override
    public void windowWillOpen() {
        this.optionsPanel.windowWillOpen();
        this.blockActionsClear();
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        this.optionsPanel.windowWillClose();
        this.blockActionsSet();
        this.parent.editorClosing(this);
    }
}

