/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.run;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.AppTask;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.run.RunPanel;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.DefaultCaret;

public abstract class RunPanelThread
extends RunPanel
implements StatusLogger {
    public static final int TEXT_AREA_ROWS = 15;
    public static final int TEXT_AREA_COLUMNS = 80;
    public String dbID;
    private JTextArea outputArea;
    private boolean lastLineWasTransient;
    private int lastOutputLineStart;
    private JViewport outputViewport;
    private int autoScrollState;
    private boolean autoScrollLock;
    private JLabel statusLabel;
    private JButton cancelButton;
    private JPanel statusPanel;
    private JTextArea reportArea;
    private JScrollPane reportPane;
    private boolean reportPaneAdded;
    private JTabbedPane tabPane;
    private static final int RUN_STATE_INIT = 0;
    private static final int RUN_STATE_WAIT = 1;
    private static final int RUN_STATE_RUNNING = 2;
    private static final int RUN_STATE_CANCELING = 3;
    private static final int RUN_STATE_EXITING = 4;
    private static final int RUN_STATE_EXIT = 5;
    private int runState = 0;
    private boolean runFailed;
    private boolean runCanceled;
    private String runStatus;
    private AppTask task;
    private boolean taskWaiting;
    private ErrorLogger runErrors;
    private String runStatusPending;
    private StringBuilder runMessageLog;
    private StringBuilder runReport;
    private Thread runThread;
    private Object runResult;
    private RunPanelThread outerThis = this;

    public RunPanelThread(String string) {
        this.runName = string;
    }

    public RunPanelThread(String string, String string2) {
        this.runName = string;
        this.dbID = string2;
    }

    public RunPanelThread(String string, Runnable runnable) {
        super(runnable);
        this.runName = string;
    }

    public RunPanelThread(String string, Runnable runnable, String string2) {
        super(runnable);
        this.runName = string;
        this.dbID = string2;
    }

    @Override
    public boolean initialize(ErrorReporter errorReporter) {
        if (this.initialized) {
            return true;
        }
        if (0 != this.runState) {
            this.runState = 5;
            this.runFailed = true;
            return false;
        }
        this.runState = 5;
        this.runFailed = true;
        if (!super.initialize(errorReporter)) {
            return false;
        }
        if (null != this.dbID && !DbCore.openDb((String)this.dbID, (Object)this)) {
            errorReporter.reportError("Invalid database connection ID");
            return false;
        }
        this.task = new AppTask(this.memoryFraction);
        this.outputArea = new JTextArea(15, 80);
        this.outputArea.setFont(new Font("Monospaced", 0, 12));
        AppController.fixKeyBindings(this.outputArea);
        this.outputArea.setEditable(false);
        this.outputArea.setLineWrap(true);
        ((DefaultCaret)this.outputArea.getCaret()).setUpdatePolicy(1);
        JScrollPane jScrollPane = AppController.createScrollPane(this.outputArea);
        this.outputViewport = jScrollPane.getViewport();
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                boolean bl;
                if (RunPanelThread.this.autoScrollLock) {
                    return;
                }
                if (((RunPanelThread)RunPanelThread.this).outputViewport.getViewSize().height <= ((RunPanelThread)RunPanelThread.this).outputViewport.getExtentSize().height) {
                    RunPanelThread.this.autoScrollState = 0;
                }
                if (0 == RunPanelThread.this.autoScrollState) {
                    return;
                }
                Adjustable adjustable = adjustmentEvent.getAdjustable();
                boolean bl2 = bl = adjustable.getMaximum() - adjustable.getVisibleAmount() - adjustmentEvent.getValue() < 10;
                if (1 == RunPanelThread.this.autoScrollState) {
                    if (!bl) {
                        RunPanelThread.this.autoScrollState = 2;
                    }
                } else if (bl) {
                    RunPanelThread.this.autoScrollState = 1;
                }
            }
        });
        if (this.showReportTab()) {
            this.reportArea = new JTextArea(15, 80);
            this.reportArea.setFont(new Font("Monospaced", 0, 12));
            AppController.fixKeyBindings(this.reportArea);
            this.reportArea.setEditable(false);
            this.reportArea.setLineWrap(true);
            this.reportPane = AppController.createScrollPane(this.reportArea);
            this.tabPane = new JTabbedPane();
            this.tabPane.addTab("Run", jScrollPane);
        }
        this.statusLabel = new JLabel("Starting...");
        this.statusLabel.setPreferredSize(AppController.labelSize[60]);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunPanelThread.this.cancel();
            }
        });
        this.cancelButton.setEnabled(false);
        this.statusPanel = new JPanel(new FlowLayout(0));
        this.statusPanel.add(this.cancelButton);
        this.statusPanel.add(this.statusLabel);
        this.setLayout(new BorderLayout());
        if (null != this.tabPane) {
            this.add((Component)this.tabPane, "Center");
        } else {
            this.add((Component)jScrollPane, "Center");
        }
        this.add((Component)this.statusPanel, "South");
        this.runState = 1;
        this.runFailed = false;
        this.initialized = true;
        return true;
    }

    protected boolean showReportTab() {
        return false;
    }

    @Override
    public String getDbID() {
        return this.dbID;
    }

    public abstract Object runActivity(StatusLogger var1, ErrorLogger var2);

    protected void cleanup(ErrorLogger errorLogger) {
    }

    public Object getResult() {
        return this.runResult;
    }

    @Override
    public void poll() {
        if (!this.initialized) {
            return;
        }
        if (5 == this.runState) {
            return;
        }
        this.cancelButton.setEnabled(!this.runCanceled && this.canCancel());
        if (1 == this.runState) {
            if (this.runCanceled) {
                this.runState = 4;
            } else {
                if (!AppTask.canTaskStart((AppTask)this.task)) {
                    if (!this.taskWaiting) {
                        this.taskWaiting = true;
                        this.statusLabel.setText("Waiting for other runs to complete...");
                    }
                    return;
                }
                this.taskWaiting = false;
                this.runErrors = new ErrorLogger();
                this.runStatusPending = null;
                this.runMessageLog = new StringBuilder();
                this.runReport = new StringBuilder();
                this.runThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            RunPanelThread.this.runResult = RunPanelThread.this.runActivity(RunPanelThread.this.outerThis, RunPanelThread.this.runErrors);
                        }
                        catch (Throwable throwable) {
                            AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
                            RunPanelThread.this.runErrors.reportError("Unexpected error:\n" + throwable);
                        }
                        if (null == RunPanelThread.this.runResult) {
                            RunPanelThread.this.runFailed = !RunPanelThread.this.runCanceled;
                        }
                        if (RunPanelThread.this.runErrors.hasMessages()) {
                            RunPanelThread.this.logMessage(RunPanelThread.this.runErrors.getMessages());
                            RunPanelThread.this.runErrors.clearMessages();
                        }
                        if (RunPanelThread.this.runErrors.hasErrors()) {
                            RunPanelThread.this.logMessage(RunPanelThread.this.runErrors.toString());
                        }
                    }
                };
                this.runThread.start();
                this.runState = 2;
                this.statusLabel.setText("Starting...");
                this.runStatus = "Starting";
            }
        }
        this.doUpdate();
        if (2 == this.runState && this.runCanceled) {
            this.statusLabel.setText("Canceling...");
            this.runState = 3;
            this.cancelButton.setEnabled(false);
        }
        if (null != this.runThread && this.runThread.isAlive()) {
            return;
        }
        this.runState = 5;
        this.cancelButton.setEnabled(false);
        this.doUpdate();
        if (this.runFailed) {
            this.statusLabel.setText("Failed");
        } else if (this.runCanceled) {
            this.statusLabel.setText("Canceled");
        } else {
            this.statusLabel.setText("Complete");
        }
        this.cleanup(this.errorReporter);
        if (null != this.callBack) {
            this.callBack.run();
        }
        if (null != this.task) {
            AppTask.taskDone((AppTask)this.task);
            this.task = null;
        }
        if (null != this.dbID) {
            DbCore.closeDb((String)this.dbID, (Object)this);
            this.dbID = null;
        }
    }

    public synchronized void reportStatus(String string) {
        this.runStatusPending = string;
    }

    public synchronized void logMessage(String string) {
        this.runMessageLog.append(string + "\n");
    }

    public synchronized void showMessage(String string) {
        this.runMessageLog.append(string + "\r");
    }

    protected synchronized void reportMessage(String string) {
        this.runReport.append(string + "\n");
    }

    private synchronized void doUpdate() {
        if (null != this.runStatusPending) {
            this.runStatus = this.runStatusPending;
            this.runStatusPending = null;
            if (!this.runCanceled) {
                this.statusLabel.setText(this.runStatus + "...");
            }
        }
        if (this.runMessageLog.length() > 0) {
            this.displayMessage(this.runMessageLog.toString());
            this.runMessageLog.setLength(0);
        }
        if (this.runReport.length() > 0) {
            if (null != this.tabPane) {
                if (!this.reportPaneAdded) {
                    this.tabPane.add("Report", this.reportPane);
                    this.reportPaneAdded = true;
                }
                this.reportArea.append(this.runReport.toString());
            }
            this.runReport.setLength(0);
        }
    }

    private void displayMessage(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        String string2 = null;
        while (n < n3) {
            char c;
            while ('\n' != (c = string.charAt(n2)) && '\r' != c && ++n2 < n3) {
            }
            if (n2 <= n) {
                n = ++n2;
                continue;
            }
            string2 = n2 < n3 ? string.substring(n, ++n2) : string.substring(n, n2) + "\n";
            n = n2;
            int n4 = this.outputArea.getDocument().getLength();
            if (this.lastLineWasTransient) {
                this.outputArea.replaceRange(string2, this.lastOutputLineStart, n4);
            } else {
                this.lastOutputLineStart = n4;
                this.outputArea.append(string2);
            }
            this.lastLineWasTransient = '\r' == c;
        }
        this.autoScrollLock = true;
        this.outputViewport.validate();
        if (this.outputViewport.getViewSize().height <= this.outputViewport.getExtentSize().height) {
            this.autoScrollState = 0;
        } else {
            if (0 == this.autoScrollState) {
                this.autoScrollState = 1;
            }
            if (1 == this.autoScrollState) {
                this.outputViewport.scrollRectToVisible(new Rectangle(0, this.outputViewport.getViewSize().height - 1, 1, 1));
            }
        }
        this.autoScrollLock = false;
    }

    public boolean isCanceled() {
        return this.runCanceled;
    }

    @Override
    public boolean isRunning() {
        return 5 != this.runState;
    }

    @Override
    public boolean isWaiting() {
        return 1 == this.runState;
    }

    @Override
    public void bumpTask() {
        if (1 == this.runState && null != this.task) {
            AppTask.bumpTask((AppTask)this.task);
        }
    }

    @Override
    public boolean runFailed() {
        return this.runFailed;
    }

    @Override
    public void cancel() {
        if (this.runCanceled || !this.canCancel()) {
            return;
        }
        this.runCanceled = true;
        this.cancelButton.setEnabled(false);
    }

    @Override
    public String getStatus() {
        switch (this.runState) {
            case 0: 
            case 1: {
                return "Waiting";
            }
            case 2: {
                return this.runStatus;
            }
            case 3: {
                return "Canceling";
            }
            case 4: {
                return "Exiting";
            }
            case 5: {
                if (this.runFailed) {
                    return "Failed";
                }
                if (this.runCanceled) {
                    return "Canceled";
                }
                return "Complete";
            }
        }
        return "Unknown";
    }

    @Override
    public boolean hasOutput() {
        if (this.isRunning()) {
            return false;
        }
        return this.outputArea.getDocument().getLength() > 0;
    }

    @Override
    public void writeOutputTo(Writer writer) throws IOException {
        if (this.isRunning() || 0 == this.outputArea.getDocument().getLength()) {
            return;
        }
        writer.write(this.outputArea.getText().trim());
    }

    @Override
    public boolean hasReport() {
        if (this.isRunning()) {
            return false;
        }
        return this.reportPaneAdded;
    }

    @Override
    public void writeReportTo(Writer writer) throws IOException {
        if (this.isRunning() || !this.reportPaneAdded) {
            return;
        }
        writer.write(this.reportArea.getText().trim());
    }
}

