/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.run;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.AppTask;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.OutputConfig;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.core.StudyBuild;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.StudyLockHolder;
import gov.fcc.tvstudy.gui.StudyManager;
import gov.fcc.tvstudy.gui.run.ProcessPanel;
import gov.fcc.tvstudy.gui.run.RunPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class RunPanelStudy
extends RunPanel
implements StudyLockHolder,
ProcessPanel.Handler,
StatusLogger {
    private StudyManager studyManager;
    private String dbID;
    public StudyBuild studyBuild;
    public boolean runAfterBuild;
    public int studyKey;
    public String studyName;
    public int studyType;
    public int studyLock;
    public int lockCount;
    public Path outDirectoryPath;
    public OutputConfig fileOutputConfig;
    public OutputConfig mapOutputConfig;
    public String reportPreamble;
    public ArrayList<Integer> scenarioKeys;
    public int totalSourceCount;
    public boolean createResultTables;
    private ProcessPanel processPanel;
    private JLabel statusLabel;
    private JButton cancelButton;
    private JTextArea reportArea;
    private JScrollPane reportPane;
    private boolean reportPaneAdded;
    private JTabbedPane tabPane;
    private static final int RUN_STATE_INIT = 0;
    private static final int RUN_STATE_WAIT = 1;
    private static final int RUN_STATE_BUILD = 2;
    private static final int RUN_STATE_START = 3;
    private static final int RUN_STATE_RUNNING = 4;
    private static final int RUN_STATE_EXITING = 6;
    private static final int RUN_STATE_EXIT = 7;
    private int runState;
    private boolean runFailed;
    private boolean runCanceled;
    private AppTask task;
    private boolean taskWaiting;
    private Thread buildThread;
    private boolean buildFailed;
    private ErrorLogger buildErrors;
    private String buildStatus;
    private StringBuilder buildMessageLog;
    private long runStatusStartTime;
    private int runStatusRunningCount;
    private int runStatusDoneCount;
    private boolean updateRunStatus;

    public RunPanelStudy(StudyManager studyManager, String string) {
        this.studyManager = studyManager;
        this.dbID = string;
    }

    @Override
    public boolean initialize(ErrorReporter errorReporter) {
        double d;
        if (this.initialized) {
            return true;
        }
        if (0 != this.runState) {
            this.runState = 7;
            this.runFailed = true;
            return false;
        }
        this.runState = 7;
        this.runFailed = true;
        if (!super.initialize(errorReporter)) {
            return false;
        }
        if (AppCore.maxEngineProcessCount > 0 && this.memoryFraction < (d = 1.0 / (double)AppCore.maxEngineProcessCount)) {
            this.memoryFraction = d;
        }
        if (null == this.fileOutputConfig || this.fileOutputConfig.isNull() || !this.fileOutputConfig.isValid()) {
            if (null != errorReporter) {
                errorReporter.reportError("Cannot run study, missing or invalid output file settings");
            }
            return false;
        }
        if (null == this.mapOutputConfig || this.mapOutputConfig.isNull() || !this.mapOutputConfig.isValid()) {
            if (null != errorReporter) {
                errorReporter.reportError("Cannot run study, missing or invalid map output settings");
            }
            return false;
        }
        this.autoSaveOutput = 1 == this.fileOutputConfig.flags[14] || 3 == this.fileOutputConfig.flags[14];
        this.autoSaveReport = 2 == this.fileOutputConfig.flags[14] || 3 == this.fileOutputConfig.flags[14];
        this.fileOutputConfig.flags[6] = 0;
        this.fileOutputConfig.flags[13] = 1;
        String string = "";
        if (null != this.studyBuild) {
            if (!this.studyBuild.initialize((ErrorLogger)errorReporter)) {
                return false;
            }
            this.studyLock = 0;
            this.studyName = this.studyBuild.studyName;
            string = "Build";
        } else {
            if (this.studyKey <= 0 || 0 == this.studyLock || this.lockCount <= 0 || null == this.outDirectoryPath) {
                errorReporter.reportError("Cannot run study, missing or invalid lock state");
                return false;
            }
            if (null != this.studyName) {
                this.studyName = this.studyName.trim();
                if (0 == this.studyName.length()) {
                    this.studyName = null;
                }
            }
            string = "Run";
        }
        this.runName = null != this.studyName ? string + " study '" + this.studyName + "'" : string + " new study";
        if (!DbCore.openDb((String)this.dbID, (Object)this)) {
            errorReporter.reportError("Invalid database connection ID");
            return false;
        }
        this.task = new AppTask(this.memoryFraction);
        this.processPanel = new ProcessPanel(this.parent, "Study", null);
        this.processPanel.setProcessHandler(this);
        this.processPanel.setStatusPanelVisible(false);
        this.statusLabel = new JLabel("Study starting");
        this.statusLabel.setPreferredSize(AppController.labelSize[60]);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunPanelStudy.this.cancel();
            }
        });
        this.cancelButton.setEnabled(false);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.cancelButton);
        jPanel.add(this.statusLabel);
        this.reportArea = new JTextArea(15, 80);
        this.reportArea.setFont(new Font("Monospaced", 0, 12));
        AppController.fixKeyBindings(this.reportArea);
        this.reportArea.setEditable(false);
        this.reportArea.setLineWrap(true);
        this.reportPane = AppController.createScrollPane(this.reportArea);
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Run", this.processPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabPane, "Center");
        this.add((Component)jPanel, "South");
        if (null != this.reportPreamble && this.reportPreamble.length() > 0) {
            this.reportArea.append(this.reportPreamble);
            this.tabPane.add("Report", this.reportPane);
            this.reportPaneAdded = true;
        }
        this.runState = 1;
        this.runFailed = false;
        this.initialized = true;
        return true;
    }

    @Override
    public String getDbID() {
        return this.dbID;
    }

    @Override
    public int getStudyKey() {
        return this.studyKey;
    }

    @Override
    public String getStudyName() {
        if (null == this.studyName) {
            return "New study";
        }
        return this.studyName;
    }

    @Override
    public int getStudyLock() {
        return this.studyLock;
    }

    @Override
    public int getLockCount() {
        return this.lockCount;
    }

    @Override
    public void toFront() {
        if (null != this.parent) {
            this.parent.getWindow().toFront();
        }
    }

    @Override
    public boolean closeWithoutSave() {
        return false;
    }

    @Override
    public boolean studyManagerClosing() {
        this.studyManager = null;
        return true;
    }

    @Override
    public boolean isDiskSpaceAvailable() {
        return AppCore.isFreeSpaceAvailable((String)this.dbID, (int)this.totalSourceCount, (long)0L);
    }

    @Override
    public void poll() {
        if (!this.initialized) {
            return;
        }
        if (7 == this.runState) {
            if (null != this.task) {
                AppTask.taskDone((AppTask)this.task);
                this.task = null;
                DbCore.closeDb((String)this.dbID, (Object)this);
            }
            return;
        }
        boolean bl = this.processPanel.poll();
        if (!this.runCanceled && this.processPanel.isCanceled()) {
            this.runCanceled = true;
        }
        this.cancelButton.setEnabled(this.canCancel() && !this.runCanceled);
        if (1 == this.runState) {
            if (this.runCanceled) {
                this.runState = 6;
                this.runFailed = this.processPanel.didProcessFail();
            } else {
                if (!AppTask.canTaskStart((AppTask)this.task)) {
                    if (!this.taskWaiting) {
                        this.taskWaiting = true;
                        this.processPanel.setStatusMessage("Waiting for other runs to complete...");
                    }
                    return;
                }
                this.taskWaiting = false;
                this.runState = null == this.studyBuild ? 3 : 2;
            }
        }
        if (2 == this.runState) {
            if (null == this.buildThread) {
                this.buildErrors = new ErrorLogger();
                this.buildStatus = null;
                this.buildMessageLog = new StringBuilder();
                this.buildThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            RunPanelStudy.this.buildStudy();
                        }
                        catch (Throwable throwable) {
                            AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
                            RunPanelStudy.this.buildFailed = true;
                        }
                    }
                };
                this.buildThread.start();
                this.processPanel.setStatusMessage("Building study...");
                return;
            }
            if (this.runCanceled && !this.studyBuild.isCanceled()) {
                this.studyBuild.cancel();
            }
            this.updateBuildStatus();
            if (this.buildThread.isAlive()) {
                return;
            }
            if (this.buildErrors.hasMessages()) {
                this.processPanel.displayLogMessage(this.buildErrors.getMessages() + "\n");
            }
            if (this.buildErrors.hasErrors()) {
                this.processPanel.displayLogMessage(this.buildErrors.toString() + "\n");
            }
            this.buildThread = null;
            if (this.buildFailed) {
                this.runState = 6;
                this.processPanel.cancel();
                if (this.studyBuild.isCanceled()) {
                    this.runCanceled = true;
                    this.processPanel.setStatusMessage("Study build canceled");
                } else {
                    this.runFailed = true;
                    this.processPanel.setStatusMessage("Study build failed");
                }
                this.cancelButton.setEnabled(false);
            } else {
                if (null != this.studyManager) {
                    this.studyManager.applyEditsFrom(this);
                }
                if (this.runAfterBuild) {
                    this.runState = 3;
                } else {
                    this.runState = 6;
                    this.processPanel.cancel();
                    this.processPanel.setStatusMessage("Study build complete");
                    this.cancelButton.setEnabled(false);
                }
            }
            if (null != this.reportPreamble && this.reportPreamble.length() > 0) {
                this.reportArea.append(this.reportPreamble);
                if (!this.reportPaneAdded) {
                    this.tabPane.add("Report", this.reportPane);
                    this.reportPaneAdded = true;
                }
            }
        }
        if (3 == this.runState) {
            if (this.runCanceled) {
                this.runState = 6;
                this.runFailed = this.processPanel.didProcessFail();
            } else {
                this.runState = 4;
                this.updateRunStatus = true;
                this.startRun();
                bl = this.processPanel.poll();
            }
        }
        if (4 == this.runState) {
            if (bl) {
                if (this.updateRunStatus && this.totalSourceCount > 0 && !this.runCanceled) {
                    String string;
                    String string2 = AppCore.formatCount((int)this.runStatusDoneCount) + " of " + AppCore.formatCount((int)this.totalSourceCount) + " items done";
                    if (this.runStatusDoneCount == this.totalSourceCount) {
                        string = this.runStatusRunningCount < 0 ? string2 + ", running" : string2 + ", study complete";
                    } else if (0L == this.runStatusStartTime) {
                        string = string2 + ", running";
                    } else {
                        double d = (double)this.runStatusDoneCount / (double)this.totalSourceCount;
                        double d2 = (double)(System.currentTimeMillis() - this.runStatusStartTime) / 60000.0;
                        if (d < 0.1 && d2 < 2.0) {
                            string = string2 + ", running";
                        } else {
                            double d3 = d2 * (1.0 / d - 1.0);
                            if (d < 0.5) {
                                d3 *= 1.5 - d;
                            }
                            if (d3 < 1.0) {
                                string = string2 + ", less than 1 minute remaining";
                            } else if (d3 < 60.0) {
                                int n = (int)Math.rint(d3);
                                string = string2 + ", about " + n + (1 == n ? " minute" : " minutes") + " remaining";
                            } else {
                                int n = (int)Math.rint(d3 / 60.0);
                                string = string2 + ", about " + n + (1 == n ? " hour" : " hours") + " remaining";
                            }
                        }
                    }
                    this.processPanel.setStatusMessage(string);
                }
                this.updateRunStatus = false;
                return;
            }
            this.runFailed = this.processPanel.didProcessFail();
        }
        this.runState = 7;
        this.cancelButton.setEnabled(false);
        if (0 != this.studyLock) {
            boolean bl2 = false;
            String string = "";
            DbConnection dbConnection = DbCore.connectDb((String)this.dbID);
            if (null != dbConnection) {
                try {
                    dbConnection.update("LOCK TABLES study WRITE");
                    dbConnection.query("SELECT study_lock, lock_count, share_count FROM study WHERE study_key=" + this.studyKey);
                    if (dbConnection.next()) {
                        int n = dbConnection.getInt(1);
                        int n2 = dbConnection.getInt(2);
                        int n3 = dbConnection.getInt(3);
                        if (n == this.studyLock && n2 == this.lockCount || 2 == this.studyLock && 3 == n && n2 == this.lockCount + 1) {
                            if (2 == n || --n3 <= 0) {
                                dbConnection.update("UPDATE study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + this.studyKey);
                                this.studyLock = 0;
                                this.lockCount = n2 + 1;
                            } else {
                                dbConnection.update("UPDATE study SET share_count = share_count - 1 WHERE study_key = " + this.studyKey);
                                this.studyLock = 3;
                                this.lockCount = n2;
                            }
                        } else {
                            bl2 = true;
                            string = "*** The study lock was modified. ***";
                        }
                    } else {
                        bl2 = true;
                        string = "*** The study was deleted. ***";
                    }
                }
                catch (SQLException sQLException) {
                    bl2 = true;
                    string = "An operation cannot be completed due to a database error:\n" + sQLException;
                    DbConnection.reportError((SQLException)sQLException);
                }
                try {
                    dbConnection.update("UNLOCK TABLES");
                }
                catch (SQLException sQLException) {
                    DbConnection.reportError((SQLException)sQLException);
                }
                DbCore.releaseDb((DbConnection)dbConnection);
            } else {
                bl2 = true;
                string = "*** Could not open database connection. ***";
            }
            if (bl2) {
                this.processPanel.setStatusMessage(string);
                this.runFailed = true;
            }
        }
        if (null != this.studyManager) {
            this.studyManager.editorClosing(this);
        }
        if (null != this.task) {
            AppTask.taskDone((AppTask)this.task);
            this.task = null;
            DbCore.closeDb((String)this.dbID, (Object)this);
        }
    }

    private void buildStudy() {
        String string = "";
        Study study = this.studyBuild.buildStudy((StatusLogger)this, this.buildErrors);
        if (null == study) {
            this.buildFailed = true;
        } else {
            this.studyKey = study.key;
            this.studyName = study.name;
            this.studyType = study.studyType;
            this.studyLock = study.studyLock;
            this.lockCount = study.lockCount;
            this.outDirectoryPath = Paths.get(study.outDirectory, new String[0]);
            if (!this.outDirectoryPath.isAbsolute()) {
                this.outDirectoryPath = AppCore.workingDirectoryPath.resolve(study.outDirectory);
            }
            this.runName = "Run study '" + this.studyName + "'";
            this.reportPreamble = study.reportPreamble;
            String string2 = DbCore.getDbName((String)this.dbID);
            DbConnection dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)this.buildErrors);
            if (null != dbConnection) {
                try {
                    dbConnection.update("LOCK TABLES study WRITE");
                    dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + study.key);
                    if (dbConnection.next()) {
                        if (dbConnection.getInt(1) == this.studyLock && dbConnection.getInt(2) == this.lockCount) {
                            dbConnection.update("UPDATE study SET study_lock = 2, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + this.studyKey);
                            this.studyLock = 2;
                            ++this.lockCount;
                            dbConnection.update("UNLOCK TABLES");
                            this.totalSourceCount = 0;
                            if (2 == this.studyType) {
                                dbConnection.query("SELECT COUNT(*) FROM " + string2 + "_" + this.studyKey + ".scenario_source WHERE scenario_key = 1 AND is_desired");
                                if (dbConnection.next()) {
                                    this.totalSourceCount = dbConnection.getInt(1);
                                }
                                dbConnection.query("SELECT parent.scenario_key, COUNT(*) FROM " + string2 + "_" + this.studyKey + ".scenario AS parent JOIN " + string2 + "_" + this.studyKey + ".scenario AS child ON (child.parent_scenario_key = parent.scenario_key) JOIN " + string2 + "_" + this.studyKey + ".scenario_source ON (scenario_source.scenario_key = child.scenario_key) WHERE scenario_source.is_desired GROUP BY 1 ORDER BY 1");
                                while (dbConnection.next()) {
                                    this.totalSourceCount += dbConnection.getInt(2);
                                }
                            } else {
                                dbConnection.query("SELECT scenario_key, COUNT(*) FROM " + string2 + "_" + this.studyKey + ".scenario JOIN " + string2 + "_" + this.studyKey + ".scenario_source USING (scenario_key) WHERE scenario_source.is_desired GROUP BY 1 ORDER BY 1");
                                this.scenarioKeys = new ArrayList();
                                while (dbConnection.next()) {
                                    this.scenarioKeys.add(dbConnection.getInt(1));
                                    this.totalSourceCount += dbConnection.getInt(2);
                                }
                            }
                        } else {
                            this.buildFailed = true;
                            string = "Could not update study lock, the lock was modified";
                        }
                    } else {
                        this.buildFailed = true;
                        string = "Could not update study lock, the study was deleted";
                    }
                }
                catch (SQLException sQLException) {
                    this.buildFailed = true;
                    string = "An operation cannot be completed due to a database error:\n" + sQLException;
                    DbConnection.reportError((SQLException)sQLException);
                }
                try {
                    dbConnection.update("UNLOCK TABLES");
                }
                catch (SQLException sQLException) {
                    DbConnection.reportError((SQLException)sQLException);
                }
                DbCore.releaseDb((DbConnection)dbConnection);
                if (this.buildFailed) {
                    this.buildErrors.reportError(string);
                }
            } else {
                this.buildFailed = true;
            }
        }
    }

    public synchronized void reportStatus(String string) {
        this.buildStatus = string;
    }

    public synchronized void logMessage(String string) {
        this.buildMessageLog.append(string + "\n");
    }

    public synchronized void showMessage(String string) {
        this.buildMessageLog.append(string + "\r");
    }

    public boolean isCanceled() {
        return this.runCanceled;
    }

    private synchronized void updateBuildStatus() {
        if (null != this.buildStatus) {
            this.processPanel.setStatusMessage(this.buildStatus);
            this.buildStatus = null;
        }
        if (this.buildMessageLog.length() > 0) {
            this.processPanel.displayLogMessage(this.buildMessageLog.toString());
            this.buildMessageLog.setLength(0);
        }
    }

    private void startRun() {
        long l;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(AppCore.libDirectoryPath.resolve("tvstudy").toString());
        if (AppCore.Debug) {
            arrayList.add("-d");
        }
        arrayList.add("-w");
        arrayList.add(AppCore.workingDirectoryPath.toString());
        arrayList.add("-z");
        arrayList.add(AppCore.cacheDirectoryPath.toString());
        arrayList.add("-o");
        arrayList.add(this.outDirectoryPath.toString());
        arrayList.add("-i");
        if (null != this.studyBuild && (l = this.studyBuild.getLogStartTime()) > 0L) {
            arrayList.add("-t");
            arrayList.add(String.valueOf(l));
        }
        arrayList.add("-h");
        arrayList.add(DbCore.getDbHostname((String)this.dbID));
        arrayList.add("-b");
        arrayList.add(DbCore.getDbName((String)this.dbID));
        arrayList.add("-u");
        arrayList.add(DbCore.getDbUsername((String)this.dbID));
        arrayList.add("-l");
        arrayList.add(String.valueOf(this.lockCount));
        arrayList.add("-m");
        arrayList.add(String.valueOf((int)Math.rint(1.0 / this.memoryFraction)));
        arrayList.add("-f");
        arrayList.add(this.fileOutputConfig.getCodes());
        arrayList.add("-e");
        arrayList.add(this.mapOutputConfig.getCodes());
        arrayList.add("-j");
        if (this.createResultTables) {
            arrayList.add("1");
        } else {
            arrayList.add("0");
        }
        if (null != this.runComment && this.runComment.length() > 0) {
            arrayList.add("-c");
            arrayList.add(this.runComment);
        }
        arrayList.add(String.valueOf(this.studyKey));
        if (null != this.scenarioKeys) {
            for (Integer n : this.scenarioKeys) {
                arrayList.add(String.valueOf(n));
            }
        }
        this.processPanel.setProcessArguments(arrayList, DbCore.getDbPassword((String)this.dbID));
    }

    @Override
    public String getProcessResponse(ProcessPanel processPanel, String string) {
        return null;
    }

    @Override
    public void processResponseConfirmed(ProcessPanel processPanel) {
    }

    @Override
    public void processFailed(ProcessPanel processPanel) {
    }

    @Override
    public void processComplete(ProcessPanel processPanel) {
    }

    @Override
    public void processStatusMessage(ProcessPanel processPanel, String string, String string2) {
        if (string.equals("report")) {
            this.reportArea.append(string2 + "\n");
            if (!this.reportPaneAdded) {
                this.tabPane.add("Report", this.reportPane);
                this.reportPaneAdded = true;
            }
            return;
        }
        if (string.equals("runcount")) {
            if (0L == this.runStatusStartTime) {
                this.runStatusStartTime = System.currentTimeMillis();
                this.updateRunStatus = true;
            }
            if (this.runStatusRunningCount > 0) {
                this.runStatusDoneCount += this.runStatusRunningCount;
                this.runStatusRunningCount = 0;
                this.updateRunStatus = true;
            }
            try {
                this.runStatusRunningCount = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public void setStatusMessage(String string) {
        this.statusLabel.setText(string);
    }

    @Override
    public String getStatus() {
        switch (this.runState) {
            case 0: 
            case 1: {
                return "Waiting";
            }
            case 2: {
                return "Building";
            }
            case 3: {
                return "Starting";
            }
            case 4: {
                if (this.totalSourceCount > 0) {
                    return "Running, " + AppCore.formatCount((int)this.runStatusDoneCount) + " of " + AppCore.formatCount((int)this.totalSourceCount) + " done";
                }
                return "Running";
            }
            case 6: {
                return "Exiting";
            }
            case 7: {
                if (this.runCanceled) {
                    return "Canceled";
                }
                if (this.runFailed) {
                    return "Failed";
                }
                return "Complete";
            }
        }
        return "Unknown";
    }

    @Override
    public boolean isRunning() {
        return 7 != this.runState;
    }

    @Override
    public boolean isWaiting() {
        return 1 == this.runState;
    }

    @Override
    public void bumpTask() {
        if (1 == this.runState && null != this.task) {
            AppTask.bumpTask((AppTask)this.task);
        }
    }

    @Override
    public boolean runFailed() {
        return this.runFailed;
    }

    @Override
    public void cancel() {
        if (this.runCanceled || !this.canCancel()) {
            return;
        }
        this.cancelButton.setEnabled(false);
        if (2 == this.runState && !this.studyBuild.isCanceled()) {
            this.studyBuild.cancel();
        }
        this.processPanel.cancel();
    }

    @Override
    public boolean hasOutput() {
        if (null == this.processPanel || this.isRunning()) {
            return false;
        }
        return this.processPanel.hasOutput();
    }

    @Override
    public void writeOutputTo(Writer writer) throws IOException {
        if (null == this.processPanel || this.isRunning()) {
            return;
        }
        this.processPanel.writeOutputTo(writer);
    }

    @Override
    public boolean hasReport() {
        if (this.isRunning()) {
            return false;
        }
        return this.reportPaneAdded;
    }

    @Override
    public void writeReportTo(Writer writer) throws IOException {
        if (this.isRunning() || !this.reportPaneAdded) {
            return;
        }
        writer.write(this.reportArea.getText().trim());
    }

    @Override
    public Path getOutDirectoryPath() {
        if (null == this.outDirectoryPath || null == this.studyName) {
            return null;
        }
        String string = DbCore.getHostDbName((String)this.dbID);
        if (null == string) {
            return this.outDirectoryPath.resolve(this.studyName);
        }
        return this.outDirectoryPath.resolve(string).resolve(this.studyName);
    }
}

