/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.run;

import gov.fcc.tvstudy.core.AppTask;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.run.ProcessPanel;
import gov.fcc.tvstudy.gui.run.RunPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class RunPanelProcess
extends RunPanel {
    private static final int RUN_STATE_INIT = 0;
    private static final int RUN_STATE_WAIT = 1;
    private static final int RUN_STATE_RUNNING = 2;
    private static final int RUN_STATE_EXITING = 3;
    private static final int RUN_STATE_EXIT = 4;
    private int runState = 0;
    private boolean runFailed;
    private boolean runCanceled;
    private AppTask task;
    private boolean taskWaiting;
    private ArrayList<String> processArguments;
    private ProcessPanel processPanel;

    public RunPanelProcess(String string, ArrayList<String> arrayList) {
        this.runName = string;
        this.processArguments = new ArrayList<String>(arrayList);
    }

    public RunPanelProcess(String string, ArrayList<String> arrayList, Runnable runnable) {
        super(runnable);
        this.runName = string;
        this.processArguments = new ArrayList<String>(arrayList);
    }

    @Override
    public boolean initialize(ErrorReporter errorReporter) {
        if (this.initialized) {
            return true;
        }
        if (0 != this.runState) {
            this.runState = 4;
            this.runFailed = true;
            return false;
        }
        this.runState = 4;
        this.runFailed = true;
        if (!super.initialize(errorReporter)) {
            return false;
        }
        this.task = new AppTask(this.memoryFraction);
        this.processPanel = new ProcessPanel(this.parent, this.runName, null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.processPanel, "Center");
        this.runState = 1;
        this.runFailed = false;
        this.initialized = true;
        return true;
    }

    @Override
    public void poll() {
        if (!this.initialized) {
            return;
        }
        if (4 == this.runState) {
            if (null != this.task) {
                AppTask.taskDone((AppTask)this.task);
                this.task = null;
            }
            return;
        }
        boolean bl = this.processPanel.poll();
        if (!this.runCanceled && this.processPanel.isCanceled()) {
            this.runCanceled = true;
        }
        if (1 == this.runState) {
            if (this.runCanceled) {
                this.runState = 3;
                this.runFailed = this.processPanel.didProcessFail();
            } else {
                if (!AppTask.canTaskStart((AppTask)this.task)) {
                    if (!this.taskWaiting) {
                        this.taskWaiting = true;
                        this.processPanel.setStatusMessage("Waiting for other activity to complete...");
                    }
                    return;
                }
                this.taskWaiting = false;
                this.runState = 2;
                this.processPanel.setStatusMessage("Activity running...");
                this.processPanel.setProcessArguments(this.processArguments, null);
                bl = this.processPanel.poll();
            }
        }
        if (2 == this.runState) {
            if (bl) {
                return;
            }
            this.runFailed = this.processPanel.didProcessFail();
        }
        this.runState = 4;
        if (null != this.task) {
            AppTask.taskDone((AppTask)this.task);
            this.task = null;
        }
        if (null != this.callBack) {
            this.callBack.run();
        }
    }

    @Override
    public boolean isRunning() {
        return 4 != this.runState;
    }

    @Override
    public boolean isWaiting() {
        return 1 == this.runState;
    }

    @Override
    public void bumpTask() {
        if (1 == this.runState && null != this.task) {
            AppTask.bumpTask((AppTask)this.task);
        }
    }

    @Override
    public boolean runFailed() {
        return this.runFailed;
    }

    @Override
    public void cancel() {
        if (!this.canCancel()) {
            return;
        }
        this.processPanel.cancel();
    }

    @Override
    public String getStatus() {
        switch (this.runState) {
            case 0: 
            case 1: {
                return "Waiting";
            }
            case 2: {
                return "Running";
            }
            case 3: {
                return "Exiting";
            }
            case 4: {
                if (this.runCanceled) {
                    return "Canceled";
                }
                if (this.runFailed) {
                    return "Failed";
                }
                return "Complete";
            }
        }
        return "Unknown";
    }

    @Override
    public boolean hasOutput() {
        if (null == this.processPanel || this.isRunning()) {
            return false;
        }
        return this.processPanel.hasOutput();
    }

    @Override
    public void writeOutputTo(Writer writer) throws IOException {
        if (null == this.processPanel || this.isRunning()) {
            return;
        }
        this.processPanel.writeOutputTo(writer);
    }
}

