/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.run;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppPanel;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.run.RunManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class RunPanel
extends AppPanel {
    public static final String LOG_FILE_NAME = "log.txt";
    public static final String REPORT_FILE_NAME = "report.txt";
    public double memoryFraction = 1.0;
    public String runComment;
    public String runName;
    public boolean autoSaveOutput;
    public boolean autoSaveReport;
    public boolean autoRemove;
    protected boolean initialized;

    public RunPanel() {
        super(RunManager.getRunManager());
    }

    public RunPanel(Runnable runnable) {
        super(RunManager.getRunManager(), runnable);
    }

    @Override
    public String getDbID() {
        return null;
    }

    public boolean initialize(ErrorReporter errorReporter) {
        if (this.initialized) {
            return true;
        }
        if (this.memoryFraction < 0.0) {
            this.memoryFraction = 0.0;
        }
        if (this.memoryFraction > 1.0) {
            this.memoryFraction = 1.0;
        }
        this.runComment = null != this.runComment ? this.runComment.trim() : "";
        return true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getRunName() {
        if (null == this.runName) {
            return "(unknown)";
        }
        return this.runName;
    }

    public boolean isDiskSpaceAvailable() {
        return true;
    }

    public abstract void poll();

    public abstract boolean isRunning();

    public abstract boolean isWaiting();

    public abstract void bumpTask();

    public abstract boolean runFailed();

    public abstract void cancel();

    public boolean canCancel() {
        return true;
    }

    public abstract String getStatus();

    public abstract boolean hasOutput();

    public abstract void writeOutputTo(Writer var1) throws IOException;

    public boolean hasReport() {
        return false;
    }

    public void writeReportTo(Writer writer) throws IOException {
    }

    public Path getOutDirectoryPath() {
        return null;
    }

    public void autoSave() {
        BufferedWriter bufferedWriter;
        Path path = this.getOutDirectoryPath();
        if (null == path) {
            return;
        }
        if (this.autoSaveOutput && this.hasOutput()) {
            this.autoSaveOutput = false;
            bufferedWriter = null;
            try {
                bufferedWriter = Files.newBufferedWriter(path.resolve(LOG_FILE_NAME), new OpenOption[0]);
            }
            catch (IOException iOException) {
                return;
            }
            try {
                this.writeOutputTo(bufferedWriter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.autoSaveReport && this.hasReport()) {
            this.autoSaveReport = false;
            bufferedWriter = null;
            try {
                bufferedWriter = Files.newBufferedWriter(path.resolve(REPORT_FILE_NAME), new OpenOption[0]);
            }
            catch (IOException iOException) {
                return;
            }
            try {
                this.writeReportTo(bufferedWriter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void saveOutput() {
        if (this.isRunning() || !this.hasOutput()) {
            return;
        }
        String string = "Save Run Log";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Save")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            if (!file.exists()) continue;
            AppController.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return;
        }
        try {
            this.writeOutputTo(fileWriter);
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not write to the file:\n" + iOException.getMessage());
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveReport() {
        if (this.isRunning() || !this.hasReport()) {
            return;
        }
        String string = "Save Report";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Save")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            if (!file.exists()) continue;
            AppController.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return;
        }
        try {
            this.writeReportTo(fileWriter);
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not write to the file:\n" + iOException.getMessage());
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

