/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.run;

import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppFrame;
import gov.fcc.tvstudy.gui.DbController;
import gov.fcc.tvstudy.gui.run.RunPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class RunManager
extends AppFrame {
    private static RunManager runManager;
    private RunListTableModel runListModel;
    private JTable runListTable;
    private RunPanel currentRunPanel;
    private JPanel wrapperPanel;
    private JSplitPane splitPane;
    private JButton saveLogButton;
    private JButton saveReportButton;
    private JButton removeButton;
    private JButton runNextButton;
    private JMenuItem cancelMenuItem;
    private JMenuItem saveLogMenuItem;
    private JMenuItem saveReportMenuItem;
    private static final int TIMER_INTERVAL = 200;
    private Timer checkTimer;
    private boolean ignoreSelectionChange;

    public static synchronized RunManager getRunManager() {
        if (null == runManager) {
            new RunManager();
        }
        return runManager;
    }

    public static synchronized void showRunManager() {
        if (null == runManager) {
            new RunManager();
        }
        if (runManager.isVisible()) {
            runManager.toFront();
        } else {
            AppController.showWindow(runManager);
        }
    }

    private RunManager() {
        super(null, "Activity Queue");
        if (null != runManager) {
            throw new RuntimeException("Run manager already exists");
        }
        runManager = this;
        this.runListModel = new RunListTableModel();
        this.runListTable = this.runListModel.createTable();
        this.runListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && !RunManager.this.ignoreSelectionChange) {
                    RunManager.this.doChangePanel();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)AppController.createScrollPane(this.runListTable), "Center");
        jPanel.setMinimumSize(new Dimension(0, this.runListTable.getRowHeight() * 8));
        this.wrapperPanel = new JPanel();
        this.wrapperPanel.setLayout(new BoxLayout(this.wrapperPanel, 0));
        this.wrapperPanel.setMinimumSize(new Dimension(0, 200));
        this.splitPane = new JSplitPane(0, false, jPanel, this.wrapperPanel);
        this.saveLogButton = new JButton("Save Log...");
        this.saveLogButton.setFocusable(false);
        this.saveLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunManager.this.doSaveOutput();
            }
        });
        this.saveReportButton = new JButton("Save Report...");
        this.saveReportButton.setFocusable(false);
        this.saveReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunManager.this.doSaveReport();
            }
        });
        this.removeButton = new JButton("Remove");
        this.removeButton.setFocusable(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RunManager.this.runListModel.isEmpty()) {
                    if (RunManager.this.windowShouldClose()) {
                        AppController.hideWindow(runManager);
                    }
                } else {
                    RunManager.this.doRemove();
                }
            }
        });
        this.runNextButton = new JButton("Move To Top");
        this.runNextButton.setFocusable(false);
        this.runNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunManager.this.doRunNext();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.runNextButton);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.saveLogButton);
        jPanel3.add(this.saveReportButton);
        jPanel3.add(this.removeButton);
        Box box = Box.createHorizontalBox();
        box.add(jPanel2);
        box.add(jPanel3);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.splitPane, "Center");
        container.add((Component)box, "South");
        this.pack();
        Dimension dimension = this.getSize();
        dimension.width = 600;
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.fileMenu.removeAll();
        this.cancelMenuItem = new JMenuItem("Cancel");
        this.cancelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunManager.this.doCancel();
            }
        });
        this.cancelMenuItem.setEnabled(false);
        this.fileMenu.add(this.cancelMenuItem);
        this.fileMenu.addSeparator();
        this.saveLogMenuItem = new JMenuItem("Save Log...");
        this.saveLogMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, AppController.MENU_SHORTCUT_KEY_MASK));
        this.saveLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunManager.this.doSaveOutput();
            }
        });
        this.fileMenu.add(this.saveLogMenuItem);
        this.saveReportMenuItem = new JMenuItem("Save Report...");
        this.saveReportMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, AppController.MENU_SHORTCUT_KEY_MASK));
        this.saveReportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunManager.this.doSaveReport();
            }
        });
        this.checkTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunManager.this.doUpdate();
            }
        });
        this.updateDocumentName();
    }

    @Override
    public String getFileMenuName() {
        return "Activity";
    }

    @Override
    protected boolean showsEditMenu() {
        return false;
    }

    @Override
    public String getDbID() {
        return null;
    }

    private void updateControls() {
        if (null == this.currentRunPanel) {
            this.cancelMenuItem.setEnabled(false);
            this.saveLogButton.setEnabled(false);
            this.saveLogMenuItem.setEnabled(false);
            this.saveReportButton.setEnabled(false);
            this.saveReportMenuItem.setEnabled(false);
            this.removeButton.setEnabled(this.runListModel.isEmpty());
            this.runNextButton.setEnabled(false);
        } else if (this.currentRunPanel.isRunning()) {
            this.cancelMenuItem.setEnabled(this.currentRunPanel.canCancel());
            this.saveLogButton.setEnabled(false);
            this.saveLogMenuItem.setEnabled(false);
            this.saveReportButton.setEnabled(false);
            this.saveReportMenuItem.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.runNextButton.setEnabled(this.currentRunPanel.isWaiting() && this.runListTable.getSelectedRow() > 0);
        } else {
            this.cancelMenuItem.setEnabled(false);
            if (this.currentRunPanel.hasOutput()) {
                this.saveLogButton.setEnabled(true);
                this.saveLogMenuItem.setEnabled(true);
            } else {
                this.saveLogButton.setEnabled(false);
                this.saveLogMenuItem.setEnabled(false);
            }
            if (this.currentRunPanel.hasReport()) {
                this.saveReportButton.setEnabled(true);
                this.saveReportMenuItem.setEnabled(true);
            } else {
                this.saveReportButton.setEnabled(false);
                this.saveReportMenuItem.setEnabled(false);
            }
            this.removeButton.setEnabled(true);
            this.runNextButton.setEnabled(false);
        }
        if (this.runListModel.isEmpty()) {
            this.removeButton.setText("Close");
        } else {
            this.removeButton.setText("Remove");
        }
    }

    private void doChangePanel() {
        if (this.runListTable.getSelectedRowCount() != 1) {
            return;
        }
        if (null != this.currentRunPanel) {
            this.wrapperPanel.remove(this.currentRunPanel);
        }
        this.currentRunPanel = this.runListModel.get(this.runListTable.getSelectedRow());
        this.wrapperPanel.add(this.currentRunPanel);
        this.wrapperPanel.revalidate();
        this.wrapperPanel.repaint();
        this.updateControls();
    }

    private void doCancel() {
        if (null == this.currentRunPanel || !this.currentRunPanel.isRunning() || !this.currentRunPanel.canCancel()) {
            return;
        }
        this.currentRunPanel.cancel();
    }

    private void doSaveOutput() {
        if (null == this.currentRunPanel || !this.currentRunPanel.hasOutput()) {
            return;
        }
        this.currentRunPanel.saveOutput();
    }

    private void doSaveReport() {
        if (null == this.currentRunPanel || !this.currentRunPanel.hasReport()) {
            return;
        }
        this.currentRunPanel.saveReport();
    }

    private void doRemove() {
        if (null == this.currentRunPanel || this.currentRunPanel.isRunning()) {
            return;
        }
        this.wrapperPanel.remove(this.currentRunPanel);
        this.runListModel.remove(this.currentRunPanel);
        this.currentRunPanel.setParent(null);
        this.currentRunPanel = null;
        if (!this.runListModel.isEmpty()) {
            this.runListTable.scrollRectToVisible(this.runListTable.getCellRect(0, 0, true));
            this.runListTable.setRowSelectionInterval(0, 0);
        } else {
            this.wrapperPanel.revalidate();
            this.wrapperPanel.repaint();
            this.updateControls();
        }
    }

    private void doRunNext() {
        if (null == this.currentRunPanel || !this.currentRunPanel.isWaiting() || this.runListTable.getSelectedRow() <= 0) {
            return;
        }
        this.currentRunPanel.bumpTask();
        this.ignoreSelectionChange = true;
        this.runListModel.remove(this.currentRunPanel);
        this.runListModel.add(0, this.currentRunPanel);
        this.runListTable.scrollRectToVisible(this.runListTable.getCellRect(0, 0, true));
        this.runListTable.setRowSelectionInterval(0, 0);
        this.ignoreSelectionChange = false;
    }

    public static void addRunPanel(RunPanel runPanel) {
        if (!runPanel.isInitialized()) {
            return;
        }
        RunManager.showRunManager();
        int n = RunManager.runManager.runListModel.add(runPanel);
        runPanel.setParent(runManager);
        if (n >= 0) {
            RunManager.runManager.runListTable.setRowSelectionInterval(n, n);
            RunManager.runManager.runListTable.scrollRectToVisible(RunManager.runManager.runListTable.getCellRect(n, 0, true));
        }
    }

    private void doUpdate() {
        boolean bl = false;
        for (RunPanel runPanel : this.runListModel.getAll()) {
            runPanel.poll();
            if (runPanel.isRunning()) continue;
            runPanel.autoSave();
            if (!runPanel.autoRemove || runPanel.runFailed()) continue;
            runPanel.autoRemove = false;
            this.runListModel.remove(runPanel);
            runPanel.setParent(null);
            if (runPanel != this.currentRunPanel) continue;
            this.wrapperPanel.remove(this.currentRunPanel);
            this.currentRunPanel = null;
            bl = true;
        }
        if (bl) {
            if (!this.runListModel.isEmpty()) {
                this.runListTable.scrollRectToVisible(this.runListTable.getCellRect(0, 0, true));
                this.runListTable.setRowSelectionInterval(0, 0);
            } else {
                this.wrapperPanel.revalidate();
                this.wrapperPanel.repaint();
            }
        }
        this.runListModel.dataChanged();
        this.updateControls();
    }

    @Override
    public void windowWillOpen() {
        Integer n = DbCore.getIntegerProperty((String)this.getDbID(), (String)(this.getKeyTitle() + ".dividerLocation"));
        if (null != n) {
            this.splitPane.setDividerLocation(n);
        }
        DbController.restoreColumnWidths(this.getDbID(), this.getKeyTitle(), this.runListTable);
        if (!this.checkTimer.isRunning()) {
            this.checkTimer.start();
        }
        this.blockActionsClear();
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        this.errorReporter.clearTitle();
        if (!this.runListModel.isEmpty()) {
            ArrayList arrayList = this.runListModel.getAll();
            for (RunPanel runPanel : arrayList) {
                if (!runPanel.isRunning()) continue;
                this.toFront();
                AppController.beep();
                this.errorReporter.reportMessage("This window can't be closed until all activities are complete");
                return false;
            }
            for (RunPanel runPanel : arrayList) {
                runPanel.setParent(null);
            }
            this.runListModel.removeAll();
            if (null != this.currentRunPanel) {
                this.wrapperPanel.remove(this.currentRunPanel);
                this.currentRunPanel.setParent(null);
                this.currentRunPanel = null;
            }
        }
        return true;
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        DbCore.setIntegerProperty((String)this.getDbID(), (String)(this.getKeyTitle() + ".dividerLocation"), (Integer)this.splitPane.getDividerLocation());
        DbController.saveColumnWidths(this.getDbID(), this.getKeyTitle(), this.runListTable);
        this.blockActionsSet();
        this.checkTimer.stop();
    }

    private class RunListTableModel
    extends AbstractTableModel {
        private static final String RUN_COLUMN = "Activity";
        private static final String STATUS_COLUMN = "Status";
        private static final String AUTO_REMOVE_COLUMN = "Remove when complete";
        private String[] columnNames = new String[]{"Activity", "Status", "Remove when complete"};
        private static final int RUN_INDEX = 0;
        private static final int STATUS_INDEX = 1;
        private static final int AUTO_REMOVE_INDEX = 2;
        private ArrayList<RunPanel> modelRows = new ArrayList();

        private RunListTableModel() {
        }

        private JTable createTable() {
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable);
            jTable.setSelectionMode(0);
            TableColumn tableColumn = jTable.getColumn(RUN_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[8]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[20]);
            tableColumn = jTable.getColumn(STATUS_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[3]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
            tableColumn = jTable.getColumn(AUTO_REMOVE_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[3]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[3]);
            return jTable;
        }

        private int add(RunPanel runPanel) {
            int n = this.modelRows.size();
            this.modelRows.add(runPanel);
            this.fireTableRowsInserted(n, n);
            return n;
        }

        private int add(int n, RunPanel runPanel) {
            this.modelRows.add(n, runPanel);
            this.fireTableRowsInserted(n, n);
            return n;
        }

        private RunPanel get(int n) {
            return this.modelRows.get(n);
        }

        private ArrayList<RunPanel> getAll() {
            return new ArrayList<RunPanel>(this.modelRows);
        }

        private void remove(RunPanel runPanel) {
            int n = this.modelRows.indexOf(runPanel);
            if (n >= 0) {
                this.modelRows.remove(n);
                this.fireTableRowsDeleted(n, n);
            }
        }

        private void removeAll() {
            this.modelRows.clear();
            this.fireTableDataChanged();
        }

        private boolean isEmpty() {
            return this.modelRows.isEmpty();
        }

        private void dataChanged() {
            if (!this.modelRows.isEmpty()) {
                this.fireTableChanged(new TableModelEvent(this, 0, this.modelRows.size() - 1));
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            if (2 == n) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.modelRows.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return 2 == n2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            RunPanel runPanel = this.modelRows.get(n);
            switch (n2) {
                case 0: {
                    return runPanel.getRunName();
                }
                case 1: {
                    return runPanel.getStatus();
                }
                case 2: {
                    return runPanel.autoRemove;
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (2 != n2) {
                return;
            }
            RunPanel runPanel = this.modelRows.get(n);
            runPanel.autoRemove = (Boolean)object;
        }
    }
}

