/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.core.editdata.ParameterEditData;
import gov.fcc.tvstudy.core.editdata.TemplateEditData;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.BackgroundWorker;
import gov.fcc.tvstudy.gui.DbController;
import gov.fcc.tvstudy.gui.EditMenu;
import gov.fcc.tvstudy.gui.RootEditor;
import gov.fcc.tvstudy.gui.editor.IxRuleEditor;
import gov.fcc.tvstudy.gui.editor.ParameterEditor;
import gov.fcc.tvstudy.gui.editor.TableFilterModel;
import gov.fcc.tvstudy.gui.editor.TableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class TemplateEditor
extends RootEditor {
    public static final String WINDOW_TITLE = "Template";
    private TemplateEditData template;
    private ArrayList<ParameterEditor> parameterEditors;
    private boolean hasNewParameters;
    private IxRuleTableModel ixRuleModel;
    private JTable ixRuleTable;
    private HashMap<Integer, IxRuleEditor> ixRuleEditors;
    private JButton editIxRuleButton;
    private JMenuItem editIxRuleMenuItem;
    private JMenuItem deleteIxRuleMenuItem;
    private JTabbedPane editorTabPane;
    private int lastSelectedTab = -1;
    private boolean dataChanged;
    private TemplateEditor outerThis = this;

    public TemplateEditor(AppEditor appEditor, TemplateEditData templateEditData) {
        super(appEditor, WINDOW_TITLE);
        Object object2;
        this.template = templateEditData;
        this.setTitleKey(this.template.template.key);
        this.parameterEditors = new ArrayList();
        JComponent jComponent = ParameterEditor.createEditorLayout(this, this.errorReporter, this.template.parameters, this.parameterEditors);
        if (!this.template.template.isLocked) {
            for (Object object2 : this.template.parameters) {
                if (!((ParameterEditData)object2).parameter.defaultsApplied) continue;
                this.hasNewParameters = true;
            }
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this.hasNewParameters) {
            jPanel.setBorder(BorderFactory.createTitledBorder("Parameters (new in red)"));
        } else {
            jPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        }
        jPanel.add((Component)jComponent, "Center");
        this.ixRuleModel = new IxRuleTableModel();
        this.ixRuleTable = this.ixRuleModel.createTable(this.editMenu);
        this.ixRuleTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    TemplateEditor.this.doOpenIxRule();
                }
            }
        });
        this.ixRuleTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TemplateEditor.this.updateRuleControls();
            }
        });
        object2 = new JPanel(new BorderLayout());
        ((JComponent)object2).setBorder(BorderFactory.createTitledBorder("Interference Rules"));
        ((Container)object2).add((Component)AppController.createScrollPane(this.ixRuleTable), "Center");
        ((Container)object2).add((Component)this.ixRuleModel.filterPanel, "South");
        this.ixRuleEditors = new HashMap();
        JButton jButton = new JButton("Save Template");
        jButton.setFocusable(false);
        if (!this.template.template.isLocked) {
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TemplateEditor.this.saveIfNeeded("Save Template", false);
                }
            });
        } else {
            jButton.setEnabled(false);
        }
        JButton jButton2 = new JButton("Save & Close");
        jButton2.setFocusable(false);
        if (!this.template.template.isLocked) {
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TemplateEditor.this.saveIfNeeded("Save Template", false) && TemplateEditor.this.windowShouldClose()) {
                        AppController.hideWindow(TemplateEditor.this.outerThis);
                    }
                }
            });
        } else {
            jButton2.setText("Close");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TemplateEditor.this.closeWithoutSave();
                }
            });
        }
        JButton jButton3 = new JButton("New");
        jButton3.setFocusable(false);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateEditor.this.doNewIxRule();
            }
        });
        this.editIxRuleButton = !this.template.template.isLocked ? new JButton("Edit") : new JButton("View");
        this.editIxRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateEditor.this.doOpenIxRule();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jButton3);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.editIxRuleButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)object2, "Center");
        jPanel5.add((Component)jPanel4, "South");
        this.editorTabPane = new JTabbedPane();
        this.editorTabPane.addTab("Parameters", jPanel);
        this.editorTabPane.addTab("Rules", jPanel5);
        this.editorTabPane.setSelectedIndex(0);
        this.editorTabPane.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TemplateEditor.this.updateFileMenu();
            }
        });
        JPanel jPanel6 = new JPanel(new FlowLayout(2));
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.editorTabPane, "Center");
        container.add((Component)jPanel6, "South");
        this.pack();
        Dimension dimension = new Dimension(980, 650);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.updateFileMenu();
        this.updateDocumentName();
    }

    private void updateFileMenu() {
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2;
        int n = this.editorTabPane.getSelectedIndex();
        if (n == this.lastSelectedTab) {
            return;
        }
        this.lastSelectedTab = n;
        this.fileMenu.removeAll();
        switch (n) {
            case 0: {
                this.getRootPane().setDefaultButton(null);
                this.fileMenu.setText("Parameter");
                break;
            }
            case 1: {
                this.getRootPane().setDefaultButton(this.editIxRuleButton);
                this.fileMenu.setText("Rule");
                jMenuItem2 = new JMenuItem("Previous");
                jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(38, AppController.MENU_SHORTCUT_KEY_MASK));
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TemplateEditor.this.doPreviousRule();
                    }
                });
                this.fileMenu.add(jMenuItem2);
                jMenuItem = new JMenuItem("Next");
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(40, AppController.MENU_SHORTCUT_KEY_MASK));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TemplateEditor.this.doNextRule();
                    }
                });
                this.fileMenu.add(jMenuItem);
                this.fileMenu.addSeparator();
                JMenuItem jMenuItem3 = new JMenuItem("New...");
                jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(78, AppController.MENU_SHORTCUT_KEY_MASK));
                if (!this.template.template.isLocked) {
                    jMenuItem3.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TemplateEditor.this.doNewIxRule();
                        }
                    });
                } else {
                    jMenuItem3.setEnabled(false);
                }
                this.fileMenu.add(jMenuItem3);
                this.fileMenu.addSeparator();
                this.editIxRuleMenuItem = !this.template.template.isLocked ? new JMenuItem("Edit") : new JMenuItem("View");
                this.editIxRuleMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppController.MENU_SHORTCUT_KEY_MASK));
                this.editIxRuleMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TemplateEditor.this.doOpenIxRule();
                    }
                });
                this.fileMenu.add(this.editIxRuleMenuItem);
                this.deleteIxRuleMenuItem = new JMenuItem("Delete");
                if (!this.template.template.isLocked) {
                    this.deleteIxRuleMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TemplateEditor.this.doDeleteIxRule();
                        }
                    });
                } else {
                    this.deleteIxRuleMenuItem.setEnabled(false);
                }
                this.fileMenu.add(this.deleteIxRuleMenuItem);
                this.fileMenu.addSeparator();
                this.updateRuleControls();
                break;
            }
        }
        jMenuItem2 = new JMenuItem("Save Template");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(83, AppController.MENU_SHORTCUT_KEY_MASK));
        if (!this.template.template.isLocked) {
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TemplateEditor.this.saveIfNeeded("Save Template", false);
                }
            });
        } else {
            jMenuItem2.setEnabled(false);
        }
        this.fileMenu.add(jMenuItem2);
        jMenuItem = new JMenuItem("Save And Lock");
        if (!this.template.template.isLocked) {
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TemplateEditor.this.doSaveAndLock();
                }
            });
        } else {
            jMenuItem.setEnabled(false);
        }
        this.fileMenu.add(jMenuItem);
    }

    private void updateRuleControls() {
        int n = this.ixRuleTable.getSelectedRowCount();
        boolean bl = false;
        boolean bl2 = false;
        if (1 == n) {
            bl = true;
        }
        if (n > 0) {
            bl2 = !this.template.template.isLocked;
        }
        this.editIxRuleButton.setEnabled(bl);
        this.editIxRuleMenuItem.setEnabled(bl);
        this.deleteIxRuleMenuItem.setEnabled(bl2);
    }

    @Override
    public String getDbID() {
        return this.template.dbID;
    }

    @Override
    public RootEditor getRootEditor() {
        return this;
    }

    @Override
    public void updateDocumentName() {
        String string = DbCore.getHostDbName((String)this.getDbID());
        if (null == string) {
            this.setDocumentName(this.template.name);
        } else {
            this.setDocumentName(string + "/" + this.template.name);
        }
        for (IxRuleEditor ixRuleEditor : this.ixRuleEditors.values()) {
            ixRuleEditor.updateDocumentName();
        }
    }

    public int getTemplateKey() {
        return this.template.template.key;
    }

    @Override
    protected boolean isDataValid(String string) {
        if (!super.isDataValid(string)) {
            return false;
        }
        if (!this.commitCurrentField()) {
            return false;
        }
        this.errorReporter.setTitle(string);
        return this.template.isDataValid((ErrorLogger)this.errorReporter);
    }

    @Override
    protected boolean isDataChanged() {
        this.dataChanged = this.template.isDataChanged();
        return this.dataChanged;
    }

    @Override
    protected boolean save(String string) {
        if (!super.save(string)) {
            this.dataChanged = false;
            return false;
        }
        if (!this.dataChanged) {
            return false;
        }
        this.dataChanged = false;
        this.errorReporter.setTitle(string);
        BackgroundWorker<Boolean> backgroundWorker = new BackgroundWorker<Boolean>((Window)this, string){

            @Override
            protected Boolean doBackgroundWork(ErrorLogger errorLogger) {
                return TemplateEditor.this.template.save(errorLogger);
            }
        };
        this.errorReporter.clearMessages();
        Boolean bl = (Boolean)backgroundWorker.runWork("Saving template, please wait...", this.errorReporter);
        boolean bl2 = false;
        if (null != bl) {
            bl2 = bl;
        }
        if (bl2) {
            this.updateDocumentName();
            this.parent.applyEditsFrom(this);
            this.errorReporter.showMessages();
            return true;
        }
        return false;
    }

    @Override
    public boolean saveIfNeeded(String string, boolean bl) {
        String string2 = null;
        DbConnection dbConnection = DbCore.connectDb((String)this.getDbID());
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT template_key FROM template WHERE template_key = " + this.template.template.key);
                if (!dbConnection.next()) {
                    string2 = "The template does not exist";
                }
            }
            catch (SQLException sQLException) {
                string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError((SQLException)sQLException);
            }
            DbCore.releaseDb((DbConnection)dbConnection);
        } else {
            string2 = "A connection to the database server cannot be established";
        }
        if (null != string2) {
            AppController.beep();
            return 0 != JOptionPane.showConfirmDialog(this, string2 + "\n\nThe template cannot be saved.  You may keep the window\nopen to view data.  Do you want to keep the window open?", string, 0, 0);
        }
        return super.saveIfNeeded(string, bl);
    }

    private void doPreviousRule() {
        int n = this.ixRuleTable.getRowCount();
        int n2 = this.ixRuleTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.ixRuleTable.setRowSelectionInterval(n2, n2);
            this.ixRuleTable.scrollRectToVisible(this.ixRuleTable.getCellRect(n2, 0, true));
        }
    }

    private void doNextRule() {
        int n = this.ixRuleTable.getRowCount();
        int n2 = this.ixRuleTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.ixRuleTable.setRowSelectionInterval(n2, n2);
            this.ixRuleTable.scrollRectToVisible(this.ixRuleTable.getCellRect(n2, 0, true));
        }
    }

    private void doNewIxRule() {
        if (this.template.template.isLocked) {
            return;
        }
        Integer n = this.template.getNewIxRuleKey();
        IxRuleEditor ixRuleEditor = new IxRuleEditor((AppEditor)this, 0, new IxRuleEditData(n));
        AppController.showWindow(ixRuleEditor);
        this.ixRuleEditors.put(n, ixRuleEditor);
    }

    private void doOpenIxRule() {
        if (this.ixRuleTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.ixRuleTable.convertRowIndexToModel(this.ixRuleTable.getSelectedRow());
        IxRuleEditData ixRuleEditData = this.ixRuleModel.get(n);
        IxRuleEditor ixRuleEditor = this.ixRuleEditors.get(ixRuleEditData.key);
        if (null != ixRuleEditor) {
            if (ixRuleEditor.isVisible()) {
                ixRuleEditor.toFront();
                return;
            }
            this.ixRuleEditors.remove(ixRuleEditData.key);
        }
        ixRuleEditor = new IxRuleEditor((AppEditor)this, 0, ixRuleEditData);
        AppController.showWindow(ixRuleEditor);
        this.ixRuleEditors.put(ixRuleEditData.key, ixRuleEditor);
    }

    private void doDeleteIxRule() {
        if (this.template.template.isLocked) {
            return;
        }
        if (0 == this.ixRuleTable.getSelectedRowCount()) {
            return;
        }
        int[] nArray = this.ixRuleTable.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.ixRuleTable.convertRowIndexToModel(nArray[i]);
            IxRuleEditData ixRuleEditData = this.ixRuleModel.get(nArray2[i]);
            IxRuleEditor ixRuleEditor = this.ixRuleEditors.get(ixRuleEditData.key);
            if (null == ixRuleEditor) continue;
            if (ixRuleEditor.isVisible() && !ixRuleEditor.cancel()) {
                AppController.beep();
                ixRuleEditor.toFront();
                return;
            }
            this.ixRuleEditors.remove(ixRuleEditData.key);
        }
        this.ixRuleModel.remove(nArray2);
    }

    private void doSaveAndLock() {
        if (this.template.template.isLocked) {
            return;
        }
        for (IxRuleEditor ixRuleEditor : new ArrayList<IxRuleEditor>(this.ixRuleEditors.values())) {
            if (ixRuleEditor.isVisible()) {
                AppController.beep();
                ixRuleEditor.toFront();
                return;
            }
            this.ixRuleEditors.remove(ixRuleEditor.getIxRule().key);
        }
        if (!this.saveIfNeeded("Save Template", false)) {
            return;
        }
        String string = "Lock Template";
        this.errorReporter.setTitle(string);
        int n = 0;
        DbConnection dbConnection = DbCore.connectDb((String)this.getDbID(), (ErrorLogger)this.errorReporter);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT COUNT(*) FROM study WHERE template_key = " + this.template.template.key);
                dbConnection.next();
                n = dbConnection.getInt(1);
                DbCore.releaseDb((DbConnection)dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb((DbConnection)dbConnection);
                DbConnection.reportError((ErrorLogger)this.errorReporter, (SQLException)sQLException);
                return;
            }
        } else {
            return;
        }
        class PromptDialog
        extends AppDialog {
            private JRadioButton lockTemplateAndStudyButton;
            private boolean canceled;

            PromptDialog(String string, int n) {
                super(TemplateEditor.this.outerThis, string, Dialog.ModalityType.APPLICATION_MODAL);
                JRadioButton jRadioButton = new JRadioButton("Lock template only", true);
                this.lockTemplateAndStudyButton = new JRadioButton("Lock template and study settings", false);
                this.lockTemplateAndStudyButton.setEnabled(0 == n);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(jRadioButton);
                buttonGroup.add(this.lockTemplateAndStudyButton);
                JLabel jLabel = new JLabel("<HTML>Locking a template prevents it from being modified.  Once a template is<BR>locked it cannot be unlocked.  Rules and parameters in studies based on<BR>the template may also be locked so the study settings cannot be modified.<BR>(That option is available only if the template is not currently in use).</HTML>");
                JButton jButton = new JButton("OK");
                jButton.setFocusable(false);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doOK();
                    }
                });
                JButton jButton2 = new JButton("Cancel");
                jButton2.setFocusable(false);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doCancel();
                    }
                });
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 0, 20));
                jPanel.add(jLabel);
                jPanel.add(Box.createVerticalStrut(10));
                jPanel.add(jRadioButton);
                jPanel.add(this.lockTemplateAndStudyButton);
                JPanel jPanel2 = new JPanel(new FlowLayout(2));
                jPanel2.add(jButton2);
                jPanel2.add(jButton);
                Container container = this.getContentPane();
                container.setLayout(new BorderLayout());
                container.add((Component)jPanel, "Center");
                container.add((Component)jPanel2, "South");
                this.pack();
                this.setLocationRelativeTo(TemplateEditor.this.outerThis);
            }

            private void doOK() {
                AppController.hideWindow(this);
            }

            private void doCancel() {
                this.canceled = true;
                AppController.hideWindow(this);
            }

            @Override
            public void windowWillOpen() {
                this.blockActionsClear();
            }

            @Override
            public void windowWillClose() {
                this.blockActionsSet();
            }
        }
        PromptDialog promptDialog = new PromptDialog(string, n);
        AppController.beep();
        AppController.showWindow(promptDialog);
        if (promptDialog.canceled) {
            return;
        }
        dbConnection = DbCore.connectDb((String)this.getDbID(), (ErrorLogger)this.errorReporter);
        if (null == dbConnection) {
            return;
        }
        boolean bl = promptDialog.lockTemplateAndStudyButton.isSelected();
        boolean bl2 = false;
        String string2 = null;
        try {
            dbConnection.update("LOCK TABLES template WRITE, study WRITE");
            if (bl) {
                dbConnection.query("SELECT COUNT(*) FROM study WHERE template_key = " + this.template.template.key);
                dbConnection.next();
                n = dbConnection.getInt(1);
                if (0 == n) {
                    dbConnection.update("UPDATE template SET locked = true, locked_in_study = true WHERE template_key = " + this.template.template.key);
                } else {
                    bl2 = true;
                    string2 = "The template is in use, it cannot be study-locked";
                }
            } else {
                dbConnection.update("UPDATE template SET locked = true WHERE template_key = " + this.template.template.key);
            }
        }
        catch (SQLException sQLException) {
            bl2 = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError((SQLException)sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError((SQLException)sQLException);
        }
        DbCore.releaseDb((DbConnection)dbConnection);
        if (bl2) {
            this.errorReporter.reportError(string2);
            return;
        }
        this.parent.applyEditsFrom(this);
        AppController.hideWindow(this);
    }

    @Override
    public boolean applyEditsFrom(AppEditor appEditor) {
        if (appEditor instanceof IxRuleEditor) {
            if (this.template.template.isLocked) {
                return false;
            }
            IxRuleEditor ixRuleEditor = (IxRuleEditor)appEditor;
            IxRuleEditData ixRuleEditData = ixRuleEditor.getIxRule();
            if (ixRuleEditor != this.ixRuleEditors.get(ixRuleEditData.key)) {
                return false;
            }
            if (this.template.ixRuleData.isIxRuleUnique(ixRuleEditData, (ErrorLogger)ixRuleEditor.getErrorReporter())) {
                int n = this.ixRuleModel.addOrReplace(ixRuleEditData);
                if (n >= 0) {
                    n = this.ixRuleTable.convertRowIndexToView(n);
                    this.ixRuleTable.setRowSelectionInterval(n, n);
                    this.ixRuleTable.scrollRectToVisible(this.ixRuleTable.getCellRect(n, 0, true));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void editorClosing(AppEditor appEditor) {
        if (appEditor instanceof IxRuleEditor) {
            this.ixRuleEditors.remove(((IxRuleEditor)appEditor).getIxRule().key, (IxRuleEditor)appEditor);
            return;
        }
    }

    @Override
    public boolean closeWithoutSave() {
        for (IxRuleEditor ixRuleEditor : new ArrayList<IxRuleEditor>(this.ixRuleEditors.values())) {
            if (ixRuleEditor.isVisible() && !ixRuleEditor.cancel()) {
                AppController.beep();
                ixRuleEditor.toFront();
                return false;
            }
            this.ixRuleEditors.remove(ixRuleEditor.getIxRule().key);
        }
        AppController.hideWindow(this);
        return true;
    }

    @Override
    public void windowWillOpen() {
        DbController.restoreColumnWidths(this.getDbID(), this.getKeyTitle() + ".Rules", this.ixRuleTable);
        this.blockActionsClear();
        if (this.hasNewParameters) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TemplateEditor.this.errorReporter.setTitle("New Parameters");
                    AppController.beep();
                    TemplateEditor.this.errorReporter.reportMessage("New parameters have been added to the template");
                }
            });
        }
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        boolean bl = this.template.template.isLocked;
        for (IxRuleEditor ixRuleEditor : new ArrayList<IxRuleEditor>(this.ixRuleEditors.values())) {
            if (!(!ixRuleEditor.isVisible() || bl && ixRuleEditor.cancel())) {
                AppController.beep();
                ixRuleEditor.toFront();
                return false;
            }
            this.ixRuleEditors.remove(ixRuleEditor.getIxRule().key);
        }
        if (!this.saveIfNeeded("Close Template", true)) {
            this.toFront();
            return false;
        }
        return true;
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        DbController.saveColumnWidths(this.getDbID(), this.getKeyTitle() + ".Rules", this.ixRuleTable);
        this.blockActionsSet();
        this.parent.editorClosing(this);
    }

    private class IxRuleTableModel
    extends AbstractTableModel
    implements TableFilterModel {
        private static final String IXRULE_COUNTRY_COLUMN = "Country D";
        private static final String IXRULE_SERVICE_COLUMN = "Service D";
        private static final String IXRULE_BAND_COLUMN = "Band D";
        private static final String IXRULE_USERVICE_COLUMN = "Service U";
        private static final String IXRULE_CHANNEL_COLUMN = "Channel U";
        private static final String IXRULE_MASK_COLUMN = "Mask U";
        private static final String IXRULE_OFFSET_COLUMN = "Offset";
        private static final String IXRULE_DISTANCE_COLUMN = "Distance";
        private static final String IXRULE_DU_COLUMN = "D/U";
        private static final String IXRULE_UTIME_COLUMN = "% Time U";
        private String[] columnNames = new String[]{"Country D", "Service D", "Band D", "Service U", "Channel U", "Mask U", "Offset", "Distance", "D/U", "% Time U"};
        private static final int IXRULE_COUNTRY_INDEX = 0;
        private static final int IXRULE_SERVICE_INDEX = 1;
        private static final int IXRULE_BAND_INDEX = 2;
        private static final int IXRULE_USERVICE_INDEX = 3;
        private static final int IXRULE_CHANNEL_INDEX = 4;
        private static final int IXRULE_MASK_INDEX = 5;
        private static final int IXRULE_OFFSET_INDEX = 6;
        private static final int IXRULE_DISTANCE_INDEX = 7;
        private static final int IXRULE_DU_INDEX = 8;
        private static final int IXRULE_UTIME_INDEX = 9;
        private NumberFormat doubleFormatter = NumberFormat.getInstance(Locale.US);
        private TableFilterPanel filterPanel;

        private IxRuleTableModel() {
            this.doubleFormatter.setMinimumFractionDigits(2);
            this.doubleFormatter.setMaximumFractionDigits(2);
            this.doubleFormatter.setMinimumIntegerDigits(1);
            this.filterPanel = new TableFilterPanel((AppEditor)TemplateEditor.this.outerThis, this);
        }

        private JTable createTable(EditMenu editMenu) {
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable, editMenu);
            jTable.setAutoCreateRowSorter(true);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (!bl) {
                        if (((IxRuleTableModel)IxRuleTableModel.this).get((int)jTable.convertRowIndexToModel((int)n)).isActive) {
                            jLabel.setForeground(Color.BLACK);
                        } else {
                            jLabel.setForeground(Color.GRAY.brighter());
                        }
                    }
                    if (7 == n2 || 8 == n2 || 9 == n2) {
                        jLabel.setHorizontalAlignment(4);
                    } else {
                        jLabel.setHorizontalAlignment(2);
                    }
                    return jLabel;
                }
            };
            DefaultTableCellRenderer defaultTableCellRenderer2 = (DefaultTableCellRenderer)new JTableHeader().getDefaultRenderer();
            defaultTableCellRenderer2.setHorizontalAlignment(4);
            TableColumn tableColumn = jTable.getColumn(IXRULE_COUNTRY_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
            tableColumn = jTable.getColumn(IXRULE_SERVICE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[8]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[15]);
            tableColumn = jTable.getColumn(IXRULE_BAND_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[5]);
            tableColumn = jTable.getColumn(IXRULE_USERVICE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[8]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[15]);
            tableColumn = jTable.getColumn(IXRULE_CHANNEL_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[10]);
            tableColumn = jTable.getColumn(IXRULE_MASK_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[10]);
            tableColumn = jTable.getColumn(IXRULE_OFFSET_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
            tableColumn = jTable.getColumn(IXRULE_DISTANCE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
            tableColumn = jTable.getColumn(IXRULE_DU_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
            tableColumn = jTable.getColumn(IXRULE_UTIME_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[5]);
            return jTable;
        }

        private int addOrReplace(IxRuleEditData ixRuleEditData) {
            this.postChange(((TemplateEditor)TemplateEditor.this).template.ixRuleData.addOrReplace(ixRuleEditData));
            int n = ((TemplateEditor)TemplateEditor.this).template.ixRuleData.getLastRowChanged();
            if (n >= 0) {
                return this.filterPanel.reverseIndex[n];
            }
            return n;
        }

        private IxRuleEditData get(int n) {
            return ((TemplateEditor)TemplateEditor.this).template.ixRuleData.get(this.filterPanel.forwardIndex[n]);
        }

        private void remove(int n) {
            this.postChange(((TemplateEditor)TemplateEditor.this).template.ixRuleData.remove(this.filterPanel.forwardIndex[n]));
        }

        private void remove(int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.filterPanel.forwardIndex[nArray[i]];
            }
            this.postChange(((TemplateEditor)TemplateEditor.this).template.ixRuleData.remove(nArray2));
        }

        private void setActive(int n, boolean bl) {
            this.postChange(((TemplateEditor)TemplateEditor.this).template.ixRuleData.setActive(this.filterPanel.forwardIndex[n], bl));
        }

        private void postChange(boolean bl) {
            if (bl) {
                int n = ((TemplateEditor)TemplateEditor.this).template.ixRuleData.getLastRowChanged();
                int n2 = -1;
                int n3 = -1;
                if (n >= 0 && n < this.filterPanel.reverseIndex.length) {
                    n2 = this.filterPanel.reverseIndex[n];
                }
                this.filterPanel.updateFilter();
                if (n >= 0 && n < this.filterPanel.reverseIndex.length) {
                    n3 = this.filterPanel.reverseIndex[n];
                }
                switch (((TemplateEditor)TemplateEditor.this).template.ixRuleData.getLastChange()) {
                    default: {
                        break;
                    }
                    case 1: {
                        this.fireTableDataChanged();
                        break;
                    }
                    case 2: {
                        if (n3 < 0) break;
                        this.fireTableRowsInserted(n3, n3);
                        break;
                    }
                    case 3: {
                        if (n2 >= 0) {
                            if (n3 >= 0) {
                                this.fireTableRowsUpdated(n2, n3);
                                break;
                            }
                            this.fireTableRowsDeleted(n2, n2);
                            break;
                        }
                        if (n3 < 0) break;
                        this.fireTableRowsInserted(n3, n3);
                        break;
                    }
                    case 4: {
                        if (n2 < 0) break;
                        this.fireTableRowsDeleted(n2, n2);
                    }
                }
            }
        }

        private void dataWasChanged() {
            this.filterPanel.updateFilter();
            this.fireTableDataChanged();
        }

        @Override
        public void filterDidChange() {
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public boolean filterByColumn(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean collapseFilterChoices(int n) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.filterPanel.forwardIndex.length;
        }

        @Override
        public int getUnfilteredRowCount() {
            return ((TemplateEditor)TemplateEditor.this).template.ixRuleData.getRowCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.getUnfilteredValueAt(this.filterPanel.forwardIndex[n], n2);
        }

        @Override
        public String getUnfilteredValueAt(int n, int n2) {
            IxRuleEditData ixRuleEditData = ((TemplateEditor)TemplateEditor.this).template.ixRuleData.get(n);
            switch (n2) {
                case 0: {
                    return ixRuleEditData.country.name;
                }
                case 1: {
                    return ixRuleEditData.serviceType.name;
                }
                case 2: {
                    return ixRuleEditData.channelBand.name;
                }
                case 3: {
                    return ixRuleEditData.undesiredServiceType.name;
                }
                case 4: {
                    return ixRuleEditData.channelDelta.name;
                }
                case 5: {
                    return ixRuleEditData.emissionMask.name;
                }
                case 6: {
                    switch (ixRuleEditData.frequencyOffset) {
                        default: {
                            return "(any)";
                        }
                        case 1: {
                            return "Without";
                        }
                        case 2: 
                    }
                    return "With";
                }
                case 7: {
                    return this.doubleFormatter.format(ixRuleEditData.distance);
                }
                case 8: {
                    return this.doubleFormatter.format(ixRuleEditData.requiredDU);
                }
                case 9: {
                    return String.valueOf(ixRuleEditData.undesiredTime);
                }
            }
            return "";
        }
    }
}

