/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.AntPattern;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordFM;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.FrequencyOffset;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.SignalType;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.core.data.Zone;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataFM;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.SourceEditDataWL;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import gov.fcc.tvstudy.core.geo.GeoSectors;
import gov.fcc.tvstudy.core.geo.Geography;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.CoordinateCopyPastePanel;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.RecordFindDialog;
import gov.fcc.tvstudy.gui.StudyManager;
import gov.fcc.tvstudy.gui.editor.CoordinatePanel;
import gov.fcc.tvstudy.gui.editor.GeoEditPanel;
import gov.fcc.tvstudy.gui.editor.GeoPlotPanel;
import gov.fcc.tvstudy.gui.editor.PatternEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SourceEditor
extends AppDialog {
    public static final String WINDOW_TITLE = "Station Data";
    private Integer originalSourceKey;
    private SourceEditData mainSource;
    private boolean isPermanentInScenario;
    private boolean isTV;
    private boolean isWL;
    private boolean isFM;
    private SourceEditDataTV mainSourceTV;
    private SourceEditDataWL mainSourceWL;
    private SourceEditDataFM mainSourceFM;
    private boolean isNewSource;
    private boolean canEdit;
    private boolean canAddRemoveDTS;
    private int minimumChannel;
    private int maximumChannel;
    private Service service;
    private Country country;
    private int facilityID;
    private int stationClass;
    private JPanel editorPanel;
    private JTabbedPane dtsTabPane;
    private HashSet<SourcePanel> sourcePanels;
    private KeyedRecordMenu addSiteMenu;
    private JButton removeSiteButton;
    private JPanel addRemovePanel;
    private JButton closeButton;
    private JButton applyButton;
    private HashMap<PatternEditor, SourcePanel> patternEditorIndex;
    private ArrayList<KeyedRecord> serviceAreaModeList;
    private ArrayList<KeyedRecord> serviceAreaGeographyList;
    private boolean showServiceArea;
    private SourceEditor outerThis = this;
    private String channelNote;

    public SourceEditor(AppEditor appEditor) {
        super(appEditor, null, WINDOW_TITLE, Dialog.ModalityType.MODELESS);
        this.sourcePanels = new HashSet();
        this.patternEditorIndex = new HashMap();
        this.serviceAreaModeList = new ArrayList();
        this.serviceAreaModeList.add(new KeyedRecord(0, "Default contour"));
        this.serviceAreaModeList.add(new KeyedRecord(1, "FCC curves contour"));
        this.serviceAreaModeList.add(new KeyedRecord(8, "FCC contour plus distance"));
        this.serviceAreaModeList.add(new KeyedRecord(9, "FCC contour plus percent"));
        this.serviceAreaModeList.add(new KeyedRecord(2, "L-R contour percent above"));
        this.serviceAreaModeList.add(new KeyedRecord(3, "L-R contour length above"));
        this.serviceAreaModeList.add(new KeyedRecord(4, "L-R contour length below"));
        this.serviceAreaModeList.add(new KeyedRecord(11, "L-R contour line fit"));
        this.serviceAreaModeList.add(new KeyedRecord(10, "Constant distance"));
        this.serviceAreaModeList.add(new KeyedRecord(5, "Geography fixed"));
        this.serviceAreaModeList.add(new KeyedRecord(6, "Geography relocated"));
        this.serviceAreaModeList.add(new KeyedRecord(7, "Unrestricted"));
        this.editorPanel = new JPanel();
        this.dtsTabPane = new JTabbedPane();
        this.dtsTabPane.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SourceEditor.this.removeSiteButton.setEnabled(SourceEditor.this.canAddRemoveDTS && SourceEditor.this.dtsTabPane.getSelectedIndex() > 1 && SourceEditor.this.dtsTabPane.getTabCount() > 3);
            }
        });
        this.addSiteMenu = new KeyedRecordMenu();
        this.addSiteMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.blockActions()) {
                    SourceEditor.this.doAddSite();
                    SourceEditor.this.blockActionsEnd();
                }
            }
        });
        this.removeSiteButton = new JButton("Remove Site");
        this.removeSiteButton.setFocusable(false);
        this.removeSiteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.blockActions()) {
                    SourceEditor.this.doRemoveSite();
                    SourceEditor.this.blockActionsEnd();
                }
            }
        });
        this.closeButton = new JButton("Close");
        this.closeButton.setFocusable(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceEditor.this.cancel();
            }
        });
        this.applyButton = new JButton("OK");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceEditor.this.doApply();
            }
        });
        this.addRemovePanel = new JPanel(new FlowLayout(0));
        this.addRemovePanel.add(this.addSiteMenu);
        this.addRemovePanel.add(this.removeSiteButton);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.closeButton);
        jPanel.add(this.applyButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.addRemovePanel);
        jPanel2.add(jPanel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.editorPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(this.applyButton);
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public void updateDocumentName() {
        String string = this.parent.getDocumentName();
        if (null != this.mainSource && this.mainSource.callSign.length() > 0) {
            string = null == string ? this.mainSource.callSign : string + "/" + this.mainSource.callSign;
            if (null != this.mainSource.study) {
                StudyManager.updateGeographyEditor(this.getDbID(), this.mainSource.study.study.key, this.mainSource.study.name, this.mainSource.key, this.mainSource.callSign);
            }
        }
        this.setDocumentName(string);
        for (PatternEditor patternEditor : this.patternEditorIndex.keySet()) {
            patternEditor.updateDocumentName();
        }
    }

    public void geographyChanged(int n, int n2, Integer n3, int n4) {
        int n5 = 0;
        if (null != n3) {
            int n6 = 0;
            int n7 = 0;
            if (null != this.mainSource && null != this.mainSource.study) {
                n6 = this.mainSource.study.study.key;
                n7 = this.mainSource.key;
            }
            if (n == n6 && n2 == n7 && 1 != n4) {
                n5 = n3;
            }
        }
        this.updateGeographies(n5);
        if (null != n3) {
            for (SourcePanel sourcePanel : this.sourcePanels) {
                sourcePanel.geographyEditPending = false;
            }
        }
    }

    public void geographyScopeChanged(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (null != this.mainSource && null != this.mainSource.study) {
            n3 = this.mainSource.study.study.key;
            n4 = this.mainSource.key;
        }
        if (n != n3 || n2 != n4) {
            for (SourcePanel sourcePanel : this.sourcePanels) {
                sourcePanel.geographyEditPending = false;
            }
        }
    }

    private void updateGeographies(int n) {
        int n2 = 0;
        int n3 = 0;
        if (null != this.mainSource && null != this.mainSource.study) {
            n2 = this.mainSource.study.study.key;
            n3 = this.mainSource.key;
        }
        this.serviceAreaGeographyList = Geography.getGeographyList((String)this.getDbID(), (int)n2, (int)n3, (int)2);
        if (null == this.serviceAreaGeographyList) {
            this.serviceAreaGeographyList = new ArrayList();
        }
        this.serviceAreaGeographyList.add(0, new KeyedRecord(0, "(none)"));
        for (SourcePanel sourcePanel : this.sourcePanels) {
            sourcePanel.updateGeographies(n);
        }
    }

    public boolean setSource(SourceEditData sourceEditData, boolean bl) {
        return this.setSource(sourceEditData, bl, false, true, null);
    }

    public boolean setSource(SourceEditData sourceEditData, boolean bl, ErrorReporter errorReporter) {
        return this.setSource(sourceEditData, false, bl, false, errorReporter);
    }

    private boolean setSource(SourceEditData sourceEditData, boolean bl, boolean bl2, boolean bl3, ErrorReporter errorReporter) {
        if (this.isVisible()) {
            return false;
        }
        this.originalSourceKey = sourceEditData.key;
        if (bl2) {
            this.mainSource = sourceEditData.deriveSource(false, (ErrorLogger)errorReporter);
            if (null == this.mainSource) {
                return false;
            }
            this.isNewSource = true;
            this.canEdit = true;
        } else {
            this.mainSource = sourceEditData.copy();
            this.isNewSource = false;
            this.canEdit = !this.mainSource.isLocked;
        }
        this.isPermanentInScenario = bl;
        this.showServiceArea = bl3;
        this.canAddRemoveDTS = this.canEdit;
        if (this.isPermanentInScenario && null != this.mainSource.study && (3 == this.mainSource.study.study.studyType || 5 == this.mainSource.study.study.studyType)) {
            this.canAddRemoveDTS = false;
        }
        this.service = this.mainSource.service;
        this.country = this.mainSource.country;
        this.isTV = false;
        this.isWL = false;
        this.isFM = false;
        this.mainSourceTV = null;
        this.mainSourceWL = null;
        this.mainSourceFM = null;
        switch (this.mainSource.recordType) {
            case 1: {
                this.isTV = true;
                this.mainSourceTV = (SourceEditDataTV)this.mainSource;
                this.facilityID = this.mainSourceTV.facilityID;
                this.stationClass = 0;
                if (null != this.mainSourceTV.study) {
                    this.minimumChannel = this.mainSourceTV.study.getMinimumChannel();
                    this.maximumChannel = this.mainSourceTV.study.getMaximumChannel();
                    break;
                }
                this.minimumChannel = 2;
                this.maximumChannel = 69;
                break;
            }
            case 2: {
                this.isWL = true;
                this.mainSourceWL = (SourceEditDataWL)this.mainSource;
                this.facilityID = 0;
                this.stationClass = 0;
                this.minimumChannel = 0;
                this.maximumChannel = 0;
                break;
            }
            case 3: {
                this.isFM = true;
                this.mainSourceFM = (SourceEditDataFM)this.mainSource;
                this.facilityID = this.mainSourceFM.facilityID;
                this.stationClass = this.mainSourceFM.stationClass;
                this.minimumChannel = 200;
                this.maximumChannel = 300;
                break;
            }
            default: {
                return false;
            }
        }
        this.updateDocumentName();
        this.updateGeographies(0);
        this.updateLayout();
        if (this.canEdit) {
            this.closeButton.setText("Cancel");
            this.applyButton.setVisible(true);
        } else {
            this.closeButton.setText("Close");
            this.applyButton.setVisible(false);
        }
        return true;
    }

    public void setChannelNote(String string) {
        this.channelNote = string;
    }

    public SourceEditData getSource() {
        return this.mainSource;
    }

    public Integer getOriginalSourceKey() {
        return this.originalSourceKey;
    }

    public boolean isEditing() {
        return this.canEdit;
    }

    public boolean isDeriving() {
        return this.isNewSource;
    }

    private void updateLayout() {
        Object object;
        for (PatternEditor object2 : this.patternEditorIndex.keySet()) {
            AppController.hideWindow(object2);
        }
        this.patternEditorIndex.clear();
        this.dtsTabPane.removeAll();
        this.editorPanel.removeAll();
        this.sourcePanels.clear();
        if (this.isTV && this.service.isDTS) {
            this.dtsTabPane.addTab("DTS Info", new DTSSourcePanel(this.mainSourceTV));
            for (SourceEditDataTV sourceEditDataTV : this.mainSourceTV.getDTSSources()) {
                object = new SourcePanel((SourceEditData)sourceEditDataTV);
                if (0 == sourceEditDataTV.siteNumber) {
                    this.dtsTabPane.insertTab("Authorized", null, (Component)object, null, 1);
                } else {
                    this.dtsTabPane.addTab("Site " + sourceEditDataTV.siteNumber, (Component)object);
                }
                this.sourcePanels.add((SourcePanel)object);
            }
            this.dtsTabPane.setSelectedIndex(0);
            this.editorPanel.add(this.dtsTabPane);
            this.addRemovePanel.setVisible(true);
            this.addSiteMenu.setEnabled(this.canAddRemoveDTS);
            this.removeSiteButton.setEnabled(false);
            this.updateAddSiteMenu();
        } else {
            object = new SourcePanel(this.mainSource);
            this.editorPanel.add((Component)object);
            this.sourcePanels.add((SourcePanel)object);
            this.addRemovePanel.setVisible(false);
        }
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private void applyServiceChange(Service service) {
        SourceEditDataTV sourceEditDataTV;
        block8: {
            ArrayList arrayList;
            block9: {
                block7: {
                    if (!this.isTV || !this.isNewSource || this.service.isDTS == service.isDTS || 1 != service.serviceType.recordType) {
                        return;
                    }
                    if (!this.patternEditorIndex.isEmpty()) {
                        AppController.beep();
                        this.patternEditorIndex.keySet().iterator().next().toFront();
                        return;
                    }
                    sourceEditDataTV = null;
                    this.errorReporter.setTitle("Change Service");
                    if (this.service.isDTS || !service.isDTS) break block7;
                    sourceEditDataTV = this.mainSourceTV.deriveSourceTV(this.facilityID, service, this.country, false, (ErrorLogger)this.errorReporter);
                    break block8;
                }
                arrayList = this.mainSourceTV.getDTSSources();
                if (!arrayList.isEmpty()) break block9;
                sourceEditDataTV = SourceEditDataTV.createSource(null, (String)this.getDbID(), (int)this.facilityID, (Service)service, (boolean)false, (Country)this.country, (boolean)false, (ErrorLogger)this.errorReporter);
                if (null == sourceEditDataTV) break block8;
                sourceEditDataTV.callSign = this.mainSourceTV.callSign;
                sourceEditDataTV.channel = this.mainSourceTV.channel;
                sourceEditDataTV.city = this.mainSourceTV.city;
                sourceEditDataTV.state = this.mainSourceTV.state;
                sourceEditDataTV.zone = this.mainSourceTV.zone;
                sourceEditDataTV.status = this.mainSourceTV.status;
                sourceEditDataTV.statusType = this.mainSourceTV.statusType;
                sourceEditDataTV.fileNumber = this.mainSourceTV.fileNumber;
                sourceEditDataTV.appARN = this.mainSourceTV.appARN;
                sourceEditDataTV.location.setLatLon(this.mainSourceTV.location);
                break block8;
            }
            if (1 == arrayList.size()) {
                sourceEditDataTV = ((SourceEditDataTV)arrayList.get(0)).deriveSourceTV(this.facilityID, service, this.country, false, (ErrorLogger)this.errorReporter);
            } else {
                Object[] objectArray = new String[arrayList.size()];
                for (int i = 0; i < objectArray.length; ++i) {
                    SourceEditDataTV sourceEditDataTV2 = (SourceEditDataTV)arrayList.get(i);
                    objectArray[i] = 0 == sourceEditDataTV2.siteNumber ? "Authorized" : "Site " + sourceEditDataTV2.siteNumber;
                }
                String string = (String)JOptionPane.showInputDialog(null, "Choose site to convert", "Convert DTS to Non-DTS", 1, null, objectArray, objectArray[0]);
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!((String)objectArray[i]).equals(string)) continue;
                    sourceEditDataTV = ((SourceEditDataTV)arrayList.get(i)).deriveSourceTV(this.facilityID, service, this.country, false, (ErrorLogger)this.errorReporter);
                    break;
                }
            }
        }
        if (null != sourceEditDataTV) {
            this.mainSource = sourceEditDataTV;
            this.mainSourceTV = sourceEditDataTV;
            this.service = service;
            this.updateLayout();
        }
    }

    private void updateSourcePanels() {
        for (SourcePanel sourcePanel : this.sourcePanels) {
            sourcePanel.updateFields();
        }
    }

    private void doAddSite() {
        Object object;
        if (!(this.isTV && this.canAddRemoveDTS && this.mainSourceTV.isParent)) {
            return;
        }
        String string = "Add DTS Site";
        this.errorReporter.setTitle(string);
        StationRecord stationRecord = null;
        int n = this.addSiteMenu.getSelectedKey();
        this.addSiteMenu.setSelectedIndex(0);
        boolean bl = true;
        Object object2 = this.mainSourceTV.getDTSSources().iterator();
        while (object2.hasNext()) {
            object = (StationRecord)object2.next();
            if (0 == object.siteNumber) {
                bl = false;
            }
            if (n != object.siteNumber) continue;
            stationRecord = object;
        }
        if (-1 == n) {
            object2 = new RecordFindDialog((AppEditor)this, "Choose record to copy for new site", 1);
            if (null != this.mainSource.study) {
                ((RecordFindDialog)object2).setDefaultExtDbKey(this.mainSource.study.extDbKey);
                ((RecordFindDialog)object2).setStudy(this.mainSource.study);
            }
            AppController.showWindow((Window)object2);
            if (((RecordFindDialog)object2).canceled) {
                return;
            }
            object = ((RecordFindDialog)object2).getSelectedRecord();
            if (object.isSource()) {
                stationRecord = (SourceEditDataTV)object;
            } else {
                stationRecord = SourceEditDataTV.makeSourceTV((ExtDbRecordTV)((ExtDbRecordTV)object), null, (boolean)true, (ErrorLogger)this.errorReporter);
                if (null == stationRecord) {
                    return;
                }
            }
        }
        if (null != stationRecord && stationRecord.isParent) {
            object2 = stationRecord.getDTSSources();
            object = new String[((ArrayList)object2).size()];
            for (int i = 0; i < ((String[])object).length; ++i) {
                SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)((ArrayList)object2).get(i);
                object[i] = 0 == sourceEditDataTV.siteNumber ? "Authorized" : "Site " + sourceEditDataTV.siteNumber;
            }
            String string2 = (String)JOptionPane.showInputDialog(null, "Choose DTS site to copy", string, 1, null, (Object[])object, object[0]);
            for (int i = 0; i < ((StationRecord)object).length; ++i) {
                if (!object[i].equals(string2)) continue;
                stationRecord = (SourceEditDataTV)((ArrayList)object2).get(i);
                break;
            }
        }
        if (null == (object2 = bl ? this.mainSourceTV.createDTSSource(0, (ErrorLogger)this.errorReporter) : this.mainSourceTV.createDTSSource(this.mainSourceTV.getNextDTSSiteNumber(), (ErrorLogger)this.errorReporter))) {
            return;
        }
        if (null != stationRecord) {
            if (bl) {
                ((SourceEditDataTV)object2).channel = stationRecord.channel;
                ((SourceEditDataTV)object2).zone = stationRecord.zone;
                ((SourceEditDataTV)object2).status = stationRecord.status;
                ((SourceEditDataTV)object2).statusType = stationRecord.statusType;
                ((SourceEditDataTV)object2).fileNumber = stationRecord.fileNumber;
                ((SourceEditDataTV)object2).appARN = stationRecord.appARN;
                ((SourceEditDataTV)object2).signalType = stationRecord.signalType;
                ((SourceEditDataTV)object2).frequencyOffset = stationRecord.frequencyOffset;
                ((SourceEditDataTV)object2).emissionMask = stationRecord.emissionMask;
            }
            ((SourceEditDataTV)object2).location.setLatLon(stationRecord.location);
            ((SourceEditDataTV)object2).heightAMSL = stationRecord.heightAMSL;
            ((SourceEditDataTV)object2).overallHAAT = stationRecord.overallHAAT;
            ((SourceEditDataTV)object2).peakERP = stationRecord.peakERP;
            if (stationRecord.hasHorizontalPattern) {
                ((SourceEditDataTV)object2).antennaID = stationRecord.antennaID;
                ((SourceEditDataTV)object2).hasHorizontalPattern = true;
                ((SourceEditDataTV)object2).horizontalPattern = stationRecord.horizontalPattern.copy();
                ((SourceEditDataTV)object2).horizontalPatternChanged = true;
                ((SourceEditDataTV)object2).horizontalPatternOrientation = stationRecord.horizontalPatternOrientation;
            }
            if (stationRecord.hasVerticalPattern) {
                ((SourceEditDataTV)object2).hasVerticalPattern = true;
                ((SourceEditDataTV)object2).verticalPattern = stationRecord.verticalPattern.copy();
                ((SourceEditDataTV)object2).verticalPatternChanged = true;
            }
            ((SourceEditDataTV)object2).verticalPatternElectricalTilt = stationRecord.verticalPatternElectricalTilt;
            ((SourceEditDataTV)object2).verticalPatternMechanicalTilt = stationRecord.verticalPatternMechanicalTilt;
            ((SourceEditDataTV)object2).verticalPatternMechanicalTiltOrientation = stationRecord.verticalPatternMechanicalTiltOrientation;
            if (stationRecord.hasMatrixPattern) {
                ((SourceEditDataTV)object2).hasMatrixPattern = true;
                ((SourceEditDataTV)object2).matrixPattern = stationRecord.matrixPattern.copy();
                ((SourceEditDataTV)object2).matrixPatternChanged = true;
            }
            ((SourceEditDataTV)object2).dtsTimeDelay = stationRecord.dtsTimeDelay;
        }
        this.mainSourceTV.addOrReplaceDTSSource((SourceEditDataTV)object2);
        object = new SourcePanel((SourceEditData)object2);
        if (bl) {
            this.dtsTabPane.insertTab("Authorized", null, (Component)object, null, 1);
            this.dtsTabPane.setSelectedIndex(1);
        } else {
            this.dtsTabPane.addTab("Site " + ((SourceEditDataTV)object2).siteNumber, (Component)object);
            this.dtsTabPane.setSelectedIndex(this.dtsTabPane.getTabCount() - 1);
        }
        this.sourcePanels.add((SourcePanel)object);
        this.updateAddSiteMenu();
    }

    private void doRemoveSite() {
        if (!(this.isTV && this.canAddRemoveDTS && this.mainSourceTV.isParent && this.dtsTabPane.getTabCount() >= 4)) {
            return;
        }
        int n = this.dtsTabPane.getSelectedIndex();
        Component component = this.dtsTabPane.getComponentAt(n);
        if (!(component instanceof SourcePanel)) {
            return;
        }
        SourcePanel sourcePanel = (SourcePanel)component;
        if (0 == ((SourcePanel)sourcePanel).sourceTV.siteNumber) {
            return;
        }
        if (null != sourcePanel.horizontalPatternEditor) {
            AppController.hideWindow(sourcePanel.horizontalPatternEditor);
            this.patternEditorIndex.remove(sourcePanel.horizontalPatternEditor);
            sourcePanel.horizontalPatternEditor = null;
        }
        if (null != sourcePanel.verticalPatternEditor) {
            AppController.hideWindow(sourcePanel.verticalPatternEditor);
            this.patternEditorIndex.remove(sourcePanel.verticalPatternEditor);
            sourcePanel.verticalPatternEditor = null;
        }
        this.sourcePanels.remove(sourcePanel);
        this.dtsTabPane.removeTabAt(n);
        this.mainSourceTV.removeDTSSource(sourcePanel.sourceTV);
        this.removeSiteButton.setEnabled(this.dtsTabPane.getSelectedIndex() > 1 && this.dtsTabPane.getTabCount() > 3);
        this.updateAddSiteMenu();
    }

    private void updateAddSiteMenu() {
        this.addSiteMenu.removeAllItems();
        this.addSiteMenu.addItem(new KeyedRecord(-3, "Add Site..."));
        this.addSiteMenu.addItem(new KeyedRecord(-2, "Blank"));
        this.addSiteMenu.addItem(new KeyedRecord(-1, "Search"));
        int n = this.dtsTabPane.getTabCount();
        if (n > 1) {
            this.addSiteMenu.addItem(new KeyedRecord(0, "Copy Authorized"));
            if (n > 2) {
                for (int i = 2; i < n; ++i) {
                    Component component = this.dtsTabPane.getComponentAt(i);
                    if (!(component instanceof SourcePanel)) continue;
                    SourcePanel sourcePanel = (SourcePanel)component;
                    this.addSiteMenu.addItem(new KeyedRecord(((SourcePanel)sourcePanel).sourceTV.siteNumber, "Copy Site " + ((SourcePanel)sourcePanel).sourceTV.siteNumber));
                }
            }
        }
    }

    private void doApply() {
        if (!this.canEdit) {
            this.cancel();
            return;
        }
        if (!this.patternEditorIndex.isEmpty()) {
            AppController.beep();
            this.patternEditorIndex.keySet().iterator().next().toFront();
            return;
        }
        if (!this.commitCurrentField()) {
            return;
        }
        if (null != this.mainSource && null != this.mainSource.study && !StudyManager.closeGeographyScopeIfPossible(this.getDbID(), this.mainSource.study.study.key, this.mainSource.key)) {
            return;
        }
        this.errorReporter.clearTitle();
        if (this.isNewSource) {
            SourceEditDataWL sourceEditDataWL = null;
            SourceEditDataTV sourceEditDataTV = null;
            SourceEditDataWL sourceEditDataWL2 = null;
            SourceEditDataFM sourceEditDataFM = null;
            switch (this.mainSource.recordType) {
                case 1: {
                    sourceEditDataTV = this.mainSourceTV.deriveSourceTV(this.facilityID, this.service, this.country, false, (ErrorLogger)this.errorReporter);
                    sourceEditDataWL = sourceEditDataTV;
                    break;
                }
                case 2: {
                    sourceEditDataWL = sourceEditDataWL2 = this.mainSourceWL.deriveSourceWL(this.service, this.country, false, (ErrorLogger)this.errorReporter);
                    break;
                }
                case 3: {
                    sourceEditDataFM = this.mainSourceFM.deriveSourceFM(this.facilityID, this.service, this.stationClass, this.country, false, (ErrorLogger)this.errorReporter);
                    sourceEditDataWL = sourceEditDataFM;
                }
            }
            if (null == sourceEditDataWL) {
                return;
            }
            if (!sourceEditDataWL.isDataValid((ErrorLogger)this.errorReporter)) {
                return;
            }
            this.mainSource = sourceEditDataWL;
            this.mainSourceTV = sourceEditDataTV;
            this.mainSourceWL = sourceEditDataWL2;
            this.mainSourceFM = sourceEditDataFM;
        } else if (!this.mainSource.isDataValid((ErrorLogger)this.errorReporter)) {
            return;
        }
        if (this.parent.applyEditsFrom(this)) {
            AppController.hideWindow(this);
            return;
        }
        if (this.isNewSource) {
            this.updateLayout();
        }
    }

    @Override
    public boolean cancel() {
        if (!this.patternEditorIndex.isEmpty()) {
            HashSet<PatternEditor> hashSet = new HashSet<PatternEditor>(this.patternEditorIndex.keySet());
            for (PatternEditor patternEditor : hashSet) {
                if (patternEditor.cancel()) continue;
                AppController.beep();
                patternEditor.toFront();
                return false;
            }
        }
        if (null != this.mainSource && null != this.mainSource.study && !StudyManager.closeGeographyScopeWithoutSave(this.getDbID(), this.mainSource.study.study.key, this.mainSource.key)) {
            return false;
        }
        AppController.hideWindow(this);
        return true;
    }

    @Override
    public boolean applyEditsFrom(AppEditor appEditor) {
        if (appEditor instanceof PatternEditor) {
            PatternEditor patternEditor = (PatternEditor)appEditor;
            SourcePanel sourcePanel = this.patternEditorIndex.get(patternEditor);
            if (null != sourcePanel) {
                return sourcePanel.applyEditsFrom(patternEditor);
            }
            return false;
        }
        return false;
    }

    @Override
    public void editorClosing(AppEditor appEditor) {
        PatternEditor patternEditor;
        SourcePanel sourcePanel;
        if (appEditor instanceof PatternEditor && null != (sourcePanel = this.patternEditorIndex.get(patternEditor = (PatternEditor)appEditor))) {
            sourcePanel.editorClosing(patternEditor);
        }
    }

    @Override
    public void windowWillOpen() {
        this.setLocationRelativeTo(this.getOwner());
        this.blockActionsClear();
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        if (!this.patternEditorIndex.isEmpty()) {
            HashSet<PatternEditor> hashSet = new HashSet<PatternEditor>(this.patternEditorIndex.keySet());
            for (PatternEditor patternEditor : hashSet) {
                if (patternEditor.cancel()) continue;
                AppController.beep();
                patternEditor.toFront();
                return false;
            }
        }
        return null == this.mainSource || null == this.mainSource.study || StudyManager.closeGeographyScopeIfPossible(this.getDbID(), this.mainSource.study.study.key, this.mainSource.key);
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        this.blockActionsSet();
        this.parent.editorClosing(this);
    }

    private class DTSSourcePanel
    extends JPanel {
        private SourceEditDataTV source;
        private boolean canEditChan;
        private boolean canEditCoords;
        private JLabel stationDataLabel;
        private JTextField recordIDLabel;
        private JPanel recordIDPanel;
        private JLabel facilityIDLabel;
        private JTextField facilityIDField;
        private JLabel serviceLabel;
        private KeyedRecordMenu serviceMenu;
        private JTextField callSignField;
        private JTextField channelField;
        private JLabel replicationLabel;
        private JLabel frequencyLabel;
        private JTextField frequencyField;
        private JCheckBox editFrequencyCheckBox;
        private JTextField cityField;
        private JTextField stateField;
        private JLabel countryLabel;
        private KeyedRecordMenu countryMenu;
        private KeyedRecordMenu zoneMenu;
        private KeyedRecordMenu signalTypeMenu;
        private KeyedRecordMenu frequencyOffsetMenu;
        private KeyedRecordMenu emissionMaskMenu;
        private KeyedRecordMenu statusMenu;
        private KeyedRecord statusItem;
        private JTextField fileNumberField;
        private boolean hasReferencePoint;
        private GeoPoint editPoint;
        private CoordinatePanel latitudePanel;
        private CoordinatePanel longitudePanel;
        private CoordinateCopyPastePanel copyPastePanel;
        private JTextField distanceField;
        private static final String TABLE_DIST_LABEL = "(table)";
        private JButton editSectorsButton;
        private JPanel referencePointPanel;
        private JCheckBox baselineCheckBox;

        private DTSSourcePanel(SourceEditDataTV sourceEditDataTV) {
            this.source = sourceEditDataTV;
            SourceEditor.this.blockActionsStart();
            this.stationDataLabel = new JLabel(" ");
            this.stationDataLabel.setPreferredSize(AppController.labelSize[32]);
            this.recordIDLabel = new JTextField(24);
            AppController.fixKeyBindings(this.recordIDLabel);
            AppController.setComponentEnabled(this.recordIDLabel, false);
            Box box = Box.createVerticalBox();
            box.add(this.stationDataLabel);
            box.add(this.recordIDLabel);
            this.recordIDPanel = new JPanel();
            this.recordIDPanel.setBorder(BorderFactory.createTitledBorder("Record ID"));
            this.recordIDPanel.add(box);
            this.facilityIDLabel = new JLabel(" ");
            this.facilityIDLabel.setPreferredSize(AppController.labelSize[8]);
            this.facilityIDField = new JTextField(8);
            AppController.fixKeyBindings(this.facilityIDField);
            this.facilityIDField.setVisible(false);
            this.facilityIDField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.isNewSource) {
                            String string = "Edit Facility ID";
                            String string2 = DTSSourcePanel.this.facilityIDField.getText().trim();
                            if (string2.length() > 0) {
                                int n = SourceEditor.this.facilityID;
                                try {
                                    n = Integer.parseInt(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The facility ID must be a number");
                                }
                                if (n != SourceEditor.this.facilityID) {
                                    SourceEditor.this.facilityID = n;
                                    SourceEditor.this.updateSourcePanels();
                                }
                            }
                        }
                        DTSSourcePanel.this.facilityIDField.setText(String.valueOf(SourceEditor.this.facilityID));
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.facilityIDField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(DTSSourcePanel.this.facilityIDField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        DTSSourcePanel.this.facilityIDField.postActionEvent();
                    }
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Facility ID"));
            jPanel.add(this.facilityIDLabel);
            jPanel.add(this.facilityIDField);
            this.serviceLabel = new JLabel(" ");
            this.serviceLabel.setPreferredSize(AppController.labelSize[26]);
            this.serviceMenu = new KeyedRecordMenu(Service.getServices((int)1));
            this.serviceMenu.setVisible(false);
            this.serviceMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.isNewSource) {
                            final Service service = (Service)DTSSourcePanel.this.serviceMenu.getSelectedItem();
                            if (!service.isDTS) {
                                DTSSourcePanel.this.serviceMenu.setSelectedItem((KeyedRecord)SourceEditor.this.service);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        SourceEditor.this.applyServiceChange(service);
                                    }
                                });
                            } else {
                                SourceEditor.this.service = service;
                                DTSSourcePanel.this.hasReferencePoint = service.isFullService();
                                if (!DTSSourcePanel.this.hasReferencePoint) {
                                    ((DTSSourcePanel)DTSSourcePanel.this).source.dtsMaximumDistance = 0.0;
                                    ((DTSSourcePanel)DTSSourcePanel.this).source.dtsSectors = "";
                                }
                                DTSSourcePanel.this.updateFields();
                                SourceEditor.this.updateSourcePanels();
                            }
                        } else {
                            DTSSourcePanel.this.serviceMenu.setSelectedItem((KeyedRecord)SourceEditor.this.service);
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Service"));
            jPanel2.add(this.serviceLabel);
            jPanel2.add(this.serviceMenu);
            this.callSignField = new JTextField(10);
            AppController.fixKeyBindings(this.callSignField);
            this.callSignField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        String string;
                        if (SourceEditor.this.canEdit && (string = DTSSourcePanel.this.callSignField.getText().trim().toUpperCase()).length() > 0) {
                            if (string.length() > 12) {
                                SourceEditor.this.errorReporter.reportValidationError("Edit Call Sign", "The call sign cannot be longer than 12 characters");
                            } else {
                                ((DTSSourcePanel)DTSSourcePanel.this).source.callSign = string;
                                for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                    sourceEditDataTV.callSign = string;
                                }
                                SourceEditor.this.updateSourcePanels();
                                DTSSourcePanel.this.updateFrequency();
                            }
                        }
                        DTSSourcePanel.this.callSignField.setText(((DTSSourcePanel)DTSSourcePanel.this).source.callSign);
                        SourceEditor.this.updateDocumentName();
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.callSignField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(DTSSourcePanel.this.callSignField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        DTSSourcePanel.this.callSignField.postActionEvent();
                    }
                }
            });
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createTitledBorder("Call Sign"));
            jPanel3.add(this.callSignField);
            this.channelField = new JTextField(5);
            AppController.fixKeyBindings(this.channelField);
            this.channelField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (DTSSourcePanel.this.canEditChan) {
                            String string = "Edit Channel";
                            String string2 = DTSSourcePanel.this.channelField.getText().trim();
                            if (string2.length() > 0) {
                                int n = ((DTSSourcePanel)DTSSourcePanel.this).source.channel;
                                try {
                                    n = Integer.parseInt(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The channel must be a number");
                                }
                                if (n != ((DTSSourcePanel)DTSSourcePanel.this).source.channel) {
                                    if (n < SourceEditor.this.minimumChannel || n > SourceEditor.this.maximumChannel) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The channel must be in the range " + SourceEditor.this.minimumChannel + " to " + SourceEditor.this.maximumChannel);
                                    } else {
                                        ((DTSSourcePanel)DTSSourcePanel.this).source.channel = n;
                                        for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                            if (sourceEditDataTV.siteNumber <= 0) continue;
                                            sourceEditDataTV.channel = n;
                                        }
                                        SourceEditor.this.updateSourcePanels();
                                    }
                                }
                            }
                        }
                        DTSSourcePanel.this.channelField.setText(String.valueOf(((DTSSourcePanel)DTSSourcePanel.this).source.channel));
                        DTSSourcePanel.this.updateFrequency();
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.channelField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(DTSSourcePanel.this.channelField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        DTSSourcePanel.this.channelField.postActionEvent();
                    }
                }
            });
            this.replicationLabel = new JLabel(" ");
            String string = AppCore.getPreference((String)"allowFrequencyEdit");
            if (null != string && Boolean.valueOf(string).booleanValue()) {
                this.frequencyField = new JTextField(5);
                AppController.fixKeyBindings(this.frequencyField);
                this.frequencyField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (DTSSourcePanel.this.canEditChan) {
                                String string = "Edit Frequency";
                                double d = DTSSourcePanel.this.source.getFrequencyValue();
                                String string2 = DTSSourcePanel.this.frequencyField.getText().trim();
                                if (string2.length() > 0) {
                                    double d2 = 0.0;
                                    try {
                                        d2 = Double.parseDouble(string2);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The frequency must be a number");
                                    }
                                    if (d2 != d) {
                                        if (d2 < 40.0 || d2 > 10000.0) {
                                            SourceEditor.this.errorReporter.reportValidationError(string, "The frequency must be in the range " + AppCore.formatDecimal((double)40.0, (int)2) + " to " + AppCore.formatDecimal((double)10000.0, (int)2) + " MHz");
                                        } else {
                                            DTSSourcePanel.this.source.setAttribute("frequency", string2);
                                            for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                                if (sourceEditDataTV.siteNumber <= 0) continue;
                                                sourceEditDataTV.setAttribute("frequency", string2);
                                            }
                                            SourceEditor.this.updateSourcePanels();
                                        }
                                    }
                                }
                            }
                            DTSSourcePanel.this.updateFrequency();
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.frequencyField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        SourceEditor.this.setCurrentField(DTSSourcePanel.this.frequencyField);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            DTSSourcePanel.this.frequencyField.postActionEvent();
                        }
                    }
                });
                this.editFrequencyCheckBox = new JCheckBox("Change frequency");
                this.editFrequencyCheckBox.setFocusable(false);
                this.editFrequencyCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (DTSSourcePanel.this.canEditChan) {
                                if (DTSSourcePanel.this.editFrequencyCheckBox.isSelected()) {
                                    String string = DTSSourcePanel.this.frequencyField.getText().trim();
                                    DTSSourcePanel.this.source.setAttribute("frequency", string);
                                    for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                        if (sourceEditDataTV.siteNumber <= 0) continue;
                                        sourceEditDataTV.setAttribute("frequency", string);
                                    }
                                } else {
                                    DTSSourcePanel.this.source.removeAttribute("frequency");
                                    for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                        if (sourceEditDataTV.siteNumber <= 0) continue;
                                        sourceEditDataTV.removeAttribute("frequency");
                                    }
                                }
                                SourceEditor.this.updateSourcePanels();
                            } else {
                                DTSSourcePanel.this.editFrequencyCheckBox.setSelected(null != DTSSourcePanel.this.source.getAttribute("frequency"));
                            }
                            DTSSourcePanel.this.updateFrequency();
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
            } else {
                this.frequencyLabel = new JLabel(" ");
            }
            JPanel jPanel4 = new JPanel();
            jPanel4.add(this.channelField);
            if (null != this.frequencyLabel) {
                jPanel4.add(this.frequencyLabel);
            }
            if (null != this.frequencyField) {
                jPanel4.add(this.frequencyField);
                jPanel4.add(new JLabel("MHz"));
            }
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 1));
            jPanel5.setBorder(BorderFactory.createTitledBorder("Channel"));
            jPanel5.add(jPanel4);
            if (null != this.editFrequencyCheckBox) {
                jPanel5.add(this.editFrequencyCheckBox);
            }
            jPanel5.add(this.replicationLabel);
            this.cityField = new JTextField(18);
            AppController.fixKeyBindings(this.cityField);
            this.cityField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        String string;
                        if (SourceEditor.this.canEdit && (string = DTSSourcePanel.this.cityField.getText().trim()).length() > 0) {
                            if (string.length() > 20) {
                                SourceEditor.this.errorReporter.reportValidationError("Edit City", "The city name cannot be longer than 20 characters");
                            } else {
                                ((DTSSourcePanel)DTSSourcePanel.this).source.city = string;
                                for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                    sourceEditDataTV.city = string;
                                }
                                SourceEditor.this.updateSourcePanels();
                            }
                        }
                        DTSSourcePanel.this.cityField.setText(((DTSSourcePanel)DTSSourcePanel.this).source.city);
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.cityField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(DTSSourcePanel.this.cityField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        DTSSourcePanel.this.cityField.postActionEvent();
                    }
                }
            });
            JPanel jPanel6 = new JPanel();
            jPanel6.setBorder(BorderFactory.createTitledBorder("City"));
            jPanel6.add(this.cityField);
            this.stateField = new JTextField(3);
            AppController.fixKeyBindings(this.stateField);
            this.stateField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        String string;
                        if (SourceEditor.this.canEdit && (string = DTSSourcePanel.this.stateField.getText().trim().toUpperCase()).length() > 0) {
                            if (string.length() > 2) {
                                SourceEditor.this.errorReporter.reportValidationError("Edit State", "The state code cannot be longer than 2 characters");
                            } else {
                                ((DTSSourcePanel)DTSSourcePanel.this).source.state = string;
                                for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                    sourceEditDataTV.state = string;
                                }
                                SourceEditor.this.updateSourcePanels();
                            }
                        }
                        DTSSourcePanel.this.stateField.setText(((DTSSourcePanel)DTSSourcePanel.this).source.state);
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.stateField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(DTSSourcePanel.this.stateField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        DTSSourcePanel.this.stateField.postActionEvent();
                    }
                }
            });
            JPanel jPanel7 = new JPanel();
            jPanel7.setBorder(BorderFactory.createTitledBorder("State"));
            jPanel7.add(this.stateField);
            this.countryLabel = new JLabel(" ");
            this.countryLabel.setPreferredSize(AppController.labelSize[6]);
            this.countryMenu = new KeyedRecordMenu(Country.getCountries());
            this.countryMenu.setVisible(false);
            this.countryMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.isNewSource) {
                            SourceEditor.this.country = (Country)DTSSourcePanel.this.countryMenu.getSelectedItem();
                            SourceEditor.this.updateSourcePanels();
                        } else {
                            DTSSourcePanel.this.countryMenu.setSelectedItem((KeyedRecord)SourceEditor.this.country);
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            JPanel jPanel8 = new JPanel();
            jPanel8.setBorder(BorderFactory.createTitledBorder("Country"));
            jPanel8.add(this.countryLabel);
            jPanel8.add(this.countryMenu);
            this.zoneMenu = new KeyedRecordMenu(Zone.getZonesWithNull());
            this.zoneMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit) {
                            ((DTSSourcePanel)DTSSourcePanel.this).source.zone = (Zone)DTSSourcePanel.this.zoneMenu.getSelectedItem();
                            for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                if (sourceEditDataTV.siteNumber <= 0) continue;
                                sourceEditDataTV.zone = ((DTSSourcePanel)DTSSourcePanel.this).source.zone;
                            }
                            SourceEditor.this.updateSourcePanels();
                        } else {
                            DTSSourcePanel.this.zoneMenu.setSelectedItem((KeyedRecord)((DTSSourcePanel)DTSSourcePanel.this).source.zone);
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            JPanel jPanel9 = new JPanel();
            jPanel9.setBorder(BorderFactory.createTitledBorder("Zone"));
            jPanel9.add(this.zoneMenu);
            JPanel jPanel10 = null;
            if (SignalType.hasMultipleOptions()) {
                this.signalTypeMenu = new KeyedRecordMenu(SignalType.getSignalTypes());
                this.signalTypeMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourceEditor.this.canEdit) {
                                ((DTSSourcePanel)DTSSourcePanel.this).source.signalType = (SignalType)DTSSourcePanel.this.signalTypeMenu.getSelectedItem();
                                for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                    if (sourceEditDataTV.siteNumber <= 0) continue;
                                    sourceEditDataTV.signalType = ((DTSSourcePanel)DTSSourcePanel.this).source.signalType;
                                }
                                SourceEditor.this.updateSourcePanels();
                            } else {
                                DTSSourcePanel.this.signalTypeMenu.setSelectedItem((KeyedRecord)((DTSSourcePanel)DTSSourcePanel.this).source.signalType);
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                jPanel10 = new JPanel();
                jPanel10.setBorder(BorderFactory.createTitledBorder("Mod. Type"));
                jPanel10.add(this.signalTypeMenu);
            }
            JPanel jPanel11 = null;
            this.frequencyOffsetMenu = new KeyedRecordMenu(FrequencyOffset.getFrequencyOffsetsWithNull());
            this.frequencyOffsetMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit) {
                            ((DTSSourcePanel)DTSSourcePanel.this).source.frequencyOffset = (FrequencyOffset)DTSSourcePanel.this.frequencyOffsetMenu.getSelectedItem();
                            for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                if (sourceEditDataTV.siteNumber <= 0) continue;
                                sourceEditDataTV.frequencyOffset = ((DTSSourcePanel)DTSSourcePanel.this).source.frequencyOffset;
                            }
                            SourceEditor.this.updateSourcePanels();
                        } else {
                            DTSSourcePanel.this.frequencyOffsetMenu.setSelectedItem((KeyedRecord)((DTSSourcePanel)DTSSourcePanel.this).source.frequencyOffset);
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            jPanel11 = new JPanel();
            jPanel11.setBorder(BorderFactory.createTitledBorder("Freq. Offset"));
            jPanel11.add(this.frequencyOffsetMenu);
            JPanel jPanel12 = null;
            this.emissionMaskMenu = new KeyedRecordMenu(EmissionMask.getEmissionMasksWithNull());
            this.emissionMaskMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit && ((SourceEditor)SourceEditor.this).service.serviceType.needsEmissionMask) {
                            ((DTSSourcePanel)DTSSourcePanel.this).source.emissionMask = (EmissionMask)DTSSourcePanel.this.emissionMaskMenu.getSelectedItem();
                            for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                if (sourceEditDataTV.siteNumber <= 0) continue;
                                sourceEditDataTV.emissionMask = ((DTSSourcePanel)DTSSourcePanel.this).source.emissionMask;
                            }
                            SourceEditor.this.updateSourcePanels();
                        } else {
                            DTSSourcePanel.this.emissionMaskMenu.setSelectedItem((KeyedRecord)((DTSSourcePanel)DTSSourcePanel.this).source.emissionMask);
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            jPanel12 = new JPanel();
            jPanel12.setBorder(BorderFactory.createTitledBorder("Emission Mask"));
            jPanel12.add(this.emissionMaskMenu);
            this.statusMenu = new KeyedRecordMenu(ExtDbRecord.getStatusList());
            this.statusMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit) {
                            DTSSourcePanel.this.statusItem = DTSSourcePanel.this.statusMenu.getSelectedItem();
                            ((DTSSourcePanel)DTSSourcePanel.this).source.status = ((DTSSourcePanel)DTSSourcePanel.this).statusItem.name;
                            ((DTSSourcePanel)DTSSourcePanel.this).source.statusType = ((DTSSourcePanel)DTSSourcePanel.this).statusItem.key;
                            for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                if (sourceEditDataTV.siteNumber <= 0) continue;
                                sourceEditDataTV.status = ((DTSSourcePanel)DTSSourcePanel.this).source.status;
                                sourceEditDataTV.statusType = ((DTSSourcePanel)DTSSourcePanel.this).source.statusType;
                            }
                            SourceEditor.this.updateSourcePanels();
                        } else {
                            DTSSourcePanel.this.statusMenu.setSelectedItem(DTSSourcePanel.this.statusItem);
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            JPanel jPanel13 = new JPanel();
            jPanel13.setBorder(BorderFactory.createTitledBorder("Status"));
            jPanel13.add(this.statusMenu);
            this.fileNumberField = new JTextField(15);
            AppController.fixKeyBindings(this.fileNumberField);
            this.fileNumberField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit) {
                            String string = DTSSourcePanel.this.fileNumberField.getText().trim();
                            if (string.length() > 255) {
                                SourceEditor.this.errorReporter.reportValidationError("Edit File Number", "The file number cannot be longer than 255 characters");
                            } else {
                                ((DTSSourcePanel)DTSSourcePanel.this).source.fileNumber = string;
                                ((DTSSourcePanel)DTSSourcePanel.this).source.appARN = ExtDbRecord.parseFileNumber((String)string)[1];
                                for (SourceEditDataTV sourceEditDataTV : DTSSourcePanel.this.source.getDTSSources()) {
                                    if (sourceEditDataTV.siteNumber <= 0) continue;
                                    sourceEditDataTV.fileNumber = string;
                                    sourceEditDataTV.appARN = ((DTSSourcePanel)DTSSourcePanel.this).source.appARN;
                                }
                                SourceEditor.this.updateSourcePanels();
                            }
                        }
                        DTSSourcePanel.this.fileNumberField.setText(((DTSSourcePanel)DTSSourcePanel.this).source.fileNumber);
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.fileNumberField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(DTSSourcePanel.this.fileNumberField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        DTSSourcePanel.this.fileNumberField.postActionEvent();
                    }
                }
            });
            JPanel jPanel14 = new JPanel();
            jPanel14.setBorder(BorderFactory.createTitledBorder("File Number"));
            jPanel14.add(this.fileNumberField);
            this.hasReferencePoint = this.source.service.isFullService();
            this.editPoint = new GeoPoint();
            this.latitudePanel = new CoordinatePanel(SourceEditor.this.outerThis, this.editPoint, false, new Runnable(){

                @Override
                public void run() {
                    if (DTSSourcePanel.this.hasReferencePoint && DTSSourcePanel.this.canEditCoords) {
                        ((DTSSourcePanel)DTSSourcePanel.this).source.location.latitude = ((DTSSourcePanel)DTSSourcePanel.this).editPoint.latitude;
                        ((DTSSourcePanel)DTSSourcePanel.this).source.location.updateDMS();
                    }
                }
            });
            this.longitudePanel = new CoordinatePanel(SourceEditor.this.outerThis, this.editPoint, true, new Runnable(){

                @Override
                public void run() {
                    if (DTSSourcePanel.this.hasReferencePoint && DTSSourcePanel.this.canEditCoords) {
                        ((DTSSourcePanel)DTSSourcePanel.this).source.location.longitude = ((DTSSourcePanel)DTSSourcePanel.this).editPoint.longitude;
                        ((DTSSourcePanel)DTSSourcePanel.this).source.location.updateDMS();
                    }
                }
            });
            this.copyPastePanel = new CoordinateCopyPastePanel(this.latitudePanel, this.longitudePanel);
            this.distanceField = new JTextField(7);
            AppController.fixKeyBindings(this.distanceField);
            this.distanceField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DTSSourcePanel.this.hasReferencePoint && SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit && 0 == ((DTSSourcePanel)DTSSourcePanel.this).source.dtsSectors.length()) {
                            String string = "Edit Distance";
                            String string2 = DTSSourcePanel.this.distanceField.getText().trim();
                            if (string2.length() > 0) {
                                if (string2.equals(DTSSourcePanel.TABLE_DIST_LABEL)) {
                                    string2 = "0";
                                }
                                double d = ((DTSSourcePanel)DTSSourcePanel.this).source.dtsMaximumDistance;
                                try {
                                    d = Double.parseDouble(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The distance must be a number");
                                }
                                if (d != ((DTSSourcePanel)DTSSourcePanel.this).source.dtsMaximumDistance) {
                                    if (d != 0.0 && (d < 50.0 || d > 200.0)) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The distance must be in the range 50.0 to 200.0");
                                    } else {
                                        ((DTSSourcePanel)DTSSourcePanel.this).source.dtsMaximumDistance = d;
                                    }
                                }
                            }
                        }
                        if (0.0 == ((DTSSourcePanel)DTSSourcePanel.this).source.dtsMaximumDistance) {
                            DTSSourcePanel.this.distanceField.setText(DTSSourcePanel.TABLE_DIST_LABEL);
                        } else {
                            DTSSourcePanel.this.distanceField.setText(AppCore.formatDistance((double)((DTSSourcePanel)DTSSourcePanel.this).source.dtsMaximumDistance));
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.distanceField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(DTSSourcePanel.this.distanceField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        DTSSourcePanel.this.distanceField.postActionEvent();
                    }
                }
            });
            JPanel jPanel15 = new JPanel();
            jPanel15.setBorder(BorderFactory.createTitledBorder("Distance, km"));
            jPanel15.add(this.distanceField);
            this.editSectorsButton = new JButton("Edit Sectors");
            this.editSectorsButton.setFocusable(false);
            this.editSectorsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DTSSourcePanel.this.doEditSectors();
                }
            });
            JPanel jPanel16 = new JPanel();
            jPanel16.add(this.editSectorsButton);
            this.baselineCheckBox = new JCheckBox("Baseline record");
            this.baselineCheckBox.setFocusable(false);
            this.baselineCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit) {
                            if (DTSSourcePanel.this.baselineCheckBox.isSelected()) {
                                DTSSourcePanel.this.source.setAttribute("isBaseline");
                            } else {
                                DTSSourcePanel.this.source.removeAttribute("isBaseline");
                            }
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            JPanel jPanel17 = new JPanel();
            jPanel17.add(this.baselineCheckBox);
            JPanel jPanel18 = new JPanel();
            jPanel18.add(jPanel2);
            jPanel18.add(jPanel);
            jPanel18.add(this.recordIDPanel);
            jPanel18.add(jPanel8);
            JPanel jPanel19 = new JPanel();
            jPanel19.add(jPanel3);
            jPanel19.add(jPanel5);
            jPanel19.add(jPanel13);
            jPanel19.add(jPanel6);
            jPanel19.add(jPanel7);
            JPanel jPanel20 = new JPanel();
            jPanel20.add(jPanel14);
            jPanel20.add(jPanel9);
            if (null != jPanel10) {
                jPanel20.add(jPanel10);
            }
            jPanel20.add(jPanel11);
            jPanel20.add(jPanel12);
            jPanel20.add(jPanel17);
            JPanel jPanel21 = new JPanel();
            jPanel21.setLayout(new BoxLayout(jPanel21, 1));
            jPanel21.add(this.latitudePanel);
            jPanel21.add(this.longitudePanel);
            JPanel jPanel22 = new JPanel();
            jPanel22.setBorder(BorderFactory.createTitledBorder("Reference point and boundary"));
            jPanel22.add(jPanel21);
            jPanel22.add(this.copyPastePanel);
            jPanel22.add(jPanel15);
            jPanel22.add(jPanel16);
            this.referencePointPanel = new JPanel();
            this.referencePointPanel.add(jPanel22);
            Box box2 = Box.createVerticalBox();
            box2.add(jPanel18);
            box2.add(jPanel19);
            box2.add(jPanel20);
            box2.add(this.referencePointPanel);
            this.add(box2);
            this.updateFields();
            SourceEditor.this.blockActionsEnd();
        }

        private void doEditSectors() {
            if (!this.hasReferencePoint) {
                return;
            }
            String string = SourceEditor.this.canEdit ? "Edit Sectors" : "View Sectors";
            SourceEditor.this.errorReporter.setTitle(string);
            class SectorsDialog
            extends AppDialog {
                private GeoSectors sectors;
                private GeoEditPanel.SectorsPanel editorPanel;
                private GeoPlotPanel plotPanel;
                private boolean canceled;

                SectorsDialog() {
                    JComponent jComponent;
                    JButton jButton;
                    super(SourceEditor.this.outerThis, "DTS Boundary Sectors", Dialog.ModalityType.APPLICATION_MODAL);
                    this.sectors = new GeoSectors(this.getDbID());
                    if (((DTSSourcePanel)DTSSourcePanel.this).source.dtsSectors.length() > 0) {
                        this.sectors.decodeFromString(((DTSSourcePanel)DTSSourcePanel.this).source.dtsSectors);
                    }
                    this.editorPanel = new GeoEditPanel.SectorsPanel(this, (Geography)this.sectors, SourceEditor.this.canEdit, false);
                    this.plotPanel = new GeoPlotPanel();
                    this.plotPanel.setGeography((Geography)this.sectors);
                    JPanel jPanel = new JPanel(new FlowLayout(2));
                    if (SourceEditor.this.canEdit) {
                        jButton = new JButton("Clear");
                        jButton.setFocusable(false);
                        jButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                this.doClear();
                            }
                        });
                        jPanel.add(jButton);
                        jComponent = new JButton("Cancel");
                        jComponent.setFocusable(false);
                        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                this.doCancel();
                            }
                        });
                        jPanel.add(jComponent);
                    }
                    jButton = new JButton("OK");
                    jButton.setFocusable(false);
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            this.doOK();
                        }
                    });
                    jPanel.add(jButton);
                    jComponent = new JTabbedPane();
                    ((JTabbedPane)jComponent).addTab("Data", this.editorPanel);
                    ((JTabbedPane)jComponent).addTab("Plot", this.plotPanel);
                    Container container = this.getContentPane();
                    container.setLayout(new BorderLayout());
                    container.add((Component)jComponent, "Center");
                    container.add((Component)jPanel, "South");
                    this.pack();
                    Dimension dimension = new Dimension(700, 400);
                    this.setMinimumSize(dimension);
                    this.setSize(dimension);
                    this.setResizable(true);
                    this.setLocationRelativeTo(SourceEditor.this.outerThis);
                }

                private void doClear() {
                    ((DTSSourcePanel)DTSSourcePanel.this).source.dtsSectors = "";
                    AppController.hideWindow(this);
                }

                private void doCancel() {
                    this.canceled = true;
                    AppController.hideWindow(this);
                }

                private void doOK() {
                    if (!this.sectors.areSectorsValid((ErrorLogger)this.errorReporter)) {
                        return;
                    }
                    ((DTSSourcePanel)DTSSourcePanel.this).source.dtsSectors = this.sectors.encodeAsString();
                    AppController.hideWindow(this);
                }

                @Override
                public void setDidEdit() {
                    this.plotPanel.setGeography((Geography)this.sectors);
                }

                @Override
                public void windowWillOpen() {
                    this.blockActionsClear();
                }

                @Override
                public boolean windowShouldClose() {
                    this.canceled = true;
                    return true;
                }

                @Override
                public void windowWillClose() {
                    this.blockActionsSet();
                }
            }
            SectorsDialog sectorsDialog = new SectorsDialog();
            AppController.showWindow(sectorsDialog);
            if (!SourceEditor.this.canEdit || sectorsDialog.canceled) {
                return;
            }
            if (this.source.dtsSectors.length() > 0) {
                this.editSectorsButton.setText("Edit Sectors");
                AppController.setComponentEnabled(this.distanceField, false);
            } else {
                this.editSectorsButton.setText("Add Sectors");
                AppController.setComponentEnabled(this.distanceField, true);
            }
        }

        private void updateFields() {
            SourceEditDataTV sourceEditDataTV;
            SourceEditor.this.blockActionsStart();
            this.canEditChan = SourceEditor.this.canEdit;
            this.canEditCoords = SourceEditor.this.canEdit;
            if (SourceEditor.this.isPermanentInScenario && null != this.source.study && (3 == this.source.study.study.studyType || 5 == this.source.study.study.studyType)) {
                this.canEditChan = false;
                this.canEditCoords = false;
            }
            if (SourceEditor.this.isNewSource) {
                this.facilityIDField.setVisible(true);
                this.facilityIDField.setText(String.valueOf(SourceEditor.this.facilityID));
                this.facilityIDLabel.setVisible(false);
                this.facilityIDLabel.setText(" ");
            } else {
                this.facilityIDLabel.setVisible(true);
                this.facilityIDLabel.setText(String.valueOf(SourceEditor.this.facilityID));
                this.facilityIDField.setVisible(false);
                this.facilityIDField.setText("");
            }
            if (this.source.hasRecordID()) {
                this.stationDataLabel.setText(this.source.getStationData());
                this.recordIDLabel.setText(this.source.getRecordID());
                this.recordIDPanel.setVisible(true);
            } else {
                this.stationDataLabel.setText(" ");
                this.recordIDLabel.setText(" ");
                this.recordIDPanel.setVisible(false);
            }
            if (SourceEditor.this.isNewSource) {
                this.serviceMenu.setVisible(true);
                this.serviceMenu.setSelectedItem((KeyedRecord)SourceEditor.this.service);
                this.serviceLabel.setVisible(false);
                this.serviceLabel.setText(" ");
            } else {
                this.serviceLabel.setVisible(true);
                this.serviceLabel.setText(((SourceEditor)SourceEditor.this).service.name);
                this.serviceMenu.setSelectedIndex(0);
                this.serviceMenu.setVisible(false);
            }
            this.callSignField.setText(this.source.callSign);
            AppController.setComponentEnabled(this.callSignField, SourceEditor.this.canEdit);
            this.channelField.setText(String.valueOf(this.source.channel));
            AppController.setComponentEnabled(this.channelField, this.canEditChan);
            String string = " ";
            if (null != SourceEditor.this.channelNote) {
                string = SourceEditor.this.channelNote;
            } else if (null != this.source.originalSourceKey && null != this.source.study && null != (sourceEditDataTV = (SourceEditDataTV)this.source.study.getSource(this.source.originalSourceKey))) {
                string = "replicated from " + (sourceEditDataTV.service.serviceType.digital ? "D" : "N") + sourceEditDataTV.channel;
            }
            this.replicationLabel.setText(string);
            this.updateFrequency();
            this.cityField.setText(this.source.city);
            AppController.setComponentEnabled(this.cityField, SourceEditor.this.canEdit);
            this.stateField.setText(this.source.state);
            AppController.setComponentEnabled(this.stateField, SourceEditor.this.canEdit);
            if (SourceEditor.this.isNewSource) {
                this.countryMenu.setVisible(true);
                this.countryMenu.setSelectedItem((KeyedRecord)SourceEditor.this.country);
                this.countryLabel.setVisible(false);
                this.countryLabel.setText(" ");
            } else {
                this.countryLabel.setVisible(true);
                this.countryLabel.setText(((SourceEditor)SourceEditor.this).country.name);
                this.countryMenu.setSelectedIndex(0);
                this.countryMenu.setVisible(false);
            }
            this.zoneMenu.setSelectedItem((KeyedRecord)this.source.zone);
            AppController.setComponentEnabled(this.zoneMenu, SourceEditor.this.canEdit);
            if (null != this.signalTypeMenu) {
                this.signalTypeMenu.setSelectedItem((KeyedRecord)this.source.signalType);
                AppController.setComponentEnabled(this.signalTypeMenu, SourceEditor.this.canEdit);
            }
            if (null != this.frequencyOffsetMenu) {
                this.frequencyOffsetMenu.setSelectedItem((KeyedRecord)this.source.frequencyOffset);
                AppController.setComponentEnabled(this.frequencyOffsetMenu, SourceEditor.this.canEdit);
            }
            if (null != this.emissionMaskMenu) {
                this.emissionMaskMenu.setSelectedItem((KeyedRecord)this.source.emissionMask);
                AppController.setComponentEnabled(this.emissionMaskMenu, SourceEditor.this.canEdit && ((SourceEditor)SourceEditor.this).service.serviceType.needsEmissionMask);
            }
            this.statusItem = new KeyedRecord(ExtDbRecord.getStatusType((String)this.source.status), this.source.status);
            this.statusMenu.setSelectedItem(this.statusItem);
            AppController.setComponentEnabled(this.statusMenu, SourceEditor.this.canEdit);
            this.fileNumberField.setText(this.source.fileNumber);
            AppController.setComponentEnabled(this.fileNumberField, SourceEditor.this.canEdit);
            if (this.hasReferencePoint) {
                this.editPoint.setLatLon(this.source.location);
                this.latitudePanel.updatePanel();
                this.longitudePanel.updatePanel();
                this.latitudePanel.setEnabled(this.canEditCoords);
                this.longitudePanel.setEnabled(this.canEditCoords);
                this.copyPastePanel.setEnabled(this.canEditCoords);
                if (0.0 == this.source.dtsMaximumDistance) {
                    this.distanceField.setText(TABLE_DIST_LABEL);
                } else {
                    this.distanceField.setText(AppCore.formatDistance((double)this.source.dtsMaximumDistance));
                }
                if (SourceEditor.this.canEdit) {
                    if (this.source.dtsSectors.length() > 0) {
                        AppController.setComponentEnabled(this.distanceField, false);
                        this.editSectorsButton.setText("Edit Sectors");
                    } else {
                        AppController.setComponentEnabled(this.distanceField, true);
                        this.editSectorsButton.setText("Add Sectors");
                    }
                    this.editSectorsButton.setEnabled(true);
                } else {
                    AppController.setComponentEnabled(this.distanceField, false);
                    if (this.source.dtsSectors.length() > 0) {
                        this.editSectorsButton.setText("View Sectors");
                        this.editSectorsButton.setEnabled(true);
                    } else {
                        this.editSectorsButton.setText("Add Sectors");
                        this.editSectorsButton.setEnabled(false);
                    }
                }
                this.referencePointPanel.setVisible(true);
            } else {
                this.referencePointPanel.setVisible(false);
            }
            this.baselineCheckBox.setSelected(null != this.source.getAttribute("isBaseline"));
            AppController.setComponentEnabled(this.baselineCheckBox, SourceEditor.this.canEdit);
            SourceEditor.this.blockActionsEnd();
        }

        private void updateFrequency() {
            String string = this.source.getAttribute("frequency");
            if (null != this.frequencyLabel) {
                this.frequencyLabel.setText(SourceEditDataTV.getFrequency((int)this.source.channel, (Service)SourceEditor.this.service, (String)string));
            }
            if (null != this.frequencyField) {
                this.frequencyField.setText(AppCore.formatDecimal((double)SourceEditDataTV.getFrequencyValue((int)this.source.channel, (Service)SourceEditor.this.service, (String)string), (int)2));
                AppController.setComponentEnabled(this.frequencyField, this.canEditChan && null != string);
            }
            if (null != this.editFrequencyCheckBox) {
                this.editFrequencyCheckBox.setSelected(string != null);
                AppController.setComponentEnabled(this.editFrequencyCheckBox, this.canEditChan);
            }
        }
    }

    private class SourcePanel
    extends JPanel {
        private SourceEditData source;
        private SourceEditDataTV sourceTV;
        private SourceEditDataWL sourceWL;
        private SourceEditDataFM sourceFM;
        private boolean canEditFacServCntry;
        private boolean canEditCallCityState;
        private boolean canEditChan;
        private boolean canEditZoneStatFileOfsMask;
        private boolean canEditCoords;
        private boolean canEditSite;
        private boolean canEditServiceArea;
        private boolean isDTSAuthorized;
        private JLabel stationDataLabel;
        private JTextField recordIDLabel;
        private JPanel recordIDPanel;
        private JLabel facilityIDLabel;
        private JTextField facilityIDField;
        private JLabel stationClassLabel;
        private KeyedRecordMenu stationClassMenu;
        private JLabel serviceLabel;
        private KeyedRecordMenu serviceMenu;
        private JTextField callSignField;
        private JTextField sectorIDField;
        private JTextField channelField;
        private JLabel replicationLabel;
        private JLabel frequencyLabel;
        private JTextField frequencyField;
        private JCheckBox editFrequencyCheckBox;
        private JTextField cityField;
        private JTextField stateField;
        private JLabel countryLabel;
        private KeyedRecordMenu countryMenu;
        private KeyedRecordMenu zoneMenu;
        private KeyedRecordMenu statusMenu;
        private KeyedRecord statusItem;
        private JTextField fileNumberField;
        private KeyedRecordMenu signalTypeMenu;
        private KeyedRecordMenu frequencyOffsetMenu;
        private KeyedRecordMenu emissionMaskMenu;
        private GeoPoint editPoint;
        private CoordinatePanel latitudePanel;
        private CoordinatePanel longitudePanel;
        private CoordinateCopyPastePanel copyPastePanel;
        private JTextField heightAMSLField;
        private JLabel actualHeightAMSLLabel;
        private JTextField overallHAATField;
        private JLabel actualOverallHAATLabel;
        private JTextField peakERPField;
        private JCheckBox ibocCheckBox;
        private JTextField ibocERPField;
        private JLabel horizontalPatternLabel;
        private JButton editHorizontalPatternButton;
        private KeyedRecordMenu changeHorizontalPatternMenu;
        private JButton exportHorizontalPatternButton;
        private JTextField horizontalPatternOrientationField;
        private JLabel verticalPatternLabel;
        private JButton editVerticalPatternButton;
        private KeyedRecordMenu changeVerticalPatternMenu;
        private JButton exportVerticalPatternButton;
        private JTextField verticalPatternElectricalTiltField;
        private JTextField verticalPatternMechanicalTiltField;
        private JTextField verticalPatternMechanicalTiltOrientationField;
        private JCheckBox useGenericVerticalPatternCheckBox;
        private JTextField siteNumberField;
        private KeyedRecordMenu serviceAreaModeMenu;
        private JTextField serviceAreaArgumentField;
        private JTextField serviceAreaContourLevelField;
        private KeyedRecordMenu serviceAreaGeographyMenu;
        private JButton editAreaGeoButton;
        private boolean geographyEditPending;
        private JTextField timeDelayField;
        private JCheckBox baselineCheckBox;
        private PatternEditor horizontalPatternEditor;
        private PatternEditor verticalPatternEditor;
        private PatternEditor patternSearchDialog;
        private final int PATTERN_CHANGE_IMPORT = 1;
        private final int PATTERN_CHANGE_SEARCH = 2;
        private final int PATTERN_CHANGE_NEW = 3;
        private final int PATTERN_CHANGE_REMOVE = 4;

        private SourcePanel(SourceEditData sourceEditData) {
            JComponent jComponent;
            JPanel jPanel;
            JPanel jPanel2;
            JPanel jPanel3;
            JPanel jPanel4;
            JPanel jPanel5;
            JPanel jPanel6;
            JPanel jPanel7;
            JPanel jPanel8;
            Object object;
            Serializable serializable;
            this.source = sourceEditData;
            switch (sourceEditData.recordType) {
                case 1: {
                    this.sourceTV = (SourceEditDataTV)sourceEditData;
                    break;
                }
                case 2: {
                    this.sourceWL = (SourceEditDataWL)sourceEditData;
                    break;
                }
                case 3: {
                    this.sourceFM = (SourceEditDataFM)sourceEditData;
                }
            }
            SourceEditor.this.blockActionsStart();
            this.stationDataLabel = new JLabel(" ");
            this.stationDataLabel.setPreferredSize(AppController.labelSize[32]);
            this.recordIDLabel = new JTextField(24);
            AppController.fixKeyBindings(this.recordIDLabel);
            AppController.setComponentEnabled(this.recordIDLabel, false);
            Box box = Box.createVerticalBox();
            box.add(this.stationDataLabel);
            box.add(this.recordIDLabel);
            this.recordIDPanel = new JPanel();
            this.recordIDPanel.setBorder(BorderFactory.createTitledBorder("Record ID"));
            this.recordIDPanel.add(box);
            JPanel jPanel9 = null;
            if (SourceEditor.this.isTV || SourceEditor.this.isFM) {
                this.facilityIDLabel = new JLabel(" ");
                this.facilityIDLabel.setPreferredSize(AppController.labelSize[8]);
                this.facilityIDField = new JTextField(8);
                AppController.fixKeyBindings(this.facilityIDField);
                this.facilityIDField.setVisible(false);
                this.facilityIDField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourcePanel.this.canEditFacServCntry) {
                                String string = "Edit Facility ID";
                                String string2 = SourcePanel.this.facilityIDField.getText().trim();
                                if (string2.length() > 0) {
                                    try {
                                        SourceEditor.this.facilityID = Integer.parseInt(string2);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The facility ID must be a number");
                                    }
                                }
                            }
                            SourcePanel.this.facilityIDField.setText(String.valueOf(SourceEditor.this.facilityID));
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.facilityIDField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        SourceEditor.this.setCurrentField(SourcePanel.this.facilityIDField);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            SourcePanel.this.facilityIDField.postActionEvent();
                        }
                    }
                });
                jPanel9 = new JPanel();
                jPanel9.setBorder(BorderFactory.createTitledBorder("Facility ID"));
                jPanel9.add(this.facilityIDLabel);
                jPanel9.add(this.facilityIDField);
            }
            JPanel jPanel10 = null;
            if (SourceEditor.this.isFM) {
                this.stationClassLabel = new JLabel(" ");
                this.stationClassLabel.setPreferredSize(AppController.labelSize[4]);
                serializable = new ArrayList<KeyedRecord>();
                for (int i = 0; i < ExtDbRecordFM.FM_CLASS_CODES.length; ++i) {
                    ((ArrayList)serializable).add((KeyedRecord)new KeyedRecord(i, ExtDbRecordFM.FM_CLASS_CODES[i]));
                }
                this.stationClassMenu = new KeyedRecordMenu((ArrayList<KeyedRecord>)serializable);
                this.stationClassMenu.setVisible(false);
                this.stationClassMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourcePanel.this.canEditFacServCntry) {
                                SourceEditor.this.stationClass = SourcePanel.this.stationClassMenu.getSelectedKey();
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                jPanel10 = new JPanel();
                jPanel10.setBorder(BorderFactory.createTitledBorder("Class"));
                jPanel10.add(this.stationClassLabel);
                jPanel10.add(this.stationClassMenu);
            }
            this.serviceLabel = new JLabel(" ");
            this.serviceLabel.setPreferredSize(AppController.labelSize[26]);
            this.serviceMenu = new KeyedRecordMenu(Service.getServices((int)this.source.recordType));
            this.serviceMenu.setVisible(false);
            this.serviceMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourcePanel.this.canEditFacServCntry) {
                            final Service service = (Service)SourcePanel.this.serviceMenu.getSelectedItem();
                            if (SourceEditor.this.isTV) {
                                if (service.isDTS) {
                                    SourcePanel.this.serviceMenu.setSelectedItem((KeyedRecord)SourceEditor.this.service);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            SourceEditor.this.applyServiceChange(service);
                                        }
                                    });
                                } else {
                                    if (service.serviceType.digital) {
                                        if (0 == ((SourcePanel)SourcePanel.this).sourceTV.signalType.key) {
                                            ((SourcePanel)SourcePanel.this).sourceTV.signalType = SignalType.getDefaultObject();
                                        }
                                    } else if (((SourcePanel)SourcePanel.this).sourceTV.signalType.key > 0) {
                                        ((SourcePanel)SourcePanel.this).sourceTV.signalType = SignalType.getNullObject();
                                    }
                                    if (null != SourcePanel.this.signalTypeMenu) {
                                        AppController.setComponentEnabled(SourcePanel.this.signalTypeMenu, service.serviceType.digital);
                                        SourcePanel.this.signalTypeMenu.setSelectedItem((KeyedRecord)((SourcePanel)SourcePanel.this).sourceTV.signalType);
                                    }
                                    if (null != SourcePanel.this.emissionMaskMenu) {
                                        if (service.serviceType.needsEmissionMask) {
                                            AppController.setComponentEnabled(SourcePanel.this.emissionMaskMenu, true);
                                            if (!((SourceEditor)SourceEditor.this).service.serviceType.needsEmissionMask) {
                                                SourcePanel.this.emissionMaskMenu.setSelectedItem((KeyedRecord)EmissionMask.getInvalidObject());
                                            }
                                        } else {
                                            AppController.setComponentEnabled(SourcePanel.this.emissionMaskMenu, false);
                                            SourcePanel.this.emissionMaskMenu.setSelectedItem((KeyedRecord)EmissionMask.getNullObject());
                                        }
                                    }
                                    SourceEditor.this.service = service;
                                    SourcePanel.this.updateFrequency();
                                }
                            } else {
                                SourceEditor.this.service = service;
                            }
                        } else {
                            SourcePanel.this.serviceMenu.setSelectedItem((KeyedRecord)SourceEditor.this.service);
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            serializable = new JPanel();
            ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder("Service"));
            ((Container)serializable).add(this.serviceLabel);
            ((Container)serializable).add(this.serviceMenu);
            this.callSignField = new JTextField(10);
            AppController.fixKeyBindings(this.callSignField);
            this.callSignField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        String string;
                        if (SourcePanel.this.canEditCallCityState && (string = SourcePanel.this.callSignField.getText().trim()).length() > 0) {
                            if (string.length() > 12) {
                                if (SourceEditor.this.isWL) {
                                    SourceEditor.this.errorReporter.reportValidationError("Edit Cell Site ID", "The cell site ID cannot be longer than 12 characters");
                                } else {
                                    SourceEditor.this.errorReporter.reportValidationError("Edit Call Sign", "The call sign cannot be longer than 12 characters");
                                }
                            } else {
                                if (!SourceEditor.this.isWL) {
                                    string = string.toUpperCase();
                                }
                                ((SourcePanel)SourcePanel.this).source.callSign = string;
                            }
                        }
                        SourcePanel.this.callSignField.setText(((SourcePanel)SourcePanel.this).source.callSign);
                        SourceEditor.this.updateDocumentName();
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.callSignField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(SourcePanel.this.callSignField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        SourcePanel.this.callSignField.postActionEvent();
                    }
                }
            });
            JPanel jPanel11 = new JPanel();
            String string = "Call Sign";
            if (SourceEditor.this.isWL) {
                string = "Cell Site ID";
            }
            jPanel11.setBorder(BorderFactory.createTitledBorder(string));
            jPanel11.add(this.callSignField);
            JPanel jPanel12 = null;
            if (SourceEditor.this.isWL) {
                this.sectorIDField = new JTextField(7);
                AppController.fixKeyBindings(this.sectorIDField);
                this.sectorIDField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            String string;
                            if (SourcePanel.this.canEditCallCityState && (string = SourcePanel.this.sectorIDField.getText().trim()).length() > 0) {
                                if (string.length() > 3) {
                                    SourceEditor.this.errorReporter.reportValidationError("Edit Sector ID", "The sector ID cannot be longer than 3 characters");
                                } else {
                                    ((SourcePanel)SourcePanel.this).sourceWL.sectorID = string;
                                }
                            }
                            SourcePanel.this.sectorIDField.setText(((SourcePanel)SourcePanel.this).sourceWL.sectorID);
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.sectorIDField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        SourceEditor.this.setCurrentField(SourcePanel.this.sectorIDField);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            SourcePanel.this.sectorIDField.postActionEvent();
                        }
                    }
                });
                jPanel12 = new JPanel();
                jPanel12.setBorder(BorderFactory.createTitledBorder("Sector ID"));
                jPanel12.add(this.sectorIDField);
            }
            JPanel jPanel13 = null;
            if (SourceEditor.this.isTV || SourceEditor.this.isFM) {
                this.channelField = new JTextField(5);
                AppController.fixKeyBindings(this.channelField);
                this.channelField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            int n = SourceEditor.this.isTV ? ((SourcePanel)SourcePanel.this).sourceTV.channel : ((SourcePanel)SourcePanel.this).sourceFM.channel;
                            if (SourcePanel.this.canEditChan) {
                                String string = "Edit Channel";
                                String string2 = SourcePanel.this.channelField.getText().trim();
                                if (string2.length() > 0) {
                                    int n2 = 0;
                                    try {
                                        n2 = Integer.parseInt(string2);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The channel must be a number");
                                    }
                                    if (n2 != n) {
                                        if (SourcePanel.this.isDTSAuthorized) {
                                            if (n2 < 2 || n2 > 69) {
                                                SourceEditor.this.errorReporter.reportValidationError(string, "The channel must be in the range 2 to 69");
                                            } else {
                                                ((SourcePanel)SourcePanel.this).sourceTV.channel = n2;
                                                n = n2;
                                            }
                                        } else if (n2 < SourceEditor.this.minimumChannel || n2 > SourceEditor.this.maximumChannel) {
                                            SourceEditor.this.errorReporter.reportValidationError(string, "The channel must be in the range " + SourceEditor.this.minimumChannel + " to " + SourceEditor.this.maximumChannel);
                                        } else {
                                            if (SourceEditor.this.isTV) {
                                                ((SourcePanel)SourcePanel.this).sourceTV.channel = n2;
                                            } else {
                                                ((SourcePanel)SourcePanel.this).sourceFM.channel = n2;
                                            }
                                            n = n2;
                                        }
                                    }
                                }
                            }
                            SourcePanel.this.channelField.setText(String.valueOf(n));
                            SourcePanel.this.updateFrequency();
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.channelField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        SourceEditor.this.setCurrentField(SourcePanel.this.channelField);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            SourcePanel.this.channelField.postActionEvent();
                        }
                    }
                });
                this.replicationLabel = new JLabel(" ");
                object = AppCore.getPreference((String)"allowFrequencyEdit");
                if (SourceEditor.this.isTV && null == this.sourceTV.parentSourceKey && null != object && Boolean.valueOf((String)object).booleanValue()) {
                    this.frequencyField = new JTextField(5);
                    AppController.fixKeyBindings(this.frequencyField);
                    this.frequencyField.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (SourceEditor.this.blockActions()) {
                                if (SourcePanel.this.canEditChan) {
                                    String string = "Edit Frequency";
                                    double d = SourcePanel.this.source.getFrequencyValue();
                                    String string2 = SourcePanel.this.frequencyField.getText().trim();
                                    if (string2.length() > 0) {
                                        double d2 = 0.0;
                                        try {
                                            d2 = Double.parseDouble(string2);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            SourceEditor.this.errorReporter.reportValidationError(string, "The frequency must be a number");
                                        }
                                        if (d2 != d) {
                                            if (d2 < 40.0 || d2 > 10000.0) {
                                                SourceEditor.this.errorReporter.reportValidationError(string, "The frequency must be in the range " + AppCore.formatDecimal((double)40.0, (int)2) + " to " + AppCore.formatDecimal((double)10000.0, (int)2) + " MHz");
                                            } else {
                                                SourcePanel.this.source.setAttribute("frequency", string2);
                                            }
                                        }
                                    }
                                }
                                SourcePanel.this.updateFrequency();
                                SourceEditor.this.blockActionsEnd();
                            }
                        }
                    });
                    this.frequencyField.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent focusEvent) {
                            SourceEditor.this.setCurrentField(SourcePanel.this.frequencyField);
                        }

                        @Override
                        public void focusLost(FocusEvent focusEvent) {
                            if (!focusEvent.isTemporary()) {
                                SourcePanel.this.frequencyField.postActionEvent();
                            }
                        }
                    });
                    this.editFrequencyCheckBox = new JCheckBox("Change frequency");
                    this.editFrequencyCheckBox.setFocusable(false);
                    this.editFrequencyCheckBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (SourceEditor.this.blockActions()) {
                                if (SourcePanel.this.canEditChan) {
                                    if (SourcePanel.this.editFrequencyCheckBox.isSelected()) {
                                        SourcePanel.this.source.setAttribute("frequency", SourcePanel.this.frequencyField.getText().trim());
                                    } else {
                                        SourcePanel.this.source.removeAttribute("frequency");
                                    }
                                } else {
                                    SourcePanel.this.editFrequencyCheckBox.setSelected(null != SourcePanel.this.source.getAttribute("frequency"));
                                }
                                SourcePanel.this.updateFrequency();
                                SourceEditor.this.blockActionsEnd();
                            }
                        }
                    });
                } else {
                    this.frequencyLabel = new JLabel(" ");
                }
                jPanel8 = new JPanel();
                jPanel8.add(this.channelField);
                if (null != this.frequencyLabel) {
                    jPanel8.add(this.frequencyLabel);
                }
                if (null != this.frequencyField) {
                    jPanel8.add(this.frequencyField);
                    jPanel8.add(new JLabel("MHz"));
                }
                jPanel13 = new JPanel();
                jPanel13.setLayout(new BoxLayout(jPanel13, 1));
                jPanel13.setBorder(BorderFactory.createTitledBorder("Channel"));
                jPanel13.add(jPanel8);
                if (null != this.editFrequencyCheckBox) {
                    jPanel13.add(this.editFrequencyCheckBox);
                }
                jPanel13.add(this.replicationLabel);
            }
            this.cityField = new JTextField(18);
            AppController.fixKeyBindings(this.cityField);
            this.cityField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        String string;
                        if (SourcePanel.this.canEditCallCityState && ((string = SourcePanel.this.cityField.getText().trim()).length() > 0 || SourceEditor.this.isWL)) {
                            if (string.length() > 20) {
                                SourceEditor.this.errorReporter.reportValidationError("Edit City", "The city name cannot be longer than 20 characters");
                            } else {
                                ((SourcePanel)SourcePanel.this).source.city = string;
                            }
                        }
                        SourcePanel.this.cityField.setText(((SourcePanel)SourcePanel.this).source.city);
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.cityField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(SourcePanel.this.cityField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        SourcePanel.this.cityField.postActionEvent();
                    }
                }
            });
            object = new JPanel();
            ((JComponent)object).setBorder(BorderFactory.createTitledBorder("City"));
            ((Container)object).add(this.cityField);
            this.stateField = new JTextField(3);
            AppController.fixKeyBindings(this.stateField);
            this.stateField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        String string;
                        if (SourcePanel.this.canEditCallCityState && ((string = SourcePanel.this.stateField.getText().trim().toUpperCase()).length() > 0 || SourceEditor.this.isWL)) {
                            if (string.length() > 2) {
                                SourceEditor.this.errorReporter.reportValidationError("Edit State", "The state code cannot be longer than 2 characters");
                            } else {
                                ((SourcePanel)SourcePanel.this).source.state = string;
                            }
                        }
                        SourcePanel.this.stateField.setText(((SourcePanel)SourcePanel.this).source.state);
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.stateField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(SourcePanel.this.stateField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        SourcePanel.this.stateField.postActionEvent();
                    }
                }
            });
            jPanel8 = new JPanel();
            jPanel8.setBorder(BorderFactory.createTitledBorder("State"));
            jPanel8.add(this.stateField);
            this.countryLabel = new JLabel(" ");
            this.countryLabel.setPreferredSize(AppController.labelSize[6]);
            this.countryMenu = new KeyedRecordMenu(Country.getCountries());
            this.countryMenu.setVisible(false);
            this.countryMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourcePanel.this.canEditFacServCntry) {
                            SourceEditor.this.country = (Country)SourcePanel.this.countryMenu.getSelectedItem();
                        } else {
                            SourcePanel.this.countryMenu.setSelectedItem((KeyedRecord)SourceEditor.this.country);
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            JPanel jPanel14 = new JPanel();
            jPanel14.setBorder(BorderFactory.createTitledBorder("Country"));
            jPanel14.add(this.countryLabel);
            jPanel14.add(this.countryMenu);
            JPanel jPanel15 = null;
            if (SourceEditor.this.isTV) {
                this.zoneMenu = new KeyedRecordMenu(Zone.getZonesWithNull());
                this.zoneMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourcePanel.this.canEditZoneStatFileOfsMask) {
                                ((SourcePanel)SourcePanel.this).sourceTV.zone = (Zone)SourcePanel.this.zoneMenu.getSelectedItem();
                            } else {
                                SourcePanel.this.zoneMenu.setSelectedItem((KeyedRecord)((SourcePanel)SourcePanel.this).sourceTV.zone);
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                jPanel15 = new JPanel();
                jPanel15.setBorder(BorderFactory.createTitledBorder("Zone"));
                jPanel15.add(this.zoneMenu);
            }
            JPanel jPanel16 = null;
            if (SourceEditor.this.isTV || SourceEditor.this.isFM) {
                this.statusMenu = new KeyedRecordMenu(ExtDbRecord.getStatusList());
                this.statusMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourcePanel.this.canEditZoneStatFileOfsMask) {
                                SourcePanel.this.statusItem = SourcePanel.this.statusMenu.getSelectedItem();
                                if (SourceEditor.this.isTV) {
                                    ((SourcePanel)SourcePanel.this).sourceTV.status = ((SourcePanel)SourcePanel.this).statusItem.name;
                                    ((SourcePanel)SourcePanel.this).sourceTV.statusType = ((SourcePanel)SourcePanel.this).statusItem.key;
                                } else {
                                    ((SourcePanel)SourcePanel.this).sourceFM.status = ((SourcePanel)SourcePanel.this).statusItem.name;
                                    ((SourcePanel)SourcePanel.this).sourceFM.statusType = ((SourcePanel)SourcePanel.this).statusItem.key;
                                }
                            } else {
                                SourcePanel.this.statusMenu.setSelectedItem(SourcePanel.this.statusItem);
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                jPanel16 = new JPanel();
                jPanel16.setBorder(BorderFactory.createTitledBorder("Status"));
                jPanel16.add(this.statusMenu);
            }
            this.fileNumberField = new JTextField(15);
            AppController.fixKeyBindings(this.fileNumberField);
            this.fileNumberField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourcePanel.this.canEditZoneStatFileOfsMask) {
                            String string = SourcePanel.this.fileNumberField.getText().trim();
                            if (string.length() > 255) {
                                if (SourceEditor.this.isWL) {
                                    SourceEditor.this.errorReporter.reportValidationError("Edit Reference Number", "The reference number cannot be longer than 255 characters");
                                } else {
                                    SourceEditor.this.errorReporter.reportValidationError("Edit File Number", "The file number cannot be longer than 255 characters");
                                }
                            } else {
                                ((SourcePanel)SourcePanel.this).source.fileNumber = string;
                                if (SourceEditor.this.isTV || SourceEditor.this.isFM) {
                                    String string2 = ExtDbRecord.parseFileNumber((String)string)[1];
                                    if (SourceEditor.this.isTV) {
                                        ((SourcePanel)SourcePanel.this).sourceTV.appARN = string2;
                                    } else {
                                        ((SourcePanel)SourcePanel.this).sourceFM.appARN = string2;
                                    }
                                }
                            }
                        }
                        SourcePanel.this.fileNumberField.setText(((SourcePanel)SourcePanel.this).source.fileNumber);
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.fileNumberField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(SourcePanel.this.fileNumberField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        SourcePanel.this.fileNumberField.postActionEvent();
                    }
                }
            });
            JPanel jPanel17 = new JPanel();
            string = "File Number";
            if (SourceEditor.this.isWL) {
                string = "Reference Number";
            }
            jPanel17.setBorder(BorderFactory.createTitledBorder(string));
            jPanel17.add(this.fileNumberField);
            JPanel jPanel18 = null;
            if (SourceEditor.this.isTV && !((SourceEditor)SourceEditor.this).service.isDTS && SignalType.hasMultipleOptions()) {
                this.signalTypeMenu = new KeyedRecordMenu(SignalType.getSignalTypes());
                this.signalTypeMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourceEditor.this.canEdit && ((SourceEditor)SourceEditor.this).service.serviceType.digital) {
                                ((SourcePanel)SourcePanel.this).sourceTV.signalType = (SignalType)SourcePanel.this.signalTypeMenu.getSelectedItem();
                            } else {
                                SourcePanel.this.signalTypeMenu.setSelectedItem((KeyedRecord)((SourcePanel)SourcePanel.this).sourceTV.signalType);
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                jPanel18 = new JPanel();
                jPanel18.setBorder(BorderFactory.createTitledBorder("Mod. Type"));
                jPanel18.add(this.signalTypeMenu);
            }
            JPanel jPanel19 = null;
            if (SourceEditor.this.isTV) {
                this.frequencyOffsetMenu = new KeyedRecordMenu(FrequencyOffset.getFrequencyOffsetsWithNull());
                this.frequencyOffsetMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourcePanel.this.canEditZoneStatFileOfsMask) {
                                ((SourcePanel)SourcePanel.this).sourceTV.frequencyOffset = (FrequencyOffset)SourcePanel.this.frequencyOffsetMenu.getSelectedItem();
                            } else {
                                SourcePanel.this.frequencyOffsetMenu.setSelectedItem((KeyedRecord)((SourcePanel)SourcePanel.this).sourceTV.frequencyOffset);
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                jPanel19 = new JPanel();
                jPanel19.setBorder(BorderFactory.createTitledBorder("Freq. Offset"));
                jPanel19.add(this.frequencyOffsetMenu);
            }
            JPanel jPanel20 = null;
            if (SourceEditor.this.isTV) {
                this.emissionMaskMenu = new KeyedRecordMenu(EmissionMask.getEmissionMasksWithNull());
                this.emissionMaskMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourcePanel.this.canEditZoneStatFileOfsMask && (SourcePanel.this.isDTSAuthorized && ((SourcePanel)SourcePanel.this).source.service.serviceType.needsEmissionMask || !SourcePanel.this.isDTSAuthorized && ((SourceEditor)SourceEditor.this).service.serviceType.needsEmissionMask)) {
                                ((SourcePanel)SourcePanel.this).sourceTV.emissionMask = (EmissionMask)SourcePanel.this.emissionMaskMenu.getSelectedItem();
                            } else {
                                SourcePanel.this.emissionMaskMenu.setSelectedItem((KeyedRecord)((SourcePanel)SourcePanel.this).sourceTV.emissionMask);
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                jPanel20 = new JPanel();
                jPanel20.setBorder(BorderFactory.createTitledBorder("Emission Mask"));
                jPanel20.add(this.emissionMaskMenu);
            }
            this.editPoint = new GeoPoint();
            this.latitudePanel = new CoordinatePanel(SourceEditor.this.outerThis, this.editPoint, false, new Runnable(){

                @Override
                public void run() {
                    if (SourcePanel.this.canEditCoords) {
                        ((SourcePanel)SourcePanel.this).source.location.latitude = ((SourcePanel)SourcePanel.this).editPoint.latitude;
                        ((SourcePanel)SourcePanel.this).source.location.updateDMS();
                        if (((SourceEditor)SourceEditor.this).mainSource.service.isDTS && 0 == ((SourcePanel)SourcePanel.this).sourceTV.siteNumber && !((SourceEditor)SourceEditor.this).mainSource.service.isFullService()) {
                            ((SourceEditor)SourceEditor.this).mainSource.location.latitude = ((SourcePanel)SourcePanel.this).editPoint.latitude;
                            ((SourceEditor)SourceEditor.this).mainSource.location.updateDMS();
                        }
                    }
                }
            });
            this.longitudePanel = new CoordinatePanel(SourceEditor.this.outerThis, this.editPoint, true, new Runnable(){

                @Override
                public void run() {
                    if (SourcePanel.this.canEditCoords) {
                        ((SourcePanel)SourcePanel.this).source.location.longitude = ((SourcePanel)SourcePanel.this).editPoint.longitude;
                        ((SourcePanel)SourcePanel.this).source.location.updateDMS();
                        if (((SourceEditor)SourceEditor.this).mainSource.service.isDTS && 0 == ((SourcePanel)SourcePanel.this).sourceTV.siteNumber && !((SourceEditor)SourceEditor.this).mainSource.service.isFullService()) {
                            ((SourceEditor)SourceEditor.this).mainSource.location.longitude = ((SourcePanel)SourcePanel.this).editPoint.longitude;
                            ((SourceEditor)SourceEditor.this).mainSource.location.updateDMS();
                        }
                    }
                }
            });
            this.copyPastePanel = new CoordinateCopyPastePanel(this.latitudePanel, this.longitudePanel);
            this.heightAMSLField = new JTextField(7);
            AppController.fixKeyBindings(this.heightAMSLField);
            this.heightAMSLField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        String string;
                        if (SourceEditor.this.canEdit) {
                            string = "Edit Height AMSL";
                            String string2 = SourcePanel.this.heightAMSLField.getText().trim();
                            if (string2.length() > 0) {
                                if (string2.equals("(derive)")) {
                                    string2 = String.valueOf(-999.0);
                                }
                                double d = ((SourcePanel)SourcePanel.this).source.heightAMSL;
                                try {
                                    d = Double.parseDouble(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The height must be a number");
                                }
                                if (d != ((SourcePanel)SourcePanel.this).source.heightAMSL) {
                                    if (d < -1100.0 || d > 10000.0) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The height must be in the range -1100.0 to 10000.0");
                                    } else {
                                        ((SourcePanel)SourcePanel.this).source.heightAMSL = d;
                                    }
                                }
                            }
                        }
                        if (-999.0 == ((SourcePanel)SourcePanel.this).source.heightAMSL) {
                            SourcePanel.this.heightAMSLField.setText("(derive)");
                        } else {
                            SourcePanel.this.heightAMSLField.setText(AppCore.formatHeight((double)((SourcePanel)SourcePanel.this).source.heightAMSL));
                        }
                        string = SourcePanel.this.source.getSource();
                        if (null != string && ((Source)string).actualHeightAMSL != ((SourcePanel)SourcePanel.this).source.heightAMSL && -999.0 != ((Source)string).actualHeightAMSL) {
                            SourcePanel.this.actualHeightAMSLLabel.setText("Last run: " + AppCore.formatHeight((double)((Source)string).actualHeightAMSL));
                        } else {
                            SourcePanel.this.actualHeightAMSLLabel.setText(" ");
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.heightAMSLField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(SourcePanel.this.heightAMSLField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        SourcePanel.this.heightAMSLField.postActionEvent();
                    }
                }
            });
            this.actualHeightAMSLLabel = new JLabel("Last run: 9999.9");
            JPanel jPanel21 = new JPanel();
            jPanel21.setBorder(BorderFactory.createTitledBorder("Height AMSL, m"));
            JPanel jPanel22 = new JPanel();
            jPanel22.setLayout(new BoxLayout(jPanel22, 1));
            jPanel22.add(this.heightAMSLField);
            jPanel22.add(this.actualHeightAMSLLabel);
            jPanel21.add(jPanel22);
            this.overallHAATField = new JTextField(7);
            AppController.fixKeyBindings(this.overallHAATField);
            this.overallHAATField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        String string;
                        if (SourceEditor.this.canEdit) {
                            string = "Edit HAAT";
                            String string2 = SourcePanel.this.overallHAATField.getText().trim();
                            if (string2.length() > 0) {
                                if (string2.equals("(derive)")) {
                                    string2 = String.valueOf(-999.0);
                                }
                                double d = ((SourcePanel)SourcePanel.this).source.overallHAAT;
                                try {
                                    d = Double.parseDouble(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The HAAT must be a number");
                                }
                                if (d != ((SourcePanel)SourcePanel.this).source.overallHAAT) {
                                    if (d < -1100.0 || d > 10000.0) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The HAAT must be in the range -1100.0 to 10000.0");
                                    } else {
                                        ((SourcePanel)SourcePanel.this).source.overallHAAT = d;
                                    }
                                }
                            }
                        }
                        if (-999.0 == ((SourcePanel)SourcePanel.this).source.overallHAAT) {
                            SourcePanel.this.overallHAATField.setText("(derive)");
                        } else {
                            SourcePanel.this.overallHAATField.setText(AppCore.formatHeight((double)((SourcePanel)SourcePanel.this).source.overallHAAT));
                        }
                        string = SourcePanel.this.source.getSource();
                        if (null != string && ((Source)string).actualOverallHAAT != ((SourcePanel)SourcePanel.this).source.overallHAAT && -999.0 != ((Source)string).actualOverallHAAT) {
                            SourcePanel.this.actualOverallHAATLabel.setText("Last run: " + AppCore.formatHeight((double)((Source)string).actualOverallHAAT));
                        } else {
                            SourcePanel.this.actualOverallHAATLabel.setText(" ");
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.overallHAATField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(SourcePanel.this.overallHAATField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        SourcePanel.this.overallHAATField.postActionEvent();
                    }
                }
            });
            this.actualOverallHAATLabel = new JLabel("Last run: 9999.9");
            JPanel jPanel23 = new JPanel();
            jPanel23.setBorder(BorderFactory.createTitledBorder("HAAT, m"));
            jPanel22 = new JPanel();
            jPanel22.setLayout(new BoxLayout(jPanel22, 1));
            jPanel22.add(this.overallHAATField);
            jPanel22.add(this.actualOverallHAATLabel);
            jPanel23.add(jPanel22);
            this.peakERPField = new JTextField(7);
            AppController.fixKeyBindings(this.peakERPField);
            this.peakERPField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit) {
                            String string = "Edit Peak ERP";
                            String string2 = SourcePanel.this.peakERPField.getText().trim();
                            if (string2.length() > 0) {
                                double d = ((SourcePanel)SourcePanel.this).source.peakERP;
                                try {
                                    d = Double.parseDouble(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The ERP must be a number");
                                }
                                if (d != ((SourcePanel)SourcePanel.this).source.peakERP) {
                                    if (d < 1.0E-5 || d > 5000.0) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The ERP must be in the range 1.0E-5 to 5000.0");
                                    } else {
                                        ((SourcePanel)SourcePanel.this).source.peakERP = d;
                                    }
                                }
                            }
                        }
                        SourcePanel.this.peakERPField.setText(AppCore.formatERP((double)((SourcePanel)SourcePanel.this).source.peakERP));
                        if (SourceEditor.this.isFM && ((SourcePanel)SourcePanel.this).sourceFM.isIBOC) {
                            SourcePanel.this.ibocERPField.setText(AppCore.formatERP((double)(((SourcePanel)SourcePanel.this).sourceFM.peakERP * ((SourcePanel)SourcePanel.this).sourceFM.ibocFraction)));
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.peakERPField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(SourcePanel.this.peakERPField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        SourcePanel.this.peakERPField.postActionEvent();
                    }
                }
            });
            JPanel jPanel24 = new JPanel();
            jPanel24.setBorder(BorderFactory.createTitledBorder("Peak ERP, kW"));
            jPanel24.add(this.peakERPField);
            Object var24_25 = null;
            if (SourceEditor.this.isFM) {
                this.ibocCheckBox = new JCheckBox("IBOC digital");
                this.ibocCheckBox.setFocusable(false);
                this.ibocCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourceEditor.this.canEdit) {
                                ((SourcePanel)SourcePanel.this).sourceFM.isIBOC = SourcePanel.this.ibocCheckBox.isSelected();
                            }
                            if (((SourcePanel)SourcePanel.this).sourceFM.isIBOC) {
                                SourcePanel.this.ibocERPField.setText(AppCore.formatERP((double)(((SourcePanel)SourcePanel.this).sourceFM.peakERP * ((SourcePanel)SourcePanel.this).sourceFM.ibocFraction)));
                            } else {
                                SourcePanel.this.ibocERPField.setText("");
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.ibocERPField = new JTextField(7);
                AppController.fixKeyBindings(this.ibocERPField);
                this.ibocERPField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourceEditor.this.canEdit) {
                                String string = "Edit IBOC ERP";
                                String string2 = SourcePanel.this.ibocERPField.getText().trim();
                                if (string2.length() > 0) {
                                    double d = ((SourcePanel)SourcePanel.this).sourceFM.ibocFraction;
                                    try {
                                        d = Double.parseDouble(string2) / ((SourcePanel)SourcePanel.this).sourceFM.peakERP;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The ERP must be a number");
                                    }
                                    if (d != ((SourcePanel)SourcePanel.this).sourceFM.ibocFraction) {
                                        if (d < 0.01 || d > 0.1) {
                                            SourceEditor.this.errorReporter.reportValidationError(string, "The IBOC ERP must be between 1% and 10% of the peak ERP");
                                        } else {
                                            ((SourcePanel)SourcePanel.this).sourceFM.ibocFraction = d;
                                        }
                                    }
                                }
                            }
                            SourcePanel.this.ibocERPField.setText(AppCore.formatERP((double)(((SourcePanel)SourcePanel.this).sourceFM.peakERP * ((SourcePanel)SourcePanel.this).sourceFM.ibocFraction)));
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.ibocERPField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        SourceEditor.this.setCurrentField(SourcePanel.this.ibocERPField);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            SourcePanel.this.ibocERPField.postActionEvent();
                        }
                    }
                });
                jPanel7 = new JPanel();
                jPanel7.setBorder(BorderFactory.createTitledBorder("IBOC ERP, kW"));
                jPanel7.add(this.ibocERPField);
                jPanel6 = new JPanel();
                jPanel6.setLayout(new BoxLayout(jPanel6, 1));
                jPanel6.add(jPanel24);
                jPanel6.add(this.ibocCheckBox);
                jPanel6.add(jPanel7);
                jPanel24 = new JPanel();
                jPanel24.add(jPanel6);
            }
            this.horizontalPatternLabel = new JLabel(" ");
            this.horizontalPatternLabel.setPreferredSize(AppController.labelSize[20]);
            this.editHorizontalPatternButton = new JButton("Edit");
            this.editHorizontalPatternButton.setFocusable(false);
            this.editHorizontalPatternButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SourcePanel.this.doEditHorizontalPattern();
                }
            });
            if (SourceEditor.this.canEdit) {
                this.changeHorizontalPatternMenu = new KeyedRecordMenu();
                this.changeHorizontalPatternMenu.addItem(new KeyedRecord(0, "Change..."));
                this.changeHorizontalPatternMenu.addItem(new KeyedRecord(1, "Import..."));
                this.changeHorizontalPatternMenu.addItem(new KeyedRecord(2, "Search..."));
                this.changeHorizontalPatternMenu.addItem(new KeyedRecord(3, "New..."));
                this.changeHorizontalPatternMenu.addItem(new KeyedRecord(4, "Remove"));
                this.changeHorizontalPatternMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            SourcePanel.this.doChangeHorizontalPattern(SourcePanel.this.changeHorizontalPatternMenu.getSelectedKey());
                            SourcePanel.this.changeHorizontalPatternMenu.setSelectedIndex(0);
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
            }
            this.exportHorizontalPatternButton = new JButton("Export");
            this.exportHorizontalPatternButton.setFocusable(false);
            this.exportHorizontalPatternButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SourcePanel.this.doExportHorizontalPattern();
                }
            });
            this.horizontalPatternOrientationField = new JTextField(7);
            AppController.fixKeyBindings(this.horizontalPatternOrientationField);
            this.horizontalPatternOrientationField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit) {
                            String string = "Edit Antenna Orientation";
                            String string2 = SourcePanel.this.horizontalPatternOrientationField.getText().trim();
                            if (string2.length() > 0) {
                                double d = ((SourcePanel)SourcePanel.this).source.horizontalPatternOrientation;
                                try {
                                    d = Math.IEEEremainder(Double.parseDouble(string2), 360.0);
                                    if (d < 0.0) {
                                        d += 360.0;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The orientation must be a number");
                                }
                                if (d != ((SourcePanel)SourcePanel.this).source.horizontalPatternOrientation) {
                                    ((SourcePanel)SourcePanel.this).source.horizontalPatternOrientation = d;
                                }
                            }
                        }
                        SourcePanel.this.horizontalPatternOrientationField.setText(AppCore.formatAzimuth((double)((SourcePanel)SourcePanel.this).source.horizontalPatternOrientation));
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.horizontalPatternOrientationField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(SourcePanel.this.horizontalPatternOrientationField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        SourcePanel.this.horizontalPatternOrientationField.postActionEvent();
                    }
                }
            });
            jPanel7 = new JPanel(new FlowLayout(0));
            jPanel7.add(this.editHorizontalPatternButton);
            if (null != this.changeHorizontalPatternMenu) {
                jPanel7.add(this.changeHorizontalPatternMenu);
            }
            jPanel7.add(this.exportHorizontalPatternButton);
            jPanel6 = new JPanel(new GridLayout(2, 1));
            jPanel6.add(this.horizontalPatternLabel);
            jPanel6.add(jPanel7);
            JPanel jPanel25 = new JPanel(new GridLayout(2, 1));
            jPanel25.add(new JLabel("Orient."));
            jPanel25.add(this.horizontalPatternOrientationField);
            JPanel jPanel26 = new JPanel();
            jPanel26.setBorder(BorderFactory.createTitledBorder("Azimuth Pattern"));
            jPanel26.add(jPanel6);
            jPanel26.add(jPanel25);
            this.verticalPatternLabel = new JLabel(" ");
            this.verticalPatternLabel.setPreferredSize(AppController.labelSize[20]);
            this.editVerticalPatternButton = new JButton("Edit");
            this.editVerticalPatternButton.setFocusable(false);
            this.editVerticalPatternButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SourcePanel.this.doEditVerticalPattern();
                }
            });
            if (SourceEditor.this.canEdit) {
                this.changeVerticalPatternMenu = new KeyedRecordMenu();
                this.changeVerticalPatternMenu.addItem(new KeyedRecord(0, "Change..."));
                this.changeVerticalPatternMenu.addItem(new KeyedRecord(1, "Import..."));
                this.changeVerticalPatternMenu.addItem(new KeyedRecord(2, "Search..."));
                this.changeVerticalPatternMenu.addItem(new KeyedRecord(3, "New..."));
                this.changeVerticalPatternMenu.addItem(new KeyedRecord(4, "Remove"));
                this.changeVerticalPatternMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            SourcePanel.this.doChangeVerticalPattern(SourcePanel.this.changeVerticalPatternMenu.getSelectedKey());
                            SourcePanel.this.changeVerticalPatternMenu.setSelectedIndex(0);
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
            }
            this.exportVerticalPatternButton = new JButton("Export");
            this.exportVerticalPatternButton.setFocusable(false);
            this.exportVerticalPatternButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SourcePanel.this.doExportVerticalPattern();
                }
            });
            this.verticalPatternElectricalTiltField = new JTextField(7);
            AppController.fixKeyBindings(this.verticalPatternElectricalTiltField);
            this.verticalPatternElectricalTiltField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit) {
                            String string = "Edit Electrical Tilt";
                            String string2 = SourcePanel.this.verticalPatternElectricalTiltField.getText().trim();
                            if (string2.length() > 0) {
                                double d = ((SourcePanel)SourcePanel.this).source.verticalPatternElectricalTilt;
                                try {
                                    d = Double.parseDouble(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The tilt must be a number");
                                }
                                if (d != ((SourcePanel)SourcePanel.this).source.verticalPatternElectricalTilt) {
                                    if (d < -10.0 || d > 16.0) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The tilt must be in the range -10.0 to 16.0");
                                    } else {
                                        ((SourcePanel)SourcePanel.this).source.verticalPatternElectricalTilt = d;
                                    }
                                }
                            }
                        }
                        SourcePanel.this.verticalPatternElectricalTiltField.setText(AppCore.formatDepression((double)((SourcePanel)SourcePanel.this).source.verticalPatternElectricalTilt));
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.verticalPatternElectricalTiltField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(SourcePanel.this.verticalPatternElectricalTiltField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        SourcePanel.this.verticalPatternElectricalTiltField.postActionEvent();
                    }
                }
            });
            this.verticalPatternMechanicalTiltField = new JTextField(7);
            AppController.fixKeyBindings(this.verticalPatternMechanicalTiltField);
            this.verticalPatternMechanicalTiltField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit) {
                            String string = "Edit Mechanical Tilt";
                            String string2 = SourcePanel.this.verticalPatternMechanicalTiltField.getText().trim();
                            if (string2.length() > 0) {
                                double d = ((SourcePanel)SourcePanel.this).source.verticalPatternMechanicalTilt;
                                try {
                                    d = Double.parseDouble(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The tilt must be a number");
                                }
                                if (d != ((SourcePanel)SourcePanel.this).source.verticalPatternMechanicalTilt) {
                                    if (d < -10.0 || d > 16.0) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The tilt must be in the range -10.0 to 16.0");
                                    } else {
                                        ((SourcePanel)SourcePanel.this).source.verticalPatternMechanicalTilt = d;
                                    }
                                }
                            }
                        }
                        SourcePanel.this.verticalPatternMechanicalTiltField.setText(AppCore.formatDepression((double)((SourcePanel)SourcePanel.this).source.verticalPatternMechanicalTilt));
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.verticalPatternMechanicalTiltField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(SourcePanel.this.verticalPatternMechanicalTiltField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        SourcePanel.this.verticalPatternMechanicalTiltField.postActionEvent();
                    }
                }
            });
            this.verticalPatternMechanicalTiltOrientationField = new JTextField(7);
            AppController.fixKeyBindings(this.verticalPatternMechanicalTiltOrientationField);
            this.verticalPatternMechanicalTiltOrientationField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit) {
                            String string = "Edit Tilt Orientation";
                            String string2 = SourcePanel.this.verticalPatternMechanicalTiltOrientationField.getText().trim();
                            if (string2.length() > 0) {
                                double d = ((SourcePanel)SourcePanel.this).source.verticalPatternMechanicalTiltOrientation;
                                try {
                                    d = Math.IEEEremainder(Double.parseDouble(string2), 360.0);
                                    if (d < 0.0) {
                                        d += 360.0;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The orientation must be a number");
                                }
                                if (d != ((SourcePanel)SourcePanel.this).source.verticalPatternMechanicalTiltOrientation) {
                                    ((SourcePanel)SourcePanel.this).source.verticalPatternMechanicalTiltOrientation = d;
                                }
                            }
                        }
                        SourcePanel.this.verticalPatternMechanicalTiltOrientationField.setText(AppCore.formatAzimuth((double)((SourcePanel)SourcePanel.this).source.verticalPatternMechanicalTiltOrientation));
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            this.verticalPatternMechanicalTiltOrientationField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SourceEditor.this.setCurrentField(SourcePanel.this.verticalPatternMechanicalTiltOrientationField);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        SourcePanel.this.verticalPatternMechanicalTiltOrientationField.postActionEvent();
                    }
                }
            });
            this.useGenericVerticalPatternCheckBox = new JCheckBox("May use generic pattern when needed");
            this.useGenericVerticalPatternCheckBox.setFocusable(false);
            this.useGenericVerticalPatternCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceEditor.this.blockActions()) {
                        if (SourceEditor.this.canEdit) {
                            ((SourcePanel)SourcePanel.this).source.useGenericVerticalPattern = SourcePanel.this.useGenericVerticalPatternCheckBox.isSelected();
                        } else {
                            SourcePanel.this.useGenericVerticalPatternCheckBox.setSelected(((SourcePanel)SourcePanel.this).source.useGenericVerticalPattern);
                        }
                        SourceEditor.this.blockActionsEnd();
                    }
                }
            });
            JPanel jPanel27 = new JPanel(new FlowLayout(0));
            jPanel27.add(this.editVerticalPatternButton);
            if (null != this.changeVerticalPatternMenu) {
                jPanel27.add(this.changeVerticalPatternMenu);
            }
            jPanel27.add(this.exportVerticalPatternButton);
            JPanel jPanel28 = new JPanel(new GridLayout(2, 1));
            jPanel28.add(this.verticalPatternLabel);
            jPanel28.add(jPanel27);
            JPanel jPanel29 = new JPanel(new GridLayout(2, 3));
            jPanel29.add(new JLabel("Elec. Tilt"));
            jPanel29.add(new JLabel("Mech. Tilt"));
            jPanel29.add(new JLabel("Tilt Orient."));
            jPanel29.add(this.verticalPatternElectricalTiltField);
            jPanel29.add(this.verticalPatternMechanicalTiltField);
            jPanel29.add(this.verticalPatternMechanicalTiltOrientationField);
            JPanel jPanel30 = new JPanel(new GridLayout(2, 1));
            jPanel30.add(jPanel29);
            jPanel30.add(this.useGenericVerticalPatternCheckBox);
            JPanel jPanel31 = new JPanel();
            jPanel31.setBorder(BorderFactory.createTitledBorder("Elevation Pattern"));
            jPanel31.add(jPanel28);
            jPanel31.add(jPanel30);
            JPanel jPanel32 = null;
            if (SourceEditor.this.isTV) {
                this.siteNumberField = new JTextField(6);
                AppController.fixKeyBindings(this.siteNumberField);
                jPanel5 = this;
                this.siteNumberField.addActionListener(new ActionListener((SourcePanel)jPanel5){
                    final /* synthetic */ SourcePanel val$that;
                    {
                        this.val$that = sourcePanel2;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourcePanel.this.canEditSite) {
                                String string = "Edit Site Number";
                                String string2 = SourcePanel.this.siteNumberField.getText().trim();
                                if (string2.length() > 0) {
                                    int n = ((SourcePanel)SourcePanel.this).sourceTV.siteNumber;
                                    try {
                                        n = Integer.parseInt(string2);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The site number must be a number");
                                    }
                                    if (n != ((SourcePanel)SourcePanel.this).sourceTV.siteNumber) {
                                        if (((SourceEditor)SourceEditor.this).service.isDTS) {
                                            if (n < 1) {
                                                SourceEditor.this.errorReporter.reportValidationError(string, "The site number must be greater than 0");
                                            } else {
                                                ((SourcePanel)SourcePanel.this).sourceTV.siteNumber = n;
                                                int n2 = SourceEditor.this.dtsTabPane.indexOfComponent(this.val$that);
                                                if (n2 > 1) {
                                                    SourceEditor.this.dtsTabPane.setTitleAt(n2, "Site " + n);
                                                }
                                            }
                                        } else if (n < 0) {
                                            SourceEditor.this.errorReporter.reportValidationError(string, "The site number must be greater than or equal to 0");
                                        } else {
                                            ((SourcePanel)SourcePanel.this).sourceTV.siteNumber = n;
                                        }
                                    }
                                }
                            }
                            SourcePanel.this.siteNumberField.setText(String.valueOf(((SourcePanel)SourcePanel.this).sourceTV.siteNumber));
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.siteNumberField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        SourceEditor.this.setCurrentField(SourcePanel.this.siteNumberField);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            SourcePanel.this.siteNumberField.postActionEvent();
                        }
                    }
                });
                jPanel32 = new JPanel();
                jPanel32.setBorder(BorderFactory.createTitledBorder("Site Number"));
                jPanel32.add(this.siteNumberField);
            }
            jPanel5 = null;
            if ((SourceEditor.this.isTV || SourceEditor.this.isFM) && SourceEditor.this.showServiceArea) {
                this.serviceAreaModeMenu = new KeyedRecordMenu(SourceEditor.this.serviceAreaModeList);
                this.serviceAreaModeMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            int n = SourcePanel.this.serviceAreaModeMenu.getSelectedKey();
                            if (SourceEditor.this.isTV) {
                                if (SourcePanel.this.canEditServiceArea) {
                                    ((SourcePanel)SourcePanel.this).sourceTV.serviceAreaMode = n;
                                } else {
                                    n = ((SourcePanel)SourcePanel.this).sourceTV.serviceAreaMode;
                                    SourcePanel.this.serviceAreaModeMenu.setSelectedKey(n);
                                }
                            } else if (SourcePanel.this.canEditServiceArea) {
                                ((SourcePanel)SourcePanel.this).sourceFM.serviceAreaMode = n;
                            } else {
                                n = ((SourcePanel)SourcePanel.this).sourceFM.serviceAreaMode;
                                SourcePanel.this.serviceAreaModeMenu.setSelectedKey(n);
                            }
                            if (SourcePanel.this.canEditServiceArea) {
                                switch (n) {
                                    case 0: 
                                    case 7: {
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaArgumentField, false);
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaContourLevelField, false);
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaGeographyMenu, false);
                                        SourcePanel.this.editAreaGeoButton.setEnabled(false);
                                        break;
                                    }
                                    case 1: 
                                    case 11: {
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaArgumentField, false);
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaContourLevelField, true);
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaGeographyMenu, false);
                                        SourcePanel.this.editAreaGeoButton.setEnabled(false);
                                        break;
                                    }
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 8: 
                                    case 9: {
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaArgumentField, true);
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaContourLevelField, true);
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaGeographyMenu, false);
                                        SourcePanel.this.editAreaGeoButton.setEnabled(false);
                                        break;
                                    }
                                    case 5: 
                                    case 6: {
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaArgumentField, false);
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaContourLevelField, false);
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaGeographyMenu, true);
                                        SourcePanel.this.editAreaGeoButton.setEnabled(true);
                                        break;
                                    }
                                    case 10: {
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaArgumentField, true);
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaContourLevelField, false);
                                        AppController.setComponentEnabled(SourcePanel.this.serviceAreaGeographyMenu, false);
                                        SourcePanel.this.editAreaGeoButton.setEnabled(false);
                                    }
                                }
                            } else {
                                AppController.setComponentEnabled(SourcePanel.this.serviceAreaArgumentField, false);
                                AppController.setComponentEnabled(SourcePanel.this.serviceAreaContourLevelField, false);
                                AppController.setComponentEnabled(SourcePanel.this.serviceAreaGeographyMenu, false);
                                SourcePanel.this.editAreaGeoButton.setEnabled(false);
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.serviceAreaArgumentField = new JTextField(6);
                AppController.fixKeyBindings(this.serviceAreaArgumentField);
                this.serviceAreaArgumentField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            double d = SourceEditor.this.isTV ? ((SourcePanel)SourcePanel.this).sourceTV.serviceAreaArg : ((SourcePanel)SourcePanel.this).sourceFM.serviceAreaArg;
                            if (SourcePanel.this.canEditServiceArea) {
                                String string = "Edit Contour Mode Argument";
                                String string2 = SourcePanel.this.serviceAreaArgumentField.getText().trim();
                                if (string2.length() > 0) {
                                    double d2 = d;
                                    try {
                                        d2 = Double.parseDouble(string2);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The argument must be a number");
                                    }
                                    if (d2 != d) {
                                        if (d2 < 0.0 || d2 > 500.0) {
                                            SourceEditor.this.errorReporter.reportValidationError(string, "The argument must be in the range 0.0 to 500.0");
                                        } else {
                                            if (SourceEditor.this.isTV) {
                                                ((SourcePanel)SourcePanel.this).sourceTV.serviceAreaArg = d2;
                                            } else {
                                                ((SourcePanel)SourcePanel.this).sourceFM.serviceAreaArg = d2;
                                            }
                                            d = d2;
                                        }
                                    }
                                }
                            }
                            SourcePanel.this.serviceAreaArgumentField.setText(AppCore.formatDecimal((double)d, (int)1));
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.serviceAreaArgumentField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        SourceEditor.this.setCurrentField(SourcePanel.this.serviceAreaArgumentField);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            SourcePanel.this.serviceAreaArgumentField.postActionEvent();
                        }
                    }
                });
                this.serviceAreaContourLevelField = new JTextField(6);
                AppController.fixKeyBindings(this.serviceAreaContourLevelField);
                this.serviceAreaContourLevelField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            double d = SourceEditor.this.isTV ? ((SourcePanel)SourcePanel.this).sourceTV.serviceAreaCL : ((SourcePanel)SourcePanel.this).sourceFM.serviceAreaCL;
                            if (SourcePanel.this.canEditServiceArea) {
                                String string = "Edit Contour Level";
                                String string2 = SourcePanel.this.serviceAreaContourLevelField.getText().trim();
                                if (string2.length() > 0) {
                                    if (string2.equals("(default)")) {
                                        string2 = String.valueOf(-999.0);
                                    }
                                    double d2 = d;
                                    try {
                                        d2 = Double.parseDouble(string2);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The contour level must be a number");
                                    }
                                    if (d2 != d) {
                                        if (d2 != -999.0 && (d2 < 0.0 || d2 > 120.0)) {
                                            SourceEditor.this.errorReporter.reportValidationError(string, "The contour level must be in the range 0.0 to 120.0");
                                        } else {
                                            if (SourceEditor.this.isTV) {
                                                ((SourcePanel)SourcePanel.this).sourceTV.serviceAreaCL = d2;
                                            } else {
                                                ((SourcePanel)SourcePanel.this).sourceFM.serviceAreaCL = d2;
                                            }
                                            d = d2;
                                        }
                                    }
                                }
                            }
                            if (-999.0 == d) {
                                SourcePanel.this.serviceAreaContourLevelField.setText("(default)");
                            } else {
                                SourcePanel.this.serviceAreaContourLevelField.setText(AppCore.formatDecimal((double)d, (int)1));
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.serviceAreaContourLevelField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        SourceEditor.this.setCurrentField(SourcePanel.this.serviceAreaContourLevelField);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            SourcePanel.this.serviceAreaContourLevelField.postActionEvent();
                        }
                    }
                });
                this.serviceAreaGeographyMenu = new KeyedRecordMenu(SourceEditor.this.serviceAreaGeographyList);
                this.serviceAreaGeographyMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourceEditor.this.isTV) {
                                if (SourcePanel.this.canEditServiceArea) {
                                    ((SourcePanel)SourcePanel.this).sourceTV.serviceAreaKey = SourcePanel.this.serviceAreaGeographyMenu.getSelectedKey();
                                } else {
                                    SourcePanel.this.serviceAreaGeographyMenu.setSelectedKey(((SourcePanel)SourcePanel.this).sourceTV.serviceAreaKey);
                                }
                            } else if (SourcePanel.this.canEditServiceArea) {
                                ((SourcePanel)SourcePanel.this).sourceFM.serviceAreaKey = SourcePanel.this.serviceAreaGeographyMenu.getSelectedKey();
                            } else {
                                SourcePanel.this.serviceAreaGeographyMenu.setSelectedKey(((SourcePanel)SourcePanel.this).sourceFM.serviceAreaKey);
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                jPanel4 = new JPanel(new FlowLayout(0));
                jPanel4.add(this.serviceAreaModeMenu);
                jPanel3 = new JPanel(new GridLayout(2, 2));
                jPanel3.add(new JLabel("Mode Arg. km or %  "));
                jPanel3.add(new JLabel("Cont. Level dBu"));
                jPanel3.add(this.serviceAreaArgumentField);
                jPanel3.add(this.serviceAreaContourLevelField);
                this.editAreaGeoButton = new JButton("Edit");
                this.editAreaGeoButton.setFocusable(false);
                this.editAreaGeoButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (null != SourceEditor.this.mainSource && null != ((SourceEditor)SourceEditor.this).mainSource.study) {
                            int n = 0;
                            n = SourceEditor.this.isTV ? ((SourcePanel)SourcePanel.this).sourceTV.serviceAreaKey : ((SourcePanel)SourcePanel.this).sourceFM.serviceAreaKey;
                            SourcePanel.this.geographyEditPending = StudyManager.showGeographyEditor(SourceEditor.this.getDbID(), ((SourceEditor)SourceEditor.this).mainSource.study.study.key, ((SourceEditor)SourceEditor.this).mainSource.study.name, ((SourceEditor)SourceEditor.this).mainSource.key, ((SourceEditor)SourceEditor.this).mainSource.callSign, 2, n);
                        } else {
                            StudyManager.showGeographyEditor(SourceEditor.this.getDbID(), 0, "", 0, "", 2, 0);
                            SourcePanel.this.geographyEditPending = false;
                        }
                    }
                });
                jPanel2 = new JPanel();
                jPanel2.add(this.serviceAreaGeographyMenu);
                jPanel2.add(this.editAreaGeoButton);
                jPanel = new JPanel(new GridLayout(2, 1));
                jPanel.add(new JLabel("Geography"));
                jPanel.add(jPanel2);
                jComponent = Box.createVerticalBox();
                jComponent.add(jPanel4);
                jComponent.add(jPanel3);
                jComponent.add(jPanel);
                jPanel5 = new JPanel();
                jPanel5.setBorder(BorderFactory.createTitledBorder("Service Area"));
                jPanel5.add(jComponent);
            }
            jPanel4 = null;
            if (SourceEditor.this.isTV && ((SourceEditor)SourceEditor.this).service.isDTS && this.sourceTV.siteNumber > 0) {
                this.timeDelayField = new JTextField(7);
                AppController.fixKeyBindings(this.timeDelayField);
                this.timeDelayField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourceEditor.this.canEdit) {
                                String string = "Edit Time Delay";
                                String string2 = SourcePanel.this.timeDelayField.getText().trim();
                                if (string2.length() > 0) {
                                    double d = ((SourcePanel)SourcePanel.this).sourceTV.dtsTimeDelay;
                                    try {
                                        d = Double.parseDouble(string2);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        SourceEditor.this.errorReporter.reportValidationError(string, "The time delay must be a number");
                                    }
                                    if (d != ((SourcePanel)SourcePanel.this).sourceTV.dtsTimeDelay) {
                                        if (d < -500.0 || d > 500.0) {
                                            SourceEditor.this.errorReporter.reportValidationError(string, "The time delay must be in the range -500.0 to 500.0");
                                        } else {
                                            ((SourcePanel)SourcePanel.this).sourceTV.dtsTimeDelay = d;
                                        }
                                    }
                                }
                            }
                            SourcePanel.this.timeDelayField.setText(AppCore.formatDecimal((double)((SourcePanel)SourcePanel.this).sourceTV.dtsTimeDelay, (int)2));
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.timeDelayField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        SourceEditor.this.setCurrentField(SourcePanel.this.timeDelayField);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            SourcePanel.this.timeDelayField.postActionEvent();
                        }
                    }
                });
                jPanel4 = new JPanel();
                jPanel4.setBorder(BorderFactory.createTitledBorder("Time delay, \u00b5S"));
                jPanel4.add(this.timeDelayField);
            }
            jPanel3 = null;
            if (SourceEditor.this.isTV && !((SourceEditor)SourceEditor.this).service.isDTS) {
                this.baselineCheckBox = new JCheckBox("Baseline record");
                this.baselineCheckBox.setFocusable(false);
                this.baselineCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SourceEditor.this.blockActions()) {
                            if (SourceEditor.this.canEdit) {
                                if (SourcePanel.this.baselineCheckBox.isSelected()) {
                                    SourcePanel.this.source.setAttribute("isBaseline");
                                } else {
                                    SourcePanel.this.source.removeAttribute("isBaseline");
                                }
                            }
                            SourceEditor.this.blockActionsEnd();
                        }
                    }
                });
                jPanel3 = new JPanel();
                jPanel3.add(this.baselineCheckBox);
            }
            jPanel2 = new JPanel();
            jPanel2.add((Component)serializable);
            if (null != jPanel9) {
                jPanel2.add(jPanel9);
            }
            jPanel2.add(this.recordIDPanel);
            jPanel2.add(jPanel14);
            jPanel = new JPanel();
            jPanel.add(jPanel11);
            if (null != jPanel12) {
                jPanel.add(jPanel12);
            }
            if (null != jPanel13) {
                jPanel.add(jPanel13);
            }
            if (null != jPanel16) {
                jPanel.add(jPanel16);
            }
            jPanel.add((Component)object);
            jPanel.add(jPanel8);
            jComponent = new JPanel();
            if (null != jPanel10) {
                jComponent.add(jPanel10);
            }
            jComponent.add(jPanel17);
            if (null != jPanel15) {
                jComponent.add(jPanel15);
            }
            if (null != jPanel18) {
                jComponent.add(jPanel18);
            }
            if (null != jPanel19) {
                jComponent.add(jPanel19);
            }
            if (null != jPanel20) {
                jComponent.add(jPanel20);
            }
            if (null != jPanel4) {
                jComponent.add(jPanel4);
            }
            JPanel jPanel33 = new JPanel();
            jPanel33.add(this.latitudePanel);
            jPanel33.add(this.longitudePanel);
            jPanel33.add(this.copyPastePanel);
            if (null != jPanel32) {
                jPanel33.add(jPanel32);
            }
            JPanel jPanel34 = new JPanel();
            jPanel34.add(jPanel21);
            jPanel34.add(jPanel23);
            jPanel34.add(jPanel24);
            jPanel34.add(jPanel26);
            if (null != jPanel3) {
                jPanel34.add(jPanel3);
            }
            JPanel jPanel35 = new JPanel();
            if (null != jPanel5) {
                jPanel35.add(jPanel5);
            }
            jPanel35.add(jPanel31);
            Box box2 = Box.createVerticalBox();
            box2.add(jPanel2);
            box2.add(jPanel);
            box2.add(jComponent);
            box2.add(jPanel33);
            box2.add(jPanel34);
            box2.add(jPanel35);
            this.add(box2);
            this.updateFields();
            SourceEditor.this.blockActionsEnd();
        }

        private void updateGeographies(int n) {
            if ((SourceEditor.this.isTV || SourceEditor.this.isFM) && SourceEditor.this.showServiceArea) {
                SourceEditor.this.blockActionsStart();
                this.serviceAreaGeographyMenu.removeAllItems();
                this.serviceAreaGeographyMenu.addAllItems(SourceEditor.this.serviceAreaGeographyList);
                if (0 == n || !this.geographyEditPending || !this.canEditServiceArea) {
                    n = SourceEditor.this.isTV ? this.sourceTV.serviceAreaKey : this.sourceFM.serviceAreaKey;
                }
                if (this.serviceAreaGeographyMenu.containsKey(n) || !this.canEditServiceArea) {
                    this.serviceAreaGeographyMenu.setSelectedKey(n);
                } else {
                    n = this.serviceAreaGeographyMenu.getSelectedKey();
                }
                if (SourceEditor.this.isTV) {
                    this.sourceTV.serviceAreaKey = n;
                } else {
                    this.sourceFM.serviceAreaKey = n;
                }
                SourceEditor.this.blockActionsEnd();
            }
        }

        private void updateFields() {
            String string;
            SourceEditor.this.blockActionsStart();
            Source source = this.source.getSource();
            this.canEditFacServCntry = SourceEditor.this.isNewSource;
            this.canEditCallCityState = SourceEditor.this.canEdit;
            this.canEditChan = SourceEditor.this.canEdit;
            this.canEditZoneStatFileOfsMask = SourceEditor.this.canEdit;
            this.canEditCoords = SourceEditor.this.canEdit;
            this.canEditSite = SourceEditor.this.canEdit;
            this.canEditServiceArea = SourceEditor.this.canEdit;
            this.isDTSAuthorized = false;
            if (SourceEditor.this.isTV && null != this.sourceTV.parentSourceKey) {
                this.canEditFacServCntry = false;
                this.canEditCallCityState = false;
                if (this.sourceTV.siteNumber > 0) {
                    this.canEditChan = false;
                    this.canEditZoneStatFileOfsMask = false;
                } else {
                    this.canEditSite = false;
                    this.canEditServiceArea = false;
                    this.isDTSAuthorized = true;
                }
            }
            if (SourceEditor.this.isPermanentInScenario && null != this.source.study && (3 == this.source.study.study.studyType || 5 == this.source.study.study.studyType)) {
                this.canEditChan = false;
                this.canEditCoords = false;
            }
            if (SourceEditor.this.isTV || SourceEditor.this.isFM) {
                if (this.canEditFacServCntry) {
                    this.facilityIDField.setVisible(true);
                    this.facilityIDField.setText(String.valueOf(SourceEditor.this.facilityID));
                    this.facilityIDLabel.setVisible(false);
                    this.facilityIDLabel.setText(" ");
                } else {
                    this.facilityIDLabel.setVisible(true);
                    this.facilityIDLabel.setText(String.valueOf(SourceEditor.this.facilityID));
                    this.facilityIDField.setVisible(false);
                    this.facilityIDField.setText("");
                }
            }
            if (SourceEditor.this.isFM) {
                if (this.canEditFacServCntry) {
                    this.stationClassMenu.setVisible(true);
                    this.stationClassMenu.setSelectedKey(SourceEditor.this.stationClass);
                    this.stationClassLabel.setVisible(false);
                    this.stationClassLabel.setText(" ");
                } else {
                    this.stationClassLabel.setVisible(true);
                    this.stationClassLabel.setText(ExtDbRecordFM.FM_CLASS_CODES[SourceEditor.this.stationClass]);
                    this.stationClassMenu.setVisible(false);
                }
            }
            if (this.source.hasRecordID()) {
                this.stationDataLabel.setText(this.source.getStationData());
                this.recordIDLabel.setText(this.source.getRecordID());
                this.recordIDPanel.setVisible(true);
            } else {
                this.stationDataLabel.setText(" ");
                this.recordIDLabel.setText(" ");
                this.recordIDPanel.setVisible(false);
            }
            if (this.canEditFacServCntry) {
                this.serviceMenu.setVisible(true);
                this.serviceMenu.setSelectedItem((KeyedRecord)SourceEditor.this.service);
                this.serviceLabel.setVisible(false);
                this.serviceLabel.setText(" ");
            } else {
                this.serviceLabel.setVisible(true);
                if (SourceEditor.this.isTV) {
                    if (this.sourceTV.isDRT) {
                        this.serviceLabel.setText("Digital Replacement Translator");
                    } else if (this.isDTSAuthorized) {
                        this.serviceLabel.setText(this.source.service.name);
                    } else {
                        this.serviceLabel.setText(((SourceEditor)SourceEditor.this).service.name);
                    }
                } else {
                    this.serviceLabel.setText(((SourceEditor)SourceEditor.this).service.name);
                }
                this.serviceMenu.setVisible(false);
            }
            this.callSignField.setText(this.source.callSign);
            AppController.setComponentEnabled(this.callSignField, this.canEditCallCityState);
            if (SourceEditor.this.isWL) {
                this.sectorIDField.setText(this.sourceWL.sectorID);
                AppController.setComponentEnabled(this.sectorIDField, this.canEditCallCityState);
            }
            if (SourceEditor.this.isTV) {
                SourceEditDataTV sourceEditDataTV;
                this.channelField.setText(String.valueOf(this.sourceTV.channel));
                AppController.setComponentEnabled(this.channelField, this.canEditChan);
                string = " ";
                if (null != SourceEditor.this.channelNote) {
                    if (!this.isDTSAuthorized) {
                        string = SourceEditor.this.channelNote;
                    }
                } else if (null != ((SourceEditor)SourceEditor.this).mainSourceTV.originalSourceKey && null != ((SourceEditor)SourceEditor.this).mainSource.study && null != (sourceEditDataTV = (SourceEditDataTV)((SourceEditor)SourceEditor.this).mainSource.study.getSource(((SourceEditor)SourceEditor.this).mainSourceTV.originalSourceKey))) {
                    string = "replicated from " + (sourceEditDataTV.service.serviceType.digital ? "D" : "N") + sourceEditDataTV.channel;
                }
                this.replicationLabel.setText(string);
            }
            if (SourceEditor.this.isFM) {
                this.channelField.setText(String.valueOf(this.sourceFM.channel));
                AppController.setComponentEnabled(this.channelField, this.canEditChan);
                this.replicationLabel.setText("");
            }
            this.updateFrequency();
            this.cityField.setText(this.source.city);
            AppController.setComponentEnabled(this.cityField, this.canEditCallCityState);
            this.stateField.setText(this.source.state);
            AppController.setComponentEnabled(this.stateField, this.canEditCallCityState);
            if (this.canEditFacServCntry) {
                this.countryMenu.setVisible(true);
                this.countryMenu.setSelectedItem((KeyedRecord)SourceEditor.this.country);
                this.countryLabel.setVisible(false);
                this.countryLabel.setText(" ");
            } else {
                this.countryLabel.setVisible(true);
                this.countryLabel.setText(((SourceEditor)SourceEditor.this).country.name);
                this.countryMenu.setVisible(false);
            }
            if (SourceEditor.this.isTV) {
                this.zoneMenu.setSelectedItem((KeyedRecord)this.sourceTV.zone);
                AppController.setComponentEnabled(this.zoneMenu, this.canEditZoneStatFileOfsMask);
                this.statusItem = new KeyedRecord(ExtDbRecord.getStatusType((String)this.sourceTV.status), this.sourceTV.status);
                this.statusMenu.setSelectedItem(this.statusItem);
                AppController.setComponentEnabled(this.statusMenu, this.canEditZoneStatFileOfsMask);
                this.siteNumberField.setText(String.valueOf(this.sourceTV.siteNumber));
                AppController.setComponentEnabled(this.siteNumberField, this.canEditSite);
                if (null != this.signalTypeMenu) {
                    this.signalTypeMenu.setSelectedItem((KeyedRecord)this.sourceTV.signalType);
                    AppController.setComponentEnabled(this.signalTypeMenu, SourceEditor.this.canEdit && ((SourceEditor)SourceEditor.this).service.serviceType.digital);
                }
                if (null != this.frequencyOffsetMenu) {
                    this.frequencyOffsetMenu.setSelectedItem((KeyedRecord)this.sourceTV.frequencyOffset);
                    AppController.setComponentEnabled(this.frequencyOffsetMenu, this.canEditZoneStatFileOfsMask);
                }
                if (null != this.emissionMaskMenu) {
                    this.emissionMaskMenu.setSelectedItem((KeyedRecord)this.sourceTV.emissionMask);
                    AppController.setComponentEnabled(this.emissionMaskMenu, this.canEditZoneStatFileOfsMask && (this.isDTSAuthorized && this.source.service.serviceType.needsEmissionMask || !this.isDTSAuthorized && ((SourceEditor)SourceEditor.this).service.serviceType.needsEmissionMask));
                }
            }
            if (SourceEditor.this.isFM) {
                this.statusItem = new KeyedRecord(ExtDbRecord.getStatusType((String)this.sourceFM.status), this.sourceFM.status);
                this.statusMenu.setSelectedItem(this.statusItem);
                AppController.setComponentEnabled(this.statusMenu, this.canEditZoneStatFileOfsMask);
            }
            this.fileNumberField.setText(this.source.fileNumber);
            AppController.setComponentEnabled(this.fileNumberField, this.canEditZoneStatFileOfsMask);
            this.editPoint.setLatLon(this.source.location);
            this.latitudePanel.updatePanel();
            this.longitudePanel.updatePanel();
            this.latitudePanel.setEnabled(this.canEditCoords);
            this.longitudePanel.setEnabled(this.canEditCoords);
            this.copyPastePanel.setEnabled(this.canEditCoords);
            if (-999.0 == this.source.heightAMSL) {
                this.heightAMSLField.setText("(derive)");
            } else {
                this.heightAMSLField.setText(AppCore.formatHeight((double)this.source.heightAMSL));
            }
            AppController.setComponentEnabled(this.heightAMSLField, SourceEditor.this.canEdit);
            if (null != source && source.actualHeightAMSL != this.source.heightAMSL && -999.0 != source.actualHeightAMSL) {
                this.actualHeightAMSLLabel.setText("Last run: " + AppCore.formatHeight((double)source.actualHeightAMSL));
            } else {
                this.actualHeightAMSLLabel.setText(" ");
            }
            if (-999.0 == this.source.overallHAAT) {
                this.overallHAATField.setText("(derive)");
            } else {
                this.overallHAATField.setText(AppCore.formatHeight((double)this.source.overallHAAT));
            }
            AppController.setComponentEnabled(this.overallHAATField, SourceEditor.this.canEdit);
            if (null != source && source.actualOverallHAAT != this.source.overallHAAT && -999.0 != source.actualOverallHAAT) {
                this.actualOverallHAATLabel.setText("Last run: " + AppCore.formatHeight((double)source.actualOverallHAAT));
            } else {
                this.actualOverallHAATLabel.setText(" ");
            }
            this.peakERPField.setText(AppCore.formatERP((double)this.source.peakERP));
            AppController.setComponentEnabled(this.peakERPField, SourceEditor.this.canEdit);
            if (SourceEditor.this.isFM) {
                this.ibocCheckBox.setSelected(this.sourceFM.isIBOC);
                AppController.setComponentEnabled(this.ibocCheckBox, SourceEditor.this.canEdit);
                if (this.sourceFM.isIBOC) {
                    this.ibocERPField.setText(AppCore.formatERP((double)(this.sourceFM.peakERP * this.sourceFM.ibocFraction)));
                } else {
                    this.ibocERPField.setText("");
                }
                AppController.setComponentEnabled(this.ibocERPField, SourceEditor.this.canEdit);
            }
            if (this.source.hasHorizontalPattern) {
                string = "(unknown)";
                if (null != this.source.horizontalPattern) {
                    string = this.source.horizontalPattern.name;
                } else if (null != source) {
                    string = source.horizontalPatternName;
                }
                this.horizontalPatternLabel.setText(string);
                this.horizontalPatternLabel.setToolTipText(string);
            } else {
                this.horizontalPatternLabel.setText("(none)");
                this.horizontalPatternLabel.setToolTipText(null);
            }
            if (SourceEditor.this.canEdit) {
                this.editHorizontalPatternButton.setText("Edit");
                this.editHorizontalPatternButton.setEnabled(true);
            } else {
                this.editHorizontalPatternButton.setText("View");
                this.editHorizontalPatternButton.setEnabled(this.source.hasHorizontalPattern);
            }
            this.horizontalPatternOrientationField.setText(AppCore.formatAzimuth((double)this.source.horizontalPatternOrientation));
            AppController.setComponentEnabled(this.horizontalPatternOrientationField, SourceEditor.this.canEdit);
            if (this.source.hasMatrixPattern) {
                string = "(unknown matrix)";
                if (null != this.source.matrixPattern) {
                    string = this.source.matrixPattern.name + " (matrix)";
                } else if (null != source) {
                    string = source.matrixPatternName + " (matrix)";
                }
                this.verticalPatternLabel.setText(string);
                this.verticalPatternLabel.setToolTipText(string);
                if (SourceEditor.this.canEdit) {
                    this.editVerticalPatternButton.setText("Edit");
                } else {
                    this.editVerticalPatternButton.setText("View");
                }
                this.editVerticalPatternButton.setEnabled(true);
            } else {
                if (this.source.hasVerticalPattern) {
                    string = "(unknown)";
                    if (null != this.source.verticalPattern) {
                        string = this.source.verticalPattern.name;
                    } else if (null != source) {
                        string = source.verticalPatternName;
                    }
                    this.verticalPatternLabel.setText(string);
                    this.verticalPatternLabel.setToolTipText(string);
                } else {
                    this.verticalPatternLabel.setText("(none)");
                    this.verticalPatternLabel.setToolTipText(null);
                }
                if (SourceEditor.this.canEdit) {
                    this.editVerticalPatternButton.setText("Edit");
                    this.editVerticalPatternButton.setEnabled(true);
                } else {
                    this.editVerticalPatternButton.setText("View");
                    this.editVerticalPatternButton.setEnabled(this.source.hasVerticalPattern);
                }
            }
            this.verticalPatternElectricalTiltField.setText(AppCore.formatDepression((double)this.source.verticalPatternElectricalTilt));
            this.verticalPatternMechanicalTiltField.setText(AppCore.formatDepression((double)this.source.verticalPatternMechanicalTilt));
            this.verticalPatternMechanicalTiltOrientationField.setText(AppCore.formatAzimuth((double)this.source.verticalPatternMechanicalTiltOrientation));
            AppController.setComponentEnabled(this.verticalPatternElectricalTiltField, SourceEditor.this.canEdit);
            AppController.setComponentEnabled(this.verticalPatternMechanicalTiltField, SourceEditor.this.canEdit);
            AppController.setComponentEnabled(this.verticalPatternMechanicalTiltOrientationField, SourceEditor.this.canEdit);
            this.useGenericVerticalPatternCheckBox.setSelected(this.source.useGenericVerticalPattern);
            AppController.setComponentEnabled(this.useGenericVerticalPatternCheckBox, SourceEditor.this.canEdit);
            if ((SourceEditor.this.isTV || SourceEditor.this.isFM) && SourceEditor.this.showServiceArea) {
                int n;
                double d;
                double d2;
                int n2;
                if (SourceEditor.this.isTV) {
                    n2 = this.sourceTV.serviceAreaMode;
                    d2 = this.sourceTV.serviceAreaArg;
                    d = this.sourceTV.serviceAreaCL;
                    n = this.sourceTV.serviceAreaKey;
                } else {
                    n2 = this.sourceFM.serviceAreaMode;
                    d2 = this.sourceFM.serviceAreaArg;
                    d = this.sourceFM.serviceAreaCL;
                    n = this.sourceFM.serviceAreaKey;
                }
                this.serviceAreaModeMenu.setSelectedKey(n2);
                this.serviceAreaArgumentField.setText(AppCore.formatDecimal((double)d2, (int)2));
                if (-999.0 == d) {
                    this.serviceAreaContourLevelField.setText("(default)");
                } else {
                    this.serviceAreaContourLevelField.setText(AppCore.formatDecimal((double)d, (int)1));
                }
                this.serviceAreaGeographyMenu.setSelectedKey(n);
                if (this.canEditServiceArea) {
                    AppController.setComponentEnabled(this.serviceAreaModeMenu, true);
                    switch (n2) {
                        case 0: 
                        case 7: {
                            AppController.setComponentEnabled(this.serviceAreaArgumentField, false);
                            AppController.setComponentEnabled(this.serviceAreaContourLevelField, false);
                            AppController.setComponentEnabled(this.serviceAreaGeographyMenu, false);
                            this.editAreaGeoButton.setEnabled(false);
                            break;
                        }
                        case 1: 
                        case 11: {
                            AppController.setComponentEnabled(this.serviceAreaArgumentField, false);
                            AppController.setComponentEnabled(this.serviceAreaContourLevelField, true);
                            AppController.setComponentEnabled(this.serviceAreaGeographyMenu, false);
                            this.editAreaGeoButton.setEnabled(false);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 8: 
                        case 9: {
                            AppController.setComponentEnabled(this.serviceAreaArgumentField, true);
                            AppController.setComponentEnabled(this.serviceAreaContourLevelField, true);
                            AppController.setComponentEnabled(this.serviceAreaGeographyMenu, false);
                            this.editAreaGeoButton.setEnabled(false);
                            break;
                        }
                        case 5: 
                        case 6: {
                            AppController.setComponentEnabled(this.serviceAreaArgumentField, false);
                            AppController.setComponentEnabled(this.serviceAreaContourLevelField, false);
                            AppController.setComponentEnabled(this.serviceAreaGeographyMenu, true);
                            this.editAreaGeoButton.setEnabled(true);
                            break;
                        }
                        case 10: {
                            AppController.setComponentEnabled(this.serviceAreaArgumentField, true);
                            AppController.setComponentEnabled(this.serviceAreaContourLevelField, false);
                            AppController.setComponentEnabled(this.serviceAreaGeographyMenu, false);
                            this.editAreaGeoButton.setEnabled(false);
                        }
                    }
                } else {
                    AppController.setComponentEnabled(this.serviceAreaModeMenu, false);
                    AppController.setComponentEnabled(this.serviceAreaArgumentField, false);
                    AppController.setComponentEnabled(this.serviceAreaContourLevelField, false);
                    AppController.setComponentEnabled(this.serviceAreaGeographyMenu, false);
                    this.editAreaGeoButton.setEnabled(false);
                }
            }
            if (null != this.timeDelayField) {
                this.timeDelayField.setText(AppCore.formatDecimal((double)this.sourceTV.dtsTimeDelay, (int)2));
                AppController.setComponentEnabled(this.timeDelayField, SourceEditor.this.canEdit);
            }
            if (null != this.baselineCheckBox) {
                this.baselineCheckBox.setSelected(null != this.source.getAttribute("isBaseline"));
                AppController.setComponentEnabled(this.baselineCheckBox, SourceEditor.this.canEdit);
            }
            SourceEditor.this.blockActionsEnd();
            this.updatePatternButtons();
        }

        private void updateFrequency() {
            if (SourceEditor.this.isTV) {
                String string = this.source.getAttribute("frequency");
                if (null != this.frequencyLabel) {
                    this.frequencyLabel.setText(SourceEditDataTV.getFrequency((int)this.sourceTV.channel, (Service)SourceEditor.this.service, (String)string));
                }
                if (null != this.frequencyField) {
                    this.frequencyField.setText(AppCore.formatDecimal((double)SourceEditDataTV.getFrequencyValue((int)this.sourceTV.channel, (Service)SourceEditor.this.service, (String)string), (int)2));
                    AppController.setComponentEnabled(this.frequencyField, this.canEditChan && null != string);
                }
                if (null != this.editFrequencyCheckBox) {
                    this.editFrequencyCheckBox.setSelected(string != null);
                    AppController.setComponentEnabled(this.editFrequencyCheckBox, this.canEditChan);
                }
            } else if (SourceEditor.this.isFM) {
                this.frequencyLabel.setText(this.source.getFrequency());
            }
        }

        private void updatePatternButtons() {
            this.editHorizontalPatternButton.setEnabled(this.source.hasHorizontalPattern);
            if (null != this.changeHorizontalPatternMenu) {
                this.changeHorizontalPatternMenu.setEnabled(null == this.horizontalPatternEditor);
            }
            this.exportHorizontalPatternButton.setEnabled(this.source.hasHorizontalPattern && (!SourceEditor.this.canEdit || null == this.horizontalPatternEditor));
            this.editVerticalPatternButton.setEnabled(this.source.hasVerticalPattern || this.source.hasMatrixPattern);
            if (null != this.changeVerticalPatternMenu) {
                this.changeVerticalPatternMenu.setEnabled(null == this.verticalPatternEditor);
            }
            this.exportVerticalPatternButton.setEnabled(!(!this.source.hasVerticalPattern && !this.source.hasMatrixPattern || SourceEditor.this.canEdit && null != this.verticalPatternEditor));
        }

        private void doEditHorizontalPattern() {
            if (null != this.horizontalPatternEditor) {
                this.horizontalPatternEditor.toFront();
                return;
            }
            String string = (SourceEditor.this.canEdit ? "Edit" : "View") + " Azimuth Pattern";
            SourceEditor.this.errorReporter.setTitle(string);
            AntPattern antPattern = this.source.getHorizontalPattern((ErrorLogger)SourceEditor.this.errorReporter);
            if (null == antPattern) {
                return;
            }
            this.horizontalPatternEditor = new PatternEditor((AppEditor)SourceEditor.this.outerThis, antPattern, SourceEditor.this.canEdit, string);
            this.horizontalPatternEditor.antennaOrientation = this.source.horizontalPatternOrientation;
            AppController.showWindow(this.horizontalPatternEditor);
            SourceEditor.this.patternEditorIndex.put(this.horizontalPatternEditor, this);
            this.updatePatternButtons();
        }

        private void doChangeHorizontalPattern(int n) {
            if (!SourceEditor.this.canEdit) {
                return;
            }
            if (null != this.horizontalPatternEditor) {
                AppController.beep();
                this.horizontalPatternEditor.toFront();
                return;
            }
            AntPattern antPattern = null;
            switch (n) {
                case 1: {
                    antPattern = this.importPattern(false);
                    break;
                }
                case 2: {
                    antPattern = this.findPattern(false);
                    break;
                }
                case 3: {
                    antPattern = new AntPattern(SourceEditor.this.getDbID(), 1, "(new)");
                    this.horizontalPatternEditor = new PatternEditor((AppEditor)SourceEditor.this.outerThis, antPattern, SourceEditor.this.canEdit, "Edit Azimuth Pattern");
                    this.horizontalPatternEditor.antennaOrientation = this.source.horizontalPatternOrientation;
                    AppController.showWindow(this.horizontalPatternEditor);
                    SourceEditor.this.patternEditorIndex.put(this.horizontalPatternEditor, this);
                    this.updatePatternButtons();
                    return;
                }
                case 4: {
                    if (!this.source.hasHorizontalPattern) break;
                    this.source.hasHorizontalPattern = false;
                    this.source.horizontalPattern = null;
                    this.source.horizontalPatternChanged = true;
                    this.horizontalPatternLabel.setText("(none)");
                    this.horizontalPatternLabel.setToolTipText(null);
                }
            }
            if (null != antPattern) {
                this.source.hasHorizontalPattern = true;
                this.source.horizontalPattern = antPattern;
                this.source.horizontalPatternChanged = true;
                this.horizontalPatternLabel.setText(antPattern.name);
                this.horizontalPatternLabel.setToolTipText(antPattern.name);
            }
            this.updatePatternButtons();
        }

        private void doExportHorizontalPattern() {
            if (SourceEditor.this.canEdit && null != this.horizontalPatternEditor) {
                return;
            }
            String string = "Export Azimuth Pattern";
            SourceEditor.this.errorReporter.setTitle(string);
            AntPattern antPattern = this.source.getHorizontalPattern((ErrorLogger)SourceEditor.this.errorReporter);
            if (null == antPattern) {
                return;
            }
            JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
            jFileChooser.setDialogType(1);
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("CSV (*.csv)", "csv"));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            File file = null;
            do {
                if (0 != jFileChooser.showDialog(this, "Export")) {
                    return;
                }
                file = jFileChooser.getSelectedFile();
                String string2 = file.getName().toLowerCase();
                if (!string2.endsWith(".csv")) {
                    file = new File(file.getAbsolutePath() + ".csv");
                }
                if (!file.exists()) continue;
                AppController.beep();
                if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
                file = null;
            } while (null == file);
            AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
            antPattern.export(file, (ErrorLogger)SourceEditor.this.errorReporter);
        }

        private void doEditVerticalPattern() {
            if (null != this.verticalPatternEditor) {
                this.verticalPatternEditor.toFront();
                return;
            }
            String string = (SourceEditor.this.canEdit ? "Edit" : "View") + " Elevation Pattern";
            SourceEditor.this.errorReporter.setTitle(string);
            AntPattern antPattern = this.source.getVerticalPattern((ErrorLogger)SourceEditor.this.errorReporter);
            if (null == antPattern) {
                return;
            }
            this.verticalPatternEditor = new PatternEditor((AppEditor)SourceEditor.this.outerThis, antPattern, SourceEditor.this.canEdit, string);
            AppController.showWindow(this.verticalPatternEditor);
            SourceEditor.this.patternEditorIndex.put(this.verticalPatternEditor, this);
            this.updatePatternButtons();
        }

        private void doChangeVerticalPattern(int n) {
            if (!SourceEditor.this.canEdit) {
                return;
            }
            if (null != this.verticalPatternEditor) {
                AppController.beep();
                this.verticalPatternEditor.toFront();
                return;
            }
            AntPattern antPattern = null;
            switch (n) {
                case 1: {
                    antPattern = this.importPattern(true);
                    break;
                }
                case 2: {
                    antPattern = this.findPattern(true);
                    break;
                }
                case 3: {
                    antPattern = new AntPattern(SourceEditor.this.getDbID(), 2, "(new)");
                    this.verticalPatternEditor = new PatternEditor((AppEditor)SourceEditor.this.outerThis, antPattern, SourceEditor.this.canEdit, "Edit Elevation Pattern");
                    AppController.showWindow(this.verticalPatternEditor);
                    SourceEditor.this.patternEditorIndex.put(this.verticalPatternEditor, this);
                    this.updatePatternButtons();
                    return;
                }
                case 4: {
                    if (this.source.hasVerticalPattern) {
                        this.source.hasVerticalPattern = false;
                        this.source.verticalPattern = null;
                        this.source.verticalPatternChanged = true;
                    }
                    if (this.source.hasMatrixPattern) {
                        this.source.hasMatrixPattern = false;
                        this.source.matrixPattern = null;
                        this.source.matrixPatternChanged = true;
                    }
                    this.verticalPatternLabel.setText("(none)");
                    this.verticalPatternLabel.setToolTipText(null);
                }
            }
            if (null != antPattern) {
                if (antPattern.isSimple()) {
                    if (this.source.hasMatrixPattern) {
                        this.source.hasMatrixPattern = false;
                        this.source.matrixPattern = null;
                        this.source.matrixPatternChanged = true;
                    }
                    this.source.hasVerticalPattern = true;
                    this.source.verticalPattern = antPattern;
                    this.source.verticalPatternChanged = true;
                    this.verticalPatternLabel.setText(antPattern.name);
                    this.verticalPatternLabel.setToolTipText(antPattern.name);
                } else {
                    AntPattern antPattern2 = antPattern.normalizeVerticalMatrix();
                    String string = SourceEditor.this.errorReporter.getTitle();
                    boolean bl = false;
                    boolean bl2 = false;
                    if (null != antPattern2) {
                        if (this.source.hasHorizontalPattern) {
                            AppController.beep();
                            if (0 != JOptionPane.showConfirmDialog(SourceEditor.this.outerThis, "The matrix pattern needs to be normalized; this will also replace\nthe azimuth pattern on this record.  Do you want to continue?", string, 0, 2)) {
                                return;
                            }
                        }
                        bl = true;
                    } else if (this.source.hasHorizontalPattern) {
                        String string2 = "Do you want to import a new azimuth pattern, set the azimuth\npattern to omni, or keep the existing azimuth pattern?";
                        Object[] objectArray = new String[]{"Import", "Omni", "Keep", "Cancel"};
                        switch (JOptionPane.showOptionDialog(SourceEditor.this.outerThis, string2, string, -1, 1, null, objectArray, objectArray[0])) {
                            case 0: {
                                bl = true;
                                bl2 = true;
                                break;
                            }
                            case 1: {
                                bl = true;
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                return;
                            }
                        }
                    } else {
                        String string3 = "Do you want to import an azimuth pattern?";
                        Object[] objectArray = new String[]{"Yes", "No", "Cancel"};
                        switch (JOptionPane.showOptionDialog(SourceEditor.this.outerThis, string3, string, -1, 1, null, objectArray, objectArray[0])) {
                            case 0: {
                                bl = true;
                                bl2 = true;
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                return;
                            }
                        }
                    }
                    if (bl && null != this.horizontalPatternEditor && !this.horizontalPatternEditor.cancel()) {
                        AppController.beep();
                        this.horizontalPatternEditor.toFront();
                        return;
                    }
                    if (bl2 && null == (antPattern2 = this.importPattern(false))) {
                        return;
                    }
                    if (this.source.hasVerticalPattern) {
                        this.source.hasVerticalPattern = false;
                        this.source.verticalPattern = null;
                        this.source.verticalPatternChanged = true;
                    }
                    this.source.hasMatrixPattern = true;
                    this.source.matrixPattern = antPattern;
                    this.source.matrixPatternChanged = true;
                    this.verticalPatternLabel.setText(antPattern.name + " (matrix)");
                    this.verticalPatternLabel.setToolTipText(antPattern.name + " (matrix)");
                    if (bl) {
                        if (null == antPattern2) {
                            this.source.hasHorizontalPattern = false;
                            this.source.horizontalPattern = null;
                            this.source.horizontalPatternChanged = true;
                            this.horizontalPatternLabel.setText("(none)");
                            this.horizontalPatternLabel.setToolTipText(null);
                        } else {
                            this.source.hasHorizontalPattern = true;
                            this.source.horizontalPattern = antPattern2;
                            this.source.horizontalPatternChanged = true;
                            this.horizontalPatternLabel.setText(antPattern2.name);
                            this.horizontalPatternLabel.setToolTipText(antPattern2.name);
                        }
                    }
                }
            }
            this.updatePatternButtons();
        }

        private void doExportVerticalPattern() {
            if (SourceEditor.this.canEdit && null != this.verticalPatternEditor) {
                return;
            }
            String string = "Export Elevation Pattern";
            SourceEditor.this.errorReporter.setTitle(string);
            AntPattern antPattern = this.source.getVerticalPattern((ErrorLogger)SourceEditor.this.errorReporter);
            if (null == antPattern) {
                return;
            }
            JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
            jFileChooser.setDialogType(1);
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("CSV (*.csv)", "csv"));
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML (*.xml)", "xml"));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            File file = null;
            boolean bl = false;
            do {
                if (0 != jFileChooser.showDialog(this, "Export")) {
                    return;
                }
                file = jFileChooser.getSelectedFile();
                String string2 = file.getName().toLowerCase();
                FileFilter fileFilter = jFileChooser.getFileFilter();
                if (fileFilter instanceof FileNameExtensionFilter && ((FileNameExtensionFilter)fileFilter).getExtensions()[0].equals("xml")) {
                    bl = true;
                    if (!string2.endsWith(".xml")) {
                        file = new File(file.getAbsolutePath() + ".xml");
                    }
                } else if (!string2.endsWith(".csv")) {
                    file = new File(file.getAbsolutePath() + ".csv");
                }
                if (!file.exists()) continue;
                AppController.beep();
                if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
                file = null;
            } while (null == file);
            AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
            antPattern.export(file, bl, (ErrorLogger)SourceEditor.this.errorReporter);
        }

        private AntPattern importPattern(boolean bl) {
            String string = bl ? "Import Elevation Pattern" : "Import Azimuth Pattern";
            SourceEditor.this.errorReporter.setTitle(string);
            JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Text (*.csv,*.txt,*.dat)", "csv", "txt", "dat"));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            if (0 != jFileChooser.showDialog(this, "Import")) {
                return null;
            }
            File file = jFileChooser.getSelectedFile();
            AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
            return AntPattern.readFromText((String)SourceEditor.this.getDbID(), (int)(bl ? 2 : 1), (File)file, (ErrorLogger)SourceEditor.this.errorReporter);
        }

        private AntPattern findPattern(boolean bl) {
            if (null != this.patternSearchDialog && this.patternSearchDialog.isVisible()) {
                return null;
            }
            String string = bl ? "Find Elevation Pattern" : "Find Azimuth Pattern";
            SourceEditor.this.errorReporter.setTitle(string);
            this.patternSearchDialog = new PatternEditor((AppEditor)SourceEditor.this.outerThis, bl, ((SourceEditor)SourceEditor.this).mainSource.recordType, string);
            AppController.showWindow(this.patternSearchDialog);
            AntPattern antPattern = this.patternSearchDialog.getPattern();
            this.patternSearchDialog = null;
            return antPattern;
        }

        private boolean applyEditsFrom(PatternEditor patternEditor) {
            AntPattern antPattern = patternEditor.getPattern();
            if (patternEditor == this.horizontalPatternEditor) {
                if (patternEditor.didEdit()) {
                    if (null != antPattern && !antPattern.isMatrix()) {
                        this.source.hasHorizontalPattern = true;
                        this.source.horizontalPattern = antPattern;
                        this.source.horizontalPatternChanged = true;
                        this.horizontalPatternLabel.setText(antPattern.name);
                        this.horizontalPatternLabel.setToolTipText(antPattern.name);
                    } else {
                        this.source.hasHorizontalPattern = false;
                        this.source.horizontalPattern = null;
                        this.source.horizontalPatternChanged = true;
                        this.horizontalPatternLabel.setText("(none)");
                        this.horizontalPatternLabel.setToolTipText(null);
                    }
                    this.source.horizontalPatternOrientation = patternEditor.antennaOrientation;
                    this.horizontalPatternOrientationField.setText(AppCore.formatAzimuth((double)patternEditor.antennaOrientation));
                    this.source.antennaID = null;
                }
                return true;
            }
            if (patternEditor == this.verticalPatternEditor) {
                if (patternEditor.didEdit()) {
                    if (null != antPattern) {
                        if (antPattern.isMatrix()) {
                            if (this.source.hasVerticalPattern) {
                                this.source.hasVerticalPattern = false;
                                this.source.verticalPattern = null;
                                this.source.verticalPatternChanged = true;
                            }
                            this.source.hasMatrixPattern = true;
                            this.source.matrixPattern = antPattern;
                            this.source.matrixPatternChanged = true;
                            this.verticalPatternLabel.setText(antPattern.name + " (matrix)");
                            this.verticalPatternLabel.setToolTipText(antPattern.name + " (matrix)");
                        } else {
                            if (this.source.hasMatrixPattern) {
                                this.source.hasMatrixPattern = false;
                                this.source.matrixPattern = null;
                                this.source.matrixPatternChanged = true;
                            }
                            this.source.hasVerticalPattern = true;
                            this.source.verticalPattern = antPattern;
                            this.source.verticalPatternChanged = true;
                            this.verticalPatternLabel.setText(antPattern.name);
                            this.verticalPatternLabel.setToolTipText(antPattern.name);
                        }
                    } else {
                        if (this.source.hasVerticalPattern) {
                            this.source.hasVerticalPattern = false;
                            this.source.verticalPattern = null;
                            this.source.verticalPatternChanged = true;
                        }
                        if (this.source.hasMatrixPattern) {
                            this.source.hasMatrixPattern = false;
                            this.source.matrixPattern = null;
                            this.source.matrixPatternChanged = true;
                        }
                        this.verticalPatternLabel.setText("(none)");
                        this.verticalPatternLabel.setToolTipText(null);
                    }
                }
                return true;
            }
            return false;
        }

        private void editorClosing(PatternEditor patternEditor) {
            if (patternEditor == this.horizontalPatternEditor) {
                SourceEditor.this.patternEditorIndex.remove(this.horizontalPatternEditor);
                this.horizontalPatternEditor = null;
                this.updatePatternButtons();
                return;
            }
            if (patternEditor == this.verticalPatternEditor) {
                SourceEditor.this.patternEditorIndex.remove(this.verticalPatternEditor);
                this.verticalPatternEditor = null;
                this.updatePatternButtons();
                return;
            }
        }
    }
}

