/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.AntPattern;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbListener;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.BackgroundWorker;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Path2D;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class PatternEditor
extends AppDialog
implements ExtDbListener {
    private AntPattern pattern;
    private int patternType;
    public double antennaOrientation;
    private JTextField patternNameField;
    private JTextField antennaOrientationField;
    private JCheckBox rotateHorizontalPlotCheckBox;
    private JTextField antennaGainField;
    private JComboBox<Double> sliceMenu;
    private JButton previousSliceButton;
    private JButton nextSliceButton;
    private boolean ignoreSliceChange;
    private Double currentSliceValue;
    private PatternTableModel patternModel;
    private PatternPlotPanel patternPlotPanel;
    private PatternSearchPanel patternSearchPanel;
    private boolean isSearch;
    private int recordType;
    private JButton changeSliceValueButton;
    private JButton removeSliceButton;
    private JButton insertPointButton;
    private JButton deletePointButton;
    private JButton applyButton;
    private boolean canEdit;
    private boolean didEdit;
    private PatternEditor outerThis = this;

    public PatternEditor(AppEditor appEditor, AntPattern antPattern, boolean bl, String string) {
        super(appEditor, string, Dialog.ModalityType.MODELESS);
        this.pattern = antPattern.copy();
        this.patternType = antPattern.type;
        this.canEdit = bl;
        this.doSetup();
    }

    public PatternEditor(AppEditor appEditor, boolean bl, int n, String string) {
        super(appEditor, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.patternType = bl ? 2 : 1;
        this.isSearch = true;
        this.recordType = n;
        this.doSetup();
    }

    private void doSetup() {
        Serializable serializable;
        JPanel jPanel;
        JComponent jComponent;
        JComponent jComponent2;
        Serializable serializable2;
        Serializable serializable3;
        this.patternNameField = new JTextField(30);
        AppController.fixKeyBindings(this.patternNameField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Name"));
        jPanel2.add(this.patternNameField);
        AppController.setComponentEnabled(this.patternNameField, this.canEdit);
        JPanel jPanel3 = null;
        if (1 == this.patternType && !this.isSearch) {
            this.antennaOrientationField = new JTextField(7);
            AppController.fixKeyBindings(this.antennaOrientationField);
            AppController.setComponentEnabled(this.antennaOrientationField, this.canEdit);
            if (this.canEdit) {
                this.antennaOrientationField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (PatternEditor.this.blockActions()) {
                            String string = "Edit Pattern Orientation";
                            String string2 = PatternEditor.this.antennaOrientationField.getText().trim();
                            if (string2.length() > 0) {
                                double d = PatternEditor.this.antennaOrientation;
                                try {
                                    d = Math.IEEEremainder(Double.parseDouble(string2), 360.0);
                                    if (d < 0.0) {
                                        d += 360.0;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    PatternEditor.this.errorReporter.reportValidationError(string, "The orientation must be a number");
                                }
                                if (d != PatternEditor.this.antennaOrientation) {
                                    PatternEditor.this.antennaOrientation = d;
                                    if (PatternEditor.this.rotateHorizontalPlotCheckBox.isSelected()) {
                                        PatternEditor.this.patternPlotPanel.repaint();
                                    }
                                }
                            }
                            PatternEditor.this.antennaOrientationField.setText(AppCore.formatAzimuth((double)PatternEditor.this.antennaOrientation));
                            PatternEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.antennaOrientationField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        PatternEditor.this.setCurrentField(PatternEditor.this.antennaOrientationField);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            PatternEditor.this.antennaOrientationField.postActionEvent();
                        }
                    }
                });
            }
            this.rotateHorizontalPlotCheckBox = new JCheckBox("Rotate pattern plot");
            this.rotateHorizontalPlotCheckBox.setFocusable(false);
            this.rotateHorizontalPlotCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PatternEditor.this.patternPlotPanel.repaint();
                }
            });
            jPanel3 = new JPanel(new FlowLayout(0));
            jPanel3.setBorder(BorderFactory.createTitledBorder("Orientation"));
            jPanel3.add(this.antennaOrientationField);
            jPanel3.add(this.rotateHorizontalPlotCheckBox);
        }
        JPanel jPanel4 = null;
        if (3 == this.patternType) {
            this.antennaGainField = new JTextField(7);
            AppController.fixKeyBindings(this.antennaGainField);
            AppController.setComponentEnabled(this.antennaGainField, this.canEdit);
            if (this.canEdit) {
                this.antennaGainField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (PatternEditor.this.blockActions()) {
                            String string = "Edit Antenna Gain";
                            String string2 = PatternEditor.this.antennaGainField.getText().trim();
                            if (string2.length() > 0) {
                                double d = ((PatternEditor)PatternEditor.this).pattern.gain;
                                try {
                                    d = Double.parseDouble(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    PatternEditor.this.errorReporter.reportValidationError(string, "The gain must be a number");
                                }
                                if (d != ((PatternEditor)PatternEditor.this).pattern.gain) {
                                    if (d < 0.0 || d > 60.0) {
                                        PatternEditor.this.errorReporter.reportValidationError(string, "The gain must be in the range 0.0 to 60.0");
                                    } else {
                                        ((PatternEditor)PatternEditor.this).pattern.gain = d;
                                        PatternEditor.this.didEdit = true;
                                    }
                                }
                            }
                            PatternEditor.this.antennaGainField.setText(AppCore.formatDecimal((double)((PatternEditor)PatternEditor.this).pattern.gain, (int)2));
                            PatternEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.antennaGainField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        PatternEditor.this.setCurrentField(PatternEditor.this.antennaGainField);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            PatternEditor.this.antennaGainField.postActionEvent();
                        }
                    }
                });
            }
            jPanel4 = new JPanel(new FlowLayout(0));
            jPanel4.setBorder(BorderFactory.createTitledBorder("Antenna Gain, dBd"));
            jPanel4.add(this.antennaGainField);
        }
        JPanel jPanel5 = null;
        if (1 != this.patternType && (null != this.pattern && this.pattern.isMatrix() || this.isSearch || this.canEdit)) {
            this.sliceMenu = new JComboBox();
            this.sliceMenu.setPrototypeDisplayValue(999.9);
            this.sliceMenu.setFocusable(false);
            this.sliceMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PatternEditor.this.doChangeSlice();
                }
            });
            serializable3 = new Dimension(20, 20);
            serializable2 = new Insets(0, 0, 0, 0);
            this.previousSliceButton = new JButton("<");
            this.previousSliceButton.setPreferredSize((Dimension)serializable3);
            this.previousSliceButton.setMargin((Insets)serializable2);
            this.previousSliceButton.setFocusable(false);
            this.previousSliceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PatternEditor.this.doPreviousSlice();
                }
            });
            this.nextSliceButton = new JButton(">");
            this.nextSliceButton.setPreferredSize((Dimension)serializable3);
            this.nextSliceButton.setMargin((Insets)serializable2);
            this.nextSliceButton.setFocusable(false);
            this.nextSliceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PatternEditor.this.doNextSlice();
                }
            });
            jPanel5 = new JPanel(new FlowLayout(0));
            if (2 != this.patternType) {
                jPanel5.setBorder(BorderFactory.createTitledBorder("Frequency, MHz"));
            } else {
                jPanel5.setBorder(BorderFactory.createTitledBorder("Azimuth"));
            }
            jPanel5.add(this.sliceMenu);
            jPanel5.add(this.previousSliceButton);
            jPanel5.add(this.nextSliceButton);
            if (this.canEdit) {
                this.changeSliceValueButton = new JButton("Edit");
                this.changeSliceValueButton.setFocusable(false);
                this.changeSliceValueButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PatternEditor.this.doChangeSliceValue();
                    }
                });
                jComponent2 = new KeyedRecordMenu();
                ((KeyedRecordMenu)jComponent2).addItem(new KeyedRecord(0, "Add..."));
                ((KeyedRecordMenu)jComponent2).addItem(new KeyedRecord(1, "New..."));
                ((KeyedRecordMenu)jComponent2).addItem(new KeyedRecord(2, "Import..."));
                jComponent2.setFocusable(false);
                ((JComboBox)jComponent2).addActionListener(new ActionListener((KeyedRecordMenu)jComponent2){
                    final /* synthetic */ KeyedRecordMenu val$addSliceMenu;
                    {
                        this.val$addSliceMenu = keyedRecordMenu;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (PatternEditor.this.blockActions()) {
                            PatternEditor.this.doAddSlice(2 == this.val$addSliceMenu.getSelectedKey());
                            this.val$addSliceMenu.setSelectedIndex(0);
                            PatternEditor.this.blockActionsEnd();
                        }
                    }
                });
                this.removeSliceButton = new JButton("Remove");
                this.removeSliceButton.setFocusable(false);
                this.removeSliceButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PatternEditor.this.doRemoveSlice();
                    }
                });
                jPanel5.add(this.changeSliceValueButton);
                jPanel5.add(jComponent2);
                jPanel5.add(this.removeSliceButton);
            }
        }
        this.patternModel = new PatternTableModel();
        this.patternModel.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PatternEditor.this.patternModel.updateButtons();
            }
        });
        serializable3 = new JPanel(new BorderLayout());
        ((Container)serializable3).add(AppController.createScrollPane(this.patternModel.table), "Center");
        AppController.setComponentEnabled(this.patternModel.table, this.canEdit);
        this.patternPlotPanel = new PatternPlotPanel();
        if (this.isSearch) {
            this.patternSearchPanel = new PatternSearchPanel();
        }
        serializable2 = null;
        if (this.canEdit) {
            serializable2 = new JButton("Add");
            ((Component)serializable2).setFocusable(false);
            ((AbstractButton)serializable2).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PatternEditor.this.doAddPoint();
                }
            });
            this.insertPointButton = new JButton("Insert");
            this.insertPointButton.setFocusable(false);
            this.insertPointButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PatternEditor.this.doInsertPoint();
                }
            });
            this.deletePointButton = new JButton("Delete");
            this.deletePointButton.setFocusable(false);
            this.deletePointButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PatternEditor.this.doDeletePoint();
                }
            });
        }
        if (this.canEdit || this.isSearch) {
            this.applyButton = 3 == this.patternType ? new JButton("Save") : new JButton("OK");
            this.applyButton.setFocusable(false);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PatternEditor.this.doApply();
                }
            });
        }
        jComponent2 = null;
        jComponent2 = this.canEdit || this.isSearch ? new JButton("Cancel") : new JButton("Close");
        jComponent2.setFocusable(false);
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PatternEditor.this.isSearch) {
                    PatternEditor.this.pattern = null;
                }
                PatternEditor.this.cancel();
            }
        });
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.add(jPanel2);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        if (null != jPanel3 || null != jPanel4 || null != jPanel5) {
            jComponent = Box.createVerticalBox();
            if (null != jPanel3) {
                jComponent.add(jPanel3);
            }
            if (null != jPanel4) {
                jComponent.add(jPanel4);
            }
            if (null != jPanel5) {
                jComponent.add(jPanel5);
            }
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(jComponent);
            jPanel7.add((Component)jPanel, "North");
        }
        if (null != serializable2) {
            jComponent = new JPanel(new FlowLayout(0));
            jComponent.add((Component)serializable2);
            jComponent.add(this.insertPointButton);
            jComponent.add(this.deletePointButton);
            ((Container)serializable3).add(jComponent, "South");
        }
        jComponent = new JTabbedPane();
        ((JTabbedPane)jComponent).addTab("Data", (Component)serializable3);
        ((JTabbedPane)jComponent).addTab("Plot", this.patternPlotPanel);
        jPanel7.add((Component)jComponent, "Center");
        jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jComponent2);
        if (null != this.applyButton) {
            jPanel.add(this.applyButton);
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        if (null != this.patternSearchPanel) {
            serializable = new JPanel(new BorderLayout());
            serializable.add(jPanel6, "North");
            serializable.add(jPanel7, "Center");
            JSplitPane jSplitPane = new JSplitPane(1, this.patternSearchPanel, (Component)serializable);
            container.add((Component)jSplitPane, "Center");
        } else {
            container.add((Component)jPanel6, "North");
            container.add((Component)jPanel7, "Center");
        }
        container.add((Component)jPanel, "South");
        if (null != this.applyButton) {
            this.getRootPane().setDefaultButton(this.applyButton);
        }
        this.pack();
        serializable = this.getSize();
        ((Dimension)serializable).height = 650;
        this.setSize((Dimension)serializable);
        this.setMinimumSize((Dimension)serializable);
        this.setResizable(true);
        this.setLocationSaved(true);
        this.updateDocumentName();
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
    }

    public AntPattern getPattern() {
        return this.pattern;
    }

    public boolean didEdit() {
        return this.didEdit;
    }

    private void doChangeSlice() {
        if (null == this.sliceMenu || null == this.currentSliceValue || this.ignoreSliceChange || this.pattern.isSimple()) {
            return;
        }
        if (this.canEdit && !this.patternModel.checkPattern()) {
            this.ignoreSliceChange = true;
            this.sliceMenu.setSelectedItem(this.currentSliceValue);
            this.ignoreSliceChange = false;
            return;
        }
        this.updateState((Double)this.sliceMenu.getSelectedItem());
    }

    private void doPreviousSlice() {
        if (null == this.sliceMenu || null == this.currentSliceValue || this.ignoreSliceChange || this.pattern.isSimple() || this.canEdit && !this.patternModel.checkPattern()) {
            return;
        }
        int n = this.sliceMenu.getSelectedIndex() - 1;
        if (n < 0) {
            n = this.sliceMenu.getItemCount() - 1;
        }
        this.ignoreSliceChange = true;
        this.sliceMenu.setSelectedIndex(n);
        this.ignoreSliceChange = false;
        this.updateState((Double)this.sliceMenu.getSelectedItem());
    }

    private void doNextSlice() {
        if (null == this.sliceMenu || null == this.currentSliceValue || this.ignoreSliceChange || this.pattern.isSimple() || this.canEdit && !this.patternModel.checkPattern()) {
            return;
        }
        int n = this.sliceMenu.getSelectedIndex() + 1;
        if (n >= this.sliceMenu.getItemCount()) {
            n = 0;
        }
        this.ignoreSliceChange = true;
        this.sliceMenu.setSelectedIndex(n);
        this.ignoreSliceChange = false;
        this.updateState((Double)this.sliceMenu.getSelectedItem());
    }

    private void doChangeSliceValue() {
        double d;
        double d2;
        String string;
        String string2;
        if (!this.canEdit || null == this.currentSliceValue || this.pattern.isSimple()) {
            return;
        }
        if (2 == this.patternType) {
            string2 = "Azimuth";
            string = "azimuth";
            d2 = 0.0;
            d = 359.999;
        } else {
            string2 = "Frequency";
            string = "frequency";
            d2 = 10.0;
            d = 5000.0;
        }
        String string3 = "Change Pattern " + string2;
        this.errorReporter.setTitle(string3);
        Double d3 = null;
        do {
            String string4;
            if (null == (string4 = (String)JOptionPane.showInputDialog(this, "New " + string, string3, 3, null, null, AppCore.formatDecimal((double)this.currentSliceValue, (int)2)))) {
                return;
            }
            if ((string4 = string4.trim()).length() <= 0) continue;
            try {
                double d4 = Double.parseDouble(string4);
                if (d4 < d2 || d4 > d) {
                    this.errorReporter.reportWarning("The " + string + " must be in the range " + d2 + " to " + d);
                    continue;
                }
                d3 = d4;
                if (d3.equals(this.currentSliceValue)) {
                    return;
                }
                if (!this.pattern.containsSlice(d3)) continue;
                this.errorReporter.reportWarning("A pattern with that " + string + " already exists");
                d3 = null;
            }
            catch (NumberFormatException numberFormatException) {
                this.errorReporter.reportWarning("The " + string + " must be a number");
            }
        } while (null == d3);
        this.pattern.changeSliceValue(this.currentSliceValue, d3);
        this.updateState(d3);
        this.didEdit = true;
    }

    private void doAddSlice(boolean bl) {
        double d;
        String string;
        double d2;
        double d3;
        String string2;
        String string3;
        String string4;
        String string5;
        if (!this.canEdit || 1 == this.patternType || !this.patternModel.checkPattern()) {
            return;
        }
        if (2 != this.patternType) {
            string5 = "Azimuth";
            string4 = "azimuth";
            string3 = "Frequency";
            string2 = "frequency";
            d3 = 10.0;
            d2 = 5000.0;
        } else {
            string5 = "Elevation";
            string4 = "elevation";
            string3 = "Azimuth";
            string2 = "azimuth";
            d3 = 0.0;
            d2 = 359.999;
        }
        String string6 = "Add " + string5 + " Pattern";
        this.errorReporter.setTitle(string6);
        Double d4 = null;
        Double d5 = null;
        if (this.pattern.isSimple()) {
            do {
                if (null == (string = JOptionPane.showInputDialog(this, "Existing pattern " + string2, string6, 3))) {
                    return;
                }
                if ((string = string.trim()).length() <= 0) continue;
                try {
                    d = Double.parseDouble(string);
                    if (d < d3 || d > d2) {
                        this.errorReporter.reportWarning("The " + string2 + " must be in the range " + d3 + " to " + d2);
                        continue;
                    }
                    d4 = d;
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorReporter.reportWarning("The " + string2 + " must be a number");
                }
            } while (null == d4);
        }
        do {
            if (null == (string = JOptionPane.showInputDialog(this, "New pattern " + string2, string6, 3))) {
                return;
            }
            if ((string = string.trim()).length() <= 0) continue;
            try {
                d = Double.parseDouble(string);
                if (d < d3 || d > d2) {
                    this.errorReporter.reportWarning("The " + string2 + " must be in the range " + d3 + " to " + d2);
                    continue;
                }
                d5 = d;
                if (!this.pattern.containsSlice(d5) && (null == d4 || !d5.equals(d4))) continue;
                this.errorReporter.reportWarning("A pattern with that " + string2 + " already exists");
                d5 = null;
            }
            catch (NumberFormatException numberFormatException) {
                this.errorReporter.reportWarning("The " + string2 + " must be a number");
            }
        } while (null == d5);
        ArrayList arrayList = null;
        if (bl) {
            JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle(string6);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Text (*.csv,*.txt,*.dat)", "csv", "txt", "dat"));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            if (0 != jFileChooser.showDialog(this, "Import")) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
            AntPattern antPattern = AntPattern.readFromText((String)this.getDbID(), (int)this.patternType, (File)file, (ErrorLogger)this.errorReporter);
            if (null == antPattern) {
                return;
            }
            if (antPattern.isSimple()) {
                arrayList = antPattern.getPoints();
            } else {
                Double d6 = null;
                ArrayList arrayList2 = antPattern.getSliceValues();
                if (null == arrayList2 || arrayList2.isEmpty()) {
                    return;
                }
                Object[] objectArray = arrayList2.toArray();
                d6 = (Double)JOptionPane.showInputDialog(this, "Select " + string4 + " pattern to add", string6, 1, null, objectArray, objectArray[0]);
                if (null == d6) {
                    return;
                }
                arrayList = antPattern.getSlice(d6);
            }
            if (null == arrayList) {
                return;
            }
        }
        if (this.pattern.isSimple()) {
            this.pattern.convertToMatrix(d4, d5, arrayList);
        } else {
            this.pattern.addSlice(d5, arrayList);
        }
        this.updateState(d5);
        this.didEdit = true;
    }

    private void doRemoveSlice() {
        if (!this.canEdit || null == this.currentSliceValue || this.pattern.isSimple()) {
            return;
        }
        this.pattern.removeSlice(this.currentSliceValue);
        this.updateState(null);
        this.didEdit = true;
    }

    private void updateState(Double d) {
        if (null == this.pattern) {
            if (null != this.applyButton) {
                this.applyButton.setEnabled(false);
            }
            this.patternModel.setPoints(null);
            this.currentSliceValue = null;
            if (null != this.sliceMenu) {
                this.ignoreSliceChange = true;
                this.sliceMenu.removeAllItems();
                this.ignoreSliceChange = false;
                this.sliceMenu.setEnabled(false);
                this.previousSliceButton.setEnabled(false);
                this.nextSliceButton.setEnabled(false);
            }
            return;
        }
        if (null != this.applyButton) {
            this.applyButton.setEnabled(true);
        }
        if (null == this.sliceMenu) {
            this.patternModel.setPoints(this.pattern.getPoints());
            this.currentSliceValue = null;
            return;
        }
        this.ignoreSliceChange = true;
        this.sliceMenu.removeAllItems();
        if (this.pattern.isSimple()) {
            this.sliceMenu.setEnabled(false);
            this.previousSliceButton.setEnabled(false);
            this.nextSliceButton.setEnabled(false);
            if (this.canEdit) {
                this.changeSliceValueButton.setEnabled(false);
                this.removeSliceButton.setEnabled(false);
            }
            this.patternModel.setPoints(this.pattern.getPoints());
            this.currentSliceValue = null;
        } else {
            for (Double d2 : this.pattern.getSliceValues()) {
                this.sliceMenu.addItem(d2);
            }
            if (null != d && this.pattern.containsSlice(d)) {
                this.sliceMenu.setSelectedItem(d);
            } else {
                d = (Double)this.sliceMenu.getSelectedItem();
            }
            this.sliceMenu.setEnabled(true);
            this.previousSliceButton.setEnabled(true);
            this.nextSliceButton.setEnabled(true);
            if (this.canEdit) {
                this.changeSliceValueButton.setEnabled(true);
                this.removeSliceButton.setEnabled(true);
            }
            this.patternModel.setPoints(this.pattern.getSlice(d));
            this.currentSliceValue = d;
        }
        this.ignoreSliceChange = false;
    }

    private void doAddPoint() {
        if (!this.canEdit) {
            return;
        }
        double d = 0.0;
        double d2 = 1.0;
        int n = this.patternModel.points.size() - 1;
        if (n >= 0) {
            double d3;
            double d4;
            if (2 != this.patternType) {
                d4 = 10.0;
                d3 = 359.899;
            } else {
                d4 = 1.0;
                d3 = 89.9;
            }
            AntPattern.AntPoint antPoint = (AntPattern.AntPoint)this.patternModel.points.get(n);
            if (n > 0) {
                AntPattern.AntPoint antPoint2 = (AntPattern.AntPoint)this.patternModel.points.get(n - 1);
                d4 = antPoint.angle - antPoint2.angle;
            }
            if ((d = antPoint.angle + d4) > d3) {
                d = d3;
            }
            if (d <= antPoint.angle) {
                AppController.beep();
                return;
            }
            d2 = antPoint.relativeField;
        }
        if (this.patternModel.addPoint(new AntPattern.AntPoint(d, d2)) >= 0) {
            this.didEdit = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doInsertPoint() {
        double d;
        double d2;
        double d3;
        if (!this.canEdit) {
            return;
        }
        int n = this.patternModel.getSelectedRow();
        if (n < 0) {
            return;
        }
        double d4 = 0.0;
        double d5 = 1.0;
        AntPattern.AntPoint antPoint = (AntPattern.AntPoint)this.patternModel.points.get(n);
        if (2 != this.patternType) {
            d3 = 10.0;
            d2 = 0.0;
            d = 1000.0;
        } else {
            d3 = 1.0;
            d2 = -90.0;
            d = 1000.0;
        }
        if (n > 0) {
            AntPattern.AntPoint antPoint2 = (AntPattern.AntPoint)this.patternModel.points.get(n - 1);
            if (!(antPoint.angle - antPoint2.angle > 2.0 / d)) {
                AppController.beep();
                return;
            }
            d4 = (antPoint.angle + antPoint2.angle) / 2.0;
            d4 = Math.rint(d4 * d) / d;
            d5 = (antPoint.relativeField + antPoint2.relativeField) / 2.0;
            d5 = Math.rint(d5 * 1000.0) / 1000.0;
        } else {
            if (n < this.patternModel.points.size() - 1) {
                AntPattern.AntPoint antPoint3 = (AntPattern.AntPoint)this.patternModel.points.get(n + 1);
                d3 = antPoint3.angle - antPoint.angle;
            }
            if ((d4 = antPoint.angle - d3) < d2) {
                d4 = d2;
            }
            if (d4 >= antPoint.angle) {
                AppController.beep();
                return;
            }
            d5 = antPoint.relativeField;
        }
        if (this.patternModel.addPoint(new AntPattern.AntPoint(d4, d5)) >= 0) {
            this.didEdit = true;
        }
    }

    private void doDeletePoint() {
        if (!this.canEdit || this.patternModel.points.size() <= 2) {
            return;
        }
        int n = this.patternModel.getSelectedRow();
        if (n >= 0) {
            this.patternModel.remove(n);
            this.didEdit = true;
        }
    }

    private void doApply() {
        if (!this.canEdit || this.isSearch) {
            AppController.hideWindow(this);
            return;
        }
        this.errorReporter.clearTitle();
        if (!this.commitCurrentField()) {
            return;
        }
        this.errorReporter.clearErrors();
        if (this.patternModel.table.isEditing()) {
            this.patternModel.table.getCellEditor().stopCellEditing();
        }
        if (this.errorReporter.hasErrors()) {
            return;
        }
        if (!this.patternModel.checkPattern()) {
            return;
        }
        if (!this.pattern.isDataValid((ErrorLogger)this.errorReporter)) {
            return;
        }
        String string = this.patternNameField.getText().trim();
        if (string.equals("(new)") || string.equals("(generic)")) {
            string = "";
        }
        if (string.length() > 255) {
            string = string.substring(0, 255);
        }
        if (3 == this.patternType && 0 == string.length()) {
            this.errorReporter.reportWarning("Please provide a name for the antenna");
            return;
        }
        if (!string.equals(this.pattern.name)) {
            if (3 == this.patternType && !AntPattern.checkReceiveAntennaName((String)this.getDbID(), (String)string, (String)this.pattern.name, (ErrorLogger)this.errorReporter)) {
                return;
            }
            this.pattern.name = string;
            this.didEdit = true;
        }
        if (this.parent.applyEditsFrom(this)) {
            AppController.hideWindow(this);
        }
    }

    @Override
    public boolean cancel() {
        if (this.windowShouldClose()) {
            AppController.hideWindow(this);
            return true;
        }
        return false;
    }

    public void updateExtDbList() {
        if (!this.isSearch) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList = ExtDb.getExtDbList((String)PatternEditor.this.getDbID(), (int)0);
                if (null == arrayList) {
                    return;
                }
                int n = PatternEditor.this.patternSearchPanel.extDbMenu.getSelectedKey();
                PatternEditor.this.patternSearchPanel.extDbMenu.removeAllItems();
                if (!arrayList.isEmpty()) {
                    PatternEditor.this.patternSearchPanel.extDbMenu.addAllItems(arrayList);
                    if (PatternEditor.this.patternSearchPanel.extDbMenu.containsKey(n)) {
                        PatternEditor.this.patternSearchPanel.extDbMenu.setSelectedKey(n);
                    }
                }
            }
        });
    }

    @Override
    public void windowWillOpen() {
        this.updateState(null);
        if (this.isSearch) {
            this.updateExtDbList();
        } else {
            this.patternNameField.setText(this.pattern.name);
            if (null != this.antennaOrientationField) {
                this.antennaOrientationField.setText(AppCore.formatAzimuth((double)this.antennaOrientation));
            }
            if (null != this.antennaGainField) {
                this.antennaGainField.setText(AppCore.formatDecimal((double)this.pattern.gain, (int)2));
            }
        }
        this.setLocationRelativeTo(this.getOwner());
        this.blockActionsClear();
        if (this.isSearch) {
            ExtDb.addListener((ExtDbListener)this);
        }
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        if (this.isSearch) {
            ExtDb.removeListener((ExtDbListener)this);
        }
        this.blockActionsSet();
        if (!this.isSearch) {
            this.parent.editorClosing(this);
        }
    }

    private class PatternSearchPanel
    extends JPanel {
        private KeyedRecordMenu extDbMenu = new KeyedRecordMenu(new ArrayList<KeyedRecord>());
        private JTextField searchField;
        private SearchListModel searchModel;
        private JButton searchButton;

        private PatternSearchPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Station Data"));
            jPanel.add(this.extDbMenu);
            this.searchField = new JTextField(15);
            AppController.fixKeyBindings(this.searchField);
            this.searchField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PatternSearchPanel.this.doSearch();
                }
            });
            this.searchModel = new SearchListModel();
            this.searchModel.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    PatternSearchPanel.this.doLoad();
                }
            });
            this.searchButton = new JButton("Search");
            this.searchButton.setFocusable(false);
            this.searchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PatternSearchPanel.this.doSearch();
                }
            });
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.add(jPanel);
            JPanel jPanel3 = new JPanel(new FlowLayout(0));
            jPanel3.add(this.searchField);
            jPanel3.add(this.searchButton);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 1));
            jPanel4.add(jPanel2);
            jPanel4.add(jPanel3);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel4, "North");
            this.add((Component)AppController.createScrollPane(this.searchModel.list), "Center");
        }

        private void doSearch() {
            PatternEditor.this.errorReporter.setTitle("Pattern Search");
            int n = this.extDbMenu.getSelectedKey();
            if (n <= 0) {
                PatternEditor.this.errorReporter.reportWarning("Please select a station data set");
                return;
            }
            final Integer n2 = n;
            final String string = this.searchField.getText().trim();
            if (0 == string.length()) {
                return;
            }
            BackgroundWorker<ArrayList<ExtDb.PatternID>> backgroundWorker = new BackgroundWorker<ArrayList<ExtDb.PatternID>>((Window)PatternEditor.this.outerThis, PatternEditor.this.getTitle()){

                @Override
                protected ArrayList<ExtDb.PatternID> doBackgroundWork(ErrorLogger errorLogger) {
                    return ExtDb.findPatterns((String)PatternEditor.this.getDbID(), (Integer)n2, (String)string, (2 == PatternEditor.this.patternType ? 1 : 0) != 0, (int)PatternEditor.this.recordType, (ErrorLogger)errorLogger);
                }
            };
            ArrayList arrayList = (ArrayList)backgroundWorker.runWork("Searching for patterns, please wait...", PatternEditor.this.errorReporter);
            if (null == arrayList) {
                return;
            }
            PatternEditor.this.pattern = null;
            PatternEditor.this.updateState(null);
            PatternEditor.this.patternNameField.setText("");
            this.searchModel.setItems(arrayList);
        }

        private void doLoad() {
            ExtDb.PatternID patternID = this.searchModel.getSelectedItem();
            if (null == patternID) {
                return;
            }
            String string = "Load Pattern Data";
            PatternEditor.this.errorReporter.setTitle(string);
            PatternEditor.this.errorReporter.clearMessages();
            PatternEditor.this.pattern = ExtDb.getPattern((ExtDb.PatternID)patternID, (ErrorLogger)PatternEditor.this.errorReporter);
            PatternEditor.this.updateState(null);
            if (null != PatternEditor.this.pattern) {
                PatternEditor.this.patternNameField.setText(((PatternEditor)PatternEditor.this).pattern.name);
                PatternEditor.this.errorReporter.showMessages();
            } else {
                PatternEditor.this.patternNameField.setText("");
            }
        }

        private class SearchListModel
        extends AbstractListModel<String> {
            private ArrayList<ExtDb.PatternID> modelRows = new ArrayList();
            private JList<String> list = new JList<String>(this);

            private SearchListModel() {
                this.list.setSelectionMode(0);
            }

            private void setItems(ArrayList<ExtDb.PatternID> arrayList) {
                int n = this.modelRows.size() - 1;
                if (n >= 0) {
                    this.modelRows.clear();
                    this.fireIntervalRemoved(this, 0, n);
                }
                if (null != arrayList) {
                    this.modelRows.addAll(arrayList);
                }
                if ((n = this.modelRows.size() - 1) >= 0) {
                    this.fireIntervalAdded(this, 0, n);
                }
            }

            private ExtDb.PatternID getSelectedItem() {
                int n = this.list.getSelectedIndex();
                if (n >= 0) {
                    return this.modelRows.get(n);
                }
                return null;
            }

            @Override
            public int getSize() {
                return this.modelRows.size();
            }

            @Override
            public String getElementAt(int n) {
                ExtDb.PatternID patternID = this.modelRows.get(n);
                if (patternID.isMatrix) {
                    return patternID.name + " (matrix)";
                }
                return patternID.name;
            }
        }
    }

    private class PatternPlotPanel
    extends Canvas {
        private PatternPlotPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            ArrayList arrayList;
            int n;
            double d;
            int n2;
            int n3;
            int n4;
            int n5;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.GRAY);
            graphics2D.setStroke(new BasicStroke(1.0f));
            double d7 = this.getHeight();
            double d8 = 1.0;
            double d9 = 1.0;
            double d10 = 1.0;
            if (2 != PatternEditor.this.patternType) {
                d6 = (double)this.getWidth() / 2.0;
                d8 = d6 * 0.95;
                d10 = d8 < (d9 = (d5 = d7 / 2.0) * 0.95) ? d8 : d9;
                d4 = 0.02;
                for (d3 = 0.2; d3 < 1.01; d3 += 0.2) {
                    d2 = d3 * d10 * 2.0;
                    n5 = (int)(d6 - d2 / 2.0);
                    n4 = (int)(d7 - (d5 + d2 / 2.0));
                    n3 = (int)d2;
                    n2 = (int)d2;
                    graphics2D.drawOval(n5, n4, n3, n2);
                }
                for (d = 0.0; d < 359.99; d += 10.0) {
                    n5 = (int)(d6 + 0.2 * d10 * Math.sin(d * (Math.PI / 180)));
                    n4 = (int)(d7 - (d5 + 0.2 * d10 * Math.cos(d * (Math.PI / 180))));
                    n3 = (int)(d6 + d10 * Math.sin(d * (Math.PI / 180)));
                    n2 = (int)(d7 - (d5 + d10 * Math.cos(d * (Math.PI / 180))));
                    graphics2D.drawLine(n5, n4, n3, n2);
                }
            } else {
                d2 = (double)this.getWidth() / 100.0;
                d8 = d2 * 0.95;
                d6 = (d2 - d8) / 2.0 * 100.0;
                d9 = d7 * 0.95;
                d5 = (d7 - d9) / 2.0;
                d4 = 0.25;
                n5 = (int)d6;
                n3 = (int)(d6 + 100.0 * d8);
                for (d3 = 0.0; d3 < 1.01; d3 += 0.1) {
                    n2 = n4 = (int)(d7 - (d5 + d3 * d9));
                    graphics2D.drawLine(n5, n4, n3, n2);
                }
                n4 = (int)(d7 - d5);
                n2 = (int)(d7 - (d5 + d9));
                for (d = 0.0; d < 100.01; d += 5.0) {
                    n3 = n5 = (int)(d6 + d * d8);
                    graphics2D.drawLine(n5, n4, n3, n2);
                }
                n3 = n5 = (int)(d6 + 10.0 * d8);
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.drawLine(n5, n4, n3, n2);
            }
            if ((n = (arrayList = PatternEditor.this.patternModel.points).size()) < 2) {
                return;
            }
            Path2D.Double double_ = new Path2D.Double();
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            double d14 = 0.0;
            boolean bl = true;
            if (2 != PatternEditor.this.patternType) {
                double d15 = 0.0;
                if (null != PatternEditor.this.rotateHorizontalPlotCheckBox && PatternEditor.this.rotateHorizontalPlotCheckBox.isSelected()) {
                    d15 = PatternEditor.this.antennaOrientation;
                }
                for (int i = 0; i < n; ++i) {
                    AntPattern.AntPoint antPoint = (AntPattern.AntPoint)arrayList.get(i);
                    double d16 = (antPoint.angle + d15) * (Math.PI / 180);
                    double d17 = antPoint.relativeField;
                    int n6 = i + 1;
                    if (n6 == n) {
                        n6 = 0;
                    }
                    AntPattern.AntPoint antPoint2 = (AntPattern.AntPoint)arrayList.get(n6);
                    double d18 = (antPoint2.angle + d15) * (Math.PI / 180);
                    if (d18 < d16) {
                        d18 += Math.PI * 2;
                    }
                    double d19 = antPoint2.relativeField;
                    for (d = d16; d < d18; d += d4) {
                        d3 = d17 + (d19 - d17) * ((d - d16) / (d18 - d16));
                        d2 = d6 + d3 * d10 * Math.sin(d);
                        double d20 = d7 - (d5 + d3 * d10 * Math.cos(d));
                        if (bl) {
                            bl = false;
                            double_.moveTo(d2, d20);
                            d13 = d2;
                            d14 = d20;
                            d11 = d2;
                            d12 = d20;
                            continue;
                        }
                        double d21 = d2 - d13;
                        double d22 = d20 - d14;
                        if (!(Math.sqrt(d21 * d21 + d22 * d22) > 2.0)) continue;
                        double_.lineTo(d2, d20);
                        d13 = d2;
                        d14 = d20;
                    }
                }
                double_.lineTo(d11, d12);
            } else {
                for (int i = 0; i < n - 1; ++i) {
                    AntPattern.AntPoint antPoint = (AntPattern.AntPoint)arrayList.get(i);
                    double d23 = antPoint.angle + 10.0;
                    double d24 = antPoint.relativeField;
                    AntPattern.AntPoint antPoint3 = (AntPattern.AntPoint)arrayList.get(i + 1);
                    double d25 = antPoint3.angle + 10.0;
                    double d26 = antPoint3.relativeField;
                    for (d = d23; d < d25; d += d4) {
                        if (d < 0.0) continue;
                        d3 = d24 + (d26 - d24) * ((d - d23) / (d25 - d23));
                        d2 = d6 + d * d8;
                        double d27 = d7 - (d5 + d3 * d9);
                        if (bl) {
                            bl = false;
                            double_.moveTo(d2, d27);
                            d13 = d2;
                            d14 = d27;
                            continue;
                        }
                        double d28 = d2 - d13;
                        double d29 = d27 - d14;
                        if (!(Math.sqrt(d28 * d28 + d29 * d29) > 2.0)) continue;
                        double_.lineTo(d2, d27);
                        d13 = d2;
                        d14 = d27;
                    }
                }
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
            graphics2D.draw(double_);
        }
    }

    private class PatternTableModel
    extends AbstractTableModel {
        private ArrayList<AntPattern.AntPoint> points = new ArrayList();
        private JTable table = new JTable(this);

        private PatternTableModel() {
            AppController.configureTable(this.table);
            TableColumn tableColumn = this.table.getColumn(this.getColumnName(0));
            tableColumn.setMinWidth(AppController.textFieldWidth[4]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
            tableColumn = this.table.getColumn(this.getColumnName(1));
            tableColumn.setMinWidth(AppController.textFieldWidth[4]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
            this.table.setPreferredScrollableViewportSize(new Dimension(this.table.getPreferredSize().width, this.table.getRowHeight() * 30));
        }

        private void setPoints(ArrayList<AntPattern.AntPoint> arrayList) {
            this.points = null == arrayList ? new ArrayList() : arrayList;
            this.fireTableDataChanged();
            this.updateButtons();
            PatternEditor.this.patternPlotPanel.repaint();
        }

        private int addPoint(AntPattern.AntPoint antPoint) {
            int n = 0;
            for (n = 0; n < this.points.size(); ++n) {
                AntPattern.AntPoint antPoint2 = this.points.get(n);
                if (!(antPoint.angle <= antPoint2.angle)) continue;
                if (antPoint.angle != antPoint2.angle) break;
                return -1;
            }
            this.points.add(n, antPoint);
            this.fireTableRowsInserted(n, n);
            final int n2 = n;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PatternTableModel.this.table.setRowSelectionInterval(n2, n2);
                    PatternTableModel.this.table.scrollRectToVisible(PatternTableModel.this.table.getCellRect(n2, 0, true));
                }
            });
            this.updateButtons();
            return n;
        }

        private void remove(int n) {
            if (this.points.size() <= 2) {
                return;
            }
            this.points.remove(n);
            this.fireTableRowsDeleted(n, n);
            this.updateButtons();
        }

        private void updateButtons() {
            if (PatternEditor.this.canEdit) {
                if (this.table.getSelectedRow() >= 0) {
                    PatternEditor.this.insertPointButton.setEnabled(true);
                    PatternEditor.this.deletePointButton.setEnabled(this.points.size() > 2);
                } else {
                    PatternEditor.this.insertPointButton.setEnabled(false);
                    PatternEditor.this.deletePointButton.setEnabled(false);
                }
            }
        }

        private int getSelectedRow() {
            return this.table.getSelectedRow();
        }

        private boolean checkPattern() {
            PatternEditor.this.errorReporter.setTitle("Verify Pattern");
            if (this.points.size() < 2) {
                PatternEditor.this.errorReporter.reportValidationError("Pattern must have 2 or more points");
                return false;
            }
            if (3 != PatternEditor.this.patternType) {
                double d = 0.0;
                for (AntPattern.AntPoint antPoint : this.points) {
                    if (!(antPoint.relativeField > d)) continue;
                    d = antPoint.relativeField;
                }
                if (d < 1.0) {
                    PatternEditor.this.errorReporter.reportValidationError("Pattern must have a 1");
                    return false;
                }
            }
            return true;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            if (0 == n) {
                if (2 != PatternEditor.this.patternType) {
                    return "Azimuth";
                }
                return "Vertical Angle";
            }
            return "Relative Field";
        }

        @Override
        public int getRowCount() {
            return this.points.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return PatternEditor.this.canEdit;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AntPattern.AntPoint antPoint = this.points.get(n);
            switch (n2) {
                case 0: {
                    if (PatternEditor.this.patternType != 2) {
                        return AppCore.formatAzimuth((double)antPoint.angle);
                    }
                    return AppCore.formatDepression((double)antPoint.angle);
                }
                case 1: {
                    return AppCore.formatRelativeField((double)antPoint.relativeField);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (!PatternEditor.this.canEdit) {
                return;
            }
            PatternEditor.this.errorReporter.setTitle("Edit Pattern Point");
            double d = 0.0;
            try {
                d = Double.parseDouble(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                PatternEditor.this.errorReporter.reportValidationError("The value must be a number");
                return;
            }
            AntPattern.AntPoint antPoint = this.points.get(n);
            switch (n2) {
                case 0: {
                    String string = "";
                    if (2 != PatternEditor.this.patternType) {
                        if ((d = Math.rint(d * 1000.0) / 1000.0) == antPoint.angle) {
                            return;
                        }
                        if (d < 0.0 || d > 359.999) {
                            PatternEditor.this.errorReporter.reportValidationError("Azimuth must be from 0.0 to 359.999");
                            return;
                        }
                        string = "azimuth";
                    } else {
                        if ((d = Math.rint(d * 1000.0) / 1000.0) == antPoint.angle) {
                            return;
                        }
                        if (d < -90.0 || d > 90.0) {
                            PatternEditor.this.errorReporter.reportValidationError("Vertical angle must be from -90.0 to 90.0");
                            return;
                        }
                        string = "vertical angle";
                    }
                    int n3 = 0;
                    for (n3 = 0; n3 < this.points.size(); ++n3) {
                        if (n3 == n) continue;
                        AntPattern.AntPoint antPoint2 = this.points.get(n3);
                        if (!(d <= antPoint2.angle)) continue;
                        if (d != antPoint2.angle) break;
                        PatternEditor.this.errorReporter.reportValidationError("A point at that " + string + " already exists");
                        return;
                    }
                    if (n3 > n) {
                        --n3;
                    }
                    antPoint.angle = d;
                    PatternEditor.this.didEdit = true;
                    if (n3 == n) {
                        this.fireTableRowsUpdated(n, n);
                    } else {
                        this.points.remove(n);
                        this.fireTableRowsDeleted(n, n);
                        this.points.add(n3, antPoint);
                        this.fireTableRowsInserted(n3, n3);
                        final int n4 = n3;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PatternTableModel.this.table.setRowSelectionInterval(n4, n4);
                                PatternTableModel.this.table.scrollRectToVisible(PatternTableModel.this.table.getCellRect(n4, 0, true));
                            }
                        });
                    }
                    return;
                }
                case 1: {
                    if (d < 0.0 || d > 1.0) {
                        PatternEditor.this.errorReporter.reportValidationError("Relative field must be from 0.001 to 1.0");
                        return;
                    }
                    if ((d = Math.rint(d * 1000.0) / 1000.0) < 0.001) {
                        d = 0.001;
                    }
                    if (d == antPoint.relativeField) {
                        return;
                    }
                    antPoint.relativeField = d;
                    PatternEditor.this.didEdit = true;
                    this.fireTableRowsUpdated(n, n);
                    return;
                }
            }
        }
    }
}

