/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.geo.GeoBox;
import gov.fcc.tvstudy.core.geo.GeoCircle;
import gov.fcc.tvstudy.core.geo.GeoPointSet;
import gov.fcc.tvstudy.core.geo.GeoPolygon;
import gov.fcc.tvstudy.core.geo.GeoSectors;
import gov.fcc.tvstudy.core.geo.Geography;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class GeoPlotPanel
extends Canvas {
    private static final int SYMBOL_SIZE = 3;
    private int plotType;
    private double latitude;
    private double longitude;
    private double radius;
    private double width;
    private double height;
    private ArrayList<GeoPointSet.StudyPoint> studyPoints;
    private ArrayList<GeoSectors.Sector> sectors;
    private ArrayList<GeoPolygon.VertexPoint> vertexPoints;

    public void setGeography(Geography geography) {
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.radius = 0.0;
        this.width = 0.0;
        this.height = 0.0;
        this.studyPoints = null;
        this.sectors = null;
        this.vertexPoints = null;
        if (null == geography) {
            this.plotType = 0;
        } else {
            this.plotType = geography.type;
            switch (this.plotType) {
                case 1: {
                    this.studyPoints = ((GeoPointSet)geography).points;
                    break;
                }
                case 2: {
                    this.latitude = ((GeoCircle)geography).center.latitude;
                    this.longitude = ((GeoCircle)geography).center.longitude;
                    this.radius = ((GeoCircle)geography).radius;
                    break;
                }
                case 3: {
                    this.latitude = ((GeoBox)geography).center.latitude;
                    this.longitude = ((GeoBox)geography).center.longitude;
                    this.width = ((GeoBox)geography).width;
                    this.height = ((GeoBox)geography).height;
                    break;
                }
                case 5: {
                    this.latitude = ((GeoSectors)geography).center.latitude;
                    this.longitude = ((GeoSectors)geography).center.longitude;
                    this.sectors = ((GeoSectors)geography).sectors;
                    break;
                }
                case 4: {
                    this.latitude = ((GeoPolygon)geography).reference.latitude;
                    this.longitude = ((GeoPolygon)geography).reference.longitude;
                    this.vertexPoints = ((GeoPolygon)geography).points;
                }
            }
        }
        this.repaint();
    }

    public void setStudyPoints(ArrayList<GeoPointSet.StudyPoint> arrayList) {
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.radius = 0.0;
        this.width = 0.0;
        this.height = 0.0;
        this.sectors = null;
        this.vertexPoints = null;
        if (null == arrayList) {
            this.plotType = 0;
            this.studyPoints = null;
        } else {
            this.plotType = 1;
            this.studyPoints = arrayList;
        }
        this.repaint();
    }

    public void setSectors(ArrayList<GeoSectors.Sector> arrayList) {
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.radius = 0.0;
        this.width = 0.0;
        this.height = 0.0;
        this.studyPoints = null;
        this.vertexPoints = null;
        if (null == arrayList) {
            this.plotType = 0;
            this.sectors = null;
        } else {
            this.plotType = 5;
            this.sectors = arrayList;
        }
        this.repaint();
    }

    public void setVertexPoints(ArrayList<GeoPolygon.VertexPoint> arrayList) {
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.radius = 0.0;
        this.width = 0.0;
        this.height = 0.0;
        this.studyPoints = null;
        this.sectors = null;
        if (null == arrayList) {
            this.plotType = 0;
            this.vertexPoints = null;
        } else {
            this.plotType = 4;
            this.vertexPoints = arrayList;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.BLACK);
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = d * 0.9;
        double d4 = d2 * 0.9;
        double d5 = d * 0.05;
        double d6 = d2 * 0.05;
        switch (this.plotType) {
            default: {
                return;
            }
            case 1: {
                double d7;
                double d8;
                double d9 = 999.0;
                double d10 = -999.0;
                double d11 = 999.0;
                double d12 = -999.0;
                for (GeoPointSet.StudyPoint studyPoint : this.studyPoints) {
                    if (0.0 == studyPoint.latitude || 0.0 == studyPoint.longitude) continue;
                    if (studyPoint.latitude < d9) {
                        d9 = studyPoint.latitude;
                    }
                    if (studyPoint.latitude > d10) {
                        d10 = studyPoint.latitude;
                    }
                    if (studyPoint.longitude < d11) {
                        d11 = studyPoint.longitude;
                    }
                    if (!(studyPoint.longitude > d12)) continue;
                    d12 = studyPoint.longitude;
                }
                if (999.0 == d9 || 999.0 == d11) {
                    return;
                }
                double d13 = Math.cos((d10 + d9) / 2.0 * (Math.PI / 180));
                double d14 = 1.0;
                if (d12 - d11 > 0.0) {
                    if (d10 - d9 > 0.0) {
                        d8 = d3 / ((d12 - d11) * d13);
                        d7 = d4 / (d10 - d9);
                        if (d8 < d7) {
                            d14 = d8;
                            d6 += (d4 - (d10 - d9) * d14) / 2.0;
                        } else {
                            d14 = d7;
                            d5 += (d3 - (d12 - d11) * d13 * d14) / 2.0;
                        }
                    } else {
                        d14 = d3 / ((d12 - d11) * d13);
                        d6 += (d4 - (d10 - d9) * d14) / 2.0;
                    }
                } else if (d10 - d9 > 0.0) {
                    d14 = d4 / (d10 - d9);
                    d5 += (d3 - (d12 - d11) * d13 * d14) / 2.0;
                } else {
                    d14 = 1.0;
                    d5 += d3 / 2.0;
                    d6 += d4 / 2.0;
                }
                graphics2D.setStroke(new BasicStroke(1.0f));
                for (GeoPointSet.StudyPoint studyPoint : this.studyPoints) {
                    if (0.0 == studyPoint.latitude || 0.0 == studyPoint.longitude) continue;
                    d8 = d5 + (d12 - studyPoint.longitude) * d13 * d14;
                    d7 = d2 - (d6 + (studyPoint.latitude - d9) * d14);
                    int n3 = (int)Math.rint(d8);
                    int n4 = (int)Math.rint(d7);
                    graphics2D.drawLine(n3 - 3, n4, n3 + 3, n4);
                    graphics2D.drawLine(n3, n4 - 3, n3, n4 + 3);
                    if (!studyPoint.useAntennaOrientation) continue;
                    int n5 = (int)Math.rint(d8 + 9.0 * Math.sin(studyPoint.antennaOrientation * (Math.PI / 180)));
                    int n6 = (int)Math.rint(d7 - 9.0 * Math.cos(studyPoint.antennaOrientation * (Math.PI / 180)));
                    graphics2D.drawLine(n3, n4, n5, n6);
                }
                return;
            }
            case 2: {
                if (this.radius <= 0.0) {
                    return;
                }
                double d15 = 2.0 * this.radius;
                double d16 = d3 / d15;
                double d17 = d4 / d15;
                double d18 = d16 < d17 ? d16 : d17;
                int n7 = (int)Math.rint(d15 * d18);
                n2 = (int)Math.rint(d5 + (d3 - d15 * d18) / 2.0);
                n = (int)Math.rint(d2 - (d6 + (d4 - d15 * d18) / 2.0 + d15 * d18));
                graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
                graphics2D.drawOval(n2, n, n7, n7);
                if (0.0 == this.latitude || 0.0 == this.longitude) {
                    return;
                }
                n2 = (int)Math.rint(d5 + d3 / 2.0);
                n = (int)Math.rint(d2 - (d6 + d4 / 2.0));
                break;
            }
            case 3: {
                if (this.width <= 0.0 || this.height <= 0.0) {
                    return;
                }
                double d19 = d3 / this.width;
                double d20 = d4 / this.height;
                double d21 = d19 < d20 ? d19 : d20;
                n2 = (int)Math.rint(d5 + (d3 - this.width * d21) / 2.0);
                n = (int)Math.rint(d2 - (d6 + (d4 - this.height * d21) / 2.0 + this.height * d21));
                int n8 = (int)Math.rint(this.width * d21);
                int n9 = (int)Math.rint(this.height * d21);
                graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
                graphics2D.drawRect(n2, n, n8, n9);
                if (0.0 == this.latitude || 0.0 == this.longitude) {
                    return;
                }
                n2 = (int)Math.rint(d5 + d3 / 2.0);
                n = (int)Math.rint(d2 - (d6 + d4 / 2.0));
                break;
            }
            case 5: {
                double d22 = 0.0;
                for (GeoSectors.Sector sector : this.sectors) {
                    if (!(sector.radius > d22)) continue;
                    d22 = sector.radius;
                }
                if (d22 <= 0.0) {
                    return;
                }
                double d23 = d5 + d3 / 2.0;
                double d24 = d2 - (d6 + d4 / 2.0);
                double d25 = 2.0 * d22;
                double d26 = d3 / d25;
                double d27 = d4 / d25;
                double d28 = d26 < d27 ? d26 : d27;
                graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
                int n10 = this.sectors.size();
                for (int i = 0; i < n10; ++i) {
                    GeoSectors.Sector sector = this.sectors.get(i);
                    GeoSectors.Sector sector2 = i < n10 - 1 ? this.sectors.get(i + 1) : this.sectors.get(0);
                    d25 = sector.radius * 2.0;
                    n2 = (int)Math.rint(d5 + (d3 - d25 * d28) / 2.0);
                    n = (int)Math.rint(d2 - (d6 + (d4 - d25 * d28) / 2.0 + d25 * d28));
                    int n11 = (int)Math.rint(d25 * d28);
                    int n12 = (int)Math.rint(90.0 - sector.azimuth);
                    int n13 = sector2.azimuth > sector.azimuth ? (int)Math.rint(sector.azimuth - sector2.azimuth) : (int)Math.rint(sector.azimuth - sector2.azimuth - 360.0);
                    graphics2D.drawArc(n2, n, n11, n11, n12, n13);
                    double d29 = Math.sin(sector2.azimuth * (Math.PI / 180));
                    double d30 = Math.cos(sector2.azimuth * (Math.PI / 180));
                    int n14 = (int)Math.rint(d23 + sector.radius * d28 * d29);
                    int n15 = (int)Math.rint(d24 - sector.radius * d28 * d30);
                    int n16 = (int)Math.rint(d23 + sector2.radius * d28 * d29);
                    int n17 = (int)Math.rint(d24 - sector2.radius * d28 * d30);
                    graphics2D.drawLine(n14, n15, n16, n17);
                }
                if (0.0 == this.latitude || 0.0 == this.longitude) {
                    return;
                }
                n2 = (int)Math.rint(d23);
                n = (int)Math.rint(d24);
                break;
            }
            case 4: {
                if (this.vertexPoints.size() < 2) {
                    return;
                }
                double d31 = 999.0;
                double d32 = -999.0;
                double d33 = 999.0;
                double d34 = -999.0;
                for (GeoPolygon.VertexPoint vertexPoint : this.vertexPoints) {
                    if (0.0 == vertexPoint.latitude || 0.0 == vertexPoint.longitude) continue;
                    if (vertexPoint.latitude < d31) {
                        d31 = vertexPoint.latitude;
                    }
                    if (vertexPoint.latitude > d32) {
                        d32 = vertexPoint.latitude;
                    }
                    if (vertexPoint.longitude < d33) {
                        d33 = vertexPoint.longitude;
                    }
                    if (!(vertexPoint.longitude > d34)) continue;
                    d34 = vertexPoint.longitude;
                }
                if (999.0 == d31 || 999.0 == d33) {
                    return;
                }
                if (this.latitude != 0.0 && this.longitude != 0.0) {
                    if (this.latitude < d31) {
                        d31 = this.latitude;
                    }
                    if (this.latitude > d32) {
                        d32 = this.latitude;
                    }
                    if (this.longitude < d33) {
                        d33 = this.longitude;
                    }
                    if (this.longitude > d34) {
                        d34 = this.longitude;
                    }
                }
                double d35 = Math.cos((d32 + d31) / 2.0 * (Math.PI / 180));
                double d36 = 1.0;
                if (d34 - d33 > 0.0) {
                    if (d32 - d31 > 0.0) {
                        double d37 = d3 / ((d34 - d33) * d35);
                        double d38 = d4 / (d32 - d31);
                        if (d37 < d38) {
                            d36 = d37;
                            d6 += (d4 - (d32 - d31) * d36) / 2.0;
                        } else {
                            d36 = d38;
                            d5 += (d3 - (d34 - d33) * d35 * d36) / 2.0;
                        }
                    } else {
                        d36 = d3 / ((d34 - d33) * d35);
                        d6 += (d4 - (d32 - d31) * d36) / 2.0;
                    }
                } else if (d32 - d31 > 0.0) {
                    d36 = d4 / (d32 - d31);
                    d5 += (d3 - (d34 - d33) * d35 * d36) / 2.0;
                } else {
                    d36 = 1.0;
                    d5 += d3 / 2.0;
                    d6 += d4 / 2.0;
                }
                graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
                int n18 = 0;
                int n19 = 0;
                int n20 = 0;
                int n21 = 0;
                boolean bl = true;
                for (GeoPolygon.VertexPoint vertexPoint : this.vertexPoints) {
                    if (0.0 == vertexPoint.latitude || 0.0 == vertexPoint.longitude) continue;
                    n2 = (int)Math.rint(d5 + (d34 - vertexPoint.longitude) * d35 * d36);
                    n = (int)Math.rint(d2 - (d6 + (vertexPoint.latitude - d31) * d36));
                    if (bl) {
                        n18 = n2;
                        n19 = n;
                        bl = false;
                    } else {
                        graphics2D.drawLine(n20, n21, n2, n);
                    }
                    n20 = n2;
                    n21 = n;
                }
                if (n20 != n18 || n21 != n19) {
                    graphics2D.drawLine(n20, n21, n18, n19);
                }
                if (0.0 == this.latitude || 0.0 == this.longitude) {
                    return;
                }
                n2 = (int)Math.rint(d5 + (d34 - this.longitude) * d35 * d36);
                n = (int)Math.rint(d2 - (d6 + (this.latitude - d31) * d36));
                break;
            }
        }
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.drawLine(n2 - 3, n, n2 + 3, n);
        graphics2D.drawLine(n2, n - 3, n2, n + 3);
    }
}

