/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class CoordinatePanel
extends AppPanel {
    private GeoPoint point;
    private boolean isLongitude;
    private JComboBox<String> directionMenu;
    private JTextField degreesField;
    private JTextField minutesField;
    private JTextField secondsField;
    private boolean enabled;

    public CoordinatePanel(AppEditor appEditor, GeoPoint geoPoint, boolean bl, Runnable runnable) {
        super(appEditor, runnable);
        this.doSetup(geoPoint, bl, true);
    }

    public CoordinatePanel(AppEditor appEditor, GeoPoint geoPoint, boolean bl, boolean bl2, Runnable runnable) {
        super(appEditor, runnable);
        this.doSetup(geoPoint, bl, bl2);
    }

    private void doSetup(GeoPoint geoPoint, boolean bl, boolean bl2) {
        this.point = geoPoint;
        this.isLongitude = bl;
        this.blockActionsStart();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                try {
                    n = Integer.parseInt(actionEvent.getActionCommand());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n < 1 || n > 3) {
                    return;
                }
                if (CoordinatePanel.this.enabled && CoordinatePanel.this.blockActions()) {
                    String string = "Edit Coordinates";
                    String string2 = "";
                    switch (n) {
                        case 1: {
                            string2 = CoordinatePanel.this.degreesField.getText().trim();
                            break;
                        }
                        case 2: {
                            string2 = CoordinatePanel.this.minutesField.getText().trim();
                            break;
                        }
                        case 3: {
                            string2 = CoordinatePanel.this.secondsField.getText().trim();
                        }
                    }
                    if (string2.length() > 0) {
                        double d;
                        int n2;
                        int n3;
                        if (CoordinatePanel.this.isLongitude) {
                            n3 = ((CoordinatePanel)CoordinatePanel.this).point.longitudeDegrees;
                            n2 = ((CoordinatePanel)CoordinatePanel.this).point.longitudeMinutes;
                            d = ((CoordinatePanel)CoordinatePanel.this).point.longitudeSeconds;
                        } else {
                            n3 = ((CoordinatePanel)CoordinatePanel.this).point.latitudeDegrees;
                            n2 = ((CoordinatePanel)CoordinatePanel.this).point.latitudeMinutes;
                            d = ((CoordinatePanel)CoordinatePanel.this).point.latitudeSeconds;
                        }
                        try {
                            int n4;
                            double d2 = Double.parseDouble(string2);
                            boolean bl = false;
                            switch (n) {
                                case 1: {
                                    n3 = (int)Math.floor(d2);
                                    n4 = 0;
                                    n4 = CoordinatePanel.this.isLongitude ? (int)Math.floor(180.0) : (int)Math.floor(73.5);
                                    if (n3 < 0 || n3 > n4) {
                                        CoordinatePanel.this.errorReporter.reportValidationError(string, "Degrees must be in the range 0 to " + n4);
                                        bl = true;
                                        break;
                                    }
                                    if (!((d2 -= (double)n3) > 1.388888888888889E-6)) break;
                                    n2 = (int)Math.floor(d2 *= 60.0);
                                    d = (d2 -= (double)n2) * 60.0;
                                    break;
                                }
                                case 2: {
                                    n2 = (int)Math.floor(d2);
                                    if (n2 < 0 || n2 > 59) {
                                        CoordinatePanel.this.errorReporter.reportValidationError(string, "Minutes must be in the range 0 to 59");
                                        bl = true;
                                        break;
                                    }
                                    if (!((d2 -= (double)n2) > 8.333333333333333E-5)) break;
                                    d = d2 * 60.0;
                                    break;
                                }
                                case 3: {
                                    d = d2;
                                    if (!(d < 0.0) && !(d >= 60.0)) break;
                                    CoordinatePanel.this.errorReporter.reportValidationError(string, "Seconds must be in the range 0 to less than 60");
                                    bl = true;
                                }
                            }
                            if (!bl) {
                                if (d > 59.995) {
                                    d = 0.0;
                                    if (++n2 > 59) {
                                        n2 = 0;
                                        ++n3;
                                    }
                                }
                                n4 = 0;
                                d2 = (double)n3 + (double)n2 / 60.0 + d / 3600.0;
                                if (CoordinatePanel.this.isLongitude) {
                                    if (d2 < 0.0 || d2 > 180.0) {
                                        CoordinatePanel.this.errorReporter.reportValidationError(string, "Longitude must be in the range 0 to 180.0");
                                    } else {
                                        if (n3 != ((CoordinatePanel)CoordinatePanel.this).point.longitudeDegrees) {
                                            ((CoordinatePanel)CoordinatePanel.this).point.longitudeDegrees = n3;
                                            n4 = 1;
                                        }
                                        if (n2 != ((CoordinatePanel)CoordinatePanel.this).point.longitudeMinutes) {
                                            ((CoordinatePanel)CoordinatePanel.this).point.longitudeMinutes = n2;
                                            n4 = 1;
                                        }
                                        if (d != ((CoordinatePanel)CoordinatePanel.this).point.longitudeSeconds) {
                                            ((CoordinatePanel)CoordinatePanel.this).point.longitudeSeconds = d;
                                            n4 = 1;
                                        }
                                    }
                                } else if (d2 < 0.0 || d2 > 73.5) {
                                    CoordinatePanel.this.errorReporter.reportValidationError(string, "Latitude must be in the range 0 to 73.5");
                                } else {
                                    if (n3 != ((CoordinatePanel)CoordinatePanel.this).point.latitudeDegrees) {
                                        ((CoordinatePanel)CoordinatePanel.this).point.latitudeDegrees = n3;
                                        n4 = 1;
                                    }
                                    if (n2 != ((CoordinatePanel)CoordinatePanel.this).point.latitudeMinutes) {
                                        ((CoordinatePanel)CoordinatePanel.this).point.latitudeMinutes = n2;
                                        n4 = 1;
                                    }
                                    if (d != ((CoordinatePanel)CoordinatePanel.this).point.latitudeSeconds) {
                                        ((CoordinatePanel)CoordinatePanel.this).point.latitudeSeconds = d;
                                        n4 = 1;
                                    }
                                }
                                if (n4 != 0) {
                                    CoordinatePanel.this.point.updateLatLon();
                                    if (null != CoordinatePanel.this.callBack) {
                                        CoordinatePanel.this.callBack.run();
                                    }
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            CoordinatePanel.this.errorReporter.reportValidationError(string, "Input must be a number");
                        }
                    }
                    CoordinatePanel.this.blockActionsEnd();
                }
                CoordinatePanel.this.updatePanel();
            }
        };
        this.directionMenu = new JComboBox();
        this.directionMenu.setFocusable(false);
        if (this.isLongitude) {
            this.directionMenu.addItem("W");
            this.directionMenu.addItem("E");
        } else {
            this.directionMenu.addItem("N");
            this.directionMenu.addItem("S");
        }
        this.directionMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CoordinatePanel.this.blockActions()) {
                    int n = CoordinatePanel.this.directionMenu.getSelectedIndex();
                    boolean bl = false;
                    if (CoordinatePanel.this.isLongitude) {
                        if (n != ((CoordinatePanel)CoordinatePanel.this).point.longitudeWE) {
                            ((CoordinatePanel)CoordinatePanel.this).point.longitudeWE = n;
                            bl = true;
                        }
                    } else if (n != ((CoordinatePanel)CoordinatePanel.this).point.latitudeNS) {
                        ((CoordinatePanel)CoordinatePanel.this).point.latitudeNS = n;
                        bl = true;
                    }
                    if (bl) {
                        CoordinatePanel.this.point.updateLatLon();
                        if (null != CoordinatePanel.this.callBack) {
                            CoordinatePanel.this.callBack.run();
                        }
                    }
                    CoordinatePanel.this.blockActionsEnd();
                }
            }
        });
        this.degreesField = new JTextField(3);
        AppController.fixKeyBindings(this.degreesField);
        this.degreesField.setActionCommand("1");
        this.degreesField.addActionListener(actionListener);
        this.degreesField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CoordinatePanel.this.setCurrentField(CoordinatePanel.this.degreesField);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    CoordinatePanel.this.degreesField.postActionEvent();
                }
            }
        });
        this.minutesField = new JTextField(3);
        AppController.fixKeyBindings(this.minutesField);
        this.minutesField.setActionCommand("2");
        this.minutesField.addActionListener(actionListener);
        this.minutesField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CoordinatePanel.this.setCurrentField(CoordinatePanel.this.minutesField);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    CoordinatePanel.this.minutesField.postActionEvent();
                }
            }
        });
        this.secondsField = new JTextField(6);
        AppController.fixKeyBindings(this.secondsField);
        this.secondsField.setActionCommand("3");
        this.secondsField.addActionListener(actionListener);
        this.secondsField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CoordinatePanel.this.setCurrentField(CoordinatePanel.this.secondsField);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    CoordinatePanel.this.secondsField.postActionEvent();
                }
            }
        });
        if (bl2) {
            if (this.isLongitude) {
                this.setBorder(BorderFactory.createTitledBorder("Longitude (NAD83)"));
            } else {
                this.setBorder(BorderFactory.createTitledBorder("Latitude (NAD83)"));
            }
        }
        this.add(this.directionMenu);
        this.add(this.degreesField);
        this.add(new JLabel("\u00b0"));
        this.add(this.minutesField);
        this.add(new JLabel("'"));
        this.add(this.secondsField);
        this.add(new JLabel("\""));
        this.updatePanel();
        this.enabled = true;
        this.blockActionsEnd();
    }

    public double getCoordinate() {
        if (this.isLongitude) {
            return this.point.longitude;
        }
        return this.point.latitude;
    }

    public void setCoordinate(double d) {
        boolean bl = false;
        if (this.isLongitude) {
            if (Math.abs(d) <= 180.0) {
                this.point.longitude = d;
                bl = true;
            }
        } else if (Math.abs(d) <= 73.5) {
            this.point.latitude = d;
            bl = true;
        }
        if (bl) {
            this.point.updateDMS();
            if (null != this.callBack) {
                this.callBack.run();
            }
            this.updatePanel();
        }
    }

    public void updatePanel() {
        this.blockActionsStart();
        if (this.isLongitude) {
            this.directionMenu.setSelectedIndex(this.point.longitudeWE);
            this.degreesField.setText(String.valueOf(this.point.longitudeDegrees));
            this.minutesField.setText(String.valueOf(this.point.longitudeMinutes));
            this.secondsField.setText(AppCore.formatSeconds((double)this.point.longitudeSeconds));
        } else {
            this.directionMenu.setSelectedIndex(this.point.latitudeNS);
            this.degreesField.setText(String.valueOf(this.point.latitudeDegrees));
            this.minutesField.setText(String.valueOf(this.point.latitudeMinutes));
            this.secondsField.setText(AppCore.formatSeconds((double)this.point.latitudeSeconds));
        }
        this.blockActionsEnd();
    }

    public boolean isLongitude() {
        return this.isLongitude;
    }

    @Override
    public void setEnabled(boolean bl) {
        AppController.setComponentEnabled(this.directionMenu, bl);
        AppController.setComponentEnabled(this.degreesField, bl);
        AppController.setComponentEnabled(this.minutesField, bl);
        AppController.setComponentEnabled(this.secondsField, bl);
        this.enabled = bl;
    }
}

