/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ColorMap;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ColorMapEditor
extends AppDialog {
    public static final String WINDOW_TITLE = "Image Color Maps";
    private static final int COLOR_BUTTON_WIDTH = 48;
    private static final int COLOR_BUTTON_HEIGHT = 16;
    private static final int INDEX_CODE_NO_SERVICE = -1;
    private static final int INDEX_CODE_INTERFERENCE = -2;
    private static final int INDEX_CODE_BACKGROUND = -3;
    private static final int LOAD_NEW = 0;
    private static final int LOAD_DEFAULT = -1;
    private static final int LOAD_COPY = -2;
    private KeyedRecordMenu colorMapMenu = new KeyedRecordMenu();
    private JButton deleteButton;
    private ColorMap map;
    private boolean didEdit;
    private ColorPanel backgroundPanel;
    private ColorPanel[] colorPanels;
    private JPanel mapColorsPanel;
    private JButton addButton;
    private JButton removeButton;
    private ColorPanel noServicePanel;
    private ColorPanel interferencePanel;
    private JTextField nameField;
    private JButton saveButton;

    public ColorMapEditor(AppEditor appEditor) {
        super(appEditor, WINDOW_TITLE, Dialog.ModalityType.MODELESS);
        this.colorMapMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ColorMapEditor.this.blockActions()) {
                    int n = ColorMapEditor.this.colorMapMenu.getSelectedKey();
                    if (ColorMapEditor.this.doSave(true)) {
                        ColorMapEditor.this.doLoad(n);
                    }
                    ColorMapEditor.this.blockActionsEnd();
                }
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setFocusable(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ColorMapEditor.this.blockActions()) {
                    ColorMapEditor.this.doDelete();
                    ColorMapEditor.this.blockActionsEnd();
                }
            }
        });
        JButton jButton = new JButton("New");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ColorMapEditor.this.blockActions()) {
                    if (ColorMapEditor.this.doSave(true)) {
                        ColorMapEditor.this.doLoad(0);
                    }
                    ColorMapEditor.this.blockActionsEnd();
                }
            }
        });
        JButton jButton2 = new JButton("Duplicate");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ColorMapEditor.this.blockActions()) {
                    if (ColorMapEditor.this.doSave(true)) {
                        ColorMapEditor.this.doLoad(-2);
                    }
                    ColorMapEditor.this.blockActionsEnd();
                }
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.colorMapMenu);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(this.deleteButton);
        this.backgroundPanel = new ColorPanel(-3);
        this.colorPanels = new ColorPanel[20];
        this.mapColorsPanel = new JPanel();
        this.mapColorsPanel.setLayout(new BoxLayout(this.mapColorsPanel, 1));
        this.mapColorsPanel.add(this.backgroundPanel);
        this.addButton = new JButton("Add");
        this.addButton.setFocusable(false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorMapEditor.this.doAddColor();
            }
        });
        this.removeButton = new JButton("Remove");
        this.removeButton.setFocusable(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorMapEditor.this.doRemoveColor();
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.addButton);
        jPanel3.add(this.removeButton);
        this.noServicePanel = new ColorPanel(-1);
        this.interferencePanel = new ColorPanel(-2);
        this.nameField = new JTextField(15);
        AppController.fixKeyBindings(this.nameField);
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ColorMapEditor.this.nameField.getText().trim();
                if (!string.equals(((ColorMapEditor)ColorMapEditor.this).map.name)) {
                    ((ColorMapEditor)ColorMapEditor.this).map.name = string;
                    ColorMapEditor.this.setDidEdit();
                }
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ColorMapEditor.this.setCurrentField(ColorMapEditor.this.nameField);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    ColorMapEditor.this.nameField.postActionEvent();
                }
            }
        });
        this.saveButton = new JButton("Save");
        this.saveButton.setFocusable(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ColorMapEditor.this.blockActions()) {
                    if (ColorMapEditor.this.doSave(false)) {
                        ColorMapEditor.this.updateMenu(true);
                    }
                    ColorMapEditor.this.blockActionsEnd();
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.nameField);
        jPanel4.add(this.saveButton);
        Box box = Box.createVerticalBox();
        box.add(jPanel);
        box.add(jPanel2);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.add(this.mapColorsPanel);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder("Color Lookup"));
        jPanel6.add((Component)AppController.createScrollPane(jPanel5), "Center");
        jPanel6.add((Component)jPanel3, "South");
        Box box2 = Box.createVerticalBox();
        box2.add(this.noServicePanel);
        box2.add(this.interferencePanel);
        box2.add(jPanel4);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)box, "North");
        container.add((Component)jPanel6, "Center");
        container.add((Component)box2, "South");
        this.pack();
        Dimension dimension = this.getSize();
        dimension.height = 520;
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.setResizable(true);
        this.setLocationSaved(true);
        this.updateDocumentName();
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
    }

    private void doAddColor() {
        if (!this.commitCurrentField()) {
            return;
        }
        if (this.map.addColor() < 0) {
            return;
        }
        this.setDidEdit();
        this.updatePanels(false);
    }

    private void doRemoveColor() {
        if (!this.commitCurrentField()) {
            return;
        }
        this.map.removeColor();
        this.setDidEdit();
        this.updatePanels(false);
    }

    private void updateMenu(boolean bl) {
        String string = this.errorReporter.getTitle();
        this.errorReporter.setTitle("Load Color Maps");
        this.colorMapMenu.removeAllItems();
        ArrayList arrayList = ColorMap.getColorMaps((String)this.getDbID(), (ErrorLogger)this.errorReporter);
        if (null != arrayList) {
            this.colorMapMenu.addAllItems(arrayList);
        }
        if (bl) {
            if (!this.colorMapMenu.containsKey(this.map.key)) {
                this.colorMapMenu.addItem(new KeyedRecord(this.map.key, this.map.name));
                this.didEdit = true;
            }
            this.colorMapMenu.setSelectedKey(this.map.key);
        }
        this.errorReporter.setTitle(string);
    }

    private void updatePanels(boolean bl) {
        int n;
        boolean bl2;
        boolean bl3 = bl2 = !this.map.isPermanent;
        if (bl) {
            this.nameField.setText(this.map.name);
        }
        AppController.setComponentEnabled(this.nameField, bl2);
        if (this.colorPanels.length < this.map.colorCount) {
            n = this.colorPanels.length + 20;
            ColorPanel[] colorPanelArray = new ColorPanel[n];
            for (int i = 0; i < this.colorPanels.length; ++i) {
                colorPanelArray[i] = this.colorPanels[i];
            }
            this.colorPanels = colorPanelArray;
        }
        for (n = this.map.colorCount; n < this.colorPanels.length; ++n) {
            if (null == this.colorPanels[n]) continue;
            this.colorPanels[n].setVisible(false);
        }
        this.backgroundPanel.updatePanel(bl);
        this.backgroundPanel.setEnabled(bl2);
        for (n = 0; n < this.map.colorCount; ++n) {
            if (null == this.colorPanels[n]) {
                this.colorPanels[n] = new ColorPanel(n);
                this.mapColorsPanel.add(this.colorPanels[n]);
                this.colorPanels[n].updatePanel(true);
            } else if (!this.colorPanels[n].isVisible()) {
                this.colorPanels[n].setVisible(true);
                this.colorPanels[n].updatePanel(true);
            } else {
                this.colorPanels[n].updatePanel(bl);
            }
            this.colorPanels[n].setEnabled(bl2);
        }
        this.noServicePanel.updatePanel(bl);
        this.noServicePanel.setEnabled(bl2);
        this.interferencePanel.updatePanel(bl);
        this.interferencePanel.setEnabled(bl2);
        this.updateControls();
    }

    private void updateControls() {
        boolean bl = !this.map.isPermanent;
        this.deleteButton.setEnabled(bl);
        this.saveButton.setEnabled(bl && this.didEdit);
        this.addButton.setEnabled(bl && this.map.colorCount < 50);
        this.removeButton.setEnabled(bl && this.map.colorCount > 1);
    }

    @Override
    public void setDidEdit() {
        if (!this.didEdit && null != this.map && !this.map.isPermanent) {
            this.didEdit = true;
            this.saveButton.setEnabled(true);
        }
    }

    private void doLoad(int n) {
        this.updateMenu(false);
        switch (n) {
            case 0: {
                this.map = new ColorMap(0);
                this.didEdit = true;
                break;
            }
            case -2: {
                this.map = this.map.copy();
                this.didEdit = true;
                break;
            }
            case -1: {
                n = this.colorMapMenu.getSelectedKey();
            }
            default: {
                this.map = ColorMap.getColorMap((String)this.getDbID(), (int)n, (ErrorLogger)this.errorReporter);
                if (null == this.map) {
                    this.map = new ColorMap(0);
                    this.didEdit = true;
                    break;
                }
                this.didEdit = false;
            }
        }
        if (!this.colorMapMenu.containsKey(this.map.key)) {
            this.colorMapMenu.addItem(new KeyedRecord(this.map.key, this.map.name));
            this.didEdit = true;
        }
        this.colorMapMenu.setSelectedKey(this.map.key);
        this.updatePanels(true);
    }

    private boolean doSave(boolean bl) {
        boolean bl2;
        if (!this.commitCurrentField()) {
            return false;
        }
        if (!this.didEdit || this.map.isPermanent) {
            return true;
        }
        String string = "Save Color Map";
        this.errorReporter.setTitle(string);
        if (bl) {
            AppController.beep();
            int bl22 = JOptionPane.showConfirmDialog(this, "Data modified, do you want to save the changes?", string, 1, 3);
            if (1 == bl22) {
                return true;
            }
            if (2 == bl22) {
                return false;
            }
        }
        this.didEdit = !(bl2 = this.map.save(this.getDbID(), (ErrorLogger)this.errorReporter));
        this.updateControls();
        return bl2;
    }

    private void doDelete() {
        if (this.map.isPermanent) {
            return;
        }
        if (this.map.key > 0 && !ColorMap.deleteColorMap((String)this.getDbID(), (int)this.map.key, (ErrorLogger)this.errorReporter)) {
            return;
        }
        this.doLoad(-1);
    }

    @Override
    public boolean cancel() {
        if (!this.isVisible()) {
            return true;
        }
        if (this.windowShouldClose()) {
            AppController.hideWindow(this);
            return true;
        }
        return false;
    }

    @Override
    public void windowWillOpen() {
        this.blockActionsClear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorMapEditor.this.blockActionsStart();
                ColorMapEditor.this.doLoad(-1);
                ColorMapEditor.this.blockActionsEnd();
            }
        });
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        this.blockActionsStart();
        boolean bl = this.doSave(true);
        this.blockActionsEnd();
        return bl;
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        this.blockActionsSet();
        this.didEdit = false;
    }

    private class ColorButtonIcon
    implements Icon {
        private int colorIndex;

        private ColorButtonIcon(int n) {
            this.colorIndex = n;
        }

        @Override
        public int getIconWidth() {
            return 48;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color;
            switch (this.colorIndex) {
                case -1: {
                    color = ((ColorMapEditor)ColorMapEditor.this).map.noServiceColor;
                    break;
                }
                case -2: {
                    color = ((ColorMapEditor)ColorMapEditor.this).map.interferenceColor;
                    break;
                }
                case -3: {
                    color = ((ColorMapEditor)ColorMapEditor.this).map.backgroundColor;
                    break;
                }
                default: {
                    color = ((ColorMapEditor)ColorMapEditor.this).map.colors[this.colorIndex];
                }
            }
            if (null != color) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(color);
                double d = 48.0;
                double d2 = 16.0;
                double d3 = d / 8.0;
                graphics2D.fill(new RoundRectangle2D.Double(n, n2, d, d2, d3, d3));
            }
        }
    }

    private class ColorPanel
    extends JPanel {
        private int colorIndex;
        private Color color;
        private JButton colorButton;
        private JCheckBox optionCheckBox;
        private JTextField levelField;
        private JLabel rangeLabel;
        private boolean enabled;

        private ColorPanel(int n) {
            this.colorIndex = n;
            this.color = ColorMap.DEFAULT_COLOR;
            this.enabled = true;
            this.setLayout(new FlowLayout(0));
            this.colorButton = new JButton(new ColorButtonIcon(n));
            this.colorButton.setFocusable(false);
            this.colorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!ColorMapEditor.this.commitCurrentField()) {
                        return;
                    }
                    Color color = JColorChooser.showDialog(ColorPanel.this.colorButton, "Pick Color: " + ColorPanel.this.getDescription(), ColorPanel.this.color);
                    if (null != color) {
                        ColorPanel.this.color = color;
                        switch (ColorPanel.this.colorIndex) {
                            case -1: {
                                ((ColorMapEditor)ColorMapEditor.this).map.noServiceColor = color;
                                break;
                            }
                            case -2: {
                                ((ColorMapEditor)ColorMapEditor.this).map.interferenceColor = color;
                                break;
                            }
                            case -3: {
                                ((ColorMapEditor)ColorMapEditor.this).map.backgroundColor = color;
                                break;
                            }
                            default: {
                                ((ColorMapEditor)ColorMapEditor.this).map.colors[((ColorPanel)ColorPanel.this).colorIndex] = color;
                            }
                        }
                        ColorPanel.this.colorButton.repaint();
                        ColorMapEditor.this.setDidEdit();
                    }
                }
            });
            this.add(this.colorButton);
            switch (this.colorIndex) {
                case -1: {
                    this.optionCheckBox = new JCheckBox("Set color for no service");
                    break;
                }
                case -2: {
                    this.optionCheckBox = new JCheckBox("Set color for interference");
                    break;
                }
                case -3: {
                    break;
                }
                default: {
                    this.levelField = new JTextField(5);
                    AppController.fixKeyBindings(this.levelField);
                    this.levelField.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = "Edit Level";
                            String string2 = ColorPanel.this.levelField.getText().trim();
                            if (string2.length() > 0) {
                                double d = ((ColorMapEditor)ColorMapEditor.this).map.levels[ColorPanel.this.colorIndex];
                                try {
                                    d = Double.parseDouble(string2);
                                    d = Math.rint(d * 100.0) / 100.0;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    ColorMapEditor.this.errorReporter.reportValidationError(string, "The color change level must be a number");
                                }
                                if (d != ((ColorMapEditor)ColorMapEditor.this).map.levels[ColorPanel.this.colorIndex]) {
                                    double d2 = 0 == ColorPanel.this.colorIndex ? -40.0 : ((ColorMapEditor)ColorMapEditor.this).map.levels[ColorPanel.this.colorIndex - 1];
                                    double d3 = ((ColorMapEditor)ColorMapEditor.this).map.colorCount - 1 == ColorPanel.this.colorIndex ? 100.0 : ((ColorMapEditor)ColorMapEditor.this).map.levels[ColorPanel.this.colorIndex + 1];
                                    if (d <= d2 || d >= d3) {
                                        ColorMapEditor.this.errorReporter.reportValidationError(string, "The color change level must be between " + d2 + " and " + d3);
                                    } else {
                                        ((ColorMapEditor)ColorMapEditor.this).map.levels[((ColorPanel)ColorPanel.this).colorIndex] = d;
                                        ColorMapEditor.this.setDidEdit();
                                    }
                                }
                            }
                            ColorPanel.this.levelField.setText(AppCore.formatDecimal((double)((ColorMapEditor)ColorMapEditor.this).map.levels[ColorPanel.this.colorIndex], (int)2));
                            if (0 == ColorPanel.this.colorIndex) {
                                ColorMapEditor.this.backgroundPanel.updatePanel(false);
                            } else {
                                ColorMapEditor.this.colorPanels[ColorPanel.this.colorIndex - 1].updatePanel(false);
                            }
                        }
                    });
                    this.levelField.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent focusEvent) {
                            ColorMapEditor.this.setCurrentField(ColorPanel.this.levelField);
                        }

                        @Override
                        public void focusLost(FocusEvent focusEvent) {
                            if (!focusEvent.isTemporary()) {
                                ColorPanel.this.levelField.postActionEvent();
                            }
                        }
                    });
                    this.add(this.levelField);
                }
            }
            if (null != this.optionCheckBox) {
                this.optionCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ColorPanel.this.optionCheckBox.isSelected()) {
                            ColorPanel.this.colorButton.setEnabled(ColorPanel.this.enabled);
                            switch (ColorPanel.this.colorIndex) {
                                case -1: {
                                    ((ColorMapEditor)ColorMapEditor.this).map.noServiceColor = ColorPanel.this.color;
                                    break;
                                }
                                case -2: {
                                    ((ColorMapEditor)ColorMapEditor.this).map.interferenceColor = ColorPanel.this.color;
                                }
                            }
                        } else {
                            ColorPanel.this.colorButton.setEnabled(false);
                            switch (ColorPanel.this.colorIndex) {
                                case -1: {
                                    ((ColorMapEditor)ColorMapEditor.this).map.noServiceColor = null;
                                    break;
                                }
                                case -2: {
                                    ((ColorMapEditor)ColorMapEditor.this).map.interferenceColor = null;
                                }
                            }
                        }
                        ColorMapEditor.this.setDidEdit();
                    }
                });
                this.add(this.optionCheckBox);
            } else {
                this.rangeLabel = new JLabel();
                this.add(this.rangeLabel);
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            this.enabled = bl;
            if (null != this.optionCheckBox) {
                AppController.setComponentEnabled(this.optionCheckBox, this.enabled);
                this.colorButton.setEnabled(this.enabled && this.optionCheckBox.isSelected());
            } else {
                this.colorButton.setEnabled(this.enabled);
            }
            if (null != this.levelField) {
                AppController.setComponentEnabled(this.levelField, this.enabled);
            }
        }

        private void updatePanel(boolean bl) {
            Color color = null;
            switch (this.colorIndex) {
                case -1: {
                    color = ((ColorMapEditor)ColorMapEditor.this).map.noServiceColor;
                    if (null == color) {
                        this.optionCheckBox.setSelected(false);
                        break;
                    }
                    this.optionCheckBox.setSelected(true);
                    break;
                }
                case -2: {
                    color = ((ColorMapEditor)ColorMapEditor.this).map.interferenceColor;
                    if (null == color) {
                        this.optionCheckBox.setSelected(false);
                        break;
                    }
                    this.optionCheckBox.setSelected(true);
                    break;
                }
                case -3: {
                    color = ((ColorMapEditor)ColorMapEditor.this).map.backgroundColor;
                    this.rangeLabel.setText(" below " + AppCore.formatDecimal((double)((ColorMapEditor)ColorMapEditor.this).map.levels[0], (int)2));
                    break;
                }
                default: {
                    color = ((ColorMapEditor)ColorMapEditor.this).map.colors[this.colorIndex];
                    this.levelField.setText(AppCore.formatDecimal((double)((ColorMapEditor)ColorMapEditor.this).map.levels[this.colorIndex], (int)2));
                    if (this.colorIndex < ((ColorMapEditor)ColorMapEditor.this).map.colorCount - 1) {
                        this.rangeLabel.setText(" to " + AppCore.formatDecimal((double)((ColorMapEditor)ColorMapEditor.this).map.levels[this.colorIndex + 1], (int)2));
                        break;
                    }
                    this.rangeLabel.setText(" and above");
                }
            }
            this.colorButton.setEnabled(this.enabled && null != color);
            if (bl) {
                this.color = null != color ? color : ColorMap.DEFAULT_COLOR;
                this.colorButton.repaint();
            }
        }

        private String getDescription() {
            switch (this.colorIndex) {
                case -1: {
                    return "No service";
                }
                case -2: {
                    return "Interference";
                }
                case -3: {
                    return "Below " + AppCore.formatDecimal((double)((ColorMapEditor)ColorMapEditor.this).map.levels[0], (int)2);
                }
            }
            String string = AppCore.formatDecimal((double)((ColorMapEditor)ColorMapEditor.this).map.levels[this.colorIndex], (int)2);
            if (this.colorIndex < ((ColorMapEditor)ColorMapEditor.this).map.colorCount - 1) {
                return string + " to " + AppCore.formatDecimal((double)((ColorMapEditor)ColorMapEditor.this).map.levels[this.colorIndex + 1], (int)2);
            }
            return string + " and above";
        }
    }
}

