/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class TextInputDialog
extends AppDialog {
    public static final int DEFAULT_ROWS = 5;
    public static final int DEFAULT_COLUMNS = 40;
    private JTextArea inputArea;
    public boolean canceled;
    private TextInputDialog outerThis = this;

    public TextInputDialog(AppEditor appEditor, String string, String string2) {
        super(appEditor, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.doSetup(string2, 5, 40);
    }

    public TextInputDialog(AppEditor appEditor, String string, String string2, int n, int n2) {
        super(appEditor, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.doSetup(string2, n, n2);
    }

    private void doSetup(String string, int n, int n2) {
        this.inputArea = new JTextArea(n, n2);
        AppController.fixKeyBindings(this.inputArea);
        this.inputArea.setLineWrap(true);
        this.inputArea.setWrapStyleWord(true);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        jPanel.add(AppController.createScrollPane(this.inputArea));
        JButton jButton = new JButton("OK");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppController.hideWindow(TextInputDialog.this.outerThis);
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextInputDialog.this.canceled = true;
                AppController.hideWindow(TextInputDialog.this.outerThis);
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(jButton2);
        jPanel2.add(jButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void setInput(String string) {
        this.inputArea.setText(string);
    }

    public String getInput() {
        if (this.canceled) {
            return null;
        }
        return this.inputArea.getText().trim();
    }

    @Override
    public void windowWillOpen() {
        this.inputArea.requestFocusInWindow();
        this.blockActionsClear();
    }

    @Override
    public boolean windowShouldClose() {
        this.canceled = true;
        return true;
    }

    @Override
    public void windowWillClose() {
        this.blockActionsSet();
    }
}

