/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.data.Template;
import gov.fcc.tvstudy.core.editdata.TemplateEditData;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppFrame;
import gov.fcc.tvstudy.gui.BackgroundWorker;
import gov.fcc.tvstudy.gui.DbController;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.ExtDbManager;
import gov.fcc.tvstudy.gui.StudyManager;
import gov.fcc.tvstudy.gui.editor.TemplateEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class TemplateManager
extends AppFrame {
    public static final String WINDOW_TITLE = "Template Manager";
    private String dbID;
    private TemplateListModel templateModel;
    private JTable templateTable;
    private HashMap<Integer, TemplateEditor> templateEditors;
    private JButton duplicateTemplateButton;
    private JButton exportTemplateButton;
    private JButton openTemplateButton;
    private JMenuItem openTemplateMenuItem;
    private JMenuItem renameTemplateMenuItem;
    private JMenuItem duplicateTemplateMenuItem;
    private JMenuItem deleteTemplateMenuItem;
    private JMenuItem exportTemplateMenuItem;
    private JMenuItem templateInfoMenuItem;
    private static HashMap<String, TemplateManager> managers = new HashMap();

    public static boolean showManager(String string) {
        TemplateManager templateManager = managers.get(string);
        if (null != templateManager) {
            templateManager.toFront();
            return true;
        }
        if (DbCore.isDbRegistered((String)string)) {
            templateManager = new TemplateManager(string);
            managers.put(string, templateManager);
            AppController.showWindow(templateManager);
            return true;
        }
        return false;
    }

    private TemplateManager(String string) {
        super(null, WINDOW_TITLE);
        this.dbID = string;
        this.templateModel = new TemplateListModel();
        this.templateTable = this.templateModel.createTable();
        this.templateTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TemplateManager.this.updateControls();
            }
        });
        this.templateTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    TemplateManager.this.doOpenTemplate();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Templates"));
        jPanel.add((Component)AppController.createScrollPane(this.templateTable), "Center");
        this.templateEditors = new HashMap();
        this.duplicateTemplateButton = new JButton("Duplicate");
        this.duplicateTemplateButton.setFocusable(false);
        this.duplicateTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doDuplicateTemplate();
            }
        });
        JButton jButton = new JButton("Import");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doImportTemplate();
            }
        });
        this.exportTemplateButton = new JButton("Export");
        this.exportTemplateButton.setFocusable(false);
        this.exportTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doExportTemplate();
            }
        });
        this.openTemplateButton = new JButton("Open");
        this.openTemplateButton.setFocusable(false);
        this.openTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doOpenTemplate();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.duplicateTemplateButton);
        jPanel2.add(jButton);
        jPanel2.add(this.exportTemplateButton);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.openTemplateButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel4, "South");
        this.pack();
        Dimension dimension = new Dimension(500, 400);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.fileMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Previous");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doPrevious();
            }
        });
        this.fileMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Next");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(40, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doNext();
            }
        });
        this.fileMenu.add(jMenuItem2);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Refresh List");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.updateTemplateList(true);
            }
        });
        this.fileMenu.add(jMenuItem3);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Import...");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doImportTemplate();
            }
        });
        this.fileMenu.add(jMenuItem4);
        this.exportTemplateMenuItem = new JMenuItem("Export...");
        this.exportTemplateMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, AppController.MENU_SHORTCUT_KEY_MASK));
        this.exportTemplateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doExportTemplate();
            }
        });
        this.fileMenu.add(this.exportTemplateMenuItem);
        this.fileMenu.addSeparator();
        this.openTemplateMenuItem = new JMenuItem("Open");
        this.openTemplateMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppController.MENU_SHORTCUT_KEY_MASK));
        this.openTemplateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doOpenTemplate();
            }
        });
        this.fileMenu.add(this.openTemplateMenuItem);
        this.renameTemplateMenuItem = new JMenuItem("Rename...");
        this.renameTemplateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doRenameTemplate();
            }
        });
        this.fileMenu.add(this.renameTemplateMenuItem);
        this.duplicateTemplateMenuItem = new JMenuItem("Duplicate...");
        this.duplicateTemplateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doDuplicateTemplate();
            }
        });
        this.fileMenu.add(this.duplicateTemplateMenuItem);
        this.deleteTemplateMenuItem = new JMenuItem("Delete");
        this.deleteTemplateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doDeleteTemplate();
            }
        });
        this.fileMenu.add(this.deleteTemplateMenuItem);
        this.fileMenu.addSeparator();
        this.templateInfoMenuItem = new JMenuItem("Get Info");
        this.templateInfoMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, AppController.MENU_SHORTCUT_KEY_MASK));
        this.templateInfoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.this.doTemplateInfo();
            }
        });
        this.fileMenu.add(this.templateInfoMenuItem);
        this.extraMenu.removeAll();
        JMenuItem jMenuItem5 = new JMenuItem("Study Manager");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.showManager(TemplateManager.this.dbID);
            }
        });
        this.extraMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("Station Data Manager");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbManager.showManager(TemplateManager.this.dbID);
            }
        });
        this.extraMenu.add(jMenuItem6);
        this.updateControls();
        this.updateDocumentName();
    }

    @Override
    public String getDbID() {
        return this.dbID;
    }

    @Override
    protected String getFileMenuName() {
        return "Template";
    }

    @Override
    protected boolean showsEditMenu() {
        return false;
    }

    @Override
    protected boolean showsExtraMenu() {
        return true;
    }

    @Override
    protected String getExtraMenuName() {
        return "Database";
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(DbCore.getHostDbName((String)this.dbID));
    }

    private void updateControls() {
        int n = this.templateTable.getSelectedRow();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (n >= 0) {
            bl = true;
            bl3 = true;
            bl6 = true;
            TemplateListItem templateListItem = this.templateModel.get(this.templateTable.convertRowIndexToModel(n));
            if (!templateListItem.isPermanent) {
                if (!this.templateEditors.containsKey(templateListItem.key)) {
                    bl2 = true;
                }
                if (0 == templateListItem.useCount) {
                    bl4 = true;
                }
                bl5 = true;
            }
        }
        this.duplicateTemplateButton.setEnabled(bl3);
        this.exportTemplateButton.setEnabled(bl5);
        this.openTemplateButton.setEnabled(bl);
        this.openTemplateMenuItem.setEnabled(bl);
        this.renameTemplateMenuItem.setEnabled(bl2);
        this.duplicateTemplateMenuItem.setEnabled(bl3);
        this.deleteTemplateMenuItem.setEnabled(bl4);
        this.exportTemplateMenuItem.setEnabled(bl5);
        this.templateInfoMenuItem.setEnabled(bl6);
    }

    public static void updateTemplates(String string) {
        TemplateManager templateManager = managers.get(string);
        if (null != templateManager && templateManager.isVisible()) {
            templateManager.updateTemplateList(true);
        }
    }

    private void updateTemplateList(boolean bl) {
        int n;
        String string = this.errorReporter.getTitle();
        this.errorReporter.setTitle("Load Template List");
        ArrayList<TemplateListItem> arrayList = this.getItems(this.errorReporter);
        if (null == arrayList) {
            this.errorReporter.setTitle(string);
            return;
        }
        TemplateListItem templateListItem = null;
        if (bl && (n = this.templateTable.getSelectedRow()) >= 0) {
            templateListItem = this.templateModel.get(this.templateTable.convertRowIndexToModel(n));
        }
        this.templateModel.setItems(arrayList);
        if (templateListItem != null && (n = this.templateModel.indexOf(templateListItem)) >= 0) {
            n = this.templateTable.convertRowIndexToView(n);
            this.templateTable.setRowSelectionInterval(n, n);
            this.templateTable.scrollRectToVisible(this.templateTable.getCellRect(n, 0, true));
        }
        this.updateControls();
        this.errorReporter.setTitle(string);
    }

    private ArrayList<TemplateListItem> getItems(ErrorReporter errorReporter) {
        ArrayList<TemplateListItem> arrayList = new ArrayList<TemplateListItem>();
        DbConnection dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)errorReporter);
        if (null != dbConnection) {
            try {
                boolean bl;
                boolean bl2 = true;
                do {
                    bl = false;
                    arrayList.clear();
                    if (bl2) {
                        dbConnection.query("SELECT template_key, name, permanent, locked, locked_in_study, (SELECT COUNT(*) FROM study WHERE template_key = template.template_key), hidden FROM template WHERE (hidden IS NULL) OR (hidden <= NOW()) ORDER BY 1");
                    } else {
                        dbConnection.query("SELECT template_key, name, permanent, locked, locked_in_study, (SELECT COUNT(*) FROM study WHERE template_key = template.template_key) FROM template WHERE (hidden IS NULL) ORDER BY 1");
                    }
                    while (dbConnection.next()) {
                        if (bl2 && null != dbConnection.getDate(7)) {
                            bl = true;
                            break;
                        }
                        TemplateListItem templateListItem = new TemplateListItem();
                        templateListItem.key = dbConnection.getInt(1);
                        templateListItem.name = dbConnection.getString(2);
                        templateListItem.isPermanent = dbConnection.getBoolean(3);
                        templateListItem.isLocked = dbConnection.getBoolean(4);
                        templateListItem.isLockedInStudy = dbConnection.getBoolean(5);
                        templateListItem.useCount = dbConnection.getInt(6);
                        arrayList.add(templateListItem);
                    }
                    bl2 = false;
                    if (!bl) continue;
                    Template.checkHiddenTemplates((DbConnection)dbConnection);
                } while (bl);
                DbCore.releaseDb((DbConnection)dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb((DbConnection)dbConnection);
                DbConnection.reportError((ErrorLogger)errorReporter, (SQLException)sQLException);
            }
        }
        return arrayList;
    }

    private TemplateListItem checkTemplate(int n, ErrorReporter errorReporter) {
        TemplateListItem templateListItem = this.templateModel.get(n);
        boolean bl = false;
        boolean bl2 = false;
        DbConnection dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)errorReporter);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT name, permanent, locked, locked_in_study, (SELECT COUNT(*) FROM study WHERE template_key = template.template_key) FROM template WHERE template_key = " + templateListItem.key);
                if (dbConnection.next()) {
                    templateListItem.name = dbConnection.getString(1);
                    templateListItem.isPermanent = dbConnection.getBoolean(2);
                    templateListItem.isLocked = dbConnection.getBoolean(3);
                    templateListItem.isLockedInStudy = dbConnection.getBoolean(4);
                    templateListItem.useCount = dbConnection.getInt(5);
                } else {
                    bl2 = true;
                }
                DbCore.releaseDb((DbConnection)dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb((DbConnection)dbConnection);
                bl = true;
                DbConnection.reportError((ErrorLogger)errorReporter, (SQLException)sQLException);
            }
        } else {
            return null;
        }
        if (bl2) {
            if (null != errorReporter) {
                errorReporter.reportError("The template no longer exists");
            }
            this.templateModel.remove(n);
            return null;
        }
        if (bl) {
            return null;
        }
        this.templateModel.itemWasChanged(n);
        return templateListItem;
    }

    private void doPrevious() {
        int n = this.templateTable.getRowCount();
        int n2 = this.templateTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.templateTable.setRowSelectionInterval(n2, n2);
            this.templateTable.scrollRectToVisible(this.templateTable.getCellRect(n2, 0, true));
        }
    }

    private void doNext() {
        int n = this.templateTable.getRowCount();
        int n2 = this.templateTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.templateTable.setRowSelectionInterval(n2, n2);
            this.templateTable.scrollRectToVisible(this.templateTable.getCellRect(n2, 0, true));
        }
    }

    private void doImportTemplate() {
        String string = "Import Template";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML (*.xml)", "xml"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (0 != jFileChooser.showDialog(this, "Import")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorReporter.reportError("Could not open the file:\n" + fileNotFoundException.getMessage());
            return;
        }
        final BufferedReader bufferedReader = new BufferedReader(fileReader);
        BackgroundWorker<Integer> backgroundWorker = new BackgroundWorker<Integer>((Window)this, string){

            @Override
            protected Integer doBackgroundWork(ErrorLogger errorLogger) {
                return TemplateEditData.readTemplateFromXML((String)TemplateManager.this.dbID, (Reader)bufferedReader, (ErrorLogger)errorLogger);
            }
        };
        Integer n = (Integer)backgroundWorker.runWork("Importing template, please wait...", this.errorReporter);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null == n) {
            return;
        }
        this.updateTemplateList(false);
        int n2 = this.templateModel.indexOfKey(n);
        if (n2 >= 0) {
            n2 = this.templateTable.convertRowIndexToView(n2);
            this.templateTable.setRowSelectionInterval(n2, n2);
            this.templateTable.scrollRectToVisible(this.templateTable.getCellRect(n2, 0, true));
        }
    }

    private void doExportTemplate() {
        int n = this.templateTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = "Export Template";
        this.errorReporter.setTitle(string);
        TemplateListItem templateListItem = this.checkTemplate(this.templateTable.convertRowIndexToModel(n), this.errorReporter);
        if (null == templateListItem) {
            return;
        }
        if (templateListItem.isPermanent) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML (*.xml)", "xml"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Export")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            String string2 = file.getName();
            if (!string2.toLowerCase().endsWith(".xml")) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            if (!file.exists()) continue;
            AppController.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        TemplateEditData.writeTemplateToXML((String)this.dbID, (int)templateListItem.key, (Writer)bufferedWriter, (ErrorLogger)this.errorReporter);
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doOpenTemplate() {
        Template template;
        int n = this.templateTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = "Open Template";
        this.errorReporter.setTitle(string);
        TemplateListItem templateListItem = this.checkTemplate(this.templateTable.convertRowIndexToModel(n), this.errorReporter);
        if (null == templateListItem) {
            return;
        }
        TemplateEditor templateEditor = this.templateEditors.get(templateListItem.key);
        if (null != templateEditor) {
            if (templateEditor.isVisible()) {
                templateEditor.toFront();
                return;
            }
            this.templateEditors.remove(templateListItem.key);
        }
        if (null == (template = Template.getTemplate((String)this.dbID, (int)templateListItem.key, (ErrorLogger)this.errorReporter))) {
            return;
        }
        try {
            TemplateEditData templateEditData = new TemplateEditData(this.dbID, template);
            templateEditor = new TemplateEditor((AppEditor)this, templateEditData);
        }
        catch (Throwable throwable) {
            AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
            this.errorReporter.reportError("Unexpected error:\n" + throwable);
            return;
        }
        AppController.showWindow(templateEditor);
        this.templateEditors.put(templateListItem.key, templateEditor);
        this.updateControls();
    }

    private void doRenameTemplate() {
        int n = this.templateTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = "Rename Template";
        this.errorReporter.setTitle(string);
        TemplateListItem templateListItem = this.checkTemplate(this.templateTable.convertRowIndexToModel(n), this.errorReporter);
        if (null == templateListItem || templateListItem.isPermanent || this.templateEditors.containsKey(templateListItem.key)) {
            return;
        }
        String string2 = "";
        do {
            if (null == (string2 = (String)JOptionPane.showInputDialog(this, "Enter a new name for the template", string, 3, null, null, templateListItem.name))) {
                return;
            }
            if (!(string2 = string2.trim()).equals(templateListItem.name)) continue;
            return;
        } while (!Template.checkTemplateName((String)this.dbID, (String)string2, (String)templateListItem.name, (ErrorLogger)this.errorReporter));
        Template.renameTemplate((String)this.dbID, (int)templateListItem.key, (String)string2, (ErrorLogger)this.errorReporter);
        this.updateTemplateList(true);
    }

    private void doDuplicateTemplate() {
        String string;
        int n = this.templateTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string2 = "Duplicate Template";
        this.errorReporter.setTitle(string2);
        TemplateListItem templateListItem = this.checkTemplate(this.templateTable.convertRowIndexToModel(n), this.errorReporter);
        if (null == templateListItem) {
            return;
        }
        String string3 = "";
        do {
            if (null != (string3 = (String)JOptionPane.showInputDialog(this, "Enter a name for the new template", string2, 3, null, null, templateListItem.name))) continue;
            return;
        } while (!Template.checkTemplateName((String)this.dbID, (String)(string3 = string3.trim()), (ErrorLogger)this.errorReporter));
        final int n2 = templateListItem.key;
        BackgroundWorker<Integer> backgroundWorker = new BackgroundWorker<Integer>((Window)this, string2, string = string3){
            final /* synthetic */ String val$newName;
            {
                this.val$newName = string2;
                super(window, string);
            }

            @Override
            protected Integer doBackgroundWork(ErrorLogger errorLogger) {
                return Template.duplicateTemplate((String)TemplateManager.this.dbID, (int)n2, (String)this.val$newName, (ErrorLogger)errorLogger);
            }
        };
        Integer n3 = (Integer)backgroundWorker.runWork("Duplicating template, please wait...", this.errorReporter);
        if (null == n3) {
            return;
        }
        this.updateTemplateList(false);
        n = this.templateModel.indexOfKey(n3);
        if (n < 0) {
            return;
        }
        n = this.templateTable.convertRowIndexToView(n);
        this.templateTable.setRowSelectionInterval(n, n);
        this.templateTable.scrollRectToVisible(this.templateTable.getCellRect(n, 0, true));
    }

    private void doDeleteTemplate() {
        int n = this.templateTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = "Delete Template";
        this.errorReporter.setTitle(string);
        TemplateListItem templateListItem = this.checkTemplate(this.templateTable.convertRowIndexToModel(n), this.errorReporter);
        if (null == templateListItem) {
            return;
        }
        if (templateListItem.isPermanent) {
            return;
        }
        AppController.beep();
        int n2 = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete template '" + templateListItem.name + "'?", string, 0, 2);
        if (0 != n2) {
            return;
        }
        TemplateEditor templateEditor = this.templateEditors.get(templateListItem.key);
        if (null != templateEditor) {
            if (templateEditor.isVisible() && !templateEditor.closeWithoutSave()) {
                this.errorReporter.reportWarning("Could not close editor window for the template\nPlease close the window manually and try again");
                templateEditor.toFront();
                return;
            }
            this.templateEditors.remove(templateListItem.key);
        }
        Template.deleteTemplate((String)this.dbID, (int)templateListItem.key, (ErrorLogger)this.errorReporter);
        this.updateTemplateList(false);
    }

    private void doTemplateInfo() {
        int n = this.templateTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = "Template Info";
        this.errorReporter.setTitle(string);
        TemplateListItem templateListItem = this.checkTemplate(this.templateTable.convertRowIndexToModel(n), this.errorReporter);
        if (null == templateListItem) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Name: ");
        stringBuilder.append(templateListItem.name);
        stringBuilder.append('\n');
        stringBuilder.append("Primary key: ");
        stringBuilder.append(String.valueOf(templateListItem.key));
        stringBuilder.append('\n');
        stringBuilder.append("Permanent: ");
        stringBuilder.append(templateListItem.isPermanent ? "Yes" : "No");
        stringBuilder.append('\n');
        stringBuilder.append("Locked: ");
        stringBuilder.append(templateListItem.isLocked ? "Yes" : "No");
        stringBuilder.append('\n');
        stringBuilder.append("Study locked: ");
        stringBuilder.append(templateListItem.isLockedInStudy ? "Yes" : "No");
        stringBuilder.append('\n');
        stringBuilder.append("Use count: ");
        stringBuilder.append(String.valueOf(templateListItem.useCount));
        stringBuilder.append('\n');
        AppController.showMessage(this, (Object)stringBuilder.toString(), "Template Info");
    }

    @Override
    public boolean applyEditsFrom(AppEditor appEditor) {
        if (appEditor instanceof TemplateEditor) {
            int n = this.templateModel.indexOfKey(((TemplateEditor)appEditor).getTemplateKey());
            if (n >= 0) {
                this.checkTemplate(n, null);
                this.updateControls();
            }
            return true;
        }
        return false;
    }

    @Override
    public void editorClosing(AppEditor appEditor) {
        if (appEditor instanceof TemplateEditor) {
            this.templateEditors.remove(((TemplateEditor)appEditor).getTemplateKey(), (TemplateEditor)appEditor);
            this.updateControls();
            return;
        }
    }

    @Override
    public void windowWillOpen() {
        if (this.isVisible()) {
            return;
        }
        DbCore.openDb((String)this.dbID, (Object)this);
        DbController.restoreColumnWidths(this.dbID, this.getKeyTitle(), this.templateTable);
        this.blockActionsClear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateManager.this.errorReporter.setTitle("Load Template List");
                TemplateManager.this.templateModel.setItems(TemplateManager.this.getItems(TemplateManager.this.errorReporter));
            }
        });
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        for (TemplateEditor templateEditor : this.templateEditors.values()) {
            if (templateEditor.closeIfPossible()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        DbController.saveColumnWidths(this.dbID, this.getKeyTitle(), this.templateTable);
        this.blockActionsSet();
        managers.remove(this.dbID);
        DbCore.closeDb((String)this.dbID, (Object)this);
    }

    private class TemplateListModel
    extends AbstractTableModel {
        private static final String TEMPLATE_NAME_COLUMN = "Name";
        private static final String TEMPLATE_LOCKED_COLUMN = "Locked";
        private static final String TEMPLATE_STUDY_LOCKED_COLUMN = "Study Locked";
        private static final String TEMPLATE_IN_USE_COLUMN = "In Use";
        private String[] columnNames = new String[]{"Name", "Locked", "Study Locked", "In Use"};
        private static final int TEMPLATE_NAME_INDEX = 0;
        private static final int TEMPLATE_LOCKED_INDEX = 1;
        private static final int TEMPLATE_STUDY_LOCKED_INDEX = 2;
        private static final int TEMPLATE_IN_USE_INDEX = 3;
        private ArrayList<TemplateListItem> modelRows = new ArrayList();

        private TemplateListModel() {
        }

        private JTable createTable() {
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable);
            TableColumn tableColumn = jTable.getColumn(TEMPLATE_NAME_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[20]);
            tableColumn = jTable.getColumn(TEMPLATE_LOCKED_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
            tableColumn = jTable.getColumn(TEMPLATE_STUDY_LOCKED_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
            tableColumn = jTable.getColumn(TEMPLATE_IN_USE_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
            return jTable;
        }

        private void setItems(ArrayList<TemplateListItem> arrayList) {
            this.modelRows.clear();
            this.modelRows.addAll(arrayList);
            this.fireTableDataChanged();
        }

        private TemplateListItem get(int n) {
            return this.modelRows.get(n);
        }

        private void remove(int n) {
            this.modelRows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        private void itemWasChanged(int n) {
            this.fireTableRowsUpdated(n, n);
        }

        private int indexOf(TemplateListItem templateListItem) {
            return this.modelRows.indexOf(templateListItem);
        }

        private int indexOfKey(Integer n) {
            int n2 = 0;
            for (TemplateListItem templateListItem : this.modelRows) {
                if (templateListItem.key.equals(n)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.modelRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TemplateListItem templateListItem = this.modelRows.get(n);
            switch (n2) {
                case 0: {
                    return templateListItem.name;
                }
                case 1: {
                    return templateListItem.isLocked ? "Yes" : "No";
                }
                case 2: {
                    return templateListItem.isLockedInStudy ? "Yes" : "No";
                }
                case 3: {
                    return templateListItem.useCount > 0 ? "Yes" : "No";
                }
            }
            return "";
        }
    }

    private class TemplateListItem {
        private Integer key;
        private String name;
        private boolean isPermanent;
        private boolean isLocked;
        private boolean isLockedInStudy;
        private int useCount;

        private TemplateListItem() {
        }
    }
}

