/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppFrame;
import java.awt.Window;
import javax.swing.JOptionPane;

public abstract class RootEditor
extends AppFrame {
    private boolean dataValid;
    private boolean validationErrorPending;
    private Window validationErrorParent;
    private String validationErrorTitle;
    private String validationErrorMessage;
    private int validationErrorType;

    public RootEditor(AppEditor appEditor, String string) {
        super(appEditor, string);
    }

    @Override
    public RootEditor getRootEditor() {
        return this;
    }

    protected boolean isDataValid(String string) {
        this.dataValid = true;
        return this.dataValid;
    }

    public void reportValidationError(Window window, String string, String string2, int n) {
        if (this.validationErrorPending) {
            return;
        }
        if (null == window) {
            window = this;
        }
        if (this.dataValid) {
            this.dataValid = false;
            this.validationErrorPending = true;
            this.validationErrorParent = window;
            this.validationErrorTitle = string;
            this.validationErrorMessage = string2;
            this.validationErrorType = n;
        } else if (null != string) {
            window.toFront();
            AppController.showMessage(window, string2, string, n);
        }
    }

    public boolean isValidationErrorPending() {
        return this.validationErrorPending;
    }

    private void displayValidationError() {
        if (null != this.validationErrorTitle) {
            this.validationErrorParent.toFront();
            AppController.showMessage(this.validationErrorParent, this.validationErrorMessage, this.validationErrorTitle, this.validationErrorType);
        }
        this.clearValidationError();
    }

    private void clearValidationError() {
        this.dataValid = false;
        this.validationErrorPending = false;
        this.validationErrorParent = null;
        this.validationErrorTitle = null;
        this.validationErrorMessage = null;
        this.validationErrorType = 0;
    }

    protected boolean save(String string) {
        boolean bl = this.dataValid;
        this.clearValidationError();
        return bl;
    }

    protected boolean isDataChanged() {
        return true;
    }

    public boolean saveIfNeeded(String string, boolean bl) {
        boolean bl2 = true;
        if (this.isDataValid(string)) {
            bl2 = this.isDataChanged();
        }
        if (bl2) {
            if (bl) {
                this.toFront();
                AppController.beep();
                int n = JOptionPane.showConfirmDialog(this, "Data modified, do you want to save the changes?", string, 1, 3);
                if (1 == n) {
                    this.clearValidationError();
                    return true;
                }
                if (!this.dataValid) {
                    this.displayValidationError();
                    return false;
                }
                if (2 == n) {
                    this.clearValidationError();
                    return false;
                }
            } else if (!this.dataValid) {
                this.displayValidationError();
                return false;
            }
            return this.save(string);
        }
        this.clearValidationError();
        return true;
    }
}

