/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbListener;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordFM;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.Parameter;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataFM;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.SourceEditDataWL;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppPanel;
import gov.fcc.tvstudy.gui.BackgroundWorker;
import gov.fcc.tvstudy.gui.CoordinateCopyPastePanel;
import gov.fcc.tvstudy.gui.DateSelectionPanel;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.SourceCompare;
import gov.fcc.tvstudy.gui.TextInputDialog;
import gov.fcc.tvstudy.gui.editor.CoordinatePanel;
import gov.fcc.tvstudy.gui.editor.SourceEditor;
import gov.fcc.tvstudy.gui.editor.TableFilterModel;
import gov.fcc.tvstudy.gui.editor.TableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;

public class RecordFindPanel
extends AppPanel
implements ExtDbListener {
    private int studyType;
    private int recordType;
    private boolean userRecordsOnly;
    private Integer defaultExtDbKey;
    private int minimumTVChannel;
    private int maximumTVChannel;
    private StudyEditData study;
    private KeyedRecordMenu searchRecordTypeMenu;
    private KeyedRecordMenu extDbMenu;
    private JCheckBox baselineCheckBox;
    private ExtDb extDb;
    private int searchRecordType;
    private boolean useBaseline;
    private JTextField recordIDField;
    private JTextField fileNumberField;
    private JPanel fileNumberPanel;
    private JTextField callSignField;
    private JPanel callSignPanel;
    private JTextField channelField;
    private KeyedRecordMenu statusMenu;
    private KeyedRecordMenu serviceMenu;
    private JTextField cityField;
    private JTextField stateField;
    private KeyedRecordMenu countryMenu;
    private JTextField facilityIDField;
    private JCheckBox includeArchivedCheckBox;
    private JCheckBox includeSharingGuestsCheckBox;
    private JTextArea additionalSQLTextArea;
    private JCheckBox radiusSearchCheckBox;
    private CoordinatePanel latitudePanel;
    private CoordinatePanel longitudePanel;
    private CoordinateCopyPastePanel copyPastePanel;
    private GeoPoint searchCenter;
    private JTextField radiusField;
    private double searchRadius;
    private AppDialog moreOptionsDialog;
    private JButton moreOptionsButton;
    private RecordListTableModel listModel;
    private JTable listTable;
    private RecordListItem selectedItem;
    private int selectedItemIndex = -1;
    private JLabel noteLabel;
    private JPanel notePanel;
    private boolean canViewEdit;
    private boolean showUserDelete;
    private KeyedRecordMenu newRecordMenu;
    private KeyedRecordMenu importMenu;
    private JButton searchButton;
    private JButton duplicateButton;
    private JButton exportButton;
    private JButton saveButton;
    private JButton deleteButton;
    private JButton openButton;
    private JMenuItem duplicateMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem compareMenuItem;
    private RecordFindPanel outerThis = this;

    public RecordFindPanel(AppEditor appEditor, int n, int n2) {
        super(appEditor);
        this.doSetup(n, n2, true);
    }

    public RecordFindPanel(AppEditor appEditor, Runnable runnable, int n, int n2) {
        super(appEditor, runnable);
        this.doSetup(n, n2, true);
    }

    public RecordFindPanel(AppEditor appEditor, Runnable runnable, int n, boolean bl) {
        super(appEditor, runnable);
        this.doSetup(0, n, bl);
    }

    private void doSetup(int n, int n2, boolean bl) {
        this.canViewEdit = bl;
        this.minimumTVChannel = 2;
        this.maximumTVChannel = 69;
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (n2 > 0) {
            this.recordType = n2;
        } else if (n2 < 0) {
            this.recordType = -n2;
            this.userRecordsOnly = true;
        } else {
            arrayList.addAll(Source.getRecordTypes((int)n));
            if (1 == arrayList.size()) {
                this.recordType = ((KeyedRecord)arrayList.get((int)0)).key;
            } else {
                this.studyType = n;
            }
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Search Record Type"));
        if (this.recordType > 0) {
            this.searchRecordType = this.recordType;
            jPanel.add(new JLabel(Source.getRecordTypeName((int)this.recordType)));
        } else {
            this.searchRecordTypeMenu = new KeyedRecordMenu(arrayList);
            this.searchRecordType = this.searchRecordTypeMenu.getSelectedKey();
            this.searchRecordTypeMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RecordFindPanel.this.blockActions()) {
                        RecordFindPanel.this.updateSearchUI(false);
                        RecordFindPanel.this.blockActionsEnd();
                    }
                }
            });
            jPanel.add(this.searchRecordTypeMenu);
        }
        JButton jButton = null;
        JButton jButton2 = null;
        if (this.canViewEdit) {
            if (this.recordType > 0) {
                jButton = new JButton("New");
                jButton.setFocusable(false);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RecordFindPanel.this.doNew(RecordFindPanel.this.recordType);
                    }
                });
                jButton2 = new JButton("Import");
                jButton2.setFocusable(false);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RecordFindPanel.this.doImport(RecordFindPanel.this.recordType);
                    }
                });
            } else {
                arrayList.add(0, new KeyedRecord(0, "New..."));
                this.newRecordMenu = new KeyedRecordMenu(arrayList);
                this.newRecordMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RecordFindPanel.this.blockActions()) {
                            int n = RecordFindPanel.this.newRecordMenu.getSelectedKey();
                            RecordFindPanel.this.newRecordMenu.setSelectedIndex(0);
                            RecordFindPanel.this.blockActionsEnd();
                            if (n > 0) {
                                RecordFindPanel.this.doNew(n);
                            }
                        }
                    }
                });
                arrayList.set(0, new KeyedRecord(0, "Import..."));
                this.importMenu = new KeyedRecordMenu(arrayList);
                this.importMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RecordFindPanel.this.blockActions()) {
                            int n = RecordFindPanel.this.importMenu.getSelectedKey();
                            RecordFindPanel.this.importMenu.setSelectedIndex(0);
                            RecordFindPanel.this.blockActionsEnd();
                            if (n > 0) {
                                RecordFindPanel.this.doImport(n);
                            }
                        }
                    }
                });
            }
        }
        this.baselineCheckBox = new JCheckBox("Baseline");
        this.baselineCheckBox.setFocusable(false);
        this.baselineCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RecordFindPanel.this.blockActions()) {
                    RecordFindPanel.this.updateSearchUI(false);
                    RecordFindPanel.this.blockActionsEnd();
                }
            }
        });
        jPanel.add(this.baselineCheckBox);
        this.extDbMenu = new KeyedRecordMenu();
        this.extDbMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXyXy"));
        this.extDbMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RecordFindPanel.this.blockActions()) {
                    RecordFindPanel.this.updateSearchUI(false);
                    RecordFindPanel.this.blockActionsEnd();
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Search Station Data"));
        jPanel2.add(this.extDbMenu);
        this.recordIDField = new JTextField(18);
        AppController.fixKeyBindings(this.recordIDField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Record ID"));
        jPanel3.add(this.recordIDField);
        this.fileNumberField = new JTextField(18);
        AppController.fixKeyBindings(this.fileNumberField);
        this.fileNumberPanel = new JPanel();
        this.fileNumberPanel.setBorder(BorderFactory.createTitledBorder("File Number"));
        this.fileNumberPanel.add(this.fileNumberField);
        this.callSignField = new JTextField(8);
        AppController.fixKeyBindings(this.callSignField);
        this.callSignPanel = new JPanel();
        this.callSignPanel.setBorder(BorderFactory.createTitledBorder("Call Sign"));
        this.callSignPanel.add(this.callSignField);
        this.channelField = new JTextField(5);
        AppController.fixKeyBindings(this.channelField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("Channel"));
        jPanel4.add(this.channelField);
        arrayList.clear();
        arrayList.add(new KeyedRecord(-1, "(any)"));
        arrayList.addAll(ExtDbRecord.getStatusList());
        this.statusMenu = new KeyedRecordMenu(arrayList);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("Status"));
        jPanel5.add(this.statusMenu);
        arrayList.clear();
        arrayList.add(new KeyedRecord(0, "(any)"));
        this.serviceMenu = new KeyedRecordMenu(arrayList);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Service"));
        jPanel6.add(this.serviceMenu);
        this.cityField = new JTextField(18);
        AppController.fixKeyBindings(this.cityField);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createTitledBorder("City"));
        jPanel7.add(this.cityField);
        this.stateField = new JTextField(4);
        AppController.fixKeyBindings(this.stateField);
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createTitledBorder("State"));
        jPanel8.add(this.stateField);
        arrayList.clear();
        arrayList.add(new KeyedRecord(0, "(any)"));
        arrayList.addAll(Country.getCountries());
        this.countryMenu = new KeyedRecordMenu(arrayList);
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(BorderFactory.createTitledBorder("Country"));
        jPanel9.add(this.countryMenu);
        this.facilityIDField = new JTextField(7);
        AppController.fixKeyBindings(this.facilityIDField);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(BorderFactory.createTitledBorder("Facility ID"));
        jPanel10.add(this.facilityIDField);
        this.includeArchivedCheckBox = new JCheckBox("Include archived");
        this.includeArchivedCheckBox.setFocusable(false);
        this.includeSharingGuestsCheckBox = new JCheckBox("Include sharing guests");
        this.includeSharingGuestsCheckBox.setFocusable(false);
        this.additionalSQLTextArea = new JTextArea(5, 40);
        AppController.fixKeyBindings(this.additionalSQLTextArea);
        this.additionalSQLTextArea.setLineWrap(true);
        this.additionalSQLTextArea.setWrapStyleWord(true);
        JPanel jPanel11 = new JPanel();
        jPanel11.setBorder(BorderFactory.createTitledBorder("Additional SQL for WHERE clause"));
        jPanel11.add(AppController.createScrollPane(this.additionalSQLTextArea));
        this.radiusSearchCheckBox = new JCheckBox("Search by center point and radius");
        this.radiusSearchCheckBox.setFocusable(false);
        this.radiusSearchCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = RecordFindPanel.this.radiusSearchCheckBox.isSelected();
                RecordFindPanel.this.latitudePanel.setEnabled(bl);
                RecordFindPanel.this.longitudePanel.setEnabled(bl);
                RecordFindPanel.this.copyPastePanel.setEnabled(bl);
                AppController.setComponentEnabled(RecordFindPanel.this.radiusField, bl);
            }
        });
        this.searchCenter = new GeoPoint();
        this.latitudePanel = new CoordinatePanel(this, this.searchCenter, false, null);
        this.longitudePanel = new CoordinatePanel(this, this.searchCenter, true, null);
        this.copyPastePanel = new CoordinateCopyPastePanel(this.latitudePanel, this.longitudePanel);
        this.radiusField = new JTextField(7);
        AppController.fixKeyBindings(this.radiusField);
        JPanel jPanel12 = new JPanel();
        jPanel12.setBorder(BorderFactory.createTitledBorder("Radius, km"));
        jPanel12.add(this.radiusField);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BoxLayout(jPanel13, 1));
        jPanel13.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel14 = new JPanel(new FlowLayout(0));
        jPanel14.add(this.radiusSearchCheckBox);
        jPanel13.add(jPanel14);
        jPanel14 = new JPanel(new FlowLayout(0));
        jPanel14.add(this.latitudePanel);
        jPanel14.add(this.copyPastePanel);
        jPanel13.add(jPanel14);
        jPanel14 = new JPanel(new FlowLayout(0));
        jPanel14.add(this.longitudePanel);
        jPanel13.add(jPanel14);
        jPanel14 = new JPanel(new FlowLayout(0));
        jPanel14.add(jPanel12);
        jPanel13.add(jPanel14);
        JPanel jPanel15 = new JPanel();
        jPanel15.add(jPanel3);
        JPanel jPanel16 = new JPanel();
        jPanel16.add(jPanel7);
        jPanel16.add(jPanel8);
        jPanel16.add(jPanel9);
        JPanel jPanel17 = new JPanel();
        jPanel17.add(jPanel13);
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new BoxLayout(jPanel18, 1));
        jPanel18.add(jPanel16);
        jPanel18.add(jPanel17);
        jPanel18.add(jPanel15);
        jPanel18.add(jPanel11);
        JButton jButton3 = new JButton("OK");
        jButton3.setFocusable(false);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null != RecordFindPanel.this.moreOptionsDialog && RecordFindPanel.this.moreOptionsDialog.isVisible()) {
                    AppController.hideWindow(RecordFindPanel.this.moreOptionsDialog);
                }
            }
        });
        JPanel jPanel19 = new JPanel(new FlowLayout(2));
        jPanel19.add(jButton3);
        this.moreOptionsDialog = new AppDialog(this.getOriginalParent(), "Additional Options", Dialog.ModalityType.APPLICATION_MODAL){

            @Override
            public void windowWillOpen() {
                this.blockActionsClear();
            }

            @Override
            public void windowWillClose() {
                this.blockActionsSet();
            }
        };
        this.moreOptionsDialog.add((Component)jPanel18, "Center");
        this.moreOptionsDialog.add((Component)jPanel19, "South");
        this.moreOptionsDialog.pack();
        this.moreOptionsDialog.setMinimumSize(this.moreOptionsDialog.getSize());
        this.latitudePanel.setParent(this.moreOptionsDialog);
        this.longitudePanel.setParent(this.moreOptionsDialog);
        this.copyPastePanel.setParent(this.moreOptionsDialog);
        this.moreOptionsButton = new JButton("More");
        this.moreOptionsButton.setFocusable(false);
        this.moreOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!RecordFindPanel.this.moreOptionsDialog.isVisible()) {
                    RecordFindPanel.this.moreOptionsDialog.setLocationRelativeTo(RecordFindPanel.this.moreOptionsButton);
                    AppController.showWindow(RecordFindPanel.this.moreOptionsDialog);
                }
            }
        });
        JPanel jPanel20 = new JPanel(new BorderLayout());
        this.listModel = new RecordListTableModel(jPanel20);
        this.listTable = this.listModel.createTable();
        if (this.canViewEdit) {
            this.listTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (2 == mouseEvent.getClickCount()) {
                        RecordFindPanel.this.doOpen();
                    }
                }
            });
        }
        this.listTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (1 == RecordFindPanel.this.listTable.getSelectedRowCount()) {
                        RecordFindPanel.this.selectedItemIndex = RecordFindPanel.this.listTable.convertRowIndexToModel(RecordFindPanel.this.listTable.getSelectedRow());
                        RecordFindPanel.this.selectedItem = RecordFindPanel.this.listModel.get(RecordFindPanel.this.selectedItemIndex);
                    } else {
                        RecordFindPanel.this.selectedItemIndex = -1;
                        RecordFindPanel.this.selectedItem = null;
                    }
                    RecordFindPanel.this.updateControls();
                    if (null != RecordFindPanel.this.callBack) {
                        RecordFindPanel.this.callBack.run();
                    }
                }
            }
        });
        jPanel20.add((Component)AppController.createScrollPane(this.listTable, 22, 32), "Center");
        jPanel20.add((Component)this.listModel.filterPanel, "South");
        this.noteLabel = new JLabel();
        this.notePanel = new JPanel(new FlowLayout(0));
        this.notePanel.add(this.noteLabel);
        this.notePanel.setVisible(false);
        String string = AppCore.getPreference((String)"hideUserRecordDelete");
        this.showUserDelete = null == string || Boolean.valueOf(string) == false;
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordFindPanel.this.doSearch();
            }
        });
        JButton jButton4 = new JButton("Clear");
        jButton4.setFocusable(false);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordFindPanel.this.doClear(true);
            }
        });
        if (this.canViewEdit) {
            this.duplicateButton = new JButton("Duplicate");
            this.duplicateButton.setFocusable(false);
            this.duplicateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RecordFindPanel.this.doDuplicate();
                }
            });
            this.exportButton = new JButton("Export");
            this.exportButton.setFocusable(false);
            this.exportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RecordFindPanel.this.doExport();
                }
            });
            this.saveButton = new JButton("Save");
            this.saveButton.setFocusable(false);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RecordFindPanel.this.doSave();
                }
            });
            if (this.showUserDelete) {
                this.deleteButton = new JButton("Delete");
                this.deleteButton.setFocusable(false);
                this.deleteButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RecordFindPanel.this.doDelete();
                    }
                });
            }
            this.openButton = new JButton("View");
            this.openButton.setFocusable(false);
            this.openButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RecordFindPanel.this.doOpen();
                }
            });
        }
        JPanel jPanel21 = new JPanel();
        jPanel21.add(this.fileNumberPanel);
        JPanel jPanel22 = new JPanel();
        jPanel22.add(this.callSignPanel);
        jPanel22.add(jPanel10);
        JPanel jPanel23 = new JPanel();
        jPanel23.add(jPanel4);
        jPanel23.add(jPanel5);
        JPanel jPanel24 = new JPanel();
        jPanel24.add(jPanel6);
        Box box = Box.createVerticalBox();
        box.add(this.includeArchivedCheckBox);
        box.add(this.includeSharingGuestsCheckBox);
        JPanel jPanel25 = new JPanel();
        jPanel25.add(box);
        jPanel25.add(this.moreOptionsButton);
        Box box2 = Box.createVerticalBox();
        box2.add(jPanel22);
        box2.add(jPanel23);
        box2.add(jPanel21);
        box2.add(jPanel24);
        box2.add(jPanel25);
        JPanel jPanel26 = new JPanel();
        jPanel26.add(box2);
        JPanel jPanel27 = new JPanel(new FlowLayout(2));
        jPanel27.add(jButton4);
        jPanel27.add(this.searchButton);
        Box box3 = Box.createVerticalBox();
        box3.add(jPanel);
        box3.add(jPanel2);
        JPanel jPanel28 = new JPanel(new BorderLayout());
        jPanel28.add((Component)box3, "North");
        jPanel28.add((Component)AppController.createScrollPane(jPanel26), "Center");
        jPanel28.add((Component)jPanel27, "South");
        JPanel jPanel29 = null;
        if (this.canViewEdit) {
            JPanel jPanel30 = new JPanel(new FlowLayout(0));
            jPanel30.add(this.openButton);
            jPanel30.add(this.duplicateButton);
            jPanel30.add(this.exportButton);
            jPanel30.add(this.saveButton);
            if (this.showUserDelete) {
                jPanel30.add(this.deleteButton);
            }
            JPanel jPanel31 = new JPanel(new FlowLayout(2));
            if (null != this.importMenu) {
                jPanel31.add(this.importMenu);
            } else if (null != jButton2) {
                jPanel31.add(jButton2);
            }
            if (null != this.newRecordMenu) {
                jPanel31.add(this.newRecordMenu);
            } else if (null != jButton) {
                jPanel31.add(jButton);
            }
            Box box4 = Box.createHorizontalBox();
            box4.add(jPanel30);
            box4.add(jPanel31);
            jPanel29 = new JPanel(new BorderLayout());
            jPanel29.add((Component)jPanel20, "Center");
            jPanel29.add((Component)box4, "South");
        } else {
            jPanel29 = jPanel20;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.notePanel, "North");
        this.add((Component)jPanel29, "Center");
        this.add((Component)jPanel28, "East");
        if (this.canViewEdit) {
            this.duplicateMenuItem = new JMenuItem("Duplicate");
            this.duplicateMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RecordFindPanel.this.doDuplicate();
                }
            });
            this.openMenuItem = new JMenuItem("View");
            this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppController.MENU_SHORTCUT_KEY_MASK));
            this.openMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RecordFindPanel.this.doOpen();
                }
            });
            this.compareMenuItem = new JMenuItem("Compare");
            this.compareMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (null == RecordFindPanel.this.selectedItem) {
                        return;
                    }
                    if (RecordFindPanel.this.selectedItem.isSource) {
                        SourceCompare.compare((SourceEditData)RecordFindPanel.this.selectedItem.record, RecordFindPanel.this.errorReporter);
                    } else {
                        SourceCompare.compare((ExtDbRecord)RecordFindPanel.this.selectedItem.record, RecordFindPanel.this.errorReporter);
                    }
                }
            });
            this.exportMenuItem = new JMenuItem("Export...");
            this.exportMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RecordFindPanel.this.doExport();
                }
            });
            this.saveMenuItem = new JMenuItem("Save");
            this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, AppController.MENU_SHORTCUT_KEY_MASK));
            this.saveMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RecordFindPanel.this.doSave();
                }
            });
            if (this.showUserDelete) {
                this.deleteMenuItem = new JMenuItem("Delete");
                this.deleteMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RecordFindPanel.this.doDelete();
                    }
                });
            }
        }
    }

    public JButton getDefaultButton() {
        return this.searchButton;
    }

    public void addMenuItems(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem("Previous");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordFindPanel.this.doPrevious();
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Next");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(40, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordFindPanel.this.doNext();
            }
        });
        jMenu.add(jMenuItem2);
        if (!this.canViewEdit) {
            return;
        }
        jMenu.addSeparator();
        if (this.recordType > 0) {
            JMenuItem jMenuItem3 = new JMenuItem("New");
            jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(78, AppController.MENU_SHORTCUT_KEY_MASK));
            jMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RecordFindPanel.this.doNew(RecordFindPanel.this.recordType);
                }
            });
            jMenu.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Import");
            jMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RecordFindPanel.this.doImport(RecordFindPanel.this.recordType);
                }
            });
            jMenu.add(jMenuItem4);
        } else {
            JMenu jMenu2 = new JMenu("New");
            for (Object object : Source.getRecordTypes((int)this.studyType)) {
                JMenuItem jMenuItem5 = new JMenuItem(((KeyedRecord)object).name);
                final int n = ((KeyedRecord)object).key;
                jMenuItem5.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RecordFindPanel.this.doNew(n);
                    }
                });
                jMenu2.add(jMenuItem5);
            }
            jMenu.add(jMenu2);
            JMenu jMenu3 = new JMenu("Import");
            for (KeyedRecord keyedRecord : Source.getRecordTypes((int)this.studyType)) {
                Object object;
                object = new JMenuItem(keyedRecord.name);
                final int n = keyedRecord.key;
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RecordFindPanel.this.doImport(n);
                    }
                });
                jMenu3.add((JMenuItem)object);
            }
            jMenu.add(jMenu3);
        }
        jMenu.add(this.duplicateMenuItem);
        jMenu.addSeparator();
        jMenu.add(this.openMenuItem);
        jMenu.add(this.saveMenuItem);
        if (this.showUserDelete) {
            jMenu.add(this.deleteMenuItem);
        }
        jMenu.addSeparator();
        jMenu.add(this.compareMenuItem);
        jMenu.add(this.exportMenuItem);
    }

    public void setDefaultExtDbKey(Integer n) {
        if (this.getWindow().isVisible()) {
            return;
        }
        this.defaultExtDbKey = n;
    }

    public void setTVChannelRange(int n, int n2) {
        if (this.getWindow().isVisible()) {
            return;
        }
        if (n < 2 || n > 69) {
            n = 2;
        }
        if (n2 < 2 || n2 > 69) {
            n2 = 69;
        }
        if (n <= n2) {
            this.minimumTVChannel = n;
            this.maximumTVChannel = n2;
        } else {
            this.minimumTVChannel = n2;
            this.maximumTVChannel = n;
        }
    }

    public void setNote(String string) {
        if (null == string || 0 == string.length()) {
            this.noteLabel.setText("");
            this.notePanel.setVisible(false);
        } else {
            this.noteLabel.setText(string);
            this.notePanel.setVisible(true);
        }
    }

    public void setStudy(StudyEditData studyEditData) {
        this.study = studyEditData;
    }

    @Override
    public void updateDocumentName() {
        this.listModel.updateEditorDocumentNames();
    }

    public StationRecord getSelectedRecord() {
        if (null != this.selectedItem) {
            return this.selectedItem.record;
        }
        return null;
    }

    public boolean canApplySelection(boolean bl) {
        if (null != this.selectedItem) {
            return this.selectedItem.isValid && (!this.selectedItem.isNew || bl && null == this.selectedItem.sourceEditor);
        }
        return false;
    }

    public void selectionWasApplied() {
        if (null != this.selectedItem) {
            this.selectedItem.wasApplied = true;
        }
    }

    public boolean canApplyRecord(StationRecord stationRecord, boolean bl) {
        RecordListItem recordListItem = this.listModel.findItemForRecord(stationRecord);
        if (null != recordListItem) {
            return recordListItem.isValid && (!recordListItem.isNew || bl && null == recordListItem.sourceEditor);
        }
        return false;
    }

    public void recordWasApplied(StationRecord stationRecord) {
        RecordListItem recordListItem = this.listModel.findItemForRecord(stationRecord);
        if (null != recordListItem) {
            recordListItem.wasApplied = true;
        }
    }

    private void updateSearchUI(boolean bl) {
        boolean bl2;
        int n;
        ArrayList<KeyedRecord> arrayList;
        boolean bl3 = false;
        int n2 = this.searchRecordType;
        if (null != this.searchRecordTypeMenu && (n2 = this.searchRecordTypeMenu.getSelectedKey()) != this.searchRecordType && null != (arrayList = this.getExtDbMenuList(n2, null))) {
            n = this.extDbMenu.getSelectedKey();
            this.extDbMenu.removeAllItems();
            this.extDbMenu.addAllItems(arrayList);
            if (this.extDbMenu.containsKey(n)) {
                this.extDbMenu.setSelectedKey(n);
            }
        }
        int n3 = -this.searchRecordType;
        n = -1;
        if (null != this.extDb) {
            n3 = this.extDb.key;
            n = this.extDb.type;
        }
        int n4 = this.extDbMenu.getSelectedKey();
        int n5 = -1;
        ExtDb extDb = null;
        if (n4 > 0) {
            extDb = ExtDb.getExtDb((String)this.getDbID(), (Integer)n4, (ErrorLogger)this.errorReporter);
            if (null == extDb) {
                this.extDbMenu.setSelectedKey(n3);
                extDb = this.extDb;
                n4 = n3;
                n5 = n;
            } else {
                n4 = extDb.key;
                n5 = extDb.type;
            }
        } else if (n4 < 0) {
            n2 = -n4;
        } else {
            n4 = -n2;
        }
        if (n4 != n3 || n2 != this.searchRecordType || bl) {
            this.extDb = extDb;
            bl3 = true;
            if (n5 != n || bl) {
                this.recordIDField.setText("");
                this.additionalSQLTextArea.setText("");
            }
            if (1 == n2 && null != this.extDb && this.extDb.hasBaseline()) {
                AppController.setComponentEnabled(this.baselineCheckBox, true);
            } else {
                this.baselineCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.baselineCheckBox, false);
            }
            if (null == this.extDb) {
                this.radiusSearchCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.radiusSearchCheckBox, false);
                this.latitudePanel.setEnabled(false);
                this.longitudePanel.setEnabled(false);
                this.copyPastePanel.setEnabled(false);
                AppController.setComponentEnabled(this.radiusField, false);
            } else {
                AppController.setComponentEnabled(this.radiusSearchCheckBox, true);
                bl2 = this.radiusSearchCheckBox.isSelected();
                this.latitudePanel.setEnabled(bl2);
                this.longitudePanel.setEnabled(bl2);
                this.copyPastePanel.setEnabled(bl2);
                AppController.setComponentEnabled(this.radiusField, bl2);
            }
        }
        bl2 = this.baselineCheckBox.isSelected();
        if (n2 != this.searchRecordType || bl2 != this.useBaseline || bl) {
            this.searchRecordType = n2;
            this.useBaseline = bl2;
            bl3 = true;
            ArrayList<KeyedRecord> arrayList2 = new ArrayList<KeyedRecord>();
            arrayList2.add(new KeyedRecord(0, "(any)"));
            arrayList2.addAll(Service.getServices((int)this.searchRecordType));
            this.serviceMenu.removeAllItems();
            this.serviceMenu.addAllItems(arrayList2);
            switch (this.searchRecordType) {
                default: {
                    this.fileNumberPanel.setBorder(BorderFactory.createTitledBorder("File Number"));
                    this.callSignPanel.setBorder(BorderFactory.createTitledBorder("Call Sign"));
                    AppController.setComponentEnabled(this.channelField, true);
                    AppController.setComponentEnabled(this.facilityIDField, true);
                    if (this.useBaseline) {
                        this.fileNumberField.setText("");
                        this.statusMenu.setSelectedIndex(0);
                        this.includeArchivedCheckBox.setSelected(false);
                        this.includeSharingGuestsCheckBox.setSelected(false);
                        AppController.setComponentEnabled(this.fileNumberField, false);
                        AppController.setComponentEnabled(this.statusMenu, false);
                        AppController.setComponentEnabled(this.includeArchivedCheckBox, false);
                        AppController.setComponentEnabled(this.includeSharingGuestsCheckBox, false);
                        if (null == this.extDb) break;
                        if (1 == this.extDb.type) {
                            this.serviceMenu.setSelectedIndex(0);
                            this.countryMenu.setSelectedIndex(0);
                            AppController.setComponentEnabled(this.serviceMenu, false);
                            AppController.setComponentEnabled(this.countryMenu, false);
                            break;
                        }
                        AppController.setComponentEnabled(this.serviceMenu, true);
                        AppController.setComponentEnabled(this.countryMenu, true);
                        break;
                    }
                    AppController.setComponentEnabled(this.fileNumberField, true);
                    AppController.setComponentEnabled(this.statusMenu, true);
                    AppController.setComponentEnabled(this.serviceMenu, true);
                    AppController.setComponentEnabled(this.includeArchivedCheckBox, true);
                    AppController.setComponentEnabled(this.includeSharingGuestsCheckBox, true);
                    AppController.setComponentEnabled(this.countryMenu, true);
                    break;
                }
                case 2: {
                    this.fileNumberPanel.setBorder(BorderFactory.createTitledBorder("Reference Number"));
                    this.callSignPanel.setBorder(BorderFactory.createTitledBorder("Cell Site ID"));
                    this.channelField.setText("");
                    this.statusMenu.setSelectedIndex(0);
                    this.facilityIDField.setText("");
                    this.includeArchivedCheckBox.setSelected(false);
                    this.includeSharingGuestsCheckBox.setSelected(false);
                    AppController.setComponentEnabled(this.fileNumberField, true);
                    AppController.setComponentEnabled(this.channelField, false);
                    AppController.setComponentEnabled(this.statusMenu, false);
                    AppController.setComponentEnabled(this.serviceMenu, true);
                    AppController.setComponentEnabled(this.facilityIDField, false);
                    AppController.setComponentEnabled(this.includeArchivedCheckBox, false);
                    AppController.setComponentEnabled(this.includeSharingGuestsCheckBox, false);
                    AppController.setComponentEnabled(this.countryMenu, true);
                    break;
                }
                case 3: {
                    this.fileNumberPanel.setBorder(BorderFactory.createTitledBorder("File Number"));
                    this.callSignPanel.setBorder(BorderFactory.createTitledBorder("Call Sign"));
                    this.includeSharingGuestsCheckBox.setSelected(false);
                    AppController.setComponentEnabled(this.fileNumberField, true);
                    AppController.setComponentEnabled(this.channelField, true);
                    AppController.setComponentEnabled(this.statusMenu, true);
                    AppController.setComponentEnabled(this.serviceMenu, true);
                    AppController.setComponentEnabled(this.facilityIDField, true);
                    AppController.setComponentEnabled(this.includeArchivedCheckBox, true);
                    AppController.setComponentEnabled(this.includeSharingGuestsCheckBox, false);
                    AppController.setComponentEnabled(this.countryMenu, true);
                }
            }
        }
        if (bl3) {
            this.listModel.setItems(null, true);
        }
    }

    private boolean doClear(boolean bl) {
        this.blockActionsStart();
        this.recordIDField.setText("");
        this.fileNumberField.setText("");
        this.facilityIDField.setText("");
        this.serviceMenu.setSelectedIndex(0);
        this.callSignField.setText("");
        this.channelField.setText("");
        this.statusMenu.setSelectedIndex(0);
        this.cityField.setText("");
        this.stateField.setText("");
        this.countryMenu.setSelectedIndex(0);
        this.includeArchivedCheckBox.setSelected(false);
        this.includeSharingGuestsCheckBox.setSelected(false);
        this.additionalSQLTextArea.setText("");
        this.radiusSearchCheckBox.setSelected(false);
        this.latitudePanel.setEnabled(false);
        this.longitudePanel.setEnabled(false);
        this.copyPastePanel.setEnabled(false);
        AppController.setComponentEnabled(this.radiusField, false);
        this.searchCenter.setLatLon(0.0, 0.0);
        this.latitudePanel.updatePanel();
        this.longitudePanel.updatePanel();
        this.radiusField.setText("");
        this.searchRadius = 0.0;
        boolean bl2 = this.listModel.setItems(null, bl);
        this.updateControls();
        this.blockActionsEnd();
        return bl2;
    }

    private void doSearch() {
        Object object;
        this.errorReporter.clearTitle();
        int n = -1;
        int n2 = 0;
        boolean bl = true;
        if (null != this.extDb) {
            n = this.extDb.type;
            n2 = this.extDb.version;
            bl = this.extDb.isGeneric();
        }
        this.searchRadius = 0.0;
        double d = 0.0;
        if (this.radiusSearchCheckBox.isSelected()) {
            object = this.radiusField.getText().trim();
            if (((String)object).length() > 0) {
                try {
                    double d2 = Double.parseDouble((String)object);
                    if (d2 < 1.0 || d2 > 1000.0) {
                        this.errorReporter.reportWarning("The radius value must be in the range 1 to 1000");
                        return;
                    }
                    this.searchRadius = d2;
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorReporter.reportWarning("The radius value must be a number");
                    return;
                }
            }
            if (null != this.study) {
                d = this.study.getKilometersPerDegree();
            } else {
                d = 111.15;
                object = Parameter.getTemplateParameterValue((String)this.getDbID(), (int)1, (int)200, (int)0);
                if (null != object) {
                    try {
                        d = Double.parseDouble((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        object = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.useBaseline || 1 != this.searchRecordType) {
            boolean bl2;
            try {
                boolean bl3 = false;
                bl2 = false;
                if (bl) {
                    if (SourceEditData.addRecordIDQuery((int)n, (String)this.recordIDField.getText().trim(), (StringBuilder)stringBuilder, (boolean)false)) {
                        bl3 = true;
                    }
                } else if (ExtDbRecord.addRecordIDQuery((int)n, (int)n2, (int)this.searchRecordType, (String)this.recordIDField.getText().trim(), (StringBuilder)stringBuilder, (boolean)false)) {
                    bl3 = true;
                }
                if (!bl3) {
                    if (bl) {
                        if (SourceEditData.addFileNumberQuery((int)n, (String)this.fileNumberField.getText().trim(), (StringBuilder)stringBuilder, (boolean)false)) {
                            bl3 = true;
                        }
                    } else if (ExtDbRecord.addFileNumberQuery((int)n, (int)n2, (int)this.searchRecordType, (String)this.fileNumberField.getText().trim(), (StringBuilder)stringBuilder, (boolean)false)) {
                        bl3 = true;
                    }
                }
                if (!bl3) {
                    String string;
                    int n3;
                    int n4;
                    int n5;
                    if (this.radiusSearchCheckBox.isSelected() && (0.0 == this.searchCenter.latitude || 0.0 == this.searchCenter.longitude || 0.0 == this.searchRadius)) {
                        this.errorReporter.reportWarning("Please enter search radius and center coordinates");
                        return;
                    }
                    if (bl) {
                        if (SourceEditData.addFacilityIDQuery((int)n, (String)this.facilityIDField.getText().trim(), (StringBuilder)stringBuilder, (boolean)false)) {
                            bl3 = true;
                        }
                    } else if (ExtDbRecord.addFacilityIDQuery((int)n, (int)n2, (int)this.searchRecordType, (String)this.facilityIDField.getText().trim(), (StringBuilder)stringBuilder, (boolean)false)) {
                        bl3 = true;
                    }
                    if ((n5 = this.serviceMenu.getSelectedKey()) > 0) {
                        if (bl) {
                            if (SourceEditData.addServiceQuery((int)n, (int)n5, (StringBuilder)stringBuilder, (boolean)bl3)) {
                                bl3 = true;
                            }
                        } else if (ExtDbRecord.addServiceQuery((int)n, (int)n2, (int)this.searchRecordType, (int)n5, (StringBuilder)stringBuilder, (boolean)bl3)) {
                            bl3 = true;
                        }
                    }
                    if (bl) {
                        if (SourceEditData.addCallSignQuery((int)n, (String)this.callSignField.getText().trim(), (StringBuilder)stringBuilder, (boolean)bl3)) {
                            bl3 = true;
                        }
                    } else if (ExtDbRecord.addCallSignQuery((int)n, (int)n2, (int)this.searchRecordType, (String)this.callSignField.getText().trim(), (StringBuilder)stringBuilder, (boolean)bl3)) {
                        bl3 = true;
                    }
                    if (1 == this.searchRecordType) {
                        if (bl) {
                            if (SourceEditData.addChannelQuery((int)n, (String)this.channelField.getText().trim(), (int)this.minimumTVChannel, (int)this.maximumTVChannel, (StringBuilder)stringBuilder, (boolean)bl3)) {
                                bl2 = true;
                                bl3 = true;
                            }
                        } else if (ExtDbRecordTV.addChannelQuery((int)n, (int)n2, (int)this.searchRecordType, (String)this.channelField.getText().trim(), (int)this.minimumTVChannel, (int)this.maximumTVChannel, (StringBuilder)stringBuilder, (boolean)bl3)) {
                            bl2 = true;
                            bl3 = true;
                        }
                    } else if (3 == this.searchRecordType) {
                        if (bl) {
                            if (SourceEditData.addChannelQuery((int)n, (String)this.channelField.getText().trim(), (int)200, (int)300, (StringBuilder)stringBuilder, (boolean)bl3)) {
                                bl2 = true;
                                bl3 = true;
                            }
                        } else if (ExtDbRecordFM.addChannelQuery((int)n, (int)n2, (int)this.searchRecordType, (String)this.channelField.getText().trim(), (int)200, (int)300, (StringBuilder)stringBuilder, (boolean)bl3)) {
                            bl2 = true;
                            bl3 = true;
                        }
                    }
                    if ((n4 = this.statusMenu.getSelectedKey()) >= 0) {
                        if (bl) {
                            if (SourceEditData.addStatusQuery((int)n, (int)n4, (StringBuilder)stringBuilder, (boolean)bl3)) {
                                bl3 = true;
                            }
                        } else if (ExtDbRecord.addStatusQuery((int)n, (int)n2, (int)this.searchRecordType, (int)n4, (StringBuilder)stringBuilder, (boolean)bl3)) {
                            bl3 = true;
                        }
                    }
                    if (bl) {
                        if (SourceEditData.addCityQuery((int)n, (String)this.cityField.getText().trim(), (StringBuilder)stringBuilder, (boolean)bl3)) {
                            bl3 = true;
                        }
                    } else if (ExtDbRecord.addCityQuery((int)n, (int)n2, (int)this.searchRecordType, (String)this.cityField.getText().trim(), (StringBuilder)stringBuilder, (boolean)bl3)) {
                        bl3 = true;
                    }
                    if (bl) {
                        if (SourceEditData.addStateQuery((int)n, (String)this.stateField.getText().trim(), (StringBuilder)stringBuilder, (boolean)bl3)) {
                            bl3 = true;
                        }
                    } else if (ExtDbRecord.addStateQuery((int)n, (int)n2, (int)this.searchRecordType, (String)this.stateField.getText().trim(), (StringBuilder)stringBuilder, (boolean)bl3)) {
                        bl3 = true;
                    }
                    if ((n3 = this.countryMenu.getSelectedKey()) > 0) {
                        if (bl) {
                            if (SourceEditData.addCountryQuery((int)n, (int)n3, (StringBuilder)stringBuilder, (boolean)bl3)) {
                                bl3 = true;
                            }
                        } else if (ExtDbRecord.addCountryQuery((int)n, (int)n2, (int)this.searchRecordType, (int)n3, (StringBuilder)stringBuilder, (boolean)bl3)) {
                            bl3 = true;
                        }
                    }
                    if ((string = this.additionalSQLTextArea.getText().trim()).length() > 0) {
                        if (bl3) {
                            stringBuilder.append(" AND ");
                        }
                        stringBuilder.append('(');
                        stringBuilder.append(string);
                        stringBuilder.append(')');
                        bl3 = true;
                    }
                } else {
                    this.searchRadius = 0.0;
                }
                if (1 == this.searchRecordType && !bl2) {
                    if (bl) {
                        if (SourceEditData.addChannelRangeQuery((int)n, (int)this.minimumTVChannel, (int)this.maximumTVChannel, (StringBuilder)stringBuilder, (boolean)bl3)) {
                            bl3 = true;
                        }
                    } else if (ExtDbRecordTV.addChannelRangeQueryTV((int)n, (int)n2, (int)this.minimumTVChannel, (int)this.maximumTVChannel, (StringBuilder)stringBuilder, (boolean)bl3)) {
                        bl3 = true;
                    }
                }
                if (!bl && ExtDbRecord.addRecordTypeQuery((int)n, (int)n2, (int)this.searchRecordType, (boolean)this.includeArchivedCheckBox.isSelected(), (StringBuilder)stringBuilder, (boolean)bl3)) {
                    bl3 = true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.errorReporter.reportError(illegalArgumentException.getMessage());
                return;
            }
            final String string = stringBuilder.toString();
            bl2 = this.includeSharingGuestsCheckBox.isSelected();
            final double d3 = d;
            BackgroundWorker<ArrayList<RecordListItem>> backgroundWorker = new BackgroundWorker<ArrayList<RecordListItem>>(this.getWindow(), this.getTitle()){

                @Override
                protected ArrayList<RecordListItem> doBackgroundWork(ErrorLogger errorLogger) {
                    ArrayList<RecordListItem> arrayList = new ArrayList<RecordListItem>();
                    int n = -1;
                    boolean bl = true;
                    if (null != RecordFindPanel.this.extDb) {
                        n = ((RecordFindPanel)RecordFindPanel.this).extDb.type;
                        bl = RecordFindPanel.this.extDb.isGeneric();
                    }
                    if (bl) {
                        AbstractList abstractList = null;
                        boolean bl22 = false;
                        if (-1 == n) {
                            abstractList = SourceEditData.findUserRecords((String)RecordFindPanel.this.getDbID(), (int)RecordFindPanel.this.searchRecordType, (String)string, (ErrorLogger)errorLogger);
                            bl22 = true;
                        } else {
                            abstractList = SourceEditData.findImportRecords((ExtDb)RecordFindPanel.this.extDb, (int)RecordFindPanel.this.searchRecordType, (String)string, (GeoPoint)RecordFindPanel.this.searchCenter, (double)RecordFindPanel.this.searchRadius, (double)d3, (ErrorLogger)errorLogger);
                        }
                        if (null == abstractList) {
                            return null;
                        }
                        for (SourceEditData sourceEditData : abstractList) {
                            RecordListItem recordListItem = new RecordListItem();
                            recordListItem.record = (StationRecord)sourceEditData;
                            recordListItem.isSource = true;
                            recordListItem.isUserRecord = bl22;
                            recordListItem.isValid = true;
                            recordListItem.comment = sourceEditData.makeCommentText();
                            arrayList.add(recordListItem);
                        }
                    } else {
                        AbstractSequentialList abstractSequentialList = null;
                        switch (RecordFindPanel.this.searchRecordType) {
                            case 1: {
                                abstractSequentialList = ExtDbRecordTV.findRecords((ExtDb)RecordFindPanel.this.extDb, (String)string, (boolean)bl2, (GeoPoint)RecordFindPanel.this.searchCenter, (double)RecordFindPanel.this.searchRadius, (double)d3, (ErrorLogger)errorLogger);
                                break;
                            }
                            case 3: {
                                abstractSequentialList = ExtDbRecordFM.findRecords((ExtDb)RecordFindPanel.this.extDb, (String)string, (GeoPoint)RecordFindPanel.this.searchCenter, (double)RecordFindPanel.this.searchRadius, (double)d3, (ErrorLogger)errorLogger);
                            }
                        }
                        if (null == abstractSequentialList) {
                            return null;
                        }
                        for (ExtDbRecord extDbRecord : abstractSequentialList) {
                            RecordListItem recordListItem = new RecordListItem();
                            recordListItem.record = (StationRecord)extDbRecord;
                            recordListItem.isValid = true;
                            recordListItem.comment = extDbRecord.makeCommentText();
                            arrayList.add(recordListItem);
                        }
                    }
                    return arrayList;
                }
            };
            this.errorReporter.clearMessages();
            object = (ArrayList)backgroundWorker.runWork("Searching for records, please wait...", this.errorReporter);
            if (null == object) {
                return;
            }
        } else {
            try {
                if (!ExtDbRecordTV.addBaselineRecordIDQuery((int)n, (int)n2, (String)this.recordIDField.getText().trim(), (StringBuilder)stringBuilder, (boolean)false) && !ExtDbRecordTV.addBaselineFacilityIDQuery((int)n, (int)n2, (String)this.facilityIDField.getText().trim(), (StringBuilder)stringBuilder, (boolean)false)) {
                    String string;
                    int n6;
                    if (this.radiusSearchCheckBox.isSelected() && (0.0 == this.searchCenter.latitude || 0.0 == this.searchCenter.longitude || 0.0 == this.searchRadius)) {
                        this.errorReporter.reportWarning("Please enter search radius and center coordinates");
                        return;
                    }
                    boolean bl4 = false;
                    int n7 = this.serviceMenu.getSelectedKey();
                    if (n7 > 0 && ExtDbRecordTV.addBaselineServiceQuery((int)n, (int)n2, (int)n7, (StringBuilder)stringBuilder, (boolean)bl4)) {
                        bl4 = true;
                    }
                    if (ExtDbRecordTV.addBaselineCallSignQuery((int)n, (int)n2, (String)this.callSignField.getText().trim(), (StringBuilder)stringBuilder, (boolean)bl4)) {
                        bl4 = true;
                    }
                    boolean bl5 = false;
                    if (ExtDbRecordTV.addBaselineChannelQuery((int)n, (int)n2, (String)this.channelField.getText().trim(), (int)this.minimumTVChannel, (int)this.maximumTVChannel, (StringBuilder)stringBuilder, (boolean)bl4)) {
                        bl5 = true;
                        bl4 = true;
                    }
                    if (ExtDbRecordTV.addBaselineCityQuery((int)n, (int)n2, (String)this.cityField.getText().trim(), (StringBuilder)stringBuilder, (boolean)bl4)) {
                        bl4 = true;
                    }
                    if (ExtDbRecordTV.addBaselineStateQuery((int)n, (int)n2, (String)this.stateField.getText().trim(), (StringBuilder)stringBuilder, (boolean)bl4)) {
                        bl4 = true;
                    }
                    if ((n6 = this.countryMenu.getSelectedKey()) > 0 && ExtDbRecordTV.addBaselineCountryQuery((int)n, (int)n2, (int)n6, (StringBuilder)stringBuilder, (boolean)bl4)) {
                        bl4 = true;
                    }
                    if ((string = this.additionalSQLTextArea.getText().trim()).length() > 0) {
                        if (bl4) {
                            stringBuilder.append(" AND ");
                        }
                        stringBuilder.append('(');
                        stringBuilder.append(string);
                        stringBuilder.append(')');
                        bl4 = true;
                    }
                    if (!bl5 && ExtDbRecordTV.addBaselineChannelRangeQuery((int)n, (int)n2, (int)this.minimumTVChannel, (int)this.maximumTVChannel, (StringBuilder)stringBuilder, (boolean)bl4)) {
                        bl4 = true;
                    }
                } else {
                    this.searchRadius = 0.0;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.errorReporter.reportError(illegalArgumentException.getMessage());
                return;
            }
            final String string = stringBuilder.toString();
            final double d4 = d;
            BackgroundWorker<ArrayList<RecordListItem>> backgroundWorker = new BackgroundWorker<ArrayList<RecordListItem>>(this.getWindow(), this.getTitle()){

                @Override
                protected ArrayList<RecordListItem> doBackgroundWork(ErrorLogger errorLogger) {
                    ArrayList<RecordListItem> arrayList = new ArrayList<RecordListItem>();
                    LinkedList linkedList = ExtDbRecordTV.findBaselineRecords((ExtDb)RecordFindPanel.this.extDb, (String)string, (GeoPoint)RecordFindPanel.this.searchCenter, (double)RecordFindPanel.this.searchRadius, (double)d4, (ErrorLogger)errorLogger);
                    if (null == linkedList) {
                        return null;
                    }
                    for (ExtDbRecordTV extDbRecordTV : linkedList) {
                        RecordListItem recordListItem = new RecordListItem();
                        recordListItem.record = (StationRecord)extDbRecordTV;
                        recordListItem.isValid = true;
                        recordListItem.comment = extDbRecordTV.makeCommentText();
                        arrayList.add(recordListItem);
                    }
                    return arrayList;
                }
            };
            this.errorReporter.clearMessages();
            object = (ArrayList)backgroundWorker.runWork("Searching for records, please wait...", this.errorReporter);
            if (null == object) {
                return;
            }
        }
        if (((ArrayList)object).size() > 0) {
            if (!this.listModel.setItems((ArrayList)object, true)) {
                return;
            }
            this.errorReporter.showMessages();
            this.listTable.setRowSelectionInterval(0, 0);
            this.listTable.scrollRectToVisible(this.listTable.getCellRect(0, 0, true));
        } else {
            if (!this.listModel.setItems(null, true)) {
                return;
            }
            this.errorReporter.reportMessage("No matching records found");
        }
    }

    private void updateControls() {
        if (!this.canViewEdit) {
            return;
        }
        if (null == this.selectedItem) {
            this.duplicateButton.setEnabled(false);
            this.duplicateMenuItem.setEnabled(false);
            this.exportButton.setEnabled(false);
            this.exportMenuItem.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.saveMenuItem.setEnabled(false);
            this.openButton.setText("View");
            this.openButton.setEnabled(false);
            this.openMenuItem.setText("View");
            this.openMenuItem.setEnabled(false);
            this.compareMenuItem.setEnabled(false);
            if (this.showUserDelete) {
                this.deleteButton.setEnabled(false);
                this.deleteMenuItem.setEnabled(false);
            }
        } else {
            boolean bl = this.selectedItem.isValid && (!this.selectedItem.isNew || null == this.selectedItem.sourceEditor);
            this.duplicateButton.setEnabled(bl);
            this.duplicateMenuItem.setEnabled(bl);
            this.exportButton.setEnabled(bl);
            this.exportMenuItem.setEnabled(bl);
            if (this.selectedItem.isNew) {
                this.saveButton.setEnabled(bl);
                this.saveMenuItem.setEnabled(bl);
                this.openButton.setText("Edit");
                this.openMenuItem.setText("Edit");
            } else {
                this.saveButton.setEnabled(false);
                this.saveMenuItem.setEnabled(false);
                this.openButton.setText("View");
                this.openMenuItem.setText("View");
            }
            this.openButton.setEnabled(true);
            this.openMenuItem.setEnabled(true);
            this.compareMenuItem.setEnabled(true);
            if (this.showUserDelete) {
                this.deleteButton.setEnabled(this.selectedItem.isUserRecord);
                this.deleteMenuItem.setEnabled(this.selectedItem.isUserRecord);
            }
        }
    }

    private void doPrevious() {
        int n = this.listTable.getRowCount();
        int n2 = this.listTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.listTable.setRowSelectionInterval(n2, n2);
            this.listTable.scrollRectToVisible(this.listTable.getCellRect(n2, 0, true));
        }
    }

    private void doNext() {
        int n = this.listTable.getRowCount();
        int n2 = this.listTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.listTable.setRowSelectionInterval(n2, n2);
            this.listTable.scrollRectToVisible(this.listTable.getCellRect(n2, 0, true));
        }
    }

    private void doOpen() {
        SourceEditor sourceEditor;
        if (!this.canViewEdit || null == this.selectedItem) {
            return;
        }
        if (null != this.selectedItem.sourceEditor) {
            if (this.selectedItem.sourceEditor.isVisible()) {
                this.selectedItem.sourceEditor.toFront();
                return;
            }
            this.selectedItem.sourceEditor = null;
        }
        if (this.selectedItem.isNew) {
            this.errorReporter.setTitle("Edit Record");
        } else {
            this.errorReporter.setTitle("View Record");
        }
        this.errorReporter.clearMessages();
        SourceEditData sourceEditData = null;
        String string = null;
        if (this.selectedItem.isSource) {
            sourceEditData = (SourceEditData)this.selectedItem.record;
        } else {
            sourceEditData = SourceEditData.makeSource((ExtDbRecord)((ExtDbRecord)this.selectedItem.record), null, (boolean)true, (ErrorLogger)this.errorReporter);
            if (null == sourceEditData) {
                return;
            }
            if (1 == sourceEditData.recordType) {
                sourceEditor = (ExtDbRecordTV)this.selectedItem.record;
                if (((ExtDbRecordTV)sourceEditor).replicateToChannel > 0) {
                    string = "will replicate to D" + ((ExtDbRecordTV)sourceEditor).replicateToChannel;
                }
            }
        }
        this.errorReporter.showMessages();
        sourceEditor = new SourceEditor(this);
        sourceEditor.setChannelNote(string);
        if (!sourceEditor.setSource(sourceEditData, this.selectedItem.isNew, this.errorReporter)) {
            return;
        }
        AppController.showWindow(sourceEditor);
        this.selectedItem.sourceEditor = sourceEditor;
        this.listModel.itemWasChanged(this.selectedItemIndex);
        this.updateControls();
    }

    private void doNew(int n) {
        if (!this.canViewEdit) {
            return;
        }
        this.errorReporter.setTitle("Create New Record");
        SourceEditDataWL sourceEditDataWL = null;
        switch (n) {
            case 1: {
                sourceEditDataWL = SourceEditDataTV.createSource(null, (String)this.getDbID(), (int)0, (Service)Service.getInvalidObject(), (boolean)false, (Country)Country.getInvalidObject(), (boolean)false, (ErrorLogger)this.errorReporter);
                break;
            }
            case 2: {
                sourceEditDataWL = SourceEditDataWL.createSource(null, (String)this.getDbID(), (Service)Service.getInvalidObject(), (Country)Country.getInvalidObject(), (boolean)false, (ErrorLogger)this.errorReporter);
                break;
            }
            case 3: {
                sourceEditDataWL = SourceEditDataFM.createSource(null, (String)this.getDbID(), (int)0, (Service)Service.getInvalidObject(), (int)0, (Country)Country.getInvalidObject(), (boolean)false, (ErrorLogger)this.errorReporter);
            }
        }
        if (null == sourceEditDataWL) {
            return;
        }
        SourceEditor sourceEditor = new SourceEditor(this);
        if (!sourceEditor.setSource((SourceEditData)sourceEditDataWL, true, this.errorReporter)) {
            return;
        }
        AppController.showWindow(sourceEditor);
        RecordListItem recordListItem = new RecordListItem();
        recordListItem.record = (StationRecord)sourceEditDataWL;
        recordListItem.isSource = true;
        recordListItem.isNew = true;
        recordListItem.sourceEditor = sourceEditor;
        int n2 = this.listModel.add(recordListItem);
        if (n2 >= 0) {
            n2 = this.listTable.convertRowIndexToView(n2);
            this.listTable.setRowSelectionInterval(n2, n2);
            this.listTable.scrollRectToVisible(this.listTable.getCellRect(n2, 0, true));
        }
    }

    private void doDuplicate() {
        if (!this.canViewEdit || null == this.selectedItem || !this.selectedItem.isValid || this.selectedItem.isNew && null != this.selectedItem.sourceEditor) {
            return;
        }
        this.errorReporter.setTitle("Duplicate Record");
        this.errorReporter.clearMessages();
        SourceEditData sourceEditData = null;
        sourceEditData = this.selectedItem.isSource ? ((SourceEditData)this.selectedItem.record).deriveSource(null, false, (ErrorLogger)this.errorReporter) : SourceEditData.makeSource((ExtDbRecord)((ExtDbRecord)this.selectedItem.record), null, (boolean)false, (ErrorLogger)this.errorReporter);
        if (null == sourceEditData) {
            return;
        }
        sourceEditData.removeAttribute("isBaseline");
        this.errorReporter.showMessages();
        SourceEditor sourceEditor = new SourceEditor(this);
        if (!sourceEditor.setSource(sourceEditData, true, this.errorReporter)) {
            return;
        }
        AppController.showWindow(sourceEditor);
        RecordListItem recordListItem = new RecordListItem();
        recordListItem.record = (StationRecord)sourceEditData;
        recordListItem.isSource = true;
        recordListItem.isNew = true;
        recordListItem.isValid = false;
        recordListItem.sourceEditor = sourceEditor;
        int n = this.listModel.add(recordListItem);
        if (n >= 0) {
            n = this.listTable.convertRowIndexToView(n);
            this.listTable.setRowSelectionInterval(n, n);
            this.listTable.scrollRectToVisible(this.listTable.getCellRect(n, 0, true));
        }
    }

    private void doImport(int n) {
        if (!this.canViewEdit) {
            return;
        }
        String string = "Import " + Source.getRecordTypeName((int)n) + " Records";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Text (*.csv,*.txt,*.dat)", "csv", "txt", "dat"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        JCheckBox jCheckBox = new JCheckBox("Separate pattern file");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createTitledBorder("Text options"));
        jPanel.add(jCheckBox);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel);
        jFileChooser.setAccessory(jPanel2);
        if (0 != jFileChooser.showDialog(this, "Import")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        final int n2 = n;
        final File file2 = file;
        file = null;
        if (jCheckBox.isSelected()) {
            jFileChooser = new JFileChooser(file2.getParentFile().getAbsolutePath());
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle("Choose pattern data file");
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Text (*.csv,*.txt,*.dat)", "csv", "txt", "dat"));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            if (0 != jFileChooser.showDialog(this, "Import")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        }
        final File file3 = file;
        BackgroundWorker<ArrayList<SourceEditData>> backgroundWorker = new BackgroundWorker<ArrayList<SourceEditData>>(this.getWindow(), string){

            @Override
            protected ArrayList<SourceEditData> doBackgroundWork(ErrorLogger errorLogger) {
                return SourceEditData.readFromText((String)RecordFindPanel.this.getDbID(), (int)n2, (File)file2, (File)file3, (ErrorLogger)errorLogger);
            }
        };
        this.errorReporter.clearMessages();
        ArrayList arrayList = (ArrayList)backgroundWorker.runWork("Importing records, please wait...", this.errorReporter);
        if (null == arrayList) {
            return;
        }
        this.errorReporter.showMessages();
        ArrayList<RecordListItem> arrayList2 = new ArrayList<RecordListItem>();
        for (SourceEditData sourceEditData : arrayList) {
            RecordListItem recordListItem = new RecordListItem();
            recordListItem.record = (StationRecord)sourceEditData;
            recordListItem.isSource = true;
            recordListItem.isNew = !sourceEditData.isLocked;
            recordListItem.isImport = recordListItem.isNew;
            recordListItem.isValid = true;
            arrayList2.add(recordListItem);
        }
        this.listModel.setItems(arrayList2, true);
        this.listTable.setRowSelectionInterval(0, 0);
        this.listTable.scrollRectToVisible(this.listTable.getCellRect(0, 0, true));
    }

    private void doExport() {
        if (!this.canViewEdit || null == this.selectedItem || !this.selectedItem.isValid || this.selectedItem.isNew && null != this.selectedItem.sourceEditor) {
            return;
        }
        String string = "Export Record";
        this.errorReporter.setTitle(string);
        this.errorReporter.clearMessages();
        SourceEditData sourceEditData = null;
        if (this.selectedItem.isSource) {
            sourceEditData = (SourceEditData)this.selectedItem.record;
        } else {
            sourceEditData = SourceEditData.makeSource((ExtDbRecord)((ExtDbRecord)this.selectedItem.record), null, (boolean)true, (ErrorLogger)this.errorReporter);
            if (null == sourceEditData) {
                return;
            }
        }
        this.errorReporter.showMessages();
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("CSV (*.csv)", "csv"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Export")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            String string2 = file.getName();
            if (!string2.toLowerCase().endsWith(".csv")) {
                file = new File(file.getAbsolutePath() + ".csv");
            }
            if (!file.exists()) continue;
            AppController.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return;
        }
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>();
        arrayList.add(sourceEditData);
        try {
            SourceEditData.writeToCSV((BufferedWriter)bufferedWriter, (int)sourceEditData.recordType, arrayList, (ErrorLogger)this.errorReporter);
        }
        catch (IOException iOException) {
            this.errorReporter.reportError(iOException.toString());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doSave() {
        Object object;
        if (!(this.canViewEdit && null != this.selectedItem && this.selectedItem.isValid && this.selectedItem.isNew && null == this.selectedItem.sourceEditor)) {
            return;
        }
        String string = "Save User Record";
        this.errorReporter.setTitle(string);
        SourceEditData sourceEditData = (SourceEditData)this.selectedItem.record;
        final Date date = AppCore.parseDate((String)sourceEditData.getAttribute("sequenceDate"));
        final boolean bl = null != sourceEditData.getAttribute("isSharingHost");
        TextInputDialog textInputDialog = new TextInputDialog((AppEditor)this.outerThis, string, "Comment");
        final DateSelectionPanel dateSelectionPanel = new DateSelectionPanel((AppEditor)textInputDialog, "Sequence date", false);
        dateSelectionPanel.setFutureAllowed(true);
        final JCheckBox jCheckBox = new JCheckBox("Shared channel host");
        JPanel jPanel = new JPanel();
        jPanel.add(dateSelectionPanel);
        jPanel.add(jCheckBox);
        if (null != date || bl) {
            object = new JButton("Set from original");
            ((Component)object).setFocusable(false);
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    dateSelectionPanel.setDate(date);
                    jCheckBox.setSelected(bl);
                }
            });
            jPanel.add((Component)object);
        }
        textInputDialog.add((Component)jPanel, "North");
        textInputDialog.pack();
        AppController.showWindow(textInputDialog);
        if (textInputDialog.canceled) {
            return;
        }
        object = textInputDialog.getInput();
        Date date2 = dateSelectionPanel.getDate();
        if (null == date2) {
            sourceEditData.removeAttribute("sequenceDate");
        } else {
            sourceEditData.setAttribute("sequenceDate", AppCore.formatDate((Date)date2));
        }
        if (jCheckBox.isSelected()) {
            sourceEditData.setAttribute("isSharingHost");
        } else {
            sourceEditData.removeAttribute("isSharingHost");
        }
        SourceEditData sourceEditData2 = sourceEditData.saveAsUserRecord((ErrorLogger)this.errorReporter);
        if (null == sourceEditData2) {
            return;
        }
        if (((String)object).length() > 0) {
            SourceEditData.setSourceComment((SourceEditData)sourceEditData2, (String)object);
        } else {
            object = null;
        }
        this.selectedItem.record = (StationRecord)sourceEditData2;
        this.selectedItem.isUserRecord = true;
        this.selectedItem.isNew = false;
        this.selectedItem.isImport = false;
        this.selectedItem.comment = sourceEditData2.makeCommentText();
        this.listModel.itemWasChanged(this.selectedItemIndex);
        this.updateControls();
        if (null != this.callBack) {
            this.callBack.run();
        }
    }

    private void doDelete() {
        if (!(this.canViewEdit && this.showUserDelete && null != this.selectedItem && this.selectedItem.isUserRecord)) {
            return;
        }
        String string = "Delete User Record";
        this.errorReporter.setTitle(string);
        if (null != this.selectedItem.sourceEditor) {
            if (this.selectedItem.sourceEditor.isVisible() && !this.selectedItem.sourceEditor.cancel()) {
                AppController.beep();
                this.selectedItem.sourceEditor.toFront();
                return;
            }
            this.selectedItem.sourceEditor = null;
        }
        SourceEditData sourceEditData = (SourceEditData)this.selectedItem.record;
        if (SourceEditData.deleteUserRecord((String)sourceEditData.dbID, (Integer)sourceEditData.userRecordID, (ErrorLogger)this.errorReporter)) {
            this.listModel.remove(this.selectedItemIndex);
        }
    }

    @Override
    public boolean applyEditsFrom(AppEditor appEditor) {
        if (appEditor instanceof SourceEditor) {
            SourceEditor sourceEditor = (SourceEditor)appEditor;
            int n = this.listModel.ufIndexOfEditor(sourceEditor);
            if (n < 0) {
                return false;
            }
            RecordListItem recordListItem = this.listModel.ufGet(n);
            recordListItem.record = (StationRecord)sourceEditor.getSource();
            recordListItem.isImport = false;
            recordListItem.wasApplied = false;
            recordListItem.isValid = true;
            this.listModel.ufItemWasChanged(n);
            return true;
        }
        return false;
    }

    @Override
    public void editorClosing(AppEditor appEditor) {
        if (appEditor instanceof SourceEditor) {
            SourceEditor sourceEditor = (SourceEditor)appEditor;
            int n = this.listModel.ufIndexOfEditor(sourceEditor);
            if (n < 0) {
                return;
            }
            RecordListItem recordListItem = this.listModel.ufGet(n);
            recordListItem.sourceEditor = null;
            if (!recordListItem.isValid) {
                this.listModel.ufRemove(n);
            } else {
                this.listModel.ufItemWasChanged(n);
            }
            this.updateControls();
            if (null != this.callBack) {
                this.callBack.run();
            }
        }
    }

    @Override
    public void clearFields() {
        this.doClear(true);
    }

    public void updateExtDbList() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RecordFindPanel.this.doExtDbUpdate(false);
            }
        });
    }

    private void doExtDbUpdate(boolean bl) {
        ErrorReporter errorReporter = null;
        if (bl) {
            errorReporter = this.errorReporter;
            this.errorReporter.setTitle("Load Station Data List");
        }
        ArrayList<KeyedRecord> arrayList = this.getExtDbMenuList(this.searchRecordType, errorReporter);
        this.blockActionsStart();
        int n = 0;
        if (bl) {
            if (null != this.defaultExtDbKey) {
                n = this.defaultExtDbKey;
            }
        } else {
            n = this.extDbMenu.getSelectedKey();
        }
        this.extDbMenu.removeAllItems();
        this.extDbMenu.addAllItems(arrayList);
        if (this.extDbMenu.containsKey(n)) {
            this.extDbMenu.setSelectedKey(n);
            if (bl) {
                this.updateSearchUI(true);
            }
        } else {
            this.updateSearchUI(bl);
        }
        if (bl) {
            this.doClear(false);
        }
        this.blockActionsEnd();
    }

    private ArrayList<KeyedRecord> getExtDbMenuList(int n, ErrorLogger errorLogger) {
        ArrayList arrayList;
        ArrayList<KeyedRecord> arrayList2 = new ArrayList<KeyedRecord>();
        boolean bl = true;
        if (!this.userRecordsOnly && null != (arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)n, (ErrorLogger)errorLogger))) {
            for (KeyedRecord keyedRecord : arrayList) {
                if (bl && (keyedRecord.key < 10000 || keyedRecord.key > 19999)) {
                    arrayList2.add(new KeyedRecord(-n, "User records"));
                    bl = false;
                }
                arrayList2.add(keyedRecord);
            }
        }
        if (bl) {
            arrayList2.add(new KeyedRecord(-n, "User records"));
        }
        return arrayList2;
    }

    @Override
    public void windowWillOpen() {
        ExtDb.addListener((ExtDbListener)this);
        this.extDb = null;
        this.callSignField.requestFocusInWindow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RecordFindPanel.this.doExtDbUpdate(true);
            }
        });
    }

    @Override
    public boolean windowShouldClose() {
        if (this.listModel.hasUnsavedData()) {
            AppController.beep();
            if (0 != JOptionPane.showConfirmDialog(this, "New records were edited but have not been saved.  Unsaved\nrecords will be discarded when this window is closed.\n\nAre you sure you want to continue?", "Confirm Close", 0, 2)) {
                return false;
            }
        }
        return this.doClear(false);
    }

    @Override
    public void windowWillClose() {
        ExtDb.removeListener((ExtDbListener)this);
    }

    private class RecordListTableModel
    extends AbstractTableModel
    implements TableFilterModel {
        private static final String RECORD_TYPE_COLUMN = "Type";
        private static final String RECORD_CALLSIGN_COLUMN = "Call Sign";
        private static final String RECORD_CALLSIGN_COLUMN_WL = "Call/ID";
        private static final String RECORD_CHANNEL_COLUMN = "Channel";
        private static final String RECORD_SERVICE_COLUMN = "Svc";
        private static final String RECORD_STATUS_COLUMN = "Status";
        private static final String RECORD_CITY_COLUMN = "City";
        private static final String RECORD_STATE_COLUMN = "State";
        private static final String RECORD_COUNTRY_COLUMN = "Cntry";
        private static final String RECORD_FACILITY_ID_COLUMN = "Facility ID";
        private static final String RECORD_FILE_COLUMN = "File Number";
        private static final String RECORD_FILE_COLUMN_WL = "File/Ref Number";
        private static final String RECORD_DATE_COLUMN = "Date";
        private String[] columnNamesNoWL = new String[]{"Type", "Call Sign", "Channel", "Svc", "Status", "City", "State", "Cntry", "Facility ID", "File Number", "Date"};
        private String[] columnNamesWL = new String[]{"Type", "Call/ID", "Channel", "Svc", "Status", "City", "State", "Cntry", "Facility ID", "File/Ref Number", "Date"};
        private String[] columnNames;
        private static final int RECORD_TYPE_INDEX = 0;
        private static final int RECORD_CALLSIGN_INDEX = 1;
        private static final int RECORD_CHANNEL_INDEX = 2;
        private static final int RECORD_SERVICE_INDEX = 3;
        private static final int RECORD_STATUS_INDEX = 4;
        private static final int RECORD_CITY_INDEX = 5;
        private static final int RECORD_STATE_INDEX = 6;
        private static final int RECORD_COUNTRY_INDEX = 7;
        private static final int RECORD_FACILITY_ID_INDEX = 8;
        private static final int RECORD_FILE_INDEX = 9;
        private static final int RECORD_DATE_INDEX = 10;
        private JPanel panel;
        private ArrayList<RecordListItem> modelRows;
        private TableFilterPanel filterPanel;

        private RecordListTableModel(JPanel jPanel) {
            this.columnNames = !(0 != RecordFindPanel.this.recordType && 2 != RecordFindPanel.this.recordType || 0 != RecordFindPanel.this.studyType && !Study.isRecordTypeAllowed((int)RecordFindPanel.this.studyType, (int)2)) ? this.columnNamesWL : this.columnNamesNoWL;
            this.panel = jPanel;
            this.modelRows = new ArrayList();
            this.filterPanel = new TableFilterPanel((AppEditor)RecordFindPanel.this.outerThis, this);
        }

        private JTable createTable() {
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable);
            TableRowSorter<RecordListTableModel> tableRowSorter = new TableRowSorter<RecordListTableModel>(this){

                @Override
                public void setSortKeys(List<? extends RowSorter.SortKey> list) {
                    Object object;
                    int n = 1;
                    SortOrder sortOrder = SortOrder.ASCENDING;
                    if (null != list && list.size() > 0) {
                        object = list.get(0);
                        n = ((RowSorter.SortKey)object).getColumn();
                        sortOrder = ((RowSorter.SortKey)object).getSortOrder();
                    }
                    object = new ArrayList<RowSorter.SortKey>();
                    switch (n) {
                        case 0: {
                            ((ArrayList)object).add(new RowSorter.SortKey(0, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(1, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            break;
                        }
                        default: {
                            ((ArrayList)object).add(new RowSorter.SortKey(1, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            break;
                        }
                        case 2: {
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            break;
                        }
                        case 3: {
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            break;
                        }
                        case 4: {
                            ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            break;
                        }
                        case 5: {
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            break;
                        }
                        case 6: {
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            break;
                        }
                        case 7: {
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            break;
                        }
                        case 8: {
                            ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            break;
                        }
                        case 9: {
                            ((ArrayList)object).add(new RowSorter.SortKey(9, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            break;
                        }
                        case 10: {
                            ((ArrayList)object).add(new RowSorter.SortKey(10, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                        }
                    }
                    super.setSortKeys((List<RowSorter.SortKey>)object);
                }
            };
            TableStringConverter tableStringConverter = new TableStringConverter(){

                @Override
                public String toString(TableModel tableModel, int n, int n2) {
                    StationRecord stationRecord = ((RecordListItem)RecordListTableModel.this.modelRows.get(((RecordListTableModel)RecordListTableModel.this).filterPanel.forwardIndex[n])).record;
                    switch (n2) {
                        case 0: {
                            return stationRecord.getRecordType();
                        }
                        case 1: {
                            return stationRecord.getCallSign();
                        }
                        case 2: {
                            return stationRecord.getSortChannel();
                        }
                        case 3: {
                            return stationRecord.getServiceCode();
                        }
                        case 4: {
                            return stationRecord.getSortStatus();
                        }
                        case 5: {
                            return stationRecord.getCity();
                        }
                        case 6: {
                            return stationRecord.getState();
                        }
                        case 7: {
                            return stationRecord.getSortCountry();
                        }
                        case 8: {
                            return stationRecord.getSortFacilityID();
                        }
                        case 9: {
                            return stationRecord.getFileNumber();
                        }
                        case 10: {
                            return stationRecord.getSortSequenceDate();
                        }
                    }
                    return "";
                }
            };
            tableRowSorter.setStringConverter(tableStringConverter);
            jTable.setRowSorter((RowSorter<? extends TableModel>)tableRowSorter);
            tableRowSorter.setSortKeys(null);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    int n3 = jTable.convertRowIndexToModel(n);
                    int n4 = jTable.convertColumnIndexToModel(n2);
                    RecordListItem recordListItem = (RecordListItem)RecordListTableModel.this.modelRows.get(((RecordListTableModel)RecordListTableModel.this).filterPanel.forwardIndex[n3]);
                    if (!bl) {
                        if (recordListItem.isNew) {
                            if (recordListItem.isValid) {
                                jLabel.setForeground(Color.GREEN.darker());
                            } else {
                                jLabel.setForeground(Color.RED);
                            }
                        } else {
                            jLabel.setForeground(Color.BLACK);
                        }
                    }
                    if (1 == n4 && null != recordListItem.comment && recordListItem.comment.length() > 0) {
                        if (!bl) {
                            jLabel.setForeground(Color.BLUE);
                        }
                        jLabel.setToolTipText(recordListItem.comment);
                    } else {
                        jLabel.setToolTipText(null);
                    }
                    return jLabel;
                }
            };
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[4]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[4]);
            tableColumn = tableColumnModel.getColumn(1);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[5]);
            tableColumn = tableColumnModel.getColumn(2);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[7]);
            tableColumn = tableColumnModel.getColumn(3);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[2]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[2]);
            tableColumn = tableColumnModel.getColumn(4);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[4]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[4]);
            tableColumn = tableColumnModel.getColumn(5);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[8]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[14]);
            tableColumn = tableColumnModel.getColumn(6);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[2]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[2]);
            tableColumn = tableColumnModel.getColumn(7);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[2]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[2]);
            tableColumn = tableColumnModel.getColumn(8);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[5]);
            tableColumn = tableColumnModel.getColumn(9);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[8]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[16]);
            tableColumn = tableColumnModel.getColumn(10);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
            jTable.setPreferredScrollableViewportSize(new Dimension(jTable.getPreferredSize().width, jTable.getRowHeight() * 5));
            return jTable;
        }

        private boolean setItems(ArrayList<RecordListItem> arrayList, boolean bl) {
            ArrayList<RecordListItem> arrayList2 = new ArrayList<RecordListItem>();
            for (RecordListItem recordListItem : new ArrayList<RecordListItem>(this.modelRows)) {
                if (recordListItem.isNew && !recordListItem.isImport && bl) {
                    arrayList2.add(recordListItem);
                    continue;
                }
                if (null == recordListItem.sourceEditor) continue;
                if (recordListItem.sourceEditor.isVisible() && !recordListItem.sourceEditor.cancel()) {
                    AppController.beep();
                    recordListItem.sourceEditor.toFront();
                    return false;
                }
                recordListItem.sourceEditor = null;
            }
            this.modelRows.clear();
            if (null != arrayList) {
                this.modelRows.addAll(arrayList);
            }
            this.modelRows.addAll(arrayList2);
            this.filterPanel.clearFilter();
            this.fireTableDataChanged();
            this.updateBorder();
            return true;
        }

        private boolean hasUnsavedData() {
            for (RecordListItem recordListItem : this.modelRows) {
                if (!recordListItem.isNew || recordListItem.isImport || recordListItem.wasApplied) continue;
                return true;
            }
            return false;
        }

        private void updateEditorDocumentNames() {
            for (RecordListItem recordListItem : this.modelRows) {
                if (null == recordListItem.sourceEditor) continue;
                recordListItem.sourceEditor.updateDocumentName();
            }
        }

        private int add(RecordListItem recordListItem) {
            int n = this.modelRows.size();
            this.modelRows.add(recordListItem);
            this.filterPanel.updateFilter();
            int n2 = this.filterPanel.reverseIndex[n];
            if (n2 >= 0) {
                this.fireTableRowsInserted(n2, n2);
                this.updateBorder();
            }
            return n2;
        }

        private RecordListItem get(int n) {
            return this.modelRows.get(this.filterPanel.forwardIndex[n]);
        }

        private void remove(int n) {
            this.modelRows.remove(this.filterPanel.forwardIndex[n]);
            this.filterPanel.updateFilter();
            this.fireTableRowsDeleted(n, n);
            this.updateBorder();
        }

        private void itemWasChanged(int n) {
            int n2 = this.filterPanel.forwardIndex[n];
            this.filterPanel.updateFilter();
            int n3 = this.filterPanel.reverseIndex[n2];
            if (n3 >= 0) {
                this.fireTableRowsUpdated(n3, n3);
            } else {
                this.fireTableRowsDeleted(n, n);
                this.updateBorder();
            }
        }

        private RecordListItem findItemForRecord(StationRecord stationRecord) {
            for (RecordListItem recordListItem : this.modelRows) {
                if (stationRecord != recordListItem.record) continue;
                return recordListItem;
            }
            return null;
        }

        private RecordListItem ufGet(int n) {
            return this.modelRows.get(n);
        }

        private void ufRemove(int n) {
            this.modelRows.remove(n);
            int n2 = this.filterPanel.reverseIndex[n];
            this.filterPanel.updateFilter();
            if (n2 >= 0) {
                this.fireTableRowsDeleted(n2, n2);
                this.updateBorder();
            }
        }

        private int ufIndexOfEditor(SourceEditor sourceEditor) {
            for (int i = 0; i < this.modelRows.size(); ++i) {
                RecordListItem recordListItem = this.modelRows.get(i);
                if (sourceEditor != recordListItem.sourceEditor) continue;
                return i;
            }
            return -1;
        }

        private void ufItemWasChanged(int n) {
            int n2 = this.filterPanel.reverseIndex[n];
            this.filterPanel.updateFilter();
            int n3 = this.filterPanel.reverseIndex[n];
            if (n2 >= 0) {
                if (n3 >= 0) {
                    this.fireTableRowsUpdated(n3, n3);
                } else {
                    this.fireTableRowsDeleted(n2, n2);
                    this.updateBorder();
                }
            } else if (n3 >= 0) {
                this.fireTableRowsInserted(n3, n3);
                this.updateBorder();
            }
        }

        @Override
        public void filterDidChange() {
            this.fireTableDataChanged();
            this.updateBorder();
        }

        private void updateBorder() {
            int n = this.filterPanel.forwardIndex.length;
            if (n > 0) {
                this.panel.setBorder(BorderFactory.createTitledBorder(String.valueOf(n) + " records"));
            } else {
                this.panel.setBorder(BorderFactory.createTitledBorder("Records"));
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public boolean filterByColumn(int n) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean collapseFilterChoices(int n) {
            switch (n) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int getRowCount() {
            return this.filterPanel.forwardIndex.length;
        }

        @Override
        public int getUnfilteredRowCount() {
            return this.modelRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.getUnfilteredValueAt(this.filterPanel.forwardIndex[n], n2);
        }

        @Override
        public String getUnfilteredValueAt(int n, int n2) {
            StationRecord stationRecord = this.modelRows.get(n).record;
            switch (n2) {
                case 0: {
                    return stationRecord.getRecordType();
                }
                case 1: {
                    return stationRecord.getCallSign();
                }
                case 2: {
                    return stationRecord.getChannel() + " " + stationRecord.getFrequency();
                }
                case 3: {
                    return stationRecord.getServiceCode();
                }
                case 4: {
                    return stationRecord.getStatus();
                }
                case 5: {
                    return stationRecord.getCity();
                }
                case 6: {
                    return stationRecord.getState();
                }
                case 7: {
                    return stationRecord.getCountryCode();
                }
                case 8: {
                    return stationRecord.getFacilityID();
                }
                case 9: {
                    return stationRecord.getFileNumber();
                }
                case 10: {
                    return stationRecord.getSequenceDate();
                }
            }
            return "";
        }
    }

    private class RecordListItem {
        private StationRecord record;
        private boolean isSource;
        private boolean isUserRecord;
        private boolean isNew;
        private boolean isImport;
        private boolean isValid;
        private boolean wasApplied;
        private String comment;
        private SourceEditor sourceEditor;

        private RecordListItem() {
        }
    }
}

