/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppFrame;
import gov.fcc.tvstudy.gui.AppPanel;
import gov.fcc.tvstudy.gui.RecordFindPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;

public class RecordFind
extends AppFrame {
    public static final String WINDOW_TITLE = "Search Station Data";
    private RecordFindPanel findPanel;
    private AppPanel accessoryPanel;
    private boolean canApplyNew;
    private boolean closeOnApply;
    private JPanel accessoryWrapperPanel;
    private JButton closeButton;
    private JButton[] applyButtons;
    private JPanel buttonPanel;
    public SourceEditData source;
    public ExtDbRecord record;
    public int applyButtonID;
    private RecordFind outerThis = this;

    public RecordFind(AppEditor appEditor, int n, int n2) {
        super(appEditor, WINDOW_TITLE);
        this.doSetup(n, n2);
    }

    public RecordFind(AppEditor appEditor, String string, int n, int n2) {
        super(appEditor, string);
        this.doSetup(n, n2);
    }

    private void doSetup(int n, int n2) {
        this.findPanel = new RecordFindPanel((AppEditor)this, new Runnable(){

            @Override
            public void run() {
                RecordFind.this.findPanelSelectionChanged();
            }
        }, n, n2);
        this.accessoryWrapperPanel = new JPanel();
        this.closeButton = new JButton("Close");
        this.closeButton.setFocusable(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordFind.this.closeIfPossible();
            }
        });
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.buttonPanel.add(this.closeButton);
        Box box = Box.createVerticalBox();
        box.add(this.accessoryWrapperPanel);
        box.add(this.buttonPanel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.findPanel, "Center");
        container.add((Component)box, "South");
        this.getRootPane().setDefaultButton(this.findPanel.getDefaultButton());
        this.pack();
        Dimension dimension = new Dimension(1170, 700);
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.fileMenu.removeAll();
        this.findPanel.addMenuItems(this.fileMenu);
        this.updateDocumentName();
    }

    @Override
    public void dispose() {
        if (null != this.accessoryPanel) {
            this.accessoryWrapperPanel.removeAll();
            this.accessoryPanel.setParent(null);
            this.accessoryPanel = null;
        }
        super.dispose();
    }

    @Override
    protected boolean showsFileMenu() {
        return true;
    }

    @Override
    protected String getFileMenuName() {
        return "Record";
    }

    @Override
    protected boolean showsEditMenu() {
        return false;
    }

    public void setDefaultExtDbKey(Integer n) {
        this.findPanel.setDefaultExtDbKey(n);
    }

    public void setTVChannelRange(int n, int n2) {
        this.findPanel.setTVChannelRange(n, n2);
    }

    public void setNote(String string) {
        this.findPanel.setNote(string);
    }

    public void setStudy(StudyEditData studyEditData) {
        this.findPanel.setStudy(studyEditData);
    }

    public void setAccessoryPanel(AppPanel appPanel) {
        if (this.isVisible()) {
            return;
        }
        if (null != this.accessoryPanel) {
            this.accessoryWrapperPanel.removeAll();
            this.accessoryPanel.setParent(null);
        }
        this.accessoryPanel = appPanel;
        if (null != this.accessoryPanel) {
            this.accessoryPanel.setParent(this);
            this.accessoryWrapperPanel.add(this.accessoryPanel);
        }
    }

    public AppPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    public void setApply(String[] stringArray, int[] nArray, boolean bl, boolean bl2) {
        if (this.isVisible()) {
            return;
        }
        this.buttonPanel.removeAll();
        this.buttonPanel.add(this.closeButton);
        if (null == stringArray || 0 == stringArray.length) {
            this.canApplyNew = false;
            this.closeOnApply = false;
            this.closeButton.setText("Close");
            this.applyButtons = null;
        } else {
            this.canApplyNew = bl;
            this.closeOnApply = bl2;
            if (this.closeOnApply) {
                this.closeButton.setText("Cancel");
            } else {
                this.closeButton.setText("Close");
            }
            this.applyButtons = new JButton[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.applyButtons[i] = new JButton(stringArray[i]);
                this.applyButtons[i].setFocusable(false);
                final int n = nArray[i];
                this.applyButtons[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RecordFind.this.doApply(n);
                    }
                });
                this.buttonPanel.add(this.applyButtons[i]);
            }
        }
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
        this.findPanel.updateDocumentName();
    }

    public void findPanelSelectionChanged() {
        if (null != this.accessoryPanel) {
            this.accessoryPanel.selectionChanged(this.findPanel.getSelectedRecord());
        }
        boolean bl = this.findPanel.canApplySelection(this.canApplyNew);
        if (null != this.accessoryPanel) {
            this.accessoryPanel.setEnabled(bl);
        }
        if (null != this.applyButtons) {
            for (JButton jButton : this.applyButtons) {
                jButton.setEnabled(bl);
            }
        }
    }

    public boolean canApplyRecord(StationRecord stationRecord, boolean bl) {
        return this.findPanel.canApplyRecord(stationRecord, bl);
    }

    public void recordWasApplied(StationRecord stationRecord) {
        this.findPanel.recordWasApplied(stationRecord);
    }

    private void doApply(int n) {
        if (null == this.applyButtons || !this.findPanel.canApplySelection(this.canApplyNew)) {
            return;
        }
        this.errorReporter.clearTitle();
        if (null != this.accessoryPanel && !this.accessoryPanel.validateInput()) {
            return;
        }
        StationRecord stationRecord = this.findPanel.getSelectedRecord();
        if (stationRecord.isSource()) {
            this.source = (SourceEditData)stationRecord;
            this.record = null;
        } else {
            this.source = null;
            this.record = (ExtDbRecord)stationRecord;
        }
        this.applyButtonID = n;
        if (!this.parent.applyEditsFrom(this)) {
            return;
        }
        this.findPanel.selectionWasApplied();
        if (this.closeOnApply) {
            this.closeIfPossible();
        }
    }

    @Override
    public void windowWillOpen() {
        this.findPanel.windowWillOpen();
        if (null != this.accessoryPanel) {
            this.accessoryPanel.windowWillOpen();
            this.accessoryPanel.setEnabled(false);
        }
        this.blockActionsClear();
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        if (!this.findPanel.windowShouldClose()) {
            return false;
        }
        return null == this.accessoryPanel || this.accessoryPanel.windowShouldClose();
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        this.findPanel.windowWillClose();
        if (null != this.accessoryPanel) {
            this.accessoryPanel.windowWillClose();
        }
        this.blockActionsSet();
        this.parent.editorClosing(this);
    }
}

