/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbListener;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.OutputConfig;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.StudyBuild;
import gov.fcc.tvstudy.core.StudyBuildIxCheck;
import gov.fcc.tvstudy.core.StudyBuildTV6FM;
import gov.fcc.tvstudy.core.StudyBuildWireless;
import gov.fcc.tvstudy.core.data.Parameter;
import gov.fcc.tvstudy.core.data.Template;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppPanel;
import gov.fcc.tvstudy.gui.DateSelectionPanel;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.OutputConfigDialog;
import gov.fcc.tvstudy.gui.RecordFind;
import gov.fcc.tvstudy.gui.RecordFindDialog;
import gov.fcc.tvstudy.gui.TextInputDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class OptionsPanel
extends AppPanel {
    protected boolean showName;
    protected String nameLabel;
    protected JTextField nameField;
    protected JPanel namePanel;
    protected boolean showDescription;
    protected String descriptionLabel;
    protected JButton descriptionButton;
    protected JPanel descriptionPanel;
    protected boolean showEdit;
    protected JCheckBox editableCheckBox;
    protected boolean isNew;
    protected JPanel editPanel;
    protected boolean showChannel;
    protected boolean allowMultiChannel;
    protected JCheckBox replicateCheckBox;
    protected JCheckBox changeChannelCheckBox;
    protected JTextField channelField;
    protected boolean isDigital;
    protected boolean isLPTV;
    protected boolean isClassA;
    protected int channel;
    protected Date sequenceDate;
    protected JPanel channelPanel;
    protected boolean showOutput;
    protected boolean showOutputMenus;
    protected JComboBox<OutputConfig> fileOutputConfigMenu;
    protected JComboBox<OutputConfig> mapOutputConfigMenu;
    protected JButton editConfigButton;
    protected JLabel fileOutputConfigLabel;
    protected JLabel mapOutputConfigLabel;
    protected JPanel outputPanel;
    protected boolean showRun;
    protected JComboBox<String> memoryFractionMenu;
    protected JButton commentButton;
    protected JPanel runPanel;
    protected boolean enabled = true;
    public String defaultName;
    public String defaultDescription;
    public OutputConfig defaultFileOutputConfig;
    public OutputConfig defaultMapOutputConfig;
    public String name;
    public String description;
    public boolean isLocked;
    public boolean replicate;
    public boolean changeChannel;
    public int studyChannel;
    public int[] studyChannels;
    public boolean includeOriginalChannelStudy;
    public OutputConfig fileOutputConfig;
    public OutputConfig mapOutputConfig;
    public double memoryFraction;
    public String comment;

    protected OptionsPanel(AppEditor appEditor, boolean bl, String string, boolean bl2, String string2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        super(appEditor);
        JComponent jComponent;
        JPanel jPanel;
        Object object;
        this.showName = bl;
        this.nameLabel = string;
        this.showDescription = bl2;
        this.descriptionLabel = string2;
        this.showEdit = bl3;
        this.showChannel = bl4;
        this.allowMultiChannel = bl5;
        this.showOutput = bl6;
        if (this.showOutput) {
            this.showOutputMenus = bl7;
        }
        this.showRun = bl8;
        if (this.showName) {
            this.nameField = new JTextField(20);
            AppController.fixKeyBindings(this.nameField);
            this.namePanel = new JPanel();
            this.namePanel.add(this.nameField);
            this.namePanel.setBorder(BorderFactory.createTitledBorder(this.nameLabel));
        }
        if (this.showDescription) {
            this.descriptionButton = new JButton(this.descriptionLabel);
            this.descriptionButton.setFocusable(false);
            this.descriptionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsPanel.this.doEditDescription();
                }
            });
            this.descriptionPanel = new JPanel(new FlowLayout(0));
            this.descriptionPanel.add(this.descriptionButton);
            this.description = "";
        }
        if (this.showEdit) {
            this.editableCheckBox = new JCheckBox("Allow editing");
            this.editableCheckBox.setFocusable(false);
            this.editableCheckBox.setToolTipText("<HTML>Allow the station record to be edited.  Changes apply only in the current scenario.<BR>Use only if necessary, editable records can significantly increase study run times.</HTML>");
            AppController.setComponentEnabled(this.editableCheckBox, false);
            if (this.showChannel) {
                this.editableCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (OptionsPanel.this.blockActions()) {
                            if (OptionsPanel.this.editableCheckBox.isSelected()) {
                                OptionsPanel.this.replicateCheckBox.setSelected(false);
                                AppController.setComponentEnabled(OptionsPanel.this.channelField, OptionsPanel.this.changeChannelCheckBox.isSelected());
                            } else {
                                OptionsPanel.this.changeChannelCheckBox.setSelected(false);
                                AppController.setComponentEnabled(OptionsPanel.this.channelField, OptionsPanel.this.replicateCheckBox.isSelected());
                            }
                            OptionsPanel.this.blockActionsEnd();
                        }
                    }
                });
            }
            this.editPanel = new JPanel(new FlowLayout(0));
            this.editPanel.add(this.editableCheckBox);
        }
        if (this.showChannel) {
            this.replicateCheckBox = new JCheckBox("Replicate");
            this.replicateCheckBox.setFocusable(false);
            this.replicateCheckBox.setToolTipText("<HTML>Study a TV station on a different channel using a derived<BR>ERP and azimuth pattern replicating the original coverage.</HTML>");
            AppController.setComponentEnabled(this.replicateCheckBox, false);
            this.replicateCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OptionsPanel.this.blockActions()) {
                        if (OptionsPanel.this.replicateCheckBox.isSelected()) {
                            OptionsPanel.this.changeChannelCheckBox.setSelected(false);
                            if (OptionsPanel.this.showEdit) {
                                OptionsPanel.this.editableCheckBox.setSelected(false);
                            }
                            AppController.setComponentEnabled(OptionsPanel.this.channelField, true);
                        } else {
                            AppController.setComponentEnabled(OptionsPanel.this.channelField, OptionsPanel.this.changeChannelCheckBox.isSelected());
                        }
                        OptionsPanel.this.blockActionsEnd();
                    }
                }
            });
            this.changeChannelCheckBox = new JCheckBox("Change Channel");
            this.changeChannelCheckBox.setFocusable(false);
            this.changeChannelCheckBox.setToolTipText("<HTML>Change the channel of the study record,<BR>preserving the existing ERP and pattern.</HTML>");
            AppController.setComponentEnabled(this.changeChannelCheckBox, false);
            this.changeChannelCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OptionsPanel.this.blockActions()) {
                        if (OptionsPanel.this.changeChannelCheckBox.isSelected()) {
                            OptionsPanel.this.replicateCheckBox.setSelected(false);
                            if (OptionsPanel.this.showEdit) {
                                OptionsPanel.this.editableCheckBox.setSelected(true);
                            }
                            AppController.setComponentEnabled(OptionsPanel.this.channelField, true);
                        } else {
                            AppController.setComponentEnabled(OptionsPanel.this.channelField, OptionsPanel.this.replicateCheckBox.isSelected());
                        }
                        OptionsPanel.this.blockActionsEnd();
                    }
                }
            });
            this.channelField = new JTextField(8);
            AppController.fixKeyBindings(this.channelField);
            AppController.setComponentEnabled(this.channelField, false);
            object = new JPanel(new FlowLayout(0));
            ((Container)object).add(this.replicateCheckBox);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.changeChannelCheckBox);
            jComponent = Box.createVerticalBox();
            jComponent.add((Component)object);
            jComponent.add(jPanel);
            JPanel jPanel2 = new JPanel();
            if (this.allowMultiChannel) {
                jPanel2.setBorder(BorderFactory.createTitledBorder("Channel(s)"));
            } else {
                jPanel2.setBorder(BorderFactory.createTitledBorder("Channel"));
            }
            jPanel2.add(this.channelField);
            this.channelPanel = new JPanel();
            this.channelPanel.add(jComponent);
            this.channelPanel.add(jPanel2);
        }
        if (this.showOutput) {
            this.outputPanel = new JPanel();
            if (this.showOutputMenus) {
                this.fileOutputConfigMenu = new JComboBox();
                this.fileOutputConfigMenu.setFocusable(false);
                object = new OutputConfig(1, "");
                ((OutputConfig)object).name = "XyXyXyXyXyXyXyXyXy";
                this.fileOutputConfigMenu.setPrototypeDisplayValue((OutputConfig)object);
                this.fileOutputConfigMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (OptionsPanel.this.blockActions()) {
                            OptionsPanel.this.fileOutputConfig = (OutputConfig)OptionsPanel.this.fileOutputConfigMenu.getSelectedItem();
                            OptionsPanel.this.blockActionsEnd();
                        }
                    }
                });
                this.mapOutputConfigMenu = new JComboBox();
                this.mapOutputConfigMenu.setFocusable(false);
                object = new OutputConfig(2, "");
                ((OutputConfig)object).name = "XyXyXyXyXyXyXyXyXy";
                this.mapOutputConfigMenu.setPrototypeDisplayValue((OutputConfig)object);
                this.mapOutputConfigMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (OptionsPanel.this.blockActions()) {
                            OptionsPanel.this.mapOutputConfig = (OutputConfig)OptionsPanel.this.mapOutputConfigMenu.getSelectedItem();
                            OptionsPanel.this.blockActionsEnd();
                        }
                    }
                });
                this.outputPanel.setBorder(BorderFactory.createTitledBorder("Output Settings"));
                this.outputPanel.add(new JLabel("File:"));
                this.outputPanel.add(this.fileOutputConfigMenu);
                this.outputPanel.add(new JLabel("Map:"));
                this.outputPanel.add(this.mapOutputConfigMenu);
                this.editConfigButton = new JButton("Edit");
                this.outputPanel.add(this.editConfigButton);
            } else {
                this.editConfigButton = new JButton("Output Settings");
                this.fileOutputConfigLabel = new JLabel();
                this.mapOutputConfigLabel = new JLabel();
                object = new JPanel();
                ((Container)object).add(this.editConfigButton);
                jPanel = new JPanel();
                jPanel.add(this.fileOutputConfigLabel);
                jComponent = new JPanel();
                jComponent.add(this.mapOutputConfigLabel);
                this.outputPanel.setLayout(new BoxLayout(this.outputPanel, 1));
                this.outputPanel.add((Component)object);
                this.outputPanel.add(jPanel);
                this.outputPanel.add(jComponent);
            }
            this.editConfigButton.setFocusable(false);
            this.editConfigButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsPanel.this.doEditOutputConfigs();
                }
            });
        }
        if (this.showRun) {
            this.memoryFractionMenu = new JComboBox();
            this.memoryFractionMenu.setFocusable(false);
            this.memoryFractionMenu.addItem("All");
            for (int i = 2; i <= AppCore.maxEngineProcessCount; ++i) {
                this.memoryFractionMenu.addItem("1/" + String.valueOf(i));
            }
            this.commentButton = new JButton("Comment");
            this.commentButton.setFocusable(false);
            this.commentButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsPanel.this.doEditComment();
                }
            });
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createTitledBorder("Memory Use"));
            jPanel3.add(this.memoryFractionMenu);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.commentButton);
            this.runPanel = new JPanel();
            this.runPanel.add(jPanel3);
            this.runPanel.add(jPanel);
            this.comment = "";
        }
        this.createLayout(this);
    }

    protected void createLayout(JPanel jPanel) {
        if (this.showName) {
            jPanel.add(this.namePanel);
        }
        if (this.showDescription) {
            jPanel.add(this.descriptionPanel);
        }
        if (this.showEdit) {
            jPanel.add(this.editPanel);
        }
        if (this.showChannel) {
            jPanel.add(this.channelPanel);
        }
        if (this.showOutput) {
            jPanel.add(this.outputPanel);
        }
        if (this.showRun) {
            jPanel.add(this.runPanel);
        }
    }

    private void doEditDescription() {
        TextInputDialog textInputDialog = new TextInputDialog(this.parent, this.descriptionLabel, this.descriptionLabel);
        textInputDialog.setInput(this.description);
        AppController.showWindow(textInputDialog);
        if (textInputDialog.canceled) {
            return;
        }
        this.description = textInputDialog.getInput();
    }

    private void doEditOutputConfigs() {
        if (!this.showOutput) {
            return;
        }
        ArrayList<OutputConfig> arrayList = new ArrayList<OutputConfig>();
        arrayList.add(this.fileOutputConfig);
        arrayList.add(this.mapOutputConfig);
        OutputConfigDialog outputConfigDialog = new OutputConfigDialog((AppEditor)this, arrayList, false);
        AppController.showWindow(outputConfigDialog);
        for (OutputConfig outputConfig : outputConfigDialog.getConfigs()) {
            switch (outputConfig.type) {
                case 1: {
                    this.fileOutputConfig = outputConfig;
                    break;
                }
                case 2: {
                    this.mapOutputConfig = outputConfig;
                }
            }
        }
        this.updateOutputConfigUI();
    }

    private void updateOutputConfigUI() {
        if (this.showOutputMenus) {
            this.blockActionsStart();
            ArrayList arrayList = OutputConfig.getConfigs((String)this.getDbID(), (int)1);
            this.fileOutputConfigMenu.removeAllItems();
            for (OutputConfig outputConfig : arrayList) {
                this.fileOutputConfigMenu.addItem(outputConfig);
            }
            if (!arrayList.contains(this.fileOutputConfig)) {
                this.fileOutputConfigMenu.addItem(this.fileOutputConfig);
            }
            this.fileOutputConfigMenu.setSelectedItem(this.fileOutputConfig);
            arrayList = OutputConfig.getConfigs((String)this.getDbID(), (int)2);
            this.mapOutputConfigMenu.removeAllItems();
            for (OutputConfig outputConfig : arrayList) {
                this.mapOutputConfigMenu.addItem(outputConfig);
            }
            if (!arrayList.contains(this.mapOutputConfig)) {
                this.mapOutputConfigMenu.addItem(this.mapOutputConfig);
            }
            this.mapOutputConfigMenu.setSelectedItem(this.mapOutputConfig);
            this.blockActionsEnd();
        } else {
            this.fileOutputConfigLabel.setText("File: " + this.fileOutputConfig.name);
            this.mapOutputConfigLabel.setText("Map: " + this.mapOutputConfig.name);
        }
    }

    private void doEditComment() {
        TextInputDialog textInputDialog = new TextInputDialog(this.parent, "Comment", "Comment");
        textInputDialog.setInput(this.comment);
        AppController.showWindow(textInputDialog);
        if (textInputDialog.canceled) {
            return;
        }
        this.comment = textInputDialog.getInput();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.showName) {
            AppController.setComponentEnabled(this.nameField, bl);
        }
        if (this.showDescription) {
            this.descriptionButton.setEnabled(bl);
        }
        if (this.showEdit) {
            if (this.isNew) {
                AppController.setComponentEnabled(this.editableCheckBox, false);
            } else {
                AppController.setComponentEnabled(this.editableCheckBox, bl);
            }
        }
        if (this.showChannel) {
            boolean bl2 = bl;
            if (this.isNew || 0 == this.channel) {
                bl2 = false;
            }
            AppController.setComponentEnabled(this.replicateCheckBox, bl2);
            AppController.setComponentEnabled(this.changeChannelCheckBox, bl);
            if (this.replicateCheckBox.isSelected() || this.changeChannelCheckBox.isSelected()) {
                AppController.setComponentEnabled(this.channelField, bl);
            } else {
                AppController.setComponentEnabled(this.channelField, false);
            }
        }
        if (this.showOutput) {
            if (this.showOutputMenus) {
                AppController.setComponentEnabled(this.fileOutputConfigMenu, bl);
                AppController.setComponentEnabled(this.mapOutputConfigMenu, bl);
            }
            this.editConfigButton.setEnabled(bl);
        }
        if (this.showRun) {
            AppController.setComponentEnabled(this.memoryFractionMenu, bl);
            this.commentButton.setEnabled(bl);
        }
        this.enabled = bl;
    }

    @Override
    public void clearFields() {
        this.blockActionsStart();
        if (this.showName) {
            if (null == this.defaultName) {
                this.defaultName = "";
            }
            this.nameField.setText(this.defaultName);
        }
        if (this.showDescription) {
            if (null == this.defaultDescription) {
                this.defaultDescription = "";
            }
            this.description = this.defaultDescription;
        }
        if (this.showEdit) {
            if (this.isNew) {
                this.editableCheckBox.setSelected(true);
                AppController.setComponentEnabled(this.editableCheckBox, false);
            } else {
                this.editableCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.editableCheckBox, true);
            }
        }
        if (this.showChannel) {
            this.replicateCheckBox.setSelected(false);
            this.changeChannelCheckBox.setSelected(false);
            this.channelField.setText("");
            AppController.setComponentEnabled(this.channelField, false);
        }
        if (this.showOutput) {
            if (null == this.defaultFileOutputConfig || this.defaultFileOutputConfig.isNull()) {
                this.defaultFileOutputConfig = OutputConfig.getLastUsed((String)this.getDbID(), (int)1);
            }
            this.fileOutputConfig = this.defaultFileOutputConfig;
            if (null == this.defaultMapOutputConfig || this.defaultMapOutputConfig.isNull()) {
                this.defaultMapOutputConfig = OutputConfig.getLastUsed((String)this.getDbID(), (int)2);
            }
            this.mapOutputConfig = this.defaultMapOutputConfig;
            this.updateOutputConfigUI();
        }
        if (this.showRun) {
            String string = AppCore.getPreference((String)"defaultEngineMemoryLimit");
            if (null != string) {
                int n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n > AppCore.maxEngineProcessCount) {
                    n = AppCore.maxEngineProcessCount;
                }
                if (n < 0) {
                    n = 0;
                }
                this.memoryFractionMenu.setSelectedIndex(n);
            } else {
                this.memoryFractionMenu.setSelectedIndex(0);
            }
            this.comment = "";
        }
        this.blockActionsEnd();
    }

    @Override
    public void selectionChanged(Object object) {
        if (null == object) {
            this.isNew = false;
            this.isDigital = false;
            this.isLPTV = false;
            this.isClassA = false;
            this.channel = 0;
            this.sequenceDate = null;
            if (this.showEdit) {
                this.editableCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.editableCheckBox, false);
            }
            if (this.showChannel) {
                this.replicateCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.replicateCheckBox, false);
                this.changeChannelCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.changeChannelCheckBox, false);
                AppController.setComponentEnabled(this.channelField, false);
            }
            return;
        }
        if (object instanceof SourceEditData) {
            SourceEditData sourceEditData = (SourceEditData)object;
            this.isNew = !sourceEditData.isLocked;
            this.isDigital = sourceEditData.service.isDigital();
            this.isLPTV = sourceEditData.service.isLPTV();
            this.isClassA = sourceEditData.service.isClassA();
            this.channel = sourceEditData.getChannelNumber();
            this.sequenceDate = AppCore.parseDate((String)sourceEditData.getAttribute("sequenceDate"));
            if (null == this.sequenceDate) {
                this.sequenceDate = new Date();
            }
        } else if (object instanceof ExtDbRecord) {
            ExtDbRecord extDbRecord = (ExtDbRecord)object;
            this.isNew = false;
            this.isDigital = extDbRecord.service.isDigital();
            this.isLPTV = extDbRecord.service.isLPTV();
            this.isClassA = extDbRecord.service.isClassA();
            this.channel = extDbRecord.getChannelNumber();
            if (1 == extDbRecord.recordType) {
                ExtDbRecordTV extDbRecordTV = (ExtDbRecordTV)extDbRecord;
                if (extDbRecordTV.replicateToChannel > 0 && this.showChannel && !this.replicateCheckBox.isSelected()) {
                    this.replicateCheckBox.setSelected(true);
                    this.channelField.setText(String.valueOf(extDbRecordTV.replicateToChannel));
                }
            }
            this.sequenceDate = extDbRecord.sequenceDate;
        } else {
            this.isNew = false;
            this.isDigital = false;
            this.isLPTV = false;
            this.isClassA = false;
            this.channel = 0;
            this.sequenceDate = null;
        }
        if (this.showEdit) {
            if (this.isNew) {
                this.editableCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.editableCheckBox, false);
            } else {
                AppController.setComponentEnabled(this.editableCheckBox, true);
            }
        }
        if (this.showChannel) {
            if (this.isNew || 0 == this.channel) {
                this.replicateCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.replicateCheckBox, false);
            } else {
                AppController.setComponentEnabled(this.replicateCheckBox, true);
            }
            AppController.setComponentEnabled(this.changeChannelCheckBox, true);
            AppController.setComponentEnabled(this.channelField, this.replicateCheckBox.isSelected() || this.changeChannelCheckBox.isSelected());
        }
    }

    protected boolean isNameRequired() {
        return true;
    }

    protected boolean noReplicateChangeSameChannel() {
        return true;
    }

    @Override
    public boolean validateInput() {
        this.name = "";
        if (this.showName) {
            this.name = this.nameField.getText().trim();
            if (this.isNameRequired() && 0 == this.name.length()) {
                this.errorReporter.reportWarning("Please provide a name");
                return false;
            }
        }
        this.isLocked = true;
        if (this.showEdit) {
            this.isLocked = !this.editableCheckBox.isSelected();
        }
        this.replicate = false;
        this.changeChannel = false;
        this.studyChannel = 0;
        this.studyChannels = null;
        this.includeOriginalChannelStudy = false;
        if (this.showChannel) {
            this.replicate = this.replicateCheckBox.isSelected();
            boolean bl = this.changeChannel = this.changeChannelCheckBox.isSelected() && !this.replicate;
            if (this.replicate || this.changeChannel) {
                Object object;
                boolean bl2 = false;
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                String string = this.channelField.getText().trim();
                if (string.length() > 0) {
                    object = string.split(",");
                    String[] stringArray = null;
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    for (String string2 : object) {
                        if (string2.contains("-")) {
                            stringArray = string2.split("-");
                            if (2 == stringArray.length) {
                                try {
                                    n2 = Integer.parseInt(stringArray[0].trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    bl2 = true;
                                }
                                if (bl2) break;
                                if (n2 < 2 || n2 > 69) {
                                    bl2 = true;
                                    break;
                                }
                                try {
                                    n3 = Integer.parseInt(stringArray[1].trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    bl2 = true;
                                }
                                if (bl2) break;
                                if (n3 < 2 || n3 > 69) {
                                    bl2 = true;
                                    break;
                                }
                                if (n2 <= n3) {
                                    for (n = n2; n <= n3; ++n) {
                                        treeSet.add(n);
                                    }
                                    continue;
                                }
                                for (n = n3; n <= n2; ++n) {
                                    treeSet.add(n);
                                }
                                continue;
                            }
                            bl2 = true;
                            break;
                        }
                        try {
                            n = Integer.parseInt(string2.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl2 = true;
                        }
                        if (bl2) break;
                        if (n < 2 || n > 69) {
                            bl2 = true;
                            break;
                        }
                        treeSet.add(n);
                    }
                } else {
                    bl2 = true;
                }
                if (this.replicate || this.changeChannel) {
                    Object object2 = object = this.replicate ? "replication" : "study";
                    if (this.allowMultiChannel) {
                        if (bl2 || treeSet.isEmpty()) {
                            this.errorReporter.reportWarning("Please enter valid " + (String)object + " channels\nUse commas and dashes for multiple channels and ranges");
                            return false;
                        }
                        if ((this.isDigital || this.changeChannel) && treeSet.remove(this.channel)) {
                            if (treeSet.isEmpty() && this.noReplicateChangeSameChannel()) {
                                this.errorReporter.reportWarning("The " + (String)object + " channel must be different than the original channel");
                                return false;
                            }
                            this.includeOriginalChannelStudy = true;
                        }
                        this.studyChannels = new int[treeSet.size()];
                        int n = 0;
                        for (Integer n4 : treeSet) {
                            this.studyChannels[n++] = n4;
                        }
                        this.studyChannel = this.studyChannels[0];
                    } else {
                        if (bl2 || treeSet.isEmpty()) {
                            this.errorReporter.reportWarning("Please enter a valid " + (String)object + " channel");
                            return false;
                        }
                        if (treeSet.size() > 1) {
                            this.errorReporter.reportWarning("Please enter a single " + (String)object + " channel");
                            return false;
                        }
                        this.studyChannel = (Integer)treeSet.first();
                        if ((this.isDigital || this.changeChannel) && this.studyChannel == this.channel && this.noReplicateChangeSameChannel()) {
                            this.errorReporter.reportWarning("The " + (String)object + " channel must be different than the original channel");
                            this.studyChannel = 0;
                            return false;
                        }
                    }
                }
            }
        }
        if (this.showOutput) {
            if (null == this.fileOutputConfig || this.fileOutputConfig.isNull() || !this.fileOutputConfig.isValid()) {
                this.errorReporter.reportWarning("Please provide valid output file settings");
                return false;
            }
            if (null == this.mapOutputConfig || this.mapOutputConfig.isNull() || !this.mapOutputConfig.isValid()) {
                this.errorReporter.reportWarning("Please provide valid map output settings");
                return false;
            }
            this.fileOutputConfig.saveAsLastUsed(this.getDbID());
            this.mapOutputConfig.saveAsLastUsed(this.getDbID());
        } else {
            this.fileOutputConfig = null;
            this.mapOutputConfig = null;
        }
        this.memoryFraction = 1.0;
        if (this.showRun) {
            this.memoryFraction = 1.0 / (double)(this.memoryFractionMenu.getSelectedIndex() + 1);
        }
        return true;
    }

    public ArrayList<StudyBuild> getStudyBuilds() {
        return null;
    }

    @Override
    public void windowWillOpen() {
        this.clearFields();
    }

    public static class RunStart
    extends OptionsPanel {
        public RunStart(AppEditor appEditor) {
            super(appEditor, false, null, false, null, false, false, false, true, true, true);
        }
    }

    public static class TV6FMStudy
    extends OptionsPanel
    implements ExtDbListener {
        private KeyedRecordMenu templateMenu;
        private KeyedRecordMenu fmExtDbMenu;
        private JCheckBox maskingCheckBox;
        private KeyedRecordMenu tvExtDbMenu;
        private StationRecord selectedRecord;
        public StudyBuildTV6FM studyBuild;

        public TV6FMStudy(AppEditor appEditor, StudyBuildTV6FM studyBuildTV6FM) {
            super(appEditor, true, "Study Name", true, "Study Description", false, true, false, true, false, true);
            this.setBorder(BorderFactory.createTitledBorder("Study Build Settings"));
            this.studyBuild = studyBuildTV6FM;
            this.defaultName = studyBuildTV6FM.studyName;
            this.defaultDescription = studyBuildTV6FM.studyDescription;
            this.templateMenu = new KeyedRecordMenu();
            this.templateMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXy"));
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Template"));
            jPanel.add(this.templateMenu);
            this.fmExtDbMenu = new KeyedRecordMenu();
            this.fmExtDbMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXy"));
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("FM Station Data"));
            jPanel2.add(this.fmExtDbMenu);
            this.maskingCheckBox = new JCheckBox("Include TV masking interference");
            this.maskingCheckBox.setFocusable(false);
            this.maskingCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppController.setComponentEnabled(tvExtDbMenu, maskingCheckBox.isSelected());
                }
            });
            this.tvExtDbMenu = new KeyedRecordMenu();
            this.tvExtDbMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXy"));
            AppController.setComponentEnabled(this.tvExtDbMenu, false);
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createTitledBorder("TV Station Data"));
            jPanel3.add(this.tvExtDbMenu);
            Box box = Box.createVerticalBox();
            box.add(this.channelPanel);
            box.add(jPanel);
            JPanel jPanel4 = new JPanel(new FlowLayout(0));
            jPanel4.add(this.maskingCheckBox);
            Box box2 = Box.createVerticalBox();
            box2.add(jPanel2);
            box2.add(jPanel4);
            box2.add(jPanel3);
            JPanel jPanel5 = new JPanel();
            jPanel5.add(this.namePanel);
            jPanel5.add(this.descriptionPanel);
            JPanel jPanel6 = new JPanel();
            jPanel6.add(this.outputPanel);
            jPanel6.add(this.runPanel);
            Box box3 = Box.createVerticalBox();
            box3.add(jPanel5);
            box3.add(jPanel6);
            this.add(box);
            this.add(box2);
            this.add(box3);
        }

        @Override
        protected void createLayout(JPanel jPanel) {
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            AppController.setComponentEnabled(this.templateMenu, bl);
            AppController.setComponentEnabled(this.fmExtDbMenu, bl);
            AppController.setComponentEnabled(this.maskingCheckBox, bl);
            if (this.maskingCheckBox.isSelected()) {
                AppController.setComponentEnabled(this.tvExtDbMenu, bl);
            } else {
                AppController.setComponentEnabled(this.tvExtDbMenu, false);
            }
        }

        public void updateExtDbList() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayList arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)3, (boolean)false, (boolean)true);
                    if (null == arrayList) {
                        return;
                    }
                    this.blockActionsStart();
                    int n = fmExtDbMenu.getSelectedKey();
                    fmExtDbMenu.removeAllItems();
                    if (!arrayList.isEmpty()) {
                        fmExtDbMenu.addAllItems(arrayList);
                        if (fmExtDbMenu.containsKey(n)) {
                            fmExtDbMenu.setSelectedKey(n);
                        }
                    }
                    this.blockActionsEnd();
                    arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)1, (boolean)false, (boolean)true);
                    if (null == arrayList) {
                        return;
                    }
                    this.blockActionsStart();
                    n = tvExtDbMenu.getSelectedKey();
                    tvExtDbMenu.removeAllItems();
                    if (!arrayList.isEmpty()) {
                        tvExtDbMenu.addAllItems(arrayList);
                        if (tvExtDbMenu.containsKey(n)) {
                            tvExtDbMenu.setSelectedKey(n);
                        }
                    }
                    this.blockActionsEnd();
                }
            });
        }

        @Override
        public void windowWillOpen() {
            ExtDb.addListener((ExtDbListener)this);
            this.templateMenu.removeAllItems();
            this.fmExtDbMenu.removeAllItems();
            this.tvExtDbMenu.removeAllItems();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.blockActionsStart();
                    errorReporter.setTitle("Load Template List");
                    ArrayList arrayList = Template.getTemplateInfoList((String)this.getDbID(), (ErrorLogger)errorReporter);
                    if (null != arrayList) {
                        templateMenu.addAllItems(arrayList);
                    }
                    errorReporter.setTitle("Load Station Data List");
                    arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)3, (boolean)false, (boolean)true, (ErrorLogger)errorReporter);
                    if (null != arrayList) {
                        if (arrayList.isEmpty()) {
                            errorReporter.reportError("No FM station data found, use Station Data Manager to add data");
                        } else {
                            fmExtDbMenu.addAllItems(arrayList);
                        }
                    }
                    if (null != (arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)1, (boolean)false, (boolean)true, (ErrorLogger)errorReporter))) {
                        tvExtDbMenu.addAllItems(arrayList);
                    }
                    this.clearFields();
                    this.blockActionsEnd();
                }
            });
        }

        @Override
        public void windowWillClose() {
            ExtDb.removeListener((ExtDbListener)this);
        }

        @Override
        public void clearFields() {
            int n;
            super.clearFields();
            this.blockActionsStart();
            if (this.studyBuild.templateKey > 0 && this.templateMenu.containsKey(this.studyBuild.templateKey)) {
                this.templateMenu.setSelectedKey(this.studyBuild.templateKey);
            } else {
                this.templateMenu.setSelectedIndex(0);
            }
            if (null != this.studyBuild.fmExtDb) {
                n = this.studyBuild.fmExtDb.key;
                if (this.fmExtDbMenu.containsKey(n)) {
                    this.fmExtDbMenu.setSelectedKey(n);
                } else {
                    this.fmExtDbMenu.setSelectedIndex(0);
                }
            } else {
                this.fmExtDbMenu.setSelectedIndex(0);
            }
            if (null != this.studyBuild.tvExtDb) {
                this.maskingCheckBox.setSelected(true);
                n = this.studyBuild.tvExtDb.key;
                if (this.tvExtDbMenu.containsKey(n)) {
                    this.tvExtDbMenu.setSelectedKey(n);
                } else {
                    this.tvExtDbMenu.setSelectedIndex(0);
                }
            } else {
                this.maskingCheckBox.setSelected(false);
                this.tvExtDbMenu.setSelectedIndex(0);
                AppController.setComponentEnabled(this.tvExtDbMenu, false);
            }
            this.blockActionsEnd();
        }

        @Override
        public void selectionChanged(Object object) {
            Object object2;
            super.selectionChanged(object);
            if (null == object) {
                return;
            }
            if (object instanceof SourceEditData) {
                object2 = (SourceEditData)object;
                if (1 == ((SourceEditData)object2).recordType) {
                    int n;
                    this.selectedRecord = object2;
                    if (null != ((SourceEditData)object2).extDbKey && this.tvExtDbMenu.containsKey(n = ((SourceEditData)object2).extDbKey.intValue())) {
                        this.tvExtDbMenu.setSelectedKey(n);
                    }
                }
            } else if (object instanceof ExtDbRecord) {
                object2 = (ExtDbRecord)object;
                if (1 == ((ExtDbRecord)object2).recordType) {
                    this.selectedRecord = object2;
                    int n = ((ExtDbRecord)object2).extDb.key;
                    if (this.tvExtDbMenu.containsKey(n)) {
                        this.tvExtDbMenu.setSelectedKey(n);
                    }
                }
            }
            if (object instanceof StationRecord && null != (object2 = ((StationRecord)object).getFileNumber()) && ((String)object2).length() > 0) {
                this.nameField.setText((String)object2);
            }
        }

        @Override
        public boolean validateInput() {
            this.errorReporter.clearTitle();
            if (null == this.selectedRecord) {
                this.errorReporter.reportWarning("Please select a TV record to study");
                return false;
            }
            if (!super.validateInput()) {
                return false;
            }
            int n = this.selectedRecord.getChannelNumber();
            if (this.replicate || this.changeChannel) {
                n = this.studyChannel;
            }
            if (6 != n) {
                this.errorReporter.reportWarning("The study record must be on or replicated/changed to channel 6");
                return false;
            }
            if (!DbCore.checkStudyName((String)this.name, (String)this.getDbID(), (boolean)false, (int)(this.replicate || this.changeChannel ? 10 : 0), (ErrorLogger)this.errorReporter)) {
                return false;
            }
            int n2 = this.templateMenu.getSelectedKey();
            if (n2 <= 0) {
                this.errorReporter.reportWarning("Please choose a study template");
                return false;
            }
            ExtDb extDb = null;
            int n3 = this.fmExtDbMenu.getSelectedKey();
            if (n3 > 0) {
                extDb = ExtDb.getExtDb((String)this.getDbID(), (Integer)n3);
            }
            if (null == extDb || extDb.deleted) {
                this.errorReporter.reportWarning("That FM station data set has been deleted, please select another");
                return false;
            }
            ExtDb extDb2 = null;
            if (this.maskingCheckBox.isSelected()) {
                n3 = this.tvExtDbMenu.getSelectedKey();
                if (n3 > 0) {
                    extDb2 = ExtDb.getExtDb((String)this.getDbID(), (Integer)n3);
                }
                if (null == extDb2 || extDb2.deleted) {
                    this.errorReporter.reportWarning("That TV station data set has been deleted, please select another");
                    return false;
                }
            }
            if (this.selectedRecord.isSource()) {
                this.studyBuild.source = (SourceEditData)this.selectedRecord;
            } else {
                this.studyBuild.record = (ExtDbRecord)this.selectedRecord;
            }
            this.studyBuild.replicate = this.replicate;
            this.studyBuild.changeChannel = this.changeChannel;
            this.studyBuild.studyChannel = this.studyChannel;
            this.studyBuild.studyName = this.replicate || this.changeChannel ? this.name + " (on " + String.valueOf(this.studyChannel) + ")" : this.name;
            this.studyBuild.studyDescription = null;
            if (this.description.length() > 0) {
                this.studyBuild.studyDescription = this.description;
            }
            this.studyBuild.templateKey = n2;
            this.studyBuild.fmExtDb = extDb;
            this.studyBuild.tvExtDb = extDb2;
            return true;
        }

        @Override
        public ArrayList<StudyBuild> getStudyBuilds() {
            ArrayList<StudyBuild> arrayList = new ArrayList<StudyBuild>();
            arrayList.add((StudyBuild)this.studyBuild);
            return arrayList;
        }
    }

    public static class WirelessStudy
    extends OptionsPanel
    implements ExtDbListener {
        private KeyedRecordMenu templateMenu;
        private KeyedRecordMenu wirelessExtDbMenu;
        private JCheckBox maskingCheckBox;
        private KeyedRecordMenu maskingExtDbMenu;
        private JTextField frequencyField;
        private JTextField bandwidthField;
        private StationRecord selectedRecord;
        private RecordsTableModel selectedRecordsModel;
        private JTable selectedRecordsTable;
        private JButton addRecordButton;
        private JButton removeRecordButton;
        public StudyBuildWireless studyBuild;
        private ArrayList<StudyBuild> studyBuilds;

        public WirelessStudy(AppEditor appEditor, StudyBuildWireless studyBuildWireless) {
            super(appEditor, true, "Study Name", true, "Study Description", false, true, false, true, false, true);
            this.setBorder(BorderFactory.createTitledBorder("Study Build Settings"));
            this.studyBuild = studyBuildWireless;
            this.defaultName = studyBuildWireless.studyName;
            this.defaultDescription = studyBuildWireless.studyDescription;
            this.templateMenu = new KeyedRecordMenu();
            this.templateMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXy"));
            this.templateMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.blockActions()) {
                        this.updateParams();
                        this.blockActionsEnd();
                    }
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Template"));
            jPanel.add(this.templateMenu);
            this.wirelessExtDbMenu = new KeyedRecordMenu();
            this.wirelessExtDbMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXy"));
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Wireless Station Data"));
            jPanel2.add(this.wirelessExtDbMenu);
            this.maskingCheckBox = new JCheckBox("Include masking interference");
            this.maskingCheckBox.setFocusable(false);
            this.maskingCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppController.setComponentEnabled(maskingExtDbMenu, maskingCheckBox.isSelected());
                }
            });
            this.maskingExtDbMenu = new KeyedRecordMenu();
            this.maskingExtDbMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXy"));
            AppController.setComponentEnabled(this.maskingExtDbMenu, false);
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createTitledBorder("TV Station Data"));
            jPanel3.add(this.maskingExtDbMenu);
            this.frequencyField = new JTextField(7);
            AppController.fixKeyBindings(this.frequencyField);
            JPanel jPanel4 = new JPanel();
            jPanel4.setBorder(BorderFactory.createTitledBorder("WL Freq., MHz"));
            jPanel4.add(this.frequencyField);
            this.bandwidthField = new JTextField(7);
            AppController.fixKeyBindings(this.bandwidthField);
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(BorderFactory.createTitledBorder("WL B/W, MHz"));
            jPanel5.add(this.bandwidthField);
            JPanel jPanel6 = new JPanel(new BorderLayout());
            this.selectedRecordsModel = new RecordsTableModel(jPanel6);
            this.selectedRecordsTable = this.selectedRecordsModel.createTable();
            this.selectedRecordsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    this.updateControls();
                }
            });
            this.addRecordButton = new JButton("Add");
            this.addRecordButton.setFocusable(false);
            this.addRecordButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doAddRecord();
                }
            });
            this.removeRecordButton = new JButton("Remove");
            this.removeRecordButton.setFocusable(false);
            this.removeRecordButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doRemoveRecord();
                }
            });
            Box box = Box.createVerticalBox();
            box.add(this.channelPanel);
            box.add(jPanel);
            JPanel jPanel7 = new JPanel(new FlowLayout(0));
            jPanel7.add(this.maskingCheckBox);
            Box box2 = Box.createVerticalBox();
            box2.add(jPanel2);
            box2.add(jPanel7);
            box2.add(jPanel3);
            Box box3 = Box.createVerticalBox();
            box3.add(jPanel4);
            box3.add(jPanel5);
            JPanel jPanel8 = new JPanel();
            jPanel8.add(this.namePanel);
            jPanel8.add(this.descriptionPanel);
            JPanel jPanel9 = new JPanel();
            jPanel9.add(this.outputPanel);
            jPanel9.add(this.runPanel);
            Box box4 = Box.createVerticalBox();
            box4.add(jPanel8);
            box4.add(jPanel9);
            JPanel jPanel10 = new JPanel();
            jPanel10.add(box);
            jPanel10.add(box2);
            jPanel10.add(box3);
            jPanel10.add(box4);
            Box box5 = Box.createVerticalBox();
            box5.add(this.addRecordButton);
            box5.add(this.removeRecordButton);
            jPanel6.add((Component)AppController.createScrollPane(this.selectedRecordsTable), "Center");
            jPanel6.add((Component)box5, "West");
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel10, "North");
            this.add((Component)jPanel6, "Center");
            this.selectedRecordsModel.updateBorder();
            this.updateControls();
        }

        @Override
        protected void createLayout(JPanel jPanel) {
        }

        private void updateParams() {
            int n = this.templateMenu.getSelectedKey();
            if (n > 0) {
                String string = Parameter.getTemplateParameterValue((String)this.getDbID(), (int)n, (int)355, (int)0);
                if (null != string) {
                    this.frequencyField.setText(string);
                }
                if (null != (string = Parameter.getTemplateParameterValue((String)this.getDbID(), (int)n, (int)356, (int)0))) {
                    this.bandwidthField.setText(string);
                }
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            AppController.setComponentEnabled(this.templateMenu, bl);
            AppController.setComponentEnabled(this.wirelessExtDbMenu, bl);
            AppController.setComponentEnabled(this.maskingCheckBox, bl);
            if (this.maskingCheckBox.isSelected()) {
                AppController.setComponentEnabled(this.maskingExtDbMenu, bl);
            } else {
                AppController.setComponentEnabled(this.maskingExtDbMenu, false);
            }
            AppController.setComponentEnabled(this.frequencyField, bl);
            AppController.setComponentEnabled(this.bandwidthField, bl);
            AppController.setComponentEnabled(this.selectedRecordsTable, bl);
            this.updateControls();
        }

        public void updateExtDbList() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayList arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)2, (boolean)false, (boolean)true);
                    if (null == arrayList) {
                        return;
                    }
                    this.blockActionsStart();
                    int n = wirelessExtDbMenu.getSelectedKey();
                    wirelessExtDbMenu.removeAllItems();
                    if (!arrayList.isEmpty()) {
                        wirelessExtDbMenu.addAllItems(arrayList);
                        if (wirelessExtDbMenu.containsKey(n)) {
                            wirelessExtDbMenu.setSelectedKey(n);
                        }
                    }
                    this.blockActionsEnd();
                    arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)1, (boolean)false, (boolean)true);
                    if (null == arrayList) {
                        return;
                    }
                    this.blockActionsStart();
                    n = maskingExtDbMenu.getSelectedKey();
                    maskingExtDbMenu.removeAllItems();
                    if (!arrayList.isEmpty()) {
                        maskingExtDbMenu.addAllItems(arrayList);
                        if (maskingExtDbMenu.containsKey(n)) {
                            maskingExtDbMenu.setSelectedKey(n);
                        }
                    }
                    this.blockActionsEnd();
                }
            });
        }

        @Override
        public void windowWillOpen() {
            ExtDb.addListener((ExtDbListener)this);
            this.templateMenu.removeAllItems();
            this.wirelessExtDbMenu.removeAllItems();
            this.maskingExtDbMenu.removeAllItems();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.blockActionsStart();
                    errorReporter.setTitle("Load Template List");
                    ArrayList arrayList = Template.getTemplateInfoList((String)this.getDbID(), (ErrorLogger)errorReporter);
                    if (null != arrayList) {
                        templateMenu.addAllItems(arrayList);
                    }
                    errorReporter.setTitle("Load Station Data List");
                    arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)2, (boolean)true, (boolean)true, (ErrorLogger)errorReporter);
                    if (null != arrayList) {
                        if (arrayList.isEmpty()) {
                            errorReporter.reportError("No wireless station data found, use Station Data Manager to add data");
                        } else {
                            wirelessExtDbMenu.addAllItems(arrayList);
                        }
                    }
                    if (null != (arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)1, (boolean)false, (boolean)true, (ErrorLogger)errorReporter))) {
                        maskingExtDbMenu.addAllItems(arrayList);
                    }
                    this.clearFields();
                    this.blockActionsEnd();
                }
            });
        }

        @Override
        public void windowWillClose() {
            ExtDb.removeListener((ExtDbListener)this);
        }

        @Override
        public void clearFields() {
            int n;
            super.clearFields();
            this.blockActionsStart();
            if (this.studyBuild.templateKey > 0 && this.templateMenu.containsKey(this.studyBuild.templateKey)) {
                this.templateMenu.setSelectedKey(this.studyBuild.templateKey);
            } else {
                this.templateMenu.setSelectedIndex(0);
            }
            this.updateParams();
            if (null != this.studyBuild.wirelessExtDb) {
                n = this.studyBuild.wirelessExtDb.key;
                if (this.wirelessExtDbMenu.containsKey(n)) {
                    this.wirelessExtDbMenu.setSelectedKey(n);
                } else {
                    this.wirelessExtDbMenu.setSelectedIndex(0);
                }
            } else {
                this.wirelessExtDbMenu.setSelectedIndex(0);
            }
            if (null != this.studyBuild.maskingExtDb) {
                this.maskingCheckBox.setSelected(true);
                n = this.studyBuild.maskingExtDb.key;
                if (this.maskingExtDbMenu.containsKey(n)) {
                    this.maskingExtDbMenu.setSelectedKey(n);
                } else {
                    this.maskingExtDbMenu.setSelectedIndex(0);
                }
            } else {
                this.maskingCheckBox.setSelected(false);
                this.maskingExtDbMenu.setSelectedIndex(0);
                AppController.setComponentEnabled(this.maskingExtDbMenu, false);
            }
            this.blockActionsEnd();
        }

        @Override
        public void selectionChanged(Object object) {
            Object object2;
            super.selectionChanged(object);
            this.selectedRecord = null;
            if (null != object) {
                int n;
                if (object instanceof SourceEditData) {
                    object2 = (SourceEditData)object;
                    if (1 == object2.recordType) {
                        this.selectedRecord = object2;
                        if (null != object2.extDbKey && this.maskingExtDbMenu.containsKey(n = object2.extDbKey.intValue())) {
                            this.maskingExtDbMenu.setSelectedKey(n);
                        }
                    }
                } else if (object instanceof ExtDbRecord) {
                    object2 = (ExtDbRecord)object;
                    if (1 == object2.recordType) {
                        this.selectedRecord = object2;
                        n = object2.extDb.key;
                        if (this.maskingExtDbMenu.containsKey(n)) {
                            this.maskingExtDbMenu.setSelectedKey(n);
                        }
                    }
                }
            }
            if (null != this.selectedRecord && 0 == this.selectedRecordsModel.getRowCount()) {
                String string;
                object2 = "";
                String string2 = "";
                String string3 = this.selectedRecord.getCallSign();
                if (null != string3 && string3.length() > 0) {
                    object2 = string3;
                    string2 = "-";
                }
                if (null != (string = this.selectedRecord.getFileNumber()) && string.length() > 0) {
                    object2 = (String)object2 + string2 + string;
                }
                this.nameField.setText((String)object2);
            }
            this.updateControls();
        }

        private void doAddRecord() {
            if (null == this.selectedRecord) {
                return;
            }
            int n = this.selectedRecordsModel.indexOfRecord(this.selectedRecord);
            if (n < 0) {
                n = this.selectedRecordsModel.add(this.selectedRecord);
                if (1 == this.selectedRecordsModel.getRowCount()) {
                    this.nameField.setText("");
                }
            }
            if (n >= 0) {
                this.selectedRecordsTable.setRowSelectionInterval(n, n);
                this.selectedRecordsTable.scrollRectToVisible(this.selectedRecordsTable.getCellRect(n, 0, true));
            }
        }

        private void doRemoveRecord() {
            if (0 == this.selectedRecordsTable.getSelectedRowCount()) {
                return;
            }
            this.selectedRecordsModel.remove(this.selectedRecordsTable.getSelectedRow());
        }

        private void updateControls() {
            boolean bl = AppController.isComponentEnabled(this.selectedRecordsTable);
            this.addRecordButton.setEnabled(bl && null != this.selectedRecord && this.selectedRecordsModel.indexOfRecord(this.selectedRecord) < 0);
            this.removeRecordButton.setEnabled(bl && 1 == this.selectedRecordsTable.getSelectedRowCount());
        }

        @Override
        protected boolean isNameRequired() {
            return 0 == this.selectedRecordsModel.getRowCount();
        }

        @Override
        protected boolean noReplicateChangeSameChannel() {
            return 0 == this.selectedRecordsModel.getRowCount();
        }

        @Override
        public boolean validateInput() {
            String string;
            int n;
            this.errorReporter.clearTitle();
            int n2 = this.selectedRecordsModel.getRowCount();
            if (null == this.selectedRecord && 0 == n2) {
                this.errorReporter.reportWarning("Please select a TV record to study");
                return false;
            }
            if (!super.validateInput()) {
                return false;
            }
            if (this.name.length() > 0) {
                n = 0;
                if (n2 > 0) {
                    n = 40;
                }
                if (this.replicate || this.changeChannel) {
                    n += 10;
                }
                if (!DbCore.checkStudyName((String)this.name, (String)this.getDbID(), (boolean)false, (int)n, (ErrorLogger)this.errorReporter)) {
                    return false;
                }
            }
            if ((n = this.templateMenu.getSelectedKey()) <= 0) {
                this.errorReporter.reportWarning("Please choose a study template");
                return false;
            }
            ExtDb extDb = null;
            int n3 = this.wirelessExtDbMenu.getSelectedKey();
            if (n3 > 0) {
                extDb = ExtDb.getExtDb((String)this.getDbID(), (Integer)n3);
            }
            if (null == extDb || extDb.deleted) {
                this.errorReporter.reportWarning("That wireless station data set has been deleted, please select another");
                return false;
            }
            ExtDb extDb2 = null;
            if (this.maskingCheckBox.isSelected()) {
                n3 = this.maskingExtDbMenu.getSelectedKey();
                if (n3 > 0) {
                    extDb2 = ExtDb.getExtDb((String)this.getDbID(), (Integer)n3);
                }
                if (null == extDb2 || extDb2.deleted) {
                    this.errorReporter.reportWarning("That TV station data set has been deleted, please select another");
                    return false;
                }
            }
            if (0 == (string = this.frequencyField.getText().trim()).length()) {
                this.errorReporter.reportWarning("Please enter a wireless frequency");
                return false;
            }
            double d = 0.0;
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.errorReporter.reportWarning("The wireless frequency must be a number");
                return false;
            }
            if (d < 50.0 || d > 800.0) {
                this.errorReporter.reportWarning("The wireless frequency must be in the range 50 to 800");
                return false;
            }
            String string2 = string;
            string = this.bandwidthField.getText().trim();
            if (0 == string.length()) {
                this.errorReporter.reportWarning("Please enter a wireless bandwidth");
                return false;
            }
            d = 0.0;
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.errorReporter.reportWarning("The wireless bandwidth must be a number");
                return false;
            }
            if (d < 0.1 || d > 20.0) {
                this.errorReporter.reportWarning("The wireless bandwidth must be in the range 0.1 to 20");
                return false;
            }
            String string3 = string;
            this.studyBuild.replicate = this.replicate;
            this.studyBuild.changeChannel = this.changeChannel;
            this.studyBuild.studyChannel = this.studyChannel;
            this.studyBuild.studyDescription = null;
            if (this.description.length() > 0) {
                this.studyBuild.studyDescription = this.description;
            }
            this.studyBuild.templateKey = n;
            this.studyBuild.wirelessExtDb = extDb;
            this.studyBuild.maskingExtDb = extDb2;
            this.studyBuild.frequency = string2;
            this.studyBuild.bandwidth = string3;
            this.studyBuilds = new ArrayList();
            int n4 = this.selectedRecordsModel.getRowCount();
            if (0 == n2) {
                if (this.selectedRecord.isSource()) {
                    this.studyBuild.source = (SourceEditData)this.selectedRecord;
                } else {
                    this.studyBuild.record = (ExtDbRecord)this.selectedRecord;
                }
                this.studyBuild.studyName = this.replicate || this.changeChannel ? this.name + " (on " + String.valueOf(this.studyChannel) + ")" : this.name;
                this.studyBuilds.add((StudyBuild)this.studyBuild);
            } else {
                StationRecord stationRecord;
                RecordFind recordFind = null;
                if (this.parent instanceof RecordFind) {
                    recordFind = (RecordFind)this.parent;
                    for (int i = 0; i < n4; ++i) {
                        stationRecord = this.selectedRecordsModel.get(i);
                        if (stationRecord == this.selectedRecord || recordFind.canApplyRecord(stationRecord, true)) continue;
                        return false;
                    }
                }
                if (null != this.selectedRecord && this.selectedRecordsModel.indexOfRecord(this.selectedRecord) < 0) {
                    this.selectedRecordsModel.add(this.selectedRecord);
                    ++n2;
                }
                for (int i = 0; i < n4; ++i) {
                    String string4;
                    String string5;
                    stationRecord = this.selectedRecordsModel.get(i);
                    StudyBuildWireless studyBuildWireless = this.studyBuild.copy();
                    String string6 = "";
                    String string7 = "";
                    if (this.name.length() > 0) {
                        string6 = this.name;
                        string7 = "-";
                    }
                    if (null != (string5 = stationRecord.getCallSign()) && string5.length() > 0) {
                        string6 = string6 + string7 + string5;
                        string7 = "-";
                    }
                    if (null != (string4 = stationRecord.getFileNumber()) && string4.length() > 0) {
                        string6 = string6 + string7 + string4;
                    }
                    if (0 == string6.length()) {
                        string6 = "Wireless study";
                    }
                    if (stationRecord.isSource()) {
                        studyBuildWireless.source = (SourceEditData)stationRecord;
                    } else {
                        studyBuildWireless.record = (ExtDbRecord)stationRecord;
                    }
                    if ((this.replicate || this.changeChannel) && stationRecord.getChannelNumber() == this.studyChannel && (this.changeChannel || stationRecord.isDigital())) {
                        studyBuildWireless.replicate = false;
                        studyBuildWireless.changeChannel = false;
                        studyBuildWireless.studyChannel = 0;
                    } else {
                        string6 = string6 + " (on " + String.valueOf(this.studyChannel) + ")";
                    }
                    studyBuildWireless.studyName = string6;
                    this.studyBuilds.add((StudyBuild)studyBuildWireless);
                    if (null == recordFind) continue;
                    recordFind.recordWasApplied(stationRecord);
                }
            }
            return true;
        }

        @Override
        public ArrayList<StudyBuild> getStudyBuilds() {
            return this.studyBuilds;
        }

        private class RecordsTableModel
        extends AbstractTableModel {
            private static final String RECORD_TYPE_COLUMN = "Type";
            private static final String RECORD_CALLSIGN_COLUMN = "Call Sign";
            private static final String RECORD_CHANNEL_COLUMN = "Channel";
            private static final String RECORD_SERVICE_COLUMN = "Svc";
            private static final String RECORD_STATUS_COLUMN = "Status";
            private static final String RECORD_CITY_COLUMN = "City";
            private static final String RECORD_STATE_COLUMN = "State";
            private static final String RECORD_COUNTRY_COLUMN = "Cntry";
            private static final String RECORD_FACILITY_ID_COLUMN = "Facility ID";
            private static final String RECORD_FILE_COLUMN = "File Number";
            private String[] columnNames = new String[]{"Type", "Call Sign", "Channel", "Svc", "Status", "City", "State", "Cntry", "Facility ID", "File Number"};
            private static final int RECORD_TYPE_INDEX = 0;
            private static final int RECORD_CALLSIGN_INDEX = 1;
            private static final int RECORD_CHANNEL_INDEX = 2;
            private static final int RECORD_SERVICE_INDEX = 3;
            private static final int RECORD_STATUS_INDEX = 4;
            private static final int RECORD_CITY_INDEX = 5;
            private static final int RECORD_STATE_INDEX = 6;
            private static final int RECORD_COUNTRY_INDEX = 7;
            private static final int RECORD_FACILITY_ID_INDEX = 8;
            private static final int RECORD_FILE_INDEX = 9;
            private JPanel panel;
            private ArrayList<StationRecord> modelRows;

            private RecordsTableModel(JPanel jPanel) {
                this.panel = jPanel;
                this.modelRows = new ArrayList();
            }

            private JTable createTable() {
                JTable jTable = new JTable(this);
                AppController.configureTable(jTable);
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                TableColumn tableColumn = tableColumnModel.getColumn(0);
                tableColumn.setMinWidth(AppController.textFieldWidth[4]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[4]);
                tableColumn = tableColumnModel.getColumn(1);
                tableColumn.setMinWidth(AppController.textFieldWidth[5]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[5]);
                tableColumn = tableColumnModel.getColumn(2);
                tableColumn.setMinWidth(AppController.textFieldWidth[5]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[7]);
                tableColumn = tableColumnModel.getColumn(3);
                tableColumn.setMinWidth(AppController.textFieldWidth[2]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[2]);
                tableColumn = tableColumnModel.getColumn(4);
                tableColumn.setMinWidth(AppController.textFieldWidth[4]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[4]);
                tableColumn = tableColumnModel.getColumn(5);
                tableColumn.setMinWidth(AppController.textFieldWidth[8]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[14]);
                tableColumn = tableColumnModel.getColumn(6);
                tableColumn.setMinWidth(AppController.textFieldWidth[2]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[2]);
                tableColumn = tableColumnModel.getColumn(7);
                tableColumn.setMinWidth(AppController.textFieldWidth[2]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[2]);
                tableColumn = tableColumnModel.getColumn(8);
                tableColumn.setMinWidth(AppController.textFieldWidth[5]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[5]);
                tableColumn = tableColumnModel.getColumn(9);
                tableColumn.setMinWidth(AppController.textFieldWidth[8]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[16]);
                jTable.setPreferredScrollableViewportSize(new Dimension(jTable.getPreferredSize().width, jTable.getRowHeight() * 3));
                return jTable;
            }

            private int add(StationRecord stationRecord) {
                int n = this.modelRows.size();
                this.modelRows.add(stationRecord);
                this.fireTableRowsInserted(n, n);
                this.updateBorder();
                return n;
            }

            private int indexOfRecord(StationRecord stationRecord) {
                String string;
                Integer n;
                Integer n2;
                ExtDbRecord extDbRecord;
                SourceEditData sourceEditData;
                int n3 = this.modelRows.size();
                if (0 == n3) {
                    return -1;
                }
                if (stationRecord.isSource()) {
                    sourceEditData = (SourceEditData)stationRecord;
                    extDbRecord = null;
                    n2 = sourceEditData.userRecordID;
                    n = sourceEditData.extDbKey;
                    string = sourceEditData.extRecordID;
                } else {
                    sourceEditData = null;
                    extDbRecord = (ExtDbRecord)stationRecord;
                    n2 = null;
                    n = extDbRecord.extDb.key;
                    string = extDbRecord.extRecordID;
                }
                for (int i = 0; i < n3; ++i) {
                    String string2;
                    Integer n4;
                    Integer n5;
                    ExtDbRecord extDbRecord2;
                    SourceEditData sourceEditData2;
                    StationRecord stationRecord2 = this.modelRows.get(i);
                    if (stationRecord == stationRecord2) {
                        return i;
                    }
                    if (null != sourceEditData && !sourceEditData.isLocked) continue;
                    if (stationRecord2.isSource()) {
                        sourceEditData2 = (SourceEditData)stationRecord2;
                        extDbRecord2 = null;
                        n5 = sourceEditData2.userRecordID;
                        n4 = sourceEditData2.extDbKey;
                        string2 = sourceEditData2.extRecordID;
                    } else {
                        sourceEditData2 = null;
                        extDbRecord2 = (ExtDbRecord)stationRecord2;
                        n5 = null;
                        n4 = extDbRecord2.extDb.key;
                        string2 = extDbRecord2.extRecordID;
                    }
                    if (null != sourceEditData2 && !sourceEditData2.isLocked || !(null != n2 ? null != n5 && n2.equals(n5) : null != string && null != string2 && n.equals(n4) && string.equals(string2))) continue;
                    return i;
                }
                return -1;
            }

            private StationRecord get(int n) {
                return this.modelRows.get(n);
            }

            private void remove(int n) {
                this.modelRows.remove(n);
                this.fireTableRowsDeleted(n, n);
                this.updateBorder();
            }

            private void updateBorder() {
                int n = this.modelRows.size();
                if (n > 0) {
                    this.panel.setBorder(BorderFactory.createTitledBorder(String.valueOf(n) + " selected records"));
                } else {
                    this.panel.setBorder(BorderFactory.createTitledBorder("Selected records"));
                }
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public String getColumnName(int n) {
                return this.columnNames[n];
            }

            @Override
            public int getRowCount() {
                return this.modelRows.size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                StationRecord stationRecord = this.modelRows.get(n);
                switch (n2) {
                    case 0: {
                        return stationRecord.getRecordType();
                    }
                    case 1: {
                        return stationRecord.getCallSign();
                    }
                    case 2: {
                        return stationRecord.getChannel() + " " + stationRecord.getFrequency();
                    }
                    case 3: {
                        return stationRecord.getServiceCode();
                    }
                    case 4: {
                        return stationRecord.getStatus();
                    }
                    case 5: {
                        return stationRecord.getCity();
                    }
                    case 6: {
                        return stationRecord.getState();
                    }
                    case 7: {
                        return stationRecord.getCountryCode();
                    }
                    case 8: {
                        return stationRecord.getFacilityID();
                    }
                    case 9: {
                        return stationRecord.getFileNumber();
                    }
                }
                return "";
            }
        }
    }

    public static class IxCheckStudy
    extends OptionsPanel
    implements ExtDbListener {
        private KeyedRecordMenu templateMenu;
        private KeyedRecordMenu extDbMenu;
        private JComboBox<String> cellSizeMenu;
        private JTextField profilePtIncField;
        private JButton setBeforeButton;
        private JButton clearBeforeButton;
        private JLabel beforeLabel;
        private JCheckBox useDefaultBeforeCheckBox;
        private JPanel beforePanel;
        private JCheckBox protectPreBaselineCheckBox;
        private JCheckBox protectBaselineFromLPTVCheckBox;
        private JCheckBox protectLPTVFromClassACheckBox;
        private JCheckBox includeForeignCheckBox;
        private JTextArea includeUserRecordsTextArea;
        private JButton includeUserRecordButton;
        private JCheckBox cpExcludesBaselineCheckBox;
        private JCheckBox excludeAppsCheckBox;
        private JCheckBox includeAmendmentsCheckBox;
        private JCheckBox excludePendingCheckBox;
        private JCheckBox excludePostTransitionCheckBox;
        private JCheckBox excludeNewLPTVCheckBox;
        private JTextArea excludeCommandsTextArea;
        private JButton excludeARNButton;
        private JPanel moreOptionsMainPanel;
        private JPanel moreOptionsButtonPanel;
        private AppDialog moreOptionsDialog;
        private JButton moreOptionsButton;
        private DateSelectionPanel filingCutoffDatePanel;
        private boolean isPostWindow;
        private StationRecord selectedRecord;
        private StudyBuildIxCheck studyBuild;
        private ArrayList<StudyBuild> studyBuilds;

        public IxCheckStudy(AppEditor appEditor, StudyBuildIxCheck studyBuildIxCheck) {
            super(appEditor, true, "Study Name", true, "Study Description", false, true, studyBuildIxCheck.buildFullStudy, studyBuildIxCheck.buildFullStudy, false, studyBuildIxCheck.buildFullStudy);
            JComponent jComponent;
            JComponent jComponent2;
            JComponent jComponent3;
            JPanel jPanel;
            JComponent jComponent4;
            if (studyBuildIxCheck.buildFullStudy) {
                this.setBorder(BorderFactory.createTitledBorder("Study Build Settings"));
            } else {
                this.setBorder(BorderFactory.createTitledBorder("Study Settings"));
            }
            this.studyBuild = studyBuildIxCheck;
            this.defaultName = studyBuildIxCheck.studyName;
            this.defaultDescription = studyBuildIxCheck.studyDescription;
            this.defaultFileOutputConfig = studyBuildIxCheck.fileOutputConfig;
            this.defaultMapOutputConfig = studyBuildIxCheck.mapOutputConfig;
            this.templateMenu = new KeyedRecordMenu();
            this.templateMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXy"));
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Template"));
            jPanel2.add(this.templateMenu);
            this.extDbMenu = new KeyedRecordMenu();
            this.extDbMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXy"));
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createTitledBorder("Station Data"));
            jPanel3.add(this.extDbMenu);
            this.cellSizeMenu = new JComboBox();
            this.cellSizeMenu.setFocusable(false);
            for (double d : StudyBuildIxCheck.CELL_SIZES) {
                this.cellSizeMenu.addItem(AppCore.formatDecimal((double)d, (int)0, (int)1));
            }
            Object object = new JPanel();
            ((JComponent)object).setBorder(BorderFactory.createTitledBorder("Cell size, km"));
            ((Container)object).add(this.cellSizeMenu);
            this.profilePtIncField = new JTextField(8);
            AppController.fixKeyBindings(this.profilePtIncField);
            this.profilePtIncField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = profilePtIncField.getText().trim();
                    if (string.length() > 0) {
                        try {
                            double d = Double.parseDouble(string);
                            if (d > 1.0) {
                                d = 1.0 / d;
                            }
                            profilePtIncField.setText(AppCore.formatDecimal((double)d, (int)0, (int)3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.profilePtIncField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        profilePtIncField.postActionEvent();
                    }
                }
            });
            JPanel jPanel4 = new JPanel();
            jPanel4.setBorder(BorderFactory.createTitledBorder("Profile inc., km"));
            jPanel4.add(this.profilePtIncField);
            this.setBeforeButton = new JButton("Set");
            this.setBeforeButton.setFocusable(false);
            this.setBeforeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppEditor appEditor = parent;
                    if (null != moreOptionsDialog) {
                        appEditor = moreOptionsDialog;
                    }
                    RecordFindDialog recordFindDialog = new RecordFindDialog(appEditor, "Choose proposal \"before\" record", 1);
                    AppController.showWindow(recordFindDialog);
                    if (!recordFindDialog.canceled) {
                        StationRecord stationRecord = recordFindDialog.getSelectedRecord();
                        if (stationRecord instanceof SourceEditDataTV) {
                            ((IxCheckStudy)this).studyBuild.didSetBefore = true;
                            ((IxCheckStudy)this).studyBuild.beforeSource = (SourceEditDataTV)stationRecord;
                            beforeLabel.setText(((IxCheckStudy)this).studyBuild.beforeSource.toString());
                            ((IxCheckStudy)this).studyBuild.beforeRecord = null;
                        } else if (stationRecord instanceof ExtDbRecordTV) {
                            ((IxCheckStudy)this).studyBuild.didSetBefore = true;
                            ((IxCheckStudy)this).studyBuild.beforeSource = null;
                            ((IxCheckStudy)this).studyBuild.beforeRecord = (ExtDbRecordTV)stationRecord;
                            beforeLabel.setText(((IxCheckStudy)this).studyBuild.beforeRecord.toString());
                        } else {
                            errorReporter.reportError("That record type is not allowed here");
                        }
                    }
                }
            });
            this.clearBeforeButton = new JButton("Clear");
            this.clearBeforeButton.setFocusable(false);
            this.clearBeforeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((IxCheckStudy)this).studyBuild.didSetBefore = true;
                    ((IxCheckStudy)this).studyBuild.beforeSource = null;
                    ((IxCheckStudy)this).studyBuild.beforeRecord = null;
                    beforeLabel.setText("(none)");
                }
            });
            if (studyBuildIxCheck.buildFullStudy) {
                this.useDefaultBeforeCheckBox = new JCheckBox("Default");
                this.useDefaultBeforeCheckBox.setFocusable(false);
                this.useDefaultBeforeCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (useDefaultBeforeCheckBox.isSelected()) {
                            ((IxCheckStudy)this).studyBuild.didSetBefore = false;
                            setBeforeButton.setEnabled(false);
                            clearBeforeButton.setEnabled(false);
                            beforeLabel.setText("(default)");
                        } else {
                            ((IxCheckStudy)this).studyBuild.didSetBefore = true;
                            setBeforeButton.setEnabled(true);
                            clearBeforeButton.setEnabled(true);
                            if (null != ((IxCheckStudy)this).studyBuild.beforeSource) {
                                beforeLabel.setText(((IxCheckStudy)this).studyBuild.beforeSource.toString());
                            } else if (null != ((IxCheckStudy)this).studyBuild.beforeRecord) {
                                beforeLabel.setText(((IxCheckStudy)this).studyBuild.beforeRecord.toString());
                            } else {
                                beforeLabel.setText("(none)");
                            }
                        }
                    }
                });
                this.beforeLabel = new JLabel("(default)");
                this.protectPreBaselineCheckBox = new JCheckBox("Protect records not on baseline channel");
                this.protectPreBaselineCheckBox.setFocusable(false);
                this.protectBaselineFromLPTVCheckBox = new JCheckBox("Protect baseline records from LPTV");
                this.protectBaselineFromLPTVCheckBox.setFocusable(false);
                this.protectLPTVFromClassACheckBox = new JCheckBox("Protect LPTV records from Class A");
                this.protectLPTVFromClassACheckBox.setFocusable(false);
                this.includeForeignCheckBox = new JCheckBox("Include non-U.S. records");
                this.includeForeignCheckBox.setFocusable(false);
                this.includeUserRecordsTextArea = new JTextArea(4, 16);
                AppController.fixKeyBindings(this.includeUserRecordsTextArea);
                this.includeUserRecordsTextArea.setLineWrap(true);
                this.includeUserRecordsTextArea.setWrapStyleWord(true);
                this.includeUserRecordButton = new JButton("Add");
                this.includeUserRecordButton.setFocusable(false);
                this.includeUserRecordButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string;
                        AppEditor appEditor = parent;
                        if (null != moreOptionsDialog) {
                            appEditor = moreOptionsDialog;
                        }
                        RecordFindDialog recordFindDialog = new RecordFindDialog(appEditor, "Choose user record to include", -1);
                        AppController.showWindow(recordFindDialog);
                        if (!recordFindDialog.canceled && null != (string = recordFindDialog.getSelectedRecord().getRecordID()) && string.length() > 0) {
                            includeUserRecordsTextArea.append(string + "\n");
                        }
                    }
                });
                JPanel jPanel5 = new JPanel(new FlowLayout(0));
                jPanel5.add(this.includeUserRecordButton);
                JPanel jPanel6 = new JPanel(new BorderLayout());
                jPanel6.setBorder(BorderFactory.createTitledBorder("User records to include"));
                jPanel6.add((Component)AppController.createScrollPane(this.includeUserRecordsTextArea), "Center");
                jPanel6.add((Component)jPanel5, "South");
                this.cpExcludesBaselineCheckBox = new JCheckBox("CP excludes station's baseline");
                this.cpExcludesBaselineCheckBox.setFocusable(false);
                this.excludeAppsCheckBox = new JCheckBox("Exclude all APP records");
                this.excludeAppsCheckBox.setFocusable(false);
                this.includeAmendmentsCheckBox = new JCheckBox("Include all AMD records");
                this.includeAmendmentsCheckBox.setFocusable(false);
                this.excludePendingCheckBox = new JCheckBox("Exclude pending license records");
                this.excludePendingCheckBox.setFocusable(false);
                this.excludePostTransitionCheckBox = new JCheckBox("Exclude all post-transition CP, APP, and BL");
                this.excludePostTransitionCheckBox.setFocusable(false);
                this.excludePostTransitionCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (excludePostTransitionCheckBox.isSelected()) {
                            protectPreBaselineCheckBox.setSelected(true);
                        }
                    }
                });
                this.excludeNewLPTVCheckBox = new JCheckBox("Exclude records for new LPTV stations");
                this.excludeNewLPTVCheckBox.setFocusable(false);
                this.excludeCommandsTextArea = new JTextArea(4, 16);
                AppController.fixKeyBindings(this.excludeCommandsTextArea);
                this.excludeCommandsTextArea.setLineWrap(true);
                this.excludeCommandsTextArea.setWrapStyleWord(true);
                this.excludeARNButton = new JButton("Add");
                this.excludeARNButton.setFocusable(false);
                this.excludeARNButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string;
                        AppEditor appEditor = parent;
                        if (null != moreOptionsDialog) {
                            appEditor = moreOptionsDialog;
                        }
                        RecordFindDialog recordFindDialog = new RecordFindDialog(appEditor, "Choose record to exclude", 1);
                        AppController.showWindow(recordFindDialog);
                        if (!recordFindDialog.canceled && null != (string = recordFindDialog.getSelectedRecord().getARN()) && string.length() > 0) {
                            excludeCommandsTextArea.append(string + "\n");
                        }
                    }
                });
                jComponent4 = new JPanel(new FlowLayout(0));
                jComponent4.add(this.excludeARNButton);
                jPanel = new JPanel(new BorderLayout());
                jPanel.setBorder(BorderFactory.createTitledBorder("Records to exclude (ARNs)"));
                jPanel.add((Component)AppController.createScrollPane(this.excludeCommandsTextArea), "Center");
                jPanel.add((Component)jComponent4, "South");
                this.filingCutoffDatePanel = new DateSelectionPanel((AppEditor)this, "Cutoff Date", false);
                this.filingCutoffDatePanel.setFutureAllowed(true);
                jComponent3 = Box.createVerticalBox();
                jComponent3.add(this.cpExcludesBaselineCheckBox);
                jComponent3.add(this.excludeAppsCheckBox);
                jComponent3.add(this.includeAmendmentsCheckBox);
                jComponent3.add(this.excludePendingCheckBox);
                jComponent3.add(this.excludePostTransitionCheckBox);
                jComponent3.add(this.excludeNewLPTVCheckBox);
                jComponent2 = new JPanel(new FlowLayout(0));
                jComponent2.add(jComponent3);
                this.moreOptionsMainPanel = new JPanel();
                this.moreOptionsMainPanel.setLayout(new BoxLayout(this.moreOptionsMainPanel, 1));
                this.moreOptionsMainPanel.add(jComponent2);
                this.moreOptionsMainPanel.add(jPanel);
                this.moreOptionsMainPanel.add(jPanel6);
                this.moreOptionsMainPanel.add(this.filingCutoffDatePanel);
                jComponent = new JButton("OK");
                jComponent.setFocusable(false);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (null != moreOptionsDialog && moreOptionsDialog.isVisible()) {
                            AppController.hideWindow(moreOptionsDialog);
                        }
                    }
                });
                this.moreOptionsButtonPanel = new JPanel(new FlowLayout(2));
                this.moreOptionsButtonPanel.add(jComponent);
                this.moreOptionsButton = new JButton("More");
                this.moreOptionsButton.setFocusable(false);
                this.moreOptionsButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (null == moreOptionsDialog) {
                            moreOptionsDialog = new AppDialog(parent, "Additional Options", Dialog.ModalityType.APPLICATION_MODAL){

                                @Override
                                public void windowWillOpen() {
                                    this.blockActionsClear();
                                }

                                @Override
                                public void windowWillClose() {
                                    this.blockActionsSet();
                                }
                            };
                            filingCutoffDatePanel.setParent(moreOptionsDialog);
                            moreOptionsDialog.add((Component)moreOptionsMainPanel, "Center");
                            moreOptionsDialog.add((Component)moreOptionsButtonPanel, "South");
                            moreOptionsDialog.pack();
                            moreOptionsDialog.setMinimumSize(moreOptionsDialog.getSize());
                            moreOptionsDialog.setLocationRelativeTo(moreOptionsButton);
                        }
                        if (!moreOptionsDialog.isVisible()) {
                            AppController.showWindow(moreOptionsDialog);
                        }
                    }
                });
            } else {
                this.beforeLabel = new JLabel("(none)");
            }
            Box box = Box.createVerticalBox();
            box.add(this.channelPanel);
            box.add(jPanel2);
            this.add(box);
            Box box2 = Box.createVerticalBox();
            box2.add(jPanel3);
            box2.add(this.namePanel);
            box2.add(this.descriptionPanel);
            this.add(box2);
            jComponent4 = Box.createVerticalBox();
            jComponent4.add((Component)object);
            jComponent4.add(jPanel4);
            this.add(jComponent4);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.beforeLabel);
            jComponent3 = new JPanel(new FlowLayout(0));
            jComponent3.add(this.setBeforeButton);
            jComponent3.add(this.clearBeforeButton);
            this.beforePanel = new JPanel();
            this.beforePanel.setBorder(BorderFactory.createTitledBorder("Proposal \"before\" case"));
            this.beforePanel.setLayout(new BoxLayout(this.beforePanel, 1));
            this.beforePanel.add(jPanel);
            this.beforePanel.add(jComponent3);
            if (studyBuildIxCheck.buildFullStudy) {
                this.moreOptionsMainPanel.add(this.beforePanel);
                this.runPanel.remove(this.commentButton);
                this.descriptionPanel.add(this.commentButton);
                jComponent3.add(this.useDefaultBeforeCheckBox);
                jComponent2 = Box.createVerticalBox();
                jComponent2.add(this.protectPreBaselineCheckBox);
                jComponent2.add(this.protectBaselineFromLPTVCheckBox);
                jComponent2.add(this.protectLPTVFromClassACheckBox);
                jComponent2.add(this.includeForeignCheckBox);
                jComponent = new JPanel();
                jComponent.add(jComponent2);
                jComponent.add(this.moreOptionsButton);
                JPanel jPanel7 = new JPanel();
                jPanel7.add(this.outputPanel);
                jPanel7.add(this.runPanel);
                Box box3 = Box.createVerticalBox();
                box3.add(jComponent);
                box3.add(jPanel7);
                this.add(box3);
            } else {
                this.add(this.beforePanel);
            }
        }

        @Override
        protected void createLayout(JPanel jPanel) {
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            AppController.setComponentEnabled(this.templateMenu, bl);
            AppController.setComponentEnabled(this.extDbMenu, bl);
            AppController.setComponentEnabled(this.cellSizeMenu, bl);
            AppController.setComponentEnabled(this.profilePtIncField, bl);
            if (this.studyBuild.buildFullStudy) {
                AppController.setComponentEnabled(this.useDefaultBeforeCheckBox, bl);
                if (this.useDefaultBeforeCheckBox.isSelected()) {
                    this.setBeforeButton.setEnabled(false);
                    this.clearBeforeButton.setEnabled(false);
                } else {
                    this.setBeforeButton.setEnabled(bl);
                    this.clearBeforeButton.setEnabled(bl);
                }
                AppController.setComponentEnabled(this.protectPreBaselineCheckBox, bl && null != this.studyBuild.baselineDate);
                AppController.setComponentEnabled(this.protectBaselineFromLPTVCheckBox, bl && this.isLPTV);
                AppController.setComponentEnabled(this.protectLPTVFromClassACheckBox, bl && this.isClassA && !this.isPostWindow);
                AppController.setComponentEnabled(this.includeForeignCheckBox, bl);
                AppController.setComponentEnabled(this.includeUserRecordsTextArea, bl);
                this.includeUserRecordButton.setEnabled(bl);
                AppController.setComponentEnabled(this.cpExcludesBaselineCheckBox, bl);
                AppController.setComponentEnabled(this.excludeAppsCheckBox, bl);
                AppController.setComponentEnabled(this.includeAmendmentsCheckBox, bl);
                AppController.setComponentEnabled(this.excludePendingCheckBox, bl);
                AppController.setComponentEnabled(this.excludePostTransitionCheckBox, bl);
                AppController.setComponentEnabled(this.excludeNewLPTVCheckBox, bl);
                AppController.setComponentEnabled(this.excludeCommandsTextArea, bl);
                this.excludeARNButton.setEnabled(bl);
                this.moreOptionsButton.setEnabled(bl);
                this.filingCutoffDatePanel.setEnabled(bl);
            } else {
                this.setBeforeButton.setEnabled(bl);
                this.clearBeforeButton.setEnabled(bl);
            }
        }

        public void updateExtDbList() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayList arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)2, (int)6);
                    if (null == arrayList) {
                        return;
                    }
                    this.blockActionsStart();
                    int n = extDbMenu.getSelectedKey();
                    extDbMenu.removeAllItems();
                    if (!arrayList.isEmpty()) {
                        extDbMenu.addAllItems(arrayList);
                        if (extDbMenu.containsKey(n)) {
                            extDbMenu.setSelectedKey(n);
                        }
                    }
                    this.blockActionsEnd();
                }
            });
        }

        @Override
        public void windowWillOpen() {
            ExtDb.addListener((ExtDbListener)this);
            this.templateMenu.removeAllItems();
            this.extDbMenu.removeAllItems();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.blockActionsStart();
                    errorReporter.setTitle("Load Template List");
                    ArrayList arrayList = Template.getTemplateInfoList((String)this.getDbID(), (ErrorLogger)errorReporter);
                    if (null != arrayList) {
                        for (KeyedRecord keyedRecord : arrayList) {
                            Template.Info info = (Template.Info)keyedRecord;
                            if (!info.isLocked || info.isLockedInStudy) continue;
                            templateMenu.addItem(keyedRecord);
                        }
                    }
                    errorReporter.setTitle("Load Station Data List");
                    arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)2, (int)6, (ErrorLogger)errorReporter);
                    if (null != arrayList) {
                        if (arrayList.isEmpty()) {
                            errorReporter.reportError("No compatible LMS station data found, use Station Data Manager to add data");
                        } else {
                            extDbMenu.addAllItems(arrayList);
                        }
                    }
                    this.clearFields();
                    this.blockActionsEnd();
                }
            });
        }

        @Override
        public void windowWillClose() {
            ExtDb.removeListener((ExtDbListener)this);
        }

        @Override
        public void clearFields() {
            super.clearFields();
            this.blockActionsStart();
            if (this.studyBuild.templateKey > 0 && this.templateMenu.containsKey(this.studyBuild.templateKey)) {
                this.templateMenu.setSelectedKey(this.studyBuild.templateKey);
            } else {
                this.templateMenu.setSelectedIndex(0);
            }
            this.applyDefaults();
            if (null != this.studyBuild.extDb) {
                int n = this.studyBuild.extDb.key;
                if (this.extDbMenu.containsKey(n)) {
                    this.extDbMenu.setSelectedKey(n);
                } else {
                    this.extDbMenu.setSelectedIndex(0);
                }
            } else {
                this.extDbMenu.setSelectedIndex(0);
            }
            this.studyBuild.beforeSource = null;
            this.studyBuild.beforeRecord = null;
            this.setBeforeButton.setEnabled(false);
            this.clearBeforeButton.setEnabled(false);
            if (this.studyBuild.buildFullStudy) {
                this.studyBuild.didSetBefore = false;
                this.beforeLabel.setText("(default)");
                this.useDefaultBeforeCheckBox.setSelected(true);
                this.protectPreBaselineCheckBox.setSelected(this.studyBuild.protectPreBaseline);
                this.protectBaselineFromLPTVCheckBox.setSelected(this.studyBuild.protectBaselineFromLPTV && this.isLPTV);
                this.protectLPTVFromClassACheckBox.setSelected(this.studyBuild.protectLPTVFromClassA && this.isClassA);
                this.includeForeignCheckBox.setSelected(this.studyBuild.includeForeign);
                if (null != this.studyBuild.includeUserRecords) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object object : this.studyBuild.includeUserRecords) {
                        stringBuilder.append(String.valueOf(object));
                        stringBuilder.append("\n");
                    }
                    this.includeUserRecordsTextArea.setText(stringBuilder.toString());
                } else {
                    this.includeUserRecordsTextArea.setText("");
                }
                this.cpExcludesBaselineCheckBox.setSelected(this.studyBuild.cpExcludesBaseline);
                this.excludeAppsCheckBox.setSelected(this.studyBuild.excludeApps);
                this.includeAmendmentsCheckBox.setSelected(this.studyBuild.includeAmendments);
                this.excludePendingCheckBox.setSelected(this.studyBuild.excludePending);
                this.excludePostTransitionCheckBox.setSelected(this.studyBuild.excludePostTransition);
                this.excludeNewLPTVCheckBox.setSelected(this.studyBuild.excludeNewLPTV);
                if (null != this.studyBuild.excludeCommands) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object object : this.studyBuild.excludeCommands) {
                        stringBuilder.append((String)object);
                        stringBuilder.append("\n");
                    }
                    this.excludeCommandsTextArea.setText(stringBuilder.toString());
                } else {
                    this.excludeCommandsTextArea.setText("");
                }
                this.filingCutoffDatePanel.setDate(this.studyBuild.filingCutoffDate);
            } else {
                this.studyBuild.didSetBefore = true;
                this.beforeLabel.setText("(none)");
            }
            this.blockActionsEnd();
        }

        private void applyDefaults() {
            double d;
            String string = this.isLPTV || this.isClassA && this.isPostWindow ? this.studyBuild.defaultCellSizeLPTV : this.studyBuild.defaultCellSize;
            if (null != string && string.length() > 0) {
                try {
                    d = Double.parseDouble(string);
                    string = AppCore.formatDecimal((double)d, (int)0, (int)1);
                    this.cellSizeMenu.setSelectedItem(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (null != (string = this.isLPTV || this.isClassA && this.isPostWindow ? this.studyBuild.defaultProfilePpkLPTV : this.studyBuild.defaultProfilePpk) && string.length() > 0) {
                try {
                    d = Double.parseDouble(string);
                    if (d > 0.0) {
                        d = 1.0 / d;
                    }
                    this.profilePtIncField.setText(AppCore.formatDecimal((double)d, (int)0, (int)3));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.studyBuild.buildFullStudy) {
                if (null != this.studyBuild.baselineDate) {
                    AppController.setComponentEnabled(this.protectPreBaselineCheckBox, this.enabled);
                } else {
                    this.protectPreBaselineCheckBox.setSelected(false);
                    AppController.setComponentEnabled(this.protectPreBaselineCheckBox, false);
                }
                this.protectLPTVFromClassACheckBox.setSelected(this.studyBuild.protectLPTVFromClassA && this.isClassA);
                AppController.setComponentEnabled(this.protectLPTVFromClassACheckBox, this.enabled && this.isClassA && !this.isPostWindow);
            }
        }

        @Override
        public void selectionChanged(Object object) {
            String string;
            int n;
            Object object2;
            super.selectionChanged(object);
            this.selectedRecord = null;
            this.isPostWindow = false;
            if (null == object) {
                return;
            }
            if (object instanceof SourceEditData) {
                object2 = (SourceEditData)object;
                if (1 == ((SourceEditData)object2).recordType) {
                    this.selectedRecord = object2;
                    if (null != ((SourceEditData)object2).extDbKey && this.extDbMenu.containsKey(n = ((SourceEditData)object2).extDbKey.intValue())) {
                        this.extDbMenu.setSelectedKey(n);
                    }
                }
            } else if (object instanceof ExtDbRecord) {
                object2 = (ExtDbRecord)object;
                if (1 == ((ExtDbRecord)object2).recordType) {
                    this.selectedRecord = object2;
                    n = ((ExtDbRecord)object2).extDb.key;
                    if (this.extDbMenu.containsKey(n)) {
                        this.extDbMenu.setSelectedKey(n);
                    }
                }
            }
            this.isPostWindow = null != this.studyBuild.filingWindowEndDate && null != this.sequenceDate && this.sequenceDate.after(this.studyBuild.filingWindowEndDate);
            object2 = this.isLPTV || this.isClassA && this.isPostWindow ? this.studyBuild.defaultCellSizeLPTV : this.studyBuild.defaultCellSize;
            if (null != object2 && ((String)object2).length() > 0) {
                try {
                    double d = Double.parseDouble((String)object2);
                    object2 = AppCore.formatDecimal((double)d, (int)0, (int)1);
                    this.cellSizeMenu.setSelectedItem(object2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (null != (object2 = this.isLPTV || this.isClassA && this.isPostWindow ? this.studyBuild.defaultProfilePpkLPTV : this.studyBuild.defaultProfilePpk) && ((String)object2).length() > 0) {
                try {
                    double d = Double.parseDouble((String)object2);
                    if (d > 0.0) {
                        d = 1.0 / d;
                    }
                    this.profilePtIncField.setText(AppCore.formatDecimal((double)d, (int)0, (int)3));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (object instanceof StationRecord && null != (string = ((StationRecord)object).getFileNumber()) && string.length() > 0) {
                this.nameField.setText(string);
            }
            if (this.studyBuild.buildFullStudy) {
                this.protectPreBaselineCheckBox.setSelected(this.studyBuild.protectPreBaseline);
                this.protectBaselineFromLPTVCheckBox.setSelected(this.studyBuild.protectBaselineFromLPTV && this.isLPTV);
                AppController.setComponentEnabled(this.protectBaselineFromLPTVCheckBox, this.enabled && this.isLPTV);
                this.protectLPTVFromClassACheckBox.setSelected(this.studyBuild.protectLPTVFromClassA && this.isClassA);
                AppController.setComponentEnabled(this.protectLPTVFromClassACheckBox, this.enabled && this.isClassA && !this.isPostWindow);
            }
        }

        @Override
        public boolean validateInput() {
            this.errorReporter.clearTitle();
            if (null == this.selectedRecord) {
                this.errorReporter.reportWarning("Please select a TV record to study");
                return false;
            }
            if (!super.validateInput()) {
                return false;
            }
            if (!DbCore.checkStudyName((String)this.name, (String)this.getDbID(), (boolean)false, (int)(this.replicate || this.changeChannel ? 10 : 0), (ErrorLogger)this.errorReporter)) {
                return false;
            }
            int n = this.templateMenu.getSelectedKey();
            if (n <= 0) {
                this.errorReporter.reportWarning("Please select a study template");
                return false;
            }
            ExtDb extDb = null;
            int n2 = this.extDbMenu.getSelectedKey();
            if (n2 <= 0) {
                this.errorReporter.reportWarning("Please select a station data set");
                return false;
            }
            extDb = ExtDb.getExtDb((String)this.getDbID(), (Integer)n2);
            if (null == extDb || extDb.deleted) {
                this.errorReporter.reportWarning("That station data set has been deleted, please select another");
                return false;
            }
            String string = (String)this.cellSizeMenu.getSelectedItem();
            String string2 = this.profilePtIncField.getText().trim();
            if (0 == string2.length()) {
                this.errorReporter.reportWarning("Please enter a profile point spacing");
                return false;
            }
            double d = 0.0;
            try {
                d = Double.parseDouble(string2);
                if (d > 0.0) {
                    if (d <= 1.0) {
                        d = 1.0 / d;
                    }
                    this.profilePtIncField.setText(AppCore.formatDecimal((double)(1.0 / d), (int)0, (int)3));
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.errorReporter.reportWarning("The profile point spacing must be a number");
                return false;
            }
            if (d < 1.0 || d > 50.0) {
                this.errorReporter.reportWarning("The profile point spacing must be in the range 0.02 to 1.0");
                return false;
            }
            String string3 = String.valueOf(d);
            TreeSet<String> treeSet = null;
            TreeSet<Integer> treeSet2 = null;
            if (this.studyBuild.buildFullStudy) {
                string2 = this.excludeCommandsTextArea.getText().trim();
                if (string2.length() > 0) {
                    treeSet = new TreeSet<String>();
                    for (String string4 : string2.split("\\s+")) {
                        treeSet.add(string4);
                    }
                }
                if ((string2 = this.includeUserRecordsTextArea.getText().trim()).length() > 0) {
                    treeSet2 = new TreeSet<Integer>();
                    for (String string5 : string2.split("\\s+")) {
                        int n3 = 0;
                        try {
                            n3 = Integer.parseInt(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n3 <= 0) {
                            this.errorReporter.reportWarning("Only user record IDs may appear in the include list");
                            return false;
                        }
                        treeSet2.add(n3);
                    }
                }
            }
            if (this.selectedRecord.isSource()) {
                this.studyBuild.source = (SourceEditData)this.selectedRecord;
            } else {
                this.studyBuild.record = (ExtDbRecord)this.selectedRecord;
            }
            this.studyBuild.templateKey = n;
            this.studyBuild.extDb = extDb;
            this.studyBuild.studyName = this.name;
            this.studyBuild.studyDescription = null;
            if (this.description.length() > 0) {
                this.studyBuild.studyDescription = this.description;
            }
            this.studyBuild.cellSize = string;
            this.studyBuild.profilePpk = string3;
            if (this.studyBuild.buildFullStudy) {
                this.studyBuild.fileOutputConfig = this.fileOutputConfig;
                this.studyBuild.mapOutputConfig = this.mapOutputConfig;
                this.studyBuild.protectPreBaseline = this.protectPreBaselineCheckBox.isSelected();
                this.studyBuild.protectBaselineFromLPTV = this.protectBaselineFromLPTVCheckBox.isSelected();
                this.studyBuild.protectLPTVFromClassA = this.protectLPTVFromClassACheckBox.isSelected();
                this.studyBuild.includeForeign = this.includeForeignCheckBox.isSelected();
                this.studyBuild.includeUserRecords = treeSet2;
                this.studyBuild.cpExcludesBaseline = this.cpExcludesBaselineCheckBox.isSelected();
                this.studyBuild.excludeApps = this.excludeAppsCheckBox.isSelected();
                this.studyBuild.includeAmendments = this.includeAmendmentsCheckBox.isSelected();
                this.studyBuild.excludePending = this.excludePendingCheckBox.isSelected();
                this.studyBuild.excludePostTransition = this.excludePostTransitionCheckBox.isSelected();
                this.studyBuild.excludeNewLPTV = this.excludeNewLPTVCheckBox.isSelected();
                this.studyBuild.excludeCommands = treeSet;
                this.studyBuild.filingCutoffDate = this.filingCutoffDatePanel.getDate();
                this.studyBuilds = new ArrayList();
                if (this.replicate || this.changeChannel) {
                    if (this.includeOriginalChannelStudy) {
                        this.studyBuilds.add((StudyBuild)this.studyBuild);
                    }
                    for (int n4 : this.studyChannels) {
                        StudyBuildIxCheck studyBuildIxCheck = this.studyBuild.copy();
                        studyBuildIxCheck.replicate = this.replicate;
                        studyBuildIxCheck.changeChannel = this.changeChannel;
                        studyBuildIxCheck.studyChannel = n4;
                        studyBuildIxCheck.studyName = this.name + " (on " + String.valueOf(n4) + ")";
                        this.studyBuilds.add((StudyBuild)studyBuildIxCheck);
                    }
                } else {
                    this.studyBuilds.add((StudyBuild)this.studyBuild);
                }
            } else if (this.replicate || this.changeChannel) {
                this.studyBuild.replicate = this.replicate;
                this.studyBuild.changeChannel = this.changeChannel;
                this.studyBuild.studyChannel = this.studyChannel;
                this.studyBuild.studyName = this.name + " (on " + String.valueOf(this.studyChannel) + ")";
            }
            return true;
        }

        public StudyBuildIxCheck getStudyBuild() {
            return this.studyBuild;
        }

        @Override
        public ArrayList<StudyBuild> getStudyBuilds() {
            return this.studyBuilds;
        }
    }

    public static class NewScenario
    extends OptionsPanel {
        public NewScenario(AppEditor appEditor) {
            super(appEditor, true, "Scenario Name", false, null, false, true, false, false, false, false);
            this.setBorder(BorderFactory.createTitledBorder("Scenario Settings"));
        }
    }

    public static class AddRecord
    extends OptionsPanel {
        public AddRecord(AppEditor appEditor) {
            super(appEditor, false, null, false, null, true, true, false, false, false, false);
            this.setBorder(BorderFactory.createTitledBorder("Record Options"));
        }
    }
}

