/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbListener;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppFrame;
import gov.fcc.tvstudy.gui.BackgroundWorker;
import gov.fcc.tvstudy.gui.DbController;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.StudyManager;
import gov.fcc.tvstudy.gui.TemplateManager;
import gov.fcc.tvstudy.gui.run.RunManager;
import gov.fcc.tvstudy.gui.run.RunPanelThread;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ExtDbManager
extends AppFrame
implements ExtDbListener {
    public static final String WINDOW_TITLE = "Station Data Manager";
    private String dbID;
    private ExtDbListModel extDbModel;
    private JTable extDbTable;
    private KeyedRecordMenu downloadMenu;
    private JButton downloadButton;
    private KeyedRecordMenu createAndImportMenu;
    private JButton importGenericButton;
    private JMenuItem importGenericMenuItem;
    private JMenuItem renameExtDbMenuItem;
    private JMenuItem deleteExtDbMenuItem;
    private JMenuItem clearBadDataFlagMenuItem;
    private JMenuItem unlockExtDbMenuItem;
    private JMenuItem extDbInfoMenuItem;
    private ExtDbManager outerThis = this;
    private static HashMap<String, ExtDbManager> managers = new HashMap();

    public static boolean showManager(String string) {
        ExtDbManager extDbManager = managers.get(string);
        if (null != extDbManager) {
            extDbManager.toFront();
            return true;
        }
        if (DbCore.isDbRegistered((String)string)) {
            extDbManager = new ExtDbManager(string);
            managers.put(string, extDbManager);
            AppController.showWindow(extDbManager);
            return true;
        }
        return false;
    }

    private ExtDbManager(String string) {
        super(null, WINDOW_TITLE);
        int n;
        JMenuItem jMenuItem;
        Object object3;
        JMenu jMenu;
        Object object2;
        this.dbID = string;
        this.extDbModel = new ExtDbListModel();
        this.extDbTable = this.extDbModel.createTable();
        this.extDbTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ExtDbManager.this.updateControls();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Station Data"));
        jPanel.add((Component)AppController.createScrollPane(this.extDbTable), "Center");
        ArrayList arrayList = ExtDb.getDownloadTypes();
        if (arrayList.size() > 1) {
            arrayList.add(0, new KeyedRecord(0, "Download..."));
            this.downloadMenu = new KeyedRecordMenu(arrayList);
            this.downloadMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExtDbManager.this.blockActions()) {
                        int n = ExtDbManager.this.downloadMenu.getSelectedKey();
                        ExtDbManager.this.downloadMenu.setSelectedIndex(0);
                        ExtDbManager.this.blockActionsEnd();
                        if (n > 0) {
                            ExtDbManager.this.doDownloadAndImport(n);
                        }
                    }
                }
            });
        } else {
            object2 = (KeyedRecord)arrayList.get(0);
            this.downloadButton = new JButton("Download " + ((KeyedRecord)object2).name);
            this.downloadButton.setFocusable(false);
            final int n2 = ((KeyedRecord)object2).key;
            this.downloadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtDbManager.this.doDownloadAndImport(n2);
                }
            });
        }
        object2 = ExtDb.getImportTypes();
        ((ArrayList)object2).add(0, new KeyedRecord(0, "Create & Import..."));
        this.createAndImportMenu = new KeyedRecordMenu((ArrayList<KeyedRecord>)object2);
        this.createAndImportMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExtDbManager.this.blockActions()) {
                    int n = ExtDbManager.this.createAndImportMenu.getSelectedKey();
                    ExtDbManager.this.createAndImportMenu.setSelectedIndex(0);
                    ExtDbManager.this.blockActionsEnd();
                    if (n > 0) {
                        ExtDbManager.this.doCreateAndImport(n);
                    }
                }
            }
        });
        this.importGenericButton = new JButton("Import More");
        this.importGenericButton.setFocusable(false);
        this.importGenericButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbManager.this.doImportGeneric();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        if (null != this.downloadMenu) {
            jPanel2.add(this.downloadMenu);
        } else {
            jPanel2.add(this.downloadButton);
        }
        jPanel2.add(this.createAndImportMenu);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.importGenericButton);
        Box box = Box.createHorizontalBox();
        box.add(jPanel2);
        box.add(jPanel3);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)box, "South");
        this.pack();
        Dimension dimension = new Dimension(500, 400);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.fileMenu.removeAll();
        JMenuItem jMenuItem2 = new JMenuItem("Previous");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(38, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbManager.this.doPrevious();
            }
        });
        this.fileMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Next");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(40, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbManager.this.doNext();
            }
        });
        this.fileMenu.add(jMenuItem3);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Refresh List");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDb.reloadCache((String)ExtDbManager.this.dbID);
            }
        });
        this.fileMenu.add(jMenuItem4);
        this.fileMenu.addSeparator();
        if (arrayList.size() > 1) {
            jMenu = new JMenu("Download");
            for (Object object3 : arrayList) {
                jMenuItem = new JMenuItem(((KeyedRecord)object3).name);
                n = ((KeyedRecord)object3).key;
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ExtDbManager.this.doDownloadAndImport(n);
                    }
                });
                jMenu.add(jMenuItem);
            }
            this.fileMenu.add(jMenu);
        } else {
            jMenu = (KeyedRecord)arrayList.get(0);
            jMenuItem = new JMenuItem("Download " + ((KeyedRecord)jMenu).name);
            final int n3 = ((KeyedRecord)jMenu).key;
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtDbManager.this.doDownloadAndImport(n3);
                }
            });
            this.fileMenu.add(jMenuItem);
        }
        jMenu = new JMenu("Create & Import");
        Object object4 = ((ArrayList)object2).iterator();
        while (object4.hasNext()) {
            object3 = (KeyedRecord)object4.next();
            if (((KeyedRecord)object3).key <= 0) continue;
            jMenuItem = new JMenuItem(((KeyedRecord)object3).name);
            n = ((KeyedRecord)object3).key;
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtDbManager.this.doCreateAndImport(n);
                }
            });
            jMenu.add(jMenuItem);
        }
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.importGenericMenuItem = new JMenuItem("Import More...");
        this.importGenericMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbManager.this.doImportGeneric();
            }
        });
        this.fileMenu.add(this.importGenericMenuItem);
        this.renameExtDbMenuItem = new JMenuItem("Rename...");
        this.renameExtDbMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbManager.this.doRenameExtDb();
            }
        });
        this.fileMenu.add(this.renameExtDbMenuItem);
        this.deleteExtDbMenuItem = new JMenuItem("Delete");
        this.deleteExtDbMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbManager.this.doDeleteExtDb();
            }
        });
        this.fileMenu.add(this.deleteExtDbMenuItem);
        this.clearBadDataFlagMenuItem = new JMenuItem("Clear Bad Data Flag");
        this.clearBadDataFlagMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbManager.this.doClearBadDataFlag();
            }
        });
        this.fileMenu.add(this.clearBadDataFlagMenuItem);
        this.fileMenu.addSeparator();
        this.unlockExtDbMenuItem = new JMenuItem("Unlock");
        this.unlockExtDbMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbManager.this.doUnlockExtDb();
            }
        });
        this.fileMenu.add(this.unlockExtDbMenuItem);
        this.fileMenu.addSeparator();
        this.extDbInfoMenuItem = new JMenuItem("Get Info");
        this.extDbInfoMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, AppController.MENU_SHORTCUT_KEY_MASK));
        this.extDbInfoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbManager.this.doExtDbInfo();
            }
        });
        this.fileMenu.add(this.extDbInfoMenuItem);
        this.extraMenu.removeAll();
        object4 = new JMenuItem("Study Manager");
        ((AbstractButton)object4).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.showManager(ExtDbManager.this.dbID);
            }
        });
        this.extraMenu.add((JMenuItem)object4);
        object3 = new JMenuItem("Template Manager");
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.showManager(ExtDbManager.this.dbID);
            }
        });
        this.extraMenu.add((JMenuItem)object3);
        this.updateControls();
        this.updateDocumentName();
    }

    @Override
    public String getDbID() {
        return this.dbID;
    }

    @Override
    protected String getFileMenuName() {
        return "Data";
    }

    @Override
    protected boolean showsExtraMenu() {
        return true;
    }

    @Override
    protected String getExtraMenuName() {
        return "Database";
    }

    @Override
    protected boolean showsEditMenu() {
        return false;
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(DbCore.getHostDbName((String)this.dbID));
    }

    private void updateControls() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = this.extDbTable.getSelectedRow();
        if (n >= 0) {
            ExtDbListItem extDbListItem = this.extDbModel.get(this.extDbTable.convertRowIndexToModel(n));
            bl = !extDbListItem.isLocked && extDbListItem.isGeneric && extDbListItem.isSupported;
            bl2 = !extDbListItem.isLocked && extDbListItem.isSupported;
            bl3 = !extDbListItem.isLocked;
            bl4 = extDbListItem.hasBadData;
            bl5 = extDbListItem.isLocked;
        }
        this.importGenericButton.setEnabled(bl);
        this.importGenericMenuItem.setEnabled(bl);
        this.renameExtDbMenuItem.setEnabled(bl2);
        this.deleteExtDbMenuItem.setEnabled(bl3);
        this.clearBadDataFlagMenuItem.setEnabled(bl4);
        this.unlockExtDbMenuItem.setEnabled(bl5);
    }

    public void updateExtDbList() {
        this.updateExtDbList(true);
    }

    private void updateExtDbList(boolean bl) {
        int n;
        ArrayList arrayList;
        int n2;
        String string = this.errorReporter.getTitle();
        this.errorReporter.setTitle("Load Station Data List");
        ExtDbListItem extDbListItem = null;
        if (bl && (n2 = this.extDbTable.getSelectedRow()) >= 0) {
            extDbListItem = this.extDbModel.get(this.extDbTable.convertRowIndexToModel(n2));
        }
        if (null == (arrayList = ExtDb.getExtDbs((String)this.dbID, (boolean)true, (ErrorLogger)this.errorReporter))) {
            this.errorReporter.setTitle(string);
            return;
        }
        ArrayList<ExtDbListItem> arrayList2 = new ArrayList<ExtDbListItem>();
        for (ExtDb extDb : arrayList) {
            ExtDbListItem extDbListItem2 = new ExtDbListItem();
            extDbListItem2.key = extDb.key;
            extDbListItem2.type = extDb.type;
            extDbListItem2.version = extDb.version;
            extDbListItem2.indexVersion = extDb.indexVersion;
            extDbListItem2.id = extDb.id;
            if (extDb.isDownload) {
                extDbListItem2.name = "(download)";
            } else {
                extDbListItem2.name = extDb.name;
            }
            extDbListItem2.isLocked = extDb.isLocked;
            extDbListItem2.isGeneric = extDb.isGeneric();
            extDbListItem2.isSupported = extDb.isSupported();
            extDbListItem2.hasBadData = extDb.hasBadData;
            arrayList2.add(extDbListItem2);
        }
        this.extDbModel.setItems(arrayList2);
        if (extDbListItem != null && (n = this.extDbModel.indexOf(extDbListItem)) >= 0) {
            n = this.extDbTable.convertRowIndexToView(n);
            this.extDbTable.setRowSelectionInterval(n, n);
            this.extDbTable.scrollRectToVisible(this.extDbTable.getCellRect(n, 0, true));
        }
        this.updateControls();
        this.errorReporter.setTitle(string);
    }

    private ExtDbListItem checkExtDb(int n, ErrorReporter errorReporter) {
        ExtDbListItem extDbListItem = this.extDbModel.get(n);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        DbConnection dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)errorReporter);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT db_type, version, index_version, id, is_download, name, locked FROM ext_db WHERE NOT deleted AND ext_db_key = " + extDbListItem.key);
                if (dbConnection.next()) {
                    int n2 = dbConnection.getInt(1);
                    int n3 = dbConnection.getInt(2);
                    int n4 = dbConnection.getInt(3);
                    String string = dbConnection.getString(4);
                    String string2 = dbConnection.getBoolean(5) ? "(download)" : dbConnection.getString(6);
                    boolean bl4 = dbConnection.getBoolean(7);
                    if (n2 != extDbListItem.type || n3 != extDbListItem.version || n4 != extDbListItem.indexVersion || !string.equals(extDbListItem.id) || !string2.equals(extDbListItem.name) || bl4 != extDbListItem.isLocked) {
                        extDbListItem.type = n2;
                        extDbListItem.version = n3;
                        extDbListItem.indexVersion = n4;
                        extDbListItem.id = string;
                        extDbListItem.name = string2;
                        extDbListItem.isLocked = bl4;
                        extDbListItem.isGeneric = ExtDb.isGeneric((int)n2);
                        extDbListItem.isSupported = ExtDb.isSupported((int)n2, (int)n3, (int)n4);
                        bl3 = true;
                    }
                } else {
                    bl2 = true;
                    bl3 = true;
                }
                DbCore.releaseDb((DbConnection)dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb((DbConnection)dbConnection);
                bl = true;
                DbConnection.reportError((ErrorLogger)errorReporter, (SQLException)sQLException);
            }
        } else {
            return extDbListItem;
        }
        if (bl) {
            return extDbListItem;
        }
        if (bl2) {
            if (null != errorReporter) {
                errorReporter.reportError("The station data no longer exists");
            }
            extDbListItem = null;
        }
        if (bl3) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtDb.reloadCache((String)ExtDbManager.this.dbID);
                }
            });
        }
        return extDbListItem;
    }

    private void doPrevious() {
        int n = this.extDbTable.getRowCount();
        int n2 = this.extDbTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.extDbTable.setRowSelectionInterval(n2, n2);
            this.extDbTable.scrollRectToVisible(this.extDbTable.getCellRect(n2, 0, true));
        }
    }

    private void doNext() {
        int n = this.extDbTable.getRowCount();
        int n2 = this.extDbTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.extDbTable.setRowSelectionInterval(n2, n2);
            this.extDbTable.scrollRectToVisible(this.extDbTable.getCellRect(n2, 0, true));
        }
    }

    private void doDownloadAndImport(int n) {
        String string = "Download " + ExtDb.getTypeName((int)n) + " station data";
        this.errorReporter.setTitle(string);
        if (ExtDb.isDownloadInProgress()) {
            this.errorReporter.reportWarning("Download is already in progress");
            RunManager.showRunManager();
            return;
        }
        final int n2 = n;
        RunPanelThread runPanelThread = new RunPanelThread(string, this.dbID){

            @Override
            public Object runActivity(StatusLogger statusLogger, ErrorLogger errorLogger) {
                return ExtDb.downloadDatabase((String)this.dbID, (int)n2, (String)"", (StatusLogger)statusLogger, (ErrorLogger)errorLogger);
            }
        };
        runPanelThread.memoryFraction = 0.0;
        if (runPanelThread.initialize(this.errorReporter)) {
            RunManager.addRunPanel(runPanelThread);
        }
    }

    private void doCreateAndImport(int n) {
        String string = "Import " + ExtDb.getTypeName((int)n) + " Station Data";
        this.errorReporter.setTitle(string);
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
                jFileChooser.setDialogType(0);
                jFileChooser.setMultiSelectionEnabled(false);
                JTextField jTextField = new JTextField(12);
                AppController.fixKeyBindings(jTextField);
                JPanel jPanel = new JPanel(new FlowLayout(0));
                jPanel.setBorder(BorderFactory.createTitledBorder("Data set name (optional)"));
                jPanel.add(jTextField);
                JPanel jPanel2 = new JPanel(new FlowLayout(0));
                jPanel2.add(jPanel);
                jFileChooser.setAccessory(jPanel2);
                jFileChooser.setFileSelectionMode(2);
                jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("ZIP (*.zip)", "zip"));
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setDialogTitle("Choose " + ExtDb.getTypeName((int)n) + " data file directory, or ZIP file");
                File file = null;
                String string2 = "";
                while (0 == jFileChooser.showDialog(this, "Choose")) {
                    string2 = jTextField.getText().trim();
                    if (!ExtDb.checkExtDbName((String)this.dbID, (String)string2, (ErrorLogger)this.errorReporter)) continue;
                    file = jFileChooser.getSelectedFile();
                    break;
                }
                if (null == file) break;
                if (!file.exists()) {
                    file = file.getParentFile();
                }
                AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
                final int n2 = n;
                final File file2 = file;
                final String string3 = string2;
                RunPanelThread runPanelThread = new RunPanelThread(string, this.dbID){

                    @Override
                    public Object runActivity(StatusLogger statusLogger, ErrorLogger errorLogger) {
                        return ExtDb.createNewDatabase((String)this.dbID, (int)n2, (File)file2, (String)string3, (StatusLogger)statusLogger, (ErrorLogger)errorLogger);
                    }
                };
                runPanelThread.memoryFraction = 0.0;
                if (!runPanelThread.initialize(this.errorReporter)) break;
                RunManager.addRunPanel(runPanelThread);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.importGeneric(null, n, string);
                break;
            }
            default: {
                this.errorReporter.reportError("Unknown or unsupported station data type");
            }
        }
    }

    private void doImportGeneric() {
        int n = this.extDbTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        ExtDbListItem extDbListItem = this.checkExtDb(this.extDbTable.convertRowIndexToModel(n), this.errorReporter);
        if (extDbListItem.isLocked || !extDbListItem.isGeneric || !extDbListItem.isSupported) {
            return;
        }
        String string = "Import " + ExtDb.getTypeName((int)extDbListItem.type) + " Station Data";
        this.errorReporter.setTitle(string);
        ExtDb extDb = ExtDb.getExtDb((String)this.dbID, (Integer)extDbListItem.key, (ErrorLogger)this.errorReporter);
        if (null == extDb) {
            return;
        }
        this.importGeneric(extDb, extDb.type, string);
    }

    private void importGeneric(ExtDb extDb, int n, String string) {
        Object object;
        JPanel jPanel;
        if (!ExtDb.isGeneric((int)n)) {
            this.errorReporter.reportError("Unknown or unsupported station data type");
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Text (*.csv,*.txt,*.dat)", "csv", "txt", "dat"));
        if (6 == n || 8 == n) {
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Canadian DBF (*.dbf)", "dbf"));
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        JCheckBox jCheckBox = new JCheckBox("Separate pattern file");
        if (7 == n) {
            jCheckBox.setSelected(true);
        }
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Text options"));
        jPanel2.add(jCheckBox);
        Box box = Box.createVerticalBox();
        JTextField jTextField = null;
        if (null == extDb) {
            jTextField = new JTextField(12);
            AppController.fixKeyBindings(jTextField);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createTitledBorder("Data set name (optional)"));
            jPanel.add(jTextField);
            box.add(jPanel);
        }
        box.add(jPanel2);
        jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(box);
        jFileChooser.setAccessory(jPanel);
        File file = null;
        String string2 = "";
        while (0 == jFileChooser.showDialog(this, "Import")) {
            if (null != jTextField && !ExtDb.checkExtDbName((String)this.dbID, (String)(string2 = jTextField.getText().trim()), (ErrorLogger)this.errorReporter)) continue;
            file = jFileChooser.getSelectedFile();
            break;
        }
        if (null == file) {
            return;
        }
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        String string3 = file.getName().toLowerCase();
        int n2 = 1;
        if (string3.endsWith(".dbf")) {
            n2 = 2;
        }
        final int n3 = n2;
        final File file2 = file;
        file = null;
        if (1 == n2 && jCheckBox.isSelected()) {
            jFileChooser = new JFileChooser(file2.getParentFile().getAbsolutePath());
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle("Choose pattern data file");
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("TVStudy text (*.csv,*.txt,*.dat)", "csv", "txt", "dat"));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            if (0 != jFileChooser.showDialog(this, "Import")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        }
        final File file3 = file;
        if (null == extDb) {
            object = ExtDb.createNewGenericDatabase((String)this.dbID, (int)n, (String)string2, (ErrorLogger)this.errorReporter);
            if (null == object) {
                return;
            }
            extDb = ExtDb.getExtDb((String)this.dbID, (Integer)object, (ErrorLogger)this.errorReporter);
            if (null == extDb) {
                return;
            }
        }
        object = extDb;
        BackgroundWorker<Integer> backgroundWorker = new BackgroundWorker<Integer>((Window)this, string){

            @Override
            protected Integer doBackgroundWork(ErrorLogger errorLogger) {
                int n = ExtDb.importToGenericDatabase((ExtDb)object, (int)n3, (File)file2, (File)file3, (ErrorLogger)errorLogger);
                if (n < 0) {
                    return null;
                }
                return n;
            }
        };
        this.errorReporter.clearMessages();
        Integer n4 = (Integer)backgroundWorker.runWork("Importing records, please wait...", this.errorReporter);
        if (null != n4) {
            this.errorReporter.showMessages();
            this.errorReporter.reportMessage("Imported " + n4 + " records");
        }
    }

    private void doRenameExtDb() {
        String string = "Rename Station Data";
        this.errorReporter.setTitle(string);
        int n = this.extDbTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        ExtDbListItem extDbListItem = this.checkExtDb(this.extDbTable.convertRowIndexToModel(n), this.errorReporter);
        if (null == extDbListItem || extDbListItem.isLocked || !extDbListItem.isSupported) {
            return;
        }
        String string2 = extDbListItem.name;
        String string3 = null;
        if (string2.equals("(download)")) {
            string2 = "";
        }
        do {
            if (null == (string3 = (String)JOptionPane.showInputDialog(this, "Enter a name for the data (optional)", string, 3, null, null, string2))) {
                return;
            }
            string3 = string3.trim();
            if (string2.length() <= 0 || !string3.equals(string2)) continue;
            return;
        } while (!ExtDb.checkExtDbName((String)this.dbID, (String)string3, (String)string2, (ErrorLogger)this.errorReporter));
        ExtDb.renameDatabase((String)this.dbID, (Integer)extDbListItem.key, (String)string3, (ErrorLogger)this.errorReporter);
    }

    private void doDeleteExtDb() {
        int n = this.extDbTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        ExtDbListItem extDbListItem = this.checkExtDb(this.extDbTable.convertRowIndexToModel(n), this.errorReporter);
        if (null == extDbListItem || extDbListItem.isLocked) {
            return;
        }
        this.errorReporter.setTitle("Delete Station Data");
        ExtDb.deleteDatabase((String)this.dbID, (Integer)extDbListItem.key, (ErrorLogger)this.errorReporter);
    }

    private void doClearBadDataFlag() {
        int n = this.extDbTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        ExtDbListItem extDbListItem = this.checkExtDb(this.extDbTable.convertRowIndexToModel(n), this.errorReporter);
        if (null == extDbListItem || extDbListItem.isLocked) {
            return;
        }
        this.errorReporter.setTitle("Clear Bad Data Flag");
        ExtDb.clearBadDataFlag((String)this.dbID, (Integer)extDbListItem.key, (ErrorLogger)this.errorReporter);
    }

    private void doUnlockExtDb() {
        String string = "Unlock Station Data";
        this.errorReporter.setTitle(string);
        int n = this.extDbTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        ExtDbListItem extDbListItem = this.checkExtDb(this.extDbTable.convertRowIndexToModel(n), this.errorReporter);
        if (null == extDbListItem || !extDbListItem.isLocked) {
            return;
        }
        AppController.beep();
        if (0 != JOptionPane.showConfirmDialog(this, "This will clear the in-use flag on the data set.  Do this only if the flag\nwas not cleared because of an application crash or network failure.  If\nthis is done when another application is still using the data set, that\napplication could fail and data could become corrupted.\n\nDo you want to continue?", string, 0, 2)) {
            return;
        }
        ExtDb extDb = ExtDb.getExtDb((String)this.dbID, (Integer)extDbListItem.key, (ErrorLogger)this.errorReporter);
        if (null == extDb) {
            return;
        }
        extDbListItem.isLocked = extDb.unlock((ErrorLogger)this.errorReporter);
        this.updateControls();
    }

    private void doExtDbInfo() {
        String string = "Data Set Info";
        this.errorReporter.setTitle(string);
        int n = this.extDbTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        ExtDbListItem extDbListItem = this.checkExtDb(this.extDbTable.convertRowIndexToModel(n), this.errorReporter);
        if (null == extDbListItem) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Name: ");
        stringBuilder.append(extDbListItem.name);
        stringBuilder.append('\n');
        stringBuilder.append("Type: ");
        stringBuilder.append(ExtDb.getTypeName((int)extDbListItem.type));
        stringBuilder.append('\n');
        stringBuilder.append("Date: ");
        stringBuilder.append(extDbListItem.id);
        stringBuilder.append('\n');
        stringBuilder.append("Primary key: ");
        stringBuilder.append(String.valueOf(extDbListItem.key));
        stringBuilder.append('\n');
        stringBuilder.append("Database name: ");
        stringBuilder.append(ExtDb.makeDbName((String)DbCore.getDbName((String)this.dbID), (int)extDbListItem.type, (Integer)extDbListItem.key));
        stringBuilder.append('\n');
        stringBuilder.append("Version: ");
        stringBuilder.append(String.valueOf(extDbListItem.version));
        stringBuilder.append('\n');
        stringBuilder.append("Index version: ");
        stringBuilder.append(String.valueOf(extDbListItem.indexVersion));
        if (extDbListItem.isLocked) {
            stringBuilder.append("\nLocked for data import");
        }
        if (!extDbListItem.isSupported) {
            stringBuilder.append("\n** Unknown/unsupported type or version **");
        }
        if (extDbListItem.hasBadData) {
            stringBuilder.append("\n** Consistency checks failed, may have bad data **");
        }
        AppController.showMessage(this, (Object)stringBuilder.toString(), "Data Set Info");
    }

    @Override
    public void windowWillOpen() {
        if (this.isVisible()) {
            return;
        }
        DbCore.openDb((String)this.dbID, (Object)this);
        ExtDb.addListener((ExtDbListener)this);
        DbController.restoreColumnWidths(this.dbID, this.getKeyTitle(), this.extDbTable);
        this.blockActionsClear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExtDbManager.this.updateExtDbList(false);
            }
        });
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        DbController.saveColumnWidths(this.dbID, this.getKeyTitle(), this.extDbTable);
        this.blockActionsSet();
        managers.remove(this.dbID);
        DbCore.closeDb((String)this.dbID, (Object)this);
    }

    private class ExtDbListModel
    extends AbstractTableModel {
        private static final String EXT_DB_TYPE_COLUMN = "Type";
        private static final String EXT_DB_ID_COLUMN = "Date";
        private static final String EXT_DB_NAME_COLUMN = "Name";
        private String[] columnNames = new String[]{"Type", "Date", "Name"};
        private static final int EXT_DB_TYPE_INDEX = 0;
        private static final int EXT_DB_ID_INDEX = 1;
        private static final int EXT_DB_NAME_INDEX = 2;
        private ArrayList<ExtDbListItem> modelRows = new ArrayList();

        private ExtDbListModel() {
        }

        private JTable createTable() {
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    ExtDbListItem extDbListItem = (ExtDbListItem)ExtDbListModel.this.modelRows.get(jTable.convertRowIndexToModel(n));
                    if (!bl && extDbListItem.hasBadData) {
                        jLabel.setForeground(Color.RED);
                    } else {
                        jLabel.setForeground(Color.BLACK);
                    }
                    return jLabel;
                }
            };
            TableColumn tableColumn = jTable.getColumn(EXT_DB_TYPE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
            tableColumn = jTable.getColumn(EXT_DB_ID_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[15]);
            tableColumn = jTable.getColumn(EXT_DB_NAME_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[20]);
            return jTable;
        }

        private void setItems(ArrayList<ExtDbListItem> arrayList) {
            this.modelRows.clear();
            this.modelRows.addAll(arrayList);
            this.fireTableDataChanged();
        }

        private ExtDbListItem get(int n) {
            return this.modelRows.get(n);
        }

        private void remove(int n) {
            this.modelRows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        private void itemWasChanged(int n) {
            this.fireTableRowsUpdated(n, n);
        }

        private int indexOf(ExtDbListItem extDbListItem) {
            return this.modelRows.indexOf(extDbListItem);
        }

        private int indexOfKey(Integer n) {
            int n2 = 0;
            for (ExtDbListItem extDbListItem : this.modelRows) {
                if (extDbListItem.key.equals(n)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.modelRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ExtDbListItem extDbListItem = this.modelRows.get(n);
            switch (n2) {
                case 0: {
                    return ExtDb.getTypeName((int)extDbListItem.type);
                }
                case 1: {
                    return extDbListItem.id;
                }
                case 2: {
                    return extDbListItem.name;
                }
            }
            return "";
        }
    }

    private class ExtDbListItem {
        private Integer key;
        private int type;
        private int version;
        private int indexVersion;
        private String id;
        private String name;
        private boolean isLocked;
        private boolean isGeneric;
        private boolean isSupported;
        private boolean hasBadData;

        private ExtDbListItem() {
        }
    }
}

