/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.BackgroundWorker;
import gov.fcc.tvstudy.gui.RootEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DbController {
    private static boolean showDbName;
    private static LoginDialog loginDialog;
    private static HashMap<String, SetupDialog> dbSetupDialogs;
    private static Method showManagerMethod;
    private static boolean didShowSocketFileWarning;

    public static void showLogin() {
        if (null != loginDialog) {
            if (loginDialog.isVisible()) {
                return;
            }
        } else {
            String string = AppCore.getPreference((String)"showDbName");
            showDbName = null != string && Boolean.valueOf(string) != false;
            loginDialog = new LoginDialog();
        }
        AppController.showWindow(loginDialog);
    }

    public static boolean isLoginWindow(Window window) {
        return window == loginDialog;
    }

    public static void setDbManagerClass(Class<?> clazz) {
        try {
            showManagerMethod = clazz.getMethod("showManager", String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setDbManagerClassByName(String string) {
        try {
            DbController.setDbManagerClass(Class.forName(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean showManager(String string) {
        if (null != showManagerMethod) {
            try {
                Object object = showManagerMethod.invoke(null, string);
                if (null != object) {
                    return (Boolean)object;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static void checkSocketFileStatus(DbCore.DbInfo dbInfo) {
        if (dbInfo.dbIsLocal && null == DbCore.mysqlSocketFile && !didShowSocketFileWarning) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AppController.showMessage("The location of the MySQL local connection socket file could not be determined.\nThis may mean the study engine will not be able to connect to the database.  To\nfix this problem, quit TVStudy and manually add the line shown below to the file\n\"lib/tvstudy.props\" with the location of the socket file on your computer:\nmysqlSocketFile=/full/path/and/filename", "MySQL Configuration Error", 2);
                }
            });
            didShowSocketFileWarning = true;
        }
    }

    public static void saveWindowLocation(Window window, String string, String string2) {
        DbCore.setIntegerProperty((String)string, (String)(string2 + ".x"), (Integer)window.getLocation().x);
        DbCore.setIntegerProperty((String)string, (String)(string2 + ".y"), (Integer)window.getLocation().y);
        boolean bl = false;
        if (window instanceof Frame) {
            bl = ((Frame)window).isResizable();
        } else if (window instanceof Dialog) {
            bl = ((Dialog)window).isResizable();
        }
        if (bl) {
            DbCore.setIntegerProperty((String)string, (String)(string2 + ".sizex"), (Integer)window.getWidth());
            DbCore.setIntegerProperty((String)string, (String)(string2 + ".sizey"), (Integer)window.getHeight());
        }
    }

    public static void restoreWindowLocation(Window window, String string, String string2, int n, int n2) {
        Integer n3 = DbCore.getIntegerProperty((String)string, (String)(string2 + ".x"));
        Integer n4 = DbCore.getIntegerProperty((String)string, (String)(string2 + ".y"));
        if (n3 != null && n4 != null) {
            n = n3;
            n2 = n4;
        }
        window.setLocation(n, n2);
        boolean bl = false;
        if (window instanceof Frame) {
            bl = ((Frame)window).isResizable();
        } else if (window instanceof Dialog) {
            bl = ((Dialog)window).isResizable();
        }
        if (bl) {
            n3 = DbCore.getIntegerProperty((String)string, (String)(string2 + ".sizex"));
            n4 = DbCore.getIntegerProperty((String)string, (String)(string2 + ".sizey"));
            if (n3 != null && n4 != null) {
                window.setSize(n3, n4);
            }
        }
    }

    public static void saveColumnWidths(String string, String string2, JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            DbCore.setIntegerProperty((String)string, (String)(string2 + "." + tableColumn.getIdentifier() + ".columnWidth"), (Integer)tableColumn.getWidth());
        }
    }

    public static void restoreColumnWidths(String string, String string2, JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            Integer n2 = DbCore.getIntegerProperty((String)string, (String)(string2 + "." + tableColumn.getIdentifier() + ".columnWidth"));
            if (null == n2) continue;
            tableColumn.setPreferredWidth(n2);
        }
    }

    static {
        dbSetupDialogs = new HashMap();
        showManagerMethod = null;
        didShowSocketFileWarning = false;
    }

    private static class SetupDialog
    extends AppDialog {
        private static final String WINDOW_TITLE = "Database Setup";
        private DbCore.DbInfo dbInfo;
        private String originalDbID;
        private JLabel versionLabel;
        private JLabel statusLabel;
        private JLabel cacheLabel;
        private JButton installButton;
        private JButton clearCacheButton;
        private JButton unlockAllButton;
        private JButton updateButton;
        private JButton reloadButton;
        private JButton openButton;

        private SetupDialog(DbCore.DbInfo dbInfo) {
            super(null, null, WINDOW_TITLE, Dialog.ModalityType.MODELESS);
            this.dbInfo = dbInfo;
            this.originalDbID = dbInfo.dbID;
            JLabel jLabel = new JLabel(this.dbInfo.dbHostname);
            JLabel jLabel2 = new JLabel(this.dbInfo.dbName);
            this.versionLabel = new JLabel(AppCore.formatVersion((int)this.dbInfo.version));
            this.statusLabel = new JLabel("XXXXXXXXXXXXXXXXXXXX");
            this.cacheLabel = new JLabel("999.99 GB");
            this.installButton = new JButton("Uninstall");
            this.installButton.setFocusable(false);
            this.installButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (((SetupDialog)this).dbInfo.hasRoot) {
                        this.doUninstall();
                    } else {
                        this.doInstall();
                    }
                }
            });
            this.clearCacheButton = new JButton("Clear Cache");
            this.clearCacheButton.setFocusable(false);
            this.clearCacheButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doClearCache();
                }
            });
            this.unlockAllButton = new JButton("Unlock All");
            this.unlockAllButton.setFocusable(false);
            this.unlockAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doUnlockAll();
                }
            });
            this.updateButton = new JButton("Update");
            this.updateButton.setFocusable(false);
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doUpdate();
                }
            });
            if (AppController.ShowUtilityUI) {
                this.reloadButton = new JButton("Reload Root Data");
                this.reloadButton.setFocusable(false);
                this.reloadButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doReload();
                    }
                });
            }
            this.openButton = new JButton("Open");
            this.openButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doOpen();
                }
            });
            JButton jButton = new JButton("Done");
            jButton.setFocusable(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doCancel();
                }
            });
            JLabel jLabel3 = new JLabel("Host:");
            JLabel jLabel4 = new JLabel("Database:");
            JLabel jLabel5 = new JLabel("Version:");
            JLabel jLabel6 = new JLabel("Status:");
            JLabel jLabel7 = new JLabel("Cache size:");
            JPanel jPanel = new JPanel();
            GroupLayout groupLayout = new GroupLayout(jPanel);
            groupLayout.setAutoCreateGaps(true);
            groupLayout.setAutoCreateContainerGaps(true);
            jPanel.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel3).addComponent(jLabel4).addComponent(jLabel5).addComponent(jLabel6).addComponent(jLabel7)).addGroup(groupLayout.createParallelGroup().addComponent(jLabel).addComponent(jLabel2).addComponent(this.versionLabel).addComponent(this.statusLabel).addComponent(this.cacheLabel)));
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(jLabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(jLabel2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.versionLabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel6).addComponent(this.statusLabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel7).addComponent(this.cacheLabel)));
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.unlockAllButton);
            jPanel2.add(this.updateButton);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(this.installButton);
            jPanel3.add(this.clearCacheButton);
            JPanel jPanel4 = new JPanel(new FlowLayout(2));
            jPanel4.add(jButton);
            jPanel4.add(this.openButton);
            Container container = this.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add(jPanel);
            container.add(jPanel2);
            container.add(jPanel3);
            if (AppController.ShowUtilityUI) {
                JPanel jPanel5 = new JPanel();
                jPanel5.add(this.reloadButton);
                container.add(jPanel5);
            }
            container.add(jPanel4);
            this.getRootPane().setDefaultButton(this.openButton);
            this.pack();
            this.setMinimumSize(this.getSize());
            this.setResizable(true);
            this.setLocationSaved(true);
            this.updateControls();
        }

        @Override
        public String getDbID() {
            return null;
        }

        @Override
        public RootEditor getRootEditor() {
            return null;
        }

        private void updateControls() {
            this.versionLabel.setText(AppCore.formatVersion((int)this.dbInfo.version));
            this.statusLabel.setText(this.dbInfo.statusText);
            if (this.dbInfo.canInstall) {
                this.installButton.setText("Install");
                this.installButton.setEnabled(true);
            } else if (this.dbInfo.canUninstall) {
                this.installButton.setText("Uninstall");
                this.installButton.setEnabled(true);
            } else {
                this.installButton.setEnabled(false);
            }
            if (this.dbInfo.cacheSize > 0L) {
                if ((double)this.dbInfo.cacheSize >= 1.0E9) {
                    this.cacheLabel.setText(String.format(Locale.US, "%.2f GB", (double)this.dbInfo.cacheSize / 1.0E9));
                } else if ((double)this.dbInfo.cacheSize >= 1000000.0) {
                    this.cacheLabel.setText(String.format(Locale.US, "%.1f MB", (double)this.dbInfo.cacheSize / 1000000.0));
                } else {
                    this.cacheLabel.setText(String.format(Locale.US, "%.0f kB", (double)this.dbInfo.cacheSize / 1000.0));
                }
                this.clearCacheButton.setEnabled(true);
            } else {
                this.cacheLabel.setText("Empty");
                this.clearCacheButton.setEnabled(false);
            }
            this.unlockAllButton.setEnabled(this.dbInfo.canUnlock);
            this.updateButton.setEnabled(this.dbInfo.canUpdate);
            if (AppController.ShowUtilityUI) {
                this.reloadButton.setEnabled(this.dbInfo.canOpen);
            }
            this.openButton.setEnabled(this.dbInfo.canOpen);
            if (null != this.dbInfo.lookupErrorMessage) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AppController.showMessage((Component)dbSetupDialogs.get(originalDbID), ((SetupDialog)this).dbInfo.lookupErrorMessage, SetupDialog.WINDOW_TITLE, 3);
                        ((SetupDialog)this).dbInfo.lookupErrorMessage = null;
                    }
                });
            }
        }

        private void doInstall() {
            if (!this.dbInfo.canInstall) {
                return;
            }
            String string = "Install Database";
            this.errorReporter.setTitle(string);
            BackgroundWorker<Object> backgroundWorker = new BackgroundWorker<Object>((Window)this, string){

                @Override
                protected Object doBackgroundWork(ErrorLogger errorLogger) {
                    DbCore.installDb((DbCore.DbInfo)dbInfo, (StatusLogger)this, (ErrorLogger)errorLogger);
                    return null;
                }
            };
            backgroundWorker.runWork("Installing database, please wait...", this.errorReporter);
            this.updateControls();
        }

        private void doUninstall() {
            if (!this.dbInfo.canUninstall) {
                return;
            }
            String string = "Uninstall Database";
            this.errorReporter.setTitle(string);
            AppController.beep();
            if (0 != JOptionPane.showConfirmDialog(this, "This will delete the '" + this.dbInfo.dbName + "' database from the server, all studies\nand other saved data in that database will be lost.  If other applications\nare still using the database, those applications will fail.\n\nDo you want to continue?", string, 0, 2)) {
                return;
            }
            BackgroundWorker<Object> backgroundWorker = new BackgroundWorker<Object>((Window)this, string){

                @Override
                protected Object doBackgroundWork(ErrorLogger errorLogger) {
                    DbCore.uninstallDb((DbCore.DbInfo)dbInfo, (ErrorLogger)errorLogger);
                    dbInfo.updateCacheSize();
                    return null;
                }
            };
            backgroundWorker.runWork("Uninstalling database, please wait...", this.errorReporter);
            this.updateControls();
        }

        private void doClearCache() {
            if (this.dbInfo.cacheSize <= 0L) {
                return;
            }
            String string = "Clear Cache";
            this.errorReporter.setTitle(string);
            BackgroundWorker<Object> backgroundWorker = new BackgroundWorker<Object>((Window)this, string){

                @Override
                protected String doBackgroundWork(ErrorLogger errorLogger) {
                    AppCore.deleteStudyCache((String)((SetupDialog)this).dbInfo.dbID, (int)0);
                    dbInfo.updateCacheSize();
                    return null;
                }
            };
            backgroundWorker.runWork("Deleting cache files, please wait...", this.errorReporter);
            this.updateControls();
        }

        private void doUnlockAll() {
            if (!this.dbInfo.canUnlock) {
                return;
            }
            String string = "Unlock All Studies";
            this.errorReporter.setTitle(string);
            AppController.beep();
            if (0 != JOptionPane.showConfirmDialog(this, "This will clear locks on all studies.  Do this only if studies were\nnot closed properly due to application crashes or network failures;\nif this is done when other applications are still using any studies,\nthose applications will fail and data could become corrupted.\n\nDo you want to continue?", string, 0, 2)) {
                return;
            }
            DbConnection dbConnection = this.dbInfo.db;
            if (dbConnection.connect(this.dbInfo.dbName, (ErrorLogger)this.errorReporter)) {
                try {
                    dbConnection.update("UPDATE study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0");
                    this.dbInfo.update();
                    dbConnection.close();
                }
                catch (SQLException sQLException) {
                    dbConnection.close();
                    DbConnection.reportError((ErrorLogger)this.errorReporter, (SQLException)sQLException);
                }
            }
            this.updateControls();
        }

        private void doUpdate() {
            if (!this.dbInfo.canUpdate) {
                return;
            }
            String string = "Update Database";
            this.errorReporter.setTitle(string);
            BackgroundWorker<Object> backgroundWorker = new BackgroundWorker<Object>((Window)this, string){

                @Override
                protected Object doBackgroundWork(ErrorLogger errorLogger) {
                    DbCore.updateDb((DbCore.DbInfo)dbInfo, (StatusLogger)this, (ErrorLogger)errorLogger);
                    return null;
                }
            };
            backgroundWorker.runWork("Updating database, please wait...", this.errorReporter);
            this.updateControls();
        }

        private void doReload() {
            if (!AppController.ShowUtilityUI || !this.dbInfo.canOpen) {
                return;
            }
            String string = "Reload Root Data";
            this.errorReporter.setTitle(string);
            BackgroundWorker<Object> backgroundWorker = new BackgroundWorker<Object>((Window)this, string){

                @Override
                protected Object doBackgroundWork(ErrorLogger errorLogger) {
                    DbCore.updateRootData((DbCore.DbInfo)dbInfo, (ErrorLogger)errorLogger);
                    return null;
                }
            };
            backgroundWorker.runWork("Reloading root data, please wait...", this.errorReporter);
            this.updateControls();
        }

        private void doOpen() {
            if (!this.dbInfo.canOpen) {
                return;
            }
            String string = "Open Database";
            this.errorReporter.setTitle(string);
            BackgroundWorker<Boolean> backgroundWorker = new BackgroundWorker<Boolean>((Window)this, string){

                @Override
                protected Boolean doBackgroundWork(ErrorLogger errorLogger) {
                    return DbCore.registerDb((DbCore.DbInfo)dbInfo, (StatusLogger)this, (ErrorLogger)errorLogger);
                }
            };
            Boolean bl = (Boolean)backgroundWorker.runWork("Opening database, please wait...", this.errorReporter);
            if (null == bl || !bl.booleanValue()) {
                return;
            }
            dbSetupDialogs.remove(this.originalDbID);
            AppController.hideWindow(this);
            if (DbController.showManager(this.dbInfo.dbID)) {
                if (loginDialog.isVisible()) {
                    AppController.hideWindow(loginDialog);
                }
                DbController.checkSocketFileStatus(this.dbInfo);
            }
        }

        private void doCancel() {
            dbSetupDialogs.remove(this.originalDbID);
            this.blockActionsSet();
            AppController.hideWindow(this);
        }

        @Override
        public void windowWillOpen() {
            this.blockActionsClear();
        }

        @Override
        public boolean windowShouldClose() {
            if (!this.isVisible()) {
                return true;
            }
            dbSetupDialogs.remove(this.originalDbID);
            return true;
        }

        @Override
        public void windowWillClose() {
            this.blockActionsSet();
        }
    }

    private static class LoginDialog
    extends AppDialog {
        private static final String WINDOW_TITLE = "Open Database";
        private JTextField hostField;
        private JTextField nameField;
        private JTextField userField;
        private JPasswordField passField;
        private JButton quitButton;

        private LoginDialog() {
            super(null, null, WINDOW_TITLE, Dialog.ModalityType.MODELESS);
            this.setDisposeOnClose(false);
            this.hostField = new JTextField(10);
            AppController.fixKeyBindings(this.hostField);
            this.nameField = new JTextField(10);
            AppController.fixKeyBindings(this.nameField);
            this.userField = new JTextField(10);
            AppController.fixKeyBindings(this.userField);
            this.passField = new JPasswordField(10);
            AppController.fixKeyBindings(this.passField);
            JButton jButton = new JButton("Open");
            jButton.setFocusable(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doOpenDb(false);
                }
            });
            JButton jButton2 = new JButton("Setup");
            jButton2.setFocusable(false);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doOpenDb(true);
                }
            });
            this.quitButton = new JButton("Quit");
            this.quitButton.setFocusable(false);
            this.quitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppController.closeWindows()) {
                        System.exit(0);
                    }
                }
            });
            JLabel jLabel = new JLabel("Host");
            JLabel jLabel2 = new JLabel("Database");
            JLabel jLabel3 = new JLabel("User");
            JLabel jLabel4 = new JLabel("Password");
            JPanel jPanel = new JPanel();
            GroupLayout groupLayout = new GroupLayout(jPanel);
            groupLayout.setAutoCreateGaps(true);
            groupLayout.setAutoCreateContainerGaps(true);
            jPanel.setLayout(groupLayout);
            if (showDbName) {
                groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel).addComponent(jLabel2).addComponent(jLabel3).addComponent(jLabel4)).addGroup(groupLayout.createParallelGroup().addComponent(this.hostField).addComponent(this.nameField).addComponent(this.userField).addComponent(this.passField)));
                groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.hostField)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.nameField)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.userField)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.passField)));
            } else {
                groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel).addComponent(jLabel3).addComponent(jLabel4)).addGroup(groupLayout.createParallelGroup().addComponent(this.hostField).addComponent(this.userField).addComponent(this.passField)));
                groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.hostField)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.userField)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.passField)));
            }
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.add(jButton2);
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            jPanel3.add(this.quitButton);
            jPanel3.add(jButton);
            JPanel jPanel4 = new JPanel();
            jPanel4.add(jPanel2);
            jPanel4.add(jPanel3);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)jPanel, "Center");
            container.add((Component)jPanel4, "South");
            this.getRootPane().setDefaultButton(jButton);
            this.pack();
            this.setMinimumSize(this.getSize());
            this.setResizable(true);
            this.setLocationSaved(true);
        }

        @Override
        public String getDbID() {
            return null;
        }

        @Override
        public RootEditor getRootEditor() {
            return null;
        }

        private void doOpenDb(boolean bl) {
            Object object;
            final String string = new String(this.passField.getPassword());
            this.passField.setText("");
            final String string2 = this.hostField.getText().trim().toLowerCase();
            if (0 == string2.length()) {
                this.errorReporter.reportWarning("Please provide a database host name");
                this.hostField.requestFocusInWindow();
                return;
            }
            String string3 = this.nameField.getText().trim().toLowerCase();
            if (null == string3 || 0 == string3.length()) {
                string3 = "tvstudy";
            } else {
                for (int i = 0; i < string3.length(); ++i) {
                    if (Character.isLetterOrDigit(string3.charAt(i))) continue;
                    if (showDbName) {
                        this.errorReporter.reportWarning("Invalid database name, only letters and numbers allowed");
                        this.nameField.requestFocusInWindow();
                        return;
                    }
                    string3 = "tvstudy";
                }
            }
            final String string4 = string3;
            final String string5 = this.userField.getText().trim();
            if (0 == string5.length() && !bl) {
                this.errorReporter.reportWarning("Please provide a user name");
                this.userField.requestFocusInWindow();
                return;
            }
            if (0 == string.length() && !bl) {
                this.errorReporter.reportWarning("Please provide the password\nBlank passwords are not allowed");
                this.passField.requestFocusInWindow();
                return;
            }
            this.errorReporter.clearErrors();
            final boolean bl2 = bl;
            final DbCore.DbInfo dbInfo = (DbCore.DbInfo)new BackgroundWorker<DbCore.DbInfo>((Window)this, WINDOW_TITLE){

                @Override
                protected DbCore.DbInfo doBackgroundWork(ErrorLogger errorLogger) {
                    DbCore.DbInfo dbInfo = new DbCore.DbInfo(string2, string4, string5, string, errorLogger);
                    if (bl2 || dbInfo.needsSetup) {
                        dbInfo.updateCacheSize();
                    }
                    return dbInfo;
                }
            }.runWork("Connecting to database, please wait...", this.errorReporter);
            if (null == dbInfo || dbInfo.connectionFailed) {
                if (!this.errorReporter.hasErrors()) {
                    object = null == dbInfo ? "Cannot connect to the database, unknown error" : dbInfo.setupError;
                    this.errorReporter.reportError((String)object);
                }
                if (null == dbInfo || !bl) {
                    return;
                }
            }
            if (null == (object = (SetupDialog)dbSetupDialogs.get(dbInfo.dbID))) {
                object = (SetupDialog)dbSetupDialogs.get(dbInfo.dbHostname);
            }
            if (null != object) {
                ((Window)object).toFront();
                return;
            }
            if (DbCore.isDbRegistered((String)dbInfo.dbID)) {
                if (bl) {
                    this.errorReporter.reportWarning("That database is currently in use, please try again later");
                    return;
                }
                if (DbController.showManager(dbInfo.dbID)) {
                    AppController.hideWindow(this);
                }
                return;
            }
            if (bl || dbInfo.needsSetup) {
                object = new SetupDialog(dbInfo);
                dbSetupDialogs.put(dbInfo.dbID, object);
                AppController.showWindow((Window)object);
                return;
            }
            Boolean bl3 = (Boolean)new BackgroundWorker<Boolean>((Window)this, this.getTitle()){

                @Override
                protected Boolean doBackgroundWork(ErrorLogger errorLogger) {
                    return DbCore.registerDb((DbCore.DbInfo)dbInfo, (StatusLogger)this, (ErrorLogger)errorLogger);
                }
            }.runWork("Opening database, please wait...", this.errorReporter);
            if (null != bl3 && bl3.booleanValue()) {
                if (DbController.showManager(dbInfo.dbID)) {
                    AppController.hideWindow(this);
                    DbController.checkSocketFileStatus(dbInfo);
                }
                return;
            }
            this.passField.requestFocusInWindow();
        }

        @Override
        public void windowWillOpen() {
            String string = AppCore.getProperty((String)"host");
            if (null == string) {
                string = "";
            }
            this.hostField.setText(string);
            String string2 = AppCore.getProperty((String)"name");
            if (null == string2 || 0 == string2.length()) {
                string2 = "tvstudy";
            }
            this.nameField.setText(string2);
            String string3 = AppCore.getProperty((String)"user");
            if (null == string3) {
                string3 = "";
            }
            this.userField.setText(string3);
            this.passField.setText("");
            if (0 == string.length()) {
                this.hostField.requestFocusInWindow();
            } else if (0 == string3.length()) {
                this.userField.requestFocusInWindow();
            } else {
                this.passField.requestFocusInWindow();
            }
            this.blockActionsClear();
        }

        @Override
        public boolean windowShouldClose() {
            if (!this.isVisible()) {
                return true;
            }
            if (AppController.hasOpenWindows()) {
                return true;
            }
            for (Window window : Window.getWindows()) {
                if (window == this || !window.isVisible()) continue;
                AppController.beep();
                window.toFront();
                return false;
            }
            return true;
        }

        @Override
        public void windowWillClose() {
            this.blockActionsSet();
        }
    }
}

