/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class CalendarDialog
extends AppDialog {
    private static final int YEAR_MENU_RANGE = 4;
    private Calendar currentCalendar;
    private boolean allowNullDate = true;
    private boolean allowFutureDate;
    private int lockoutYear;
    private int lockoutMonth;
    private int lockoutDay;
    private Date lastDateSet;
    private Calendar displayCalendar;
    private JComboBox<String> monthMenu;
    private JComboBox<String> yearMenu;
    private int yearMenuBaseYear;
    private ArrayList<JToggleButton> buttons;
    private JButton todayButton;
    private JButton clearButton;
    public boolean canceled;
    private CalendarDialog outerThis = this;

    public CalendarDialog(AppEditor appEditor) {
        super(appEditor, "Select Date", Dialog.ModalityType.APPLICATION_MODAL);
        this.displayCalendar = Calendar.getInstance();
        this.displayCalendar.set(5, 1);
        this.displayCalendar.set(11, 0);
        this.displayCalendar.set(12, 0);
        this.displayCalendar.set(13, 0);
        this.displayCalendar.set(14, 0);
        String[] stringArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        this.monthMenu = new JComboBox<String>(stringArray);
        this.monthMenu.setFocusable(false);
        this.monthMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CalendarDialog.this.blockActions()) {
                    CalendarDialog.this.displayCalendar.set(2, CalendarDialog.this.monthMenu.getSelectedIndex() + 0);
                    CalendarDialog.this.updateDisplay();
                    CalendarDialog.this.blockActionsEnd();
                }
            }
        });
        this.monthMenu.setMaximumRowCount(12);
        this.yearMenu = new JComboBox();
        this.yearMenu.setFocusable(false);
        this.yearMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CalendarDialog.this.blockActions()) {
                    CalendarDialog.this.displayCalendar.set(1, CalendarDialog.this.yearMenu.getSelectedIndex() + CalendarDialog.this.yearMenuBaseYear);
                    CalendarDialog.this.updateDisplay();
                    CalendarDialog.this.blockActionsEnd();
                }
            }
        });
        this.yearMenu.setMaximumRowCount(9);
        this.yearMenuBaseYear = this.displayCalendar.get(1) - 4;
        JPanel jPanel = new JPanel();
        jPanel.add(this.monthMenu);
        jPanel.add(this.yearMenu);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 7, 0, 0));
        jPanel2.add(new JLabel("Sun", 0));
        jPanel2.add(new JLabel("Mon", 0));
        jPanel2.add(new JLabel("Tue", 0));
        jPanel2.add(new JLabel("Wed", 0));
        jPanel2.add(new JLabel("Thu", 0));
        jPanel2.add(new JLabel("Fri", 0));
        jPanel2.add(new JLabel("Sat", 0));
        this.buttons = new ArrayList();
        Dimension dimension = new Dimension(35, 35);
        Insets insets = new Insets(0, 0, 0, 0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(6, 7, 0, 0));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                if (CalendarDialog.this.buttons.contains(jToggleButton)) {
                    for (JToggleButton jToggleButton2 : CalendarDialog.this.buttons) {
                        if (jToggleButton2.equals(jToggleButton)) continue;
                        jToggleButton2.setSelected(false);
                    }
                    if (jToggleButton.isSelected()) {
                        int n = CalendarDialog.this.buttons.indexOf(jToggleButton) - (CalendarDialog.this.displayCalendar.get(7) - 1) + 1;
                        CalendarDialog.this.currentCalendar = Calendar.getInstance();
                        CalendarDialog.this.currentCalendar.setTime(CalendarDialog.this.displayCalendar.getTime());
                        CalendarDialog.this.currentCalendar.set(5, n);
                    } else {
                        jToggleButton.setSelected(true);
                    }
                    AppController.hideWindow(CalendarDialog.this.outerThis);
                }
            }
        };
        for (int i = 0; i < 42; ++i) {
            JToggleButton jToggleButton = new JToggleButton(" ");
            jToggleButton.setFocusable(false);
            jToggleButton.setMargin(insets);
            jToggleButton.setPreferredSize(dimension);
            jToggleButton.setMinimumSize(dimension);
            jToggleButton.setMaximumSize(dimension);
            this.buttons.add(jToggleButton);
            jPanel3.add(jToggleButton);
            jToggleButton.addActionListener(actionListener);
        }
        this.todayButton = new JButton("Today");
        this.todayButton.setFocusable(false);
        this.todayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarDialog.this.doSetDate(new Date());
                AppController.hideWindow(CalendarDialog.this.outerThis);
            }
        });
        this.clearButton = new JButton("Clear");
        this.clearButton.setFocusable(false);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarDialog.this.doSetDate(null);
                AppController.hideWindow(CalendarDialog.this.outerThis);
            }
        });
        JButton jButton = new JButton("Cancel");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarDialog.this.doSetDate(CalendarDialog.this.lastDateSet);
                CalendarDialog.this.canceled = true;
                AppController.hideWindow(CalendarDialog.this.outerThis);
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.todayButton);
        jPanel4.add(this.clearButton);
        jPanel4.add(jButton);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 3));
        container.add(jPanel);
        container.add(jPanel2);
        container.add(jPanel3);
        container.add(jPanel4);
        this.pack();
        this.updateDisplay();
    }

    public void setNullAllowed(boolean bl) {
        this.allowNullDate = bl;
        this.clearButton.setVisible(bl);
        if (!this.allowNullDate && null == this.currentCalendar) {
            this.doSetDate(new Date());
        }
    }

    public void setFutureAllowed(boolean bl) {
        this.allowFutureDate = bl;
        this.updateDisplay();
    }

    public void setLockoutDate(Date date) {
        if (null == date) {
            this.todayButton.setEnabled(true);
            this.lockoutYear = 0;
            this.lockoutMonth = 0;
            this.lockoutDay = 0;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            this.todayButton.setEnabled(date.before(calendar.getTime()));
            calendar.setTime(date);
            this.lockoutYear = calendar.get(1);
            this.lockoutMonth = calendar.get(2);
            this.lockoutDay = calendar.get(5);
        }
        this.updateDisplay();
    }

    public void setDate(Date date) {
        this.lastDateSet = date;
        this.doSetDate(date);
    }

    public void setAllState(boolean bl, boolean bl2, Date date, Date date2) {
        this.allowNullDate = bl;
        this.clearButton.setVisible(bl);
        this.allowFutureDate = bl2;
        if (null == date) {
            this.todayButton.setEnabled(true);
            this.lockoutYear = 0;
            this.lockoutMonth = 0;
            this.lockoutDay = 0;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            this.todayButton.setEnabled(date.before(calendar.getTime()));
            calendar.setTime(date);
            this.lockoutYear = calendar.get(1);
            this.lockoutMonth = calendar.get(2);
            this.lockoutDay = calendar.get(5);
        }
        this.lastDateSet = date2;
        this.doSetDate(date2);
    }

    private void doSetDate(Date date) {
        int n;
        if (!this.allowNullDate && null == date) {
            date = new Date();
        }
        if (null == date) {
            this.displayCalendar.setTime(new Date());
            n = 0;
        } else {
            this.displayCalendar.setTime(date);
            n = this.displayCalendar.get(5);
        }
        this.displayCalendar.set(5, 1);
        this.displayCalendar.set(11, 0);
        this.displayCalendar.set(12, 0);
        this.displayCalendar.set(13, 0);
        this.displayCalendar.set(14, 0);
        if (n > 0) {
            this.currentCalendar = Calendar.getInstance();
            this.currentCalendar.setTime(this.displayCalendar.getTime());
            this.currentCalendar.set(5, n);
        } else {
            this.currentCalendar = null;
        }
        this.updateDisplay();
    }

    public Date getDate() {
        if (null != this.currentCalendar) {
            return this.currentCalendar.getTime();
        }
        return null;
    }

    @Override
    public void windowWillOpen() {
        this.canceled = false;
        this.blockActionsClear();
    }

    @Override
    public boolean windowShouldClose() {
        this.doSetDate(this.lastDateSet);
        this.canceled = true;
        return true;
    }

    @Override
    public void windowWillClose() {
        this.blockActionsSet();
    }

    private void updateDisplay() {
        int n;
        int n2;
        int n3;
        int n4 = this.displayCalendar.get(1);
        int n5 = this.displayCalendar.get(2);
        int n6 = 0;
        if (n4 < this.lockoutYear || n4 == this.lockoutYear && n5 < this.lockoutMonth) {
            n6 = 999;
        } else if (n4 == this.lockoutYear && n5 == this.lockoutMonth) {
            n6 = this.lockoutDay;
        }
        int n7 = 999;
        if (!this.allowFutureDate) {
            Calendar calendar = Calendar.getInstance();
            n3 = calendar.get(1);
            n2 = calendar.get(2);
            if (n4 > n3 || n4 == n3 && n5 > n2) {
                n7 = 0;
            } else if (n4 == n3 && n5 == n2) {
                n7 = calendar.get(5);
            }
        }
        this.blockActionsStart();
        this.monthMenu.setSelectedIndex(n5);
        this.yearMenuBaseYear = n4 - 4;
        this.yearMenu.removeAllItems();
        for (n = 0; n < 9; ++n) {
            this.yearMenu.addItem(String.valueOf(this.yearMenuBaseYear + n));
        }
        this.yearMenu.setSelectedIndex(4);
        this.blockActionsEnd();
        n = 0;
        if (null != this.currentCalendar && this.currentCalendar.get(1) == n4 && this.currentCalendar.get(2) == n5) {
            n = this.currentCalendar.get(5);
        }
        n3 = this.displayCalendar.getActualMaximum(5);
        n2 = 1 - (this.displayCalendar.get(7) - 1);
        for (JToggleButton jToggleButton : this.buttons) {
            if (n2 < 1 || n2 > n3) {
                jToggleButton.setText(" ");
                jToggleButton.setSelected(false);
                jToggleButton.setEnabled(false);
            } else {
                jToggleButton.setText(String.valueOf(n2));
                jToggleButton.setSelected(n2 == n);
                jToggleButton.setEnabled(n2 > n6 && n2 <= n7);
            }
            ++n2;
        }
        this.repaint();
    }
}

