/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.ErrorReporter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public abstract class BackgroundWorker<ReturnType>
extends SwingWorker<ReturnType, String>
implements StatusLogger {
    private static final int DIALOG_DELAY_TIME = 500;
    private static final int DIALOG_DISPLAY_TIME = 2000;
    private Window parent;
    private String title;
    private ErrorLogger workerErrors;
    private JDialog statusDialog;
    private JLabel statusLabel;
    private boolean canCloseDialog;
    private JButton cancelButton;
    private boolean showCancel;
    private boolean canceled;

    public BackgroundWorker(Window window, String string) {
        this.parent = window;
        this.title = string;
        this.workerErrors = new ErrorLogger(new StringBuilder());
    }

    public ReturnType runWork(String string, ErrorReporter errorReporter) {
        this.execute();
        ReturnType ReturnType = null;
        boolean bl = false;
        try {
            ReturnType = (ReturnType)this.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            bl = true;
        }
        catch (Throwable throwable) {
            AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
            this.workerErrors.reportError("An unexpected error occurred:\n" + throwable, 3);
        }
        if (bl) {
            this.statusDialog = new JDialog(this.parent, this.title, Dialog.ModalityType.APPLICATION_MODAL);
            this.statusDialog.setResizable(false);
            this.statusDialog.setDefaultCloseOperation(0);
            this.statusLabel = new JLabel(string);
            this.statusLabel.setPreferredSize(AppController.labelSize[40]);
            Box box = Box.createVerticalBox();
            box.add(Box.createVerticalStrut(20));
            box.add(this.statusLabel);
            box.add(Box.createVerticalStrut(20));
            Box box2 = Box.createHorizontalBox();
            box2.add(Box.createHorizontalStrut(20));
            box2.add(box);
            box2.add(Box.createHorizontalStrut(20));
            Container container = this.statusDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)box2, "Center");
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setFocusable(false);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (BackgroundWorker.this.showCancel && !BackgroundWorker.this.canceled) {
                        BackgroundWorker.this.canceled = true;
                        BackgroundWorker.this.cancelButton.setEnabled(false);
                        BackgroundWorker.this.cancelWork();
                    }
                }
            });
            this.cancelButton.setVisible(this.showCancel);
            JPanel jPanel = new JPanel(new FlowLayout(2));
            jPanel.add(this.cancelButton);
            container.add((Component)jPanel, "South");
            this.statusDialog.pack();
            this.statusDialog.setLocationRelativeTo(this.parent);
            Timer timer = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (BackgroundWorker.this.canCloseDialog) {
                        BackgroundWorker.this.statusDialog.setVisible(false);
                    } else {
                        BackgroundWorker.this.canCloseDialog = true;
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
            this.statusDialog.setVisible(true);
            try {
                ReturnType = (ReturnType)this.get();
            }
            catch (Throwable throwable) {
                AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
                this.workerErrors.reportError("An unexpected error occurred:\n" + throwable, 3);
            }
        }
        if (this.workerErrors.hasErrors()) {
            errorReporter.reportError(this.workerErrors.toString(), this.workerErrors.getLastErrorType());
        }
        if (this.workerErrors.hasMessages()) {
            errorReporter.logMessage(this.workerErrors.getMessages());
        }
        return ReturnType;
    }

    @Override
    protected ReturnType doInBackground() throws Exception {
        return this.doBackgroundWork(this.workerErrors);
    }

    protected abstract ReturnType doBackgroundWork(ErrorLogger var1);

    public synchronized void showCancel() {
        this.showCancel = true;
        if (null == this.cancelButton) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BackgroundWorker.this.cancelButton.setVisible(true);
            }
        });
    }

    public synchronized void hideCancel() {
        this.showCancel = false;
        if (null == this.cancelButton) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BackgroundWorker.this.cancelButton.setVisible(false);
            }
        });
    }

    public void cancelWork() {
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setWaitMessage(String string) {
        this.publish(string);
    }

    public void reportStatus(String string) {
        this.publish(string);
    }

    public void logMessage(String string) {
    }

    public void showMessage(String string) {
    }

    @Override
    protected void process(List<String> list) {
        if (null != this.statusLabel) {
            this.statusLabel.setText(list.get(list.size() - 1));
        }
    }

    @Override
    protected void done() {
        if (this.canCloseDialog) {
            this.statusDialog.setVisible(false);
        } else {
            this.canCloseDialog = true;
            if (null != this.cancelButton) {
                this.cancelButton.setEnabled(false);
            }
        }
    }
}

