/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.api;

import gov.fcc.tvstudy.api.APIOperation;
import gov.fcc.tvstudy.api.SearchAPI;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.FrequencyOffset;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.Zone;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import java.util.HashMap;

public class RecordAPI
extends APIOperation {
    public static final String OP_START = "record";
    public static final String OP_SAVE = "recordsave";
    public static final String KEY_FACILITY_ID = "facility_id";
    public static final String KEY_SERVICE = "service";
    public static final String KEY_STATUS = "status";
    public static final String KEY_CALL_SIGN = "call_sign";
    public static final String KEY_CHANNEL = "channel";
    public static final String KEY_CITY = "city";
    public static final String KEY_STATE = "state";
    public static final String KEY_COUNTRY = "country";
    public static final String KEY_ZONE = "zone";
    public static final String KEY_FREQUENCY_OFFSET = "frequency_offset";
    public static final String KEY_EMISSION_MASK = "emission_mask";
    public static final String KEY_LATITUDE_DIRECTION = "latitude_direction";
    public static final String KEY_LATITUDE_DEGREES = "latitude_degrees";
    public static final String KEY_LATITUDE_MINUTES = "latitude_minutes";
    public static final String KEY_LATITUDE_SECONDS = "latitude_seconds";
    public static final String KEY_LONGITUDE_DIRECTION = "longitude_direction";
    public static final String KEY_LONGITUDE_DEGREES = "longitude_degrees";
    public static final String KEY_LONGITUDE_MINUTES = "longitude_minutes";
    public static final String KEY_LONGITUDE_SECONDS = "longitude_seconds";
    public static final String KEY_HEIGHT_AMSL = "height_amsl";
    public static final String KEY_HEIGHT_AAT = "height_aat";
    public static final String KEY_PEAK_ERP = "peak_erp";
    public static final String KEY_COMMENT = "comment";
    private ErrorLogger errors = new ErrorLogger();

    public static boolean canHandleOperation(String string) {
        return OP_START.equals(string) || OP_SAVE.equals(string);
    }

    public RecordAPI(String string, HashMap<String, String> hashMap, String string2) {
        super(string, hashMap, string2);
        this.dispatchOperation(string);
    }

    @Override
    protected void dispatchOperation(String string) {
        if (OP_START.equals(string)) {
            this.doOpStart();
            return;
        }
        if (OP_SAVE.equals(string)) {
            this.doOpSave();
            return;
        }
        super.dispatchOperation(string);
    }

    private void doOpStart() {
        if (null == this.nextOp) {
            this.nextOp = "searchshow";
        }
        SourceEditDataTV sourceEditDataTV = null;
        SearchAPI.SearchResult searchResult = SearchAPI.getSearchResult(this.parameters);
        if (null != searchResult.source) {
            sourceEditDataTV = searchResult.source;
        } else if (null != searchResult.record) {
            sourceEditDataTV = SourceEditDataTV.makeSourceTV((ExtDbRecordTV)searchResult.record, null, (boolean)true);
        }
        if (null != sourceEditDataTV && sourceEditDataTV.service.isDTS) {
            sourceEditDataTV = null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        RecordAPI.addPageHeader(stringBuilder, "TVStudy - Create User Record", 0, this.errorMessage);
        if (null != this.backOp) {
            RecordAPI.addFormStart(stringBuilder, OP_SAVE, this.backOp, this.backOpLabel, this.nextOp, true);
        } else {
            RecordAPI.addFormStart(stringBuilder, OP_SAVE, OP_START, "Create Another Record", this.nextOp, true);
        }
        stringBuilder.append("<table>\n");
        String string = (String)this.parameters.get(KEY_FACILITY_ID);
        if (null == string && null != sourceEditDataTV) {
            string = String.valueOf(sourceEditDataTV.facilityID);
        }
        stringBuilder.append("<tr><td>Facility ID</td>\n");
        if (null != string) {
            stringBuilder.append("<td><input type=\"text\" name=\"facility_id\" value=\"" + string + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"facility_id\"></td>\n");
        }
        string = (String)this.parameters.get(KEY_SERVICE);
        if (null == string && null != sourceEditDataTV) {
            string = sourceEditDataTV.service.serviceCode;
        }
        stringBuilder.append("<tr><td>Service</td>");
        stringBuilder.append("<td><select name=\"service\">\n");
        for (Service service : Service.getAllServices()) {
            if (service.isDTS) continue;
            if (service.serviceCode.equals(string)) {
                stringBuilder.append("<option value=\"" + service.serviceCode + "\" selected>" + service.name + "</option>\n");
                continue;
            }
            stringBuilder.append("<option value=\"" + service.serviceCode + "\">" + service.name + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        string = (String)this.parameters.get(KEY_CALL_SIGN);
        if (null == string && null != sourceEditDataTV) {
            string = sourceEditDataTV.callSign;
        }
        stringBuilder.append("<tr><td>Call sign</td>\n");
        if (null != string) {
            stringBuilder.append("<td><input type=\"text\" name=\"call_sign\" value=\"" + string + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"call_sign\"></td>\n");
        }
        string = (String)this.parameters.get(KEY_CHANNEL);
        if (null == string && null != sourceEditDataTV) {
            string = String.valueOf(sourceEditDataTV.channel);
        }
        stringBuilder.append("<tr><td>Channel</td>\n");
        if (null != string) {
            stringBuilder.append("<td><input type=\"text\" name=\"channel\" value=\"" + string + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"channel\"></td>\n");
        }
        string = (String)this.parameters.get(KEY_STATUS);
        if (null == string && null != sourceEditDataTV) {
            string = sourceEditDataTV.status;
        }
        stringBuilder.append("<tr><td>Status</td>\n");
        stringBuilder.append("<td><select name=\"status\">\n");
        for (Service service : ExtDbRecord.getStatusList()) {
            if (service.name.equals(string)) {
                stringBuilder.append("<option value=\"" + service.name + "\" selected>" + service.name + "</option>\n");
                string = null;
                continue;
            }
            stringBuilder.append("<option value=\"" + service.name + "\">" + service.name + "</option>\n");
        }
        if (null != string) {
            stringBuilder.append("<option value=\"" + string + "\" selected>" + string + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        string = (String)this.parameters.get(KEY_CITY);
        if (null == string && null != sourceEditDataTV) {
            string = sourceEditDataTV.city;
        }
        stringBuilder.append("<tr><td>City</td>\n");
        if (null != string) {
            stringBuilder.append("<td><input type=\"text\" name=\"city\" value=\"" + string + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"city\"></td>\n");
        }
        string = (String)this.parameters.get(KEY_STATE);
        if (null == string && null != sourceEditDataTV) {
            string = sourceEditDataTV.state;
        }
        stringBuilder.append("<tr><td>State</td>\n");
        if (null != string) {
            stringBuilder.append("<td><input type=\"text\" name=\"state\" value=\"" + string + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"state\"></td>\n");
        }
        string = (String)this.parameters.get(KEY_COUNTRY);
        if (null == string && null != sourceEditDataTV) {
            string = sourceEditDataTV.country.countryCode;
        }
        stringBuilder.append("<tr><td>Country</td>");
        stringBuilder.append("<td><select name=\"country\">\n");
        for (Service service : Country.getAllCountries()) {
            if (service.countryCode.equals(string)) {
                stringBuilder.append("<option value=\"" + service.countryCode + "\" selected>" + service.name + "</option>\n");
                continue;
            }
            stringBuilder.append("<option value=\"" + service.countryCode + "\">" + service.name + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        string = (String)this.parameters.get(KEY_ZONE);
        if (null == string && null != sourceEditDataTV) {
            string = sourceEditDataTV.zone.zoneCode;
        }
        stringBuilder.append("<tr><td>Zone</td>");
        stringBuilder.append("<td><select name=\"zone\">\n");
        stringBuilder.append("<option value=\"\">--</option>\n");
        for (Service service : Zone.getAllZones()) {
            if (service.zoneCode.equals(string)) {
                stringBuilder.append("<option value=\"" + service.zoneCode + "\" selected>" + service.name + "</option>\n");
                continue;
            }
            stringBuilder.append("<option value=\"" + service.zoneCode + "\">" + service.name + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        string = (String)this.parameters.get(KEY_FREQUENCY_OFFSET);
        if (null == string && null != sourceEditDataTV) {
            string = sourceEditDataTV.frequencyOffset.frequencyOffsetCode;
        }
        stringBuilder.append("<tr><td>Frequency offset</td>");
        stringBuilder.append("<td><select name=\"frequency_offset\">\n");
        stringBuilder.append("<option value=\"\">--</option>\n");
        for (Service service : FrequencyOffset.getAllFrequencyOffsets()) {
            if (service.frequencyOffsetCode.equals(string)) {
                stringBuilder.append("<option value=\"" + service.frequencyOffsetCode + "\" selected>" + service.name + "</option>\n");
                continue;
            }
            stringBuilder.append("<option value=\"" + service.frequencyOffsetCode + "\">" + service.name + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        string = (String)this.parameters.get(KEY_EMISSION_MASK);
        if (null == string && null != sourceEditDataTV) {
            string = sourceEditDataTV.emissionMask.emissionMaskCode;
        }
        stringBuilder.append("<tr><td>Emission mask</td>");
        stringBuilder.append("<td><select name=\"emission_mask\">\n");
        stringBuilder.append("<option value=\"\">--</option>\n");
        for (Service service : EmissionMask.getAllEmissionMasks()) {
            if (service.emissionMaskCode.equals(string)) {
                stringBuilder.append("<option value=\"" + service.emissionMaskCode + "\" selected>" + service.name + "</option>\n");
                continue;
            }
            stringBuilder.append("<option value=\"" + service.emissionMaskCode + "\">" + service.name + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        stringBuilder.append("<tr><td>Latitude</td>\n");
        string = (String)this.parameters.get(KEY_LATITUDE_DIRECTION);
        if (null == string && null != sourceEditDataTV) {
            string = 0 == sourceEditDataTV.location.latitudeNS ? "N" : "S";
        }
        stringBuilder.append("<td><select name=\"latitude_direction\">\n");
        if (null != string && string.equalsIgnoreCase("N")) {
            stringBuilder.append("<option value=\"N\" selected>N</option>\n");
        } else {
            stringBuilder.append("<option value=\"N\">N</option>\n");
        }
        if (null != string && string.equalsIgnoreCase("S")) {
            stringBuilder.append("<option value=\"S\" selected>S</option>\n");
        } else {
            stringBuilder.append("<option value=\"S\">S</option>\n");
        }
        string = (String)this.parameters.get(KEY_LATITUDE_DEGREES);
        if (null == string && null != sourceEditDataTV) {
            string = String.valueOf(sourceEditDataTV.location.latitudeDegrees);
        }
        if (null != string) {
            stringBuilder.append("<input type=\"text\" name=\"latitude_degrees\" value=\"" + string + "\" size=\"6\"> deg\n");
        } else {
            stringBuilder.append("<input type=\"text\" name=\"latitude_degrees\" size=\"6\"> deg\n");
        }
        string = (String)this.parameters.get(KEY_LATITUDE_MINUTES);
        if (null == string && null != sourceEditDataTV) {
            string = String.valueOf(sourceEditDataTV.location.latitudeMinutes);
        }
        if (null != string) {
            stringBuilder.append("<input type=\"text\" name=\"latitude_minutes\" value=\"" + string + "\" size=\"6\"> min\n");
        } else {
            stringBuilder.append("<input type=\"text\" name=\"latitude_minutes\" size=\"6\"> min\n");
        }
        string = (String)this.parameters.get(KEY_LATITUDE_SECONDS);
        if (null == string && null != sourceEditDataTV) {
            string = AppCore.formatSeconds((double)sourceEditDataTV.location.latitudeSeconds);
        }
        if (null != string) {
            stringBuilder.append("<input type=\"text\" name=\"latitude_seconds\" value=\"" + string + "\" size=\"6\"> sec</td>\n");
        } else {
            stringBuilder.append("<input type=\"text\" name=\"latitude_seconds\" size=\"6\"> sec</td>\n");
        }
        stringBuilder.append("<tr><td>Longitude</td>\n");
        string = (String)this.parameters.get(KEY_LONGITUDE_DIRECTION);
        if (null == string && null != sourceEditDataTV) {
            string = 0 == sourceEditDataTV.location.longitudeWE ? "W" : "E";
        }
        stringBuilder.append("<td><select name=\"longitude_direction\">\n");
        if (null != string && string.equalsIgnoreCase("W")) {
            stringBuilder.append("<option value=\"W\" selected>W</option>\n");
        } else {
            stringBuilder.append("<option value = \"W\">W</option>\n");
        }
        if (null != string && string.equalsIgnoreCase("E")) {
            stringBuilder.append("<option value=\"E\" selected>E</option>\n");
        } else {
            stringBuilder.append("<option value = \"E\">E</option>\n");
        }
        string = (String)this.parameters.get(KEY_LONGITUDE_DEGREES);
        if (null == string && null != sourceEditDataTV) {
            string = String.valueOf(sourceEditDataTV.location.longitudeDegrees);
        }
        if (null != string) {
            stringBuilder.append("<input type=\"text\" name=\"longitude_degrees\" value=\"" + string + "\" size=\"6\"> deg\n");
        } else {
            stringBuilder.append("<input type=\"text\" name=\"longitude_degrees\" size=\"6\"> deg\n");
        }
        string = (String)this.parameters.get(KEY_LONGITUDE_MINUTES);
        if (null == string && null != sourceEditDataTV) {
            string = String.valueOf(sourceEditDataTV.location.longitudeMinutes);
        }
        if (null != string) {
            stringBuilder.append("<input type=\"text\" name=\"longitude_minutes\" value=\"" + string + "\" size=\"6\"> min\n");
        } else {
            stringBuilder.append("<input type=\"text\" name=\"longitude_minutes\" size=\"6\"> min\n");
        }
        string = (String)this.parameters.get(KEY_LONGITUDE_SECONDS);
        if (null == string && null != sourceEditDataTV) {
            string = AppCore.formatSeconds((double)sourceEditDataTV.location.longitudeSeconds);
        }
        if (null != string) {
            stringBuilder.append("<input type=\"text\" name=\"longitude_seconds\" value=\"" + string + "\" size=\"6\"> sec</td>\n");
        } else {
            stringBuilder.append("<input type=\"text\" name=\"longitude_seconds\" size=\"6\"> sec</td>\n");
        }
        string = (String)this.parameters.get(KEY_HEIGHT_AMSL);
        if (null == string && null != sourceEditDataTV) {
            string = AppCore.formatHeight((double)sourceEditDataTV.heightAMSL);
        }
        stringBuilder.append("<tr><td>Height AMSL</td>\n");
        if (null != string) {
            stringBuilder.append("<td><input type=\"text\" name=\"height_amsl\" value=\"" + string + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"height_amsl\"></td>\n");
        }
        string = (String)this.parameters.get(KEY_HEIGHT_AAT);
        if (null == string && null != sourceEditDataTV) {
            string = AppCore.formatHeight((double)sourceEditDataTV.overallHAAT);
        }
        stringBuilder.append("<tr><td>HAAT</td>\n");
        if (null != string) {
            stringBuilder.append("<td><input type=\"text\" name=\"height_aat\" value=\"" + string + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"height_aat\"></td>\n");
        }
        string = (String)this.parameters.get(KEY_PEAK_ERP);
        if (null == string && null != sourceEditDataTV) {
            string = AppCore.formatERP((double)sourceEditDataTV.peakERP);
        }
        stringBuilder.append("<tr><td>Peak ERP</td>\n");
        if (null != string) {
            stringBuilder.append("<td><input type=\"text\" name=\"peak_erp\" value=\"" + string + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"peak_erp\"></td>\n");
        }
        stringBuilder.append("<tr><td>Comment</td>\n");
        stringBuilder.append("<td><textarea rows=\"5\" cols=\"40\" name=\"comment\"></textarea></td>\n");
        stringBuilder.append("</table>\n");
        RecordAPI.addFormEnd(stringBuilder, "Save Record");
        if (null != this.backOp) {
            RecordAPI.addFormStart(stringBuilder, this.backOp);
            SearchAPI.addHiddenFields(stringBuilder, this.parameters);
            RecordAPI.addFormEnd(stringBuilder, this.backOpLabel);
        }
        RecordAPI.addPageFooter(stringBuilder);
        this.resultPage = stringBuilder.toString();
        this.status = 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doOpSave() {
        if (null == this.nextOp) {
            this.nextOp = "searchshow";
        }
        int n = 0;
        String string = (String)this.parameters.get(KEY_FACILITY_ID);
        if (null == string) {
            this.handleError("ERROR: Missing facility ID", OP_START);
            return;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.handleError("ERROR: Bad facility ID, must be a number", OP_START);
            return;
        }
        Service service = null;
        string = (String)this.parameters.get(KEY_SERVICE);
        if (null == string) {
            this.handleError("ERROR: Missing service code", OP_START);
            return;
        }
        service = Service.getService((String)string);
        if (null == service) {
            this.handleError("ERROR: Bad service code", OP_START);
            return;
        }
        Country country = null;
        string = (String)this.parameters.get(KEY_COUNTRY);
        if (null == string) {
            this.handleError("ERROR: Missing country code", OP_START);
            return;
        }
        country = Country.getCountry((String)string);
        if (null == country) {
            this.handleError("ERROR: Bad country code", OP_START);
            return;
        }
        SourceEditDataTV sourceEditDataTV = SourceEditDataTV.createSource(null, (String)dbID, (int)n, (Service)service, (boolean)false, (Country)country, (boolean)false, (ErrorLogger)this.errors);
        if (null == sourceEditDataTV) {
            this.handleError(this.errors.toString(), OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_CALL_SIGN);
        if (null == string) {
            this.handleError("ERROR: Missing call sign", OP_START);
            return;
        }
        sourceEditDataTV.callSign = string.toUpperCase();
        string = (String)this.parameters.get(KEY_CHANNEL);
        if (null == string) {
            this.handleError("ERROR: Missing channel number", OP_START);
            return;
        }
        sourceEditDataTV.channel = 0;
        try {
            sourceEditDataTV.channel = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (sourceEditDataTV.channel < 2 || sourceEditDataTV.channel > 69) {
            this.handleError("ERROR: Bad channel number", OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_STATUS);
        if (null != string) {
            sourceEditDataTV.status = string.toUpperCase();
            sourceEditDataTV.statusType = ExtDbRecord.getStatusType((String)string);
        }
        if (null == (string = (String)this.parameters.get(KEY_CITY))) {
            this.handleError("ERROR: Missing city name", OP_START);
            return;
        }
        sourceEditDataTV.city = string.toUpperCase();
        string = (String)this.parameters.get(KEY_STATE);
        if (null == string) {
            this.handleError("ERROR: Missing state code", OP_START);
            return;
        }
        sourceEditDataTV.state = string.toUpperCase();
        string = (String)this.parameters.get(KEY_ZONE);
        if (null != string) {
            sourceEditDataTV.zone = Zone.getZone((String)string);
            if (sourceEditDataTV.zone.key < 1) {
                this.handleError("ERROR: Bad zone code", OP_START);
                return;
            }
        }
        if (null != (string = (String)this.parameters.get(KEY_FREQUENCY_OFFSET))) {
            sourceEditDataTV.frequencyOffset = FrequencyOffset.getFrequencyOffset((String)string);
            if (sourceEditDataTV.frequencyOffset.key < 1) {
                this.handleError("ERROR: Bad frequency offset code", OP_START);
                return;
            }
        }
        if (sourceEditDataTV.service.serviceType.needsEmissionMask) {
            string = (String)this.parameters.get(KEY_EMISSION_MASK);
            if (null == string) {
                this.handleError("ERROR: Missing emission mask code", OP_START);
                return;
            }
            sourceEditDataTV.emissionMask = EmissionMask.getEmissionMask((String)string);
            if (sourceEditDataTV.emissionMask.key < 1) {
                this.handleError("ERROR: Bad emission mask code", OP_START);
                return;
            }
        }
        if (null == (string = (String)this.parameters.get(KEY_LATITUDE_DIRECTION))) {
            this.handleError("ERROR: Missing latitude", OP_START);
            return;
        }
        sourceEditDataTV.location.latitudeNS = -1;
        if (string.equalsIgnoreCase("N")) {
            sourceEditDataTV.location.latitudeNS = 0;
        } else if (string.equalsIgnoreCase("S")) {
            sourceEditDataTV.location.latitudeNS = 1;
        }
        if (sourceEditDataTV.location.latitudeNS < 0) {
            this.handleError("ERROR: Bad latitude direction", OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_LATITUDE_DEGREES);
        if (null == string) {
            this.handleError("ERROR: Missing latitude degrees", OP_START);
            return;
        }
        sourceEditDataTV.location.latitudeDegrees = -74;
        try {
            sourceEditDataTV.location.latitudeDegrees = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ((double)sourceEditDataTV.location.latitudeDegrees < -73.0 || (double)sourceEditDataTV.location.latitudeDegrees > 73.5) {
            this.handleError("ERROR: Bad latitude degrees", OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_LATITUDE_MINUTES);
        if (null == string) {
            this.handleError("ERROR: Missing latitude minutes", OP_START);
            return;
        }
        sourceEditDataTV.location.latitudeMinutes = -1;
        try {
            sourceEditDataTV.location.latitudeMinutes = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (sourceEditDataTV.location.latitudeMinutes < 0 || sourceEditDataTV.location.latitudeMinutes > 59) {
            this.handleError("ERROR: Bad latitude minutes", OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_LATITUDE_SECONDS);
        if (null == string) {
            this.handleError("ERROR: Missing latitude seconds", OP_START);
            return;
        }
        sourceEditDataTV.location.latitudeSeconds = -1.0;
        try {
            sourceEditDataTV.location.latitudeSeconds = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (sourceEditDataTV.location.latitudeSeconds < 0.0 || sourceEditDataTV.location.latitudeSeconds >= 60.0) {
            this.handleError("ERROR: Bad latitude seconds", OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_LONGITUDE_DIRECTION);
        if (null == string) {
            this.handleError("ERROR: Missing longitude", OP_START);
            return;
        }
        sourceEditDataTV.location.longitudeWE = -1;
        if (string.equalsIgnoreCase("W")) {
            sourceEditDataTV.location.longitudeWE = 0;
        } else if (string.equalsIgnoreCase("E")) {
            sourceEditDataTV.location.longitudeWE = 1;
        }
        if (sourceEditDataTV.location.longitudeWE < 0) {
            this.handleError("ERROR: Bad longitude direction", OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_LONGITUDE_DEGREES);
        if (null == string) {
            this.handleError("ERROR: Missing longitude degrees", OP_START);
            return;
        }
        sourceEditDataTV.location.longitudeDegrees = -181;
        try {
            sourceEditDataTV.location.longitudeDegrees = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ((double)sourceEditDataTV.location.longitudeDegrees < -180.0 || (double)sourceEditDataTV.location.longitudeDegrees > 180.0) {
            this.handleError("ERROR: Bad longitude degrees", OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_LONGITUDE_MINUTES);
        if (null == string) {
            this.handleError("ERROR: Missing longitude minutes", OP_START);
            return;
        }
        sourceEditDataTV.location.longitudeMinutes = -1;
        try {
            sourceEditDataTV.location.longitudeMinutes = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (sourceEditDataTV.location.longitudeMinutes < 0 || sourceEditDataTV.location.longitudeMinutes > 59) {
            this.handleError("ERROR: Bad longitude minutes", OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_LONGITUDE_SECONDS);
        if (null == string) {
            this.handleError("ERROR: Missing longitude seconds", OP_START);
            return;
        }
        sourceEditDataTV.location.longitudeSeconds = -1.0;
        try {
            sourceEditDataTV.location.longitudeSeconds = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (sourceEditDataTV.location.longitudeSeconds < 0.0 || sourceEditDataTV.location.longitudeSeconds >= 60.0) {
            this.handleError("ERROR: Bad longitude seconds", OP_START);
            return;
        }
        sourceEditDataTV.location.updateLatLon();
        string = (String)this.parameters.get(KEY_HEIGHT_AMSL);
        if (null == string) {
            this.handleError("ERROR: Missing AMSL height", OP_START);
            return;
        }
        sourceEditDataTV.heightAMSL = -1101.0;
        try {
            sourceEditDataTV.heightAMSL = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (sourceEditDataTV.heightAMSL < -1100.0 || sourceEditDataTV.heightAMSL > 10000.0) {
            this.handleError("ERROR: Bad AMSL height", OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_HEIGHT_AAT);
        if (null == string) {
            this.handleError("ERROR: Missing HAAT", OP_START);
            return;
        }
        sourceEditDataTV.overallHAAT = -1101.0;
        try {
            sourceEditDataTV.overallHAAT = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (sourceEditDataTV.overallHAAT < -1100.0 || sourceEditDataTV.overallHAAT > 10000.0) {
            this.handleError("ERROR: Bad HAAT", OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_PEAK_ERP);
        if (null == string) {
            this.handleError("ERROR: Missing peak ERP", OP_START);
            return;
        }
        sourceEditDataTV.peakERP = -0.99999;
        try {
            sourceEditDataTV.peakERP = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (sourceEditDataTV.peakERP < 1.0E-5 || sourceEditDataTV.peakERP > 5000.0) {
            this.handleError("ERROR: Bad peak ERP", OP_START);
            return;
        }
        if (null == (sourceEditDataTV = (SourceEditDataTV)sourceEditDataTV.saveAsUserRecord(this.errors))) {
            if (this.errors.hasErrors()) {
                this.handleError(this.errors.toString(), OP_START);
                return;
            }
            this.handleError("ERROR: Could not save new user record", OP_START);
            return;
        }
        string = (String)this.parameters.get(KEY_COMMENT);
        if (null != string) {
            SourceEditData.setSourceComment((SourceEditData)sourceEditDataTV, (String)string);
        }
        this.parameters.put("ext_db_key", "0");
        this.parameters.put("user_record_id", String.valueOf(sourceEditDataTV.userRecordID));
        this.chainToOperation(this.nextOp);
    }
}

