/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.geo;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.geo.GeoBox;
import gov.fcc.tvstudy.core.geo.GeoCircle;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import gov.fcc.tvstudy.core.geo.GeoPointSet;
import gov.fcc.tvstudy.core.geo.GeoPolygon;
import gov.fcc.tvstudy.core.geo.GeoSectors;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Geography {
    public static final double MIN_RECEIVE_HEIGHT = 0.0;
    public static final double MAX_RECEIVE_HEIGHT = 1000.0;
    public static final double MIN_DISTANCE = 1.0;
    public static final double MAX_DISTANCE = 3000.0;
    public static final int GEO_TYPE_POINT_SET = 1;
    public static final int GEO_TYPE_CIRCLE = 2;
    public static final int GEO_TYPE_BOX = 3;
    public static final int GEO_TYPE_POLYGON = 4;
    public static final int GEO_TYPE_SECTORS = 5;
    public static final int MODE_ALL = 1;
    public static final int MODE_AREA = 2;
    public static final int MODE_POINTS = 3;
    public final String dbID;
    public final int type;
    public Integer key;
    public int studyKey;
    public int sourceKey;
    public String name;
    public int modCount;

    protected Geography(String string, int n) {
        this.dbID = string;
        this.type = n;
        this.name = "";
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return null != this.key ? this.key.hashCode() : super.hashCode();
    }

    public boolean equals(Object object) {
        return null != object && (null != this.key ? this.key.equals(((Geography)object).key) : super.equals(object));
    }

    public static String getTypeName(int n) {
        switch (n) {
            case 1: {
                return "Point set";
            }
            case 2: {
                return "Circle";
            }
            case 3: {
                return "Box";
            }
            case 5: {
                return "Sectors";
            }
            case 4: {
                return "Polygon";
            }
        }
        return "???";
    }

    public static ArrayList<KeyedRecord> getTypes(int n) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (1 == n || 3 == n) {
            arrayList.add(new KeyedRecord(1, Geography.getTypeName(1)));
        }
        if (1 == n || 2 == n) {
            arrayList.add(new KeyedRecord(2, Geography.getTypeName(2)));
            arrayList.add(new KeyedRecord(3, Geography.getTypeName(3)));
            arrayList.add(new KeyedRecord(5, Geography.getTypeName(5)));
            arrayList.add(new KeyedRecord(4, Geography.getTypeName(4)));
        }
        return arrayList;
    }

    public static ArrayList<Geography> getGeographies(String string, int n, int n2, int n3) {
        return Geography.getGeographies(string, n, n2, n3, null);
    }

    public static ArrayList<Geography> getGeographies(String string, int n, int n2, int n3, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        ArrayList<Geography> arrayList = new ArrayList<Geography>();
        String string2 = "";
        string2 = 0 == n2 ? "(study_key = 0) AND (source_key = 0)" : (0 == n3 ? "((study_key = 0) OR (study_key = " + n2 + ")) AND (source_key = 0)" : "((study_key = 0) OR (study_key = " + n2 + ")) AND ((source_key = 0) OR (source_key = " + n3 + "))");
        string2 = string2 + " AND (geo_type = " + n + ")";
        try {
            dbConnection.query("SELECT geo_type, geo_key, study_key, source_key, name, mod_count FROM geography WHERE " + string2 + " ORDER BY geo_key DESC");
            block9: while (dbConnection.next()) {
                Geography geography;
                switch (dbConnection.getInt(1)) {
                    case 1: {
                        geography = new GeoPointSet(string);
                        break;
                    }
                    case 3: {
                        geography = new GeoBox(string);
                        break;
                    }
                    case 2: {
                        geography = new GeoCircle(string);
                        break;
                    }
                    case 5: {
                        geography = new GeoSectors(string);
                        break;
                    }
                    case 4: {
                        geography = new GeoPolygon(string);
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                geography.key = dbConnection.getInt(2);
                geography.studyKey = dbConnection.getInt(3);
                geography.sourceKey = dbConnection.getInt(4);
                geography.name = dbConnection.getString(5);
                geography.modCount = dbConnection.getInt(6);
                arrayList.add(geography);
            }
            DbCore.releaseDb(dbConnection);
        }
        catch (SQLException sQLException) {
            DbCore.releaseDb(dbConnection);
            arrayList = null;
            DbConnection.reportError(errorLogger, sQLException);
        }
        return arrayList;
    }

    public static int getKeyForName(String string, String string2) {
        return Geography.getKeyForName(string, string2, null);
    }

    public static int getKeyForName(String string, String string2, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return 0;
        }
        int n = 0;
        try {
            dbConnection.query("SELECT geo_key FROM geography WHERE UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "'");
            if (dbConnection.next()) {
                n = dbConnection.getInt(1);
            }
            DbCore.releaseDb(dbConnection);
        }
        catch (SQLException sQLException) {
            DbCore.releaseDb(dbConnection);
            DbConnection.reportError(errorLogger, sQLException);
            n = -1;
        }
        return n;
    }

    public static int getTypeForKey(String string, int n) {
        return Geography.getTypeForKey(string, n, null);
    }

    public static int getTypeForKey(String string, int n, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return 0;
        }
        int n2 = 0;
        try {
            dbConnection.query("SELECT geo_type FROM geography WHERE geo_key = " + n);
            if (dbConnection.next()) {
                n2 = dbConnection.getInt(1);
            }
            DbCore.releaseDb(dbConnection);
        }
        catch (SQLException sQLException) {
            DbCore.releaseDb(dbConnection);
            DbConnection.reportError(errorLogger, sQLException);
        }
        return n2;
    }

    public static ArrayList<KeyedRecord> getGeographyList(String string, int n, int n2, int n3) {
        return Geography.getGeographyList(string, n, n2, n3, null);
    }

    public static ArrayList<KeyedRecord> getGeographyList(String string, int n, int n2, int n3, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        String string2 = "";
        string2 = 0 == n ? "(study_key = 0) AND (source_key = 0)" : (0 == n2 ? "((study_key = 0) OR (study_key = " + n + ")) AND (source_key = 0)" : "((study_key = 0) OR (study_key = " + n + ")) AND ((source_key = 0) OR (source_key = " + n2 + "))");
        if (3 == n3) {
            string2 = string2 + " AND (geo_type = " + 1 + ")";
        } else if (2 == n3) {
            string2 = string2 + " AND (geo_type <> " + 1 + ")";
        }
        try {
            dbConnection.query("SELECT geo_key, name FROM geography WHERE " + string2 + " ORDER BY geo_key DESC");
            while (dbConnection.next()) {
                arrayList.add(new KeyedRecord(dbConnection.getInt(1), dbConnection.getString(2)));
            }
            DbCore.releaseDb(dbConnection);
        }
        catch (SQLException sQLException) {
            DbCore.releaseDb(dbConnection);
            arrayList = null;
            DbConnection.reportError(errorLogger, sQLException);
        }
        return arrayList;
    }

    public static boolean checkGeographyName(String string, String string2) {
        return Geography.checkGeographyName(string, string2, null, true, null);
    }

    public static boolean checkGeographyName(String string, String string2, ErrorLogger errorLogger) {
        return Geography.checkGeographyName(string, string2, null, true, errorLogger);
    }

    public static boolean checkGeographyName(String string, String string2, boolean bl) {
        return Geography.checkGeographyName(string, string2, null, bl, null);
    }

    public static boolean checkGeographyName(String string, String string2, boolean bl, ErrorLogger errorLogger) {
        return Geography.checkGeographyName(string, string2, null, bl, errorLogger);
    }

    public static boolean checkGeographyName(String string, String string2, String string3) {
        return Geography.checkGeographyName(string, string2, string3, true, null);
    }

    public static boolean checkGeographyName(String string, String string2, String string3, ErrorLogger errorLogger) {
        return Geography.checkGeographyName(string, string2, string3, true, errorLogger);
    }

    public static boolean checkGeographyName(String string, String string2, String string3, boolean bl, ErrorLogger errorLogger) {
        if (null != string3 && string3.length() > 0 && string2.equalsIgnoreCase(string3)) {
            return true;
        }
        if (0 == string2.length()) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Please provide a name for the geography");
            }
            return false;
        }
        if (string2.length() > 245) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("The geography name cannot be more than 245 characters long");
            }
            return false;
        }
        if (string2.contains(String.valueOf('#'))) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("The geography name cannot contain the character '#'");
            }
            return false;
        }
        if (bl) {
            int n = Geography.getKeyForName(string, string2, errorLogger);
            if (n < 0) {
                return false;
            }
            if (n > 0) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("That geography name is already in use, please try again");
                }
                return false;
            }
        }
        return true;
    }

    public boolean loadData() {
        return this.loadData(null);
    }

    public abstract boolean loadData(ErrorLogger var1);

    public abstract Geography duplicate();

    protected void duplicateTo(Geography geography) {
        geography.studyKey = this.studyKey;
        geography.sourceKey = this.sourceKey;
        geography.name = this.name + " copy";
    }

    public boolean isDataValid() {
        return this.isDataValid(null);
    }

    public boolean isDataValid(ErrorLogger errorLogger) {
        if (null == this.name) {
            this.name = "";
        }
        this.name = this.name.trim();
        if (0 == this.name.length()) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A geography name must be provided");
            }
            return false;
        }
        if (this.name.length() > 245) {
            this.name = this.name.substring(0, 245);
        }
        return true;
    }

    public boolean save() {
        return this.save(null);
    }

    public boolean save(ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        String string = null;
        try {
            String string2 = "";
            switch (this.type) {
                case 1: {
                    string2 = "geo_point_set WRITE, receive_antenna_index WRITE, antenna_key_sequence WRITE, receive_pattern WRITE, geography_receive_antenna WRITE, ";
                    break;
                }
                case 5: {
                    string2 = "geo_sectors WRITE, ";
                    break;
                }
                case 4: {
                    string2 = "geo_polygon WRITE, ";
                }
            }
            dbConnection.update("LOCK TABLES geography WRITE, geo_key_sequence WRITE, " + string2 + "study WRITE, study_geography WRITE");
            if (null != this.key) {
                dbConnection.query("SELECT COUNT(*) FROM study_geography JOIN study USING (study_key) WHERE (study_geography.geo_key = " + this.key + ") AND (study.study_lock IN (" + 2 + "," + 3 + "))");
                if (dbConnection.next() && dbConnection.getInt(1) > 0) {
                    string = "Changes cannot be saved now, the geography is in use by a running study";
                }
            }
            if (null == string) {
                string = this.saveGeography(dbConnection);
            }
        }
        catch (SQLException sQLException) {
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string) {
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return false;
        }
        return true;
    }

    protected abstract String saveGeography(DbConnection var1) throws SQLException;

    protected String saveGeography(DbConnection dbConnection, GeoPoint geoPoint, double d, double d2, double d3) throws SQLException {
        dbConnection.query("SELECT geo_key FROM geography WHERE UPPER(name) = '" + DbConnection.clean(this.name.toUpperCase()) + "'");
        boolean bl = false;
        if (dbConnection.next()) {
            if (null == this.key) {
                bl = true;
            } else {
                boolean bl2 = bl = dbConnection.getInt(1) != this.key.intValue();
            }
        }
        if (null == this.key) {
            dbConnection.update("UPDATE geo_key_sequence SET geo_key = geo_key + 1");
            dbConnection.query("SELECT geo_key FROM geo_key_sequence");
            dbConnection.next();
            this.key = dbConnection.getInt(1);
        } else {
            dbConnection.update("DELETE FROM geography WHERE geo_key = " + this.key);
            ++this.modCount;
        }
        if (bl) {
            this.name = this.name + " " + '#' + this.key;
        }
        dbConnection.update("INSERT INTO geography (geo_key, study_key, source_key, geo_type, name, latitude, longitude, radius, width, height, mod_count) VALUES (" + this.key + "," + this.studyKey + "," + this.sourceKey + "," + this.type + ",'" + DbConnection.clean(this.name) + "', " + geoPoint.latitude + ", " + geoPoint.longitude + ", " + d + ", " + d2 + ", " + d3 + ", " + this.modCount + ")");
        return null;
    }

    public static boolean deleteGeography(String string, int n) {
        return Geography.deleteGeography(string, n, null);
    }

    public static boolean deleteGeography(String string, int n, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        String string2 = null;
        int n2 = 0;
        int n3 = 3;
        try {
            dbConnection.update("LOCK TABLES geography WRITE, geo_point_set WRITE, geo_polygon WRITE, geo_sectors WRITE, geography_receive_antenna WRITE, study_geography WRITE");
            dbConnection.query("SELECT COUNT(*) FROM study_geography WHERE geo_key = " + n);
            dbConnection.next();
            n2 = dbConnection.getInt(1);
            if (0 == n2) {
                dbConnection.update("DELETE FROM geography WHERE geo_key = " + n);
                dbConnection.update("DELETE FROM geo_point_set WHERE geo_key = " + n);
                dbConnection.update("DELETE FROM geo_sectors WHERE geo_key = " + n);
                dbConnection.update("DELETE FROM geo_polygon WHERE geo_key = " + n);
                dbConnection.update("DELETE FROM geography_receive_antenna WHERE geo_key = " + n);
            } else {
                string2 = "The geography is in use and cannot be deleted";
                n3 = 2;
            }
        }
        catch (SQLException sQLException) {
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string2) {
            if (null != errorLogger) {
                errorLogger.reportError(string2, n3);
            }
            return false;
        }
        return true;
    }

    public static void duplicateStudyGeographies(DbConnection dbConnection, String string, int n, Study.GeographyKeys geographyKeys) throws SQLException {
        int n2;
        dbConnection.setDatabase(string);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        dbConnection.query("SELECT geo_key, geo_type FROM geography WHERE ((geo_key IN (SELECT DISTINCT service_area_key FROM " + string + "_" + n + ".source)) OR (geo_key = " + geographyKeys.pointSetKey + ") OR (geo_key = " + geographyKeys.areaKey + ")) AND (study_key > 0)");
        while (dbConnection.next()) {
            hashMap.put(dbConnection.getInt(1), dbConnection.getInt(2));
        }
        if (!hashMap.isEmpty()) {
            dbConnection.update("LOCK TABLES geography WRITE, geography AS old WRITE, geo_key_sequence WRITE, geo_point_set WRITE, geo_point_set AS old_point WRITE, geography_receive_antenna WRITE, geo_polygon WRITE, geo_polygon AS old_poly WRITE, geo_sectors WRITE, geo_sectors AS old_sectors WRITE, study_geography WRITE, " + string + "_" + n + ".source WRITE");
            dbConnection.query("SELECT geo_key FROM geo_key_sequence");
            dbConnection.next();
            int n3 = dbConnection.getInt(1);
            dbConnection.update("UPDATE geo_key_sequence SET geo_key = geo_key + " + hashMap.size());
            for (Object object : hashMap.keySet()) {
                int n4 = (Integer)object;
                n2 = (Integer)hashMap.get(object);
                dbConnection.update("INSERT INTO geography (geo_key,study_key,source_key,geo_type,name,latitude,longitude,radius,width,height,mod_count) SELECT " + ++n3 + " AS geo_key," + n + " AS study_key,old.source_key,old.geo_type,CONCAT(old.name, ' " + '#' + n3 + "'),old.latitude,old.longitude,old.radius,old.width,old.height,0 AS mod_count FROM geography AS old WHERE old.geo_key = " + n4);
                switch (n2) {
                    case 1: {
                        dbConnection.update("INSERT INTO geo_point_set (geo_key,point_name,latitude,longitude,receive_height,antenna_key,antenna_orientation) SELECT " + n3 + " AS geo_key,old_point.point_name,old_point.latitude,old_point.longitude,old_point.receive_height,old_point.antenna_key,old_point.antenna_orientation FROM geo_point_set AS old_point WHERE old_point.geo_key = " + n4);
                        dbConnection.update("INSERT INTO geography_receive_antenna (geo_key,antenna_key) SELECT DISTINCT geo_key,antenna_key FROM geo_point_set WHERE geo_key = " + n3 + " AND antenna_key > 0");
                        break;
                    }
                    case 4: {
                        dbConnection.update("INSERT INTO geo_polygon (geo_key,vertex_key,latitude,longitude) SELECT " + n3 + " AS geo_key,old_poly.vertex_key,old_poly.latitude,old_poly.longitude FROM geo_polygon AS old_poly WHERE old_poly.geo_key = " + n4);
                        break;
                    }
                    case 5: {
                        dbConnection.update("INSERT INTO geo_sectors (geo_key,azimuth,radius) SELECT " + n3 + " AS geo_key,old_sectors.azimuth,old_sectors.radius FROM geo_sectors AS old_sectors WHERE old_sectors.geo_key = " + n4);
                    }
                }
                if (n4 == geographyKeys.pointSetKey) {
                    geographyKeys.pointSetKey = n3;
                    continue;
                }
                if (n4 == geographyKeys.areaKey) {
                    geographyKeys.areaKey = n3;
                    continue;
                }
                dbConnection.update("UPDATE " + string + "_" + n + ".source SET service_area_key = " + n3 + " WHERE service_area_key = " + n4);
            }
        } else {
            dbConnection.update("LOCK TABLES study_geography WRITE, " + string + "_" + n + ".source WRITE");
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        dbConnection.query("SELECT DISTINCT service_area_key FROM " + string + "_" + n + ".source WHERE service_area_key > 0");
        while (dbConnection.next()) {
            hashSet.add(dbConnection.getInt(1));
        }
        if (geographyKeys.pointSetKey > 0) {
            hashSet.add(geographyKeys.pointSetKey);
        }
        if (geographyKeys.areaKey > 0) {
            hashSet.add(geographyKeys.areaKey);
        }
        if (!hashSet.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("INSERT INTO study_geography (study_key, geo_key) VALUES");
            n2 = stringBuilder.length();
            Object object = " (";
            for (Integer n5 : hashSet) {
                stringBuilder.append((String)object);
                stringBuilder.append(String.valueOf(n));
                stringBuilder.append(',');
                stringBuilder.append(String.valueOf(n5));
                if (stringBuilder.length() > 500000) {
                    stringBuilder.append(')');
                    dbConnection.update(stringBuilder.toString());
                    stringBuilder.setLength(n2);
                    object = " (";
                    continue;
                }
                object = "),(";
            }
            if (stringBuilder.length() > n2) {
                stringBuilder.append(')');
                dbConnection.update(stringBuilder.toString());
            }
        }
        dbConnection.update("UNLOCK TABLES");
    }

    public static void deleteStudyGeographies(DbConnection dbConnection, String string, int n, String string2) throws SQLException {
        if (null == string2) {
            dbConnection.query("SELECT geo_key FROM " + string + ".geography WHERE study_key = " + n);
        } else {
            dbConnection.query("SELECT geo_key FROM " + string + ".geography WHERE study_key = " + n + " AND source_key IN " + string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "(";
        while (dbConnection.next()) {
            stringBuilder.append(string3);
            stringBuilder.append(String.valueOf(dbConnection.getInt(1)));
            string3 = ",";
        }
        if (0 == stringBuilder.length()) {
            return;
        }
        stringBuilder.append(")");
        String string4 = stringBuilder.toString();
        dbConnection.update("DELETE FROM " + string + ".geography WHERE geo_key IN " + string4);
        dbConnection.update("DELETE FROM " + string + ".geo_point_set WHERE geo_key IN " + string4);
        dbConnection.update("DELETE FROM " + string + ".geo_sectors WHERE geo_key IN " + string4);
        dbConnection.update("DELETE FROM " + string + ".geo_polygon WHERE geo_key IN " + string4);
        dbConnection.update("DELETE FROM " + string + ".geography_receive_antenna WHERE geo_key IN " + string4);
    }

    public boolean writeToXML(Writer writer) {
        return this.writeToXML(writer, null);
    }

    public boolean writeToXML(Writer writer, ErrorLogger errorLogger) {
        if (!this.isDataValid(errorLogger)) {
            return false;
        }
        try {
            writer.append("<GEOGRAPHY TYPE=\"");
            writer.append(String.valueOf(this.type));
            writer.append("\" NAME=\"");
            writer.append(this.name);
            writer.append('\"');
            this.writeAttributes(writer);
            if (this.hasElements()) {
                writer.append(">\n");
                this.writeElements(writer);
                writer.append("</GEOGRAPHY>\n");
            } else {
                writer.append("/>\n");
            }
        }
        catch (IOException iOException) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not write to the file:\n" + iOException.getMessage());
            }
            return false;
        }
        return true;
    }

    public static Geography readGeographyFromXML(String string, Reader reader) {
        return Geography.readGeographyFromXML(string, reader, null);
    }

    public static Geography readGeographyFromXML(String string, Reader reader, ErrorLogger errorLogger) {
        GeographyXMLHandler geographyXMLHandler = new GeographyXMLHandler(string, errorLogger);
        if (!AppCore.parseXML(reader, geographyXMLHandler, errorLogger)) {
            return null;
        }
        if (null == geographyXMLHandler.geography) {
            errorLogger.reportWarning("No geography data found in file");
            return null;
        }
        return geographyXMLHandler.geography;
    }

    protected void writeAttributes(Writer writer) throws IOException {
    }

    protected boolean parseAttributes(String string, Attributes attributes, ErrorLogger errorLogger) {
        return true;
    }

    protected boolean hasElements() {
        return false;
    }

    protected void writeElements(Writer writer) throws IOException {
    }

    protected boolean parseElement(String string, Attributes attributes, String string2, ErrorLogger errorLogger) {
        return true;
    }

    private static class GeographyXMLHandler
    extends DefaultHandler {
        private String dbID;
        private ErrorLogger errors;
        private Locator locator;
        private Geography geography;
        private boolean hasElements;
        private ArrayDeque<String> elements;
        private ArrayDeque<Attributes> attributes;
        private ArrayDeque<StringWriter> buffers;
        private boolean ignoreAll;

        private GeographyXMLHandler(String string, ErrorLogger errorLogger) {
            this.dbID = string;
            this.errors = errorLogger;
            this.elements = new ArrayDeque();
            this.attributes = new ArrayDeque();
            this.buffers = new ArrayDeque();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private void throwError(String string) throws SAXException {
            if (null != this.errors) {
                if (null != this.locator) {
                    if (null == string) {
                        string = "Error occurred ";
                    }
                    this.errors.reportError(string + " at line " + String.valueOf(this.locator.getLineNumber()));
                } else if (null != string) {
                    this.errors.reportError(string);
                }
            }
            throw new SAXException();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.ignoreAll) {
                return;
            }
            this.elements.push(string3);
            this.attributes.push(attributes);
            this.buffers.push(new StringWriter());
            if (string3.equals("GEOGRAPHY")) {
                if (this.geography != null) {
                    this.throwError("GEOGRAPHY elements may not be nested");
                }
                int n = 0;
                String string4 = attributes.getValue("TYPE");
                if (null != string4) {
                    try {
                        n = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                switch (n) {
                    case 1: {
                        this.geography = new GeoPointSet(this.dbID);
                        break;
                    }
                    case 2: {
                        this.geography = new GeoCircle(this.dbID);
                        break;
                    }
                    case 3: {
                        this.geography = new GeoBox(this.dbID);
                        break;
                    }
                    case 5: {
                        this.geography = new GeoSectors(this.dbID);
                        break;
                    }
                    case 4: {
                        this.geography = new GeoPolygon(this.dbID);
                    }
                }
                if (null == this.geography) {
                    this.throwError("Missing or bad TYPE attribute in GEOGRAPHY tag");
                }
                this.geography.name = attributes.getValue("NAME");
                if (null == this.geography.name) {
                    this.geography = null;
                    this.throwError("Missing NAME attribute in GEOGRAPHY tag");
                }
                if (!Geography.checkGeographyName(this.dbID, this.geography.name, false)) {
                    this.geography = null;
                    this.throwError("Bad NAME attribute in GEOGRAPHY tag");
                }
                if (!this.geography.parseAttributes(string3, attributes, this.errors)) {
                    this.geography = null;
                    this.throwError(null);
                }
                this.hasElements = this.geography.hasElements();
                return;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (!this.buffers.isEmpty()) {
                this.buffers.peek().write(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.ignoreAll) {
                return;
            }
            String string4 = this.elements.pop();
            Attributes attributes = this.attributes.pop();
            String string5 = this.buffers.pop().toString().trim();
            if (!string4.equals(string3)) {
                this.throwError("Overlapping elements not allowed");
            }
            if (string4.equals("GEOGRAPHY")) {
                if (null == this.geography || !this.geography.isDataValid(this.errors)) {
                    this.throwError(null);
                }
                this.ignoreAll = true;
                return;
            }
            if (this.hasElements && !this.geography.parseElement(string4, attributes, string5, this.errors)) {
                this.throwError(null);
            }
        }
    }
}

