/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.geo;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import gov.fcc.tvstudy.core.geo.Geography;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class GeoPolygon
extends Geography {
    public final GeoPoint reference = new GeoPoint();
    public ArrayList<VertexPoint> points = new ArrayList();

    public GeoPolygon(String string) {
        super(string, 4);
    }

    @Override
    public boolean loadData(ErrorLogger errorLogger) {
        if (null == this.key) {
            return false;
        }
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        this.points = new ArrayList();
        String string = null;
        try {
            dbConnection.query("SELECT latitude, longitude FROM geography WHERE geo_key = " + this.key);
            if (dbConnection.next()) {
                this.reference.setLatLon(dbConnection.getDouble(1), dbConnection.getDouble(2));
            } else {
                string = "Polygon geography data not found for key " + this.key;
            }
            if (null == string) {
                dbConnection.query("SELECT latitude, longitude FROM geo_polygon WHERE geo_key = " + this.key + " ORDER BY vertex_key");
                while (dbConnection.next()) {
                    VertexPoint vertexPoint = new VertexPoint();
                    vertexPoint.setLatLon(dbConnection.getDouble(1), dbConnection.getDouble(2));
                    this.points.add(vertexPoint);
                }
                if (this.points.size() < 3) {
                    string = "Bad polygon geography data for key " + this.key;
                }
            }
        }
        catch (SQLException sQLException) {
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string) {
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return false;
        }
        return true;
    }

    @Override
    public Geography duplicate() {
        GeoPolygon geoPolygon = new GeoPolygon(this.dbID);
        super.duplicateTo(geoPolygon);
        geoPolygon.reference.setLatLon(this.reference);
        if (null != this.points) {
            geoPolygon.points = new ArrayList();
            for (VertexPoint vertexPoint : this.points) {
                geoPolygon.points.add(vertexPoint.duplicate());
            }
        }
        return geoPolygon;
    }

    @Override
    public boolean isDataValid(ErrorLogger errorLogger) {
        if (!super.isDataValid(errorLogger)) {
            return false;
        }
        if (0.0 == this.reference.latitude || 0.0 == this.reference.longitude) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Reference point latitude and longitude must be provided");
            }
            return false;
        }
        if (this.reference.latitude < -73.0 || this.reference.latitude > 73.5) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad reference latitude, must be -73.0 to 73.5 degrees");
            }
            return false;
        }
        if (this.reference.longitude < -180.0 || this.reference.longitude > 180.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad reference longitude, must be -180.0 to 180.0 degrees");
            }
            return false;
        }
        if (this.points.size() < 4) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Polygon must contain at least 3 points");
            }
            return false;
        }
        for (VertexPoint vertexPoint : this.points) {
            if (vertexPoint.isDataValid(errorLogger)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String saveGeography(DbConnection dbConnection) throws SQLException {
        String string = super.saveGeography(dbConnection, this.reference, 0.0, 0.0, 0.0);
        if (null != string) {
            return string;
        }
        dbConnection.update("DELETE FROM geo_polygon WHERE geo_key = " + this.key);
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO geo_polygon VALUES");
        int n = stringBuilder.length();
        String string2 = " (";
        int n2 = 0;
        for (VertexPoint vertexPoint : this.points) {
            stringBuilder.append(string2);
            stringBuilder.append(String.valueOf(this.key));
            stringBuilder.append(',');
            stringBuilder.append(String.valueOf(n2++));
            stringBuilder.append(',');
            stringBuilder.append(String.valueOf(vertexPoint.latitude));
            stringBuilder.append(',');
            stringBuilder.append(String.valueOf(vertexPoint.longitude));
            if (stringBuilder.length() > 500000) {
                stringBuilder.append(')');
                dbConnection.update(stringBuilder.toString());
                stringBuilder.setLength(n);
                string2 = " (";
                continue;
            }
            string2 = "),(";
        }
        if (stringBuilder.length() > n) {
            stringBuilder.append(')');
            dbConnection.update(stringBuilder.toString());
        }
        return null;
    }

    @Override
    protected void writeAttributes(Writer writer) throws IOException {
        this.reference.writeAttributes(writer);
    }

    @Override
    protected boolean parseAttributes(String string, Attributes attributes, ErrorLogger errorLogger) {
        return this.reference.parseAttributes(string, attributes, errorLogger);
    }

    @Override
    protected boolean hasElements() {
        return true;
    }

    @Override
    protected void writeElements(Writer writer) throws IOException {
        for (VertexPoint vertexPoint : this.points) {
            writer.append("<VERTEX");
            vertexPoint.writeAttributes(writer);
            writer.append("/>\n");
        }
    }

    @Override
    protected boolean parseElement(String string, Attributes attributes, String string2, ErrorLogger errorLogger) {
        if (!string.equals("VERTEX")) {
            return true;
        }
        VertexPoint vertexPoint = new VertexPoint();
        if (!vertexPoint.parseAttributes(string, attributes, errorLogger)) {
            return false;
        }
        this.points.add(vertexPoint);
        return true;
    }

    public static class VertexPoint
    extends GeoPoint {
        public VertexPoint duplicate() {
            VertexPoint vertexPoint = new VertexPoint();
            vertexPoint.setLatLon(this);
            return vertexPoint;
        }

        public boolean isDataValid(ErrorLogger errorLogger) {
            if (0.0 == this.latitude || 0.0 == this.longitude) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Vertex latitude and longitude must be provided");
                }
                return false;
            }
            if (this.latitude < -73.0 || this.latitude > 73.5) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad vertex latitude, must be -73.0 to 73.5 degrees");
                }
                return false;
            }
            if (this.longitude < -180.0 || this.longitude > 180.0) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad vertex longitude, must be -180.0 to 180.0 degrees");
                }
                return false;
            }
            return true;
        }
    }
}

