/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.geo;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import gov.fcc.tvstudy.core.geo.Geography;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import org.xml.sax.Attributes;

public class GeoCircle
extends Geography {
    public final GeoPoint center = new GeoPoint();
    public double radius;

    public GeoCircle(String string) {
        super(string, 2);
    }

    @Override
    public boolean loadData(ErrorLogger errorLogger) {
        if (null == this.key) {
            return false;
        }
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        String string = null;
        try {
            dbConnection.query("SELECT latitude, longitude, radius FROM geography WHERE geo_key = " + this.key);
            if (dbConnection.next()) {
                this.center.setLatLon(dbConnection.getDouble(1), dbConnection.getDouble(2));
                this.radius = dbConnection.getDouble(3);
            } else {
                string = "Circle geography data not found for key " + this.key;
            }
        }
        catch (SQLException sQLException) {
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string) {
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return false;
        }
        return true;
    }

    @Override
    public Geography duplicate() {
        GeoCircle geoCircle = new GeoCircle(this.dbID);
        super.duplicateTo(geoCircle);
        geoCircle.center.setLatLon(this.center);
        geoCircle.radius = this.radius;
        return geoCircle;
    }

    @Override
    public boolean isDataValid(ErrorLogger errorLogger) {
        if (!super.isDataValid(errorLogger)) {
            return false;
        }
        if (0.0 == this.center.latitude || 0.0 == this.center.longitude) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Circle center latitude and longitude must be provided");
            }
            return false;
        }
        if (this.center.latitude < -73.0 || this.center.latitude > 73.5) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad circle center latitude, must be -73.0 to 73.5 degrees");
            }
            return false;
        }
        if (this.center.longitude < -180.0 || this.center.longitude > 180.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad circle center longitude, must be -180.0 to 180.0 degrees");
            }
            return false;
        }
        if (this.radius < 1.0 || this.radius > 3000.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Circle radius must be provided and between 1.0 and 3000.0");
            }
            return false;
        }
        return true;
    }

    @Override
    protected String saveGeography(DbConnection dbConnection) throws SQLException {
        return super.saveGeography(dbConnection, this.center, this.radius, 0.0, 0.0);
    }

    @Override
    protected void writeAttributes(Writer writer) throws IOException {
        this.center.writeAttributes(writer);
        writer.append(" RADIUS=\"");
        writer.append(AppCore.formatDistance(this.radius));
        writer.append('\"');
    }

    @Override
    protected boolean parseAttributes(String string, Attributes attributes, ErrorLogger errorLogger) {
        if (!this.center.parseAttributes(string, attributes, errorLogger)) {
            return false;
        }
        String string2 = attributes.getValue("RADIUS");
        this.radius = 0.0;
        if (null != string2) {
            try {
                this.radius = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.radius < 1.0 || this.radius > 3000.0) {
            if (null != errorLogger) {
                errorLogger.reportError("Bad RADIUS attribute in " + string + " tag");
            }
            return false;
        }
        return true;
    }
}

