/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.data.ChannelBand;
import gov.fcc.tvstudy.core.data.ChannelDelta;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.IxRule;
import gov.fcc.tvstudy.core.data.Parameter;
import gov.fcc.tvstudy.core.data.ServiceType;
import gov.fcc.tvstudy.core.data.SignalType;
import gov.fcc.tvstudy.core.data.Template;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.core.editdata.IxRuleListData;
import gov.fcc.tvstudy.core.editdata.ParameterEditData;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TemplateEditData {
    public final String dbID;
    public Template template;
    private int newIxRuleKey;
    public String name;
    public final ArrayList<ParameterEditData> parameters;
    public final IxRuleListData ixRuleData;

    public TemplateEditData(String string, Template template) {
        this.dbID = string;
        this.template = template;
        this.newIxRuleKey = 0;
        for (IxRule keyedRecord : this.template.ixRules) {
            if (keyedRecord.key <= this.newIxRuleKey) continue;
            this.newIxRuleKey = keyedRecord.key;
        }
        this.name = this.template.name;
        this.parameters = new ArrayList();
        for (Parameter parameter : this.template.parameters) {
            this.parameters.add(new ParameterEditData(parameter, this.template.isLocked));
        }
        this.ixRuleData = new IxRuleListData(this.template.ixRules, this.template.isLocked);
    }

    public Integer getNewIxRuleKey() {
        if (++this.newIxRuleKey <= 0) {
            this.newIxRuleKey = -1;
            throw new RuntimeException("Interference rule key range exhausted");
        }
        return this.newIxRuleKey;
    }

    public boolean isDataValid() {
        return this.isDataValid(null);
    }

    public boolean isDataValid(ErrorLogger errorLogger) {
        if (this.template.isLocked) {
            return true;
        }
        return this.ixRuleData.isDataValid(errorLogger);
    }

    public boolean isDataChanged() {
        if (this.template.isLocked) {
            return false;
        }
        if (this.ixRuleData.isDataChanged()) {
            return true;
        }
        for (ParameterEditData parameterEditData : this.parameters) {
            if (!parameterEditData.isDataChanged()) continue;
            return true;
        }
        return !this.name.equals(this.template.name);
    }

    public synchronized boolean save() {
        return this.save(null);
    }

    public synchronized boolean save(ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null != dbConnection) {
            boolean bl = false;
            String string = "";
            try {
                dbConnection.update("LOCK TABLES template WRITE, template_parameter_data WRITE, template_ix_rule WRITE");
                dbConnection.query("SELECT template_key FROM template WHERE template_key = " + this.template.key);
                if (!dbConnection.next()) {
                    bl = true;
                    string = "Template save failed, template does not exist";
                }
                if (!bl) {
                    dbConnection.update("DELETE FROM template_parameter_data WHERE template_key = " + this.template.key);
                    for (ParameterEditData arrayList2 : this.parameters) {
                        for (int i = 0; i < arrayList2.parameter.valueCount; ++i) {
                            dbConnection.update("INSERT INTO template_parameter_data (template_key,parameter_key,value_index,value) VALUES (" + this.template.key + "," + arrayList2.parameter.key + "," + i + ",'" + DbConnection.clean(arrayList2.value[i]) + "')");
                        }
                        arrayList2.didSave();
                    }
                    dbConnection.update("DELETE FROM template_ix_rule WHERE template_key = " + this.template.key);
                    int n = 0;
                    for (IxRuleEditData ixRuleEditData : this.ixRuleData.getRows()) {
                        dbConnection.update("INSERT INTO template_ix_rule (template_key, ix_rule_key, country_key, service_type_key, signal_type_key, undesired_service_type_key, undesired_signal_type_key, channel_delta_key, channel_band_key, frequency_offset, emission_mask_key, distance, required_du, undesired_time) VALUES (" + this.template.key + "," + ++n + "," + ixRuleEditData.country.key + "," + ixRuleEditData.serviceType.key + "," + ixRuleEditData.signalType.key + "," + ixRuleEditData.undesiredServiceType.key + "," + ixRuleEditData.undesiredSignalType.key + "," + ixRuleEditData.channelDelta.key + "," + ixRuleEditData.channelBand.key + "," + ixRuleEditData.frequencyOffset + "," + ixRuleEditData.emissionMask.key + "," + ixRuleEditData.distance + "," + ixRuleEditData.requiredDU + "," + ixRuleEditData.undesiredTime + ")");
                        ixRuleEditData.didSave();
                    }
                    this.ixRuleData.didSave();
                    if (!this.name.equals(this.template.name)) {
                        dbConnection.query("SELECT template_key FROM template WHERE UPPER(name) = '" + DbConnection.clean(this.name.toUpperCase()) + "' AND template_key <> " + this.template.key);
                        if (dbConnection.next()) {
                            this.name = this.name + " " + '#' + this.template.key;
                        }
                        dbConnection.update("UPDATE template SET name = '" + DbConnection.clean(this.name) + "' WHERE template_key = " + this.template.key);
                    }
                    ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
                    for (ParameterEditData parameterEditData : this.parameters) {
                        arrayList.add(parameterEditData.parameter);
                    }
                    this.template = new Template(this.dbID, this.template.key, this.name, this.template.isPermanent, this.template.isLocked, this.template.isLockedInStudy, arrayList, this.ixRuleData.getRules());
                }
            }
            catch (SQLException sQLException) {
                bl = true;
                string = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
            if (bl) {
                if (null != errorLogger) {
                    errorLogger.reportError(string);
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static Integer createNewTemplateFromStudy(String string, StudyEditData studyEditData) {
        return TemplateEditData.createNewTemplateFromStudy(string, studyEditData, null);
    }

    public static Integer createNewTemplateFromStudy(String string, StudyEditData studyEditData, ErrorLogger errorLogger) {
        ArrayList<TemplateParameter> arrayList = new ArrayList<TemplateParameter>(studyEditData.parameters.size());
        for (ParameterEditData object2 : studyEditData.parameters) {
            arrayList.add(new TemplateParameter(object2));
        }
        ArrayList<IxRuleEditData> arrayList2 = studyEditData.ixRuleData.getRows();
        ArrayList<TemplateIxRule> arrayList3 = new ArrayList<TemplateIxRule>(arrayList2.size());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            IxRuleEditData ixRuleEditData = (IxRuleEditData)iterator.next();
            arrayList3.add(new TemplateIxRule(ixRuleEditData));
        }
        return TemplateEditData.createNewTemplate(studyEditData.dbID, string, false, null, false, false, arrayList, arrayList3, errorLogger);
    }

    private static Integer createNewTemplate(String string, String string2, boolean bl, Date date, boolean bl2, boolean bl3, ArrayList<TemplateParameter> arrayList, ArrayList<TemplateIxRule> arrayList2, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        boolean bl4 = false;
        String string3 = "";
        int n = 0;
        try {
            dbConnection.update("LOCK TABLES template WRITE, template_key_sequence WRITE, template_parameter_data WRITE, template_ix_rule WRITE");
            boolean bl5 = false;
            if (null == date) {
                dbConnection.query("SELECT permanent, template_key FROM template WHERE UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "'");
                if (dbConnection.next()) {
                    if (bl && !dbConnection.getBoolean(1)) {
                        n = dbConnection.getInt(2);
                        dbConnection.update("UPDATE template SET name = '" + DbConnection.clean(string2) + " " + '#' + n + "' WHERE template_key = " + n);
                    } else {
                        bl5 = true;
                    }
                }
            }
            dbConnection.update("UPDATE template_key_sequence SET template_key = template_key + 1");
            dbConnection.query("SELECT template_key FROM template_key_sequence");
            dbConnection.next();
            n = dbConnection.getInt(1);
            if (bl5) {
                string2 = string2 + " " + '#' + n;
            }
            String string4 = "null";
            if (null != date) {
                string4 = "'" + AppCore.formatDateTime(date) + "'";
            }
            dbConnection.update("INSERT INTO template (template_key, name, permanent, locked, locked_in_study, hidden) VALUES (" + n + ", '" + DbConnection.clean(string2) + "', false, " + bl2 + ", " + bl3 + ", " + string4 + ")");
            for (TemplateParameter object : arrayList) {
                for (int i = 0; i < object.value.length; ++i) {
                    if (null == object.value[i]) continue;
                    dbConnection.update("INSERT INTO template_parameter_data (template_key,parameter_key,value_index,value) VALUES (" + n + "," + object.key + "," + i + ",'" + DbConnection.clean(object.value[i]) + "')");
                }
            }
            int n2 = 0;
            for (TemplateIxRule templateIxRule : arrayList2) {
                dbConnection.update("INSERT INTO template_ix_rule (template_key, ix_rule_key, country_key, service_type_key, signal_type_key, undesired_service_type_key, undesired_signal_type_key, channel_delta_key, channel_band_key, frequency_offset, emission_mask_key, distance, required_du, undesired_time) VALUES (" + n + "," + ++n2 + "," + ((TemplateIxRule)templateIxRule).country.key + "," + ((TemplateIxRule)templateIxRule).serviceType.key + "," + ((TemplateIxRule)templateIxRule).signalType.key + "," + ((TemplateIxRule)templateIxRule).undesiredServiceType.key + "," + ((TemplateIxRule)templateIxRule).undesiredSignalType.key + "," + ((TemplateIxRule)templateIxRule).channelDelta.key + "," + ((TemplateIxRule)templateIxRule).channelBand.key + "," + templateIxRule.frequencyOffset + "," + ((TemplateIxRule)templateIxRule).emissionMask.key + "," + templateIxRule.distance + "," + templateIxRule.requiredDU + "," + templateIxRule.undesiredTime + ")");
            }
        }
        catch (SQLException sQLException) {
            bl4 = true;
            string3 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            if (bl4 && n > 0) {
                dbConnection.update("DELETE FROM template WHERE template_key = " + n);
                dbConnection.update("DELETE FROM template_parameter_data WHERE template_key = " + n);
                dbConnection.update("DELETE FROM template_ix_rule WHERE template_key = " + n);
            }
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl4) {
            if (null != errorLogger) {
                errorLogger.reportError(string3);
            }
            return null;
        }
        return n;
    }

    public static boolean writeTemplateToXML(String string, int n, Writer writer) {
        return TemplateEditData.writeTemplateToXML(string, n, writer, null);
    }

    public static boolean writeTemplateToXML(String string, int n, Writer writer, ErrorLogger errorLogger) {
        int n2;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        ArrayList<TemplateParameter> arrayList = new ArrayList<TemplateParameter>();
        ArrayList<TemplateIxRule> arrayList2 = new ArrayList<TemplateIxRule>();
        int n3 = 0;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        try {
            dbConnection.update("LOCK TABLES template READ, template_parameter_data READ, template_ix_rule READ");
            dbConnection.query("SELECT permanent, name, locked, locked_in_study FROM template WHERE template_key = " + n);
            if (dbConnection.next()) {
                if (!dbConnection.getBoolean(1)) {
                    string3 = dbConnection.getString(2);
                    bl2 = dbConnection.getBoolean(3);
                    bl3 = dbConnection.getBoolean(4);
                    dbConnection.query("SELECT parameter_key,value_index,value FROM template_parameter_data WHERE template_key = " + n + " ORDER BY 1, 2");
                    while (dbConnection.next()) {
                        int n4 = dbConnection.getInt(1);
                        if (n4 > n3) {
                            if (n3 > 0) {
                                arrayList.add(new TemplateParameter(n3, arrayList3));
                            }
                            n3 = n4;
                            arrayList3.clear();
                        }
                        if ((n2 = dbConnection.getInt(2)) >= arrayList3.size()) {
                            for (int i = arrayList3.size(); i <= n2; ++i) {
                                arrayList3.add(null);
                            }
                        }
                        arrayList3.set(n2, dbConnection.getString(3));
                    }
                    if (n3 > 0) {
                        arrayList.add(new TemplateParameter(n3, arrayList3));
                    }
                    dbConnection.query("SELECT country_key, service_type_key, signal_type_key, undesired_service_type_key, undesired_signal_type_key, channel_delta_key, channel_band_key, frequency_offset, emission_mask_key, distance, required_du, undesired_time FROM template_ix_rule WHERE template_key = " + n);
                    while (dbConnection.next()) {
                        TemplateIxRule templateIxRule = new TemplateIxRule();
                        templateIxRule.country = Country.getCountry(dbConnection.getInt(1));
                        templateIxRule.serviceType = ServiceType.getServiceType(dbConnection.getInt(2));
                        templateIxRule.signalType = SignalType.getSignalType(dbConnection.getInt(3));
                        templateIxRule.undesiredServiceType = ServiceType.getServiceType(dbConnection.getInt(4));
                        templateIxRule.undesiredSignalType = SignalType.getSignalType(dbConnection.getInt(5));
                        templateIxRule.channelDelta = ChannelDelta.getChannelDelta(dbConnection.getInt(6));
                        if (null == templateIxRule.country || null == templateIxRule.serviceType || null == templateIxRule.signalType || null == templateIxRule.undesiredServiceType || null == templateIxRule.undesiredSignalType || null == templateIxRule.channelDelta) continue;
                        templateIxRule.channelBand = ChannelBand.getChannelBand(dbConnection.getInt(7));
                        templateIxRule.frequencyOffset = dbConnection.getInt(8);
                        templateIxRule.emissionMask = EmissionMask.getEmissionMask(dbConnection.getInt(9));
                        templateIxRule.distance = dbConnection.getDouble(10);
                        templateIxRule.requiredDU = dbConnection.getDouble(11);
                        templateIxRule.undesiredTime = dbConnection.getDouble(12);
                        arrayList2.add(templateIxRule);
                    }
                } else {
                    bl = true;
                    string2 = "The template cannot be exported";
                }
            } else {
                bl = true;
                string2 = "The template does not exist";
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl) {
            if (null != errorLogger) {
                errorLogger.reportError(string2);
            }
            return false;
        }
        try {
            writer.append("<TEMPLATE NAME=\"" + string3 + "\" LOCKED=\"" + bl2 + "\" STUDYLOCKED=\"" + bl3 + "\">\n");
            for (TemplateParameter object : arrayList) {
                writer.append("<PARAMETER KEY=\"" + object.key + "\">\n");
                for (n2 = 0; n2 < object.value.length; ++n2) {
                    if (null == object.value[n2]) continue;
                    writer.append("<VALUE INDEX=\"" + n2 + "\">" + AppCore.xmlclean(object.value[n2]) + "</VALUE>\n");
                }
                writer.append("</PARAMETER>\n");
            }
            for (TemplateIxRule templateIxRule : arrayList2) {
                writer.append("<RULE COUNTRY=\"" + ((TemplateIxRule)templateIxRule).country.key + '\"');
                writer.append(" DSERVICE=\"" + ((TemplateIxRule)templateIxRule).serviceType.key + '\"');
                if (((TemplateIxRule)templateIxRule).signalType.key > 0) {
                    writer.append(" DMOD_TYPE=\"" + ((TemplateIxRule)templateIxRule).signalType.key + '\"');
                }
                writer.append(" USERVICE=\"" + ((TemplateIxRule)templateIxRule).undesiredServiceType.key + '\"');
                if (((TemplateIxRule)templateIxRule).undesiredSignalType.key > 0) {
                    writer.append(" UMOD_TYPE=\"" + ((TemplateIxRule)templateIxRule).undesiredSignalType.key + '\"');
                }
                writer.append(" CHANNEL=\"" + ((TemplateIxRule)templateIxRule).channelDelta.delta + '\"');
                if (((TemplateIxRule)templateIxRule).channelBand.key > 0) {
                    writer.append(" BAND=\"" + ((TemplateIxRule)templateIxRule).channelBand.key + '\"');
                }
                if (templateIxRule.frequencyOffset > 0) {
                    writer.append(" OFFSET=\"" + templateIxRule.frequencyOffset + '\"');
                }
                if (((TemplateIxRule)templateIxRule).emissionMask.key > 0) {
                    writer.append(" MASK=\"" + ((TemplateIxRule)templateIxRule).emissionMask.key + '\"');
                }
                writer.append(" DISTANCE=\"" + AppCore.formatDistance(templateIxRule.distance) + '\"');
                writer.append(" DU=\"" + AppCore.formatDU(templateIxRule.requiredDU) + '\"');
                writer.append(" UTIME=\"" + AppCore.formatPercent(templateIxRule.undesiredTime) + "\"/>\n");
            }
            writer.append("</TEMPLATE>\n");
        }
        catch (IOException iOException) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not write to the file:\n" + iOException.getMessage());
            }
            return false;
        }
        return true;
    }

    public static Integer readTemplateFromXML(String string, Reader reader) {
        return TemplateEditData.readTemplateFromXML(string, reader, false, false, null);
    }

    public static Integer readTemplateFromXML(String string, Reader reader, ErrorLogger errorLogger) {
        return TemplateEditData.readTemplateFromXML(string, reader, false, false, errorLogger);
    }

    public static Integer readTemplateFromXML(String string, Reader reader, boolean bl) {
        return TemplateEditData.readTemplateFromXML(string, reader, bl, false, null);
    }

    public static Integer readTemplateFromXML(String string, Reader reader, boolean bl, ErrorLogger errorLogger) {
        return TemplateEditData.readTemplateFromXML(string, reader, bl, false, errorLogger);
    }

    public static Integer readTemplateFromXML(String string, Reader reader, boolean bl, boolean bl2) {
        return TemplateEditData.readTemplateFromXML(string, reader, bl, bl2, null);
    }

    public static Integer readTemplateFromXML(String string, Reader reader, boolean bl, boolean bl2, ErrorLogger errorLogger) {
        TemplateXMLHandler templateXMLHandler = new TemplateXMLHandler(string, bl, bl2, errorLogger);
        if (!AppCore.parseXML(reader, templateXMLHandler, errorLogger)) {
            return null;
        }
        if (null == templateXMLHandler.templateKey) {
            errorLogger.reportWarning("No template data found in file");
            return null;
        }
        return templateXMLHandler.templateKey;
    }

    private static class TemplateXMLHandler
    extends DefaultHandler {
        private String dbID;
        private ErrorLogger errors;
        private Locator locator;
        private boolean renameExisting;
        private boolean allowHidden;
        private Date hiddenDate;
        private String templateName;
        private boolean isLocked;
        private boolean isLockedInStudy;
        private ArrayList<TemplateParameter> parameters;
        private ArrayList<TemplateIxRule> ixRules;
        private int parameterKey = 0;
        private int valueIndex = -1;
        private ArrayList<String> parameterValues = new ArrayList();
        private TemplateIxRule ixRule;
        private ArrayDeque<String> elements;
        private ArrayDeque<StringWriter> buffers;
        private Integer templateKey;

        private TemplateXMLHandler(String string, boolean bl, boolean bl2, ErrorLogger errorLogger) {
            this.dbID = string;
            this.renameExisting = bl;
            this.allowHidden = bl2;
            this.errors = errorLogger;
            this.parameters = new ArrayList();
            this.ixRules = new ArrayList();
            this.elements = new ArrayDeque();
            this.buffers = new ArrayDeque();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private void throwError(String string) throws SAXException {
            if (null != this.errors) {
                if (null != this.locator) {
                    if (null == string) {
                        string = "Error occurred ";
                    }
                    this.errors.reportError(string + " at line " + String.valueOf(this.locator.getLineNumber()));
                } else if (null != string) {
                    this.errors.reportError(string);
                }
            }
            throw new SAXException();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.elements.push(string3);
            this.buffers.push(new StringWriter());
            if (string3.equals("TEMPLATE")) {
                String string4;
                if (this.templateName != null) {
                    this.throwError("TEMPLATE elements may not be nested");
                }
                this.templateName = attributes.getValue("NAME");
                if (null == this.templateName) {
                    this.throwError("Missing NAME attribute in TEMPLATE tag");
                }
                if (!Template.checkTemplateName(this.dbID, this.templateName, false)) {
                    this.throwError("Bad NAME attribute in TEMPLATE tag");
                }
                boolean bl = this.isLocked = null != (string4 = attributes.getValue("LOCKED")) && Boolean.valueOf(string4) != false;
                this.isLockedInStudy = this.isLocked ? null == (string4 = attributes.getValue("STUDYLOCKED")) || Boolean.valueOf(string4) != false : false;
                if (this.allowHidden) {
                    this.hiddenDate = AppCore.parseDate(attributes.getValue("HIDE_UNTIL"));
                }
                return;
            }
            if (string3.equals("PARAMETER")) {
                String string5;
                if (null == this.templateName) {
                    this.throwError("PARAMETER element must be inside a TEMPLATE element");
                }
                if (this.parameterKey > 0) {
                    this.throwError("PARAMETER elements cannot be nested");
                }
                if (null != (string5 = attributes.getValue("KEY"))) {
                    try {
                        this.parameterKey = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.parameterKey <= 0) {
                    this.throwError("Missing or bad KEY attribute in PARAMETER tag");
                }
                for (TemplateParameter templateParameter : this.parameters) {
                    if (this.parameterKey != templateParameter.key) continue;
                    this.throwError("Duplicate parameter key in template");
                }
                this.parameterValues.clear();
                return;
            }
            if (string3.equals("VALUE")) {
                String string6;
                if (this.parameterKey <= 0) {
                    this.throwError("VALUE element must be inside a PARAMETER element");
                }
                if (this.valueIndex >= 0) {
                    this.throwError("VALUE elements cannot be nested");
                }
                if (null != (string6 = attributes.getValue("INDEX"))) {
                    try {
                        this.valueIndex = Integer.parseInt(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.valueIndex < 0 || this.valueIndex >= 6) {
                    this.throwError("Missing or bad INDEX attribute in VALUE tag");
                }
                if (this.valueIndex >= this.parameterValues.size()) {
                    for (int i = this.parameterValues.size(); i <= this.valueIndex; ++i) {
                        this.parameterValues.add(null);
                    }
                }
                return;
            }
            if (string3.equals("RULE")) {
                if (null == this.templateName) {
                    this.throwError("RULE element must be inside a TEMPLATE element");
                }
                if (null != this.ixRule) {
                    this.throwError("RULE elements cannot be nested");
                }
                this.ixRule = new TemplateIxRule();
                String string7 = attributes.getValue("COUNTRY");
                if (null != string7) {
                    try {
                        this.ixRule.country = Country.getCountry(Integer.parseInt(string7));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (null == this.ixRule.country) {
                    this.throwError("Missing or bad COUNTRY attribute in RULE tag");
                }
                if (null != (string7 = attributes.getValue("DSERVICE"))) {
                    try {
                        this.ixRule.serviceType = ServiceType.getServiceType(Integer.parseInt(string7));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (null == this.ixRule.serviceType) {
                    this.throwError("Missing or bad DSERVICE attribute in RULE tag");
                }
                if (((TemplateIxRule)this.ixRule).serviceType.digital) {
                    string7 = attributes.getValue("DMOD_TYPE");
                    if (null == string7) {
                        this.ixRule.signalType = SignalType.getDefaultObject();
                    } else {
                        int n = 0;
                        try {
                            n = Integer.parseInt(string7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        this.ixRule.signalType = SignalType.getSignalType(n);
                        if (((TemplateIxRule)this.ixRule).signalType.key < 1) {
                            this.throwError("Bad DMOD_TYPE attribute in RULE tag");
                        }
                    }
                } else {
                    this.ixRule.signalType = SignalType.getNullObject();
                }
                string7 = attributes.getValue("USERVICE");
                if (null != string7) {
                    try {
                        this.ixRule.undesiredServiceType = ServiceType.getServiceType(Integer.parseInt(string7));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (null == this.ixRule.undesiredServiceType) {
                    this.throwError("Missing or bad USERVICE attribute in RULE tag");
                }
                if (((TemplateIxRule)this.ixRule).serviceType.recordType != ((TemplateIxRule)this.ixRule).undesiredServiceType.recordType) {
                    this.throwError("Invalid RULE tag, DSERVICE and USERVICE record types do not match");
                }
                if (((TemplateIxRule)this.ixRule).undesiredServiceType.digital) {
                    string7 = attributes.getValue("UMOD_TYPE");
                    if (null == string7) {
                        this.ixRule.undesiredSignalType = SignalType.getDefaultObject();
                    } else {
                        int n = 0;
                        try {
                            n = Integer.parseInt(string7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        this.ixRule.undesiredSignalType = SignalType.getSignalType(n);
                        if (((TemplateIxRule)this.ixRule).undesiredSignalType.key < 1) {
                            this.throwError("Bad UMOD_TYPE attribute in RULE tag");
                        }
                    }
                } else {
                    this.ixRule.undesiredSignalType = SignalType.getNullObject();
                }
                string7 = attributes.getValue("CHANNEL");
                if (null != string7) {
                    try {
                        this.ixRule.channelDelta = ChannelDelta.getChannelDeltaByDelta(((TemplateIxRule)this.ixRule).serviceType.recordType, Integer.parseInt(string7));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (null == this.ixRule.channelDelta) {
                    this.throwError("Missing or bad CHANNEL attribute in RULE tag");
                }
                if (null != (string7 = attributes.getValue("BAND")) && 1 == ((TemplateIxRule)this.ixRule).serviceType.recordType) {
                    try {
                        this.ixRule.channelBand = ChannelBand.getChannelBand(Integer.parseInt(string7));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (null == this.ixRule.channelBand) {
                        this.throwError("Bad BAND attribute in RULE tag");
                    }
                } else {
                    this.ixRule.channelBand = ChannelBand.getNullObject();
                }
                if (null != (string7 = attributes.getValue("OFFSET")) && 1 == ((TemplateIxRule)this.ixRule).serviceType.recordType) {
                    try {
                        this.ixRule.frequencyOffset = Integer.parseInt(string7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (1 != this.ixRule.frequencyOffset && 2 != this.ixRule.frequencyOffset) {
                        this.throwError("Bad OFFSET attribute in RULE tag");
                    }
                }
                if (null != (string7 = attributes.getValue("MASK")) && 1 == ((TemplateIxRule)this.ixRule).serviceType.recordType) {
                    try {
                        this.ixRule.emissionMask = EmissionMask.getEmissionMask(Integer.parseInt(string7));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (null == this.ixRule.emissionMask) {
                        this.throwError("Bad BAND attribute in RULE tag");
                    }
                } else {
                    this.ixRule.emissionMask = EmissionMask.getNullObject();
                }
                this.ixRule.distance = 0.0;
                string7 = attributes.getValue("DISTANCE");
                if (null != string7) {
                    try {
                        this.ixRule.distance = Double.parseDouble(string7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.ixRule.distance < 1.0 || this.ixRule.distance > 500.0) {
                    this.throwError("Missing or bad DISTANCE attribute in RULE tag");
                }
                this.ixRule.requiredDU = -61.0;
                string7 = attributes.getValue("DU");
                if (null != string7) {
                    try {
                        this.ixRule.requiredDU = Double.parseDouble(string7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.ixRule.requiredDU < -60.0 || this.ixRule.requiredDU > 60.0) {
                    this.throwError("Missing or bad DU attribute in RULE tag");
                }
                this.ixRule.undesiredTime = -0.99;
                string7 = attributes.getValue("UTIME");
                if (null != string7) {
                    try {
                        this.ixRule.undesiredTime = Double.parseDouble(string7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.ixRule.undesiredTime < 0.01 || this.ixRule.undesiredTime > 99.99) {
                    this.throwError("Missing or bad UTIME attribute in RULE tag");
                }
                return;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (!this.buffers.isEmpty()) {
                this.buffers.peek().write(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4 = this.elements.pop();
            String string5 = this.buffers.pop().toString().trim();
            if (!string4.equals(string3)) {
                this.throwError("Overlapping elements not allowed");
            }
            if (string4.equals("TEMPLATE")) {
                if (this.parameters.isEmpty() || this.ixRules.isEmpty()) {
                    this.throwError("TEMPLATE element must contain parameters and rules");
                }
                this.templateKey = TemplateEditData.createNewTemplate(this.dbID, this.templateName, this.renameExisting, this.hiddenDate, this.isLocked, this.isLockedInStudy, this.parameters, this.ixRules, this.errors);
                if (null == this.templateKey) {
                    this.throwError(null);
                }
                this.templateName = null;
                this.isLocked = false;
                this.isLockedInStudy = false;
                this.parameters.clear();
                this.ixRules.clear();
                this.parameterKey = 0;
                this.valueIndex = -1;
                this.parameterValues.clear();
                this.ixRule = null;
                return;
            }
            if (string4.equals("PARAMETER")) {
                if (this.parameterValues.isEmpty()) {
                    if (0 == string5.length()) {
                        this.throwError("PARAMETER element must have at least one VALUE");
                    }
                    this.parameterValues.add(string5);
                }
                this.parameters.add(new TemplateParameter(this.parameterKey, this.parameterValues));
                this.parameterKey = 0;
                this.valueIndex = -1;
                this.parameterValues.clear();
                return;
            }
            if (string4.equals("VALUE")) {
                this.parameterValues.set(this.valueIndex, string5);
                this.valueIndex = -1;
                return;
            }
            if (string4.equals("RULE")) {
                this.ixRules.add(this.ixRule);
                this.ixRule = null;
                return;
            }
        }
    }

    private static class TemplateIxRule {
        private Country country;
        private ServiceType serviceType;
        private SignalType signalType;
        private ServiceType undesiredServiceType;
        private SignalType undesiredSignalType;
        private ChannelDelta channelDelta;
        private ChannelBand channelBand;
        private int frequencyOffset;
        private EmissionMask emissionMask;
        private double distance;
        private double requiredDU;
        private double undesiredTime;

        private TemplateIxRule() {
        }

        private TemplateIxRule(IxRuleEditData ixRuleEditData) {
            this.country = ixRuleEditData.country;
            this.serviceType = ixRuleEditData.serviceType;
            this.signalType = ixRuleEditData.signalType;
            this.undesiredServiceType = ixRuleEditData.undesiredServiceType;
            this.undesiredSignalType = ixRuleEditData.undesiredSignalType;
            this.channelDelta = ixRuleEditData.channelDelta;
            this.channelBand = ixRuleEditData.channelBand;
            this.frequencyOffset = ixRuleEditData.frequencyOffset;
            this.emissionMask = ixRuleEditData.emissionMask;
            this.distance = ixRuleEditData.distance;
            this.requiredDU = ixRuleEditData.requiredDU;
            this.undesiredTime = ixRuleEditData.undesiredTime;
        }
    }

    private static class TemplateParameter {
        private int key;
        private String[] value;

        private TemplateParameter(int n, ArrayList<String> arrayList) {
            this.key = n;
            this.value = new String[arrayList.size()];
            for (int i = 0; i < this.value.length; ++i) {
                this.value[i] = arrayList.get(i);
            }
        }

        private TemplateParameter(ParameterEditData parameterEditData) {
            this.key = parameterEditData.parameter.key;
            this.value = new String[parameterEditData.parameter.valueCount];
            for (int i = 0; i < this.value.length; ++i) {
                this.value[i] = parameterEditData.value[i];
            }
        }
    }
}

