/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.Parameter;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.core.data.SourceWL;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.xml.sax.Attributes;

public class SourceEditDataWL
extends SourceEditData
implements StationRecord {
    private SourceWL source;
    public String sectorID;

    public SourceEditDataWL(StudyEditData studyEditData, SourceWL sourceWL) {
        super(studyEditData, sourceWL.dbID, 2, sourceWL.key, sourceWL.service, sourceWL.country, sourceWL.isLocked, sourceWL.userRecordID, sourceWL.extDbKey, sourceWL.extRecordID);
        this.source = sourceWL;
        this.callSign = this.source.callSign;
        this.sectorID = this.source.sectorID;
        this.city = this.source.city;
        this.state = this.source.state;
        this.fileNumber = this.source.fileNumber;
        this.location.setLatLon(this.source.location);
        this.heightAMSL = this.source.heightAMSL;
        this.overallHAAT = this.source.overallHAAT;
        this.peakERP = this.source.peakERP;
        this.antennaID = this.source.antennaID;
        this.hasHorizontalPattern = this.source.hasHorizontalPattern;
        this.horizontalPattern = null;
        this.horizontalPatternChanged = false;
        this.horizontalPatternOrientation = this.source.horizontalPatternOrientation;
        this.hasVerticalPattern = this.source.hasVerticalPattern;
        this.verticalPattern = null;
        this.verticalPatternChanged = false;
        this.verticalPatternElectricalTilt = this.source.verticalPatternElectricalTilt;
        this.verticalPatternMechanicalTilt = this.source.verticalPatternMechanicalTilt;
        this.verticalPatternMechanicalTiltOrientation = this.source.verticalPatternMechanicalTiltOrientation;
        this.hasMatrixPattern = this.source.hasMatrixPattern;
        this.matrixPattern = null;
        this.matrixPatternChanged = false;
        this.useGenericVerticalPattern = this.source.useGenericVerticalPattern;
        this.setAllAttributes(this.source.attributes);
    }

    private SourceEditDataWL(StudyEditData studyEditData, String string, Integer n, Service service, Country country, boolean bl, Integer n2, Integer n3, String string2) {
        super(studyEditData, string, 2, n, service, country, bl, n2, n3, string2);
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public SourceEditDataWL copy() {
        SourceEditDataWL sourceEditDataWL = new SourceEditDataWL(this.study, this.dbID, this.key, this.service, this.country, this.isLocked, this.userRecordID, this.extDbKey, this.extRecordID);
        sourceEditDataWL.source = this.source;
        sourceEditDataWL.callSign = this.callSign;
        sourceEditDataWL.sectorID = this.sectorID;
        sourceEditDataWL.city = this.city;
        sourceEditDataWL.state = this.state;
        sourceEditDataWL.fileNumber = this.fileNumber;
        sourceEditDataWL.location.setLatLon(this.location);
        sourceEditDataWL.heightAMSL = this.heightAMSL;
        sourceEditDataWL.overallHAAT = this.overallHAAT;
        sourceEditDataWL.peakERP = this.peakERP;
        sourceEditDataWL.antennaID = this.antennaID;
        sourceEditDataWL.hasHorizontalPattern = this.hasHorizontalPattern;
        sourceEditDataWL.horizontalPattern = this.horizontalPattern;
        sourceEditDataWL.horizontalPatternChanged = this.horizontalPatternChanged;
        sourceEditDataWL.horizontalPatternOrientation = this.horizontalPatternOrientation;
        sourceEditDataWL.hasVerticalPattern = this.hasVerticalPattern;
        sourceEditDataWL.verticalPattern = this.verticalPattern;
        sourceEditDataWL.verticalPatternChanged = this.verticalPatternChanged;
        sourceEditDataWL.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditDataWL.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditDataWL.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        sourceEditDataWL.hasMatrixPattern = this.hasMatrixPattern;
        sourceEditDataWL.matrixPattern = this.matrixPattern;
        sourceEditDataWL.matrixPatternChanged = this.matrixPatternChanged;
        sourceEditDataWL.useGenericVerticalPattern = this.useGenericVerticalPattern;
        sourceEditDataWL.setAllAttributes(this.attributes);
        return sourceEditDataWL;
    }

    public static SourceEditDataWL createSource(StudyEditData studyEditData, String string, Service service, Country country, boolean bl, ErrorLogger errorLogger) {
        return SourceEditDataWL.createSource(studyEditData, string, service, country, bl, null, null, null, errorLogger);
    }

    public static SourceEditDataWL createExtSource(ExtDb extDb, Service service, Country country) {
        return SourceEditDataWL.createExtSource(extDb, service, country, null);
    }

    public static SourceEditDataWL createExtSource(ExtDb extDb, Service service, Country country, ErrorLogger errorLogger) {
        if (!SourceEditDataWL.isExtDbSupported(extDb)) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create new record, invalid record/station data type");
            }
            return null;
        }
        Integer n = extDb.getNewRecordKey();
        if (null == n) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create new record, no keys available");
            }
            return null;
        }
        return SourceEditDataWL.createSource(null, extDb.dbID, n, service, country, true, null, extDb.key, String.valueOf(n));
    }

    private static SourceEditDataWL createSource(StudyEditData studyEditData, String string, Service service, Country country, boolean bl, Integer n, Integer n2, String string2, ErrorLogger errorLogger) {
        Integer n3;
        if (null != studyEditData) {
            n3 = studyEditData.getNewSourceKey();
            string = studyEditData.dbID;
        } else {
            n3 = SourceEditDataWL.getTemporaryKey();
        }
        if (null == n3) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create new record, no keys available");
            }
            return null;
        }
        return SourceEditDataWL.createSource(studyEditData, string, n3, service, country, bl, n, n2, string2);
    }

    private static SourceEditDataWL createSource(StudyEditData studyEditData, String string, Integer n, Service service, Country country, boolean bl, Integer n2, Integer n3, String string2) {
        if (null == string2) {
            n3 = null;
        }
        SourceEditDataWL sourceEditDataWL = new SourceEditDataWL(studyEditData, string, n, service, country, bl, n2, n3, string2);
        sourceEditDataWL.callSign = "";
        sourceEditDataWL.sectorID = "";
        sourceEditDataWL.city = "";
        sourceEditDataWL.state = "";
        sourceEditDataWL.fileNumber = "";
        sourceEditDataWL.heightAMSL = 0.0;
        sourceEditDataWL.overallHAAT = 0.0;
        sourceEditDataWL.peakERP = 0.001;
        sourceEditDataWL.antennaID = null;
        sourceEditDataWL.hasHorizontalPattern = false;
        sourceEditDataWL.horizontalPattern = null;
        sourceEditDataWL.horizontalPatternChanged = false;
        sourceEditDataWL.horizontalPatternOrientation = 0.0;
        sourceEditDataWL.hasVerticalPattern = false;
        sourceEditDataWL.verticalPattern = null;
        sourceEditDataWL.verticalPatternChanged = false;
        sourceEditDataWL.verticalPatternElectricalTilt = 0.0;
        sourceEditDataWL.verticalPatternMechanicalTilt = 0.0;
        sourceEditDataWL.verticalPatternMechanicalTiltOrientation = 0.0;
        sourceEditDataWL.hasMatrixPattern = false;
        sourceEditDataWL.matrixPattern = null;
        sourceEditDataWL.matrixPatternChanged = false;
        sourceEditDataWL.useGenericVerticalPattern = false;
        return sourceEditDataWL;
    }

    @Override
    public SourceEditData deriveSource(StudyEditData studyEditData, boolean bl, ErrorLogger errorLogger) {
        return this.deriveSourceWL(studyEditData, this.service, this.country, bl, false, errorLogger);
    }

    public SourceEditDataWL deriveSourceWL(Service service, Country country, boolean bl) {
        return this.deriveSourceWL(this.study, service, country, bl, true, null);
    }

    public SourceEditDataWL deriveSourceWL(Service service, Country country, boolean bl, ErrorLogger errorLogger) {
        return this.deriveSourceWL(this.study, service, country, bl, true, errorLogger);
    }

    private SourceEditDataWL deriveSourceWL(StudyEditData studyEditData, Service service, Country country, boolean bl, boolean bl2, ErrorLogger errorLogger) {
        String string = this.dbID;
        Integer n = this.userRecordID;
        Integer n2 = this.extDbKey;
        String string2 = this.extRecordID;
        if (null != studyEditData && !studyEditData.dbID.equals(this.dbID)) {
            string = studyEditData.dbID;
            bl2 = true;
        }
        if (bl2) {
            n = null;
            n2 = null;
            string2 = null;
        }
        if (!this.isLocked && bl) {
            if (null != errorLogger) {
                errorLogger.reportError("Unlocked records cannot be locked again");
            }
            return null;
        }
        return this.deriveSourceWL(studyEditData, string, service, country, bl, n, n2, string2, errorLogger);
    }

    private SourceEditDataWL deriveSourceWL(StudyEditData studyEditData, String string, Service service, Country country, boolean bl, Integer n, Integer n2, String string2, ErrorLogger errorLogger) {
        SourceEditDataWL sourceEditDataWL = SourceEditDataWL.createSource(studyEditData, string, service, country, bl, n, n2, string2, errorLogger);
        sourceEditDataWL.callSign = this.callSign;
        sourceEditDataWL.sectorID = this.sectorID;
        sourceEditDataWL.city = this.city;
        sourceEditDataWL.state = this.state;
        sourceEditDataWL.fileNumber = this.fileNumber;
        sourceEditDataWL.location.setLatLon(this.location);
        sourceEditDataWL.heightAMSL = this.heightAMSL;
        sourceEditDataWL.overallHAAT = this.overallHAAT;
        sourceEditDataWL.peakERP = this.peakERP;
        sourceEditDataWL.antennaID = this.antennaID;
        sourceEditDataWL.hasHorizontalPattern = false;
        sourceEditDataWL.horizontalPattern = null;
        sourceEditDataWL.horizontalPatternChanged = false;
        sourceEditDataWL.horizontalPatternOrientation = this.horizontalPatternOrientation;
        sourceEditDataWL.hasVerticalPattern = false;
        sourceEditDataWL.verticalPattern = null;
        sourceEditDataWL.verticalPatternChanged = false;
        sourceEditDataWL.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditDataWL.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditDataWL.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        sourceEditDataWL.hasMatrixPattern = false;
        sourceEditDataWL.matrixPattern = null;
        sourceEditDataWL.matrixPatternChanged = false;
        sourceEditDataWL.useGenericVerticalPattern = this.useGenericVerticalPattern;
        sourceEditDataWL.setAllAttributes(this.attributes);
        if (this.hasHorizontalPattern) {
            if (null == this.horizontalPattern && null != this.source) {
                this.horizontalPattern = this.source.getHorizontalPattern(errorLogger);
            }
            if (null != this.horizontalPattern) {
                sourceEditDataWL.hasHorizontalPattern = true;
                sourceEditDataWL.horizontalPattern = this.horizontalPattern.copy();
                sourceEditDataWL.horizontalPatternChanged = true;
            }
        }
        if (this.hasVerticalPattern) {
            if (null == this.verticalPattern && null != this.source) {
                this.verticalPattern = this.source.getVerticalPattern(errorLogger);
            }
            if (null != this.verticalPattern) {
                sourceEditDataWL.hasVerticalPattern = true;
                sourceEditDataWL.verticalPattern = this.verticalPattern.copy();
                sourceEditDataWL.verticalPatternChanged = true;
            }
        }
        if (this.hasMatrixPattern) {
            if (null == this.matrixPattern && null != this.source) {
                this.matrixPattern = this.source.getMatrixPattern(errorLogger);
            }
            if (null != this.matrixPattern) {
                sourceEditDataWL.hasMatrixPattern = true;
                sourceEditDataWL.matrixPattern = this.matrixPattern.copy();
                sourceEditDataWL.matrixPatternChanged = true;
            }
        }
        return sourceEditDataWL;
    }

    @Override
    public boolean isDataChanged() {
        if (null == this.source) {
            return true;
        }
        if (super.isDataChanged()) {
            return true;
        }
        if (this.isLocked) {
            return false;
        }
        return !this.sectorID.equals(this.source.sectorID);
    }

    @Override
    public void save(DbConnection dbConnection) throws SQLException {
        dbConnection.update("DELETE FROM source WHERE source_key=" + this.key);
        int n = 0;
        if (null != this.source) {
            n = this.source.modCount + 1;
        }
        String string = "";
        if (this.hasHorizontalPattern) {
            if (null != this.horizontalPattern) {
                string = this.horizontalPattern.name;
            } else if (null != this.source) {
                string = this.source.horizontalPatternName;
            }
        }
        String string2 = "";
        if (this.hasVerticalPattern) {
            if (null != this.verticalPattern) {
                string2 = this.verticalPattern.name;
            } else if (null != this.source) {
                string2 = this.source.verticalPatternName;
            }
        }
        String string3 = "";
        if (this.hasMatrixPattern) {
            if (null != this.matrixPattern) {
                string3 = this.matrixPattern.name;
            } else if (null != this.source) {
                string3 = this.source.matrixPatternName;
            }
        }
        String string4 = this.getAllAttributes();
        dbConnection.update("INSERT INTO source (source_key,record_type,needs_update,mod_count,facility_id,service_key,is_drt,is_iboc,station_class,call_sign,sector_id,channel,city,state,country_key,zone_key,status,file_number,signal_type_key,frequency_offset_key,emission_mask_key,latitude,longitude,dts_maximum_distance,dts_sectors,height_amsl,actual_height_amsl,height_agl,overall_haat,actual_overall_haat,peak_erp,contour_erp,iboc_fraction,antenna_id,has_horizontal_pattern,horizontal_pattern_name,horizontal_pattern_orientation,has_vertical_pattern,vertical_pattern_name,vertical_pattern_electrical_tilt,vertical_pattern_mechanical_tilt,vertical_pattern_mechanical_tilt_orientation,has_matrix_pattern,matrix_pattern_name,use_generic_vertical_pattern,site_number,locked,user_record_id,ext_db_key,ext_record_id,original_source_key,parent_source_key,service_area_mode,service_area_arg,service_area_cl,service_area_key,dts_time_delay,attributes) VALUES (" + this.key + "," + this.recordType + ",true," + n + ",0," + this.service.key + ",false,false,0,'" + DbConnection.clean(this.callSign) + "','" + DbConnection.clean(this.sectorID) + "',0,'" + DbConnection.clean(this.city) + "','" + DbConnection.clean(this.state) + "'," + this.country.key + ",0,'','" + DbConnection.clean(this.fileNumber) + "',0,0,0," + this.location.latitude + "," + this.location.longitude + ",0,''," + this.heightAMSL + "," + this.heightAMSL + ",0," + this.overallHAAT + "," + this.overallHAAT + "," + this.peakERP + "," + 10.0 * Math.log10(this.peakERP) + ",0.," + (null == this.antennaID ? "null" : "'" + DbConnection.clean(this.antennaID) + "'") + "," + this.hasHorizontalPattern + ",'" + DbConnection.clean(string) + "'," + this.horizontalPatternOrientation + "," + this.hasVerticalPattern + ",'" + DbConnection.clean(string2) + "'," + this.verticalPatternElectricalTilt + "," + this.verticalPatternMechanicalTilt + "," + this.verticalPatternMechanicalTiltOrientation + "," + this.hasMatrixPattern + ",'" + DbConnection.clean(string3) + "'," + this.useGenericVerticalPattern + ",0," + this.isLocked + "," + (null == this.userRecordID ? "0" : this.userRecordID) + "," + (null == this.extDbKey ? "0" : this.extDbKey) + "," + (null == this.extRecordID ? "null" : "'" + DbConnection.clean(this.extRecordID) + "'") + ",0,0,0,0,0,0,0,'" + DbConnection.clean(string4) + "')");
        this.savePatterns(dbConnection);
        this.source = new SourceWL(this.dbID, dbConnection.getDatabase(), this.key, this.service, this.callSign, this.sectorID, this.city, this.state, this.country, this.fileNumber, this.location.latitude, this.location.longitude, this.heightAMSL, this.heightAMSL, this.overallHAAT, this.overallHAAT, this.peakERP, this.antennaID, this.hasHorizontalPattern, string, this.horizontalPatternOrientation, this.hasVerticalPattern, string2, this.verticalPatternElectricalTilt, this.verticalPatternMechanicalTilt, this.verticalPatternMechanicalTiltOrientation, this.hasMatrixPattern, string3, this.useGenericVerticalPattern, this.isLocked, this.userRecordID, this.extDbKey, this.extRecordID, n, string4);
        this.horizontalPatternChanged = false;
        this.verticalPatternChanged = false;
        this.matrixPatternChanged = false;
        this.attributesChanged = false;
    }

    public static boolean isExtDbSupported(ExtDb extDb) {
        return SourceEditData.isExtDbSupported(extDb) && extDb.canProvide(2);
    }

    public static int addRecords(ExtDb extDb, ScenarioEditData scenarioEditData, int n, String string, GeoPoint geoPoint, double d, ErrorLogger errorLogger) {
        if (!SourceEditDataWL.isExtDbSupported(extDb) || !Study.isRecordTypeAllowed(scenarioEditData.study.study.studyType, 2) || 2 != n) {
            return 0;
        }
        double d2 = scenarioEditData.study.getKilometersPerDegree();
        double[] dArray = scenarioEditData.study.getWirelessCullDistance(5);
        if (null == dArray) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot load wireless culling distance table from parameters");
            }
            return -1;
        }
        ArrayList<SourceEditData> arrayList = scenarioEditData.sourceData.getDesiredSources(1);
        if (arrayList.isEmpty()) {
            if (null != errorLogger) {
                errorLogger.reportError("There is no desired TV station in the scenario");
            }
            return -1;
        }
        SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)arrayList.get(0);
        LinkedList<SourceEditData> linkedList = SourceEditDataWL.findImportRecords(extDb, 2, string, geoPoint, d, d2, errorLogger);
        if (null == linkedList) {
            return -1;
        }
        if (linkedList.isEmpty()) {
            return 0;
        }
        ArrayList<SourceEditData> arrayList2 = scenarioEditData.sourceData.getSources(2);
        ListIterator<SourceEditData> listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            SourceEditDataWL sourceEditDataWL = (SourceEditDataWL)listIterator.next();
            boolean bl = false;
            for (SourceEditData sourceEditData : arrayList2) {
                if (!sourceEditDataWL.extDbKey.equals(sourceEditData.extDbKey) || !sourceEditDataWL.extRecordID.equals(sourceEditData.extRecordID)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                double d3;
                int n2;
                int n3;
                bl = true;
                if (-999.0 == sourceEditDataWL.overallHAAT) {
                    n3 = 0;
                } else {
                    for (n3 = 1; n3 < 8 && !(sourceEditDataWL.overallHAAT > Parameter.wirelessCullHAAT[n3]); ++n3) {
                    }
                    --n3;
                }
                for (n2 = 1; n2 < 9 && !(sourceEditDataWL.peakERP > Parameter.wirelessCullERP[n2]); ++n2) {
                }
                double d4 = dArray[n3 * 9 + --n2];
                if (sourceEditDataTV.isParent) {
                    for (SourceEditDataTV sourceEditDataTV2 : sourceEditDataTV.getDTSSources()) {
                        if (sourceEditDataTV2.siteNumber <= 0) continue;
                        d3 = d4 + sourceEditDataTV2.getRuleExtraDistance();
                        if (!(sourceEditDataTV2.location.distanceTo(sourceEditDataWL.location, d2) <= d3)) continue;
                        bl = false;
                        break;
                    }
                } else {
                    d3 = d4 + sourceEditDataTV.getRuleExtraDistance();
                    if (sourceEditDataTV.location.distanceTo(sourceEditDataWL.location, d2) <= d3) {
                        bl = false;
                    }
                }
            }
            if (!bl) continue;
            listIterator.remove();
        }
        ArrayList<Iterator<SourceEditDataTV>> arrayList3 = new ArrayList<Iterator<SourceEditDataTV>>();
        for (SourceEditData sourceEditData : linkedList) {
            Object object3 = scenarioEditData.study.findSharedSource(sourceEditData.extDbKey, sourceEditData.extRecordID);
            if (null == object3 && null == (object3 = sourceEditData.deriveSource(scenarioEditData.study, true, errorLogger))) {
                return -1;
            }
            arrayList3.add((Iterator<SourceEditDataTV>)object3);
        }
        for (SourceEditData sourceEditData : arrayList3) {
            scenarioEditData.sourceData.addOrReplace(sourceEditData, false, true);
        }
        return arrayList3.size();
    }

    @Override
    protected boolean writeToXML(Writer writer, boolean bl, boolean bl2, boolean bl3, ErrorLogger errorLogger) throws IOException {
        if (!this.isDataValid(errorLogger)) {
            return false;
        }
        writer.append("<SOURCE");
        if (bl) {
            writer.append(" LOCKED=\"false\"");
        } else {
            writer.append(" DESIRED=\"" + bl2 + "\"");
            writer.append(" UNDESIRED=\"" + bl3 + '\"');
            writer.append(" LOCKED=\"" + this.isLocked + '\"');
        }
        writer.append(" SERVICE=\"" + this.service.serviceCode + '\"');
        writer.append(" CELL_SITE_ID=\"" + AppCore.xmlclean(this.callSign) + '\"');
        writer.append(" SECTOR_ID=\"" + AppCore.xmlclean(this.sectorID) + '\"');
        writer.append(" CITY=\"" + AppCore.xmlclean(this.city) + '\"');
        writer.append(" STATE=\"" + AppCore.xmlclean(this.state) + '\"');
        writer.append(" COUNTRY=\"" + this.country.countryCode + '\"');
        writer.append(" REFERENCE_NUMBER=\"" + AppCore.xmlclean(this.fileNumber) + '\"');
        this.writeAttributes(writer, errorLogger);
        writer.append("</SOURCE>\n");
        return true;
    }

    protected static SourceEditDataWL makeSourceWithAttributesWL(String string, Attributes attributes, StudyEditData studyEditData, String string2, Service service, Country country, boolean bl, Integer n, Integer n2, String string3, ErrorLogger errorLogger) {
        SourceEditDataWL sourceEditDataWL = SourceEditDataWL.createSource(studyEditData, string2, service, country, bl, n, n2, string3, errorLogger);
        if (null == sourceEditDataWL) {
            return null;
        }
        if (!sourceEditDataWL.parseAttributesWL(string, attributes, errorLogger)) {
            return null;
        }
        return sourceEditDataWL;
    }

    protected static SourceEditDataWL makeExtSourceWithAttributesWL(String string, Attributes attributes, ExtDb extDb, Service service, Country country, ErrorLogger errorLogger) {
        SourceEditDataWL sourceEditDataWL = SourceEditDataWL.createExtSource(extDb, service, country, errorLogger);
        if (null == sourceEditDataWL) {
            return null;
        }
        if (!sourceEditDataWL.parseAttributesWL(string, attributes, errorLogger)) {
            return null;
        }
        return sourceEditDataWL;
    }

    private boolean parseAttributesWL(String string, Attributes attributes, ErrorLogger errorLogger) {
        String string2 = attributes.getValue("CELL_SITE_ID");
        string2 = null == string2 ? "" : string2.trim();
        if (0 == string2.length()) {
            if (null != errorLogger) {
                errorLogger.reportError("Missing or bad CELL_SITE_ID attribute in " + string + " tag");
            }
            return false;
        }
        if (string2.length() > 12) {
            string2 = string2.substring(0, 12);
        }
        this.callSign = string2;
        string2 = attributes.getValue("SECTOR_ID");
        if (null != string2) {
            if ((string2 = string2.trim()).length() > 3) {
                string2 = string2.substring(0, 12);
            }
            this.sectorID = string2;
        }
        if (null != (string2 = attributes.getValue("CITY"))) {
            if ((string2 = string2.trim()).length() > 20) {
                string2 = string2.substring(0, 20);
            }
            this.city = string2;
        }
        if (null != (string2 = attributes.getValue("STATE"))) {
            if ((string2 = string2.trim()).length() > 2) {
                string2 = string2.substring(0, 2);
            }
            this.state = string2;
        }
        if (null != (string2 = attributes.getValue("REFERENCE_NUMBER"))) {
            if ((string2 = string2.trim()).length() > 255) {
                string2 = string2.substring(0, 255);
            }
            this.fileNumber = string2;
        }
        return this.parseAttributes(string, attributes, errorLogger);
    }

    @Override
    public String getCallSign() {
        if (this.sectorID.length() > 0) {
            return this.callSign + "-" + this.sectorID;
        }
        return this.callSign;
    }
}

