/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.FrequencyOffset;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.SignalType;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.core.data.SourceTV;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.data.Zone;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import gov.fcc.tvstudy.core.geo.GeoSectors;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.TreeMap;
import org.xml.sax.Attributes;

public class SourceEditDataTV
extends SourceEditData
implements StationRecord {
    public final int facilityID;
    public final boolean isDRT;
    public final Integer originalSourceKey;
    public final Integer parentSourceKey;
    public final boolean isParent;
    private SourceTV source;
    public int channel;
    public Zone zone;
    public String status;
    public int statusType;
    public String appARN;
    public SignalType signalType;
    public FrequencyOffset frequencyOffset;
    public EmissionMask emissionMask;
    public double dtsMaximumDistance;
    public String dtsSectors;
    public int siteNumber;
    public int serviceAreaMode;
    public double serviceAreaArg;
    public double serviceAreaCL;
    public int serviceAreaKey;
    public double dtsTimeDelay;
    private TreeMap<Integer, SourceEditDataTV> dtsSources;
    private HashSet<Integer> addedDTSSourceKeys;
    private HashSet<Integer> deletedDTSSourceKeys;
    private ArrayList<SourceEditDataTV> changedDTSSources;
    private ArrayList<SourceEditDataTV> dtsSourceListCache;
    private ArrayList<GeoPoint> dtsLocationListCache;
    public static final double DEFAULT_RULE_EXTRA_DISTANCE = 163.0;

    public SourceEditDataTV(StudyEditData studyEditData, SourceTV sourceTV) {
        super(studyEditData, sourceTV.dbID, 1, sourceTV.key, sourceTV.service, sourceTV.country, sourceTV.isLocked, sourceTV.userRecordID, sourceTV.extDbKey, sourceTV.extRecordID);
        this.source = sourceTV;
        this.facilityID = this.source.facilityID;
        this.isDRT = this.source.isDRT;
        this.originalSourceKey = this.source.originalSourceKey;
        this.parentSourceKey = this.source.parentSourceKey;
        this.isParent = this.source.isParent;
        this.callSign = this.source.callSign;
        this.channel = this.source.channel;
        this.city = this.source.city;
        this.state = this.source.state;
        this.zone = this.source.zone;
        this.status = this.source.status;
        this.statusType = ExtDbRecord.getStatusType(this.source.status);
        this.fileNumber = this.source.fileNumber;
        this.appARN = ExtDbRecord.parseFileNumber(this.fileNumber)[1];
        this.signalType = this.source.signalType;
        this.frequencyOffset = this.source.frequencyOffset;
        this.emissionMask = this.source.emissionMask;
        this.location.setLatLon(this.source.location);
        this.dtsMaximumDistance = this.source.dtsMaximumDistance;
        this.dtsSectors = this.source.dtsSectors;
        this.heightAMSL = this.source.heightAMSL;
        this.overallHAAT = this.source.overallHAAT;
        this.peakERP = this.source.peakERP;
        this.antennaID = this.source.antennaID;
        this.hasHorizontalPattern = this.source.hasHorizontalPattern;
        this.horizontalPattern = null;
        this.horizontalPatternChanged = false;
        this.horizontalPatternOrientation = this.source.horizontalPatternOrientation;
        this.hasVerticalPattern = this.source.hasVerticalPattern;
        this.verticalPattern = null;
        this.verticalPatternChanged = false;
        this.verticalPatternElectricalTilt = this.source.verticalPatternElectricalTilt;
        this.verticalPatternMechanicalTilt = this.source.verticalPatternMechanicalTilt;
        this.verticalPatternMechanicalTiltOrientation = this.source.verticalPatternMechanicalTiltOrientation;
        this.hasMatrixPattern = this.source.hasMatrixPattern;
        this.matrixPattern = null;
        this.matrixPatternChanged = false;
        this.useGenericVerticalPattern = this.source.useGenericVerticalPattern;
        this.siteNumber = this.source.siteNumber;
        this.serviceAreaMode = this.source.serviceAreaMode;
        this.serviceAreaArg = this.source.serviceAreaArg;
        this.serviceAreaCL = this.source.serviceAreaCL;
        this.serviceAreaKey = this.source.serviceAreaKey;
        this.dtsTimeDelay = this.source.dtsTimeDelay;
        this.setAllAttributes(this.source.attributes);
        if (this.isParent) {
            this.dtsSources = new TreeMap();
            for (SourceTV sourceTV2 : this.source.dtsSources) {
                SourceEditDataTV sourceEditDataTV = new SourceEditDataTV(this.study, sourceTV2);
                this.dtsSources.put(sourceEditDataTV.key, sourceEditDataTV);
            }
            this.addedDTSSourceKeys = new HashSet();
            this.deletedDTSSourceKeys = new HashSet();
            this.changedDTSSources = new ArrayList();
        }
    }

    private SourceEditDataTV(StudyEditData studyEditData, String string, Integer n, int n2, Service service, boolean bl, Country country, boolean bl2, Integer n3, Integer n4, String string2, Integer n5, Integer n6, boolean bl3) {
        super(studyEditData, string, 1, n, service, country, bl2, n3, n4, string2);
        this.facilityID = n2;
        this.isDRT = bl;
        this.originalSourceKey = n5;
        this.parentSourceKey = n6;
        this.isParent = bl3;
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public SourceEditDataTV copy() {
        SourceEditDataTV sourceEditDataTV = new SourceEditDataTV(this.study, this.dbID, this.key, this.facilityID, this.service, this.isDRT, this.country, this.isLocked, this.userRecordID, this.extDbKey, this.extRecordID, this.originalSourceKey, this.parentSourceKey, this.isParent);
        sourceEditDataTV.source = this.source;
        sourceEditDataTV.callSign = this.callSign;
        sourceEditDataTV.channel = this.channel;
        sourceEditDataTV.city = this.city;
        sourceEditDataTV.state = this.state;
        sourceEditDataTV.zone = this.zone;
        sourceEditDataTV.status = this.status;
        sourceEditDataTV.statusType = this.statusType;
        sourceEditDataTV.fileNumber = this.fileNumber;
        sourceEditDataTV.appARN = this.appARN;
        sourceEditDataTV.signalType = this.signalType;
        sourceEditDataTV.frequencyOffset = this.frequencyOffset;
        sourceEditDataTV.emissionMask = this.emissionMask;
        sourceEditDataTV.location.setLatLon(this.location);
        sourceEditDataTV.dtsMaximumDistance = this.dtsMaximumDistance;
        sourceEditDataTV.dtsSectors = this.dtsSectors;
        sourceEditDataTV.heightAMSL = this.heightAMSL;
        sourceEditDataTV.overallHAAT = this.overallHAAT;
        sourceEditDataTV.peakERP = this.peakERP;
        sourceEditDataTV.antennaID = this.antennaID;
        sourceEditDataTV.hasHorizontalPattern = this.hasHorizontalPattern;
        sourceEditDataTV.horizontalPattern = this.horizontalPattern;
        sourceEditDataTV.horizontalPatternChanged = this.horizontalPatternChanged;
        sourceEditDataTV.horizontalPatternOrientation = this.horizontalPatternOrientation;
        sourceEditDataTV.hasVerticalPattern = this.hasVerticalPattern;
        sourceEditDataTV.verticalPattern = this.verticalPattern;
        sourceEditDataTV.verticalPatternChanged = this.verticalPatternChanged;
        sourceEditDataTV.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditDataTV.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditDataTV.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        sourceEditDataTV.hasMatrixPattern = this.hasMatrixPattern;
        sourceEditDataTV.matrixPattern = this.matrixPattern;
        sourceEditDataTV.matrixPatternChanged = this.matrixPatternChanged;
        sourceEditDataTV.useGenericVerticalPattern = this.useGenericVerticalPattern;
        sourceEditDataTV.siteNumber = this.siteNumber;
        sourceEditDataTV.serviceAreaMode = this.serviceAreaMode;
        sourceEditDataTV.serviceAreaArg = this.serviceAreaArg;
        sourceEditDataTV.serviceAreaCL = this.serviceAreaCL;
        sourceEditDataTV.serviceAreaKey = this.serviceAreaKey;
        sourceEditDataTV.dtsTimeDelay = this.dtsTimeDelay;
        sourceEditDataTV.setAllAttributes(this.attributes);
        if (sourceEditDataTV.isParent) {
            sourceEditDataTV.dtsSources = new TreeMap();
            for (SourceEditDataTV sourceEditDataTV2 : this.dtsSources.values()) {
                sourceEditDataTV.dtsSources.put(sourceEditDataTV2.key, sourceEditDataTV2.copy());
            }
            sourceEditDataTV.addedDTSSourceKeys = new HashSet<Integer>(this.addedDTSSourceKeys);
            sourceEditDataTV.deletedDTSSourceKeys = new HashSet<Integer>(this.deletedDTSSourceKeys);
            sourceEditDataTV.changedDTSSources = new ArrayList();
        }
        return sourceEditDataTV;
    }

    public static SourceEditDataTV createSource(StudyEditData studyEditData, String string, int n, Service service, boolean bl, Country country, boolean bl2, ErrorLogger errorLogger) {
        return SourceEditDataTV.createSource(studyEditData, string, n, service, bl, country, bl2, null, null, null, null, errorLogger);
    }

    public static SourceEditDataTV createExtSource(ExtDb extDb, int n, Service service, boolean bl, Country country) {
        return SourceEditDataTV.createExtSource(extDb, n, service, bl, country, null, null);
    }

    public static SourceEditDataTV createExtSource(ExtDb extDb, int n, Service service, boolean bl, Country country, ErrorLogger errorLogger) {
        return SourceEditDataTV.createExtSource(extDb, n, service, bl, country, null, errorLogger);
    }

    private static SourceEditDataTV createExtSource(ExtDb extDb, int n, Service service, boolean bl, Country country, Integer n2, ErrorLogger errorLogger) {
        if (!SourceEditDataTV.isExtDbSupported(extDb)) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create new record, invalid record/station data type");
            }
            return null;
        }
        Integer n3 = extDb.getNewRecordKey();
        if (null == n3) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create new record, no keys available");
            }
            return null;
        }
        return SourceEditDataTV.createSource(null, extDb.dbID, n3, n, service, bl, country, true, null, extDb.key, String.valueOf(n3), n2);
    }

    private static SourceEditDataTV createSource(StudyEditData studyEditData, String string, int n, Service service, boolean bl, Country country, boolean bl2, Integer n2, Integer n3, String string2, Integer n4, ErrorLogger errorLogger) {
        Integer n5;
        if (null != studyEditData) {
            n5 = studyEditData.getNewSourceKey();
            string = studyEditData.dbID;
        } else {
            n5 = SourceEditDataTV.getTemporaryKey();
        }
        if (null == n5) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create new record, no keys available");
            }
            return null;
        }
        return SourceEditDataTV.createSource(studyEditData, string, n5, n, service, bl, country, bl2, n2, n3, string2, n4);
    }

    private static SourceEditDataTV createSource(StudyEditData studyEditData, String string, Integer n, int n2, Service service, boolean bl, Country country, boolean bl2, Integer n3, Integer n4, String string2, Integer n5) {
        if (null == string2) {
            n4 = null;
        }
        boolean bl3 = service.isDTS & null == n5;
        SourceEditDataTV sourceEditDataTV = new SourceEditDataTV(studyEditData, string, n, n2, service, bl, country, bl2, n3, n4, string2, null, n5, bl3);
        sourceEditDataTV.callSign = "";
        sourceEditDataTV.channel = 0;
        sourceEditDataTV.city = "";
        sourceEditDataTV.state = "";
        sourceEditDataTV.zone = Zone.getNullObject();
        sourceEditDataTV.status = "";
        sourceEditDataTV.statusType = 4;
        sourceEditDataTV.fileNumber = "";
        sourceEditDataTV.appARN = "";
        sourceEditDataTV.signalType = service.serviceType.digital ? SignalType.getDefaultObject() : SignalType.getNullObject();
        sourceEditDataTV.frequencyOffset = FrequencyOffset.getNullObject();
        sourceEditDataTV.emissionMask = service.serviceType.needsEmissionMask ? EmissionMask.getInvalidObject() : EmissionMask.getNullObject();
        sourceEditDataTV.dtsMaximumDistance = 0.0;
        sourceEditDataTV.dtsSectors = "";
        sourceEditDataTV.heightAMSL = 0.0;
        sourceEditDataTV.overallHAAT = 0.0;
        sourceEditDataTV.peakERP = 0.001;
        sourceEditDataTV.antennaID = null;
        sourceEditDataTV.hasHorizontalPattern = false;
        sourceEditDataTV.horizontalPattern = null;
        sourceEditDataTV.horizontalPatternChanged = false;
        sourceEditDataTV.horizontalPatternOrientation = 0.0;
        sourceEditDataTV.hasVerticalPattern = false;
        sourceEditDataTV.verticalPattern = null;
        sourceEditDataTV.verticalPatternChanged = false;
        sourceEditDataTV.verticalPatternElectricalTilt = 0.0;
        sourceEditDataTV.verticalPatternMechanicalTilt = 0.0;
        sourceEditDataTV.verticalPatternMechanicalTiltOrientation = 0.0;
        sourceEditDataTV.hasMatrixPattern = false;
        sourceEditDataTV.matrixPattern = null;
        sourceEditDataTV.matrixPatternChanged = false;
        sourceEditDataTV.useGenericVerticalPattern = true;
        sourceEditDataTV.siteNumber = 0;
        sourceEditDataTV.serviceAreaMode = 0;
        sourceEditDataTV.serviceAreaCL = -999.0;
        if (bl3) {
            sourceEditDataTV.dtsSources = new TreeMap();
            sourceEditDataTV.addedDTSSourceKeys = new HashSet();
            sourceEditDataTV.deletedDTSSourceKeys = new HashSet();
            sourceEditDataTV.changedDTSSources = new ArrayList();
        }
        return sourceEditDataTV;
    }

    public static SourceEditDataTV makeSourceTV(ExtDbRecordTV extDbRecordTV, StudyEditData studyEditData, boolean bl) {
        return SourceEditDataTV.makeSourceTV(extDbRecordTV, studyEditData, bl, null);
    }

    public static SourceEditDataTV makeSourceTV(ExtDbRecordTV extDbRecordTV, StudyEditData studyEditData, boolean bl, ErrorLogger errorLogger) {
        SourceEditDataTV sourceEditDataTV = SourceEditDataTV.createSource(studyEditData, extDbRecordTV.extDb.dbID, extDbRecordTV.facilityID, extDbRecordTV.service, extDbRecordTV.isDRT, extDbRecordTV.country, bl, null, extDbRecordTV.extDb.key, extDbRecordTV.extRecordID, null, errorLogger);
        if (null == sourceEditDataTV) {
            return null;
        }
        if (!extDbRecordTV.updateSource(sourceEditDataTV, errorLogger)) {
            return null;
        }
        return sourceEditDataTV;
    }

    public static SourceEditDataTV makeExtSourceTV(ExtDbRecordTV extDbRecordTV, ExtDb extDb) {
        return SourceEditDataTV.makeExtSourceTV(extDbRecordTV, extDb, null);
    }

    public static SourceEditDataTV makeExtSourceTV(ExtDbRecordTV extDbRecordTV, ExtDb extDb, ErrorLogger errorLogger) {
        SourceEditDataTV sourceEditDataTV = SourceEditDataTV.createExtSource(extDb, extDbRecordTV.facilityID, extDbRecordTV.service, extDbRecordTV.isDRT, extDbRecordTV.country, null, errorLogger);
        if (null == sourceEditDataTV) {
            return null;
        }
        if (!extDbRecordTV.updateSource(sourceEditDataTV, extDb, errorLogger)) {
            return null;
        }
        return sourceEditDataTV;
    }

    public SourceEditDataTV addDTSSource(ExtDbRecordTV extDbRecordTV) {
        return this.addDTSSource(extDbRecordTV, extDbRecordTV.service, extDbRecordTV.siteNumber, extDbRecordTV.extRecordID, null, null);
    }

    public SourceEditDataTV addDTSSource(ExtDbRecordTV extDbRecordTV, ErrorLogger errorLogger) {
        return this.addDTSSource(extDbRecordTV, extDbRecordTV.service, extDbRecordTV.siteNumber, extDbRecordTV.extRecordID, null, errorLogger);
    }

    public SourceEditDataTV addDTSSource(ExtDbRecordTV extDbRecordTV, ExtDb extDb) {
        return this.addDTSSource(extDbRecordTV, extDbRecordTV.service, extDbRecordTV.siteNumber, extDbRecordTV.extRecordID, extDb, null);
    }

    public SourceEditDataTV addDTSSource(ExtDbRecordTV extDbRecordTV, ExtDb extDb, ErrorLogger errorLogger) {
        return this.addDTSSource(extDbRecordTV, extDbRecordTV.service, extDbRecordTV.siteNumber, extDbRecordTV.extRecordID, extDb, errorLogger);
    }

    public SourceEditDataTV addDTSSource(Service service, int n) {
        return this.addDTSSource(null, service, n, null, null, null);
    }

    public SourceEditDataTV addDTSSource(Service service, int n, ErrorLogger errorLogger) {
        return this.addDTSSource(null, service, n, null, null, errorLogger);
    }

    public SourceEditDataTV addExtDTSSource(ExtDb extDb, Service service, int n) {
        return this.addDTSSource(null, service, n, null, extDb, null);
    }

    public SourceEditDataTV addExtDTSSource(ExtDb extDb, Service service, int n, ErrorLogger errorLogger) {
        return this.addDTSSource(null, service, n, null, extDb, errorLogger);
    }

    private SourceEditDataTV addDTSSource(ExtDbRecordTV extDbRecordTV, Service service, int n, String string, ExtDb extDb, ErrorLogger errorLogger) {
        if (!this.isParent) {
            if (null != errorLogger) {
                errorLogger.reportError("SourceEditDataTV.addDTSSource() called on non-parent source");
            }
            return null;
        }
        Service service2 = this.service;
        String string2 = this.extRecordID;
        if (0 == n) {
            service2 = service;
            if (service2.isDTS) {
                if (null != errorLogger) {
                    errorLogger.reportError("SourceEditDataTV.addDTSSource() cannot use DTS record as authorized facility");
                }
                return null;
            }
            string2 = string;
        }
        SourceEditDataTV sourceEditDataTV = null;
        sourceEditDataTV = null == extDb ? SourceEditDataTV.createSource(this.study, this.dbID, this.facilityID, service2, false, this.country, this.isLocked, null, this.extDbKey, string2, this.key, errorLogger) : SourceEditDataTV.createExtSource(extDb, this.facilityID, service2, false, this.country, this.key, errorLogger);
        if (null == sourceEditDataTV) {
            return null;
        }
        if (0 == n) {
            sourceEditDataTV.serviceAreaMode = 1;
            sourceEditDataTV.serviceAreaCL = -999.0;
        }
        if (null != extDbRecordTV) {
            if (!extDbRecordTV.updateSource(sourceEditDataTV, extDb, errorLogger)) {
                return null;
            }
        } else {
            sourceEditDataTV.callSign = this.callSign;
            sourceEditDataTV.city = this.city;
            sourceEditDataTV.state = this.state;
            if (n > 0) {
                sourceEditDataTV.channel = this.channel;
                sourceEditDataTV.zone = this.zone;
                sourceEditDataTV.status = this.status;
                sourceEditDataTV.statusType = this.statusType;
                sourceEditDataTV.fileNumber = this.fileNumber;
                sourceEditDataTV.appARN = this.appARN;
                sourceEditDataTV.signalType = this.signalType;
                sourceEditDataTV.frequencyOffset = this.frequencyOffset;
                sourceEditDataTV.emissionMask = this.emissionMask;
            }
            sourceEditDataTV.siteNumber = n;
        }
        this.dtsSources.put(sourceEditDataTV.key, sourceEditDataTV);
        this.addedDTSSourceKeys.add(sourceEditDataTV.key);
        this.dtsSourceListCache = null;
        this.dtsLocationListCache = null;
        return sourceEditDataTV;
    }

    public SourceEditDataTV makeDTSAuthorizedSource(ErrorLogger errorLogger) {
        return this.makeDTSAuthorizedSource(null, errorLogger);
    }

    public SourceEditDataTV makeDTSAuthorizedSource(ExtDb extDb, ErrorLogger errorLogger) {
        SourceEditDataTV sourceEditDataTV2;
        if (!this.isParent) {
            if (null != errorLogger) {
                errorLogger.reportError("SourceEditDataTV.makeDTSAuthorizedSource() called on non-parent source");
            }
            return null;
        }
        for (SourceEditDataTV sourceEditDataTV2 : this.dtsSources.values()) {
            if (0 != sourceEditDataTV2.siteNumber) continue;
            if (null != errorLogger) {
                errorLogger.reportError("DTS parent source already has an authorized facility");
            }
            return null;
        }
        if (!this.service.isFullService()) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create DTS authorized facility on non-full-service source");
            }
            return null;
        }
        Service service = Service.getService("DT");
        if (null == service) {
            if (null != errorLogger) {
                errorLogger.reportError("SourceEditDataTV.makeDTSAuthorizedSource() could not load service record");
            }
            return null;
        }
        sourceEditDataTV2 = null;
        sourceEditDataTV2 = null == extDb ? SourceEditDataTV.createSource(this.study, this.dbID, this.facilityID, service, false, this.country, this.isLocked, null, null, null, this.key, errorLogger) : SourceEditDataTV.createExtSource(extDb, this.facilityID, service, false, this.country, this.key, errorLogger);
        if (null == sourceEditDataTV2) {
            return null;
        }
        sourceEditDataTV2.siteNumber = 0;
        sourceEditDataTV2.callSign = this.callSign;
        sourceEditDataTV2.city = this.city;
        sourceEditDataTV2.state = this.state;
        sourceEditDataTV2.channel = this.channel;
        sourceEditDataTV2.zone = this.zone;
        sourceEditDataTV2.location.setLatLon(this.location);
        sourceEditDataTV2.heightAMSL = -999.0;
        sourceEditDataTV2.overallHAAT = -999.0;
        sourceEditDataTV2.peakERP = 0.001;
        this.dtsSources.put(sourceEditDataTV2.key, sourceEditDataTV2);
        this.addedDTSSourceKeys.add(sourceEditDataTV2.key);
        this.dtsSourceListCache = null;
        this.dtsLocationListCache = null;
        return sourceEditDataTV2;
    }

    @Override
    public SourceEditData deriveSource(StudyEditData studyEditData, boolean bl, ErrorLogger errorLogger) {
        return this.deriveSourceTV(studyEditData, this.facilityID, this.service, this.country, bl, false, errorLogger);
    }

    public SourceEditDataTV deriveSourceTV(int n, Service service, Country country, boolean bl) {
        return this.deriveSourceTV(this.study, n, service, country, bl, true, null);
    }

    public SourceEditDataTV deriveSourceTV(int n, Service service, Country country, boolean bl, ErrorLogger errorLogger) {
        return this.deriveSourceTV(this.study, n, service, country, bl, true, errorLogger);
    }

    private SourceEditDataTV deriveSourceTV(StudyEditData studyEditData, int n, Service service, Country country, boolean bl, boolean bl2, ErrorLogger errorLogger) {
        String string = this.dbID;
        Integer n2 = this.userRecordID;
        Integer n3 = this.extDbKey;
        String string2 = this.extRecordID;
        if (null != studyEditData && !studyEditData.dbID.equals(this.dbID)) {
            string = studyEditData.dbID;
            bl2 = true;
        }
        if (bl2) {
            n2 = null;
            n3 = null;
            string2 = null;
        }
        boolean bl3 = this.isDRT;
        if (!service.equals(this.service)) {
            bl3 = false;
        }
        if (null != this.originalSourceKey || this.isParent && !service.isDTS || null != this.parentSourceKey && this.service.isDTS && service.isDTS) {
            if (null != errorLogger) {
                errorLogger.reportError("The record derivation cannot be performed");
            }
            return null;
        }
        if (!this.isLocked && bl) {
            if (null != errorLogger) {
                errorLogger.reportError("Unlocked records cannot be locked again");
            }
            return null;
        }
        return this.deriveSourceTV(studyEditData, string, n, service, bl3, country, bl, n2, n3, string2, null, errorLogger);
    }

    private SourceEditDataTV deriveSourceTV(StudyEditData studyEditData, String string, int n, Service service, boolean bl, Country country, boolean bl2, Integer n2, Integer n3, String string2, Integer n4, ErrorLogger errorLogger) {
        SourceEditDataTV sourceEditDataTV = SourceEditDataTV.createSource(studyEditData, string, n, service, bl, country, bl2, n2, n3, string2, n4, errorLogger);
        if (null == sourceEditDataTV) {
            return null;
        }
        SourceEditDataTV sourceEditDataTV2 = null;
        if (sourceEditDataTV.isParent && !this.isParent) {
            sourceEditDataTV2 = sourceEditDataTV;
            sourceEditDataTV2.callSign = this.callSign;
            sourceEditDataTV2.channel = this.channel;
            sourceEditDataTV2.city = this.city;
            sourceEditDataTV2.state = this.state;
            sourceEditDataTV2.zone = this.zone;
            sourceEditDataTV2.status = this.status;
            sourceEditDataTV2.statusType = this.statusType;
            sourceEditDataTV2.fileNumber = this.fileNumber;
            sourceEditDataTV2.appARN = this.appARN;
            if (this.service.serviceType.digital) {
                sourceEditDataTV2.signalType = this.signalType;
                sourceEditDataTV2.frequencyOffset = this.frequencyOffset;
                sourceEditDataTV2.emissionMask = this.emissionMask;
            } else {
                sourceEditDataTV2.signalType = SignalType.getDefaultObject();
                sourceEditDataTV2.frequencyOffset = FrequencyOffset.getNullObject();
                sourceEditDataTV2.emissionMask = EmissionMask.getDefaultObject();
            }
            sourceEditDataTV2.location.setLatLon(this.location);
            sourceEditDataTV = sourceEditDataTV2.createDTSSource(0, this.service, errorLogger);
            if (null == sourceEditDataTV) {
                return null;
            }
            sourceEditDataTV2.addOrReplaceDTSSource(sourceEditDataTV);
            sourceEditDataTV2.setAllAttributes(this.attributes);
            if (!sourceEditDataTV2.isLocked) {
                sourceEditDataTV2.removeAttribute("-isPending");
                sourceEditDataTV2.removeAttribute("-isArchived");
            }
        } else {
            sourceEditDataTV.siteNumber = this.siteNumber;
            sourceEditDataTV.setAllAttributes(this.attributes);
            if (!sourceEditDataTV.isLocked) {
                sourceEditDataTV.removeAttribute("-isPending");
                sourceEditDataTV.removeAttribute("-isArchived");
            }
        }
        sourceEditDataTV.callSign = this.callSign;
        sourceEditDataTV.channel = this.channel;
        sourceEditDataTV.city = this.city;
        sourceEditDataTV.state = this.state;
        sourceEditDataTV.zone = this.zone;
        sourceEditDataTV.status = this.status;
        sourceEditDataTV.statusType = this.statusType;
        sourceEditDataTV.fileNumber = this.fileNumber;
        sourceEditDataTV.appARN = this.appARN;
        sourceEditDataTV.signalType = this.signalType;
        sourceEditDataTV.frequencyOffset = this.frequencyOffset;
        sourceEditDataTV.emissionMask = this.emissionMask;
        sourceEditDataTV.location.setLatLon(this.location);
        sourceEditDataTV.dtsMaximumDistance = this.dtsMaximumDistance;
        sourceEditDataTV.dtsSectors = this.dtsSectors;
        sourceEditDataTV.heightAMSL = this.heightAMSL;
        sourceEditDataTV.overallHAAT = this.overallHAAT;
        sourceEditDataTV.peakERP = this.peakERP;
        sourceEditDataTV.antennaID = this.antennaID;
        sourceEditDataTV.hasHorizontalPattern = false;
        sourceEditDataTV.horizontalPattern = null;
        sourceEditDataTV.horizontalPatternChanged = false;
        sourceEditDataTV.horizontalPatternOrientation = this.horizontalPatternOrientation;
        sourceEditDataTV.hasVerticalPattern = false;
        sourceEditDataTV.verticalPattern = null;
        sourceEditDataTV.verticalPatternChanged = false;
        sourceEditDataTV.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditDataTV.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditDataTV.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        sourceEditDataTV.hasMatrixPattern = false;
        sourceEditDataTV.matrixPattern = null;
        sourceEditDataTV.matrixPatternChanged = false;
        sourceEditDataTV.useGenericVerticalPattern = this.useGenericVerticalPattern;
        sourceEditDataTV.serviceAreaMode = this.serviceAreaMode;
        sourceEditDataTV.serviceAreaArg = this.serviceAreaArg;
        sourceEditDataTV.serviceAreaCL = this.serviceAreaCL;
        sourceEditDataTV.serviceAreaKey = this.serviceAreaKey;
        sourceEditDataTV.dtsTimeDelay = this.dtsTimeDelay;
        if (this.hasHorizontalPattern) {
            if (null == this.horizontalPattern && null != this.source) {
                this.horizontalPattern = this.source.getHorizontalPattern(errorLogger);
            }
            if (null != this.horizontalPattern) {
                sourceEditDataTV.hasHorizontalPattern = true;
                sourceEditDataTV.horizontalPattern = this.horizontalPattern.copy();
                sourceEditDataTV.horizontalPatternChanged = true;
            }
        }
        if (this.hasVerticalPattern) {
            if (null == this.verticalPattern && null != this.source) {
                this.verticalPattern = this.source.getVerticalPattern(errorLogger);
            }
            if (null != this.verticalPattern) {
                sourceEditDataTV.hasVerticalPattern = true;
                sourceEditDataTV.verticalPattern = this.verticalPattern.copy();
                sourceEditDataTV.verticalPatternChanged = true;
            }
        }
        if (this.hasMatrixPattern) {
            if (null == this.matrixPattern && null != this.source) {
                this.matrixPattern = this.source.getMatrixPattern(errorLogger);
            }
            if (null != this.matrixPattern) {
                sourceEditDataTV.hasMatrixPattern = true;
                sourceEditDataTV.matrixPattern = this.matrixPattern.copy();
                sourceEditDataTV.matrixPatternChanged = true;
            }
        }
        if (null != sourceEditDataTV2) {
            return sourceEditDataTV2;
        }
        if (sourceEditDataTV.isParent && this.isParent) {
            sourceEditDataTV.dtsSources = new TreeMap();
            sourceEditDataTV.addedDTSSourceKeys = new HashSet();
            for (SourceEditDataTV sourceEditDataTV3 : this.dtsSources.values()) {
                SourceEditDataTV sourceEditDataTV4 = 0 == sourceEditDataTV3.siteNumber ? sourceEditDataTV3.deriveSourceTV(studyEditData, string, n, sourceEditDataTV3.service, sourceEditDataTV3.isDRT, country, bl2, n2, n3, string2, sourceEditDataTV.key, errorLogger) : sourceEditDataTV3.deriveSourceTV(studyEditData, string, n, service, bl, country, bl2, n2, n3, string2, sourceEditDataTV.key, errorLogger);
                if (null == sourceEditDataTV4) {
                    return null;
                }
                sourceEditDataTV.dtsSources.put(sourceEditDataTV4.key, sourceEditDataTV4);
                sourceEditDataTV.addedDTSSourceKeys.add(sourceEditDataTV4.key);
            }
            sourceEditDataTV.deletedDTSSourceKeys = new HashSet();
            sourceEditDataTV.changedDTSSources = new ArrayList();
        }
        return sourceEditDataTV;
    }

    public SourceEditDataTV replicate(int n) {
        return this.replicate(n, null);
    }

    public SourceEditDataTV replicate(int n, ErrorLogger errorLogger) {
        if (null == this.study || null != this.originalSourceKey || null != this.parentSourceKey) {
            if (null != errorLogger) {
                errorLogger.reportError("The record replication cannot be performed");
            }
            return null;
        }
        if (this.service.serviceType.digital && n == this.channel) {
            if (null != errorLogger) {
                errorLogger.reportError("The replication channel must be different");
            }
            return null;
        }
        return this.replicate(n, null, errorLogger);
    }

    private SourceEditDataTV replicate(int n, Integer n2, ErrorLogger errorLogger) {
        Integer n3 = this.study.getNewSourceKey();
        if (null == n3) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create new record, no keys available");
            }
            return null;
        }
        Service service = this.service;
        SignalType signalType = this.signalType;
        FrequencyOffset frequencyOffset = this.frequencyOffset;
        EmissionMask emissionMask = this.emissionMask;
        if (!service.serviceType.digital) {
            service = this.service.digitalService;
            if (null == service) {
                if (null != errorLogger) {
                    errorLogger.reportError("Unable to replicate, no equivalent digital service exists");
                }
                return null;
            }
            signalType = SignalType.getDefaultObject();
            frequencyOffset = FrequencyOffset.getNullObject();
            emissionMask = service.serviceType.needsEmissionMask ? EmissionMask.getDefaultObject() : EmissionMask.getNullObject();
        }
        SourceEditDataTV sourceEditDataTV = new SourceEditDataTV(this.study, this.dbID, n3, this.facilityID, service, this.isDRT, this.country, true, this.userRecordID, this.extDbKey, this.extRecordID, this.key, n2, this.isParent);
        sourceEditDataTV.callSign = this.callSign;
        sourceEditDataTV.channel = n;
        sourceEditDataTV.city = this.city;
        sourceEditDataTV.state = this.state;
        sourceEditDataTV.zone = this.zone;
        sourceEditDataTV.status = this.status;
        sourceEditDataTV.statusType = this.statusType;
        sourceEditDataTV.fileNumber = this.fileNumber;
        sourceEditDataTV.appARN = this.appARN;
        sourceEditDataTV.signalType = signalType;
        sourceEditDataTV.frequencyOffset = frequencyOffset;
        sourceEditDataTV.emissionMask = emissionMask;
        sourceEditDataTV.location.setLatLon(this.location);
        sourceEditDataTV.dtsMaximumDistance = this.dtsMaximumDistance;
        sourceEditDataTV.dtsSectors = this.dtsSectors;
        sourceEditDataTV.heightAMSL = this.heightAMSL;
        sourceEditDataTV.overallHAAT = this.overallHAAT;
        sourceEditDataTV.peakERP = 0.001;
        sourceEditDataTV.antennaID = null;
        sourceEditDataTV.hasHorizontalPattern = false;
        sourceEditDataTV.horizontalPattern = null;
        sourceEditDataTV.horizontalPatternChanged = false;
        sourceEditDataTV.horizontalPatternOrientation = 0.0;
        if (null != this.attributes.get("isBaseline")) {
            if (this.hasVerticalPattern) {
                if (null == this.verticalPattern && null != this.source) {
                    this.verticalPattern = this.source.getVerticalPattern(errorLogger);
                }
                if (null != this.verticalPattern) {
                    sourceEditDataTV.hasVerticalPattern = true;
                    sourceEditDataTV.verticalPattern = this.verticalPattern.copy();
                    sourceEditDataTV.verticalPatternChanged = true;
                }
            }
            if (this.hasMatrixPattern) {
                if (null == this.matrixPattern && null != this.source) {
                    this.matrixPattern = this.source.getMatrixPattern(errorLogger);
                }
                if (null != this.matrixPattern) {
                    sourceEditDataTV.hasMatrixPattern = true;
                    sourceEditDataTV.matrixPattern = this.matrixPattern.copy();
                    sourceEditDataTV.matrixPatternChanged = true;
                }
            }
        } else {
            sourceEditDataTV.hasVerticalPattern = false;
            sourceEditDataTV.verticalPattern = null;
            sourceEditDataTV.verticalPatternChanged = false;
            sourceEditDataTV.hasMatrixPattern = false;
            sourceEditDataTV.matrixPattern = null;
            sourceEditDataTV.matrixPatternChanged = false;
        }
        sourceEditDataTV.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditDataTV.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditDataTV.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        sourceEditDataTV.useGenericVerticalPattern = this.useGenericVerticalPattern;
        sourceEditDataTV.siteNumber = this.siteNumber;
        sourceEditDataTV.serviceAreaMode = this.serviceAreaMode;
        sourceEditDataTV.serviceAreaArg = this.serviceAreaArg;
        sourceEditDataTV.serviceAreaCL = this.serviceAreaCL;
        sourceEditDataTV.serviceAreaKey = this.serviceAreaKey;
        sourceEditDataTV.dtsTimeDelay = this.dtsTimeDelay;
        sourceEditDataTV.setAllAttributes(this.attributes);
        sourceEditDataTV.removeAttribute("frequency");
        if (this.isParent) {
            sourceEditDataTV.dtsSources = new TreeMap();
            sourceEditDataTV.addedDTSSourceKeys = new HashSet();
            for (SourceEditDataTV sourceEditDataTV2 : this.dtsSources.values()) {
                SourceEditDataTV sourceEditDataTV3 = 0 == sourceEditDataTV2.siteNumber ? sourceEditDataTV2.deriveSourceTV(this.study, this.study.dbID, sourceEditDataTV2.facilityID, sourceEditDataTV2.service, sourceEditDataTV2.isDRT, sourceEditDataTV2.country, true, sourceEditDataTV2.userRecordID, sourceEditDataTV2.extDbKey, sourceEditDataTV2.extRecordID, n3, errorLogger) : sourceEditDataTV2.replicate(n, n3, errorLogger);
                if (null == sourceEditDataTV3) {
                    return null;
                }
                sourceEditDataTV.dtsSources.put(sourceEditDataTV3.key, sourceEditDataTV3);
                sourceEditDataTV.addedDTSSourceKeys.add(sourceEditDataTV3.key);
            }
            sourceEditDataTV.deletedDTSSourceKeys = new HashSet();
            sourceEditDataTV.changedDTSSources = new ArrayList();
        }
        return sourceEditDataTV;
    }

    public SourceEditDataTV createDTSSource(int n) {
        return this.createDTSSource(n, null, null);
    }

    public SourceEditDataTV createDTSSource(int n, ErrorLogger errorLogger) {
        return this.createDTSSource(n, null, errorLogger);
    }

    public SourceEditDataTV createDTSSource(int n, Service service) {
        return this.createDTSSource(n, service, null);
    }

    /*
     * WARNING - void declaration
     */
    public SourceEditDataTV createDTSSource(int n, Service service, ErrorLogger errorLogger) {
        void var5_8;
        if (!this.isParent) {
            if (null != errorLogger) {
                errorLogger.reportError("SourceEditDataTV.createDTSSource() called on non-parent source");
            }
            return null;
        }
        if (this.isLocked) {
            if (null != errorLogger) {
                errorLogger.reportError("SourceEditDataTV.createDTSSource() called on locked source");
            }
            return null;
        }
        if (0 == n) {
            for (SourceEditDataTV object2 : this.dtsSources.values()) {
                if (0 != object2.siteNumber) continue;
                if (null != errorLogger) {
                    errorLogger.reportError("DTS parent source already has an authorized facility");
                }
                return null;
            }
        }
        Object object3 = this.userRecordID;
        Integer n2 = this.extDbKey;
        String string = this.extRecordID;
        if (0 == n) {
            if ((null == service || service.key < 1 || service.isDTS) && null == (service = Service.getService("DT"))) {
                if (null != errorLogger) {
                    errorLogger.reportError("SourceEditDataTV.createDTSSource() could not load service record");
                }
                return null;
            }
            object3 = null;
            Object var5_7 = null;
            string = null;
        } else {
            service = this.service;
        }
        SourceEditDataTV sourceEditDataTV = SourceEditDataTV.createSource(this.study, this.dbID, this.facilityID, service, false, this.country, false, (Integer)object3, (Integer)var5_8, string, this.key, errorLogger);
        if (null == sourceEditDataTV) {
            return null;
        }
        sourceEditDataTV.siteNumber = n;
        sourceEditDataTV.callSign = this.callSign;
        sourceEditDataTV.city = this.city;
        sourceEditDataTV.state = this.state;
        if (n > 0) {
            sourceEditDataTV.channel = this.channel;
            sourceEditDataTV.zone = this.zone;
            sourceEditDataTV.status = this.status;
            sourceEditDataTV.statusType = this.statusType;
            sourceEditDataTV.fileNumber = this.fileNumber;
            sourceEditDataTV.appARN = this.appARN;
            sourceEditDataTV.signalType = this.signalType;
            sourceEditDataTV.frequencyOffset = this.frequencyOffset;
            sourceEditDataTV.emissionMask = this.emissionMask;
            String string2 = this.getAttribute("frequency");
            if (string2 != null) {
                sourceEditDataTV.setAttribute("frequency", string2);
            }
        } else {
            sourceEditDataTV.serviceAreaMode = 1;
            sourceEditDataTV.serviceAreaCL = -999.0;
        }
        return sourceEditDataTV;
    }

    public int getNextDTSSiteNumber() {
        if (!this.isParent || this.dtsSources.isEmpty()) {
            return 0;
        }
        int n = 0;
        for (SourceEditDataTV sourceEditDataTV : this.dtsSources.values()) {
            if (sourceEditDataTV.siteNumber <= n) continue;
            n = sourceEditDataTV.siteNumber;
        }
        return n + 1;
    }

    public synchronized void addOrReplaceDTSSource(SourceEditDataTV sourceEditDataTV) {
        if (!this.isParent || !this.key.equals(sourceEditDataTV.parentSourceKey)) {
            return;
        }
        if (null == this.dtsSources.put(sourceEditDataTV.key, sourceEditDataTV) && !this.deletedDTSSourceKeys.remove(sourceEditDataTV.key)) {
            this.addedDTSSourceKeys.add(sourceEditDataTV.key);
        }
        this.dtsSourceListCache = null;
        this.dtsLocationListCache = null;
    }

    public synchronized void removeDTSSource(SourceEditDataTV sourceEditDataTV) {
        if (null != this.dtsSources.remove(sourceEditDataTV.key) && !this.addedDTSSourceKeys.remove(sourceEditDataTV.key)) {
            this.deletedDTSSourceKeys.add(sourceEditDataTV.key);
        }
        this.dtsSourceListCache = null;
        this.dtsLocationListCache = null;
    }

    public ArrayList<SourceEditDataTV> getDTSSources() {
        if (null == this.dtsSources) {
            return null;
        }
        if (null == this.dtsSourceListCache) {
            this.dtsSourceListCache = new ArrayList<SourceEditDataTV>(this.dtsSources.values());
        }
        return this.dtsSourceListCache;
    }

    public ArrayList<GeoPoint> getDTSLocations() {
        if (null == this.dtsSources) {
            return null;
        }
        if (null == this.dtsLocationListCache) {
            this.dtsLocationListCache = new ArrayList();
            for (SourceEditDataTV sourceEditDataTV : this.getDTSSources()) {
                if (sourceEditDataTV.siteNumber <= 0) continue;
                this.dtsLocationListCache.add(sourceEditDataTV.location);
            }
        }
        return this.dtsLocationListCache;
    }

    @Override
    public boolean isGeographyInUse(int n) {
        return (5 == this.serviceAreaMode || 6 == this.serviceAreaMode) && n == this.serviceAreaKey;
    }

    @Override
    public int getGeographyKey() {
        if (5 == this.serviceAreaMode || 6 == this.serviceAreaMode) {
            return this.serviceAreaKey;
        }
        return 0;
    }

    @Override
    public boolean isDataValid(ErrorLogger errorLogger) {
        int n;
        int n2;
        if (this.isLocked && null != this.source) {
            return true;
        }
        if (this.service.serviceType.digital) {
            if (0 == this.signalType.key) {
                this.signalType = SignalType.getDefaultObject();
            }
        } else if (this.signalType.key != 0) {
            this.signalType = SignalType.getNullObject();
        }
        if (this.service.serviceType.needsEmissionMask) {
            if (0 == this.emissionMask.key) {
                this.emissionMask = EmissionMask.getInvalidObject();
            }
        } else if (this.emissionMask.key != 0) {
            this.emissionMask = EmissionMask.getNullObject();
        }
        if (null == this.study || null != this.parentSourceKey && 0 == this.siteNumber) {
            if (this.channel < 2 || this.channel > 69) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad channel, must be 2 to 69");
                }
                return false;
            }
        } else {
            n2 = this.study.getMinimumChannel();
            n = this.study.getMaximumChannel();
            if (this.channel < n2 || this.channel > n) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad channel, must be " + n2 + " to " + n);
                }
                return false;
            }
        }
        if (0 == this.city.length()) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A city name must be provided");
            }
            return false;
        }
        if (0 == this.state.length()) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A state code must be provided");
            }
            return false;
        }
        if (this.zone.key < 0 || 0 == this.zone.key && 1 == this.country.key && this.service.isFullService() && null == this.getAttribute("isBaseline")) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A zone must be selected");
            }
            return false;
        }
        if (this.signalType.key < 0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A signal type must be selected");
            }
            return false;
        }
        if (this.emissionMask.key < 0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("An emission mask must be selected");
            }
            return false;
        }
        if (this.isParent && this.service.isFullService()) {
            String string;
            if (this.dtsMaximumDistance != 0.0 && (this.dtsMaximumDistance < 50.0 || this.dtsMaximumDistance > 200.0)) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad DTS boundary distance, must be 50.0 to 200.0");
                }
                return false;
            }
            if (this.dtsSectors.length() > 0 && null != (string = GeoSectors.validateString(this.dtsSectors))) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad DTS boundary: " + string);
                }
                return false;
            }
        }
        if (this.siteNumber < 0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad site number, must be >= 0");
            }
            return false;
        }
        if ((2 == this.serviceAreaMode || 3 == this.serviceAreaMode || 4 == this.serviceAreaMode) && (this.serviceAreaArg < 0.0 || this.serviceAreaArg > 500.0)) {
            errorLogger.reportValidationError("Bad contour mode argument, must be 0.0 to 500.0");
            return false;
        }
        if ((0 == this.serviceAreaMode || 1 == this.serviceAreaMode || 2 == this.serviceAreaMode || 3 == this.serviceAreaMode || 4 == this.serviceAreaMode || 11 == this.serviceAreaMode) && this.serviceAreaCL != -999.0 && (this.serviceAreaCL < 0.0 || this.serviceAreaCL > 120.0)) {
            errorLogger.reportValidationError("Bad contour level, must be 0.0 to 120.0");
            return false;
        }
        if ((5 == this.serviceAreaMode || 6 == this.serviceAreaMode) && this.serviceAreaKey <= 0) {
            errorLogger.reportValidationError("Bad or missing service area geography");
            return false;
        }
        if (null != this.parentSourceKey && this.siteNumber > 0 && (this.dtsTimeDelay < -500.0 || this.dtsTimeDelay > 500.0)) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad DTS time delay, must be -500.0 to 500.0");
            }
            return false;
        }
        if (!super.isDataValid(errorLogger)) {
            return false;
        }
        if (this.isParent) {
            if (0 != this.siteNumber) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad site number for DTS parent, must be 0");
                }
                return false;
            }
            n2 = 0;
            n = 0;
            for (SourceEditDataTV sourceEditDataTV : this.dtsSources.values()) {
                if (!sourceEditDataTV.isDataValid(errorLogger)) {
                    return false;
                }
                if (0 == sourceEditDataTV.siteNumber) {
                    if (n2 != 0) {
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Multiple authorized facilities (site number 0) for DTS parent");
                        }
                        return false;
                    }
                    n2 = 1;
                    continue;
                }
                n = 1;
            }
            if (n2 == 0) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("DTS parent must have an authorized facility");
                }
                return false;
            }
            if (n == 0) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("DTS parent must have at least one transmitter site");
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isDataChanged() {
        if (null == this.source) {
            if (this.isParent) {
                this.changedDTSSources.clear();
                this.changedDTSSources.addAll(this.dtsSources.values());
            }
            return true;
        }
        if (super.isDataChanged()) {
            return true;
        }
        if (this.isLocked) {
            return false;
        }
        if (this.isParent) {
            boolean bl = false;
            this.changedDTSSources.clear();
            for (SourceEditDataTV sourceEditDataTV : this.dtsSources.values()) {
                if (!sourceEditDataTV.isDataChanged() && !this.addedDTSSourceKeys.contains(sourceEditDataTV.key)) continue;
                this.changedDTSSources.add(sourceEditDataTV);
                bl = true;
            }
            if (bl) {
                return true;
            }
            if (!this.deletedDTSSourceKeys.isEmpty()) {
                return true;
            }
        }
        if (this.facilityID != this.source.facilityID) {
            return true;
        }
        if (this.channel != this.source.channel) {
            return true;
        }
        if (this.zone.key != this.source.zone.key) {
            return true;
        }
        if (!this.status.equals(this.source.status)) {
            return true;
        }
        if (this.signalType.key != this.source.signalType.key) {
            return true;
        }
        if (this.frequencyOffset.key != this.source.frequencyOffset.key) {
            return true;
        }
        if (this.emissionMask.key != this.source.emissionMask.key) {
            return true;
        }
        if (this.dtsMaximumDistance != this.source.dtsMaximumDistance) {
            return true;
        }
        if (!this.dtsSectors.equals(this.source.dtsSectors)) {
            return true;
        }
        if (this.siteNumber != this.source.siteNumber) {
            return true;
        }
        if (this.serviceAreaMode != this.source.serviceAreaMode) {
            return true;
        }
        if (this.serviceAreaArg != this.source.serviceAreaArg) {
            return true;
        }
        if (this.serviceAreaCL != this.source.serviceAreaCL) {
            return true;
        }
        if ((5 == this.serviceAreaMode || 6 == this.serviceAreaMode) && this.serviceAreaKey != this.source.serviceAreaKey) {
            return true;
        }
        return this.dtsTimeDelay != this.source.dtsTimeDelay;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void save(DbConnection dbConnection) throws SQLException {
        void var3_8;
        if (this.isParent) {
            if (!this.deletedDTSSourceKeys.isEmpty()) {
                String string = DbConnection.makeKeyList(this.deletedDTSSourceKeys);
                dbConnection.update("DELETE FROM source_horizontal_pattern WHERE source_key IN " + (String)string);
                dbConnection.update("DELETE FROM source_vertical_pattern WHERE source_key IN " + (String)string);
                dbConnection.update("DELETE FROM source_matrix_pattern WHERE source_key IN " + (String)string);
                dbConnection.update("DELETE FROM source WHERE source_key IN " + (String)string);
            }
            for (SourceEditDataTV object2 : this.changedDTSSources) {
                object2.save(dbConnection);
            }
        }
        dbConnection.update("DELETE FROM source WHERE source_key=" + this.key);
        int n = 0;
        if (null != this.source && null == this.parentSourceKey) {
            n = this.source.modCount + 1;
        }
        String string = "";
        if (this.hasHorizontalPattern) {
            if (null != this.horizontalPattern) {
                String string2 = this.horizontalPattern.name;
            } else if (null != this.source) {
                String string3 = this.source.horizontalPatternName;
            }
        }
        String string4 = "";
        if (this.hasVerticalPattern) {
            if (null != this.verticalPattern) {
                string4 = this.verticalPattern.name;
            } else if (null != this.source) {
                string4 = this.source.verticalPatternName;
            }
        }
        String string5 = "";
        if (this.hasMatrixPattern) {
            if (null != this.matrixPattern) {
                string5 = this.matrixPattern.name;
            } else if (null != this.source) {
                string5 = this.source.matrixPatternName;
            }
        }
        int n2 = 0;
        if (5 == this.serviceAreaMode || 6 == this.serviceAreaMode) {
            n2 = this.serviceAreaKey;
        }
        String string6 = this.getAllAttributes();
        dbConnection.update("INSERT INTO source (source_key,record_type,needs_update,mod_count,facility_id,service_key,is_drt,is_iboc,station_class,call_sign,sector_id,channel,city,state,country_key,zone_key,status,file_number,signal_type_key,frequency_offset_key,emission_mask_key,latitude,longitude,dts_maximum_distance,dts_sectors,height_amsl,actual_height_amsl,height_agl,overall_haat,actual_overall_haat,peak_erp,contour_erp,iboc_fraction,antenna_id,has_horizontal_pattern,horizontal_pattern_name,horizontal_pattern_orientation,has_vertical_pattern,vertical_pattern_name,vertical_pattern_electrical_tilt,vertical_pattern_mechanical_tilt,vertical_pattern_mechanical_tilt_orientation,has_matrix_pattern,matrix_pattern_name,use_generic_vertical_pattern,site_number,locked,user_record_id,ext_db_key,ext_record_id,original_source_key,parent_source_key,service_area_mode,service_area_arg,service_area_cl,service_area_key,dts_time_delay,attributes) VALUES (" + this.key + "," + this.recordType + ",true," + n + "," + this.facilityID + "," + this.service.key + "," + this.isDRT + ",false,0,'" + DbConnection.clean(this.callSign) + "',''," + this.channel + ",'" + DbConnection.clean(this.city) + "','" + DbConnection.clean(this.state) + "'," + this.country.key + "," + this.zone.key + ",'" + DbConnection.clean(this.status) + "','" + DbConnection.clean(this.fileNumber) + "'," + this.signalType.key + "," + this.frequencyOffset.key + "," + this.emissionMask.key + "," + this.location.latitude + "," + this.location.longitude + "," + this.dtsMaximumDistance + ",'" + DbConnection.clean(this.dtsSectors.trim()) + "'," + this.heightAMSL + "," + this.heightAMSL + ",0," + this.overallHAAT + "," + this.overallHAAT + "," + this.peakERP + "," + 10.0 * Math.log10(this.peakERP) + ",0.," + (null == this.antennaID ? "null" : "'" + DbConnection.clean(this.antennaID) + "'") + "," + this.hasHorizontalPattern + ",'" + DbConnection.clean((String)var3_8) + "'," + this.horizontalPatternOrientation + "," + this.hasVerticalPattern + ",'" + DbConnection.clean(string4) + "'," + this.verticalPatternElectricalTilt + "," + this.verticalPatternMechanicalTilt + "," + this.verticalPatternMechanicalTiltOrientation + "," + this.hasMatrixPattern + ",'" + DbConnection.clean(string5) + "'," + this.useGenericVerticalPattern + "," + this.siteNumber + "," + this.isLocked + "," + (null == this.userRecordID ? "0" : this.userRecordID) + "," + (null == this.extDbKey ? "0" : this.extDbKey) + "," + (null == this.extRecordID ? "null" : "'" + DbConnection.clean(this.extRecordID) + "'") + "," + (null == this.originalSourceKey ? "0" : this.originalSourceKey) + "," + (null == this.parentSourceKey ? "0" : this.parentSourceKey) + "," + this.serviceAreaMode + "," + this.serviceAreaArg + "," + this.serviceAreaCL + "," + n2 + "," + this.dtsTimeDelay + ",'" + DbConnection.clean(string6) + "')");
        this.savePatterns(dbConnection);
        ArrayList<SourceTV> arrayList = null;
        if (this.isParent) {
            arrayList = new ArrayList<SourceTV>();
            for (SourceEditDataTV sourceEditDataTV : this.dtsSources.values()) {
                arrayList.add(sourceEditDataTV.source);
            }
        }
        this.source = new SourceTV(this.dbID, dbConnection.getDatabase(), this.key, this.facilityID, this.service, this.isDRT, this.callSign, this.channel, this.city, this.state, this.country, this.zone, this.status, this.fileNumber, this.signalType, this.frequencyOffset, this.emissionMask, this.location.latitude, this.location.longitude, this.dtsMaximumDistance, this.dtsSectors, this.heightAMSL, this.heightAMSL, this.overallHAAT, this.overallHAAT, this.peakERP, this.antennaID, this.hasHorizontalPattern, (String)var3_8, this.horizontalPatternOrientation, this.hasVerticalPattern, string4, this.verticalPatternElectricalTilt, this.verticalPatternMechanicalTilt, this.verticalPatternMechanicalTiltOrientation, this.hasMatrixPattern, string5, this.useGenericVerticalPattern, this.siteNumber, this.isLocked, this.userRecordID, this.extDbKey, this.extRecordID, this.originalSourceKey, this.parentSourceKey, arrayList, n, this.serviceAreaMode, this.serviceAreaArg, this.serviceAreaCL, n2, this.dtsTimeDelay, string6);
        if (this.isParent) {
            this.addedDTSSourceKeys.clear();
            this.deletedDTSSourceKeys.clear();
            this.changedDTSSources.clear();
        }
        this.horizontalPatternChanged = false;
        this.verticalPatternChanged = false;
        this.matrixPatternChanged = false;
        this.attributesChanged = false;
    }

    public static boolean isExtDbSupported(ExtDb extDb) {
        return SourceEditData.isExtDbSupported(extDb) && extDb.canProvide(1);
    }

    public static int addRecords(ExtDb extDb, ScenarioEditData scenarioEditData, int n, String string, GeoPoint geoPoint, double d, int n2, int n3, boolean bl, boolean bl2, boolean bl3, ErrorLogger errorLogger) {
        Object object;
        int n4;
        Object object2;
        Cloneable cloneable;
        int n5 = scenarioEditData.study.study.studyType;
        if (!SourceEditDataTV.isExtDbSupported(extDb) || !Study.isRecordTypeAllowed(n5, 1) || (1 == n || 3 == n) && 1 != n5) {
            return 0;
        }
        double d2 = scenarioEditData.study.getCoChannelMxDistance();
        double d3 = scenarioEditData.study.getKilometersPerDegree();
        boolean bl4 = scenarioEditData.study.getCheckIndividualDTSDistance();
        int n6 = scenarioEditData.study.getMinimumChannel();
        int n7 = scenarioEditData.study.getMaximumChannel();
        if (n2 > n6) {
            n6 = n2;
        }
        if (n3 > 0 && n3 < n7) {
            n7 = n3;
        }
        if (n6 > n7) {
            return 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl5 = false;
        if (null != string && string.length() > 0) {
            stringBuilder.append(string);
            bl5 = true;
        }
        ArrayList<SourceEditData> arrayList = null;
        Collection collection = null;
        if (1 == n) {
            try {
                SourceEditDataTV.addChannelRangeQuery(extDb.type, n6, n7, stringBuilder, bl5);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            if (3 == n) {
                arrayList = scenarioEditData.sourceData.getUndesiredSources(1);
                if (arrayList.isEmpty()) {
                    if (null != errorLogger) {
                        errorLogger.reportError("There are no undesired TV stations in the scenario");
                    }
                    return -1;
                }
            } else {
                arrayList = scenarioEditData.sourceData.getDesiredSources(1);
                if (arrayList.isEmpty()) {
                    if (null != errorLogger) {
                        errorLogger.reportError("There are no desired TV stations in the scenario");
                    }
                    return -1;
                }
            }
            cloneable = new HashMap();
            for (IxRuleEditData ixRuleEditData : scenarioEditData.study.ixRuleData.getActiveRows()) {
                if (1 != ixRuleEditData.serviceType.recordType) continue;
                object2 = (SearchDelta)((HashMap)cloneable).get(ixRuleEditData.channelDelta.delta);
                if (null == object2) {
                    object2 = new SearchDelta();
                    ((SearchDelta)object2).delta = ixRuleEditData.channelDelta.delta;
                    ((SearchDelta)object2).analogOnly = ixRuleEditData.channelDelta.analogOnly;
                    ((SearchDelta)object2).maximumDistance = ixRuleEditData.distance;
                    ((HashMap)cloneable).put(((SearchDelta)object2).delta, object2);
                    continue;
                }
                if (!(ixRuleEditData.distance > ((SearchDelta)object2).maximumDistance)) continue;
                ((SearchDelta)object2).maximumDistance = ixRuleEditData.distance;
            }
            collection = ((HashMap)cloneable).values();
            int n8 = 0;
            int n9 = n7 - n6 + 1;
            boolean[] blArray = new boolean[n9];
            for (SourceEditData sourceEditData : arrayList) {
                SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
                for (SearchDelta searchDelta : collection) {
                    int n10;
                    int n11;
                    if (3 != n ? (n11 = (n10 = sourceEditDataTV.channel) + searchDelta.delta) < n6 || n11 > n7 || blArray[n4 = n11 - n6] : (n10 = (n11 = sourceEditDataTV.channel) - searchDelta.delta) < n6 || n10 > n7 || blArray[n4 = n10 - n6]) continue;
                    if (n10 < 5 ? n11 > 4 : (n10 < 7 ? n11 < 5 || n11 > 6 : (n10 < 14 ? n11 < 7 || n11 > 13 : n11 < 14))) continue;
                    blArray[n4] = true;
                    if (++n8 != n9) continue;
                    break;
                }
                if (n8 != n9) continue;
                break;
            }
            if (0 == n8) {
                return 0;
            }
            if (n8 < n9) {
                StringBuilder stringBuilder2 = new StringBuilder();
                int n12 = 40;
                for (n4 = 0; n4 < n9; ++n4) {
                    if (!blArray[n4]) continue;
                    stringBuilder2.append((char)n12);
                    stringBuilder2.append(String.valueOf(n4 + n6));
                    n12 = 44;
                }
                stringBuilder2.append(')');
                try {
                    SourceEditDataTV.addMultipleChannelQuery(extDb.type, stringBuilder2.toString(), stringBuilder, bl5);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                try {
                    SourceEditDataTV.addChannelRangeQuery(extDb.type, n6, n7, stringBuilder, bl5);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        cloneable = SourceEditDataTV.findImportRecords(extDb, 1, stringBuilder.toString(), geoPoint, d, d3, errorLogger);
        if (null == cloneable) {
            return -1;
        }
        if (((AbstractCollection)((Object)cloneable)).isEmpty()) {
            return 0;
        }
        SourceEditDataTV.removeAllMX(scenarioEditData, (LinkedList<SourceEditData>)cloneable, bl, bl2, d2, d3);
        if (2 == n5) {
            object2 = (SourceEditDataTV)scenarioEditData.sourceData.getDesiredSource(1);
            object = null;
            ScenarioEditData scenarioEditData2 = scenarioEditData.study.scenarioData.get(0);
            if (2 == scenarioEditData2.scenarioType) {
                for (SourceEditData sourceEditData : scenarioEditData2.sourceData.getSources(1)) {
                    if (null == sourceEditData.getAttribute("-isProposal")) continue;
                    object = (SourceEditDataTV)sourceEditData;
                    break;
                }
            }
            ListIterator listIterator = ((LinkedList)cloneable).listIterator(0);
            while (listIterator.hasNext()) {
                SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)listIterator.next();
                if ((null == object2 || !ExtDbRecordTV.areRecordsMX(sourceEditDataTV, (SourceEditDataTV)object2, true, 0.0, 0.0)) && (null == object || !ExtDbRecordTV.areRecordsMX(sourceEditDataTV, (SourceEditDataTV)object, true, 0.0, 0.0))) continue;
                listIterator.remove();
            }
        }
        if (1 != n) {
            object2 = ((LinkedList)cloneable).listIterator(0);
            while (object2.hasNext()) {
                object = (SourceEditDataTV)object2.next();
                boolean bl6 = true;
                for (SourceEditData sourceEditData : arrayList) {
                    Object object3;
                    Object object4;
                    if (3 == n) {
                        object4 = object;
                        object3 = (SourceEditDataTV)sourceEditData;
                    } else {
                        object4 = (SourceEditDataTV)sourceEditData;
                        object3 = object;
                    }
                    n4 = ((SourceEditDataTV)object3).channel - ((SourceEditDataTV)object4).channel;
                    for (SearchDelta searchDelta : collection) {
                        double d4;
                        if (searchDelta.delta != n4 || searchDelta.analogOnly && ((SourceEditDataTV)object4).service.serviceType.digital) continue;
                        if (((SourceEditDataTV)object4).channel < 5) {
                            if (((SourceEditDataTV)object3).channel > 4) {
                                continue;
                            }
                        } else if (((SourceEditDataTV)object4).channel < 7) {
                            if (((SourceEditDataTV)object3).channel < 5 || ((SourceEditDataTV)object3).channel > 6) {
                                continue;
                            }
                        } else if (((SourceEditDataTV)object4).channel >= 14 ? ((SourceEditDataTV)object3).channel < 14 : ((SourceEditDataTV)object3).channel < 7 || ((SourceEditDataTV)object3).channel > 13) continue;
                        if (((SourceEditDataTV)object4).isParent) {
                            for (SourceEditDataTV sourceEditDataTV : ((SourceEditDataTV)object4).getDTSSources()) {
                                if (sourceEditDataTV.siteNumber <= 0) continue;
                                d4 = searchDelta.maximumDistance + SourceEditDataTV.getRuleExtraDistance(scenarioEditData.study, sourceEditDataTV.service, false, sourceEditDataTV.country, sourceEditDataTV.channel, sourceEditDataTV.peakERP);
                                if (((SourceEditDataTV)object3).isParent && bl4) {
                                    for (GeoPoint geoPoint2 : ((SourceEditDataTV)object3).getDTSLocations()) {
                                        if (!(sourceEditDataTV.location.distanceTo(geoPoint2, d3) <= d4)) continue;
                                        bl6 = false;
                                        break;
                                    }
                                    if (bl6) continue;
                                } else {
                                    if (!(sourceEditDataTV.location.distanceTo(((SourceEditDataTV)object3).location, d3) <= d4)) continue;
                                    bl6 = false;
                                }
                                break;
                            }
                        } else {
                            d4 = searchDelta.maximumDistance + SourceEditDataTV.getRuleExtraDistance(scenarioEditData.study, ((SourceEditDataTV)object4).service, false, ((SourceEditDataTV)object4).country, ((SourceEditDataTV)object4).channel, ((SourceEditDataTV)object4).peakERP);
                            if (((SourceEditDataTV)object3).isParent && bl4) {
                                for (GeoPoint geoPoint3 : ((SourceEditDataTV)object3).getDTSLocations()) {
                                    if (!(((SourceEditDataTV)object4).location.distanceTo(geoPoint3, d3) <= d4)) continue;
                                    bl6 = false;
                                    break;
                                }
                            } else if (((SourceEditDataTV)object4).location.distanceTo(((SourceEditDataTV)object3).location, d3) <= d4) {
                                bl6 = false;
                            }
                        }
                        if (bl6) continue;
                        break;
                    }
                    if (bl6) continue;
                    break;
                }
                if (!bl6) continue;
                object2.remove();
            }
        }
        object = new ArrayList();
        Iterator iterator = ((AbstractSequentialList)((Object)cloneable)).iterator();
        while (iterator.hasNext()) {
            SourceEditData sourceEditData = (SourceEditData)iterator.next();
            object2 = scenarioEditData.study.findSharedSource(sourceEditData.extDbKey, sourceEditData.extRecordID);
            if (null == object2 && null == (object2 = sourceEditData.deriveSource(scenarioEditData.study, true, errorLogger))) {
                return -1;
            }
            ((ArrayList)object).add(object2);
        }
        boolean bl7 = true;
        boolean bl8 = true;
        if (1 == n || 3 == n) {
            bl8 = bl ? false : bl3;
        } else {
            bl7 = false;
            if (bl && 2 != n5) {
                bl8 = false;
            }
        }
        Iterator iterator2 = ((ArrayList)object).iterator();
        while (iterator2.hasNext()) {
            SourceEditData sourceEditData = (SourceEditData)iterator2.next();
            scenarioEditData.sourceData.addOrReplace(sourceEditData, bl7, bl8);
        }
        return ((ArrayList)object).size();
    }

    private static void removeAllMX(ScenarioEditData scenarioEditData, LinkedList<SourceEditData> linkedList, boolean bl, boolean bl2, double d, double d2) {
        SourceEditDataTV sourceEditDataTV;
        ArrayList<SourceEditData> arrayList = scenarioEditData.sourceData.getSources(1);
        ListIterator<SourceEditData> listIterator = linkedList.listIterator(0);
        block0: while (listIterator.hasNext()) {
            sourceEditDataTV = (SourceEditDataTV)listIterator.next();
            for (SourceEditData sourceEditData : arrayList) {
                SourceEditDataTV sourceEditDataTV2 = (SourceEditDataTV)sourceEditData;
                if ((!sourceEditDataTV.extDbKey.equals(sourceEditDataTV2.extDbKey) || !sourceEditDataTV.extRecordID.equals(sourceEditDataTV2.extRecordID)) && (bl || !ExtDbRecordTV.areRecordsMX(sourceEditDataTV, sourceEditDataTV2, bl2, d, d2))) continue;
                listIterator.remove();
                continue block0;
            }
        }
        if (bl) {
            return;
        }
        Comparator<SourceEditData> comparator = new Comparator<SourceEditData>(){

            @Override
            public int compare(SourceEditData sourceEditData, SourceEditData sourceEditData2) {
                if (((SourceEditDataTV)sourceEditData).isPreferredRecord((SourceEditDataTV)sourceEditData2)) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(linkedList, comparator);
        int n = linkedList.size() - 1;
        for (int i = 0; i < n; ++i) {
            sourceEditDataTV = (SourceEditDataTV)linkedList.get(i);
            listIterator = linkedList.listIterator(i + 1);
            while (listIterator.hasNext()) {
                if (!ExtDbRecordTV.areRecordsMX(sourceEditDataTV, (SourceEditDataTV)listIterator.next(), bl2, d, d2)) continue;
                listIterator.remove();
                --n;
            }
        }
    }

    private boolean isPreferredRecord(SourceEditDataTV sourceEditDataTV) {
        if (this.service.preferenceRank > sourceEditDataTV.service.preferenceRank) {
            return true;
        }
        if (this.service.preferenceRank < sourceEditDataTV.service.preferenceRank) {
            return false;
        }
        if (this.statusType < sourceEditDataTV.statusType) {
            return true;
        }
        if (this.statusType > sourceEditDataTV.statusType) {
            return false;
        }
        return this.extRecordID.compareTo(sourceEditDataTV.extRecordID) > 0;
    }

    public double getRuleExtraDistance() {
        return SourceEditDataTV.getRuleExtraDistance(this.study, this.service, this.isParent, this.country, this.channel, this.peakERP);
    }

    public static double getRuleExtraDistance(StudyEditData studyEditData, Service service, boolean bl, Country country, int n, double d) {
        double d2;
        int n2;
        double d3;
        if (null == studyEditData) {
            return 163.0;
        }
        if (studyEditData.getUseMaxRuleExtraDistance()) {
            return studyEditData.getMaximumDistance();
        }
        if (bl || d <= 0.0) {
            return 163.0;
        }
        int n3 = country.key - 1;
        if (n < 7) {
            switch (service.serviceType.key) {
                default: {
                    d3 = studyEditData.getContourVloDigital(n3);
                    n2 = studyEditData.getCurveSetDigital(n3);
                    break;
                }
                case 2: {
                    d3 = studyEditData.getContourVloAnalog(n3);
                    n2 = studyEditData.getCurveSetAnalog(n3);
                    break;
                }
                case 3: 
                case 5: {
                    d3 = studyEditData.getContourVloDigitalLPTV(n3);
                    n2 = studyEditData.getCurveSetDigital(n3);
                    break;
                }
                case 4: 
                case 6: {
                    d3 = studyEditData.getContourVloAnalogLPTV(n3);
                    n2 = studyEditData.getCurveSetAnalog(n3);
                    break;
                }
            }
        } else if (n < 14) {
            switch (service.serviceType.key) {
                default: {
                    d3 = studyEditData.getContourVhiDigital(n3);
                    n2 = studyEditData.getCurveSetDigital(n3);
                    break;
                }
                case 2: {
                    d3 = studyEditData.getContourVhiAnalog(n3);
                    n2 = studyEditData.getCurveSetAnalog(n3);
                    break;
                }
                case 3: 
                case 5: {
                    d3 = studyEditData.getContourVhiDigitalLPTV(n3);
                    n2 = studyEditData.getCurveSetDigital(n3);
                    break;
                }
                case 4: 
                case 6: {
                    d3 = studyEditData.getContourVhiAnalogLPTV(n3);
                    n2 = studyEditData.getCurveSetAnalog(n3);
                    break;
                }
            }
        } else {
            d2 = 0.0;
            if (studyEditData.getUseDipoleCont(n3)) {
                d2 = 20.0 * Math.log10((473.0 + (double)(n - 14) * 6.0) / studyEditData.getDipoleCenterFreqCont(n3));
            }
            switch (service.serviceType.key) {
                default: {
                    d3 = studyEditData.getContourUhfDigital(n3) + d2;
                    n2 = studyEditData.getCurveSetDigital(n3);
                    break;
                }
                case 2: {
                    d3 = studyEditData.getContourUhfAnalog(n3) + d2;
                    n2 = studyEditData.getCurveSetAnalog(n3);
                    break;
                }
                case 3: 
                case 5: {
                    d3 = studyEditData.getContourUhfDigitalLPTV(n3) + d2;
                    n2 = studyEditData.getCurveSetDigital(n3);
                    break;
                }
                case 4: 
                case 6: {
                    d3 = studyEditData.getContourUhfAnalogLPTV(n3) + d2;
                    n2 = studyEditData.getCurveSetAnalog(n3);
                }
            }
        }
        if (2 == n2) {
            return 300.0;
        }
        d2 = 10.0 * Math.log10(d) + (studyEditData.getContourUhfDigital(0) - d3);
        int n4 = studyEditData.getCurveSetDigital(0);
        if (3 == n4) {
            if (1 == n2) {
                d2 += 8.0;
            }
        } else if (1 == n4 && 3 == n2) {
            d2 -= 8.0;
        }
        if (d2 < studyEditData.getRuleExtraDistanceERPLow()) {
            return studyEditData.getRuleExtraDistanceLow();
        }
        if (d2 < studyEditData.getRuleExtraDistanceERPMedium()) {
            return studyEditData.getRuleExtraDistanceLowMedium();
        }
        if (d2 < studyEditData.getRuleExtraDistanceERPHigh()) {
            return studyEditData.getRuleExtraDistanceMediumHigh();
        }
        return studyEditData.getRuleExtraDistanceHigh();
    }

    @Override
    protected boolean writeToXML(Writer writer, boolean bl, boolean bl2, boolean bl3, ErrorLogger errorLogger) throws IOException {
        ExtDb extDb;
        Object object;
        SourceEditDataTV sourceEditDataTV = this;
        if (null != this.originalSourceKey) {
            if (null != this.study) {
                object = this.study.getSource(this.originalSourceKey);
                if (1 == ((SourceEditData)object).recordType) {
                    sourceEditDataTV = (SourceEditDataTV)object;
                }
            } else {
                sourceEditDataTV = null;
            }
            if (null == sourceEditDataTV) {
                if (null != errorLogger) {
                    errorLogger.reportError("An original record needed for replication does not exist");
                }
                return false;
            }
        }
        if (null != (object = sourceEditDataTV.extRecordID) && (null == (extDb = ExtDb.getExtDb(this.dbID, sourceEditDataTV.extDbKey, true)) || extDb.isGeneric())) {
            object = null;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (null == sourceEditDataTV.parentSourceKey) {
            if (!sourceEditDataTV.isDataValid(errorLogger)) {
                return false;
            }
            bl5 = sourceEditDataTV.isParent;
            bl4 = !bl5;
            writer.append("<SOURCE");
            if (bl) {
                writer.append(" LOCKED=\"false\"");
            } else {
                writer.append(" DESIRED=\"" + bl2 + "\"");
                writer.append(" UNDESIRED=\"" + bl3 + '\"');
                writer.append(" LOCKED=\"" + sourceEditDataTV.isLocked + '\"');
            }
            writer.append(" SERVICE=\"" + sourceEditDataTV.service.serviceCode + '\"');
            if (null != this.originalSourceKey) {
                writer.append(" REPLICATE=\"" + this.channel + '\"');
            }
        } else {
            if (sourceEditDataTV.isLocked && null != object && !bl) {
                return false;
            }
            if (0 == sourceEditDataTV.siteNumber) {
                bl6 = true;
            } else {
                bl7 = true;
            }
            writer.append("<DTS_SOURCE");
            if (bl6) {
                writer.append(" SERVICE=\"" + sourceEditDataTV.service.serviceCode + '\"');
            }
        }
        if ((bl4 || bl5 || bl6) && null != object && !bl) {
            writer.append(" RECORD_ID=\"" + (String)object + '\"');
            if ((bl4 || bl5) && sourceEditDataTV.isLocked) {
                writer.append("/>\n");
                return true;
            }
        }
        if (bl6 || bl7 || bl4 && sourceEditDataTV.siteNumber > 0) {
            writer.append(" SITE_NUMBER=\"" + sourceEditDataTV.siteNumber + '\"');
        }
        if (bl4 || bl5) {
            writer.append(" ID=\"" + sourceEditDataTV.facilityID + '\"');
            writer.append(" CALL_SIGN=\"" + AppCore.xmlclean(sourceEditDataTV.callSign) + '\"');
            writer.append(" CITY=\"" + AppCore.xmlclean(sourceEditDataTV.city) + '\"');
            writer.append(" STATE=\"" + AppCore.xmlclean(sourceEditDataTV.state) + '\"');
            writer.append(" COUNTRY=\"" + sourceEditDataTV.country.countryCode + '\"');
        }
        if (bl4 || bl5 || bl6) {
            if (sourceEditDataTV.isDRT) {
                writer.append(" DRT=\"true\"");
            }
            writer.append(" CHANNEL=\"" + sourceEditDataTV.channel + '\"');
            if (sourceEditDataTV.zone.key > 0) {
                writer.append(" ZONE=\"" + sourceEditDataTV.zone.zoneCode + '\"');
            }
            writer.append(" STATUS=\"" + sourceEditDataTV.status + '\"');
            writer.append(" FILE_NUMBER=\"" + AppCore.xmlclean(sourceEditDataTV.fileNumber) + '\"');
            if (sourceEditDataTV.signalType.key > 0) {
                writer.append(" MOD_TYPE=\"" + sourceEditDataTV.signalType.key + '\"');
            }
            if (sourceEditDataTV.frequencyOffset.key > 0) {
                writer.append(" OFFSET=\"" + sourceEditDataTV.frequencyOffset.frequencyOffsetCode + '\"');
            }
            if (sourceEditDataTV.service.serviceType.needsEmissionMask) {
                writer.append(" MASK=\"" + sourceEditDataTV.emissionMask.emissionMaskCode + '\"');
            }
        }
        if (bl5) {
            if (sourceEditDataTV.service.isFullService()) {
                sourceEditDataTV.location.writeAttributes(writer);
                if (sourceEditDataTV.dtsSectors.length() > 0) {
                    writer.append(" DTS_SECTORS=\"" + this.dtsSectors + '\"');
                } else if (sourceEditDataTV.dtsMaximumDistance > 0.0) {
                    writer.append(" DTS_MAXIMUM_DISTANCE=\"" + AppCore.formatDistance(sourceEditDataTV.dtsMaximumDistance) + '\"');
                }
            }
            writer.append(">\n");
            writer.append(AppCore.xmlclean(sourceEditDataTV.getAllAttributesNT()));
            for (SourceEditDataTV sourceEditDataTV2 : sourceEditDataTV.dtsSources.values()) {
                sourceEditDataTV2.writeToXML(writer, bl, bl2, bl3, errorLogger);
            }
        } else {
            if (bl7) {
                writer.append(" TIME_DELAY=\"" + AppCore.formatDecimal(sourceEditDataTV.dtsTimeDelay, 2) + '\"');
            }
            sourceEditDataTV.writeAttributes(writer, errorLogger);
        }
        if (bl4 || bl5) {
            writer.append("</SOURCE>\n");
        } else {
            writer.append("</DTS_SOURCE>\n");
        }
        return true;
    }

    protected static SourceEditDataTV makeSourceWithAttributesTV(String string, Attributes attributes, StudyEditData studyEditData, String string2, Service service, Country country, boolean bl, Integer n, Integer n2, String string3, ErrorLogger errorLogger) {
        SourceEditDataTV sourceEditDataTV;
        int n3 = 0;
        String string4 = attributes.getValue("ID");
        if (null != string4) {
            try {
                n3 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad ID attribute in " + string + " tag");
                }
                return null;
            }
        } else {
            if (null != errorLogger) {
                errorLogger.reportError("Missing ID attribute in " + string + " tag");
            }
            return null;
        }
        boolean bl2 = false;
        string4 = attributes.getValue("DRT");
        if (null != string4) {
            bl2 = Boolean.valueOf(string4);
        }
        if (null == (sourceEditDataTV = SourceEditDataTV.createSource(studyEditData, string2, n3, service, bl2, country, bl, n, n2, string3, null, errorLogger))) {
            return null;
        }
        if (!sourceEditDataTV.isParent && null != (string4 = attributes.getValue("SITE_NUMBER"))) {
            sourceEditDataTV.siteNumber = -1;
            try {
                sourceEditDataTV.siteNumber = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (sourceEditDataTV.siteNumber < 0) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad SITE_NUMBER attribute in " + string + " tag");
                }
                return null;
            }
        }
        if (!sourceEditDataTV.parseAttributesTV(string, attributes, errorLogger)) {
            return null;
        }
        return sourceEditDataTV;
    }

    protected static SourceEditDataTV makeExtSourceWithAttributesTV(String string, Attributes attributes, ExtDb extDb, Service service, Country country, ErrorLogger errorLogger) {
        SourceEditDataTV sourceEditDataTV;
        int n = 0;
        String string2 = attributes.getValue("ID");
        if (null != string2) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad ID attribute in " + string + " tag");
                }
                return null;
            }
        } else {
            if (null != errorLogger) {
                errorLogger.reportError("Missing ID attribute in " + string + " tag");
            }
            return null;
        }
        boolean bl = false;
        string2 = attributes.getValue("DRT");
        if (null != string2) {
            bl = Boolean.valueOf(string2);
        }
        if (null == (sourceEditDataTV = SourceEditDataTV.createExtSource(extDb, n, service, bl, country, null, errorLogger))) {
            return null;
        }
        if (!sourceEditDataTV.isParent && null != (string2 = attributes.getValue("SITE_NUMBER"))) {
            sourceEditDataTV.siteNumber = -1;
            try {
                sourceEditDataTV.siteNumber = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (sourceEditDataTV.siteNumber < 0) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad SITE_NUMBER attribute in " + string + " tag");
                }
                return null;
            }
        }
        if (!sourceEditDataTV.parseAttributesTV(string, attributes, errorLogger)) {
            return null;
        }
        return sourceEditDataTV;
    }

    public SourceEditDataTV addDTSSourceWithAttributes(String string, Attributes attributes) {
        return this.addDTSSourceWithAttributes(string, attributes, null, null);
    }

    public SourceEditDataTV addDTSSourceWithAttributes(String string, Attributes attributes, ErrorLogger errorLogger) {
        return this.addDTSSourceWithAttributes(string, attributes, null, errorLogger);
    }

    public SourceEditDataTV addDTSSourceWithAttributes(String string, Attributes attributes, ExtDb extDb) {
        return this.addDTSSourceWithAttributes(string, attributes, extDb, null);
    }

    public synchronized SourceEditDataTV addDTSSourceWithAttributes(String string, Attributes attributes, ExtDb extDb, ErrorLogger errorLogger) {
        if (!this.isParent) {
            if (null != errorLogger) {
                errorLogger.reportError("SourceEditDataTV.addDTSSourceWithAttributes() called on non-parent source");
            }
            return null;
        }
        int n = -1;
        String string2 = attributes.getValue("SITE_NUMBER");
        if (null != string2) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n < 0) {
            if (null != errorLogger) {
                errorLogger.reportError("Missing or bad SITE_NUMBER attribute in " + string + " tag");
            }
            return null;
        }
        Service service = this.service;
        Integer n2 = this.userRecordID;
        Integer n3 = this.extDbKey;
        String string3 = this.extRecordID;
        if (0 == n) {
            service = null;
            string2 = attributes.getValue("SERVICE");
            if (null != string2) {
                service = Service.getService(string2);
            }
            if (null == service) {
                if (null != errorLogger) {
                    errorLogger.reportError("Missing or bad SERVICE attribute in " + string + " tag");
                }
                return null;
            }
            n2 = null;
            if (null != this.extDbKey) {
                string3 = attributes.getValue("RECORD_ID");
                if (null == string3) {
                    string3 = attributes.getValue("CDBS_ID");
                }
                if (null == string3) {
                    n3 = null;
                }
            }
        }
        SourceEditDataTV sourceEditDataTV = null;
        sourceEditDataTV = null == extDb ? SourceEditDataTV.createSource(this.study, this.dbID, this.facilityID, service, false, this.country, this.isLocked, n2, n3, string3, this.key, errorLogger) : SourceEditDataTV.createExtSource(extDb, this.facilityID, service, false, this.country, this.key, errorLogger);
        if (null == sourceEditDataTV) {
            return null;
        }
        sourceEditDataTV.siteNumber = n;
        sourceEditDataTV.callSign = this.callSign;
        sourceEditDataTV.city = this.city;
        sourceEditDataTV.state = this.state;
        if (n > 0) {
            sourceEditDataTV.channel = this.channel;
            sourceEditDataTV.zone = this.zone;
            sourceEditDataTV.status = this.status;
            sourceEditDataTV.statusType = this.statusType;
            sourceEditDataTV.fileNumber = this.fileNumber;
            sourceEditDataTV.appARN = this.appARN;
            sourceEditDataTV.signalType = this.signalType;
            sourceEditDataTV.frequencyOffset = this.frequencyOffset;
            sourceEditDataTV.emissionMask = this.emissionMask;
        } else {
            sourceEditDataTV.serviceAreaMode = 1;
            sourceEditDataTV.serviceAreaCL = -999.0;
        }
        if (!sourceEditDataTV.parseAttributesTV(string, attributes, errorLogger)) {
            return null;
        }
        this.dtsSources.put(sourceEditDataTV.key, sourceEditDataTV);
        this.addedDTSSourceKeys.add(sourceEditDataTV.key);
        this.dtsSourceListCache = null;
        return sourceEditDataTV;
    }

    private boolean parseAttributesTV(String string, Attributes attributes, ErrorLogger errorLogger) {
        String string2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (null != this.parentSourceKey) {
            if (0 == this.siteNumber) {
                bl2 = true;
            } else {
                bl3 = true;
            }
        } else {
            boolean bl4 = bl = !this.isParent;
        }
        if (bl || this.isParent) {
            this.callSign = attributes.getValue("CALL_SIGN");
            if (null == this.callSign || 0 == this.callSign.length()) {
                if (null != errorLogger) {
                    errorLogger.reportError("Missing or bad CALL_SIGN attribute in " + string + " tag");
                }
                return false;
            }
            if (this.callSign.length() > 12) {
                this.callSign = this.callSign.substring(0, 12);
            }
            this.city = attributes.getValue("CITY");
            if (null == this.city || 0 == this.city.length()) {
                if (null != errorLogger) {
                    errorLogger.reportError("Missing or bad CITY attribute in " + string + " tag");
                }
                return false;
            }
            if (this.city.length() > 20) {
                this.city = this.city.substring(0, 20);
            }
            this.state = attributes.getValue("STATE");
            if (null == this.state || 0 == this.state.length()) {
                if (null != errorLogger) {
                    errorLogger.reportError("Missing or bad STATE attribute in " + string + " tag");
                }
                return false;
            }
            if (this.state.length() > 2) {
                this.state = this.state.substring(0, 2);
            }
        }
        if (bl || this.isParent || bl2) {
            string2 = attributes.getValue("CHANNEL");
            if (null != string2) {
                try {
                    this.channel = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.channel < 2 || this.channel > 69) {
                if (null != errorLogger) {
                    errorLogger.reportError("Missing or bad CHANNEL attribute in " + string + " tag");
                }
                return false;
            }
            string2 = attributes.getValue("ZONE");
            if (null != string2) {
                this.zone = Zone.getZone(string2);
                if (this.zone.key < 1) {
                    if (null != errorLogger) {
                        errorLogger.reportError("Bad ZONE attribute in " + string + " tag");
                    }
                    return false;
                }
            }
            if (null != (string2 = attributes.getValue("STATUS"))) {
                this.status = string2;
                this.statusType = ExtDbRecord.getStatusType(string2);
                if (4 != this.statusType) {
                    this.status = ExtDbRecord.STATUS_CODES[this.statusType];
                }
                if (this.status.length() > 6) {
                    this.status = this.status.substring(0, 6);
                }
            }
            if (null != (string2 = attributes.getValue("FILE_NUMBER"))) {
                if (string2.length() > 255) {
                    string2 = string2.substring(0, 255);
                }
                this.fileNumber = string2;
                this.appARN = ExtDbRecord.parseFileNumber(string2)[1];
            }
            if (this.service.serviceType.digital) {
                string2 = attributes.getValue("MOD_TYPE");
                if (null == string2) {
                    this.signalType = SignalType.getDefaultObject();
                } else {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.signalType = SignalType.getSignalType(n);
                    if (this.signalType.key < 1) {
                        if (null != errorLogger) {
                            errorLogger.reportError("Bad MOD_TYPE attribute in " + string + " tag");
                        }
                        return false;
                    }
                }
            }
            if (null != (string2 = attributes.getValue("OFFSET"))) {
                this.frequencyOffset = FrequencyOffset.getFrequencyOffset(string2);
                if (this.frequencyOffset.key < 1) {
                    if (null != errorLogger) {
                        errorLogger.reportError("Bad OFFSET attribute in " + string + " tag");
                    }
                    return false;
                }
            }
            if (this.service.serviceType.needsEmissionMask) {
                string2 = attributes.getValue("MASK");
                if (null != string2) {
                    this.emissionMask = EmissionMask.getEmissionMask(string2);
                }
                if (this.emissionMask.key < 1) {
                    if (null != errorLogger) {
                        errorLogger.reportError("Missing or bad MASK attribute in " + string + " tag");
                    }
                    return false;
                }
            }
        }
        if (this.isParent) {
            if (this.service.isFullService()) {
                if (!this.location.parseAttributes(string, attributes, this.recordType, errorLogger)) {
                    return false;
                }
                string2 = attributes.getValue("DTS_SECTORS");
                if (null != string2) {
                    if (null != GeoSectors.validateString(string2 = string2.trim())) {
                        if (null != errorLogger) {
                            errorLogger.reportError("Bad DTS_SECTORS attribute in " + string + " tag");
                        }
                        return false;
                    }
                    this.dtsSectors = string2;
                } else {
                    this.dtsSectors = "";
                    string2 = attributes.getValue("DTS_MAXIMUM_DISTANCE");
                    if (null != string2) {
                        this.dtsMaximumDistance = 49.0;
                        try {
                            this.dtsMaximumDistance = Double.parseDouble(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (this.dtsMaximumDistance < 50.0 || this.dtsMaximumDistance > 200.0) {
                            if (null != errorLogger) {
                                errorLogger.reportError("Bad DTS_MAXIMUM_DISTANCE attribute in " + string + " tag");
                            }
                            return false;
                        }
                    }
                }
            }
            return true;
        }
        if (bl3 && null != (string2 = attributes.getValue("TIME_DELAY"))) {
            this.dtsTimeDelay = -501.0;
            try {
                this.dtsTimeDelay = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.dtsTimeDelay < -500.0 || this.dtsTimeDelay > 500.0) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad TIME_DELAY attribute in " + string + " tag");
                }
                return false;
            }
        }
        return this.parseAttributes(string, attributes, errorLogger);
    }

    @Override
    protected ArrayList<String> getComments() {
        boolean bl;
        ArrayList<String> arrayList = null;
        String string = this.getAttribute("licensee");
        boolean bl2 = null != string && string.length() > 0;
        boolean bl3 = null != this.getAttribute("isSharingHost");
        boolean bl4 = null != this.getAttribute("-isSharingGuest");
        String string2 = this.getAttribute("-channelSharingComment");
        boolean bl5 = bl = null != this.getAttribute("isBaseline");
        if (bl2 || this.isDRT || bl3 || bl4 || bl) {
            arrayList = new ArrayList<String>();
            if (bl2) {
                arrayList.add("Licensee: " + string);
            }
            if (this.isDRT) {
                arrayList.add("Digital replacement translator");
            }
            if (bl3) {
                arrayList.add("Shared channel host");
                if (null != string2) {
                    arrayList.add(string2);
                }
            }
            if (bl4) {
                arrayList.add("Shared channel guest");
                if (null != string2) {
                    arrayList.add(string2);
                }
            }
            if (bl) {
                arrayList.add("Baseline record");
            }
        }
        return arrayList;
    }

    @Override
    public boolean isReplication() {
        return null != this.originalSourceKey;
    }

    @Override
    public String getFacilityID() {
        return String.valueOf(this.facilityID);
    }

    @Override
    public String getSortFacilityID() {
        return String.format(Locale.US, "%07d", this.facilityID);
    }

    @Override
    public String getService() {
        if (this.isDRT) {
            return "Digital Replacement Translator";
        }
        return this.service.name;
    }

    @Override
    public String getSiteCount() {
        if (this.isParent) {
            int n = this.dtsSources.size() - 1;
            if (n < 1) {
                n = 1;
            }
            return String.valueOf(n);
        }
        return "1";
    }

    @Override
    public String getSiteNumber() {
        return String.valueOf(this.siteNumber);
    }

    @Override
    public String getChannel() {
        SourceEditDataTV sourceEditDataTV;
        if (null != this.originalSourceKey && null != this.study && null != (sourceEditDataTV = (SourceEditDataTV)this.study.getSource(this.originalSourceKey))) {
            return (this.service.serviceType.digital ? "D" : "N") + String.valueOf(this.channel) + this.frequencyOffset.frequencyOffsetCode + " (" + sourceEditDataTV.getChannel() + ")";
        }
        return (this.service.serviceType.digital ? "D" : "N") + String.valueOf(this.channel) + this.frequencyOffset.frequencyOffsetCode;
    }

    @Override
    public int getChannelNumber() {
        return this.channel;
    }

    @Override
    public String getSortChannel() {
        return String.format(Locale.US, "%02d%c", this.channel, Character.valueOf(this.service.serviceType.digital ? (char)'D' : 'N'));
    }

    @Override
    public String getOriginalChannel() {
        SourceEditDataTV sourceEditDataTV;
        if (null != this.originalSourceKey && null != this.study && null != (sourceEditDataTV = (SourceEditDataTV)this.study.getSource(this.originalSourceKey))) {
            return sourceEditDataTV.getChannel();
        }
        return this.getChannel();
    }

    @Override
    public String getFrequency() {
        return SourceEditDataTV.getFrequency(this.channel, this.service, this.getAttribute("frequency"));
    }

    @Override
    public double getFrequencyValue() {
        return SourceEditDataTV.getFrequencyValue(this.channel, this.service, this.getAttribute("frequency"));
    }

    public static String getFrequency(int n, Service service) {
        return SourceEditDataTV.getFrequency(n, service, null);
    }

    public static String getFrequency(int n, Service service, String string) {
        double d = SourceEditDataTV.getFrequencyValue(n, service, string);
        if (0.0 == d) {
            return "";
        }
        if (service.serviceType.digital && null == string) {
            return String.format(Locale.US, "%.0f MHz", d);
        }
        return String.format(Locale.US, "%.2f MHz", d);
    }

    public static double getFrequencyValue(int n, Service service) {
        return SourceEditDataTV.getFrequencyValue(n, service, null);
    }

    public static double getFrequencyValue(int n, Service service, String string) {
        double d;
        if (null != string) {
            try {
                d = Double.parseDouble(string);
                if (d >= 40.0 && d <= 10000.0) {
                    return d;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (0 == n) {
            return 0.0;
        }
        d = n < 5 ? 57.0 + (double)(n - 2) * 6.0 : (n < 7 ? 79.0 + (double)(n - 5) * 6.0 : (n < 14 ? 177.0 + (double)(n - 7) * 6.0 : 473.0 + (double)(n - 14) * 6.0));
        if (!service.serviceType.digital) {
            d -= 1.75;
        }
        return d;
    }

    @Override
    public String getZone() {
        if (this.zone.key > 0) {
            return this.zone.name;
        }
        return "";
    }

    @Override
    public String getStatus() {
        return this.status + (null != this.getAttribute("-isPending") ? " *P" : (null != this.getAttribute("-isArchived") ? " *A" : ""));
    }

    @Override
    public String getSortStatus() {
        return String.valueOf(this.statusType);
    }

    @Override
    public String getARN() {
        return this.appARN;
    }

    @Override
    public String getFrequencyOffset() {
        if (this.frequencyOffset.key > 0) {
            return this.frequencyOffset.name;
        }
        return "";
    }

    @Override
    public String getEmissionMask() {
        if (this.service.serviceType.needsEmissionMask && this.emissionMask.key > 0) {
            return this.emissionMask.name;
        }
        return "";
    }

    public String getDTSMaximumDistance() {
        if (this.isParent && this.service.isFullService()) {
            if (this.dtsMaximumDistance > 0.0) {
                return AppCore.formatDistance(this.dtsMaximumDistance);
            }
            return "Default";
        }
        return "";
    }

    public String getDTSTimeDelay() {
        if (this.service.isDTS && !this.isParent && 0 != this.siteNumber) {
            return AppCore.formatDecimal(this.dtsTimeDelay, 2);
        }
        return "";
    }

    @Override
    public SourceEditData.RecordData getRecordData(ErrorLogger errorLogger) {
        SourceEditData.RecordData recordData = super.getRecordData(errorLogger);
        if (null == recordData) {
            return null;
        }
        TreeMap<String, String> treeMap = recordData.propertyValues;
        if (!this.service.isDTS || this.isParent) {
            treeMap.put("180facilityID", this.getFacilityID());
            treeMap.put("240zone", this.getZone());
            treeMap.put("140status", this.getStatus());
        }
        if (!this.service.isDTS || this.isParent || 0 == this.siteNumber) {
            treeMap.put("130channel", this.getChannel());
        }
        if (!this.service.isDTS || !this.isParent) {
            treeMap.put("210siteNumber", String.valueOf(this.siteNumber));
            treeMap.put("290frequencyOffset", this.getFrequencyOffset());
            if (this.service.serviceType.needsEmissionMask) {
                treeMap.put("300emissionMask", this.getEmissionMask());
            }
        }
        if (this.service.isDTS) {
            if (this.isParent) {
                treeMap.remove("260heightAMSL");
                treeMap.remove("270overallHAAT");
                treeMap.remove("280peakERP");
                treeMap.put("200siteCount", this.getSiteCount());
                if (this.service.isFullService()) {
                    treeMap.put("250dtsMaximumDistance", this.getDTSMaximumDistance());
                }
                recordData.dependentData = new TreeMap();
                for (SourceEditDataTV sourceEditDataTV : this.dtsSources.values()) {
                    SourceEditData.RecordData recordData2 = sourceEditDataTV.getRecordData(errorLogger);
                    if (null == recordData2) {
                        return null;
                    }
                    recordData.dependentData.put(sourceEditDataTV.siteNumber, recordData2);
                }
            } else {
                treeMap.remove("320recordType");
                treeMap.remove("330stationData");
                treeMap.remove("340recordID");
                treeMap.remove("110callSign");
                treeMap.remove("150city");
                treeMap.remove("160state");
                treeMap.remove("170country");
                treeMap.remove("350sequenceDate");
                if (this.siteNumber > 0) {
                    treeMap.remove("120service");
                    treeMap.remove("190fileNumber");
                }
            }
        }
        return recordData;
    }

    private static class SearchDelta {
        int delta;
        boolean analogOnly;
        double maximumDistance;

        private SearchDelta() {
        }
    }
}

