/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.AntPattern;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordFM;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.FrequencyOffset;
import gov.fcc.tvstudy.core.data.Scenario;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.core.data.SourceFM;
import gov.fcc.tvstudy.core.data.SourceTV;
import gov.fcc.tvstudy.core.data.SourceWL;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.data.Zone;
import gov.fcc.tvstudy.core.editdata.ParameterEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataFM;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.SourceEditDataWL;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import gov.fcc.tvstudy.core.geo.GeoSectors;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SourceEditData
implements StationRecord {
    public final StudyEditData study;
    public final String dbID;
    public final int recordType;
    public final Integer key;
    public final Service service;
    public final Country country;
    public final boolean isLocked;
    public final Integer userRecordID;
    public final Integer extDbKey;
    public final String extRecordID;
    public String callSign;
    public String city;
    public String state;
    public String fileNumber;
    public final GeoPoint location;
    public double heightAMSL;
    public double overallHAAT;
    public double peakERP;
    public String antennaID;
    public boolean hasHorizontalPattern;
    public AntPattern horizontalPattern;
    public boolean horizontalPatternChanged;
    public double horizontalPatternOrientation;
    public boolean hasVerticalPattern;
    public AntPattern verticalPattern;
    public boolean verticalPatternChanged;
    public double verticalPatternElectricalTilt;
    public double verticalPatternMechanicalTilt;
    public double verticalPatternMechanicalTiltOrientation;
    public boolean hasMatrixPattern;
    public AntPattern matrixPattern;
    public boolean matrixPatternChanged;
    public boolean useGenericVerticalPattern;
    protected final HashMap<String, String> attributes;
    protected boolean attributesChanged;
    private static int nextTemporaryKey = 1;
    private static HashMap<String, HashMap<Integer, String>> userRecordCommentCaches = new HashMap();
    private static final String PATTERN_DATA_START = "$pattern";
    private static final String PATTERN_DATA_END = "$end";

    protected SourceEditData(StudyEditData studyEditData, String string, int n, Integer n2, Service service, Country country, boolean bl, Integer n3, Integer n4, String string2) {
        this.study = studyEditData;
        this.dbID = string;
        this.recordType = n;
        this.key = n2;
        this.service = service;
        this.country = country;
        this.isLocked = bl;
        this.userRecordID = n3;
        this.extDbKey = n4;
        this.extRecordID = string2;
        this.location = new GeoPoint();
        this.attributes = new HashMap();
    }

    public abstract Source getSource();

    public static SourceEditData getInstance(StudyEditData studyEditData, Source source) {
        switch (source.recordType) {
            case 1: {
                return new SourceEditDataTV(studyEditData, (SourceTV)source);
            }
            case 2: {
                return new SourceEditDataWL(studyEditData, (SourceWL)source);
            }
            case 3: {
                return new SourceEditDataFM(studyEditData, (SourceFM)source);
            }
        }
        return null;
    }

    public static SourceEditData makeSource(ExtDbRecord extDbRecord, StudyEditData studyEditData, boolean bl) {
        return SourceEditData.makeSource(extDbRecord, studyEditData, bl, null);
    }

    public static SourceEditData makeSource(ExtDbRecord extDbRecord, StudyEditData studyEditData, boolean bl, ErrorLogger errorLogger) {
        switch (extDbRecord.recordType) {
            case 1: {
                return SourceEditDataTV.makeSourceTV((ExtDbRecordTV)extDbRecord, studyEditData, bl, errorLogger);
            }
            case 3: {
                return SourceEditDataFM.makeSourceFM((ExtDbRecordFM)extDbRecord, studyEditData, bl, errorLogger);
            }
        }
        return null;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object object) {
        return null != object && ((SourceEditData)object).key.equals(this.key);
    }

    public String toString() {
        return this.getCallSign() + " " + this.getChannel() + " " + this.getServiceCode() + " " + this.getStatus() + " " + this.getCity() + " " + this.getState();
    }

    protected static synchronized Integer getTemporaryKey() {
        return nextTemporaryKey++;
    }

    public abstract SourceEditData copy();

    public SourceEditData deriveSource(boolean bl) {
        return this.deriveSource(this.study, bl, null);
    }

    public SourceEditData deriveSource(boolean bl, ErrorLogger errorLogger) {
        return this.deriveSource(this.study, bl, errorLogger);
    }

    public SourceEditData deriveSource(StudyEditData studyEditData, boolean bl) {
        return this.deriveSource(studyEditData, bl, null);
    }

    public abstract SourceEditData deriveSource(StudyEditData var1, boolean var2, ErrorLogger var3);

    public boolean isGeographyInUse(int n) {
        return false;
    }

    public int getGeographyKey() {
        return 0;
    }

    public void setAttribute(String string) {
        this.attributes.put(string, "");
        this.attributesChanged = true;
    }

    public void setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
        this.attributesChanged = true;
    }

    public String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String removeAttribute(String string) {
        this.attributesChanged = true;
        return this.attributes.remove(string);
    }

    public ArrayList<String> getAttributeKeys() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    protected void setAllAttributes(HashMap<String, String> hashMap) {
        this.attributes.clear();
        this.attributes.putAll(hashMap);
    }

    protected void setAllAttributesNT(HashMap<String, String> hashMap) {
        this.attributes.clear();
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            if (entry.getKey().startsWith("-")) continue;
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    protected void setAllAttributes(String string) {
        this.doParseAttributes(string, false);
    }

    protected void setAllAttributesNT(String string) {
        this.doParseAttributes(string, true);
    }

    private void doParseAttributes(String string, boolean bl) {
        this.attributes.clear();
        for (String string2 : string.split("\\n")) {
            String string3;
            String string4;
            int n = string2.indexOf(61);
            if (n > 0) {
                string4 = string2.substring(0, n).trim();
                string3 = string2.substring(n + 1).trim();
            } else {
                string4 = string2.trim();
                string3 = "";
            }
            if (bl && string4.startsWith("-")) continue;
            this.attributes.put(string4, string3);
        }
    }

    protected String getAllAttributes() {
        return this.formatAttributes(false);
    }

    protected String getAllAttributesNT() {
        return this.formatAttributes(true);
    }

    private String formatAttributes(boolean bl) {
        if (this.attributes.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if (bl && entry.getKey().startsWith("-")) continue;
            stringBuilder.append(entry.getKey());
            String string = entry.getValue();
            if (string.length() > 0) {
                stringBuilder.append('=');
                stringBuilder.append(string);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public void copyTransientAttributes(SourceEditData sourceEditData) {
        for (Map.Entry<String, String> entry : sourceEditData.attributes.entrySet()) {
            if (!entry.getKey().startsWith("-")) continue;
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    public AntPattern getHorizontalPattern(ErrorLogger errorLogger) {
        if (this.hasHorizontalPattern) {
            Source source;
            if (null == this.horizontalPattern && null != (source = this.getSource())) {
                this.horizontalPattern = source.getHorizontalPattern(errorLogger);
            }
            return this.horizontalPattern;
        }
        return null;
    }

    public AntPattern getVerticalPattern(ErrorLogger errorLogger) {
        if (this.hasMatrixPattern) {
            Source source;
            if (null == this.matrixPattern && null != (source = this.getSource())) {
                this.matrixPattern = source.getMatrixPattern(errorLogger);
            }
            return this.matrixPattern;
        }
        if (this.hasVerticalPattern) {
            Source source;
            if (null == this.verticalPattern && null != (source = this.getSource())) {
                this.verticalPattern = source.getVerticalPattern(errorLogger);
            }
            return this.verticalPattern;
        }
        return null;
    }

    public boolean isDataValid() {
        return this.isDataValid(null);
    }

    public boolean isDataValid(ErrorLogger errorLogger) {
        if (this.isLocked && null != this.getSource()) {
            return true;
        }
        if (this.service.key < 1) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A service must be selected");
            }
            return false;
        }
        if (this.country.key < 1) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A country must be selected");
            }
            return false;
        }
        if (0 == this.callSign.length()) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A " + (2 == this.recordType ? "site ID" : "call sign") + " must be provided");
            }
            return false;
        }
        if (0.0 == this.location.latitude || 0.0 == this.location.longitude) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Latitude and longitude must be provided");
            }
            return false;
        }
        if (this.location.latitude < -73.0 || this.location.latitude > 73.5) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad latitude, must be -73.0 to 73.5 degrees");
            }
            return false;
        }
        if (this.location.longitude < -180.0 || this.location.longitude > 180.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad longitude, must be -180.0 to 180.0 degrees");
            }
            return false;
        }
        if (this.heightAMSL < -1100.0 || this.heightAMSL > 10000.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad height AMSL, must be -1100.0 to 10000.0");
            }
            return false;
        }
        if (this.overallHAAT < -1100.0 || this.overallHAAT > 10000.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad HAAT, must be -1100.0 to 10000.0");
            }
            return false;
        }
        if (this.peakERP < 1.0E-5 || this.peakERP > 5000.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad ERP, must be 1.0E-5 to 5000.0");
            }
            return false;
        }
        if (this.hasHorizontalPattern) {
            if (null != this.horizontalPattern) {
                if (1 != this.horizontalPattern.type || !this.horizontalPattern.isSimple()) {
                    if (null != errorLogger) {
                        errorLogger.reportValidationError("Bad azimuth pattern, invalid object type or format");
                    }
                    return false;
                }
                if (!this.horizontalPattern.isDataValid(errorLogger)) {
                    return false;
                }
            }
        } else {
            this.horizontalPattern = null;
        }
        if (this.horizontalPatternOrientation < 0.0 || this.horizontalPatternOrientation >= 360.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad azimuth pattern orientation, must be 0 to less than 360");
            }
            return false;
        }
        if (this.hasVerticalPattern) {
            if (null != this.verticalPattern) {
                if (2 != this.verticalPattern.type || !this.verticalPattern.isSimple()) {
                    if (null != errorLogger) {
                        errorLogger.reportValidationError("Bad elevation pattern, invalid object type or format");
                    }
                    return false;
                }
                if (!this.verticalPattern.isDataValid(errorLogger)) {
                    return false;
                }
            }
        } else {
            this.verticalPattern = null;
        }
        if (this.verticalPatternElectricalTilt < -10.0 || this.verticalPatternElectricalTilt > 16.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad elevation pattern electrical tilt, must be -10.0 to 16.0");
            }
            return false;
        }
        if (this.verticalPatternMechanicalTilt < -10.0 || this.verticalPatternMechanicalTilt > 16.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad elevation pattern mechanical tilt, must be -10.0 to 16.0");
            }
            return false;
        }
        if (this.verticalPatternMechanicalTiltOrientation < 0.0 || this.verticalPatternMechanicalTiltOrientation >= 360.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad elevation pattern mechanical tilt orientation, must be 0 to less than 360");
            }
            return false;
        }
        if (this.hasMatrixPattern) {
            if (null != this.matrixPattern) {
                if (2 != this.matrixPattern.type || this.matrixPattern.isSimple()) {
                    if (null != errorLogger) {
                        errorLogger.reportValidationError("Bad elevation pattern, invalid object type or format");
                    }
                    return false;
                }
                if (!this.matrixPattern.isDataValid(errorLogger)) {
                    return false;
                }
            }
        } else {
            this.matrixPattern = null;
        }
        return true;
    }

    public boolean isDataChanged() {
        if (this.attributesChanged) {
            return true;
        }
        Source source = this.getSource();
        if (null == source) {
            return true;
        }
        if (this.isLocked) {
            return false;
        }
        if (this.service.key != source.service.key) {
            return true;
        }
        if (this.country.key != source.country.key) {
            return true;
        }
        if (!this.callSign.equals(source.callSign)) {
            return true;
        }
        if (!this.city.equals(source.city)) {
            return true;
        }
        if (!this.state.equals(source.state)) {
            return true;
        }
        if (!this.fileNumber.equals(source.fileNumber)) {
            return true;
        }
        if (!this.location.equals(source.location)) {
            return true;
        }
        if (this.heightAMSL != source.heightAMSL) {
            return true;
        }
        if (this.overallHAAT != source.overallHAAT) {
            return true;
        }
        if (this.peakERP != source.peakERP) {
            return true;
        }
        if (this.hasHorizontalPattern != source.hasHorizontalPattern) {
            return true;
        }
        if (null != this.horizontalPattern && !this.horizontalPattern.name.equals(source.horizontalPatternName)) {
            return true;
        }
        if (this.horizontalPatternChanged) {
            return true;
        }
        if (this.horizontalPatternOrientation != source.horizontalPatternOrientation) {
            return true;
        }
        if (this.hasVerticalPattern != source.hasVerticalPattern) {
            return true;
        }
        if (null != this.verticalPattern && !this.verticalPattern.name.equals(source.verticalPatternName)) {
            return true;
        }
        if (this.verticalPatternChanged) {
            return true;
        }
        if (this.verticalPatternElectricalTilt != source.verticalPatternElectricalTilt) {
            return true;
        }
        if (this.verticalPatternMechanicalTilt != source.verticalPatternMechanicalTilt) {
            return true;
        }
        if (this.verticalPatternMechanicalTiltOrientation != source.verticalPatternMechanicalTiltOrientation) {
            return true;
        }
        if (this.hasMatrixPattern != source.hasMatrixPattern) {
            return true;
        }
        if (this.matrixPattern != null && !this.matrixPattern.name.equals(source.matrixPatternName)) {
            return true;
        }
        if (this.matrixPatternChanged) {
            return true;
        }
        return this.useGenericVerticalPattern != source.useGenericVerticalPattern;
    }

    public abstract void save(DbConnection var1) throws SQLException;

    protected void savePatterns(DbConnection dbConnection) throws SQLException {
        String string;
        int n;
        StringBuilder stringBuilder;
        if (this.horizontalPatternChanged) {
            dbConnection.update("DELETE FROM source_horizontal_pattern WHERE source_key=" + this.key);
            if (null != this.horizontalPattern) {
                stringBuilder = new StringBuilder("INSERT INTO source_horizontal_pattern (source_key,azimuth,relative_field) VALUES");
                n = stringBuilder.length();
                string = " (";
                for (AntPattern.AntPoint object : this.horizontalPattern.getPoints()) {
                    stringBuilder.append(string);
                    stringBuilder.append(String.valueOf(this.key));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(object.angle));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(object.relativeField));
                    if (stringBuilder.length() > 500000) {
                        stringBuilder.append(')');
                        dbConnection.update(stringBuilder.toString());
                        stringBuilder.setLength(n);
                        string = " (";
                        continue;
                    }
                    string = "),(";
                }
                if (stringBuilder.length() > n) {
                    stringBuilder.append(')');
                    dbConnection.update(stringBuilder.toString());
                }
            }
        }
        if (this.verticalPatternChanged) {
            dbConnection.update("DELETE FROM source_vertical_pattern WHERE source_key=" + this.key);
            if (null != this.verticalPattern) {
                stringBuilder = new StringBuilder("INSERT INTO source_vertical_pattern (source_key,depression_angle,relative_field) VALUES");
                n = stringBuilder.length();
                string = " (";
                for (AntPattern.AntPoint antPoint : this.verticalPattern.getPoints()) {
                    stringBuilder.append(string);
                    stringBuilder.append(String.valueOf(this.key));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(antPoint.angle));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(antPoint.relativeField));
                    if (stringBuilder.length() > 500000) {
                        stringBuilder.append(')');
                        dbConnection.update(stringBuilder.toString());
                        stringBuilder.setLength(n);
                        string = " (";
                        continue;
                    }
                    string = "),(";
                }
                if (stringBuilder.length() > n) {
                    stringBuilder.append(')');
                    dbConnection.update(stringBuilder.toString());
                }
            }
        }
        if (this.matrixPatternChanged) {
            dbConnection.update("DELETE FROM source_matrix_pattern WHERE source_key=" + this.key);
            if (null != this.matrixPattern) {
                stringBuilder = new StringBuilder("INSERT INTO source_matrix_pattern (source_key,azimuth,depression_angle,relative_field) VALUES");
                n = stringBuilder.length();
                string = " (";
                for (AntPattern.AntSlice antSlice : this.matrixPattern.getSlices()) {
                    for (AntPattern.AntPoint antPoint : antSlice.points) {
                        stringBuilder.append(string);
                        stringBuilder.append(String.valueOf(this.key));
                        stringBuilder.append(',');
                        stringBuilder.append(String.valueOf(antSlice.value));
                        stringBuilder.append(',');
                        stringBuilder.append(String.valueOf(antPoint.angle));
                        stringBuilder.append(',');
                        stringBuilder.append(String.valueOf(antPoint.relativeField));
                        if (stringBuilder.length() > 500000) {
                            stringBuilder.append(')');
                            dbConnection.update(stringBuilder.toString());
                            stringBuilder.setLength(n);
                            string = " (";
                            continue;
                        }
                        string = "),(";
                    }
                }
                if (stringBuilder.length() > n) {
                    stringBuilder.append(')');
                    dbConnection.update(stringBuilder.toString());
                }
            }
        }
    }

    public static void setSourceComment(SourceEditData sourceEditData, String string) {
        if (null == sourceEditData.userRecordID) {
            return;
        }
        string = null == string ? "" : string.trim();
        HashMap<Integer, String> hashMap = userRecordCommentCaches.get(sourceEditData.dbID);
        if (null == hashMap) {
            hashMap = new HashMap();
            userRecordCommentCaches.put(sourceEditData.dbID, hashMap);
        }
        hashMap.put(sourceEditData.userRecordID, string);
        DbConnection dbConnection = DbCore.connectDb(sourceEditData.dbID);
        if (null != dbConnection) {
            try {
                dbConnection.update("UPDATE user_record SET comment = '" + DbConnection.clean(string) + "' WHERE user_record_id = " + sourceEditData.userRecordID);
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
        }
    }

    public static String getSourceComment(SourceEditData sourceEditData) {
        String string;
        if (null == sourceEditData.userRecordID) {
            return "";
        }
        HashMap<Integer, String> hashMap = userRecordCommentCaches.get(sourceEditData.dbID);
        if (null == hashMap) {
            hashMap = new HashMap();
            userRecordCommentCaches.put(sourceEditData.dbID, hashMap);
        }
        if (null != (string = hashMap.get(sourceEditData.userRecordID))) {
            return string;
        }
        string = "";
        DbConnection dbConnection = DbCore.connectDb(sourceEditData.dbID);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT comment FROM user_record WHERE user_record_id = " + sourceEditData.userRecordID);
                if (dbConnection.next()) {
                    string = dbConnection.getString(1);
                }
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
        }
        hashMap.put(sourceEditData.userRecordID, string);
        return string;
    }

    public SourceEditData saveAsUserRecord(ErrorLogger errorLogger) {
        return this.saveAsUserRecord(null, errorLogger);
    }

    public SourceEditData saveAsUserRecord(StudyEditData studyEditData, ErrorLogger errorLogger) {
        if (this.isReplication()) {
            if (null != errorLogger) {
                errorLogger.reportError("Replication record cannot be saved as a user record");
            }
            return null;
        }
        if (!this.isDataValid(errorLogger)) {
            return null;
        }
        if (null != errorLogger) {
            errorLogger.clearErrors();
        } else {
            errorLogger = new ErrorLogger(null, null);
        }
        StringWriter stringWriter = new StringWriter();
        try {
            this.writeToXML(stringWriter, errorLogger);
        }
        catch (IOException iOException) {
            errorLogger.reportError(iOException.toString());
        }
        if (errorLogger.hasErrors()) {
            return null;
        }
        String string = stringWriter.toString();
        Integer n = null;
        boolean bl = false;
        String string2 = "";
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null != dbConnection) {
            HashMap<Integer, String> hashMap = userRecordCommentCaches.get(this.dbID);
            if (null == hashMap) {
                hashMap = new HashMap();
                userRecordCommentCaches.put(this.dbID, hashMap);
            }
            try {
                dbConnection.update("LOCK TABLES user_record WRITE, user_record_id_sequence WRITE");
                dbConnection.update("UPDATE user_record_id_sequence SET user_record_id = user_record_id + 1");
                dbConnection.query("SELECT user_record_id FROM user_record_id_sequence");
                dbConnection.next();
                n = dbConnection.getInt(1);
                int n2 = 0;
                int n3 = 0;
                switch (this.recordType) {
                    case 1: {
                        n2 = ((SourceEditDataTV)this).facilityID;
                        n3 = ((SourceEditDataTV)this).channel;
                        break;
                    }
                    case 3: {
                        n2 = ((SourceEditDataFM)this).facilityID;
                        n3 = ((SourceEditDataFM)this).channel;
                    }
                }
                dbConnection.update("INSERT INTO user_record (user_record_id,record_type,xml_data,facility_id,service_key,call_sign,status,channel,city,state,country,file_number,comment) VALUES (" + n + "," + this.recordType + ",'" + DbConnection.clean(string) + "'," + n2 + "," + this.service.key + ",'" + DbConnection.clean(this.getCallSign()) + "','" + DbConnection.clean(this.getStatus()) + "'," + n3 + ",'" + DbConnection.clean(this.getCity()) + "','" + DbConnection.clean(this.getState()) + "','" + DbConnection.clean(this.getCountryCode()) + "','" + DbConnection.clean(this.getFileNumber()) + "','')");
                hashMap.put(n, "");
            }
            catch (SQLException sQLException) {
                bl = true;
                string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
            if (bl) {
                errorLogger.reportError(string2);
                return null;
            }
        } else {
            return null;
        }
        return SourceEditData.readSourceFromXML(this.dbID, new StringReader(string), studyEditData, n, errorLogger);
    }

    public static boolean deleteUserRecord(String string, Integer n) {
        return SourceEditData.deleteUserRecord(string, n, null);
    }

    public static boolean deleteUserRecord(String string, Integer n, ErrorLogger errorLogger) {
        if (null == n) {
            return false;
        }
        boolean bl = false;
        String string2 = "";
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.update("LOCK TABLES user_record WRITE");
                dbConnection.update("DELETE FROM user_record WHERE user_record_id = " + n);
            }
            catch (SQLException sQLException) {
                bl = true;
                string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
            if (bl) {
                errorLogger.reportError(string2);
                return false;
            }
            HashMap<Integer, String> hashMap = userRecordCommentCaches.get(string);
            if (null != hashMap) {
                hashMap.remove(n);
            }
            return true;
        }
        return false;
    }

    public static ArrayList<SourceEditData> findUserRecords(String string, int n, String string2) {
        return SourceEditData.findUserRecords(string, n, string2, null);
    }

    public static ArrayList<SourceEditData> findUserRecords(String string, int n, String string2, ErrorLogger errorLogger) {
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>();
        String string3 = null != string2 && string2.length() > 0 ? "WHERE (" + string2 + ") AND " : "WHERE ";
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            HashMap<Integer, String> hashMap = userRecordCommentCaches.get(string);
            if (null == hashMap) {
                hashMap = new HashMap();
                userRecordCommentCaches.put(string, hashMap);
            }
            ErrorLogger errorLogger2 = new ErrorLogger(null, null);
            try {
                dbConnection.query("SELECT user_record_id, xml_data, comment FROM user_record " + string3 + "(record_type = " + n + ")");
                while (dbConnection.next()) {
                    Integer n2 = dbConnection.getInt(1);
                    SourceEditData sourceEditData = SourceEditData.readSourceFromXML(string, new StringReader(dbConnection.getString(2)), null, n2, errorLogger2);
                    if (null == sourceEditData) continue;
                    arrayList.add(sourceEditData);
                    hashMap.put(n2, dbConnection.getString(3));
                }
                DbCore.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                arrayList = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        return arrayList;
    }

    public static SourceEditData findUserRecord(String string, Integer n) {
        return SourceEditData.findUserRecord(string, null, n, null);
    }

    public static SourceEditData findUserRecord(String string, Integer n, ErrorLogger errorLogger) {
        return SourceEditData.findUserRecord(string, null, n, errorLogger);
    }

    public static SourceEditData findUserRecord(String string, StudyEditData studyEditData, Integer n) {
        return SourceEditData.findUserRecord(string, studyEditData, n, null);
    }

    public static SourceEditData findUserRecord(String string, StudyEditData studyEditData, Integer n, ErrorLogger errorLogger) {
        String string2 = null;
        boolean bl = false;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            HashMap<Integer, String> hashMap = userRecordCommentCaches.get(string);
            if (null == hashMap) {
                hashMap = new HashMap();
                userRecordCommentCaches.put(string, hashMap);
            }
            try {
                dbConnection.query("SELECT xml_data, comment FROM user_record WHERE user_record_id = " + n);
                if (dbConnection.next()) {
                    string2 = dbConnection.getString(1);
                    hashMap.put(n, dbConnection.getString(2));
                } else {
                    bl = true;
                }
                DbCore.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                DbConnection.reportError(errorLogger, sQLException);
                return null;
            }
        }
        if (bl) {
            if (null != errorLogger) {
                errorLogger.reportError("User record not found for record ID '" + n + "'");
            }
            return null;
        }
        return SourceEditData.readSourceFromXML(string, new StringReader(string2), studyEditData, n, errorLogger);
    }

    public static boolean isExtDbSupported(ExtDb extDb) {
        return !extDb.deleted && extDb.isSupported() && extDb.isGeneric();
    }

    public static LinkedList<SourceEditData> findImportRecords(ExtDb extDb, int n, String string) {
        return SourceEditData.findImportRecords(extDb, n, string, null, 0.0, 0.0, null);
    }

    public static LinkedList<SourceEditData> findImportRecords(ExtDb extDb, int n, String string, ErrorLogger errorLogger) {
        return SourceEditData.findImportRecords(extDb, n, string, null, 0.0, 0.0, errorLogger);
    }

    public static LinkedList<SourceEditData> findImportRecords(ExtDb extDb, int n, String string, GeoPoint geoPoint, double d, double d2) {
        return SourceEditData.findImportRecords(extDb, n, string, geoPoint, d, d2, null);
    }

    public static LinkedList<SourceEditData> findImportRecords(ExtDb extDb, int n, String string, GeoPoint geoPoint, double d, double d2, ErrorLogger errorLogger) {
        if (!SourceEditData.isExtDbSupported(extDb) || !extDb.canProvide(n)) {
            return new LinkedList<SourceEditData>();
        }
        DbConnection dbConnection = extDb.connectDb(errorLogger);
        if (null == dbConnection) {
            return null;
        }
        ArrayList<Source> arrayList = new ArrayList<Source>();
        try {
            switch (n) {
                case 1: {
                    SourceTV.getSources(dbConnection, extDb.dbID, extDb.dbName, string, arrayList);
                    break;
                }
                case 2: {
                    SourceWL.getSources(dbConnection, extDb.dbID, extDb.dbName, string, arrayList);
                    break;
                }
                case 3: {
                    SourceFM.getSources(dbConnection, extDb.dbID, extDb.dbName, string, arrayList);
                }
            }
            extDb.releaseDb(dbConnection);
        }
        catch (SQLException sQLException) {
            extDb.releaseDb(dbConnection);
            DbConnection.reportError(errorLogger, sQLException);
            return null;
        }
        LinkedList<SourceEditData> linkedList = new LinkedList<SourceEditData>();
        for (Source source : arrayList) {
            SourceEditData sourceEditData;
            if (null != geoPoint && d > 0.0) {
                boolean bl = true;
                if (source.service.isDTS) {
                    for (SourceTV sourceTV : ((SourceTV)source).dtsSources) {
                        if (!(geoPoint.distanceTo(sourceTV.location, d2) <= d)) continue;
                        bl = false;
                        break;
                    }
                } else if (geoPoint.distanceTo(source.location, d2) <= d) {
                    bl = false;
                }
                if (bl) continue;
            }
            if (null == (sourceEditData = SourceEditData.getInstance(null, source))) continue;
            linkedList.add(sourceEditData);
        }
        return linkedList;
    }

    public static SourceEditData findImportRecord(ExtDb extDb, int n, String string) {
        return SourceEditData.findImportRecord(extDb, n, null, string, null);
    }

    public static SourceEditData findImportRecord(ExtDb extDb, int n, String string, ErrorLogger errorLogger) {
        return SourceEditData.findImportRecord(extDb, n, null, string, errorLogger);
    }

    public static SourceEditData findImportRecord(ExtDb extDb, int n, StudyEditData studyEditData, String string) {
        return SourceEditData.findImportRecord(extDb, n, studyEditData, string, null);
    }

    public static SourceEditData findImportRecord(ExtDb extDb, int n, StudyEditData studyEditData, String string, ErrorLogger errorLogger) {
        if (!SourceEditData.isExtDbSupported(extDb) || !extDb.canProvide(n)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            SourceEditData.addRecordIDQuery(extDb.type, string, stringBuilder, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (null != errorLogger) {
                errorLogger.logMessage(illegalArgumentException.getMessage());
            }
            return null;
        }
        LinkedList<SourceEditData> linkedList = SourceEditData.findImportRecords(extDb, n, stringBuilder.toString(), null, 0.0, 0.0, errorLogger);
        if (null == linkedList) {
            return null;
        }
        if (linkedList.isEmpty()) {
            if (null != errorLogger) {
                errorLogger.logMessage("Record not found for record ID '" + string + "'");
            }
            return null;
        }
        return linkedList.getFirst();
    }

    public static boolean addRecordIDQuery(int n, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (-1 == n) {
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("The user record ID must be a number");
            }
            if (n2 <= 0) {
                throw new IllegalArgumentException("The user record ID must be greater than 0");
            }
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        if (-1 == n) {
            stringBuilder.append("(user_record_id = ");
            stringBuilder.append(string);
        } else {
            stringBuilder.append("(ext_record_id = '");
            stringBuilder.append(string);
            stringBuilder.append("'");
        }
        stringBuilder.append(')');
        return true;
    }

    public static boolean addFileNumberQuery(int n, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        String[] stringArray = ExtDbRecord.parseFileNumber(string);
        return SourceEditData.addFileNumberQuery(n, stringArray[0], stringArray[1], stringBuilder, bl);
    }

    public static boolean addFileNumberQuery(int n, String string, String string2, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        if (string.length() > 0) {
            stringBuilder.append("(UPPER(file_number) LIKE '");
            stringBuilder.append(DbConnection.clean(string.toUpperCase()));
            stringBuilder.append('%');
            stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
        } else {
            stringBuilder.append("(UPPER(file_number) LIKE '%");
            stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
        }
        stringBuilder.append("')");
        return true;
    }

    public static boolean addFacilityIDQuery(int n, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The facility ID must be a number");
        }
        return SourceEditData.addFacilityIDQuery(n, n2, stringBuilder, bl);
    }

    public static boolean addFacilityIDQuery(int n, int n2, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        stringBuilder.append("(facility_id = ");
        stringBuilder.append(String.valueOf(n2));
        stringBuilder.append(')');
        return true;
    }

    public static boolean addServiceQuery(int n, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        Service service = Service.getService(string);
        if (null == service) {
            throw new IllegalArgumentException("Unknown service code");
        }
        return SourceEditData.addServiceQuery(n, service.key, stringBuilder, bl);
    }

    public static boolean addServiceQuery(int n, int n2, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        stringBuilder.append("(service_key = ");
        stringBuilder.append(String.valueOf(n2));
        stringBuilder.append(')');
        return true;
    }

    public static boolean addCallSignQuery(int n, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        stringBuilder.append("(UPPER(call_sign) REGEXP '^D*");
        stringBuilder.append(DbConnection.clean(string.toUpperCase()));
        stringBuilder.append(".*')");
        return true;
    }

    public static boolean addChannelQuery(int n, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        return SourceEditData.addChannelQuery(n, string, 0, 0, stringBuilder, bl);
    }

    public static boolean addChannelQuery(int n, String string, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        int n4 = 0;
        try {
            n4 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The channel must be a number");
        }
        return SourceEditData.addChannelQuery(n, n4, n2, n3, stringBuilder, bl);
    }

    public static boolean addChannelQuery(int n, int n2, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        return SourceEditData.addChannelQuery(n, n2, 0, 0, stringBuilder, bl);
    }

    public static boolean addChannelQuery(int n, int n2, int n3, int n4, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (n3 > 0 && n4 > 0 && (n2 < n3 || n2 > n4)) {
            throw new IllegalArgumentException("The channel must be in the range " + n3 + " to " + n4);
        }
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        stringBuilder.append("(channel = ");
        stringBuilder.append(String.valueOf(n2));
        stringBuilder.append(')');
        return true;
    }

    public static boolean addChannelRangeQuery(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        stringBuilder.append("(channel BETWEEN ");
        stringBuilder.append(String.valueOf(n2));
        stringBuilder.append(" AND ");
        stringBuilder.append(String.valueOf(n3));
        stringBuilder.append(')');
        return true;
    }

    public static boolean addMultipleChannelQuery(int n, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        stringBuilder.append("(channel IN ");
        stringBuilder.append(string);
        stringBuilder.append(')');
        return true;
    }

    public static boolean addStatusQuery(int n, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        return SourceEditData.addStatusQuery(n, ExtDbRecord.getStatusType(string), stringBuilder, bl);
    }

    public static boolean addStatusQuery(int n, int n2, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown status code");
            }
        }
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        stringBuilder.append("(UPPER(status) = '");
        stringBuilder.append(ExtDbRecord.STATUS_CODES[n2]);
        stringBuilder.append("')");
        return true;
    }

    public static boolean addCityQuery(int n, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        stringBuilder.append("(UPPER(city) LIKE '%");
        stringBuilder.append(DbConnection.clean(string.toUpperCase()).replace('*', '%'));
        stringBuilder.append("%')");
        return true;
    }

    public static boolean addStateQuery(int n, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        stringBuilder.append("(UPPER(state) = '");
        stringBuilder.append(DbConnection.clean(string.toUpperCase()));
        stringBuilder.append("')");
        return true;
    }

    public static boolean addCountryQuery(int n, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        Country country = Country.getCountry(string);
        if (null == country) {
            throw new IllegalArgumentException("Unknown country code");
        }
        return SourceEditData.addCountryQuery(n, country, stringBuilder, bl);
    }

    public static boolean addCountryQuery(int n, int n2, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        Country country = Country.getCountry(n2);
        if (null == country) {
            throw new IllegalArgumentException("Unknown country key");
        }
        return SourceEditData.addCountryQuery(n, country, stringBuilder, bl);
    }

    public static boolean addCountryQuery(int n, Country country, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (!ExtDb.isGeneric(n) && -1 != n) {
            throw new IllegalArgumentException("Unknown or unsupported station data type");
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        if (-1 == n) {
            stringBuilder.append("(UPPER(country) = '");
            stringBuilder.append(country.countryCode);
            stringBuilder.append("')");
        } else {
            stringBuilder.append("(country_key = ");
            stringBuilder.append(country.key);
            stringBuilder.append(")");
        }
        return true;
    }

    public boolean writeToXML(Writer writer) throws IOException {
        return this.writeToXML(writer, null);
    }

    public boolean writeToXML(Writer writer, ErrorLogger errorLogger) throws IOException {
        writer.append("<TVSTUDY VERSION=\"105000\">\n");
        boolean bl = this.writeToXML(writer, true, false, false, errorLogger);
        writer.append("</TVSTUDY>\n");
        return bl;
    }

    public boolean writeToXML(Writer writer, boolean bl, boolean bl2) throws IOException {
        return this.writeToXML(writer, false, bl, bl2, null);
    }

    public boolean writeToXML(Writer writer, boolean bl, boolean bl2, ErrorLogger errorLogger) throws IOException {
        return this.writeToXML(writer, false, bl, bl2, errorLogger);
    }

    protected abstract boolean writeToXML(Writer var1, boolean var2, boolean var3, boolean var4, ErrorLogger var5) throws IOException;

    public static boolean writeSourcesToXML(Writer writer, ArrayList<SourceEditData> arrayList) throws IOException {
        return SourceEditData.writeSourcesToXML(writer, arrayList, null);
    }

    public static boolean writeSourcesToXML(Writer writer, ArrayList<SourceEditData> arrayList, ErrorLogger errorLogger) throws IOException {
        writer.append("<TVSTUDY VERSION=\"105000\">\n");
        boolean bl = true;
        for (SourceEditData sourceEditData : arrayList) {
            if (sourceEditData.writeToXML(writer, true, false, false, errorLogger)) continue;
            bl = false;
            break;
        }
        writer.append("</TVSTUDY>\n");
        return bl;
    }

    protected void writeAttributes(Writer writer, ErrorLogger errorLogger) throws IOException {
        boolean bl;
        boolean bl2;
        this.location.writeAttributes(writer);
        writer.append(" HAMSL=\"" + AppCore.formatHeight(this.heightAMSL) + '\"');
        writer.append(" HAAT=\"" + AppCore.formatHeight(this.overallHAAT) + '\"');
        writer.append(" ERP=\"" + AppCore.formatERP(this.peakERP) + '\"');
        if (null != this.antennaID && this.antennaID.length() > 0) {
            writer.append(" ANTENNA_ID=\"" + this.antennaID + '\"');
        }
        writer.append(" USE_GENERIC=\"" + this.useGenericVerticalPattern + '\"');
        writer.append(" APAT_ORIENT=\"" + AppCore.formatAzimuth(this.horizontalPatternOrientation) + '\"');
        writer.append(" EPAT_ETILT=\"" + AppCore.formatDepression(this.verticalPatternElectricalTilt) + '\"');
        writer.append(" EPAT_MTILT=\"" + AppCore.formatDepression(this.verticalPatternMechanicalTilt) + '\"');
        writer.append(" EPAT_ORIENT=\"" + AppCore.formatDepression(this.verticalPatternMechanicalTiltOrientation) + '\"');
        Source source = this.getSource();
        boolean bl3 = this.hasHorizontalPattern;
        if (bl3) {
            if (null == this.horizontalPattern && null != source) {
                this.horizontalPattern = source.getHorizontalPattern(errorLogger);
            }
            if (null == this.horizontalPattern) {
                bl3 = false;
            }
        }
        writer.append(" HAS_APAT=\"" + bl3 + '\"');
        if (bl3) {
            writer.append(" APAT_NAME=\"" + AppCore.xmlclean(this.horizontalPattern.name) + '\"');
        }
        boolean bl4 = bl2 = this.hasVerticalPattern && !this.hasMatrixPattern;
        if (bl2) {
            if (null == this.verticalPattern && null != source) {
                this.verticalPattern = source.getVerticalPattern(errorLogger);
            }
            if (null == this.verticalPattern) {
                bl2 = false;
            }
        }
        writer.append(" HAS_EPAT=\"" + bl2 + '\"');
        if (bl2) {
            writer.append(" EPAT_NAME=\"" + AppCore.xmlclean(this.verticalPattern.name) + '\"');
        }
        if (bl = this.hasMatrixPattern) {
            if (null == this.matrixPattern && null != source) {
                this.matrixPattern = source.getMatrixPattern(errorLogger);
            }
            if (null == this.matrixPattern) {
                bl = false;
            }
        }
        writer.append(" HAS_MPAT=\"" + bl + '\"');
        if (bl) {
            writer.append(" MPAT_NAME=\"" + AppCore.xmlclean(this.matrixPattern.name) + '\"');
        }
        writer.append(">\n");
        writer.append(AppCore.xmlclean(this.getAllAttributesNT()));
        if (bl3) {
            writer.append("<APAT>\n");
            for (AntPattern.AntPoint object : this.horizontalPattern.getPoints()) {
                writer.append(AppCore.formatAzimuth(object.angle));
                writer.append(',');
                writer.append(AppCore.formatRelativeField(object.relativeField));
                writer.append('\n');
            }
            writer.append("</APAT>\n");
        }
        if (bl2) {
            writer.append("<EPAT>\n");
            for (AntPattern.AntPoint antPoint : this.verticalPattern.getPoints()) {
                writer.append(AppCore.formatDepression(antPoint.angle));
                writer.append(',');
                writer.append(AppCore.formatRelativeField(antPoint.relativeField));
                writer.append('\n');
            }
            writer.append("</EPAT>\n");
        }
        if (bl) {
            writer.append("<MPAT>\n");
            for (AntPattern.AntSlice antSlice : this.matrixPattern.getSlices()) {
                for (AntPattern.AntPoint antPoint : antSlice.points) {
                    writer.append(AppCore.formatAzimuth(antSlice.value));
                    writer.append(',');
                    writer.append(AppCore.formatDepression(antPoint.angle));
                    writer.append(',');
                    writer.append(AppCore.formatRelativeField(antPoint.relativeField));
                    writer.append('\n');
                }
            }
            writer.append("</MPAT>\n");
        }
    }

    private static SourceEditData readSourceFromXML(String string, Reader reader, StudyEditData studyEditData, Integer n, ErrorLogger errorLogger) {
        SourceXMLHandler sourceXMLHandler = new SourceXMLHandler(studyEditData, string, n, errorLogger);
        if (!AppCore.parseXML(reader, sourceXMLHandler, errorLogger)) {
            return null;
        }
        if (null == sourceXMLHandler.source) {
            errorLogger.reportError("Invalid XML data in user record");
            return null;
        }
        return sourceXMLHandler.source;
    }

    public static ArrayList<SourceEditData> readSourcesFromXML(String string, Reader reader, Integer n, Integer n2, int n3, int n4) {
        return SourceEditData.readSourcesFromXML(string, reader, n, n2, n3, n4, null);
    }

    public static ArrayList<SourceEditData> readSourcesFromXML(String string, Reader reader, Integer n, Integer n2, int n3, int n4, ErrorLogger errorLogger) {
        SourceXMLHandler sourceXMLHandler = new SourceXMLHandler(string, n, n2, n3, n4, errorLogger);
        if (!AppCore.parseXML(reader, sourceXMLHandler, errorLogger)) {
            return null;
        }
        if (null == sourceXMLHandler.sources || sourceXMLHandler.sources.isEmpty()) {
            if (sourceXMLHandler.hadStudy) {
                errorLogger.reportWarning("No compatible records found");
            } else {
                errorLogger.reportWarning("No recognized XML structure found");
            }
            return null;
        }
        return sourceXMLHandler.sources;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parseAttributes(String var1_1, Attributes var2_2, ErrorLogger var3_3) {
        if (!this.location.parseAttributes(var1_1, var2_2, this.recordType, var3_3)) {
            return false;
        }
        this.heightAMSL = -1101.0;
        var4_4 = var2_2.getValue("HAMSL");
        if (null != var4_4) {
            try {
                this.heightAMSL = Double.parseDouble(var4_4);
            }
            catch (NumberFormatException var5_5) {
                // empty catch block
            }
        }
        if (this.heightAMSL < -1100.0 || this.heightAMSL > 10000.0) {
            if (null != var3_3) {
                var3_3.reportError("Missing or bad HAMSL attribute in " + var1_1 + " tag");
            }
            return false;
        }
        var4_4 = var2_2.getValue("HAAT");
        if (null != var4_4) {
            this.overallHAAT = -1101.0;
            try {
                this.overallHAAT = Double.parseDouble(var4_4);
            }
            catch (NumberFormatException var5_6) {
                // empty catch block
            }
            if (this.overallHAAT < -1100.0 || this.overallHAAT > 10000.0) {
                if (null != var3_3) {
                    var3_3.reportError("Bad HAAT attribute in " + var1_1 + " tag");
                }
                return false;
            }
        }
        this.peakERP = -0.99999;
        var4_4 = var2_2.getValue("ERP");
        if (null != var4_4) {
            try {
                this.peakERP = Double.parseDouble(var4_4);
            }
            catch (NumberFormatException var5_7) {
                // empty catch block
            }
        }
        if (this.peakERP < 1.0E-5 || this.peakERP > 5000.0) {
            if (null != var3_3) {
                var3_3.reportError("Missing or bad ERP attribute in " + var1_1 + " tag");
            }
            return false;
        }
        this.antennaID = var2_2.getValue("ANTENNA_ID");
        var4_4 = var2_2.getValue("APAT_ORIENT");
        if (null != var4_4) {
            try {
                this.horizontalPatternOrientation = Math.IEEEremainder(Double.parseDouble(var4_4), 360.0);
                if (this.horizontalPatternOrientation < 0.0) {
                    this.horizontalPatternOrientation += 360.0;
                }
            }
            catch (NumberFormatException var5_8) {
                if (null != var3_3) {
                    var3_3.reportError("Bad APAT_ORIENT attribute in " + var1_1 + " tag");
                }
                return false;
            }
        }
        if (null != (var4_4 = var2_2.getValue("EPAT_ETILT"))) {
            this.verticalPatternElectricalTilt = -11.0;
            try {
                this.verticalPatternElectricalTilt = Double.parseDouble(var4_4);
            }
            catch (NumberFormatException var5_9) {
                // empty catch block
            }
            if (this.verticalPatternElectricalTilt < -10.0 || this.verticalPatternElectricalTilt > 16.0) {
                if (null != var3_3) {
                    var3_3.reportError("Bad EPAT_ETILT attribute in " + var1_1 + " tag");
                }
                return false;
            }
        }
        if (null != (var4_4 = var2_2.getValue("EPAT_MTILT"))) {
            this.verticalPatternMechanicalTilt = -11.0;
            try {
                this.verticalPatternMechanicalTilt = Double.parseDouble(var4_4);
            }
            catch (NumberFormatException var5_10) {
                // empty catch block
            }
            if (this.verticalPatternMechanicalTilt < -10.0 || this.verticalPatternMechanicalTilt > 16.0) {
                if (null != var3_3) {
                    var3_3.reportError("Bad EPAT_MTILT attribute in " + var1_1 + " tag");
                }
                return false;
            }
        }
        if (null != (var4_4 = var2_2.getValue("EPAT_ORIENT"))) {
            try {
                this.verticalPatternMechanicalTiltOrientation = Math.IEEEremainder(Double.parseDouble(var4_4), 360.0);
                if (!(this.verticalPatternMechanicalTiltOrientation < 0.0)) ** GOTO lbl87
                this.verticalPatternMechanicalTiltOrientation += 360.0;
            }
            catch (NumberFormatException var5_11) {
                if (null != var3_3) {
                    var3_3.reportError("Bad EPAT_ORIENT attribute in " + var1_1 + " tag");
                }
                return false;
            }
        } else if (0.0 != this.verticalPatternMechanicalTilt) {
            if (null != var3_3) {
                var3_3.reportError("Missing EPAT_ORIENT attribute in " + var1_1 + " tag");
            }
            return false;
        }
lbl87:
        // 4 sources

        var4_4 = var2_2.getValue("USE_GENERIC");
        this.useGenericVerticalPattern = null == var4_4 || Boolean.parseBoolean(var4_4) != false;
        var4_4 = var2_2.getValue("HAS_APAT");
        this.hasHorizontalPattern = null != var4_4 && Boolean.parseBoolean(var4_4) != false;
        var4_4 = var2_2.getValue("HAS_MPAT");
        v0 = this.hasMatrixPattern = null != var4_4 && Boolean.parseBoolean(var4_4) != false;
        if (!this.hasMatrixPattern) {
            var4_4 = var2_2.getValue("HAS_EPAT");
            this.hasVerticalPattern = null != var4_4 && Boolean.parseBoolean(var4_4) != false;
        }
        return true;
    }

    public String makeCommentText() {
        String[] stringArray;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "<HTML>";
        ArrayList<String> arrayList = this.getComments();
        if (null != arrayList && !arrayList.isEmpty()) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                stringArray = (String[])object.next();
                stringBuilder.append(string);
                stringBuilder.append((String)stringArray);
                string = "<BR>";
            }
        }
        if (null != (object = SourceEditData.getSourceComment(this)) && ((String)object).length() > 0) {
            stringBuilder.append(string);
            stringArray = ((String)object).split("\\s+");
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = stringArray[i].length();
                if (n2 <= 0) continue;
                stringBuilder.append(stringArray[i]);
                if ((n += n2) > 35) {
                    stringBuilder.append("<BR>");
                    n = 0;
                    continue;
                }
                stringBuilder.append(" ");
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("</HTML>");
            return stringBuilder.toString();
        }
        return null;
    }

    protected ArrayList<String> getComments() {
        return null;
    }

    @Override
    public String getRecordType() {
        if (null != this.userRecordID) {
            return "User " + Source.getRecordTypeName(this.recordType);
        }
        if (null != this.extDbKey) {
            return ExtDb.getExtDbTypeName(this.dbID, this.extDbKey);
        }
        return "New " + Source.getRecordTypeName(this.recordType);
    }

    @Override
    public boolean isSource() {
        return true;
    }

    @Override
    public boolean hasRecordID() {
        return null != this.userRecordID || null != this.extDbKey && null != this.extRecordID;
    }

    @Override
    public boolean isReplication() {
        return false;
    }

    @Override
    public String getStationData() {
        if (null != this.userRecordID) {
            return "User record";
        }
        if (null != this.extDbKey) {
            return ExtDb.getExtDbDescription(this.dbID, this.extDbKey);
        }
        return "";
    }

    @Override
    public String getRecordID() {
        if (null != this.userRecordID) {
            return String.valueOf(this.userRecordID);
        }
        if (null != this.extDbKey && null != this.extRecordID) {
            return this.extRecordID;
        }
        return "";
    }

    @Override
    public String getFacilityID() {
        return "";
    }

    @Override
    public String getSortFacilityID() {
        return "0";
    }

    @Override
    public String getService() {
        return this.service.name;
    }

    @Override
    public String getServiceCode() {
        return this.service.serviceCode;
    }

    @Override
    public boolean isDigital() {
        return this.service.serviceType.digital;
    }

    @Override
    public boolean isDTS() {
        return this.service.isDTS;
    }

    @Override
    public String getSiteCount() {
        return "";
    }

    public String getSiteNumber() {
        return "";
    }

    @Override
    public String getCallSign() {
        return this.callSign;
    }

    @Override
    public String getChannel() {
        return "";
    }

    @Override
    public int getChannelNumber() {
        return 0;
    }

    @Override
    public String getSortChannel() {
        return "0";
    }

    @Override
    public String getOriginalChannel() {
        return this.getChannel();
    }

    @Override
    public String getFrequency() {
        return "";
    }

    @Override
    public double getFrequencyValue() {
        return 0.0;
    }

    @Override
    public String getCity() {
        return this.city;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getCountry() {
        return this.country.name;
    }

    @Override
    public String getCountryCode() {
        return this.country.countryCode;
    }

    @Override
    public String getSortCountry() {
        return String.valueOf(this.country.key);
    }

    @Override
    public String getZone() {
        return "";
    }

    @Override
    public String getStatus() {
        return "";
    }

    @Override
    public String getSortStatus() {
        return "0";
    }

    @Override
    public String getFileNumber() {
        return this.fileNumber;
    }

    @Override
    public String getARN() {
        return "";
    }

    @Override
    public String getSequenceDate() {
        String string = this.getAttribute("sequenceDate");
        if (null != string) {
            return string;
        }
        return "";
    }

    @Override
    public String getSortSequenceDate() {
        Date date = AppCore.parseDate(this.getAttribute("sequenceDate"));
        if (null != date) {
            return String.format(Locale.US, "%013d", date.getTime());
        }
        return "9999999999999";
    }

    @Override
    public String getFrequencyOffset() {
        return "";
    }

    @Override
    public String getEmissionMask() {
        return "";
    }

    @Override
    public String getLatitude() {
        return AppCore.formatLatitude(this.location.latitude);
    }

    @Override
    public String getLongitude() {
        return AppCore.formatLongitude(this.location.longitude);
    }

    @Override
    public String getHeightAMSL() {
        if (-999.0 == this.heightAMSL) {
            return "(derive)";
        }
        return AppCore.formatHeight(this.heightAMSL) + " m";
    }

    @Override
    public String getOverallHAAT() {
        if (-999.0 == this.overallHAAT) {
            return "(derive)";
        }
        return AppCore.formatHeight(this.overallHAAT) + " m";
    }

    @Override
    public String getPeakERP() {
        return AppCore.formatERP(this.peakERP) + " kW";
    }

    @Override
    public boolean hasHorizontalPattern() {
        return this.hasHorizontalPattern;
    }

    @Override
    public String getHorizontalPatternName() {
        if (this.hasHorizontalPattern) {
            String string = "unknown";
            if (null != this.horizontalPattern) {
                string = this.horizontalPattern.name;
            } else {
                Source source = this.getSource();
                if (null != source) {
                    string = source.horizontalPatternName;
                }
            }
            if (null != this.antennaID && this.antennaID.length() > 0) {
                return string + " (ID " + this.antennaID + ")";
            }
            return string;
        }
        return "Omnidirectional";
    }

    @Override
    public String getHorizontalPatternOrientation() {
        if (this.hasHorizontalPattern) {
            return AppCore.formatAzimuth(this.horizontalPatternOrientation) + " deg";
        }
        return "";
    }

    public RecordData getRecordData(ErrorLogger errorLogger) {
        Source source;
        RecordData recordData = new RecordData();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        recordData.propertyValues = treeMap;
        treeMap.put("320recordType", this.getRecordType());
        treeMap.put("330stationData", this.getStationData());
        treeMap.put("340recordID", this.getRecordID());
        treeMap.put("120service", this.getService());
        treeMap.put("110callSign", this.getCallSign());
        treeMap.put("150city", this.getCity());
        treeMap.put("160state", this.getState());
        treeMap.put("170country", this.getCountry());
        treeMap.put("190fileNumber", this.getFileNumber());
        treeMap.put("350sequenceDate", this.getSequenceDate());
        treeMap.put("220latitude", this.getLatitude());
        treeMap.put("230longitude", this.getLongitude());
        treeMap.put("260heightAMSL", this.getHeightAMSL());
        treeMap.put("270overallHAAT", this.getOverallHAAT());
        treeMap.put("280peakERP", this.getPeakERP());
        String string = "Omnidirectional";
        if (this.hasHorizontalPattern) {
            string = this.getHorizontalPatternName();
            treeMap.put("370horizontalPatternOrientation", this.getHorizontalPatternOrientation());
            if (null == this.horizontalPattern && null != (source = this.getSource())) {
                this.horizontalPattern = source.getHorizontalPattern(errorLogger);
                if (null == this.horizontalPattern) {
                    return null;
                }
            }
            if (null != this.horizontalPattern) {
                recordData.horizontalPattern = this.horizontalPattern.copy();
            }
        }
        treeMap.put("360horizontalPatternName", string);
        string = "None";
        if (this.hasVerticalPattern || this.hasMatrixPattern || this.useGenericVerticalPattern) {
            if (this.hasVerticalPattern) {
                if (null != this.verticalPattern) {
                    string = this.verticalPattern.name;
                } else {
                    source = this.getSource();
                    if (null != source) {
                        string = source.verticalPatternName;
                        this.verticalPattern = source.getVerticalPattern(errorLogger);
                        if (null == this.verticalPattern) {
                            return null;
                        }
                    }
                }
                if (null != this.verticalPattern) {
                    recordData.verticalPattern = this.verticalPattern.copy();
                }
            } else if (this.hasMatrixPattern) {
                if (null != this.matrixPattern) {
                    string = this.matrixPattern.name;
                } else {
                    source = this.getSource();
                    if (null != source) {
                        string = source.matrixPatternName;
                        this.matrixPattern = source.getMatrixPattern(errorLogger);
                        if (null == this.matrixPattern) {
                            return null;
                        }
                    }
                }
                if (null != this.matrixPattern) {
                    recordData.verticalPattern = this.matrixPattern.copy();
                }
            } else if (this.useGenericVerticalPattern) {
                string = "Generic";
            }
            if (this.hasVerticalPattern || this.useGenericVerticalPattern) {
                treeMap.put("390verticalPatternElectricalTilt", AppCore.formatDepression(this.verticalPatternElectricalTilt) + " deg");
                treeMap.put("400verticalPatternMechanicalTilt", AppCore.formatDepression(this.verticalPatternMechanicalTilt) + " deg");
                treeMap.put("410verticalPatternMechanicalTiltOrientation", AppCore.formatAzimuth(this.verticalPatternMechanicalTiltOrientation) + " deg");
            }
        }
        treeMap.put("380verticalPatternName", string);
        return recordData;
    }

    public static ArrayList<SourceEditData> readFromText(ExtDb extDb, File file, File file2, ErrorLogger errorLogger) {
        if (!extDb.isGeneric()) {
            if (null != errorLogger) {
                errorLogger.reportError("Unsupported import format for station data type");
            }
            return null;
        }
        return SourceEditData.readFromText(extDb.dbID, extDb.getDefaultRecordType(), file, file2, extDb, null, errorLogger);
    }

    public static ArrayList<SourceEditData> readFromText(StudyEditData studyEditData, int n, File file, File file2, ErrorLogger errorLogger) {
        if (!Study.isRecordTypeAllowed(studyEditData.study.studyType, n)) {
            if (null != errorLogger) {
                errorLogger.reportError("Unsupported record type for study type");
            }
            return null;
        }
        return SourceEditData.readFromText(studyEditData.dbID, n, file, file2, null, studyEditData, errorLogger);
    }

    public static ArrayList<SourceEditData> readFromText(String string, int n, File file, File file2, ErrorLogger errorLogger) {
        return SourceEditData.readFromText(string, n, file, file2, null, null, errorLogger);
    }

    private static ArrayList<SourceEditData> readFromText(String string, int n, File file, File file2, ExtDb extDb, StudyEditData studyEditData, ErrorLogger errorLogger) {
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>();
        BufferedReader bufferedReader = null;
        String string2 = "";
        String string3 = null;
        AppCore.LineCounter lineCounter = null;
        try {
            HashMap<Integer, AntPattern> hashMap = new HashMap<Integer, AntPattern>();
            if (null != file2) {
                string2 = file2.getName();
                bufferedReader = new BufferedReader(new FileReader(file2));
                lineCounter = new AppCore.LineCounter();
                lineCounter.setDelimiterForFile(file2);
                string3 = SourceEditData.readPatterns(string, bufferedReader, string2, lineCounter, hashMap, errorLogger);
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                bufferedReader = null;
                string2 = "";
                lineCounter = null;
            }
            if (null == string3) {
                string2 = file.getName();
                bufferedReader = new BufferedReader(new FileReader(file));
                lineCounter = new AppCore.LineCounter();
                lineCounter.setDelimiterForFile(file);
                string3 = SourceEditData.readSources(string, n, extDb, studyEditData, bufferedReader, string2, lineCounter, hashMap, arrayList, errorLogger);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            string3 = "Data file '" + string2 + "' could not be opened";
        }
        catch (IOException iOException) {
            string3 = "An I/O error occurred:\n" + iOException + "\n";
        }
        catch (Throwable throwable) {
            string3 = "An unexpected error occurred:\n" + throwable + "\n";
            AppCore.log(3, "Unexpected error", throwable);
        }
        if (null != bufferedReader) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (null != string3) {
            if (null != errorLogger) {
                if (null != lineCounter && lineCounter.get() > 0) {
                    string3 = string3 + "in '" + string2 + "' at line " + lineCounter;
                }
                errorLogger.reportError(string3);
            }
            return null;
        }
        return arrayList;
    }

    private static String readPatterns(String string, BufferedReader bufferedReader, String string2, AppCore.LineCounter lineCounter, HashMap<Integer, AntPattern> hashMap, ErrorLogger errorLogger) throws IOException {
        AntPattern antPattern;
        String[] stringArray;
        Integer n = null;
        AntPattern antPattern2 = null;
        boolean bl = false;
        String string3 = null;
        double d = 0.0;
        double d2 = -1.0;
        Pattern pattern = Pattern.compile(";");
        while (!(null == (stringArray = AppCore.readAndParseLine(bufferedReader, lineCounter)) || 1 == stringArray.length && stringArray[0].toLowerCase().startsWith(PATTERN_DATA_END))) {
            int n2;
            ArrayList<AntPattern.AntPoint> arrayList;
            double d3;
            boolean bl2;
            if (stringArray.length < 5) {
                return "Bad field count ";
            }
            int n3 = -1;
            String string4 = stringArray[0];
            if (string4.length() > 0) {
                try {
                    n3 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n3 <= 0) {
                return "Missing or bad antenna ID ";
            }
            if (bl && n3 != n) {
                if (d < 0.977 && null != errorLogger) {
                    errorLogger.logMessage("Pattern does not contain a 1 for antenna ID " + n + " in '" + string2 + "' at line " + lineCounter);
                }
                if (antPattern2.isDataValid(errorLogger)) {
                    antPattern = antPattern2.normalizeVerticalMatrix();
                    if (null != antPattern) {
                        hashMap.put(-n.intValue(), antPattern);
                    }
                    hashMap.put(n, antPattern2);
                    bl = false;
                    d = 0.0;
                    d2 = -1.0;
                } else {
                    return "Error occurred ";
                }
            }
            n = n3;
            int n4 = 32;
            string4 = stringArray[1];
            if (string4.length() > 0) {
                n4 = string4.toUpperCase().charAt(0);
            }
            if (65 != n4 && 69 != n4 && 77 != n4) {
                return "Missing or bad pattern type ";
            }
            boolean bl3 = bl2 = 65 == n4;
            if (!bl) {
                string3 = stringArray[2];
                if (0 == string3.length()) {
                    return "Missing pattern name ";
                }
                if (string3.length() > 255) {
                    string3 = string3.substring(0, 255);
                    if (null != errorLogger) {
                        errorLogger.logMessage("Pattern name too long, truncated, in '" + string2 + "' at line " + lineCounter);
                    }
                }
            }
            if (77 == n4) {
                string4 = stringArray[3];
                d3 = -1.0;
                if (string4.length() > 0) {
                    try {
                        d3 = Double.parseDouble(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((d3 = Math.rint(d3 * 1000.0) / 1000.0) < 0.0 || d3 > 359.999) {
                    return "Bad matrix slice azimuth ";
                }
                if (d3 <= d2) {
                    return "Matrix slices out of order or duplicated ";
                }
                d2 = d3;
                if (!bl) {
                    antPattern2 = new AntPattern(string, 2, string3);
                    bl = true;
                }
                arrayList = antPattern2.addSlice(d3);
                n2 = 4;
            } else {
                antPattern2 = bl2 ? new AntPattern(string, 1, string3) : new AntPattern(string, 2, string3);
                arrayList = antPattern2.getPoints();
                n2 = 3;
            }
            double d4 = bl2 ? -1.0 : -91.0;
            double d5 = 0.0;
            for (int i = n2; i < stringArray.length; ++i) {
                String[] stringArray2 = pattern.split(stringArray[i]);
                if (stringArray2.length != 2) {
                    return "Bad pattern point format at point " + (i - 2) + " ";
                }
                string4 = stringArray2[0];
                d3 = bl2 ? -1.0 : -91.0;
                if (string4.length() > 0) {
                    try {
                        d3 = Double.parseDouble(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (bl2) {
                    if ((d3 = Math.rint(d3 * 1000.0) / 1000.0) < 0.0 || d3 > 359.999) {
                        return "Bad azimuth at point " + (i - 2) + " ";
                    }
                } else if ((d3 = Math.rint(d3 * 1000.0) / 1000.0) < -90.0 || d3 > 90.0) {
                    return "Bad vertical angle at point " + (i - 2) + " ";
                }
                if (d3 <= d4) {
                    return "Pattern points out of order or duplicated at point " + (i - 2) + " ";
                }
                d4 = d3;
                double d6 = -1.0;
                string4 = stringArray2[1];
                if (string4.length() > 0) {
                    try {
                        d6 = Double.parseDouble(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((d6 = Math.rint(d6 * 1000.0) / 1000.0) < 0.0 || d6 > 1.0) {
                    return "Bad relative field at point " + (i - 2) + " ";
                }
                if (d6 < 0.001) {
                    d6 = 0.001;
                }
                if (d6 > d5) {
                    d5 = d6;
                }
                arrayList.add(new AntPattern.AntPoint(d3, d6));
            }
            if (bl) {
                if (d5 > d) {
                    d = d5;
                }
            } else if (d5 < 0.977 && null != errorLogger) {
                errorLogger.logMessage("Pattern does not contain a 1 for antenna ID " + n + " in '" + string2 + "' at line " + lineCounter);
            }
            if (bl) continue;
            if (antPattern2.isDataValid(errorLogger)) {
                hashMap.put(n, antPattern2);
                continue;
            }
            return "Error occurred ";
        }
        if (bl) {
            if (d < 0.977 && null != errorLogger) {
                errorLogger.logMessage("Pattern does not contain a 1 for antenna ID " + n + " in '" + string2 + "' at line " + lineCounter);
            }
            if (antPattern2.isDataValid(errorLogger)) {
                antPattern = antPattern2.normalizeVerticalMatrix();
                if (null != antPattern) {
                    hashMap.put(-n.intValue(), antPattern);
                }
                hashMap.put(n, antPattern2);
            } else {
                return "Error occurred ";
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static String readSources(String var0, int var1_1, ExtDb var2_2, StudyEditData var3_3, BufferedReader var4_4, String var5_5, AppCore.LineCounter var6_6, HashMap<Integer, AntPattern> var7_7, ArrayList<SourceEditData> var8_8, ErrorLogger var9_9) throws IOException {
        var52_10 = false;
        var53_11 = 0;
        var84_12 = null;
        var85_13 = null;
        var86_14 = null;
        var87_15 = null;
        var88_16 = null;
        var89_17 = null;
        var90_18 = AppCore.formatDate(new Date());
        while (null != (var92_81 = AppCore.readAndParseLine(var4_4, var6_6))) {
            if (1 == var92_81.length && var92_81[0].toLowerCase().startsWith("$pattern")) {
                var93_82 = SourceEditData.readPatterns(var0, var4_4, var5_5, var6_6, var7_7, var9_9);
                if (null == var93_82) continue;
                return var93_82;
            }
            var10_19 = null;
            var11_20 = null;
            var12_21 = null;
            var37_46 = null;
            var38_47 = false;
            var39_48 = false;
            var40_49 = false;
            var41_50 = false;
            var42_51 = false;
            var43_52 = false;
            var44_53 = false;
            var45_54 = false;
            var13_22 = null;
            var47_56 = -1;
            var14_23 = null;
            var48_57 = 0;
            var15_24 = null;
            var49_58 = 4;
            var16_25 = null;
            var17_26 = null;
            var50_59 = -1;
            var18_27 = null;
            var19_28 = null;
            var20_29 = null;
            var54_61 = null;
            var21_30 = null;
            var55_62 = Zone.getNullObject();
            var51_60 = -1;
            var22_31 = null;
            var56_63 = 49.0;
            var23_32 = null;
            var58_64 = -74.0;
            var24_33 = null;
            var60_65 = -181.0;
            var25_34 = null;
            var62_66 = -1101.0;
            var26_35 = null;
            var64_67 = -1101.0;
            var27_36 = null;
            var66_68 = -0.99999;
            var28_37 = null;
            var78_74 = FrequencyOffset.getNullObject();
            var29_38 = null;
            var79_75 = EmissionMask.getNullObject();
            var30_39 = null;
            var68_69 = -0.99;
            var46_55 = false;
            var31_40 = null;
            var81_77 = null;
            var32_41 = null;
            var70_70 = -1.0;
            var33_42 = null;
            var80_76 = null;
            var82_78 = null;
            var83_79 = null;
            var34_43 = null;
            var72_71 = -91.0;
            var35_44 = null;
            var74_72 = -91.0;
            var36_45 = null;
            var76_73 = -1.0;
            switch (var1_1) {
                case 1: {
                    var38_47 = true;
                    if (var92_81.length < 13 || var92_81.length > 25) {
                        return "Bad field count ";
                    }
                    var91_80 = var92_81[10].toUpperCase();
                    if (var91_80.length() > 0) {
                        if (var91_80.equals("P")) {
                            var41_50 = true;
                            var51_60 = 0;
                        } else if (var91_80.equals("R")) {
                            if (null == var86_14) {
                                return "No parent record for DTS authorized facility ";
                            }
                            if (null != var87_15) {
                                return "Multiple DTS authorized facilities for same parent ";
                            }
                            var42_51 = true;
                            var51_60 = 0;
                        } else {
                            try {
                                var51_60 = Integer.parseInt(var91_80);
                            }
                            catch (NumberFormatException var93_83) {
                                return "Bad site number ";
                            }
                        }
                    }
                    if ((var91_80 = var92_81[1].toUpperCase()).equals("DRT")) {
                        var39_48 = true;
                        var91_80 = "LD";
                    }
                    if (var91_80.length() > 0) {
                        var37_46 = Service.getService(var91_80);
                        if (null != var37_46) {
                            if (var37_46.isDTS) {
                                if (!var41_50) {
                                    if (var42_51) {
                                        return "Authorized facility record cannot be DTS service ";
                                    }
                                    if (null == var86_14) {
                                        return "No parent record for DTS site record ";
                                    }
                                    if (var37_46.key != var86_14.service.key) {
                                        return "DTS site must be same service as parent ";
                                    }
                                    var43_52 = true;
                                }
                            } else {
                                if (var41_50) {
                                    return "Parent record must be DTS service ";
                                }
                                if (!var42_51) {
                                    var40_49 = true;
                                }
                            }
                        }
                    } else if (!var41_50 && !var42_51 && null != var86_14) {
                        var43_52 = true;
                        var37_46 = var86_14.service;
                    }
                    if (null == var37_46) {
                        return "Unknown or missing service code ";
                    }
                    if (!var37_46.isTV()) {
                        return "Invalid service for record type ";
                    }
                    if (var51_60 < 0) {
                        if (var39_48 || var43_52) {
                            return "Missing site number ";
                        }
                        var51_60 = 1;
                    }
                    if ((var40_49 || var41_50) && null != var86_14) {
                        if (var86_14.service.isFullService()) {
                            if (null == var87_15 && null == var86_14.makeDTSAuthorizedSource(var2_2, var9_9)) {
                                return "Error occurred ";
                            }
                        } else {
                            if (null == var87_15) {
                                return "No authorized facility record for DTS parent ";
                            }
                            var86_14.location.setLatLon(var87_15.location);
                        }
                        if (!var86_14.isDataValid(var9_9)) {
                            return "Error occurred ";
                        }
                        var8_8.add(var86_14);
                        var86_14 = null;
                        var87_15 = null;
                    }
                    if (var40_49) {
                        var10_19 = var92_81[0];
                        var13_22 = var92_81[2];
                        var15_24 = var92_81[3];
                        var16_25 = var92_81[4];
                        var17_26 = var92_81[5];
                        var18_27 = var92_81[6];
                        var19_28 = var92_81[7];
                        var20_29 = var92_81[8].toUpperCase();
                        var21_30 = var92_81[9].toUpperCase();
                        var23_32 = var92_81[11];
                        var24_33 = var92_81[12];
                        var25_34 = var92_81.length > 13 ? var92_81[13] : "";
                        var26_35 = var92_81.length > 14 ? var92_81[14] : "";
                        var27_36 = var92_81.length > 15 ? var92_81[15] : "";
                        var31_40 = var92_81.length > 16 ? var92_81[16] : "";
                        var32_41 = var92_81.length > 17 ? var92_81[17] : "";
                        var33_42 = var92_81.length > 18 ? var92_81[18] : "";
                        var34_43 = var92_81.length > 19 ? var92_81[19] : "";
                        var35_44 = var92_81.length > 20 ? var92_81[20] : "";
                        var36_45 = var92_81.length > 21 ? var92_81[21] : "";
                        var29_38 = var92_81.length > 22 ? var92_81[22].toUpperCase() : "";
                        var28_37 = var92_81.length > 23 ? var92_81[23].toUpperCase() : "";
                    }
                    if (var41_50) {
                        var10_19 = var92_81[0];
                        var13_22 = var92_81[2];
                        var15_24 = var92_81[3];
                        var16_25 = var92_81[4];
                        var17_26 = var92_81[5];
                        var18_27 = var92_81[6];
                        var19_28 = var92_81[7];
                        var20_29 = var92_81[8].toUpperCase();
                        var21_30 = var92_81[9].toUpperCase();
                        if (var37_46.isFullService()) {
                            var23_32 = var92_81[11];
                            var24_33 = var92_81[12];
                            var22_31 = var92_81.length > 24 ? var92_81[24].toUpperCase() : "";
                        } else {
                            var22_31 = "";
                        }
                        var29_38 = var92_81.length > 22 ? var92_81[22].toUpperCase() : "";
                        var28_37 = var92_81.length > 23 ? var92_81[23].toUpperCase() : "";
                    }
                    if (var42_51) {
                        var13_22 = var92_81[2];
                        var15_24 = var92_81[3];
                        var16_25 = var92_81[4];
                        var21_30 = var92_81[9].toUpperCase();
                        var23_32 = var92_81[11];
                        var24_33 = var92_81[12];
                        var25_34 = var92_81.length > 13 ? var92_81[13] : "";
                        var26_35 = var92_81.length > 14 ? var92_81[14] : "";
                        var27_36 = var92_81.length > 15 ? var92_81[15] : "";
                        var31_40 = var92_81.length > 16 ? var92_81[16] : "";
                        var32_41 = var92_81.length > 17 ? var92_81[17] : "";
                        var33_42 = var92_81.length > 18 ? var92_81[18] : "";
                        var34_43 = var92_81.length > 19 ? var92_81[19] : "";
                        var35_44 = var92_81.length > 20 ? var92_81[20] : "";
                        var36_45 = var92_81.length > 21 ? var92_81[21] : "";
                        var29_38 = var92_81.length > 22 ? var92_81[22].toUpperCase() : "";
                        var28_37 = var92_81.length > 23 ? var92_81[23].toUpperCase() : "";
                    }
                    if (!var43_52) break;
                    var23_32 = var92_81[11];
                    var24_33 = var92_81[12];
                    var25_34 = var92_81.length > 13 ? var92_81[13] : "";
                    var26_35 = var92_81.length > 14 ? var92_81[14] : "";
                    var27_36 = var92_81.length > 15 ? var92_81[15] : "";
                    var31_40 = var92_81.length > 16 ? var92_81[16] : "";
                    var32_41 = var92_81.length > 17 ? var92_81[17] : "";
                    var33_42 = var92_81.length > 18 ? var92_81[18] : "";
                    var34_43 = var92_81.length > 19 ? var92_81[19] : "";
                    var35_44 = var92_81.length > 20 ? var92_81[20] : "";
                    if (var92_81.length > 21) {
                        var36_45 = var92_81[21];
                        break;
                    }
                    var36_45 = "";
                    break;
                }
                case 2: {
                    var44_53 = true;
                    if (var92_81.length < 7 || var92_81.length > 17) {
                        return "Bad field count ";
                    }
                    var12_21 = "WL";
                    var10_19 = var92_81[0];
                    var11_20 = var92_81[1];
                    var23_32 = var92_81[2];
                    var24_33 = var92_81[3];
                    var25_34 = var92_81[4];
                    var26_35 = var92_81[5];
                    var27_36 = var92_81[6];
                    var31_40 = var92_81.length > 7 ? var92_81[7] : "";
                    var32_41 = var92_81.length > 8 ? var92_81[8] : "";
                    var33_42 = var92_81.length > 9 ? var92_81[9] : "";
                    var34_43 = var92_81.length > 10 ? var92_81[10] : "";
                    var35_44 = var92_81.length > 11 ? var92_81[11] : "";
                    var36_45 = var92_81.length > 12 ? var92_81[12] : "";
                    var16_25 = var92_81.length > 13 ? var92_81[13] : "";
                    var18_27 = var92_81.length > 14 ? var92_81[14] : "";
                    var19_28 = var92_81.length > 15 ? var92_81[15] : "";
                    if (var92_81.length > 16) {
                        var20_29 = var92_81[16].toUpperCase();
                        break;
                    }
                    var20_29 = "US";
                    break;
                }
                case 3: {
                    var45_54 = true;
                    if (var92_81.length < 15 || var92_81.length > 22) {
                        return "Bad field count ";
                    }
                    var10_19 = var92_81[0];
                    var12_21 = var92_81[1].toUpperCase();
                    var13_22 = var92_81[2];
                    var14_23 = var92_81[3].toUpperCase();
                    var15_24 = var92_81[4].toUpperCase();
                    var16_25 = var92_81[5];
                    var17_26 = var92_81[6];
                    var18_27 = var92_81[7];
                    var19_28 = var92_81[8];
                    var20_29 = var92_81[9].toUpperCase();
                    var23_32 = var92_81[10];
                    var24_33 = var92_81[11];
                    var25_34 = var92_81[12];
                    var26_35 = var92_81[13];
                    var27_36 = var92_81[14];
                    var30_39 = var92_81.length > 15 ? var92_81[15] : "";
                    var31_40 = var92_81.length > 16 ? var92_81[16] : "";
                    var32_41 = var92_81.length > 17 ? var92_81[17] : "";
                    var33_42 = var92_81.length > 18 ? var92_81[18] : "";
                    var34_43 = var92_81.length > 19 ? var92_81[19] : "";
                    var35_44 = var92_81.length > 20 ? var92_81[20] : "";
                    if (var92_81.length > 21) {
                        var36_45 = var92_81[21];
                        break;
                    }
                    var36_45 = "";
                    break;
                }
                default: {
                    return "Unknown or unsupported station data type ";
                }
            }
            if (null != var10_19) {
                if (0 == var10_19.length()) {
                    return "Missing " + (var44_53 != false ? "cell site ID " : "call sign ");
                }
                if (var10_19.length() > 12) {
                    var10_19 = var10_19.substring(0, 12);
                    if (null != var9_9) {
                        var9_9.logMessage((var44_53 != false ? "Cell site ID" : "Call sign") + " too long, truncated, in '" + var5_5 + "' at line " + var6_6);
                    }
                }
            }
            if (null != var11_20 && var11_20.length() > 3) {
                var11_20 = var11_20.substring(0, 3);
                if (null != var9_9) {
                    var9_9.logMessage("Sector ID too long, truncated, in '" + var5_5 + "' at line " + var6_6);
                }
            }
            if (null != var12_21) {
                var37_46 = Service.getService(var12_21);
                if (null == var37_46) {
                    return "Unknown or missing service code ";
                }
                if (var38_47 != false && var37_46.isTV() == false || var44_53 != false && var37_46.isWL() == false || var45_54 && !var37_46.isFM()) {
                    return "Invalid service for record type ";
                }
            }
            if (null != var13_22) {
                try {
                    var47_56 = Integer.parseInt(var13_22);
                }
                catch (NumberFormatException var93_84) {
                    // empty catch block
                }
                if (var45_54 && (var47_56 < 200 || var47_56 > 300) || var38_47 && (var47_56 < 2 || var47_56 > 69)) {
                    return "Bad channel number ";
                }
            }
            if (null != var14_23) {
                for (var93_85 = 1; var93_85 < ExtDbRecordFM.FM_CLASS_CODES.length; ++var93_85) {
                    if (!var14_23.equals(ExtDbRecordFM.FM_CLASS_CODES[var93_85])) continue;
                    var48_57 = var93_85;
                    break;
                }
            }
            if (null != var15_24) {
                var49_58 = ExtDbRecord.getStatusType(var15_24);
            }
            if (null != var16_25 && var16_25.length() > 255) {
                var16_25 = var16_25.substring(0, 255);
            }
            if (null != var17_26) {
                try {
                    var50_59 = Integer.parseInt(var17_26);
                }
                catch (NumberFormatException var93_86) {
                    // empty catch block
                }
                if (var50_59 <= 0) {
                    return "Missing or bad facility ID ";
                }
            }
            if (null != var18_27) {
                if (var18_27.length() > 20) {
                    var18_27 = var18_27.substring(0, 20);
                }
                if (!var44_53 && 0 == var18_27.length()) {
                    return "Missing city name ";
                }
            }
            if (null != var19_28) {
                if (var19_28.length() > 2) {
                    var19_28 = var19_28.substring(0, 2);
                }
                if (!var44_53 && 0 == var19_28.length()) {
                    return "Missing state code ";
                }
            }
            if (null != var20_29 && null == (var54_61 = Country.getCountry(var20_29))) {
                return "Missing or unknown country code ";
            }
            if (null != var21_30) {
                var55_62 = Zone.getZone(var21_30);
            }
            if (null != var22_31) {
                if (var22_31.length() > 0) {
                    try {
                        var56_63 = Double.parseDouble(var22_31);
                        if (var56_63 != 0.0 && (var56_63 < 50.0 || var56_63 > 200.0)) {
                            return "Bad DTS maximum distance ";
                        }
                        var22_31 = "";
                    }
                    catch (NumberFormatException var93_87) {
                        var91_80 = GeoSectors.validateString(var22_31);
                        if (null != var91_80) {
                            return var91_80 + " ";
                        }
                        var56_63 = 0.0;
                    }
                } else {
                    var56_63 = 0.0;
                }
            }
            if (null != var23_32) {
                if (var23_32.length() > 0) {
                    try {
                        var58_64 = Double.parseDouble(var23_32);
                    }
                    catch (NumberFormatException var93_88) {
                        // empty catch block
                    }
                }
                if (var58_64 < -73.0 || var58_64 > 73.5) {
                    return "Missing or bad latitude ";
                }
            }
            if (null != var24_33) {
                if (var24_33.length() > 0) {
                    try {
                        var60_65 = Double.parseDouble(var24_33);
                        if (var44_53) {
                            var60_65 = -var60_65;
                        }
                    }
                    catch (NumberFormatException var93_89) {
                        // empty catch block
                    }
                }
                if (var60_65 < -180.0 || var60_65 > 180.0) {
                    return "Missing or bad longitude ";
                }
            }
            if (null != var25_34) {
                if (var25_34.length() > 0) {
                    try {
                        var62_66 = Double.parseDouble(var25_34);
                    }
                    catch (NumberFormatException var93_90) {
                        // empty catch block
                    }
                }
                if (var62_66 < -1100.0 || var62_66 > 10000.0) {
                    return "Missing or bad AMSL height ";
                }
            }
            if (null != var26_35) {
                if (var26_35.length() > 0) {
                    try {
                        var64_67 = Double.parseDouble(var26_35);
                    }
                    catch (NumberFormatException var93_91) {
                        // empty catch block
                    }
                    if (var64_67 < -1100.0 || var64_67 > 10000.0) {
                        return "Missing or bad HAAT ";
                    }
                } else {
                    var64_67 = -999.0;
                }
            }
            if (null != var27_36) {
                if (var27_36.length() > 0) {
                    try {
                        var66_68 = Double.parseDouble(var27_36);
                    }
                    catch (NumberFormatException var93_92) {
                        // empty catch block
                    }
                }
                if (var66_68 < 1.0E-5 || var66_68 > 5000.0) {
                    return "Missing or bad ERP ";
                }
            }
            if (null != var28_37) {
                var78_74 = FrequencyOffset.getFrequencyOffset(var28_37);
            }
            if (null != var29_38 && var37_46.serviceType.needsEmissionMask) {
                var79_75 = EmissionMask.getEmissionMask(var29_38);
                if (var79_75.key <= 0) {
                    return "Missing or bad emission mask code ";
                }
            }
            if (null != var30_39) {
                if (var30_39.length() > 0) {
                    try {
                        var68_69 = Double.parseDouble(var30_39);
                    }
                    catch (NumberFormatException var93_93) {
                        // empty catch block
                    }
                    if (var68_69 >= 1.0) {
                        var68_69 /= 100.0;
                    }
                    if (var68_69 < 0.01 || var68_69 > 0.1) {
                        return "Bad IBOC power ";
                    }
                    var46_55 = true;
                } else {
                    var68_69 = 0.01;
                }
            }
            if (null != var31_40 && var31_40.length() > 0) {
                try {
                    var53_11 = Integer.parseInt(var31_40);
                    if (var53_11 > 0) {
                        var81_77 = var7_7.get(var53_11);
                    }
                }
                catch (NumberFormatException var93_94) {
                    // empty catch block
                }
                if (null == var81_77) {
                    return "Bad or unknown azimuth antenna ID ";
                }
                if (1 != var81_77.type) {
                    return "Wrong type for azimuth pattern ";
                }
            }
            if (null != var32_41) {
                if (var32_41.length() > 0) {
                    try {
                        var70_70 = Math.IEEEremainder(Double.parseDouble(var32_41), 360.0);
                        if (var70_70 < 0.0) {
                            var70_70 += 360.0;
                        }
                    }
                    catch (NumberFormatException var93_95) {
                        // empty catch block
                    }
                    if (var70_70 < 0.0 || var70_70 > 359.999) {
                        return "Bad pattern orientation ";
                    }
                } else {
                    var70_70 = 0.0;
                }
            }
            if (null != var33_42 && var33_42.length() > 0) {
                try {
                    var53_11 = Integer.parseInt(var33_42);
                    if (var53_11 > 0) {
                        var82_78 = var7_7.get(var53_11);
                    }
                }
                catch (NumberFormatException var93_96) {
                    // empty catch block
                }
                if (null == var82_78) {
                    return "Bad elevation antenna ID ";
                }
                if (2 != var82_78.type) {
                    return "Wrong type for elevation pattern ";
                }
                var83_79 = var7_7.get(-var53_11);
                if (null != var83_79) {
                    if (null != var81_77 && null != var9_9) {
                        var9_9.logMessage("Matrix envelope overriding azimuth pattern, in '" + var5_5 + "' at line " + var6_6);
                    }
                    var81_77 = var83_79;
                }
            }
            if (null != var34_43) {
                if (var34_43.length() > 0) {
                    try {
                        var72_71 = Double.parseDouble(var34_43);
                    }
                    catch (NumberFormatException var93_97) {
                        // empty catch block
                    }
                    if (var72_71 < -10.0 || var72_71 > 16.0) {
                        return "Bad electrical tilt ";
                    }
                } else {
                    var72_71 = 0.0;
                }
            }
            if (null != var35_44) {
                if (var35_44.length() > 0) {
                    try {
                        var74_72 = Double.parseDouble(var35_44);
                    }
                    catch (NumberFormatException var93_98) {
                        // empty catch block
                    }
                    if (var74_72 < -10.0 || var74_72 > 16.0) {
                        return "Bad mechanical tilt ";
                    }
                } else {
                    var74_72 = 0.0;
                }
            }
            if (null != var36_45) {
                if (var36_45.length() > 0) {
                    try {
                        var76_73 = Math.IEEEremainder(Double.parseDouble(var36_45), 360.0);
                        if (!(var76_73 < 0.0)) ** GOTO lbl494
                        var76_73 += 360.0;
                    }
                    catch (NumberFormatException var93_99) {
                        return "Bad mechanical tilt orientation ";
                    }
                } else {
                    var76_73 = var70_70;
                }
            }
lbl494:
            // 5 sources

            var84_12 = null;
            if (null != var2_2) {
                if (var38_47) {
                    if (var42_51 || var43_52) {
                        var85_13 = var86_14.addExtDTSSource(var2_2, var37_46, var51_60, var9_9);
                        var84_12 = var85_13;
                    } else {
                        var85_13 = SourceEditDataTV.createExtSource(var2_2, var50_59, var37_46, var39_48, var54_61, var9_9);
                        var84_12 = var85_13;
                    }
                } else if (var44_53) {
                    var88_16 = SourceEditDataWL.createExtSource(var2_2, var37_46, var54_61, var9_9);
                    var84_12 = var88_16;
                } else if (var45_54) {
                    var89_17 = SourceEditDataFM.createExtSource(var2_2, var50_59, var37_46, var48_57, var54_61, var9_9);
                    var84_12 = var89_17;
                }
            } else if (var38_47) {
                if (var42_51 || var43_52) {
                    var85_13 = var86_14.addDTSSource(var37_46, var51_60, var9_9);
                    var84_12 = var85_13;
                } else {
                    var85_13 = SourceEditDataTV.createSource(var3_3, var0, var50_59, var37_46, var39_48, var54_61, false, var9_9);
                    var84_12 = var85_13;
                }
            } else if (var44_53) {
                var88_16 = SourceEditDataWL.createSource(var3_3, var0, var37_46, var54_61, false, var9_9);
                var84_12 = var88_16;
            } else if (var45_54) {
                var89_17 = SourceEditDataFM.createSource(var3_3, var0, var50_59, var37_46, var48_57, var54_61, false, var9_9);
                var84_12 = var89_17;
            }
            if (null == var84_12) {
                return "Error occurred ";
            }
            var84_12.location.setLatLon(var58_64, var60_65);
            if (var41_50) {
                var86_14 = var85_13;
                var85_13.dtsMaximumDistance = var56_63;
                var85_13.dtsSectors = var22_31;
            } else {
                var84_12.heightAMSL = var62_66;
                var84_12.overallHAAT = var64_67;
                var84_12.peakERP = var66_68;
                if (null != var81_77) {
                    var84_12.hasHorizontalPattern = true;
                    var84_12.horizontalPattern = var81_77;
                    var84_12.horizontalPatternChanged = true;
                }
                var84_12.horizontalPatternOrientation = var70_70;
                if (null != var82_78) {
                    if (var82_78.isSimple()) {
                        var84_12.hasVerticalPattern = true;
                        var84_12.verticalPattern = var82_78;
                        var84_12.verticalPatternChanged = true;
                    } else {
                        var84_12.hasMatrixPattern = true;
                        var84_12.matrixPattern = var82_78;
                        var84_12.matrixPatternChanged = true;
                    }
                }
                var84_12.verticalPatternElectricalTilt = var72_71;
                var84_12.verticalPatternMechanicalTilt = var74_72;
                var84_12.verticalPatternMechanicalTiltOrientation = var76_73;
            }
            if (var38_47) {
                if (var42_51) {
                    var87_15 = var85_13;
                    var85_13.channel = var47_56;
                    var85_13.status = var15_24;
                    var85_13.statusType = var49_58;
                    var85_13.fileNumber = var16_25;
                    var85_13.zone = var55_62;
                    var85_13.frequencyOffset = var78_74;
                    var85_13.emissionMask = var79_75;
                } else if (!var43_52) {
                    var85_13.callSign = var10_19;
                    var85_13.channel = var47_56;
                    var85_13.status = var15_24;
                    var85_13.statusType = var49_58;
                    var85_13.fileNumber = var16_25;
                    var85_13.city = var18_27;
                    var85_13.state = var19_28;
                    var85_13.zone = var55_62;
                    var85_13.frequencyOffset = var78_74;
                    var85_13.emissionMask = var79_75;
                    var85_13.siteNumber = var51_60;
                }
                if (null != var15_24 && var15_24.equals("BL")) {
                    var84_12.setAttribute("isBaseline");
                }
            } else if (var44_53) {
                var88_16.callSign = var10_19;
                var88_16.sectorID = var11_20;
                var88_16.fileNumber = var16_25;
                var88_16.city = var18_27;
                var88_16.state = var19_28;
            } else if (var45_54) {
                var89_17.callSign = var10_19;
                var89_17.channel = var47_56;
                var89_17.status = var15_24;
                var89_17.statusType = var49_58;
                var89_17.fileNumber = var16_25;
                var89_17.city = var18_27;
                var89_17.state = var19_28;
                var89_17.isIBOC = var46_55;
                var89_17.ibocFraction = var68_69;
            }
            var84_12.setAttribute("sequenceDate", var90_18);
            if (var38_47 && !var40_49) continue;
            if (!var84_12.isDataValid(var9_9)) {
                return "Error occurred ";
            }
            var8_8.add(var84_12);
        }
        if (null != var86_14) {
            if (var86_14.service.isFullService()) {
                if (null == var87_15 && null == var86_14.makeDTSAuthorizedSource(var2_2, var9_9)) {
                    return "Error occurred ";
                }
            } else {
                if (null == var87_15) {
                    return "No authorized facility record for DTS parent ";
                }
                var86_14.location.setLatLon(var87_15.location);
            }
            if (!var86_14.isDataValid(var9_9)) {
                return "Error occurred ";
            }
            var8_8.add(var86_14);
            var86_14 = null;
            var87_15 = null;
        }
        return null;
    }

    public static void writeToCSV(BufferedWriter bufferedWriter, int n, ArrayList<SourceEditData> arrayList, ErrorLogger errorLogger) throws IOException {
        block5: for (SourceEditData sourceEditData : arrayList) {
            int n2;
            if (n != sourceEditData.recordType) continue;
            if (sourceEditData.service.isDTS) {
                boolean bl = true;
                n2 = 1;
                for (SourceEditDataTV sourceEditDataTV2 : ((SourceEditDataTV)sourceEditData).getDTSSources()) {
                    if (sourceEditDataTV2.hasHorizontalPattern || sourceEditDataTV2.hasMatrixPattern || sourceEditDataTV2.hasVerticalPattern) {
                        if (bl) {
                            bufferedWriter.write(PATTERN_DATA_START);
                            bufferedWriter.write(10);
                            bl = false;
                        }
                        if (!SourceEditData.writePatternsToCSV(bufferedWriter, sourceEditDataTV2, n2, errorLogger)) {
                            return;
                        }
                    }
                    n2 += 2;
                }
                if (!bl) {
                    bufferedWriter.write(PATTERN_DATA_END);
                    bufferedWriter.write(10);
                }
            } else if (sourceEditData.hasHorizontalPattern || sourceEditData.hasMatrixPattern || sourceEditData.hasVerticalPattern) {
                bufferedWriter.write(PATTERN_DATA_START);
                bufferedWriter.write(10);
                if (!SourceEditData.writePatternsToCSV(bufferedWriter, sourceEditData, 1, errorLogger)) {
                    return;
                }
                bufferedWriter.write(PATTERN_DATA_END);
                bufferedWriter.write(10);
            }
            switch (n) {
                case 1: {
                    SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
                    bufferedWriter.write(sourceEditDataTV.callSign);
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataTV.service.serviceCode);
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataTV.channel));
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataTV.status);
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataTV.fileNumber);
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataTV.facilityID));
                    bufferedWriter.write(",\"");
                    bufferedWriter.write(sourceEditDataTV.city);
                    bufferedWriter.write("\",");
                    bufferedWriter.write(sourceEditDataTV.state);
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataTV.country.countryCode);
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataTV.zone.zoneCode);
                    bufferedWriter.write(44);
                    if (sourceEditDataTV.service.isDTS) {
                        bufferedWriter.write(80);
                    } else {
                        bufferedWriter.write(String.valueOf(sourceEditDataTV.siteNumber));
                    }
                    bufferedWriter.write(44);
                    if (sourceEditDataTV.service.isDTS) {
                        if (sourceEditDataTV.service.isFullService()) {
                            bufferedWriter.write(String.valueOf(sourceEditDataTV.location.latitude));
                            bufferedWriter.write(44);
                            bufferedWriter.write(String.valueOf(sourceEditDataTV.location.longitude));
                        } else {
                            bufferedWriter.write(44);
                        }
                        bufferedWriter.write(",,,,,,,,,,");
                        if (sourceEditDataTV.service.serviceType.needsEmissionMask) {
                            bufferedWriter.write(sourceEditDataTV.emissionMask.emissionMaskCode);
                        }
                        bufferedWriter.write(44);
                        bufferedWriter.write(sourceEditDataTV.frequencyOffset.frequencyOffsetCode);
                        if (sourceEditDataTV.service.isFullService()) {
                            bufferedWriter.write(44);
                            if (sourceEditDataTV.dtsSectors.length() > 0) {
                                bufferedWriter.write("\"");
                                bufferedWriter.write(sourceEditDataTV.dtsSectors);
                                bufferedWriter.write("\"");
                            } else if (sourceEditDataTV.dtsMaximumDistance > 0.0) {
                                bufferedWriter.write(String.valueOf(sourceEditDataTV.dtsMaximumDistance));
                            }
                        }
                    } else {
                        bufferedWriter.write(String.valueOf(sourceEditDataTV.location.latitude));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV.location.longitude));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV.heightAMSL));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV.overallHAAT));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV.peakERP));
                        bufferedWriter.write(44);
                        if (sourceEditData.hasHorizontalPattern) {
                            bufferedWriter.write(49);
                        }
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV.horizontalPatternOrientation));
                        bufferedWriter.write(44);
                        if (sourceEditDataTV.hasMatrixPattern || sourceEditDataTV.hasVerticalPattern) {
                            bufferedWriter.write(50);
                        }
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV.verticalPatternElectricalTilt));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV.verticalPatternMechanicalTilt));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV.verticalPatternMechanicalTiltOrientation));
                        bufferedWriter.write(44);
                        if (sourceEditDataTV.service.serviceType.needsEmissionMask) {
                            bufferedWriter.write(sourceEditDataTV.emissionMask.emissionMaskCode);
                        }
                        bufferedWriter.write(44);
                        bufferedWriter.write(sourceEditDataTV.frequencyOffset.frequencyOffsetCode);
                    }
                    bufferedWriter.write(10);
                    if (!sourceEditDataTV.service.isDTS) break;
                    n2 = 1;
                    for (SourceEditDataTV sourceEditDataTV2 : sourceEditDataTV.getDTSSources()) {
                        bufferedWriter.write(44);
                        if (0 == sourceEditDataTV2.siteNumber) {
                            bufferedWriter.write(sourceEditDataTV2.service.serviceCode);
                            bufferedWriter.write(44);
                            bufferedWriter.write(String.valueOf(sourceEditDataTV2.channel));
                            bufferedWriter.write(44);
                            bufferedWriter.write(sourceEditDataTV2.status);
                            bufferedWriter.write(44);
                            bufferedWriter.write(sourceEditDataTV2.fileNumber);
                            bufferedWriter.write(44);
                        } else {
                            bufferedWriter.write(",,,,");
                        }
                        bufferedWriter.write(",,,,");
                        if (0 == sourceEditDataTV2.siteNumber) {
                            bufferedWriter.write(sourceEditDataTV2.zone.zoneCode);
                        }
                        bufferedWriter.write(44);
                        if (0 == sourceEditDataTV2.siteNumber) {
                            bufferedWriter.write(82);
                        } else {
                            bufferedWriter.write(String.valueOf(sourceEditDataTV2.siteNumber));
                        }
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV2.location.latitude));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV2.location.longitude));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV2.heightAMSL));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV2.overallHAAT));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV2.peakERP));
                        bufferedWriter.write(44);
                        if (sourceEditDataTV2.hasHorizontalPattern) {
                            bufferedWriter.write(String.valueOf(n2));
                        }
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV2.horizontalPatternOrientation));
                        bufferedWriter.write(44);
                        if (sourceEditDataTV2.hasMatrixPattern || sourceEditDataTV2.hasVerticalPattern) {
                            bufferedWriter.write(String.valueOf(n2 + 1));
                        }
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV2.verticalPatternElectricalTilt));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV2.verticalPatternMechanicalTilt));
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(sourceEditDataTV2.verticalPatternMechanicalTiltOrientation));
                        bufferedWriter.write(44);
                        if (0 == sourceEditDataTV2.siteNumber) {
                            bufferedWriter.write(sourceEditDataTV2.emissionMask.emissionMaskCode);
                            bufferedWriter.write(44);
                            bufferedWriter.write(sourceEditDataTV2.frequencyOffset.frequencyOffsetCode);
                        } else {
                            bufferedWriter.write(44);
                        }
                        bufferedWriter.write(10);
                        n2 += 2;
                    }
                    continue block5;
                }
                case 2: {
                    SourceEditDataWL sourceEditDataWL = (SourceEditDataWL)sourceEditData;
                    bufferedWriter.write(sourceEditDataWL.callSign);
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataWL.sectorID);
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataWL.location.latitude));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(-sourceEditDataWL.location.longitude));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataWL.heightAMSL));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataWL.overallHAAT));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataWL.peakERP));
                    bufferedWriter.write(44);
                    if (sourceEditDataWL.hasHorizontalPattern) {
                        bufferedWriter.write(49);
                    }
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataWL.horizontalPatternOrientation));
                    bufferedWriter.write(44);
                    if (sourceEditDataWL.hasMatrixPattern || sourceEditDataWL.hasVerticalPattern) {
                        bufferedWriter.write(50);
                    }
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataWL.verticalPatternElectricalTilt));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataWL.verticalPatternMechanicalTilt));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataWL.verticalPatternMechanicalTiltOrientation));
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataWL.fileNumber);
                    bufferedWriter.write(",\"");
                    bufferedWriter.write(sourceEditDataWL.city);
                    bufferedWriter.write("\",");
                    bufferedWriter.write(sourceEditDataWL.state);
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataWL.country.countryCode);
                    bufferedWriter.write(10);
                    break;
                }
                case 3: {
                    SourceEditDataFM sourceEditDataFM = (SourceEditDataFM)sourceEditData;
                    bufferedWriter.write(sourceEditDataFM.callSign);
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataFM.service.serviceCode);
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataFM.channel));
                    bufferedWriter.write(44);
                    bufferedWriter.write(ExtDbRecordFM.FM_CLASS_CODES[sourceEditDataFM.stationClass]);
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataFM.status);
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataFM.fileNumber);
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataFM.facilityID));
                    bufferedWriter.write(",\"");
                    bufferedWriter.write(sourceEditDataFM.city);
                    bufferedWriter.write("\",");
                    bufferedWriter.write(sourceEditDataFM.state);
                    bufferedWriter.write(44);
                    bufferedWriter.write(sourceEditDataFM.country.countryCode);
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataFM.location.latitude));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataFM.location.longitude));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataFM.heightAMSL));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataFM.overallHAAT));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataFM.peakERP));
                    bufferedWriter.write(44);
                    if (sourceEditDataFM.isIBOC) {
                        bufferedWriter.write(String.valueOf(sourceEditDataFM.ibocFraction * 100.0));
                    }
                    bufferedWriter.write(44);
                    if (sourceEditDataFM.hasHorizontalPattern) {
                        bufferedWriter.write(49);
                    }
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataFM.horizontalPatternOrientation));
                    bufferedWriter.write(44);
                    if (sourceEditDataFM.hasMatrixPattern || sourceEditDataFM.hasVerticalPattern) {
                        bufferedWriter.write(50);
                    }
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataFM.verticalPatternElectricalTilt));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataFM.verticalPatternMechanicalTilt));
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(sourceEditDataFM.verticalPatternMechanicalTiltOrientation));
                    bufferedWriter.write(10);
                }
            }
        }
    }

    private static boolean writePatternsToCSV(BufferedWriter bufferedWriter, SourceEditData sourceEditData, int n, ErrorLogger errorLogger) throws IOException {
        AntPattern antPattern;
        if (sourceEditData.hasHorizontalPattern) {
            antPattern = sourceEditData.getHorizontalPattern(errorLogger);
            if (null == antPattern) {
                return false;
            }
            bufferedWriter.write(String.valueOf(n));
            bufferedWriter.write(",A,\"");
            bufferedWriter.write(antPattern.name);
            bufferedWriter.write(34);
            for (AntPattern.AntPoint object : antPattern.getPoints()) {
                bufferedWriter.write(44);
                bufferedWriter.write(String.valueOf(object.angle));
                bufferedWriter.write(59);
                bufferedWriter.write(String.valueOf(object.relativeField));
            }
            bufferedWriter.write(10);
        }
        if (sourceEditData.hasMatrixPattern || sourceEditData.hasVerticalPattern) {
            antPattern = sourceEditData.getVerticalPattern(errorLogger);
            if (null == antPattern) {
                return false;
            }
            if (antPattern.isMatrix()) {
                boolean bl = true;
                for (AntPattern.AntSlice antSlice : antPattern.getSlices()) {
                    bufferedWriter.write(String.valueOf(n + 1));
                    bufferedWriter.write(",M,");
                    if (bl) {
                        bufferedWriter.write(34);
                        bufferedWriter.write(antPattern.name);
                        bufferedWriter.write(34);
                        bl = false;
                    }
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(antSlice.value));
                    for (AntPattern.AntPoint antPoint : antSlice.points) {
                        bufferedWriter.write(44);
                        bufferedWriter.write(String.valueOf(antPoint.angle));
                        bufferedWriter.write(59);
                        bufferedWriter.write(String.valueOf(antPoint.relativeField));
                    }
                    bufferedWriter.write(10);
                }
            } else {
                bufferedWriter.write(String.valueOf(n + 1));
                bufferedWriter.write(",E,\"");
                bufferedWriter.write(antPattern.name);
                bufferedWriter.write(34);
                for (AntPattern.AntPoint antPoint : antPattern.getPoints()) {
                    bufferedWriter.write(44);
                    bufferedWriter.write(String.valueOf(antPoint.angle));
                    bufferedWriter.write(59);
                    bufferedWriter.write(String.valueOf(antPoint.relativeField));
                }
                bufferedWriter.write(10);
            }
        }
        return true;
    }

    public static class SourceXMLHandler
    extends DefaultHandler {
        public ArrayList<SourceEditData> sources;
        public SourceEditData source;
        public int scenarioCount;
        public boolean hadStudy;
        private StudyEditData study;
        private String dbID;
        private Integer userRecordID;
        private int parseRecordType;
        private int parseStudyType;
        private ErrorLogger errors;
        private Locator locator;
        private boolean userRecordMode;
        private boolean scenarioMode;
        private LookupIndex lookupIndex;
        private LookupIndex alternateIndex;
        private HashSet<String> searchIDs;
        private ArrayList<SearchItem> searchItems;
        private boolean ignoreAll;
        private boolean inStudy;
        private int xmlVersion;
        private ArrayList<SourceEditData> studyNewSources;
        private ArrayList<ScenarioItem> scenarioItems;
        private boolean inScenario;
        private String scenarioName;
        private String scenarioDescription;
        private ArrayList<Scenario.SourceListItem> scenarioSourceItems;
        private HashMap<Integer, ArrayList<String>> scenarioParameters;
        private boolean hasDesiredTV;
        private boolean inParameter;
        private int parameterKey;
        private ArrayList<String> parameterValues;
        private boolean inValue;
        private int valueIndex;
        private boolean inSource;
        private boolean isDesired;
        private boolean isUndesired;
        private SourceEditData newSource;
        private SourceEditDataTV newSourceTV;
        private SourceEditDataWL newSourceWL;
        private SourceEditDataFM newSourceFM;
        private boolean didMakeSource;
        private int replicateToChannel;
        private boolean inDTSSource;
        private SourceEditDataTV newDTSSource;
        private String horizontalPatternName;
        private String verticalPatternName;
        private String matrixPatternName;
        private boolean inPat;
        private ArrayDeque<String> elements;
        private ArrayDeque<StringWriter> buffers;
        private Pattern patternParser;

        public SourceXMLHandler(StudyEditData studyEditData, Integer n, Integer n2, ErrorLogger errorLogger) {
            this.doSetup(studyEditData, studyEditData.dbID, n, n2, null, 0, studyEditData.study.studyType, errorLogger);
        }

        private SourceXMLHandler(StudyEditData studyEditData, String string, Integer n, ErrorLogger errorLogger) {
            this.doSetup(studyEditData, string, null, null, n, 0, 0, errorLogger);
        }

        public SourceXMLHandler(String string, Integer n, Integer n2, int n3, int n4, ErrorLogger errorLogger) {
            this.doSetup(null, string, n, n2, null, n3, n4, errorLogger);
        }

        private void doSetup(StudyEditData studyEditData, String string, Integer n, Integer n2, Integer n3, int n4, int n5, ErrorLogger errorLogger) {
            this.study = studyEditData;
            this.dbID = string;
            this.userRecordID = n3;
            this.parseRecordType = n4;
            this.parseStudyType = n5;
            this.errors = errorLogger;
            boolean bl = this.userRecordMode = null != this.userRecordID;
            if (!this.userRecordMode) {
                boolean bl2 = this.scenarioMode = null != this.study;
            }
            if (!this.userRecordMode) {
                if (null == n) {
                    n2 = null;
                }
                ExtDb extDb = null;
                if (null == n && this.scenarioMode) {
                    n = this.study.extDbKey;
                }
                if (null != n && null != (extDb = ExtDb.getExtDb(this.dbID, n))) {
                    switch (this.parseRecordType) {
                        case 0: {
                            if (ExtDbRecordTV.isExtDbSupported(extDb) || ExtDbRecordFM.isExtDbSupported(extDb)) break;
                            extDb = null;
                            break;
                        }
                        case 1: {
                            if (ExtDbRecordTV.isExtDbSupported(extDb)) break;
                            extDb = null;
                            break;
                        }
                        case 3: {
                            if (ExtDbRecordFM.isExtDbSupported(extDb)) break;
                            extDb = null;
                            break;
                        }
                        default: {
                            extDb = null;
                        }
                    }
                }
                if (null != extDb) {
                    this.lookupIndex = new LookupIndex();
                    this.lookupIndex.lookupExtDb = extDb;
                    this.lookupIndex.sharedSources = new HashMap();
                    this.searchIDs = new HashSet();
                    if (this.scenarioMode) {
                        this.lookupIndex.sharedReplicationSources = new ArrayList();
                        this.study.loadSharedSourceIndex(((LookupIndex)this.lookupIndex).lookupExtDb.key, this.lookupIndex.sharedSources, this.lookupIndex.sharedReplicationSources);
                        this.searchItems = new ArrayList();
                    }
                    extDb = null;
                    if (null != n2 && null != (extDb = ExtDb.getExtDb(this.dbID, n2))) {
                        switch (this.parseRecordType) {
                            case 0: {
                                if (ExtDbRecordTV.isExtDbSupported(extDb) || ExtDbRecordFM.isExtDbSupported(extDb)) break;
                                extDb = null;
                                break;
                            }
                            case 1: {
                                if (ExtDbRecordTV.isExtDbSupported(extDb)) break;
                                extDb = null;
                                break;
                            }
                            case 3: {
                                if (ExtDbRecordFM.isExtDbSupported(extDb)) break;
                                extDb = null;
                                break;
                            }
                            default: {
                                extDb = null;
                            }
                        }
                    }
                    if (null != extDb) {
                        this.alternateIndex = new LookupIndex();
                        this.alternateIndex.lookupExtDb = extDb;
                        this.alternateIndex.sharedSources = new HashMap();
                        if (this.scenarioMode) {
                            this.alternateIndex.sharedReplicationSources = new ArrayList();
                            this.study.loadSharedSourceIndex(((LookupIndex)this.alternateIndex).lookupExtDb.key, this.alternateIndex.sharedSources, this.alternateIndex.sharedReplicationSources);
                        }
                    }
                }
            }
            if (!this.scenarioMode && !this.userRecordMode) {
                this.sources = new ArrayList();
            }
            this.valueIndex = -1;
            this.elements = new ArrayDeque();
            this.buffers = new ArrayDeque();
            this.patternParser = Pattern.compile("[,\\n]");
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private void throwError(String string) throws SAXException {
            if (null != this.errors) {
                if (null != this.locator) {
                    if (null == string) {
                        string = "Error occurred ";
                    }
                    this.errors.reportError(string + " at line " + String.valueOf(this.locator.getLineNumber()));
                } else if (null != string) {
                    this.errors.reportError(string);
                }
            }
            throw new SAXException();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.elements.push(string3);
            this.buffers.push(new StringWriter());
            if (string3.equals("TVSTUDY")) {
                if (this.hadStudy || this.ignoreAll) {
                    return;
                }
                if (this.inStudy) {
                    this.throwError("TVSTUDY elements may not be nested");
                }
                this.inStudy = true;
                this.hadStudy = true;
                String string4 = attributes.getValue("VERSION");
                if (null != string4) {
                    try {
                        this.xmlVersion = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.xmlVersion <= 0) {
                    this.throwError("Missing or bad VERSION attribute in TVSTUDY tag");
                }
                if (this.xmlVersion < 103000 || this.xmlVersion > 105000) {
                    this.throwError("Format version is not supported");
                }
                if (this.scenarioMode) {
                    this.studyNewSources = new ArrayList();
                    this.scenarioItems = new ArrayList();
                }
                return;
            }
            if (string3.equals("SCENARIO")) {
                if (!this.inStudy || !this.scenarioMode || this.ignoreAll) {
                    return;
                }
                if (this.inScenario) {
                    this.throwError("SCENARIO elements may not be nested");
                }
                this.inScenario = true;
                this.scenarioName = attributes.getValue("NAME");
                if (null == this.scenarioName || !DbCore.checkScenarioName(this.scenarioName, this.study, false)) {
                    this.scenarioName = "Import";
                }
                this.scenarioDescription = "";
                this.scenarioSourceItems = new ArrayList();
                this.scenarioParameters = new HashMap();
                return;
            }
            if (string3.equals("DESCRIPTION")) {
                return;
            }
            if (string3.equals("PARAMETER")) {
                if (!this.inScenario || this.ignoreAll) {
                    return;
                }
                if (this.inParameter) {
                    this.throwError("PARAMETER elements may not be nested");
                }
                this.inParameter = true;
                String string5 = attributes.getValue("KEY");
                if (null != string5) {
                    try {
                        this.parameterKey = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.parameterKey <= 0) {
                    this.throwError("Missing or bad KEY attribute in PARAMETER tag");
                }
                this.parameterValues = new ArrayList();
                return;
            }
            if (string3.equals("VALUE")) {
                if (!this.inParameter || this.ignoreAll) {
                    return;
                }
                if (this.inValue) {
                    this.throwError("VALUE elements cannot be nested");
                }
                this.inValue = true;
                String string6 = attributes.getValue("INDEX");
                if (null != string6) {
                    try {
                        this.valueIndex = Integer.parseInt(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.valueIndex < 0 || this.valueIndex >= 6) {
                    this.throwError("Missing or bad INDEX attribute in VALUE tag");
                }
                if (this.valueIndex >= this.parameterValues.size()) {
                    for (int i = this.parameterValues.size(); i <= this.valueIndex; ++i) {
                        this.parameterValues.add(null);
                    }
                }
                return;
            }
            if (string3.equals("SOURCE")) {
                boolean bl;
                if (!this.inStudy || this.scenarioMode && !this.inScenario || this.ignoreAll) {
                    return;
                }
                if (this.inSource) {
                    this.throwError("SOURCE elements may not be nested");
                }
                this.inSource = true;
                Service service = null;
                String string7 = attributes.getValue("SERVICE");
                if (null != string7 && null == (service = Service.getService(string7))) {
                    this.throwError("Bad SERVICE attribute in SOURCE tag");
                }
                int n = 1;
                if (this.xmlVersion >= 105000) {
                    if (null == service) {
                        this.throwError("Missing SERVICE attribute in SOURCE tag");
                    }
                    n = service.serviceType.recordType;
                }
                if (this.parseRecordType > 0) {
                    if (n != this.parseRecordType) {
                        this.inSource = false;
                        return;
                    }
                } else if (this.parseStudyType > 0 && !Study.isRecordTypeAllowed(this.parseStudyType, n)) {
                    this.inSource = false;
                    return;
                }
                if (this.inScenario) {
                    string7 = attributes.getValue("DESIRED");
                    if (null == string7) {
                        string7 = attributes.getValue("STUDY");
                    }
                    this.isDesired = null == string7 || Boolean.valueOf(string7) != false;
                    string7 = attributes.getValue("UNDESIRED");
                    this.isUndesired = null == string7 || Boolean.valueOf(string7) != false;
                }
                boolean bl2 = bl = null == (string7 = attributes.getValue("LOCKED")) || Boolean.valueOf(string7) != false;
                if (this.inScenario && 1 == n && null != (string7 = attributes.getValue("REPLICATE"))) {
                    try {
                        this.replicateToChannel = Integer.parseInt(string7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (this.replicateToChannel < 2 || this.replicateToChannel > 69) {
                        this.throwError("Bad REPLICATE attribute in SOURCE tag");
                    }
                }
                String string8 = null;
                if (!this.userRecordMode && 2 != n && null == (string8 = attributes.getValue("RECORD_ID"))) {
                    string8 = attributes.getValue("CDBS_ID");
                }
                if (bl && null != string8) {
                    if (null == this.lookupIndex) {
                        this.inSource = false;
                    } else {
                        this.newSource = (SourceEditData)this.lookupIndex.sharedSources.get(string8);
                        if (null == this.newSource && null != this.alternateIndex) {
                            this.newSource = (SourceEditData)this.alternateIndex.sharedSources.get(string8);
                        }
                        if (null == this.newSource) {
                            this.searchIDs.add(string8);
                            if (this.inScenario) {
                                SearchItem searchItem = new SearchItem();
                                searchItem.extRecordID = string8;
                                searchItem.isDesired = this.isDesired;
                                searchItem.isUndesired = this.isUndesired;
                                searchItem.replicateToChannel = this.replicateToChannel;
                                this.searchItems.add(searchItem);
                            }
                            this.inSource = false;
                        } else if (this.inScenario) {
                            switch (n) {
                                case 1: {
                                    this.newSourceTV = (SourceEditDataTV)this.newSource;
                                    break;
                                }
                                case 3: {
                                    this.newSourceFM = (SourceEditDataFM)this.newSource;
                                }
                            }
                        } else {
                            this.inSource = false;
                        }
                    }
                    return;
                }
                if (null == service) {
                    this.throwError("Missing SERVICE attribute in SOURCE tag");
                }
                Country country = null;
                string7 = attributes.getValue("COUNTRY");
                if (null != string7) {
                    country = Country.getCountry(string7);
                }
                if (null == country) {
                    this.throwError("Missing or bad COUNTRY attribute in SOURCE tag");
                }
                Integer n2 = null;
                if (this.userRecordMode) {
                    bl = true;
                    string8 = null;
                } else if (null != this.lookupIndex && null != string8 && ExtDbRecord.doesRecordIDExist(this.lookupIndex.lookupExtDb, string8)) {
                    n2 = ((LookupIndex)this.lookupIndex).lookupExtDb.key;
                } else {
                    string8 = null;
                }
                switch (n) {
                    case 1: {
                        this.newSourceTV = SourceEditDataTV.makeSourceWithAttributesTV(string3, attributes, this.study, this.dbID, service, country, bl, this.userRecordID, n2, string8, this.errors);
                        if (null == this.newSourceTV) {
                            this.throwError(null);
                        }
                        this.newSource = this.newSourceTV;
                        if (!this.inScenario) break;
                        if (0 == this.replicateToChannel) {
                            if (this.newSourceTV.channel >= this.study.getMinimumChannel() && this.newSourceTV.channel <= this.study.getMaximumChannel()) break;
                            if (null != this.errors) {
                                this.errors.logMessage(ExtDbRecord.makeMessage(this.newSource, "Ignored, channel is out of range for study"));
                            }
                            this.inSource = false;
                            return;
                        }
                        if (this.replicateToChannel >= this.study.getMinimumChannel() && this.replicateToChannel <= this.study.getMaximumChannel()) break;
                        if (null != this.errors) {
                            this.errors.logMessage(ExtDbRecord.makeMessage(this.newSource, "Ignored, replication channel " + String.valueOf(this.replicateToChannel) + " is out of range for study"));
                        }
                        this.inSource = false;
                        return;
                    }
                    case 2: {
                        this.newSourceWL = SourceEditDataWL.makeSourceWithAttributesWL(string3, attributes, this.study, this.dbID, service, country, bl, this.userRecordID, null, null, this.errors);
                        if (null == this.newSourceWL) {
                            this.throwError(null);
                        }
                        this.newSource = this.newSourceWL;
                        break;
                    }
                    case 3: {
                        this.newSourceFM = SourceEditDataFM.makeSourceWithAttributesFM(string3, attributes, this.study, this.dbID, service, country, bl, this.userRecordID, n2, string8, this.errors);
                        if (null == this.newSourceFM) {
                            this.throwError(null);
                        }
                        this.newSource = this.newSourceFM;
                    }
                }
                this.didMakeSource = true;
                string7 = attributes.getValue("APAT_NAME");
                if (null != string7) {
                    if (string7.length() > 255) {
                        string7 = string7.substring(0, 255);
                    }
                    this.horizontalPatternName = string7;
                } else {
                    this.horizontalPatternName = "";
                }
                string7 = attributes.getValue("EPAT_NAME");
                if (null != string7) {
                    if (string7.length() > 255) {
                        string7 = string7.substring(0, 255);
                    }
                    this.verticalPatternName = string7;
                } else {
                    this.verticalPatternName = "";
                }
                string7 = attributes.getValue("MPAT_NAME");
                if (null != string7) {
                    if (string7.length() > 255) {
                        string7 = string7.substring(0, 255);
                    }
                    this.matrixPatternName = string7;
                } else {
                    this.matrixPatternName = "";
                }
                return;
            }
            if (string3.equals("DTS_SOURCE")) {
                String string9;
                if (!this.inSource || !this.didMakeSource || this.ignoreAll) {
                    return;
                }
                if (this.inDTSSource) {
                    this.throwError("DTS_SOURCE elements may not be nested");
                }
                this.inDTSSource = true;
                if (null == this.newSourceTV || !this.newSourceTV.isParent) {
                    this.throwError("DTS_SOURCE not allowed in non-parent SOURCE element");
                }
                this.newDTSSource = this.newSourceTV.addDTSSourceWithAttributes(string3, attributes, this.errors);
                if (null == this.newDTSSource) {
                    this.throwError(null);
                }
                if (null != (string9 = attributes.getValue("APAT_NAME"))) {
                    if (string9.length() > 255) {
                        string9 = string9.substring(0, 255);
                    }
                    this.horizontalPatternName = string9;
                } else {
                    this.horizontalPatternName = "";
                }
                string9 = attributes.getValue("EPAT_NAME");
                if (null != string9) {
                    if (string9.length() > 255) {
                        string9 = string9.substring(0, 255);
                    }
                    this.verticalPatternName = string9;
                } else {
                    this.verticalPatternName = "";
                }
                string9 = attributes.getValue("MPAT_NAME");
                if (null != string9) {
                    if (string9.length() > 255) {
                        string9 = string9.substring(0, 255);
                    }
                    this.matrixPatternName = string9;
                } else {
                    this.matrixPatternName = "";
                }
                return;
            }
            boolean bl = string3.equals("APAT");
            boolean bl3 = string3.equals("EPAT");
            boolean bl4 = string3.equals("MPAT");
            if (bl || bl3 || bl4) {
                if (!this.inSource || !this.didMakeSource || this.ignoreAll) {
                    return;
                }
                SourceEditData sourceEditData = this.newSource;
                if (null != this.newDTSSource) {
                    sourceEditData = this.newDTSSource;
                }
                if (bl && !sourceEditData.hasHorizontalPattern || bl3 && !sourceEditData.hasVerticalPattern || bl4 && !sourceEditData.hasMatrixPattern) {
                    return;
                }
                if (this.inPat) {
                    this.throwError("APAT/EPAT/MPAT elements may not be nested");
                }
                this.inPat = true;
                return;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (!this.buffers.isEmpty()) {
                this.buffers.peek().write(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4 = this.elements.pop();
            String string5 = this.buffers.pop().toString().trim();
            if (!string4.equals(string3)) {
                this.throwError("Overlapping or un-terminated elements");
            }
            if (string4.equals("TVSTUDY")) {
                if (this.inStudy) {
                    if (null != this.lookupIndex && !this.searchIDs.isEmpty()) {
                        this.doSearch(this.lookupIndex);
                        if (!this.searchIDs.isEmpty() && null != this.alternateIndex) {
                            this.doSearch(this.alternateIndex);
                        }
                        if (!this.searchIDs.isEmpty()) {
                            this.errors.logMessage("Record IDs not found in data sets:");
                            for (String object : this.searchIDs) {
                                this.errors.logMessage(object);
                            }
                        }
                        this.searchIDs.clear();
                    }
                    if (this.scenarioMode && !this.scenarioItems.isEmpty()) {
                        for (SourceEditData bl2 : this.studyNewSources) {
                            this.study.addOrReplaceSource(bl2);
                        }
                        for (ScenarioItem scenarioItem : this.scenarioItems) {
                            ScenarioEditData scenarioEditData = new ScenarioEditData(this.study, scenarioItem.name, scenarioItem.description, scenarioItem.sourceItems);
                            if (!scenarioItem.parameters.isEmpty()) {
                                for (Integer n : scenarioItem.parameters.keySet()) {
                                    ParameterEditData parameterEditData = scenarioEditData.getParameter(n);
                                    if (null == parameterEditData) continue;
                                    ArrayList arrayList = (ArrayList)scenarioItem.parameters.get(n);
                                    int n2 = arrayList.size();
                                    if (n2 > parameterEditData.parameter.valueCount) {
                                        n2 = parameterEditData.parameter.valueCount;
                                    }
                                    for (int i = 0; i < n2; ++i) {
                                        String string6 = (String)arrayList.get(i);
                                        if (null == string6) continue;
                                        parameterEditData.value[i] = string6;
                                    }
                                }
                            }
                            this.study.scenarioData.addOrReplace(scenarioEditData);
                            ++this.scenarioCount;
                        }
                    }
                    this.inStudy = false;
                }
                this.xmlVersion = 0;
                this.studyNewSources = null;
                this.scenarioItems = null;
                return;
            }
            if (string4.equals("SCENARIO")) {
                if (this.inScenario) {
                    if (null != this.lookupIndex && !this.searchIDs.isEmpty()) {
                        this.doSearch(this.lookupIndex);
                        if (!this.searchIDs.isEmpty() && null != this.alternateIndex) {
                            this.doSearch(this.alternateIndex);
                        }
                        if (!this.searchIDs.isEmpty()) {
                            this.errors.logMessage("Record IDs not found in data sets:");
                            for (String string7 : this.searchIDs) {
                                this.errors.logMessage(string7);
                            }
                        }
                        this.searchIDs.clear();
                        this.searchItems.clear();
                    }
                    if (!this.scenarioSourceItems.isEmpty() && (2 != this.study.study.studyType && 3 != this.study.study.studyType && 5 != this.study.study.studyType || this.hasDesiredTV)) {
                        ScenarioItem scenarioItem = new ScenarioItem();
                        scenarioItem.name = this.scenarioName;
                        scenarioItem.description = this.scenarioDescription;
                        scenarioItem.sourceItems = this.scenarioSourceItems;
                        scenarioItem.parameters = this.scenarioParameters;
                        this.scenarioItems.add(scenarioItem);
                    }
                    this.inScenario = false;
                }
                this.scenarioName = null;
                this.scenarioDescription = null;
                this.scenarioSourceItems = null;
                this.scenarioParameters = null;
                this.hasDesiredTV = false;
                return;
            }
            if (string4.equals("DESCRIPTION")) {
                if (this.inScenario) {
                    this.scenarioDescription = string5;
                }
                return;
            }
            if (string4.equals("PARAMETER")) {
                if (this.inParameter) {
                    if (!this.parameterValues.isEmpty()) {
                        this.scenarioParameters.put(this.parameterKey, this.parameterValues);
                    }
                    this.inParameter = false;
                }
                this.parameterKey = 0;
                this.parameterValues = null;
                return;
            }
            if (string4.equals("VALUE")) {
                if (this.inValue) {
                    if (string5.length() > 0) {
                        this.parameterValues.set(this.valueIndex, string5);
                    }
                    this.inValue = false;
                }
                this.valueIndex = -1;
                return;
            }
            if (string4.equals("SOURCE")) {
                if (this.inSource) {
                    if (this.didMakeSource) {
                        if (null != this.newSourceTV && this.newSourceTV.isParent) {
                            boolean bl;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            SourceEditDataTV sourceEditDataTV = null;
                            for (SourceEditDataTV sourceEditDataTV2 : this.newSourceTV.getDTSSources()) {
                                if (0 == sourceEditDataTV2.siteNumber) {
                                    if (null != sourceEditDataTV) {
                                        boolean bl4 = true;
                                        break;
                                    }
                                    sourceEditDataTV = sourceEditDataTV2;
                                    continue;
                                }
                                bl2 = true;
                            }
                            if (null == sourceEditDataTV || !bl2) {
                                bl = true;
                            }
                            if (bl) {
                                this.throwError("Incomplete or invalid set of DTS_SOURCE elements within SOURCE element");
                            }
                            if (!this.newSourceTV.service.isFullService()) {
                                this.newSourceTV.location.setLatLon(sourceEditDataTV.location);
                            }
                        }
                        if (this.newSource.hasHorizontalPattern && null == this.newSource.horizontalPattern) {
                            this.throwError("Missing APAT element in SOURCE element");
                        }
                        if (this.newSource.hasVerticalPattern && null == this.newSource.verticalPattern) {
                            this.throwError("Missing EPAT element in SOURCE element");
                        }
                        if (this.newSource.hasMatrixPattern) {
                            AntPattern antPattern;
                            if (null == this.newSource.matrixPattern) {
                                this.throwError("Missing MPAT element in SOURCE element");
                            }
                            if (null != (antPattern = this.newSource.matrixPattern.normalizeVerticalMatrix())) {
                                this.newSource.hasHorizontalPattern = true;
                                this.newSource.horizontalPattern = antPattern;
                                this.newSource.horizontalPatternChanged = true;
                            }
                        }
                        this.newSource.setAllAttributesNT(string5);
                        if (this.scenarioMode) {
                            if (this.inScenario) {
                                this.studyNewSources.add(this.newSource);
                            }
                        } else if (this.userRecordMode) {
                            this.source = this.newSource;
                            this.ignoreAll = true;
                        } else {
                            this.sources.add(this.newSource);
                        }
                    }
                    if (this.inScenario) {
                        this.doScenarioAdd(this.newSource, this.isDesired, this.isUndesired, this.newSourceTV, this.replicateToChannel);
                    }
                    this.inSource = false;
                }
                this.isDesired = false;
                this.isUndesired = false;
                this.newSource = null;
                this.newSourceTV = null;
                this.newSourceWL = null;
                this.newSourceFM = null;
                this.didMakeSource = false;
                this.replicateToChannel = 0;
                this.horizontalPatternName = null;
                this.verticalPatternName = null;
                this.matrixPatternName = null;
                return;
            }
            if (string4.equals("DTS_SOURCE")) {
                if (this.inDTSSource) {
                    if (this.didMakeSource) {
                        if (this.newDTSSource.hasHorizontalPattern && null == this.newDTSSource.horizontalPattern) {
                            this.throwError("Missing APAT element in DTS_SOURCE element");
                        }
                        if (this.newDTSSource.hasVerticalPattern && null == this.newDTSSource.verticalPattern) {
                            this.throwError("Missing EPAT element in DTS_SOURCE element");
                        }
                        if (this.newDTSSource.hasMatrixPattern) {
                            AntPattern antPattern;
                            if (null == this.newDTSSource.matrixPattern) {
                                this.throwError("Missing MPAT element in DTS_SOURCE element");
                            }
                            if (null != (antPattern = this.newDTSSource.matrixPattern.normalizeVerticalMatrix())) {
                                this.newDTSSource.hasHorizontalPattern = true;
                                this.newDTSSource.horizontalPattern = antPattern;
                                this.newDTSSource.horizontalPatternChanged = true;
                            }
                        }
                        this.newDTSSource.setAllAttributesNT(string5);
                    }
                    this.inDTSSource = false;
                }
                this.newDTSSource = null;
                return;
            }
            boolean bl = string4.equals("APAT");
            boolean bl5 = string4.equals("EPAT");
            boolean bl6 = string4.equals("MPAT");
            if (bl || bl5 || bl6) {
                if (this.inPat) {
                    boolean bl7 = false;
                    SourceEditData sourceEditData = this.newSource;
                    if (null != this.newDTSSource) {
                        sourceEditData = this.newDTSSource;
                    }
                    String[] stringArray = this.patternParser.split(string5);
                    if (bl || bl5) {
                        double d;
                        double d2;
                        double d3;
                        ArrayList<AntPattern.AntPoint> arrayList = new ArrayList<AntPattern.AntPoint>();
                        if (bl) {
                            d3 = 0.0;
                            d2 = 359.999;
                            d = -1.0;
                        } else {
                            d3 = -90.0;
                            d2 = 90.0;
                            d = -91.0;
                        }
                        for (int i = 1; i < stringArray.length; i += 2) {
                            double d4;
                            double d5;
                            try {
                                d5 = Double.parseDouble(stringArray[i - 1]);
                                d4 = Double.parseDouble(stringArray[i]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                bl7 = true;
                                break;
                            }
                            if (d5 < d3 || d5 > d2) {
                                bl7 = true;
                                break;
                            }
                            if (d5 <= d) {
                                bl7 = true;
                                break;
                            }
                            d = d5;
                            if (d4 < 0.001 || d4 > 1.0) {
                                bl7 = true;
                                break;
                            }
                            arrayList.add(new AntPattern.AntPoint(d5, d4));
                        }
                        if (!bl7 && arrayList.size() < 2) {
                            bl7 = true;
                        }
                        if (!bl7) {
                            if (bl) {
                                sourceEditData.hasHorizontalPattern = true;
                                sourceEditData.horizontalPattern = new AntPattern(this.dbID, 1, this.horizontalPatternName, arrayList);
                                sourceEditData.horizontalPatternChanged = true;
                            } else {
                                sourceEditData.hasVerticalPattern = true;
                                sourceEditData.verticalPattern = new AntPattern(this.dbID, 2, this.verticalPatternName, arrayList);
                                sourceEditData.verticalPatternChanged = true;
                            }
                        }
                    } else {
                        ArrayList<AntPattern.AntSlice> arrayList = new ArrayList<AntPattern.AntSlice>();
                        ArrayList<AntPattern.AntPoint> arrayList2 = null;
                        double d = -1.0;
                        double d6 = -91.0;
                        for (int i = 2; i < stringArray.length; i += 3) {
                            double d7;
                            double d8;
                            double d9;
                            try {
                                d9 = Double.parseDouble(stringArray[i - 2]);
                                d8 = Double.parseDouble(stringArray[i - 1]);
                                d7 = Double.parseDouble(stringArray[i]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                bl7 = true;
                                break;
                            }
                            if (d9 < 0.0 || d9 > 359.999) {
                                bl7 = true;
                                break;
                            }
                            if (d8 < -90.0 || d8 > 90.0) {
                                bl7 = true;
                                break;
                            }
                            if (d9 != d) {
                                if (d9 <= d) {
                                    bl7 = true;
                                    break;
                                }
                                d = d9;
                                if (null != arrayList2 && arrayList2.size() < 2) {
                                    bl7 = true;
                                    break;
                                }
                                arrayList2 = new ArrayList<AntPattern.AntPoint>();
                                arrayList.add(new AntPattern.AntSlice(d9, arrayList2));
                                d6 = -91.0;
                            }
                            if (d8 <= d6) {
                                bl7 = true;
                                break;
                            }
                            d6 = d8;
                            if (d7 < 0.001 || d7 > 1.0) {
                                bl7 = true;
                                break;
                            }
                            arrayList2.add(new AntPattern.AntPoint(d8, d7));
                        }
                        if (!bl7 && null != arrayList2 && arrayList2.size() < 2) {
                            bl7 = true;
                        }
                        if (!bl7 && arrayList.size() < 2) {
                            bl7 = true;
                        }
                        if (!bl7) {
                            sourceEditData.hasMatrixPattern = true;
                            sourceEditData.matrixPattern = new AntPattern(this.dbID, this.matrixPatternName, 2, arrayList);
                            sourceEditData.matrixPatternChanged = true;
                        }
                    }
                    if (bl7) {
                        this.throwError("Bad data in APAT/EPAT/MPAT element");
                    }
                    this.inPat = false;
                }
                return;
            }
        }

        private void doSearch(LookupIndex lookupIndex) throws SAXException {
            SourceEditData sourceEditData;
            SourceEditData sourceEditData2;
            Object object;
            HashMap<String, ExtDbRecord> hashMap;
            if (lookupIndex.lookupExtDb.canProvide(1) && (0 == this.parseRecordType || 1 == this.parseRecordType) && (0 == this.parseStudyType || Study.isRecordTypeAllowed(this.parseStudyType, 1))) {
                hashMap = ExtDbRecordTV.batchFindRecordTV(lookupIndex.lookupExtDb, this.searchIDs, this.errors);
                if (null == hashMap) {
                    this.throwError(null);
                }
                if (!hashMap.isEmpty()) {
                    if (this.inScenario) {
                        for (SearchItem searchItem : this.searchItems) {
                            object = (ExtDbRecordTV)hashMap.get(searchItem.extRecordID);
                            if (null == object) continue;
                            this.searchIDs.remove(searchItem.extRecordID);
                            if (0 == searchItem.replicateToChannel) {
                                searchItem.replicateToChannel = ((ExtDbRecordTV)object).replicateToChannel;
                            }
                            if (0 == searchItem.replicateToChannel) {
                                if (((ExtDbRecordTV)object).channel < this.study.getMinimumChannel() || ((ExtDbRecordTV)object).channel > this.study.getMaximumChannel()) {
                                    if (null == this.errors) continue;
                                    this.errors.logMessage(ExtDbRecord.makeMessage((StationRecord)object, "Ignored, channel is out of range for study"));
                                    continue;
                                }
                            } else if (searchItem.replicateToChannel < this.study.getMinimumChannel() || searchItem.replicateToChannel > this.study.getMaximumChannel()) {
                                if (null == this.errors) continue;
                                this.errors.logMessage(ExtDbRecord.makeMessage((StationRecord)object, "Ignored, replication channel " + String.valueOf(searchItem.replicateToChannel) + " is out of range for study"));
                                continue;
                            }
                            if (null == (sourceEditData2 = (SourceEditData)lookupIndex.sharedSources.get(searchItem.extRecordID))) {
                                sourceEditData = SourceEditDataTV.makeSourceTV((ExtDbRecordTV)object, this.study, true, this.errors);
                                if (null == sourceEditData) {
                                    this.throwError(null);
                                }
                                sourceEditData2 = sourceEditData;
                                lookupIndex.sharedSources.put(searchItem.extRecordID, sourceEditData2);
                                this.studyNewSources.add(sourceEditData2);
                            } else {
                                sourceEditData = (SourceEditDataTV)sourceEditData2;
                            }
                            this.doScenarioAdd(sourceEditData2, searchItem.isDesired, searchItem.isUndesired, (SourceEditDataTV)sourceEditData, searchItem.replicateToChannel);
                        }
                    }
                    if (!this.scenarioMode) {
                        for (ExtDbRecordTV extDbRecordTV : hashMap.values()) {
                            this.searchIDs.remove(extDbRecordTV.extRecordID);
                            if (extDbRecordTV.replicateToChannel > 0) continue;
                            sourceEditData = SourceEditDataTV.makeSourceTV(extDbRecordTV, null, true, this.errors);
                            if (null == sourceEditData) {
                                this.throwError(null);
                            }
                            this.sources.add(sourceEditData);
                        }
                    }
                }
            }
            if (lookupIndex.lookupExtDb.canProvide(3) && (0 == this.parseRecordType || 3 == this.parseRecordType) && (0 == this.parseStudyType || Study.isRecordTypeAllowed(this.parseStudyType, 3))) {
                hashMap = ExtDbRecordFM.batchFindRecordFM(lookupIndex.lookupExtDb, this.searchIDs, this.errors);
                if (null == hashMap) {
                    this.throwError(null);
                }
                if (!hashMap.isEmpty()) {
                    if (this.inScenario) {
                        for (SearchItem searchItem : this.searchItems) {
                            object = (ExtDbRecordFM)hashMap.get(searchItem.extRecordID);
                            if (null == object) continue;
                            this.searchIDs.remove(searchItem.extRecordID);
                            sourceEditData2 = (SourceEditData)lookupIndex.sharedSources.get(searchItem.extRecordID);
                            if (null == sourceEditData2) {
                                sourceEditData = SourceEditDataFM.makeSourceFM((ExtDbRecordFM)object, this.study, true, this.errors);
                                if (null == sourceEditData) {
                                    this.throwError(null);
                                }
                                sourceEditData2 = sourceEditData;
                                lookupIndex.sharedSources.put(((ExtDbRecordFM)object).extRecordID, sourceEditData2);
                                this.studyNewSources.add(sourceEditData2);
                            }
                            this.doScenarioAdd(sourceEditData2, searchItem.isDesired, searchItem.isUndesired, null, 0);
                        }
                    }
                    if (!this.scenarioMode) {
                        for (ExtDbRecordFM extDbRecordFM : hashMap.values()) {
                            this.searchIDs.remove(extDbRecordFM.extRecordID);
                            sourceEditData = SourceEditDataFM.makeSourceFM(extDbRecordFM, null, true, this.errors);
                            if (null == sourceEditData) {
                                this.throwError(null);
                            }
                            this.sources.add(sourceEditData);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void doScenarioAdd(SourceEditData sourceEditData, boolean bl, boolean bl2, SourceEditDataTV sourceEditDataTV, int n) throws SAXException {
            if (!(null == sourceEditDataTV || n <= 0 || n == sourceEditDataTV.channel && sourceEditDataTV.service.serviceType.digital)) {
                void var7_11;
                SourceEditDataTV sourceEditDataTV2 = sourceEditDataTV;
                sourceEditDataTV = null;
                Object object = null;
                if (null != sourceEditDataTV2.extDbKey && null != sourceEditDataTV2.extRecordID && null != this.lookupIndex) {
                    if (sourceEditDataTV2.extDbKey.equals(this.lookupIndex.lookupExtDb)) {
                        LookupIndex lookupIndex = this.lookupIndex;
                    } else if (null != this.alternateIndex && sourceEditDataTV2.extDbKey.equals(this.alternateIndex.lookupExtDb)) {
                        LookupIndex lookupIndex = this.alternateIndex;
                    }
                }
                if (null != var7_11 && sourceEditDataTV2.isLocked) {
                    sourceEditDataTV = (SourceEditDataTV)((HashMap)((LookupIndex)var7_11).sharedReplicationSources.get(n - 2)).get(sourceEditDataTV2.extRecordID);
                }
                if (null == sourceEditDataTV) {
                    sourceEditDataTV = sourceEditDataTV2.replicate(n, this.errors);
                    if (null == sourceEditDataTV) {
                        this.throwError(null);
                    }
                    if (null != var7_11 && sourceEditDataTV2.isLocked) {
                        ((HashMap)((LookupIndex)var7_11).sharedReplicationSources.get(n - 2)).put(sourceEditDataTV2.extRecordID, sourceEditDataTV);
                    }
                    this.studyNewSources.add(sourceEditDataTV);
                }
                sourceEditData = sourceEditDataTV;
            }
            for (Scenario.SourceListItem sourceListItem : this.scenarioSourceItems) {
                if (sourceEditData.key != sourceListItem.key) continue;
                return;
            }
            boolean bl3 = false;
            if (2 == this.study.study.studyType || 3 == this.study.study.studyType || 5 == this.study.study.studyType) {
                if (null != sourceEditDataTV) {
                    if (this.hasDesiredTV) {
                        bl = false;
                    } else if (bl) {
                        if (5 == this.study.study.studyType) {
                            if (6 == sourceEditDataTV.channel) {
                                this.hasDesiredTV = true;
                                bl2 = true;
                                bl3 = true;
                            } else {
                                bl = false;
                            }
                        } else {
                            this.hasDesiredTV = true;
                            bl2 = false;
                            bl3 = true;
                        }
                    }
                } else if (5 != this.study.study.studyType) {
                    bl = false;
                }
            }
            this.scenarioSourceItems.add(new Scenario.SourceListItem(sourceEditData.key, bl, bl2, bl3));
        }

        private class ScenarioItem {
            private String name;
            private String description;
            private ArrayList<Scenario.SourceListItem> sourceItems;
            private HashMap<Integer, ArrayList<String>> parameters;

            private ScenarioItem() {
            }
        }

        private class SearchItem {
            private String extRecordID;
            private boolean isDesired;
            private boolean isUndesired;
            private int replicateToChannel;

            private SearchItem() {
            }
        }

        private class LookupIndex {
            private ExtDb lookupExtDb;
            private HashMap<String, SourceEditData> sharedSources;
            private ArrayList<HashMap<String, SourceEditDataTV>> sharedReplicationSources;

            private LookupIndex() {
            }
        }
    }

    public static class RecordData {
        public static final String KEY_CALL_SIGN = "110callSign";
        public static final String KEY_SERVICE = "120service";
        public static final String KEY_CHANNEL = "130channel";
        public static final String KEY_STATUS = "140status";
        public static final String KEY_CITY = "150city";
        public static final String KEY_STATE = "160state";
        public static final String KEY_COUNTRY = "170country";
        public static final String KEY_FACILITY_ID = "180facilityID";
        public static final String KEY_FILE_NUMBER = "190fileNumber";
        public static final String KEY_SITE_COUNT = "200siteCount";
        public static final String KEY_SITE_NUMBER = "210siteNumber";
        public static final String KEY_LATITUDE = "220latitude";
        public static final String KEY_LONGITUDE = "230longitude";
        public static final String KEY_ZONE = "240zone";
        public static final String KEY_DTS_MAXIMUM_DISTANCE = "250dtsMaximumDistance";
        public static final String KEY_HEIGHT_AMSL = "260heightAMSL";
        public static final String KEY_OVERALL_HAAT = "270overallHAAT";
        public static final String KEY_PEAK_ERP = "280peakERP";
        public static final String KEY_FREQUENCY_OFFSET = "290frequencyOffset";
        public static final String KEY_EMISSION_MASK = "300emissionMask";
        public static final String KEY_DTS_TIME_DELAY = "310dtsTimeDelay";
        public static final String KEY_RECORD_TYPE = "320recordType";
        public static final String KEY_STATION_DATA = "330stationData";
        public static final String KEY_RECORD_ID = "340recordID";
        public static final String KEY_SEQUENCE_DATE = "350sequenceDate";
        public static final String KEY_HORIZONTAL_PATTERN_NAME = "360horizontalPatternName";
        public static final String KEY_HORIZONTAL_PATTERN_ORIENTATION = "370horizontalPatternOrientation";
        public static final String KEY_VERTICAL_PATTERN_NAME = "380verticalPatternName";
        public static final String KEY_VERTICAL_PATTERN_ELECTRICAL_TILT = "390verticalPatternElectricalTilt";
        public static final String KEY_VERTICAL_PATTERN_MECHANICAL_TILT = "400verticalPatternMechanicalTilt";
        public static final String KEY_VERTICAL_PATTERN_MECHANICAL_TILT_ORIENTATION = "410verticalPatternMechanicalTiltOrientation";
        public static final HashMap<String, String> propertyNames = new HashMap();
        public TreeMap<String, String> propertyValues;
        public AntPattern horizontalPattern;
        public AntPattern verticalPattern;
        public TreeMap<Integer, RecordData> dependentData;

        static {
            propertyNames.put(KEY_RECORD_TYPE, "Record type");
            propertyNames.put(KEY_STATION_DATA, "Station data");
            propertyNames.put(KEY_RECORD_ID, "Record ID");
            propertyNames.put(KEY_FILE_NUMBER, "File number");
            propertyNames.put(KEY_SEQUENCE_DATE, "Date");
            propertyNames.put(KEY_SERVICE, "Service");
            propertyNames.put(KEY_CALL_SIGN, "Call sign");
            propertyNames.put(KEY_CHANNEL, "Channel");
            propertyNames.put(KEY_STATUS, "Status");
            propertyNames.put(KEY_CITY, "City");
            propertyNames.put(KEY_STATE, "State");
            propertyNames.put(KEY_COUNTRY, "Country");
            propertyNames.put(KEY_FACILITY_ID, "Facility ID");
            propertyNames.put(KEY_SITE_COUNT, "Site count");
            propertyNames.put(KEY_SITE_NUMBER, "Site number");
            propertyNames.put(KEY_LATITUDE, "Latitude");
            propertyNames.put(KEY_LONGITUDE, "Longitude");
            propertyNames.put(KEY_ZONE, "Zone");
            propertyNames.put(KEY_DTS_MAXIMUM_DISTANCE, "DTS limit distance");
            propertyNames.put(KEY_HEIGHT_AMSL, "Height AMSL");
            propertyNames.put(KEY_OVERALL_HAAT, "HAAT");
            propertyNames.put(KEY_PEAK_ERP, "Peak ERP");
            propertyNames.put(KEY_FREQUENCY_OFFSET, "Frequency offset");
            propertyNames.put(KEY_EMISSION_MASK, "Emission mask");
            propertyNames.put(KEY_DTS_TIME_DELAY, "DTS time delay");
            propertyNames.put(KEY_HORIZONTAL_PATTERN_NAME, "Horizontal pattern");
            propertyNames.put(KEY_HORIZONTAL_PATTERN_ORIENTATION, "Pattern orientation");
            propertyNames.put(KEY_VERTICAL_PATTERN_NAME, "Vertical pattern");
            propertyNames.put(KEY_VERTICAL_PATTERN_ELECTRICAL_TILT, "Electrical tilt");
            propertyNames.put(KEY_VERTICAL_PATTERN_MECHANICAL_TILT, "Mechanical tilt");
            propertyNames.put(KEY_VERTICAL_PATTERN_MECHANICAL_TILT_ORIENTATION, "Mechanical tilt orientation");
        }
    }
}

