/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.IxRule;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.core.editdata.ListDataChange;
import java.util.ArrayList;
import java.util.HashSet;

public class IxRuleListData
implements ListDataChange {
    private final boolean isLocked;
    private ArrayList<IxRuleEditData> modelRows;
    private HashSet<Integer> addedKeys;
    private HashSet<Integer> deletedKeys;
    private ArrayList<IxRuleEditData> changedRows;
    private int lastChange;
    private int lastRow;

    public IxRuleListData(ArrayList<IxRule> arrayList, boolean bl) {
        this.isLocked = bl;
        this.modelRows = new ArrayList();
        for (IxRule ixRule : arrayList) {
            if (null == ixRule) continue;
            this.modelRows.add(new IxRuleEditData(ixRule, this.isLocked));
        }
        this.addedKeys = new HashSet();
        this.deletedKeys = new HashSet();
        this.changedRows = new ArrayList();
        this.lastChange = 1;
        this.lastRow = 0;
    }

    public boolean isIxRuleUnique(IxRuleEditData ixRuleEditData) {
        return this.isIxRuleUnique(ixRuleEditData, null);
    }

    public boolean isIxRuleUnique(IxRuleEditData ixRuleEditData, ErrorLogger errorLogger) {
        for (IxRuleEditData ixRuleEditData2 : this.modelRows) {
            if (ixRuleEditData.key.equals(ixRuleEditData2.key) || ixRuleEditData.country.key != ixRuleEditData2.country.key || ixRuleEditData.serviceType.key != ixRuleEditData2.serviceType.key || ixRuleEditData.undesiredServiceType.key != ixRuleEditData2.undesiredServiceType.key || ixRuleEditData.channelDelta.key != ixRuleEditData2.channelDelta.key || 0 != ixRuleEditData.channelBand.key && 0 != ixRuleEditData2.channelBand.key && ixRuleEditData.channelBand.key != ixRuleEditData2.channelBand.key || 0 != ixRuleEditData.frequencyOffset && 0 != ixRuleEditData2.frequencyOffset && ixRuleEditData.frequencyOffset != ixRuleEditData2.frequencyOffset || ixRuleEditData.emissionMask.key != ixRuleEditData2.emissionMask.key) continue;
            if (null != errorLogger) {
                errorLogger.reportValidationError("Duplicate interference rule");
            }
            return false;
        }
        return true;
    }

    public boolean addOrReplace(IxRuleEditData ixRuleEditData) {
        this.lastChange = 0;
        this.lastRow = -1;
        if (this.isLocked) {
            return false;
        }
        this.lastRow = this.modelRows.indexOf(ixRuleEditData);
        if (this.lastRow >= 0) {
            this.modelRows.set(this.lastRow, ixRuleEditData);
            this.lastChange = 3;
        } else {
            this.lastRow = this.modelRows.size();
            this.modelRows.add(ixRuleEditData);
            if (!this.deletedKeys.remove(ixRuleEditData.key)) {
                this.addedKeys.add(ixRuleEditData.key);
            }
            this.lastChange = 2;
        }
        return true;
    }

    public boolean remove(int n) {
        this.lastChange = 0;
        this.lastRow = -1;
        if (this.isLocked) {
            return false;
        }
        IxRuleEditData ixRuleEditData = this.modelRows.remove(n);
        if (!this.addedKeys.remove(ixRuleEditData.key)) {
            this.deletedKeys.add(ixRuleEditData.key);
        }
        this.lastChange = 4;
        this.lastRow = n;
        return true;
    }

    public boolean remove(int[] nArray) {
        int n;
        this.lastChange = 0;
        this.lastRow = -1;
        if (this.isLocked) {
            return false;
        }
        if (0 == nArray.length) {
            return false;
        }
        if (1 == nArray.length) {
            this.remove(nArray[0]);
            this.lastChange = 4;
            this.lastRow = nArray[0];
            return true;
        }
        for (n = 0; n < nArray.length - 1; ++n) {
            int n2 = n;
            for (int i = n + 1; i < nArray.length; ++i) {
                if (nArray[i] <= nArray[n2]) continue;
                n2 = i;
            }
            if (n2 == n) continue;
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
        }
        for (n = 0; n < nArray.length; ++n) {
            IxRuleEditData ixRuleEditData = this.modelRows.remove(nArray[n]);
            if (this.addedKeys.remove(ixRuleEditData.key)) continue;
            this.deletedKeys.add(ixRuleEditData.key);
        }
        this.lastChange = 1;
        this.lastRow = 0;
        return true;
    }

    public IxRuleEditData get(int n) {
        return this.modelRows.get(n);
    }

    public ArrayList<IxRuleEditData> getRows() {
        return new ArrayList<IxRuleEditData>(this.modelRows);
    }

    public ArrayList<IxRuleEditData> getActiveRows() {
        ArrayList<IxRuleEditData> arrayList = new ArrayList<IxRuleEditData>();
        for (IxRuleEditData ixRuleEditData : this.modelRows) {
            if (!ixRuleEditData.isActive) continue;
            arrayList.add(ixRuleEditData);
        }
        return arrayList;
    }

    public boolean setActive(int n, boolean bl) {
        IxRuleEditData ixRuleEditData;
        int n2;
        this.lastChange = 0;
        this.lastRow = -1;
        IxRuleEditData ixRuleEditData2 = this.modelRows.get(n);
        if (bl == ixRuleEditData2.isActive) {
            return false;
        }
        ixRuleEditData2.isActive = bl;
        this.lastChange = 3;
        this.lastRow = n;
        int n3 = this.modelRows.size();
        if (ixRuleEditData2.emissionMask.key > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (n2 == n) continue;
                ixRuleEditData = this.modelRows.get(n2);
                if (ixRuleEditData.country.key != ixRuleEditData2.country.key || ixRuleEditData.serviceType.key != ixRuleEditData2.serviceType.key || ixRuleEditData.undesiredServiceType.key != ixRuleEditData2.undesiredServiceType.key || ixRuleEditData.channelDelta.key != ixRuleEditData2.channelDelta.key || ixRuleEditData.channelBand.key != ixRuleEditData2.channelBand.key || 0 != ixRuleEditData.frequencyOffset && 0 != ixRuleEditData2.frequencyOffset && ixRuleEditData.frequencyOffset != ixRuleEditData2.frequencyOffset) continue;
                ixRuleEditData.isActive = bl;
                this.lastChange = 1;
                this.lastRow = 0;
            }
        }
        if (0 != ixRuleEditData2.frequencyOffset) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (n2 == n) continue;
                ixRuleEditData = this.modelRows.get(n2);
                if (ixRuleEditData.country.key != ixRuleEditData2.country.key || ixRuleEditData.serviceType.key != ixRuleEditData2.serviceType.key || ixRuleEditData.undesiredServiceType.key != ixRuleEditData2.undesiredServiceType.key || ixRuleEditData.channelDelta.key != ixRuleEditData2.channelDelta.key || ixRuleEditData.channelBand.key != ixRuleEditData2.channelBand.key || ixRuleEditData.emissionMask.key != ixRuleEditData2.emissionMask.key) continue;
                ixRuleEditData.isActive = bl;
                this.lastChange = 1;
                this.lastRow = 0;
            }
        }
        return true;
    }

    public boolean isDataValid() {
        return this.isDataValid(null);
    }

    public boolean isDataValid(ErrorLogger errorLogger) {
        int n;
        int n2 = this.modelRows.size();
        boolean[] blArray = new boolean[n2];
        boolean[] blArray2 = new boolean[n2];
        ArrayList<KeyedRecord> arrayList = EmissionMask.getEmissionMasks();
        int n3 = arrayList.size();
        int[] nArray = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray[n] = arrayList.get((int)n).key;
        }
        boolean[] blArray3 = new boolean[n3];
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            IxRuleEditData ixRuleEditData;
            int n4;
            IxRuleEditData ixRuleEditData2 = this.modelRows.get(i);
            if (!ixRuleEditData2.isActive) continue;
            if (!blArray[i] && ixRuleEditData2.emissionMask.key > 0) {
                for (n = 0; n < n3; ++n) {
                    blArray3[n] = nArray[n] == ixRuleEditData2.emissionMask.key;
                }
                bl = false;
                for (n4 = i + 1; n4 < n2; ++n4) {
                    ixRuleEditData = this.modelRows.get(n4);
                    if (!ixRuleEditData.isActive || ixRuleEditData.country.key != ixRuleEditData2.country.key || ixRuleEditData.serviceType.key != ixRuleEditData2.serviceType.key || ixRuleEditData.undesiredServiceType.key != ixRuleEditData2.undesiredServiceType.key || ixRuleEditData.channelDelta.key != ixRuleEditData2.channelDelta.key || ixRuleEditData.channelBand.key != ixRuleEditData2.channelBand.key || 0 != ixRuleEditData.frequencyOffset && 0 != ixRuleEditData2.frequencyOffset && ixRuleEditData.frequencyOffset != ixRuleEditData2.frequencyOffset) continue;
                    bl = true;
                    for (n = 0; n < n3; ++n) {
                        if (nArray[n] == ixRuleEditData.emissionMask.key) {
                            blArray3[n] = true;
                            continue;
                        }
                        if (blArray3[n]) continue;
                        bl = false;
                    }
                    blArray[n4] = true;
                    if (bl) break;
                }
                if (!bl) {
                    if (null != errorLogger) {
                        errorLogger.reportValidationError("Incomplete rule set, for rule:\n" + ixRuleEditData2.toString() + "\nMust have matching active rules for all other emission mask types");
                    }
                    return false;
                }
            }
            blArray[i] = true;
            if (!blArray2[i] && 0 != ixRuleEditData2.frequencyOffset) {
                bl = false;
                for (n4 = i + 1; n4 < n2; ++n4) {
                    ixRuleEditData = this.modelRows.get(n4);
                    if (!ixRuleEditData.isActive || ixRuleEditData.country.key != ixRuleEditData2.country.key || ixRuleEditData.serviceType.key != ixRuleEditData2.serviceType.key || ixRuleEditData.undesiredServiceType.key != ixRuleEditData2.undesiredServiceType.key || ixRuleEditData.channelDelta.key != ixRuleEditData2.channelDelta.key || ixRuleEditData.channelBand.key != ixRuleEditData2.channelBand.key || ixRuleEditData.emissionMask.key != ixRuleEditData2.emissionMask.key) continue;
                    bl = true;
                    blArray2[n4] = true;
                    break;
                }
                if (!bl) {
                    String string = null;
                    string = 2 == ixRuleEditData2.frequencyOffset ? "without frequency offset" : "with frequency offset";
                    if (null != errorLogger) {
                        errorLogger.reportValidationError("Incomplete rule set, for rule:\n" + ixRuleEditData2.toString() + "\nMust have matching active rule " + string);
                    }
                    return false;
                }
            }
            blArray2[i] = true;
        }
        return true;
    }

    public boolean isDataChanged() {
        this.changedRows.clear();
        if (this.isLocked) {
            return false;
        }
        boolean bl = false;
        for (IxRuleEditData ixRuleEditData : this.modelRows) {
            if (!ixRuleEditData.isDataChanged() && !this.addedKeys.contains(ixRuleEditData.key)) continue;
            this.changedRows.add(ixRuleEditData);
            bl = true;
        }
        if (bl) {
            return true;
        }
        return !this.deletedKeys.isEmpty();
    }

    public HashSet<Integer> getDeletedKeys() {
        return this.deletedKeys;
    }

    public ArrayList<IxRuleEditData> getChangedRows() {
        return this.changedRows;
    }

    public void didSave() {
        this.addedKeys.clear();
        this.deletedKeys.clear();
        this.changedRows.clear();
    }

    public ArrayList<IxRule> getRules() {
        ArrayList<IxRule> arrayList = new ArrayList<IxRule>();
        for (IxRuleEditData ixRuleEditData : this.modelRows) {
            arrayList.add(ixRuleEditData.ixRule);
        }
        return arrayList;
    }

    public int getRowCount() {
        return this.modelRows.size();
    }

    @Override
    public int getLastChange() {
        return this.lastChange;
    }

    @Override
    public int getLastRowChanged() {
        return this.lastRow;
    }
}

