/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.KeyedRecord;
import java.sql.SQLException;
import java.util.ArrayList;

public class Zone
extends KeyedRecord {
    public final String zoneCode;
    private static Zone nullObject = new Zone(0, "(n/a)", "");
    private static Zone invalidObject = new Zone(-1, "???", "?");
    private static ArrayList<Zone> recordCache = new ArrayList();

    public Zone(int n, String string, String string2) {
        super(n, string);
        this.zoneCode = string2;
    }

    public static Zone getZone(int n) {
        if (0 == n) {
            return nullObject;
        }
        for (Zone zone : recordCache) {
            if (n != zone.key) continue;
            return zone;
        }
        return nullObject;
    }

    public static Zone getZone(String string) {
        for (Zone zone : recordCache) {
            if (!zone.zoneCode.equalsIgnoreCase(string)) continue;
            return zone;
        }
        return nullObject;
    }

    public static Zone getNullObject() {
        return nullObject;
    }

    public static Zone getInvalidObject() {
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getZones() {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        for (Zone zone : recordCache) {
            arrayList.add(zone);
        }
        return arrayList;
    }

    public static ArrayList<KeyedRecord> getZonesWithNull() {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(nullObject);
        for (Zone zone : recordCache) {
            arrayList.add(zone);
        }
        return arrayList;
    }

    public static ArrayList<Zone> getAllZones() {
        return new ArrayList<Zone>(recordCache);
    }

    public static void loadCache(DbConnection dbConnection) throws SQLException {
        recordCache.clear();
        dbConnection.query("SELECT zone_key, name, zone_code FROM zone ORDER BY 1");
        while (dbConnection.next()) {
            recordCache.add(new Zone(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3)));
        }
    }
}

