/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.FrequencyOffset;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.SignalType;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.core.data.Zone;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SourceTV
extends Source {
    public static final int CHANNEL_MIN = 2;
    public static final int CHANNEL_MAX = 69;
    public static final double FREQUENCY_MIN = 40.0;
    public static final double FREQUENCY_MAX = 10000.0;
    public final int facilityID;
    public final boolean isDRT;
    public final int channel;
    public final Zone zone;
    public final String status;
    public final SignalType signalType;
    public final FrequencyOffset frequencyOffset;
    public final EmissionMask emissionMask;
    public final double dtsMaximumDistance;
    public final String dtsSectors;
    public final int siteNumber;
    public final Integer originalSourceKey;
    public final Integer parentSourceKey;
    public final ArrayList<SourceTV> dtsSources;
    public final int serviceAreaMode;
    public final double serviceAreaArg;
    public final double serviceAreaCL;
    public final int serviceAreaKey;
    public final double dtsTimeDelay;
    public final boolean isParent;

    public SourceTV(String string, String string2, int n, int n2, Service service, boolean bl, String string3, int n3, String string4, String string5, Country country, Zone zone, String string6, String string7, SignalType signalType, FrequencyOffset frequencyOffset, EmissionMask emissionMask, double d, double d2, double d3, String string8, double d4, double d5, double d6, double d7, double d8, String string9, boolean bl2, String string10, double d9, boolean bl3, String string11, double d10, double d11, double d12, boolean bl4, String string12, boolean bl5, int n4, boolean bl6, Integer n5, Integer n6, String string13, Integer n7, Integer n8, ArrayList<SourceTV> arrayList, int n9, int n10, double d13, double d14, int n11, double d15, String string14) {
        super(string, string2, 1, n, string3 + " " + n3 + " " + string6, service, string3, string4, string5, country, string7, d, d2, d4, d5, d6, d7, d8, string9, bl2, string10, d9, bl3, string11, d10, d11, d12, bl4, string12, bl5, bl6, n5, n6, string13, n9, string14);
        this.facilityID = n2;
        this.isDRT = bl;
        this.channel = n3;
        this.zone = zone;
        this.status = string6;
        this.signalType = signalType;
        this.frequencyOffset = frequencyOffset;
        this.emissionMask = emissionMask;
        this.dtsMaximumDistance = d3;
        this.dtsSectors = string8;
        this.siteNumber = n4;
        this.originalSourceKey = n7;
        this.parentSourceKey = n8;
        this.dtsSources = arrayList;
        this.isParent = null != this.dtsSources;
        this.serviceAreaMode = n10;
        this.serviceAreaArg = d13;
        this.serviceAreaCL = d14;
        this.serviceAreaKey = n11;
        this.dtsTimeDelay = d15;
    }

    public static void getSources(DbConnection dbConnection, String string, String string2, List<Source> list) throws SQLException {
        SourceTV.getSources(dbConnection, string, string2, null, list);
    }

    public static void getSources(DbConnection dbConnection, String string, String string2, String string3, List<Source> list) throws SQLException {
        Integer n;
        Integer n2;
        Integer n3;
        int n4;
        Country country;
        Service service;
        int n5 = 0;
        ArrayList<SourceTV> arrayList = null;
        HashMap<Integer, ArrayList<SourceTV>> hashMap = new HashMap<Integer, ArrayList<SourceTV>>();
        dbConnection.setDatabase(string2);
        dbConnection.query("SELECT source_key, facility_id, service_key, call_sign, channel, city, state, country_key, zone_key, status, file_number, frequency_offset_key, emission_mask_key, latitude, longitude, height_amsl, actual_height_amsl, overall_haat, actual_overall_haat, peak_erp, antenna_id, has_horizontal_pattern, horizontal_pattern_name, horizontal_pattern_orientation, has_vertical_pattern, vertical_pattern_name, vertical_pattern_electrical_tilt, vertical_pattern_mechanical_tilt, vertical_pattern_mechanical_tilt_orientation, has_matrix_pattern, matrix_pattern_name, use_generic_vertical_pattern, site_number, locked, user_record_id, ext_db_key, ext_record_id, original_source_key, parent_source_key, service_area_mode, service_area_arg, service_area_cl, service_area_key, dts_time_delay, signal_type_key, attributes FROM source WHERE record_type = 1 AND (parent_source_key > 0) ORDER BY parent_source_key, site_number, source_key");
        while (dbConnection.next()) {
            service = Service.getService(dbConnection.getInt(3));
            if (null == service || service.serviceType.recordType != 1 || null == (country = Country.getCountry(dbConnection.getInt(8)))) continue;
            n4 = dbConnection.getInt(35);
            n3 = 0 == n4 ? null : Integer.valueOf(n4);
            n4 = dbConnection.getInt(36);
            n2 = 0 == n4 ? null : Integer.valueOf(n4);
            n4 = dbConnection.getInt(38);
            n = 0 == n4 ? null : Integer.valueOf(n4);
            n4 = dbConnection.getInt(39);
            Integer n6 = n4;
            if (n4 != n5) {
                arrayList = new ArrayList<SourceTV>();
                hashMap.put(n6, arrayList);
                n5 = n4;
            }
            arrayList.add(new SourceTV(string, string2, dbConnection.getInt(1), dbConnection.getInt(2), service, false, dbConnection.getString(4), dbConnection.getInt(5), dbConnection.getString(6), dbConnection.getString(7), country, Zone.getZone(dbConnection.getInt(9)), dbConnection.getString(10), dbConnection.getString(11), SignalType.getSignalType(dbConnection.getInt(45)), FrequencyOffset.getFrequencyOffset(dbConnection.getInt(12)), EmissionMask.getEmissionMask(dbConnection.getInt(13)), dbConnection.getDouble(14), dbConnection.getDouble(15), 0.0, "", dbConnection.getDouble(16), dbConnection.getDouble(17), dbConnection.getDouble(18), dbConnection.getDouble(19), dbConnection.getDouble(20), dbConnection.getString(21), dbConnection.getBoolean(22), dbConnection.getString(23), dbConnection.getDouble(24), dbConnection.getBoolean(25), dbConnection.getString(26), dbConnection.getDouble(27), dbConnection.getDouble(28), dbConnection.getDouble(29), dbConnection.getBoolean(30), dbConnection.getString(31), dbConnection.getBoolean(32), dbConnection.getInt(33), dbConnection.getBoolean(34), n3, n2, dbConnection.getString(37), n, n6, null, 0, dbConnection.getInt(40), dbConnection.getDouble(41), dbConnection.getDouble(42), dbConnection.getInt(43), dbConnection.getDouble(44), dbConnection.getString(46)));
        }
        String string4 = "";
        if (null != string3 && string3.length() > 0) {
            string4 = "AND (" + string3 + ") ";
        }
        dbConnection.query("SELECT source_key, facility_id, service_key, call_sign, channel, city, state, country_key, zone_key, status, file_number, frequency_offset_key, emission_mask_key, latitude, longitude, dts_maximum_distance, height_amsl, actual_height_amsl, overall_haat, actual_overall_haat, peak_erp, antenna_id, has_horizontal_pattern, horizontal_pattern_name, horizontal_pattern_orientation, has_vertical_pattern, vertical_pattern_name, vertical_pattern_electrical_tilt, vertical_pattern_mechanical_tilt, vertical_pattern_mechanical_tilt_orientation, has_matrix_pattern, matrix_pattern_name, use_generic_vertical_pattern, site_number, locked, user_record_id, ext_db_key, ext_record_id, original_source_key, mod_count, is_drt, service_area_mode, service_area_arg, service_area_cl, service_area_key, signal_type_key, dts_sectors, attributes FROM source WHERE record_type = 1 AND (parent_source_key = 0) " + string4 + "ORDER BY source_key");
        while (dbConnection.next()) {
            int n7 = dbConnection.getInt(1);
            service = Service.getService(dbConnection.getInt(3));
            if (null == service || service.serviceType.recordType != 1 || null == (country = Country.getCountry(dbConnection.getInt(8)))) continue;
            if (service.isDTS) {
                arrayList = (ArrayList<SourceTV>)hashMap.remove(n7);
                if (null == arrayList) {
                    continue;
                }
            } else {
                arrayList = null;
            }
            n3 = 0 == (n4 = dbConnection.getInt(36)) ? null : Integer.valueOf(n4);
            n4 = dbConnection.getInt(37);
            n2 = 0 == n4 ? null : Integer.valueOf(n4);
            n4 = dbConnection.getInt(39);
            n = 0 == n4 ? null : Integer.valueOf(n4);
            list.add(new SourceTV(string, string2, n7, dbConnection.getInt(2), service, dbConnection.getBoolean(41), dbConnection.getString(4), dbConnection.getInt(5), dbConnection.getString(6), dbConnection.getString(7), country, Zone.getZone(dbConnection.getInt(9)), dbConnection.getString(10), dbConnection.getString(11), SignalType.getSignalType(dbConnection.getInt(46)), FrequencyOffset.getFrequencyOffset(dbConnection.getInt(12)), EmissionMask.getEmissionMask(dbConnection.getInt(13)), dbConnection.getDouble(14), dbConnection.getDouble(15), dbConnection.getDouble(16), dbConnection.getString(47), dbConnection.getDouble(17), dbConnection.getDouble(18), dbConnection.getDouble(19), dbConnection.getDouble(20), dbConnection.getDouble(21), dbConnection.getString(22), dbConnection.getBoolean(23), dbConnection.getString(24), dbConnection.getDouble(25), dbConnection.getBoolean(26), dbConnection.getString(27), dbConnection.getDouble(28), dbConnection.getDouble(29), dbConnection.getDouble(30), dbConnection.getBoolean(31), dbConnection.getString(32), dbConnection.getBoolean(33), dbConnection.getInt(34), dbConnection.getBoolean(35), n3, n2, dbConnection.getString(38), n, null, arrayList, dbConnection.getInt(40), dbConnection.getInt(42), dbConnection.getDouble(43), dbConnection.getDouble(44), dbConnection.getInt(45), 0.0, dbConnection.getString(48)));
        }
    }
}

