/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.ServiceType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class Service
extends KeyedRecord {
    public static final String DT_CODE = "DT";
    public static final String DC_CODE = "DC";
    public static final String LD_CODE = "LD";
    public static final String DX_CODE = "DX";
    public static final String TV_CODE = "TV";
    public static final String CA_CODE = "CA";
    public static final String TX_CODE = "TX";
    public static final String TS_CODE = "TS";
    public static final String WL_CODE = "WL";
    public static final String FM_CODE = "FM";
    public static final String FL_CODE = "FL";
    public static final String FS_CODE = "FS";
    public final String serviceCode;
    public final ServiceType serviceType;
    public final boolean isDTS;
    public final boolean isOperating;
    public final int preferenceRank;
    public final Service digitalService;
    private static Service invalidObject = new Service(-1, "???", "??", ServiceType.getInvalidObject(), false, false, 0, null);
    private static ArrayList<Service> serviceCache = new ArrayList();
    private static HashMap<Integer, Service> serviceKeyCache = new HashMap();
    private static HashMap<String, Service> serviceCodeCache = new HashMap();

    public Service(int n, String string, String string2, ServiceType serviceType, boolean bl, boolean bl2, int n2, Service service) {
        super(n, string);
        this.serviceCode = string2;
        this.serviceType = serviceType;
        this.isDTS = bl;
        this.isOperating = bl2;
        this.preferenceRank = n2;
        this.digitalService = service;
    }

    public boolean isDigital() {
        return this.serviceType.digital;
    }

    public boolean isTV() {
        return 1 == this.serviceType.key || 2 == this.serviceType.key || 3 == this.serviceType.key || 4 == this.serviceType.key || 5 == this.serviceType.key || 6 == this.serviceType.key;
    }

    public boolean isFullService() {
        return 1 == this.serviceType.key || 2 == this.serviceType.key;
    }

    public boolean isClassA() {
        return 3 == this.serviceType.key || 4 == this.serviceType.key;
    }

    public boolean isLPTV() {
        return 5 == this.serviceType.key || 6 == this.serviceType.key;
    }

    public boolean isWL() {
        return 11 == this.serviceType.key;
    }

    public boolean isFM() {
        return 21 == this.serviceType.key || 22 == this.serviceType.key || 23 == this.serviceType.key;
    }

    public static Service getService(int n) {
        return serviceKeyCache.get(n);
    }

    public static Service getService(String string) {
        return serviceCodeCache.get(string);
    }

    public static Service getInvalidObject() {
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getServices() {
        return Service.getServices(0);
    }

    public static ArrayList<KeyedRecord> getServices(int n) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        for (Service service : serviceCache) {
            if (0 != n && service.serviceType.recordType != n) continue;
            arrayList.add(service);
        }
        return arrayList;
    }

    public static ArrayList<Service> getAllServices() {
        return new ArrayList<Service>(serviceCache);
    }

    public static void loadCache(DbConnection dbConnection) throws SQLException {
        ServiceType.loadCache(dbConnection);
        serviceCache.clear();
        serviceKeyCache.clear();
        serviceCodeCache.clear();
        dbConnection.query("SELECT service.service_key, service.name, service.service_code, service.service_type_key, service.is_dts, service.is_operating, service.preference_rank, service.digital_service_key FROM service JOIN service_type USING (service_type_key) ORDER BY service.display_order");
        while (dbConnection.next()) {
            Service service = new Service(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3), ServiceType.getServiceType(dbConnection.getInt(4)), dbConnection.getBoolean(5), dbConnection.getBoolean(6), dbConnection.getInt(7), serviceKeyCache.get(dbConnection.getInt(8)));
            serviceCache.add(service);
            serviceKeyCache.put(service.key, service);
            serviceCodeCache.put(service.serviceCode, service);
        }
    }
}

