/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.ChannelBand;
import gov.fcc.tvstudy.core.data.ChannelDelta;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.ServiceType;
import gov.fcc.tvstudy.core.data.SignalType;
import gov.fcc.tvstudy.core.data.Source;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

public class IxRule
extends KeyedRecord {
    public static final int FREQUENCY_OFFSET_WITHOUT = 1;
    public static final int FREQUENCY_OFFSET_WITH = 2;
    public static final double DISTANCE_MIN = 1.0;
    public static final double DISTANCE_MAX = 500.0;
    public static final double DU_MIN = -60.0;
    public static final double DU_MAX = 60.0;
    public static final double PERCENT_TIME_MIN = 0.01;
    public static final double PERCENT_TIME_MAX = 99.99;
    public final Country country;
    public final ServiceType serviceType;
    public final SignalType signalType;
    public final ServiceType undesiredServiceType;
    public final SignalType undesiredSignalType;
    public final ChannelDelta channelDelta;
    public final ChannelBand channelBand;
    public final int frequencyOffset;
    public final EmissionMask emissionMask;
    public final double distance;
    public final double requiredDU;
    public final double undesiredTime;
    public final boolean isActive;

    public IxRule(int n, Country country, ServiceType serviceType, SignalType signalType, ServiceType serviceType2, SignalType signalType2, ChannelDelta channelDelta, ChannelBand channelBand, int n2, EmissionMask emissionMask, double d, double d2, double d3, boolean bl) {
        super(n, country.name + " " + serviceType.name + " from " + serviceType2.name + " " + channelDelta.name);
        this.country = country;
        this.serviceType = serviceType;
        this.signalType = signalType;
        this.undesiredServiceType = serviceType2;
        this.undesiredSignalType = signalType2;
        this.channelDelta = channelDelta;
        this.channelBand = channelBand;
        this.frequencyOffset = n2;
        this.emissionMask = emissionMask;
        this.distance = d;
        this.requiredDU = d2;
        this.undesiredTime = d3;
        this.isActive = bl;
    }

    public static ArrayList<IxRule> getIxRules(DbConnection dbConnection, String string, String string2, int n, int n2) throws SQLException {
        KeyedRecord keyedRecord;
        Object object;
        Object object2;
        ArrayList<IxRule> arrayList = new ArrayList<IxRule>();
        StringBuilder stringBuilder = new StringBuilder("(");
        if (0 == n2 || null != string) {
            object2 = "";
            object = Source.getRecordTypes(n2).iterator();
            while (object.hasNext()) {
                keyedRecord = object.next();
                stringBuilder.append((String)object2);
                stringBuilder.append(String.valueOf(keyedRecord.key));
                object2 = ",";
            }
        } else {
            stringBuilder.append(String.valueOf(n2));
        }
        stringBuilder.append(")");
        if (null != string) {
            dbConnection.setDatabase(string);
            dbConnection.query("SELECT ix_rule.ix_rule_key, ix_rule.country_key, ix_rule.service_type_key, ix_rule.signal_type_key, ix_rule.undesired_service_type_key, ix_rule.undesired_signal_type_key, ix_rule.channel_delta_key, ix_rule.channel_band_key, ix_rule.frequency_offset, ix_rule.emission_mask_key, ix_rule.distance, ix_rule.required_du, ix_rule.undesired_time, ix_rule.is_active FROM ix_rule JOIN " + string2 + ".service_type USING (service_type_key) WHERE service_type.record_type IN " + stringBuilder + " ORDER BY 2, 3, 4, 5, 6, 7, 10");
        } else {
            dbConnection.setDatabase(string2);
            dbConnection.query("SELECT ix_rule_key, country_key, service_type_key, signal_type_key, undesired_service_type_key, undesired_signal_type_key, channel_delta_key, channel_band_key, frequency_offset, emission_mask_key, distance, required_du, undesired_time, true AS is_active FROM template_ix_rule JOIN service_type USING (service_type_key) WHERE template_key = " + n + " AND service_type.record_type IN " + stringBuilder + " ORDER BY 2, 3, 4, 5, 6, 7, 10");
        }
        while (dbConnection.next()) {
            ChannelDelta channelDelta;
            object2 = Country.getCountry(dbConnection.getInt(2));
            if (null == object2 || null == (object = ServiceType.getServiceType(dbConnection.getInt(3))) || null == (keyedRecord = ServiceType.getServiceType(dbConnection.getInt(5))) || null == (channelDelta = ChannelDelta.getChannelDelta(dbConnection.getInt(7)))) continue;
            arrayList.add(new IxRule(dbConnection.getInt(1), (Country)object2, (ServiceType)object, SignalType.getSignalType(dbConnection.getInt(4)), (ServiceType)keyedRecord, SignalType.getSignalType(dbConnection.getInt(6)), channelDelta, ChannelBand.getChannelBand(dbConnection.getInt(8)), dbConnection.getInt(9), EmissionMask.getEmissionMask(dbConnection.getInt(10)), dbConnection.getDouble(11), dbConnection.getDouble(12), dbConnection.getDouble(13), dbConnection.getBoolean(14)));
        }
        return arrayList;
    }

    public static String makeIxRuleSummary(ArrayList<IxRule> arrayList) {
        boolean bl = false;
        for (IxRule object2 : arrayList) {
            if (1 != object2.serviceType.recordType) continue;
            bl = true;
            break;
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = SignalType.hasMultipleOptions();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            if (bl2) {
                stringBuilder.append("Ctry D  Service D                Mod D   Bnd D  Service U                Mod U   Channel U   Mask U        Offset  Dist km   D/U dB     % U\n\n");
            } else {
                stringBuilder.append("Ctry D  Service D                Bnd D  Service U                Channel U   Mask U        Offset  Dist km   D/U dB     % U\n\n");
            }
        } else {
            stringBuilder.append("Ctry D  Service D                Service U                Channel U  Dist km   D/U dB     % U\n\n");
        }
        for (IxRule ixRule : arrayList) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            if (!ixRule.isActive) continue;
            if (1 == ixRule.serviceType.recordType) {
                string5 = ixRule.signalType.name;
                string4 = ixRule.channelBand.name;
                string3 = ixRule.undesiredSignalType.name;
                string2 = ixRule.undesiredSignalType.name;
                switch (ixRule.frequencyOffset) {
                    case 2: {
                        string = "With";
                        break;
                    }
                    case 1: {
                        string = "Without";
                        break;
                    }
                    default: {
                        string = "(any)";
                        break;
                    }
                }
            } else {
                string5 = "";
                string4 = "";
                string3 = "";
                string2 = "";
                string = "";
            }
            if (bl) {
                if (bl2) {
                    stringBuilder.append(String.format(Locale.US, "%-6s  %-23s  %-6s  %-5s  %-23s  %-6s  %-10s  %-12s  %-7s  %6.1f  %7.2f  %6.2f\n", ixRule.country.name, ixRule.serviceType.name, string5, string4, ixRule.undesiredServiceType.name, string3, ixRule.channelDelta.name, string2, string, ixRule.distance, ixRule.requiredDU, ixRule.undesiredTime));
                    continue;
                }
                stringBuilder.append(String.format(Locale.US, "%-6s  %-23s  %-5s  %-23s  %-10s  %-12s  %-7s  %6.1f  %7.2f  %6.2f\n", ixRule.country.name, ixRule.serviceType.name, string4, ixRule.undesiredServiceType.name, ixRule.channelDelta.name, string2, string, ixRule.distance, ixRule.requiredDU, ixRule.undesiredTime));
                continue;
            }
            stringBuilder.append(String.format(Locale.US, "%-6s  %-23s  %-23s  %-10s  %6.1f  %7.2f  %6.2f\n", ixRule.country.name, ixRule.serviceType.name, ixRule.undesiredServiceType.name, ixRule.channelDelta.name, ixRule.distance, ixRule.requiredDU, ixRule.undesiredTime));
        }
        return stringBuilder.toString();
    }

    public static void createTables(DbConnection dbConnection, String string, String string2, int n, int n2) throws SQLException {
        dbConnection.setDatabase(string);
        dbConnection.update("CREATE TABLE ix_rule (ix_rule_key INT NOT NULL PRIMARY KEY,country_key INT NOT NULL,service_type_key INT NOT NULL,signal_type_key INT NOT NULL,undesired_service_type_key INT NOT NULL,undesired_signal_type_key INT NOT NULL,channel_delta_key INT NOT NULL,channel_band_key INT NOT NULL,frequency_offset INT NOT NULL,emission_mask_key INT NOT NULL,distance FLOAT NOT NULL,required_du FLOAT NOT NULL,undesired_time FLOAT NOT NULL,is_active BOOLEAN NOT NULL)");
        if (null != string2 && n > 0) {
            for (KeyedRecord keyedRecord : Source.getRecordTypes(n2)) {
                int n3;
                int n4 = n;
                while ((n3 = dbConnection.update("INSERT INTO ix_rule (ix_rule_key,country_key,service_type_key,signal_type_key,undesired_service_type_key,undesired_signal_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time,is_active) SELECT ix_rule_key,country_key,service_type_key,signal_type_key,undesired_service_type_key,undesired_signal_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time,true AS is_active FROM " + string2 + ".template_ix_rule JOIN " + string2 + ".service_type USING (service_type_key) WHERE template_key = " + n4 + " AND service_type.record_type = " + keyedRecord.key)) <= 0 && 1 != n4) {
                    n4 = 1;
                }
            }
        }
    }

    public static void copyTables(DbConnection dbConnection, String string, String string2) throws SQLException {
        IxRule.createTables(dbConnection, string, null, 0, 0);
        dbConnection.update("INSERT INTO ix_rule (ix_rule_key,country_key,service_type_key,signal_type_key,undesired_service_type_key,undesired_signal_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time,is_active) SELECT ix_rule_key,country_key,service_type_key,signal_type_key,undesired_service_type_key,undesired_signal_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time,is_active FROM " + string2 + ".ix_rule");
    }
}

