/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.KeyedRecord;
import java.sql.SQLException;
import java.util.ArrayList;

public class FrequencyOffset
extends KeyedRecord {
    public final String frequencyOffsetCode;
    private static FrequencyOffset nullObject = new FrequencyOffset(0, "(none)", "");
    private static FrequencyOffset invalidObject = new FrequencyOffset(-1, "???", "?");
    private static ArrayList<FrequencyOffset> recordCache = new ArrayList();

    public FrequencyOffset(int n, String string, String string2) {
        super(n, string);
        this.frequencyOffsetCode = string2;
    }

    public static FrequencyOffset getFrequencyOffset(int n) {
        if (0 == n) {
            return nullObject;
        }
        for (FrequencyOffset frequencyOffset : recordCache) {
            if (n != frequencyOffset.key) continue;
            return frequencyOffset;
        }
        return nullObject;
    }

    public static FrequencyOffset getFrequencyOffset(String string) {
        for (FrequencyOffset frequencyOffset : recordCache) {
            if (!frequencyOffset.frequencyOffsetCode.equalsIgnoreCase(string)) continue;
            return frequencyOffset;
        }
        return nullObject;
    }

    public static FrequencyOffset getNullObject() {
        return nullObject;
    }

    public static FrequencyOffset getInvalidObject() {
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getFrequencyOffsets() {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        for (FrequencyOffset frequencyOffset : recordCache) {
            arrayList.add(frequencyOffset);
        }
        return arrayList;
    }

    public static ArrayList<KeyedRecord> getFrequencyOffsetsWithNull() {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(nullObject);
        for (FrequencyOffset frequencyOffset : recordCache) {
            arrayList.add(frequencyOffset);
        }
        return arrayList;
    }

    public static ArrayList<FrequencyOffset> getAllFrequencyOffsets() {
        return new ArrayList<FrequencyOffset>(recordCache);
    }

    public static void loadCache(DbConnection dbConnection) throws SQLException {
        recordCache.clear();
        dbConnection.query("SELECT frequency_offset_key, name, offset_code FROM frequency_offset ORDER BY 1");
        while (dbConnection.next()) {
            recordCache.add(new FrequencyOffset(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3)));
        }
    }
}

