/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.KeyedRecord;
import java.sql.SQLException;
import java.util.ArrayList;

public class ChannelBand
extends KeyedRecord {
    public final int firstChannel;
    public final int lastChannel;
    private static ChannelBand nullObject = new ChannelBand(0, "(any)", 0, 9999);
    private static ChannelBand invalidObject = new ChannelBand(-1, "???", 0, 0);
    private static ArrayList<ChannelBand> recordCache = new ArrayList();

    public ChannelBand(int n, String string, int n2, int n3) {
        super(n, string);
        this.firstChannel = n2;
        this.lastChannel = n3;
    }

    public static ChannelBand getChannelBand(int n) {
        if (0 == n) {
            return nullObject;
        }
        for (ChannelBand channelBand : recordCache) {
            if (n != channelBand.key) continue;
            return channelBand;
        }
        return nullObject;
    }

    public static ChannelBand getNullObject() {
        return nullObject;
    }

    public static ChannelBand getInvalidObject() {
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getChannelBands() {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        for (ChannelBand channelBand : recordCache) {
            arrayList.add(channelBand);
        }
        return arrayList;
    }

    public static ArrayList<KeyedRecord> getChannelBandsWithNull() {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(nullObject);
        for (ChannelBand channelBand : recordCache) {
            arrayList.add(channelBand);
        }
        return arrayList;
    }

    public static ArrayList<ChannelBand> getAllChannelBands() {
        return new ArrayList<ChannelBand>(recordCache);
    }

    public static void loadCache(DbConnection dbConnection) throws SQLException {
        recordCache.clear();
        dbConnection.query("SELECT channel_band_key, name, first_channel, last_channel FROM channel_band ORDER BY 1");
        while (dbConnection.next()) {
            recordCache.add(new ChannelBand(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getInt(3), dbConnection.getInt(4)));
        }
    }
}

