/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.core.StudyBuild;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.Scenario;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class StudyBuildPair
extends StudyBuild {
    public Study baseStudy;
    public Country studyCountry;
    public int[] studyChannels;
    public int runCount;
    public int baselineScenarioKey;
    public int baselineSourceCount;
    public int scenarioCount;
    public int scenarioSourceCount;
    private TreeSet<ScenarioSortItem> sortedScenarios;
    private static final int MIN_SCENARIOS_PER_RUN = 5;
    private StudyEditData study;
    private ScenarioEditData baselineScenario;

    public StudyBuildPair(String string) {
        super(string);
    }

    @Override
    public boolean initialize(ErrorLogger errorLogger) {
        int n;
        if (this.initialized) {
            return true;
        }
        if (null == this.baseStudy || 1 != this.baseStudy.studyLock) {
            if (null != errorLogger) {
                errorLogger.reportError("Invalid settings");
            }
            return false;
        }
        if (null == this.studyChannels || 0 == this.studyChannels.length) {
            if (null != errorLogger) {
                errorLogger.reportError("No channels selected");
            }
            return false;
        }
        for (n = 0; n < this.studyChannels.length - 1; ++n) {
            for (int i = n + 1; i < this.studyChannels.length; ++i) {
                if (this.studyChannels[n] != this.studyChannels[i]) continue;
                if (null != errorLogger) {
                    errorLogger.reportError("Duplicate channels selected");
                }
                return false;
            }
        }
        if (this.runCount > AppCore.maxEngineProcessCount) {
            this.runCount = AppCore.maxEngineProcessCount;
        }
        if (this.runCount < 1) {
            this.runCount = 1;
        }
        if (1 != this.baseStudy.studyType) {
            if (null != errorLogger) {
                errorLogger.reportError("A general-purpose TV study must be selected");
            }
            return false;
        }
        try {
            this.study = new StudyEditData(this.baseStudy);
        }
        catch (Throwable throwable) {
            AppCore.log(3, "Unexpected error", throwable);
            if (null != errorLogger) {
                errorLogger.reportError("Unexpected error:\n" + throwable);
            }
            return false;
        }
        if (1 != this.study.studyMode || 2 != this.study.getGridType()) {
            if (null != errorLogger) {
                errorLogger.reportError("The study must use global grid mode");
            }
            this.study.invalidate();
            return false;
        }
        if (this.study.getCellSize() < 0.5) {
            if (null != errorLogger) {
                errorLogger.reportError("The study grid cell size must be 0.5 km or larger");
            }
            this.study.invalidate();
            return false;
        }
        if (1 != this.baseStudy.scenarios.size()) {
            if (null != errorLogger) {
                errorLogger.reportError("There must be exactly one scenario in the study");
            }
            this.study.invalidate();
            return false;
        }
        this.baselineScenario = this.study.scenarioData.get(0);
        this.baselineScenarioKey = this.baselineScenario.key;
        this.baselineSourceCount = this.baselineScenario.sourceData.getDesiredSourceCount();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = 0;
        double d = this.study.getKilometersPerDegree();
        for (SourceEditData sourceEditData : this.baselineScenario.sourceData.getDesiredSources()) {
            if (1 != sourceEditData.recordType) {
                if (null != errorLogger) {
                    errorLogger.reportError("The baseline scenario must contain only TV stations");
                }
                this.study.invalidate();
                return false;
            }
            SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
            if (sourceEditDataTV.facilityID <= 0) {
                if (null != errorLogger) {
                    errorLogger.reportError("All records in the baseline scenario must have valid facility IDs");
                }
                this.study.invalidate();
                return false;
            }
            if (!hashSet.add(sourceEditDataTV.facilityID)) {
                if (null != errorLogger) {
                    errorLogger.reportError("Records in the baseline scenario must not have matching facility IDs");
                }
                this.study.invalidate();
                return false;
            }
            if (sourceEditData.location.latitude < 0.0 || sourceEditData.location.latitude > 75.0 || sourceEditData.location.longitude < 0.0 || sourceEditData.location.longitude > 180.0) {
                if (null != errorLogger) {
                    errorLogger.reportError("Stations must be in 0-75 N. latitude and 0-180 W. longitude");
                }
                this.study.invalidate();
                return false;
            }
            double d2 = 2.0 / Math.cos(sourceEditData.location.latitude * (Math.PI / 180));
            if (sourceEditData.location.latitude < 2.0 || sourceEditData.location.latitude > 73.0 || sourceEditData.location.longitude < d2 || sourceEditData.location.longitude > 180.0 - d2) {
                boolean bl = false;
                double d3 = sourceEditDataTV.getRuleExtraDistance();
                double d4 = sourceEditData.location.distanceTo(0.0, sourceEditData.location.longitude, d);
                if (d4 < d3) {
                    bl = true;
                } else {
                    d4 = sourceEditData.location.distanceTo(75.0, sourceEditData.location.longitude, d);
                    if (d4 < d3) {
                        bl = true;
                    } else {
                        d4 = sourceEditData.location.distanceTo(sourceEditData.location.latitude, 0.0, d);
                        if (d4 < d3) {
                            bl = true;
                        } else {
                            d4 = sourceEditData.location.distanceTo(sourceEditData.location.latitude, 180.0, d);
                            if (d4 < d3) {
                                bl = true;
                            }
                        }
                    }
                }
                if (bl) {
                    if (null != errorLogger) {
                        errorLogger.reportError("Station coverage areas must be entirely in 0-75 N. latitude and 0-180 W. longitude");
                    }
                    this.study.invalidate();
                    return false;
                }
            }
            ++n2;
        }
        if (n2 < 2) {
            if (null != errorLogger) {
                errorLogger.reportError("The baseline scenario must contain at least two records");
            }
            this.study.invalidate();
            return false;
        }
        int n3 = this.study.getMinimumChannel();
        int n4 = this.study.getMaximumChannel();
        for (n = 0; n < this.studyChannels.length; ++n) {
            if (this.studyChannels[n] >= n3 && this.studyChannels[n] <= n4) continue;
            if (null != errorLogger) {
                errorLogger.reportError("Study channels must be in the range " + n3 + " to " + n4);
            }
            this.study.invalidate();
            return false;
        }
        this.sortedScenarios = new TreeSet();
        this.initialized = true;
        return true;
    }

    @Override
    public Study buildStudy(StatusLogger statusLogger, ErrorLogger errorLogger) {
        if (!this.initialized) {
            return null;
        }
        boolean bl = true;
        if (this.createStudyScenarios(errorLogger)) {
            if (0 == this.scenarioCount) {
                if (null != errorLogger) {
                    errorLogger.reportError("No station pairs found");
                }
            } else if (!this.isCanceled()) {
                this.study.isDataChanged();
                if (this.study.save(errorLogger)) {
                    this.baseStudy = this.study.study;
                    bl = false;
                }
            }
        }
        this.study.invalidate();
        if (bl) {
            return null;
        }
        return this.baseStudy;
    }

    public ArrayDeque<ScenarioSortItem> getScenarioRunList() {
        ArrayDeque<ScenarioSortItem> arrayDeque = new ArrayDeque<ScenarioSortItem>();
        Iterator<ScenarioSortItem> iterator = this.sortedScenarios.iterator();
        while (iterator.hasNext()) {
            arrayDeque.add(iterator.next());
        }
        return arrayDeque;
    }

    public boolean restoreStudy(ErrorLogger errorLogger) {
        if (!this.initialized) {
            return false;
        }
        boolean bl = false;
        String string = "";
        String string2 = DbCore.getDbName(this.dbID);
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.update("LOCK TABLES study WRITE");
                dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + this.baseStudy.key);
                if (dbConnection.next()) {
                    if (dbConnection.getInt(1) == this.baseStudy.studyLock && dbConnection.getInt(2) == this.baseStudy.lockCount) {
                        dbConnection.update("UPDATE study SET study_lock = 1, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + this.baseStudy.key);
                        this.baseStudy.studyLock = 1;
                        ++this.baseStudy.lockCount;
                    } else {
                        bl = true;
                        string = "The study lock was modified";
                    }
                } else {
                    bl = true;
                    string = "The study was deleted";
                }
            }
            catch (SQLException sQLException) {
                bl = true;
                string = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            if (!bl) {
                try {
                    dbConnection.setDatabase(string2 + "_" + this.baseStudy.key);
                    dbConnection.update("DELETE FROM scenario_parameter_data WHERE scenario_key <> " + this.baselineScenario.key);
                    dbConnection.update("DELETE FROM scenario_source WHERE scenario_key <> " + this.baselineScenario.key);
                    dbConnection.update("DELETE FROM scenario WHERE scenario_key <> " + this.baselineScenario.key);
                }
                catch (SQLException sQLException) {
                    bl = true;
                    string = "An operation cannot be completed due to a database error:\n" + sQLException;
                    DbConnection.reportError(sQLException);
                }
            }
            DbCore.releaseDb(dbConnection);
            if (bl && null != errorLogger) {
                errorLogger.reportError("Could not restore the study database:\n" + string);
            }
        } else {
            bl = true;
        }
        return !bl;
    }

    private boolean createStudyScenarios(ErrorLogger errorLogger) {
        ScenarioEditData scenarioEditData;
        SourceEditDataTV sourceEditDataTV;
        IxRuleEditData ixRuleEditData;
        int n;
        int n2;
        boolean bl;
        double d;
        int n3;
        int n4;
        int n5;
        SourceEditDataTV sourceEditDataTV2;
        boolean bl2;
        int n6;
        int n7;
        int n8;
        SourceEditDataTV sourceEditDataTV3;
        SourceEditData sourceEditData;
        SourceEditDataTV sourceEditDataTV4;
        int n9;
        double d2 = this.study.getKilometersPerDegree();
        boolean bl3 = this.study.getCheckIndividualDTSDistance();
        int n10 = this.study.getMinimumChannel();
        int n11 = this.study.getMaximumChannel();
        ArrayList<SourceEditDataTV> arrayList = new ArrayList<SourceEditDataTV>();
        for (SourceEditData object2 : this.baselineScenario.sourceData.getDesiredSources()) {
            arrayList.add((SourceEditDataTV)object2);
        }
        ArrayList arrayList2 = new ArrayList();
        for (IxRuleEditData ixRuleEditData2 : this.study.ixRuleData.getRows()) {
            if (!ixRuleEditData2.isActive || !ixRuleEditData2.serviceType.digital || !ixRuleEditData2.undesiredServiceType.digital || ixRuleEditData2.channelDelta.delta < -1 || ixRuleEditData2.channelDelta.delta > 1) continue;
            arrayList2.add(ixRuleEditData2);
        }
        this.sortedScenarios.clear();
        double d3 = 999.0;
        double d4 = -999.0;
        double d5 = 999.0;
        double d6 = -999.0;
        for (SourceEditDataTV sourceEditDataTV5 : arrayList) {
            if (sourceEditDataTV5.location.latitude < d3) {
                d3 = sourceEditDataTV5.location.latitude;
            }
            if (sourceEditDataTV5.location.latitude > d4) {
                d4 = sourceEditDataTV5.location.latitude;
            }
            if (sourceEditDataTV5.location.longitude < d5) {
                d5 = sourceEditDataTV5.location.longitude;
            }
            if (!(sourceEditDataTV5.location.longitude > d6)) continue;
            d6 = sourceEditDataTV5.location.longitude;
        }
        boolean bl4 = false;
        if (d4 - d3 > d6 - d5) {
            bl4 = true;
        }
        int n12 = n11 - n10 + 1;
        ArrayList arrayList3 = new ArrayList(n12);
        for (n9 = 0; n9 < n12; ++n9) {
            arrayList3.add(new HashMap());
        }
        this.scenarioCount = 0;
        this.scenarioSourceCount = 0;
        n9 = 0;
        int n13 = 0;
        ArrayList<Scenario.SourceListItem> arrayList4 = new ArrayList<Scenario.SourceListItem>();
        for (SourceEditDataTV sourceEditDataTV6 : arrayList) {
            if (null != this.studyCountry && this.studyCountry.key != sourceEditDataTV6.country.key) continue;
            if (null == sourceEditDataTV6.originalSourceKey) {
                sourceEditDataTV4 = sourceEditDataTV6;
            } else {
                sourceEditData = this.study.getSource(sourceEditDataTV6.originalSourceKey);
                if (null == sourceEditData || 1 != sourceEditData.recordType) {
                    if (null != errorLogger) {
                        errorLogger.reportError("An original record needed for replication does not exist");
                    }
                    return false;
                }
                sourceEditDataTV4 = (SourceEditDataTV)sourceEditData;
            }
            boolean bl5 = true;
            for (int n14 : this.studyChannels) {
                if (n14 == sourceEditDataTV4.channel && sourceEditDataTV4.service.serviceType.digital) {
                    sourceEditDataTV3 = sourceEditDataTV4;
                } else {
                    sourceEditDataTV3 = null;
                    sourceEditDataTV3 = sourceEditDataTV4.isLocked && null != sourceEditDataTV4.extDbKey && null != sourceEditDataTV4.extRecordID ? this.study.findSharedReplicationSource(sourceEditDataTV4.extDbKey, sourceEditDataTV4.extRecordID, n14) : (SourceEditDataTV)((HashMap)arrayList3.get(n14 - n10)).get(sourceEditDataTV4.key);
                    if (null == sourceEditDataTV3) {
                        sourceEditDataTV3 = sourceEditDataTV4.replicate(n14, errorLogger);
                        if (null == sourceEditDataTV3) {
                            return false;
                        }
                        this.study.addOrReplaceSource(sourceEditDataTV3);
                        if (!sourceEditDataTV4.isLocked || null == sourceEditDataTV4.extRecordID) {
                            ((HashMap)arrayList3.get(n14 - n10)).put(sourceEditDataTV4.key, sourceEditDataTV3);
                        }
                    }
                }
                arrayList4.add(new Scenario.SourceListItem(sourceEditDataTV3.key, true, false, false));
                n8 = sourceEditDataTV3.service.serviceType.key;
                n7 = sourceEditDataTV3.country.key;
                n6 = sourceEditDataTV3.frequencyOffset.key;
                bl2 = bl5;
                for (SourceEditDataTV sourceEditDataTV7 : arrayList) {
                    if (this.isCanceled()) {
                        return false;
                    }
                    if (sourceEditDataTV7.facilityID == sourceEditDataTV3.facilityID) continue;
                    if (null == sourceEditDataTV7.originalSourceKey) {
                        sourceEditDataTV2 = sourceEditDataTV7;
                    } else {
                        sourceEditData = this.study.getSource(sourceEditDataTV7.originalSourceKey);
                        if (null == sourceEditData || 1 != sourceEditData.recordType) {
                            if (null != errorLogger) {
                                errorLogger.reportError("An original record needed for replication does not exist");
                            }
                            return false;
                        }
                        sourceEditDataTV2 = (SourceEditDataTV)sourceEditData;
                    }
                    if (sourceEditDataTV2.service.serviceType.digital) {
                        n5 = sourceEditDataTV2.service.serviceType.key;
                        n4 = sourceEditDataTV2.frequencyOffset.key;
                        n3 = sourceEditDataTV2.emissionMask.key;
                    } else {
                        n5 = sourceEditDataTV2.service.digitalService.serviceType.key;
                        n4 = 0;
                        n3 = sourceEditDataTV2.service.digitalService.serviceType.needsEmissionMask ? EmissionMask.getDefaultObject().key : 0;
                    }
                    d = this.distanceBetween(sourceEditDataTV3, sourceEditDataTV2, d2, bl3);
                    bl = bl5;
                    for (n2 = -1; n2 <= 1; ++n2) {
                        n = n14 + n2;
                        if (n < n10 || n > n11 || (n14 < 5 ? n > 4 : (n14 < 7 ? n < 5 || n > 6 : n14 < 14 && (n < 7 || n > 13)))) continue;
                        ixRuleEditData = null;
                        Iterator iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            IxRuleEditData ixRuleEditData3 = (IxRuleEditData)iterator.next();
                            if (ixRuleEditData3.country.key != n7 || ixRuleEditData3.serviceType.key != n8 || ixRuleEditData3.undesiredServiceType.key != n5 || n2 != ixRuleEditData3.channelDelta.delta || n14 < ixRuleEditData3.channelBand.firstChannel || n14 > ixRuleEditData3.channelBand.lastChannel || 2 == ixRuleEditData3.frequencyOffset && (0 == n6 || 0 == n4 || n6 == n4) || 1 == ixRuleEditData3.frequencyOffset && 0 != n6 && 0 != n4 && n6 != n4 || 0 != ixRuleEditData3.emissionMask.key && (0 == n3 || ixRuleEditData3.emissionMask.key != n3)) continue;
                            ixRuleEditData = ixRuleEditData3;
                            break;
                        }
                        if (null == ixRuleEditData || d > ixRuleEditData.distance) continue;
                        if (bl2) {
                            ++n9;
                            bl2 = false;
                        }
                        if (bl) {
                            ++n13;
                            bl = false;
                        }
                        if (n == sourceEditDataTV2.channel && sourceEditDataTV2.service.serviceType.digital) {
                            sourceEditDataTV = sourceEditDataTV2;
                        } else {
                            sourceEditDataTV = null;
                            sourceEditDataTV = sourceEditDataTV2.isLocked && null != sourceEditDataTV2.extDbKey && null != sourceEditDataTV2.extRecordID ? this.study.findSharedReplicationSource(sourceEditDataTV2.extDbKey, sourceEditDataTV2.extRecordID, n) : (SourceEditDataTV)((HashMap)arrayList3.get(n - n10)).get(sourceEditDataTV2.key);
                            if (null == sourceEditDataTV) {
                                sourceEditDataTV = sourceEditDataTV2.replicate(n, errorLogger);
                                if (null == sourceEditDataTV) {
                                    return false;
                                }
                                this.study.addOrReplaceSource(sourceEditDataTV);
                                if (!sourceEditDataTV2.isLocked || null == sourceEditDataTV2.extRecordID) {
                                    ((HashMap)arrayList3.get(n - n10)).put(sourceEditDataTV2.key, sourceEditDataTV);
                                }
                            }
                        }
                        arrayList4.add(new Scenario.SourceListItem(sourceEditDataTV.key, false, true, false));
                    }
                }
                if (arrayList4.size() > 1) {
                    scenarioEditData = new ScenarioEditData(this.study, "Pair", "Pair study", arrayList4);
                    this.study.scenarioData.addOrReplace(scenarioEditData);
                    ScenarioSortItem scenarioSortItem = new ScenarioSortItem(scenarioEditData, sourceEditDataTV3, bl4);
                    this.sortedScenarios.add(scenarioSortItem);
                    ++this.scenarioCount;
                    this.scenarioSourceCount += scenarioSortItem.sourceCount;
                }
                arrayList4.clear();
                bl5 = false;
            }
        }
        for (SourceEditDataTV sourceEditDataTV6 : arrayList) {
            if (null == this.studyCountry || this.studyCountry.key == sourceEditDataTV6.country.key) continue;
            int n15 = sourceEditDataTV6.channel;
            if (sourceEditDataTV6.service.serviceType.digital) {
                sourceEditDataTV3 = sourceEditDataTV6;
            } else {
                if (null == sourceEditDataTV6.originalSourceKey) {
                    sourceEditDataTV4 = sourceEditDataTV6;
                } else {
                    sourceEditData = this.study.getSource(sourceEditDataTV6.originalSourceKey);
                    if (null == sourceEditData || 1 != sourceEditData.recordType) {
                        if (null != errorLogger) {
                            errorLogger.reportError("An original record needed for replication does not exist");
                        }
                        return false;
                    }
                    sourceEditDataTV4 = (SourceEditDataTV)sourceEditData;
                }
                sourceEditDataTV3 = null;
                sourceEditDataTV3 = sourceEditDataTV4.isLocked && null != sourceEditDataTV4.extDbKey && null != sourceEditDataTV4.extRecordID ? this.study.findSharedReplicationSource(sourceEditDataTV4.extDbKey, sourceEditDataTV4.extRecordID, n15) : (SourceEditDataTV)((HashMap)arrayList3.get(n15 - n10)).get(sourceEditDataTV4.key);
                if (null == sourceEditDataTV3) {
                    sourceEditDataTV3 = sourceEditDataTV4.replicate(n15, errorLogger);
                    if (null == sourceEditDataTV3) {
                        return false;
                    }
                    this.study.addOrReplaceSource(sourceEditDataTV3);
                    if (!sourceEditDataTV4.isLocked || null == sourceEditDataTV4.extRecordID) {
                        ((HashMap)arrayList3.get(n15 - n10)).put(sourceEditDataTV4.key, sourceEditDataTV3);
                    }
                }
            }
            arrayList4.add(new Scenario.SourceListItem(sourceEditDataTV3.key, true, false, false));
            n8 = sourceEditDataTV3.service.serviceType.key;
            n7 = sourceEditDataTV3.country.key;
            n6 = sourceEditDataTV3.frequencyOffset.key;
            bl2 = true;
            for (SourceEditDataTV sourceEditDataTV8 : arrayList) {
                if (this.isCanceled()) {
                    return false;
                }
                if (this.studyCountry.key != sourceEditDataTV8.country.key) continue;
                if (null == sourceEditDataTV8.originalSourceKey) {
                    sourceEditDataTV2 = sourceEditDataTV8;
                } else {
                    sourceEditData = this.study.getSource(sourceEditDataTV8.originalSourceKey);
                    if (null == sourceEditData || 1 != sourceEditData.recordType) {
                        if (null != errorLogger) {
                            errorLogger.reportError("An original record needed for replication does not exist");
                        }
                        return false;
                    }
                    sourceEditDataTV2 = (SourceEditDataTV)sourceEditData;
                }
                if (sourceEditDataTV2.service.serviceType.digital) {
                    n5 = sourceEditDataTV2.service.serviceType.key;
                    n4 = sourceEditDataTV2.frequencyOffset.key;
                    n3 = sourceEditDataTV2.emissionMask.key;
                } else {
                    n5 = sourceEditDataTV2.service.digitalService.serviceType.key;
                    n4 = 0;
                    n3 = sourceEditDataTV2.service.digitalService.serviceType.needsEmissionMask ? EmissionMask.getDefaultObject().key : 0;
                }
                d = this.distanceBetween(sourceEditDataTV3, sourceEditDataTV2, d2, bl3);
                bl = true;
                for (n2 = -1; n2 <= 1; ++n2) {
                    n = n15 + n2;
                    if (n < n10 || n > n11 || (n15 < 5 ? n > 4 : (n15 < 7 ? n < 5 || n > 6 : n15 < 14 && (n < 7 || n > 13)))) continue;
                    ixRuleEditData = null;
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        IxRuleEditData ixRuleEditData4 = (IxRuleEditData)iterator.next();
                        if (ixRuleEditData4.country.key != n7 || ixRuleEditData4.serviceType.key != n8 || ixRuleEditData4.undesiredServiceType.key != n5 || n2 != ixRuleEditData4.channelDelta.delta || n15 < ixRuleEditData4.channelBand.firstChannel || n15 > ixRuleEditData4.channelBand.lastChannel || 2 == ixRuleEditData4.frequencyOffset && (0 == n6 || 0 == n4 || n6 == n4) || 1 == ixRuleEditData4.frequencyOffset && 0 != n6 && 0 != n4 && n6 != n4 || 0 != ixRuleEditData4.emissionMask.key && (0 == n3 || ixRuleEditData4.emissionMask.key != n3)) continue;
                        ixRuleEditData = ixRuleEditData4;
                        break;
                    }
                    if (null == ixRuleEditData || d > ixRuleEditData.distance) continue;
                    if (bl2) {
                        ++n9;
                        bl2 = false;
                    }
                    if (bl) {
                        ++n13;
                        bl = false;
                    }
                    if (n == sourceEditDataTV2.channel && sourceEditDataTV2.service.serviceType.digital) {
                        sourceEditDataTV = sourceEditDataTV2;
                    } else {
                        sourceEditDataTV = null;
                        sourceEditDataTV = sourceEditDataTV2.isLocked && null != sourceEditDataTV2.extDbKey && null != sourceEditDataTV2.extRecordID ? this.study.findSharedReplicationSource(sourceEditDataTV2.extDbKey, sourceEditDataTV2.extRecordID, n) : (SourceEditDataTV)((HashMap)arrayList3.get(n - n10)).get(sourceEditDataTV2.key);
                        if (null == sourceEditDataTV) {
                            sourceEditDataTV = sourceEditDataTV2.replicate(n, errorLogger);
                            if (null == sourceEditDataTV) {
                                return false;
                            }
                            this.study.addOrReplaceSource(sourceEditDataTV);
                            if (!sourceEditDataTV2.isLocked || null == sourceEditDataTV2.extRecordID) {
                                ((HashMap)arrayList3.get(n - n10)).put(sourceEditDataTV2.key, sourceEditDataTV);
                            }
                        }
                    }
                    arrayList4.add(new Scenario.SourceListItem(sourceEditDataTV.key, false, true, false));
                }
            }
            if (arrayList4.size() > 1) {
                scenarioEditData = new ScenarioEditData(this.study, "Pair", "Pair study", arrayList4);
                this.study.scenarioData.addOrReplace(scenarioEditData);
                ScenarioSortItem scenarioSortItem = new ScenarioSortItem(scenarioEditData, sourceEditDataTV3, bl4);
                this.sortedScenarios.add(scenarioSortItem);
                ++this.scenarioCount;
                this.scenarioSourceCount += scenarioSortItem.sourceCount;
            }
            arrayList4.clear();
        }
        if (this.scenarioCount > 0) {
            int n16 = this.scenarioCount / 5;
            if (n16 < 1) {
                n16 = 1;
            }
            if (n16 < this.runCount) {
                this.runCount = n16;
            }
        }
        if (null != errorLogger) {
            errorLogger.logMessage("Stations in baseline scenario: " + AppCore.formatCount(arrayList.size()));
            errorLogger.logMessage("   Stations involved in pairs: " + AppCore.formatCount(n9));
            errorLogger.logMessage("   Unique pairs to be studied: " + AppCore.formatCount(n13));
            errorLogger.logMessage("         Pair study scenarios: " + AppCore.formatCount(this.scenarioCount));
        }
        return true;
    }

    private double distanceBetween(SourceEditDataTV sourceEditDataTV, SourceEditDataTV sourceEditDataTV2, double d, boolean bl) {
        double d2 = 99999.0;
        if (sourceEditDataTV.isParent) {
            for (SourceEditDataTV sourceEditDataTV3 : sourceEditDataTV.getDTSSources()) {
                double d3;
                if (sourceEditDataTV3.siteNumber <= 0) continue;
                double d4 = sourceEditDataTV3.getRuleExtraDistance();
                if (sourceEditDataTV2.isParent && bl) {
                    for (GeoPoint geoPoint : sourceEditDataTV2.getDTSLocations()) {
                        d3 = sourceEditDataTV3.location.distanceTo(geoPoint, d) - d4;
                        if (!(d3 < d2)) continue;
                        d2 = d3;
                    }
                    continue;
                }
                d3 = sourceEditDataTV3.location.distanceTo(sourceEditDataTV2.location, d) - d4;
                if (!(d3 < d2)) continue;
                d2 = d3;
            }
        } else {
            double d5 = sourceEditDataTV.getRuleExtraDistance();
            if (sourceEditDataTV2.isParent && bl) {
                for (GeoPoint geoPoint : sourceEditDataTV2.getDTSLocations()) {
                    double d6 = sourceEditDataTV.location.distanceTo(geoPoint, d) - d5;
                    if (!(d6 < d2)) continue;
                    d2 = d6;
                }
            } else {
                d2 = sourceEditDataTV.location.distanceTo(sourceEditDataTV2.location, d) - d5;
            }
        }
        return d2;
    }

    public static class ScenarioSortItem
    implements Comparable {
        public Integer key;
        public int sourceCount;
        private double coordinate;

        private ScenarioSortItem(ScenarioEditData scenarioEditData, SourceEditDataTV sourceEditDataTV, boolean bl) {
            this.key = scenarioEditData.key;
            this.coordinate = bl ? sourceEditDataTV.location.latitude : sourceEditDataTV.location.longitude;
            this.sourceCount = scenarioEditData.sourceData.getRowCount();
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            return null != object && this.key.equals(((ScenarioSortItem)object).key);
        }

        public int compareTo(Object object) {
            if (null == object) {
                return 0;
            }
            ScenarioSortItem scenarioSortItem = (ScenarioSortItem)object;
            if (this.coordinate < scenarioSortItem.coordinate) {
                return -1;
            }
            if (this.coordinate > scenarioSortItem.coordinate) {
                return 1;
            }
            return this.key.compareTo(scenarioSortItem.key);
        }
    }
}

