/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.AppTask;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.OutputConfig;
import gov.fcc.tvstudy.core.ProcessRun;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.core.StudyBuild;
import gov.fcc.tvstudy.core.data.IxRule;
import gov.fcc.tvstudy.core.data.Parameter;
import gov.fcc.tvstudy.core.data.Scenario;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.data.Template;
import gov.fcc.tvstudy.core.editdata.ParameterEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioListData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.SourceListData;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class StudyBuildIxCheck
extends StudyBuild
implements ProcessRun.Handler {
    public static final int MIN_LMS_VERSION = 6;
    public static final String DEFAULT_CONFIG_NAME = "Interference Check";
    public static final String STUDY_NAME_PREFIX = "IxCheck";
    public static final String LOG_FILE_NAME = "log.txt";
    public static final double[] CELL_SIZES = new double[]{2.0, 1.0, 0.5};
    public Path outPath;
    public String indexFileName;
    public String logFileName;
    public int templateKey;
    public ExtDb extDb;
    public OutputConfig fileOutputConfig;
    public OutputConfig mapOutputConfig;
    public String cellSize;
    public String profilePpk;
    public String defaultCellSize;
    public String defaultProfilePpk;
    public String defaultCellSizeLPTV;
    public String defaultProfilePpkLPTV;
    public double amSearchDistanceND;
    public double amSearchDistanceDA;
    public boolean buildFullStudy = true;
    public SourceEditDataTV beforeSource;
    public ExtDbRecordTV beforeRecord;
    public boolean didSetBefore;
    public boolean protectPreBaseline;
    public boolean protectBaselineFromLPTV;
    public boolean protectLPTVFromClassA;
    public boolean includeForeign;
    public TreeSet<Integer> includeUserRecords;
    public boolean cpExcludesBaseline;
    public boolean excludeApps;
    public boolean includeAmendments;
    public boolean excludePending;
    public boolean excludePostTransition;
    public boolean excludeNewLPTV;
    public TreeSet<String> excludeCommands;
    private HashSet<String> excludeARNs;
    private HashSet<Integer> excludeFacilityIDs;
    private HashSet<String> excludeCallSigns;
    public Date baselineDate;
    public Date filingWindowEndDate;
    public Date filingCutoffDate;
    private StringBuilder studyReport;
    private Path studyOutDirectoryPath;
    private ArrayList<String> outputFiles;
    private StudyEditData study;
    private ArrayList<IxRule> rules;
    private SourceEditDataTV proposalSource;
    private SourceEditDataTV proposalBeforeSource;
    private ScenarioEditData proposalScenario;
    private ArrayList<SourceEditData> userRecordSources;
    private ArrayList<Protected> protectedList;
    private HashSet<Integer> baselineExcludedIndex;
    private ExtDbRecordTV.BaselineIndex baselineIndex;
    private HashMap<Integer, ArrayList<ExtDbRecordTV>> searchCache;
    private HashMap<Integer, ArrayList<ExtDbRecordTV>> baselineCache;
    private TreeMap<String, ExtDbRecordTV> excludedRecords;
    private TreeMap<Integer, SourceEditDataTV> includedSources;
    private ScenarioBuilder builder;
    private ProcessRun studyRun;
    private ProcessRun probeRun;
    private StatusLogger runStatus;
    private ErrorLogger runErrors;
    private int runStatusTotal;
    private int runStatusRunning;
    private int runStatusDone;
    private static final long STATUS_UPDATE_INTERVAL = 2950L;
    private long lastRunStatusUpdate;
    private String probeRunDescription;
    private ArrayList<IXProbeResult> probeRunResult;

    public StudyBuildIxCheck(String string) {
        super(string);
    }

    public static boolean isExtDbSupported(ExtDb extDb) {
        return ExtDbRecordTV.isExtDbSupported(extDb) && (2 == extDb.type || 5 == extDb.type) && extDb.version >= 6;
    }

    public void loadDefaults() {
        Object object;
        if (this.initialized) {
            return;
        }
        this.templateKey = Template.getTemplateKeyForName(this.dbID, DEFAULT_CONFIG_NAME);
        if (this.templateKey > 0) {
            object = Template.getTemplateInfo(this.dbID, this.templateKey);
            if (null == object || !((Template.Info)object).isLocked || ((Template.Info)object).isLockedInStudy) {
                this.templateKey = 1;
            }
        } else {
            this.templateKey = 1;
        }
        this.extDb = ExtDb.getExtDb(this.dbID, DEFAULT_CONFIG_NAME);
        if (null == this.extDb || !StudyBuildIxCheck.isExtDbSupported(this.extDb)) {
            this.extDb = ExtDb.getExtDb(this.dbID, 10005);
        }
        this.fileOutputConfig = OutputConfig.getConfig(this.dbID, 1, DEFAULT_CONFIG_NAME);
        if (null == this.fileOutputConfig) {
            this.fileOutputConfig = OutputConfig.getLastUsed(this.dbID, 1);
        }
        this.mapOutputConfig = OutputConfig.getConfig(this.dbID, 2, DEFAULT_CONFIG_NAME);
        if (null == this.mapOutputConfig) {
            this.mapOutputConfig = OutputConfig.getLastUsed(this.dbID, 2);
        }
        this.defaultCellSize = AppCore.getPreference("ixCheckDefaultCellSize");
        this.defaultProfilePpk = AppCore.getPreference("ixCheckDefaultProfileResolution");
        this.defaultCellSizeLPTV = AppCore.getPreference("ixCheckDefaultCellSizeLPTV");
        this.defaultProfilePpkLPTV = AppCore.getPreference("ixCheckDefaultProfileResolution");
        object = AppCore.getPreference("ixCheckAMSearchDistanceND");
        if (null != object && ((String)object).length() > 0) {
            this.amSearchDistanceND = 0.0;
            try {
                this.amSearchDistanceND = Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (null != (object = AppCore.getPreference("ixCheckAMSearchDistanceDA")) && ((String)object).length() > 0) {
            this.amSearchDistanceDA = 0.0;
            try {
                this.amSearchDistanceDA = Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (null != (object = AppCore.getPreference("lmsBaselineDate")) && ((String)object).length() > 0) {
            this.baselineDate = AppCore.parseDate((String)object);
        }
        if (null != (object = AppCore.getPreference("ixCheckFilingWindowEndDate")) && ((String)object).length() > 0) {
            this.filingWindowEndDate = AppCore.parseDate((String)object);
        }
        this.protectPreBaseline = null != (object = AppCore.getPreference("ixCheckProtectPreBaselineDefault")) && Boolean.valueOf((String)object) != false;
        object = AppCore.getPreference("ixCheckIncludeForeignDefault");
        this.includeForeign = null != object && Boolean.valueOf((String)object) != false;
        object = AppCore.getPreference("ixCheckDefaultCPExcludesBL");
        this.cpExcludesBaseline = null != object && Boolean.valueOf((String)object) != false;
        object = AppCore.getPreference("ixCheckDefaultExcludeNewLPTV");
        this.excludeNewLPTV = null != object && Boolean.valueOf((String)object) != false;
        this.protectLPTVFromClassA = true;
    }

    public StudyBuildIxCheck copy() {
        StudyBuildIxCheck studyBuildIxCheck = new StudyBuildIxCheck(this.dbID);
        studyBuildIxCheck.studyDescription = this.studyDescription;
        studyBuildIxCheck.studyFolderKey = this.studyFolderKey;
        studyBuildIxCheck.source = this.source;
        studyBuildIxCheck.record = this.record;
        studyBuildIxCheck.replicate = this.replicate;
        studyBuildIxCheck.changeChannel = this.changeChannel;
        studyBuildIxCheck.studyChannel = this.studyChannel;
        studyBuildIxCheck.outPath = this.outPath;
        studyBuildIxCheck.indexFileName = this.indexFileName;
        studyBuildIxCheck.logFileName = this.logFileName;
        studyBuildIxCheck.templateKey = this.templateKey;
        studyBuildIxCheck.extDb = this.extDb;
        studyBuildIxCheck.fileOutputConfig = this.fileOutputConfig;
        studyBuildIxCheck.mapOutputConfig = this.mapOutputConfig;
        studyBuildIxCheck.cellSize = this.cellSize;
        studyBuildIxCheck.profilePpk = this.profilePpk;
        studyBuildIxCheck.defaultCellSize = this.defaultCellSize;
        studyBuildIxCheck.defaultProfilePpk = this.defaultProfilePpk;
        studyBuildIxCheck.defaultCellSizeLPTV = this.defaultCellSizeLPTV;
        studyBuildIxCheck.defaultProfilePpkLPTV = this.defaultProfilePpkLPTV;
        studyBuildIxCheck.amSearchDistanceND = this.amSearchDistanceND;
        studyBuildIxCheck.amSearchDistanceDA = this.amSearchDistanceDA;
        studyBuildIxCheck.buildFullStudy = this.buildFullStudy;
        studyBuildIxCheck.beforeSource = this.beforeSource;
        studyBuildIxCheck.beforeRecord = this.beforeRecord;
        studyBuildIxCheck.didSetBefore = this.didSetBefore;
        studyBuildIxCheck.protectPreBaseline = this.protectPreBaseline;
        studyBuildIxCheck.protectBaselineFromLPTV = this.protectBaselineFromLPTV;
        studyBuildIxCheck.protectLPTVFromClassA = this.protectLPTVFromClassA;
        studyBuildIxCheck.includeForeign = this.includeForeign;
        if (null != this.includeUserRecords) {
            studyBuildIxCheck.includeUserRecords = new TreeSet<Integer>((SortedSet<Integer>)this.includeUserRecords);
        }
        studyBuildIxCheck.cpExcludesBaseline = this.cpExcludesBaseline;
        studyBuildIxCheck.excludeApps = this.excludeApps;
        studyBuildIxCheck.includeAmendments = this.includeAmendments;
        studyBuildIxCheck.excludePending = this.excludePending;
        studyBuildIxCheck.excludePostTransition = this.excludePostTransition;
        studyBuildIxCheck.excludeNewLPTV = this.excludeNewLPTV;
        if (null != this.excludeCommands) {
            studyBuildIxCheck.excludeCommands = new TreeSet<String>((SortedSet<String>)this.excludeCommands);
        }
        studyBuildIxCheck.baselineDate = this.baselineDate;
        studyBuildIxCheck.filingWindowEndDate = this.filingWindowEndDate;
        studyBuildIxCheck.filingCutoffDate = this.filingCutoffDate;
        return studyBuildIxCheck;
    }

    @Override
    public boolean initialize(ErrorLogger errorLogger) {
        Object object;
        int n;
        Object object2;
        if (this.initialized) {
            return true;
        }
        if (!super.initialize(errorLogger)) {
            return false;
        }
        Template.Info info = null;
        if (this.templateKey > 0) {
            info = Template.getTemplateInfo(this.dbID, this.templateKey);
        }
        if (null == info || !info.isLocked || info.isLockedInStudy) {
            if (null != errorLogger) {
                errorLogger.reportError("Missing or invalid template selection");
            }
            return false;
        }
        if (null == this.extDb || !StudyBuildIxCheck.isExtDbSupported(this.extDb)) {
            if (null != errorLogger) {
                errorLogger.reportError("Missing or invalid station data selection");
            }
            return false;
        }
        if (this.didSetBefore) {
            object2 = Parameter.getTemplateParameterValue(this.dbID, this.templateKey, 200, 0, errorLogger);
            if (null == object2) {
                return false;
            }
            double d = 0.0;
            try {
                d = Double.parseDouble((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (d < 110.0) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad parameter value in selected template");
                }
                return false;
            }
            boolean bl = true;
            if (null != this.beforeSource) {
                bl = null != this.source ? ExtDbRecordTV.areRecordsMX((SourceEditDataTV)this.source, this.beforeSource, true, 0.0, 0.0) : ExtDbRecordTV.areRecordsMX((ExtDbRecordTV)this.record, this.beforeSource, true, 0.0, 0.0);
            } else if (null != this.beforeRecord) {
                bl = null != this.source ? ExtDbRecordTV.areRecordsMX((SourceEditDataTV)this.source, this.beforeRecord, true, 0.0, 0.0) : ExtDbRecordTV.areRecordsMX((ExtDbRecordTV)this.record, this.beforeRecord, true, 0.0, 0.0);
            }
            if (!bl) {
                if (null != errorLogger) {
                    errorLogger.reportError("The \"before\" record must be MX to the proposal");
                }
                return false;
            }
        }
        object2 = null;
        HashSet<String> hashSet = null;
        HashSet<Integer> hashSet2 = null;
        if (this.buildFullStudy) {
            if (null == this.fileOutputConfig || !this.fileOutputConfig.isValid()) {
                if (null != errorLogger) {
                    errorLogger.reportError("Missing or invalid output file settings");
                }
                return false;
            }
            if (null == this.mapOutputConfig || !this.mapOutputConfig.isValid()) {
                if (null != errorLogger) {
                    errorLogger.reportError("Missing or invalid map output settings");
                }
                return false;
            }
            if (null != this.excludeCommands && !this.excludeCommands.isEmpty()) {
                boolean bl = false;
                for (String string : this.excludeCommands) {
                    String string2;
                    if (string.startsWith("$")) {
                        n = string.indexOf(61);
                        if (n > 0) {
                            string2 = string.substring(1, n).trim().toLowerCase();
                            object = string.substring(n + 1).trim();
                        } else {
                            string2 = string.trim().toLowerCase();
                            object = "";
                        }
                    } else {
                        string2 = "arn";
                        object = string.trim();
                        if (0 == ((String)object).length()) continue;
                    }
                    if (string2.equals("arn")) {
                        if (((String)object).length() > 0) {
                            if (null == object2) {
                                object2 = new HashSet();
                            }
                            ((HashSet)object2).add(((String)object).toUpperCase());
                        } else {
                            bl = true;
                        }
                    } else if (string2.equals("facilityid")) {
                        int n2 = 0;
                        try {
                            n2 = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n2 > 0) {
                            if (null == hashSet2) {
                                hashSet2 = new HashSet<Integer>();
                            }
                            hashSet2.add(n2);
                        } else {
                            bl = true;
                        }
                    } else if (string2.equals("callsign")) {
                        if (((String)object).length() > 0) {
                            if (null == hashSet) {
                                hashSet = new HashSet<String>();
                            }
                            hashSet.add(((String)object).toUpperCase());
                        } else {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                    if (!bl) continue;
                    if (null != errorLogger) {
                        errorLogger.reportError("Bad command '" + string + "' in exclusion list");
                    }
                    return false;
                }
            }
        }
        boolean bl = null != this.source ? this.source.service.isLPTV() : this.record.service.isLPTV();
        if (null != this.cellSize) {
            this.cellSize = this.cellSize.trim();
            if (0 == this.cellSize.length()) {
                this.cellSize = null;
            }
        }
        if (null == this.cellSize) {
            this.cellSize = bl ? this.defaultCellSizeLPTV : this.defaultCellSize;
        }
        if (null != this.cellSize) {
            try {
                this.cellSize = AppCore.formatDecimal(Double.parseDouble(this.cellSize), 0, 2);
            }
            catch (NumberFormatException numberFormatException) {
                this.cellSize = null;
            }
        }
        if (null != this.profilePpk) {
            this.profilePpk = this.profilePpk.trim();
            if (0 == this.profilePpk.length()) {
                this.profilePpk = null;
            }
        }
        if (null == this.profilePpk) {
            this.profilePpk = bl ? this.defaultProfilePpkLPTV : this.defaultProfilePpk;
        }
        if (null != this.profilePpk) {
            try {
                this.profilePpk = AppCore.formatDecimal(Double.parseDouble(this.profilePpk), 0, 1);
            }
            catch (NumberFormatException numberFormatException) {
                this.profilePpk = null;
            }
        }
        if (this.buildFullStudy) {
            this.fileOutputConfig.flags[6] = 0;
            this.fileOutputConfig.flags[13] = 1;
            if (null != this.filingWindowEndDate) {
                if (null != this.source) {
                    object = AppCore.parseDate(this.source.getAttribute("sequenceDate"));
                    if (null == object) {
                        object = new Date();
                    }
                    n = this.source.service.isClassA() ? 1 : 0;
                } else {
                    object = this.record.sequenceDate;
                    n = this.record.service.isClassA() ? 1 : 0;
                }
                if (n != 0 && ((Date)object).after(this.filingWindowEndDate)) {
                    this.protectLPTVFromClassA = true;
                }
            }
            if (null != this.excludeCommands) {
                if (this.excludeCommands.isEmpty()) {
                    this.excludeCommands = null;
                } else {
                    this.excludeARNs = object2;
                    this.excludeFacilityIDs = hashSet2;
                    this.excludeCallSigns = hashSet;
                }
            }
            if (null != this.includeUserRecords && this.includeUserRecords.isEmpty()) {
                this.includeUserRecords = null;
            }
            if (null == this.outPath) {
                this.outPath = AppCore.outDirectoryPath;
            }
            if (null != this.indexFileName) {
                this.indexFileName = this.indexFileName.trim();
                if (0 == this.indexFileName.length()) {
                    this.indexFileName = null;
                }
            }
            if (null != this.logFileName) {
                this.logFileName = this.logFileName.trim();
                if (0 == this.logFileName.length()) {
                    this.logFileName = null;
                }
            }
            if (null == this.logFileName) {
                this.logFileName = LOG_FILE_NAME;
            }
            this.outputFiles = new ArrayList();
            this.baselineExcludedIndex = new HashSet();
            this.searchCache = new HashMap();
            this.baselineCache = new HashMap();
        }
        this.studyReport = new StringBuilder();
        StudyBuildIxCheck.makeDescription(this.source, this.record, this.didSetBefore, this.beforeSource, this.beforeRecord, this.studyReport, this);
        if (null != this.studyName) {
            this.studyName = this.studyName.trim();
            if (0 == this.studyName.length()) {
                this.studyName = null;
            }
        }
        if (null != this.studyName) {
            this.updateStudyOutDirectoryPath(false);
        }
        if (null != this.studyDescription) {
            this.studyDescription = this.studyDescription.trim();
            if (0 == this.studyDescription.length()) {
                this.studyDescription = null;
            }
        }
        this.initialized = true;
        return true;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (null != this.builder) {
            this.builder.cancel();
        }
    }

    private void updateStudyOutDirectoryPath(boolean bl) {
        if (null != this.outPath && null != this.studyName) {
            String string = bl ? this.dbID : DbCore.getHostDbName(this.dbID);
            this.studyOutDirectoryPath = null == string ? this.outPath.resolve(this.studyName) : this.outPath.resolve(string).resolve(this.studyName);
        }
    }

    private static void makeDescription(SourceEditData sourceEditData, ExtDbRecord extDbRecord, boolean bl, SourceEditDataTV sourceEditDataTV, ExtDbRecordTV extDbRecordTV, StringBuilder stringBuilder, StudyBuildIxCheck studyBuildIxCheck) {
        StationRecord stationRecord = null != sourceEditData ? sourceEditData : extDbRecord;
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(stationRecord.getCallSign());
        stringBuilder2.append(' ');
        if (null != studyBuildIxCheck) {
            if (studyBuildIxCheck.replicate || studyBuildIxCheck.changeChannel) {
                if (studyBuildIxCheck.replicate) {
                    stringBuilder2.append('D');
                } else {
                    stringBuilder2.append(stationRecord.isDigital() ? (char)'D' : 'N');
                }
                stringBuilder2.append(String.valueOf(studyBuildIxCheck.studyChannel));
                stringBuilder2.append(" (");
                stringBuilder2.append(stationRecord.getChannel());
                stringBuilder2.append(')');
            } else {
                stringBuilder2.append(stationRecord.getChannel());
            }
        } else {
            stringBuilder2.append(stationRecord.getChannel());
        }
        stringBuilder2.append(' ');
        stringBuilder2.append(stationRecord.getServiceCode());
        stringBuilder2.append(' ');
        String string = stationRecord.getStatus();
        if (string.length() > 0) {
            stringBuilder2.append(string);
            stringBuilder2.append(' ');
        }
        stringBuilder2.append(stationRecord.getCity());
        stringBuilder2.append(", ");
        stringBuilder2.append(stationRecord.getState());
        if (null != studyBuildIxCheck) {
            if (null == studyBuildIxCheck.studyDescription) {
                studyBuildIxCheck.studyDescription = "Interference check study for " + stationRecord.getFileNumber() + " " + stringBuilder2.toString();
            }
            stringBuilder.append("Study created: ");
            stringBuilder.append(new SimpleDateFormat("yyyy.MM.dd HH:mm:ss", Locale.US).format(new Date()));
            stringBuilder.append(" TVStudy v");
            stringBuilder.append(AppCore.appVersionString);
            stringBuilder.append("\n\n");
            stringBuilder.append("Study build station data: ");
            stringBuilder.append(ExtDb.getExtDbDescription(studyBuildIxCheck.dbID, studyBuildIxCheck.extDb.key));
            stringBuilder.append("\n\n");
        } else {
            stringBuilder.append("Study last edited: ");
            stringBuilder.append(new SimpleDateFormat("yyyy.MM.dd HH:mm:ss", Locale.US).format(new Date()));
            stringBuilder.append("\n\n");
        }
        stringBuilder.append("    Proposal: ");
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append('\n');
        string = stationRecord.getFileNumber();
        if (string.length() > 0) {
            stringBuilder.append(" File number: ");
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        stringBuilder.append(" Facility ID: ");
        stringBuilder.append(stationRecord.getFacilityID());
        stringBuilder.append('\n');
        if (stationRecord.hasRecordID()) {
            stringBuilder.append("Station data: ");
            stringBuilder.append(stationRecord.getStationData());
            stringBuilder.append('\n');
            stringBuilder.append("   Record ID: ");
            stringBuilder.append(stationRecord.getRecordID());
            stringBuilder.append('\n');
        }
        stringBuilder.append("     Country: ");
        stringBuilder.append(stationRecord.getCountry());
        stringBuilder.append('\n');
        string = stationRecord.getZone();
        if (string.length() > 0) {
            stringBuilder.append("        Zone: ");
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        if (stationRecord.isDTS()) {
            stringBuilder.append("   Ref. lat.: ");
            stringBuilder.append(stationRecord.getLatitude());
            stringBuilder.append('\n');
            stringBuilder.append("  Ref. long.: ");
            stringBuilder.append(stationRecord.getLongitude());
            stringBuilder.append('\n');
            stringBuilder.append(" # DTS sites: ");
            stringBuilder.append(stationRecord.getSiteCount());
            stringBuilder.append('\n');
        }
        stringBuilder.append('\n');
        if (bl) {
            StationRecord stationRecord2 = stationRecord = null != sourceEditDataTV ? sourceEditDataTV : extDbRecordTV;
            if (null == stationRecord) {
                stringBuilder.append("Proposal \"before\": (none)\n");
            } else {
                stringBuilder.append("Proposal \"before\": ");
                stringBuilder.append(stationRecord.getCallSign());
                stringBuilder.append(' ');
                stringBuilder.append(stationRecord.getChannel());
                stringBuilder.append(' ');
                stringBuilder.append(stationRecord.getServiceCode());
                stringBuilder.append(' ');
                string = stationRecord.getStatus();
                if (string.length() > 0) {
                    stringBuilder.append(string);
                    stringBuilder.append(' ');
                }
                stringBuilder.append(stationRecord.getCity());
                stringBuilder.append(", ");
                stringBuilder.append(stationRecord.getState());
                stringBuilder.append('\n');
                string = stationRecord.getFileNumber();
                if (string.length() > 0) {
                    stringBuilder.append("      File number: ");
                    stringBuilder.append(string);
                    stringBuilder.append('\n');
                }
                stringBuilder.append("      Facility ID: ");
                stringBuilder.append(stationRecord.getFacilityID());
                stringBuilder.append('\n');
                if (stationRecord.hasRecordID()) {
                    stringBuilder.append("     Station data: ");
                    stringBuilder.append(stationRecord.getStationData());
                    stringBuilder.append('\n');
                    stringBuilder.append("        Record ID: ");
                    stringBuilder.append(stationRecord.getRecordID());
                    stringBuilder.append('\n');
                }
                stringBuilder.append("          Country: ");
                stringBuilder.append(stationRecord.getCountry());
                stringBuilder.append('\n');
                if (null != sourceEditDataTV && !sourceEditDataTV.isLocked) {
                    stringBuilder.append("(record may have been modified)\n");
                }
            }
            stringBuilder.append('\n');
        }
    }

    public String getStudyDescription() {
        return this.studyDescription;
    }

    public Path getStudyOutDirectoryPath() {
        return this.studyOutDirectoryPath;
    }

    public String getIndexURLPath() {
        return this.makeIndexURLPath(this.studyName);
    }

    public ArrayList<String> getOutputFiles() {
        return this.outputFiles;
    }

    public String getStudyReport() {
        if (null != this.studyReport) {
            return this.studyReport.toString();
        }
        return "";
    }

    public ArrayList<RunIndex> getPastRuns() {
        return this.getPastRuns(null);
    }

    public ArrayList<RunIndex> getPastRuns(ErrorLogger errorLogger) {
        if (!this.initialized) {
            if (null != errorLogger) {
                errorLogger.reportError("Study build has not been initialized");
            }
            return null;
        }
        String string = this.makeStudyID();
        if (null == string) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot run study, unable to form unique study ID");
            }
            return null;
        }
        ArrayList<RunIndex> arrayList = null;
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null != dbConnection) {
            try {
                arrayList = new ArrayList<RunIndex>();
                String string2 = null;
                dbConnection.query("SELECT study_name, run_date FROM ix_check_status WHERE study_id = '" + DbConnection.clean(string) + "' ORDER BY run_date");
                while (dbConnection.next()) {
                    string2 = dbConnection.getString(1);
                    RunIndex runIndex = new RunIndex();
                    runIndex.indexURLPath = this.makeIndexURLPath(string2);
                    runIndex.runDate = dbConnection.getTimestamp(2);
                    arrayList.add(runIndex);
                }
                if (null != string2) {
                    this.studyName = string2;
                    this.updateStudyOutDirectoryPath(true);
                }
                DbCore.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                arrayList = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        return arrayList;
    }

    private String makeIndexURLPath(String string) {
        if (null == this.outPath || null == string || null == this.indexFileName) {
            return null;
        }
        return this.outPath.getFileName().toString() + "/" + this.dbID + "/" + string + "/" + this.indexFileName;
    }

    public boolean willRunStudy() {
        return this.willRunStudy(null);
    }

    public boolean willRunStudy(ErrorLogger errorLogger) {
        if (!this.initialized) {
            if (null != errorLogger) {
                errorLogger.reportError("Study build has not been initialized");
            }
            return false;
        }
        String string = this.makeStudyID();
        if (null == string) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot run study, unable to form unique study ID");
            }
            return false;
        }
        boolean bl = false;
        String string2 = "";
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.update("LOCK TABLES ix_check_status WRITE, ix_check_name_sequence WRITE");
                dbConnection.update("UPDATE ix_check_name_sequence SET name_key = name_key + 1");
                dbConnection.query("SELECT name_key FROM ix_check_name_sequence");
                dbConnection.next();
                this.studyName = STUDY_NAME_PREFIX + dbConnection.getString(1);
                this.updateStudyOutDirectoryPath(true);
                try {
                    Files.createDirectories(this.studyOutDirectoryPath, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    bl = true;
                    string2 = "Cannot create output directory: " + iOException;
                }
                if (!bl) {
                    dbConnection.update("INSERT INTO ix_check_status VALUES ('" + this.studyName + "', '" + DbConnection.clean(string) + "', NOW())");
                }
            }
            catch (SQLException sQLException) {
                bl = true;
                string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
            if (bl && null != errorLogger) {
                errorLogger.reportError(string2);
            }
        } else {
            bl = true;
        }
        return !bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String makeStudyID() {
        Object object;
        if (!this.initialized) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (null != this.source) {
            if (null != this.source.userRecordID) {
                stringBuilder.append("U#I");
                stringBuilder.append(String.valueOf(this.source.userRecordID));
            } else {
                if (null == this.source.extDbKey || null == this.source.extRecordID) return null;
                stringBuilder.append(String.valueOf(this.source.extDbKey));
                stringBuilder.append("#I");
                stringBuilder.append(this.source.extRecordID);
            }
        } else {
            stringBuilder.append(String.valueOf(this.record.extDb.key));
            stringBuilder.append("#I");
            stringBuilder.append(this.record.extRecordID);
        }
        if (this.replicate || this.changeChannel) {
            stringBuilder.append("#C");
            stringBuilder.append(String.valueOf(this.studyChannel));
        }
        stringBuilder.append("#T");
        stringBuilder.append(String.valueOf(this.templateKey));
        stringBuilder.append("#E");
        stringBuilder.append(String.valueOf(this.extDb.key));
        stringBuilder.append("#O");
        stringBuilder.append(this.fileOutputConfig.getCodes());
        stringBuilder.append("#M");
        stringBuilder.append(this.mapOutputConfig.getCodes());
        if (null != this.cellSize) {
            stringBuilder.append("#S");
            stringBuilder.append(this.cellSize);
        }
        if (null != this.profilePpk) {
            stringBuilder.append("#P");
            stringBuilder.append(this.profilePpk);
        }
        stringBuilder.append("#F");
        stringBuilder.append(this.excludeApps ? (char)'Y' : 'N');
        stringBuilder.append(this.excludePending ? (char)'Y' : 'N');
        stringBuilder.append(this.includeForeign ? (char)'Y' : 'N');
        stringBuilder.append(this.protectPreBaseline ? (char)'Y' : 'N');
        stringBuilder.append(this.protectBaselineFromLPTV ? (char)'Y' : 'N');
        stringBuilder.append(this.protectLPTVFromClassA ? (char)'Y' : 'N');
        stringBuilder.append(this.cpExcludesBaseline ? (char)'Y' : 'N');
        stringBuilder.append(this.excludePostTransition ? (char)'Y' : 'N');
        stringBuilder.append(this.excludeNewLPTV ? (char)'Y' : 'N');
        stringBuilder.append(this.includeAmendments ? (char)'Y' : 'N');
        if (null != this.filingCutoffDate) {
            stringBuilder.append("#D");
            object = Calendar.getInstance();
            ((Calendar)object).setTime(this.filingCutoffDate);
            stringBuilder.append(String.format("%d%02d%02d", ((Calendar)object).get(1), ((Calendar)object).get(2), ((Calendar)object).get(5)));
        }
        if (null != this.excludeCommands) {
            stringBuilder.append("#X");
            object = "";
            for (String string : this.excludeCommands) {
                stringBuilder.append((String)object);
                stringBuilder.append(string.toUpperCase());
                object = ":";
            }
        }
        if (null == this.includeUserRecords) return stringBuilder.toString();
        stringBuilder.append("#A");
        object = "";
        for (Integer n : this.includeUserRecords) {
            stringBuilder.append((String)object);
            stringBuilder.append(String.valueOf(n));
            object = ":";
        }
        return stringBuilder.toString();
    }

    public boolean runStudy() {
        return this.runStudy(null, null);
    }

    public boolean runStudy(ErrorLogger errorLogger) {
        return this.runStudy(null, errorLogger);
    }

    public boolean runStudy(StatusLogger statusLogger) {
        return this.runStudy(statusLogger, null);
    }

    public boolean runStudy(StatusLogger statusLogger, ErrorLogger errorLogger) {
        if (!this.initialized) {
            if (null != errorLogger) {
                errorLogger.reportError("Study build has not been initialized");
            }
            return false;
        }
        if (null == this.studyName || null == this.studyOutDirectoryPath) {
            if (null != errorLogger) {
                errorLogger.reportError("Study build failed, study name is not set");
            }
            return false;
        }
        if (AppCore.maxEngineProcessCount < 1) {
            if (null != errorLogger) {
                errorLogger.reportError("Study run failed, study engine unavailable");
            }
            return false;
        }
        AppTask appTask = new AppTask(1.0 / (double)AppCore.maxEngineProcessCount);
        while (!AppTask.canTaskStart(appTask)) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        ErrorLogger errorLogger2 = null;
        try {
            errorLogger2 = new ErrorLogger(new PrintStream(Files.newOutputStream(this.studyOutDirectoryPath.resolve(this.logFileName), StandardOpenOption.CREATE, StandardOpenOption.APPEND), true), null);
        }
        catch (IOException iOException) {
            if (null != errorLogger) {
                errorLogger.reportError("Study build failed, cannot create log file:\n" + iOException);
            }
            AppTask.taskDone(appTask);
            return false;
        }
        final ErrorLogger errorLogger3 = errorLogger2;
        final StatusLogger statusLogger2 = statusLogger;
        StatusLogger statusLogger3 = new StatusLogger(){

            @Override
            public void reportStatus(String string) {
                if (null != statusLogger2) {
                    statusLogger2.reportStatus(string);
                }
            }

            @Override
            public void logMessage(String string) {
                errorLogger3.reportMessage(string);
            }

            @Override
            public void showMessage(String string) {
            }

            @Override
            public boolean isCanceled() {
                return false;
            }
        };
        Study study = this.buildStudy(statusLogger3, errorLogger3);
        if (errorLogger3.hasMessages()) {
            errorLogger3.reportMessage(errorLogger3.getMessages());
            errorLogger3.clearMessages();
        }
        errorLogger3.closeStream();
        if (null == study) {
            if (null != errorLogger) {
                errorLogger.reportError("Study build failed, see log file for details");
            }
            AppTask.taskDone(appTask);
            return false;
        }
        boolean bl = false;
        String string = "";
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.update("LOCK TABLES study WRITE");
                dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + study.key);
                if (dbConnection.next()) {
                    if (dbConnection.getInt(1) == study.studyLock && dbConnection.getInt(2) == study.lockCount) {
                        dbConnection.update("UPDATE study SET study_lock = 2, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + study.key);
                        study.studyLock = 2;
                        ++study.lockCount;
                    } else {
                        bl = true;
                        string = "Could not update study lock, the lock was modified";
                    }
                } else {
                    bl = true;
                    string = "Could not update study lock, the study was deleted";
                }
            }
            catch (SQLException sQLException) {
                bl = true;
                string = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
            if (bl && null != errorLogger) {
                errorLogger.reportError(string);
            }
        } else {
            bl = true;
        }
        if (!bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(AppCore.libDirectoryPath.resolve("tvstudy").toString());
            if (AppCore.Debug) {
                arrayList.add("-d");
            }
            arrayList.add("-w");
            arrayList.add(AppCore.workingDirectoryPath.toString());
            arrayList.add("-z");
            arrayList.add(AppCore.cacheDirectoryPath.toString());
            arrayList.add("-o");
            arrayList.add(this.outPath.toString());
            arrayList.add("-s");
            arrayList.add("-i");
            arrayList.add("-g");
            arrayList.add(this.studyOutDirectoryPath.resolve(this.logFileName).toString());
            long l = this.getLogStartTime();
            if (l > 0L) {
                arrayList.add("-t");
                arrayList.add(String.valueOf(l));
            }
            arrayList.add("-h");
            arrayList.add(DbCore.getDbHostname(this.dbID));
            arrayList.add("-b");
            arrayList.add(DbCore.getDbName(this.dbID));
            arrayList.add("-u");
            arrayList.add(DbCore.getDbUsername(this.dbID));
            arrayList.add("-l");
            arrayList.add(String.valueOf(study.lockCount));
            arrayList.add("-k");
            arrayList.add("-m");
            arrayList.add(String.valueOf(AppCore.maxEngineProcessCount));
            arrayList.add("-f");
            arrayList.add(this.fileOutputConfig.getCodes());
            arrayList.add("-e");
            arrayList.add(this.mapOutputConfig.getCodes());
            arrayList.add(String.valueOf(study.key));
            this.runStatus = statusLogger;
            this.runErrors = errorLogger;
            this.runStatusTotal = this.proposalScenario.sourceData.getDesiredSourceCount();
            for (int i = 1; i < this.study.scenarioData.getRowCount(); ++i) {
                this.runStatusTotal += this.study.scenarioData.get(i).getChildScenarioCount();
            }
            this.runStatusRunning = 0;
            this.runStatusDone = 0;
            this.studyRun = new ProcessRun(arrayList, DbCore.getDbPassword(this.dbID));
            this.studyRun.setHandler(this);
            this.studyRun.setStuckTimeout(0L);
            this.studyRun.run();
            bl = this.studyRun.didFail();
            this.studyRun = null;
        }
        if (null != study) {
            Study.deleteStudy(this.dbID, study.key, study.lockCount);
        }
        AppTask.taskDone(appTask);
        this.runStatus = null;
        this.runErrors = null;
        return !bl;
    }

    @Override
    public Study buildStudy(StatusLogger statusLogger, ErrorLogger errorLogger) {
        Integer n;
        if (!this.initialized) {
            if (null != errorLogger) {
                errorLogger.reportError("Object has not been initialized");
            }
            return null;
        }
        if (null == this.studyName) {
            if (null != errorLogger) {
                errorLogger.reportError("Study name not provided");
            }
            return null;
        }
        this.setLogStartTime();
        if (null != statusLogger) {
            statusLogger.reportStatus("Building study...");
            statusLogger.logMessage(this.timestampMessage("Starting study build"));
        }
        if (null == (n = Study.createNewStudy(this.dbID, this.studyName, 2, this.templateKey, this.extDb.key, this.studyFolderKey, errorLogger))) {
            return null;
        }
        int n2 = n;
        Study study = Study.getStudy(this.dbID, n2, errorLogger);
        if (null == study) {
            return null;
        }
        boolean bl = false;
        try {
            this.study = new StudyEditData(study);
            this.study.description = this.studyDescription;
            this.rules = this.study.ixRuleData.getRules();
            if (null != this.source) {
                this.proposalSource = (SourceEditDataTV)this.source.deriveSource(this.study, true, errorLogger);
            } else {
                ExtDbRecordTV extDbRecordTV = (ExtDbRecordTV)this.record;
                this.proposalSource = SourceEditDataTV.makeSourceTV(extDbRecordTV, this.study, true, errorLogger);
            }
            if (null != this.proposalSource) {
                this.proposalSource.setAttribute("-isProposal");
                if (this.replicate || this.changeChannel) {
                    this.study.addOrReplaceSource(this.proposalSource);
                    if (this.replicate) {
                        this.proposalSource = this.proposalSource.replicate(this.studyChannel, errorLogger);
                    } else {
                        this.proposalSource = (SourceEditDataTV)this.proposalSource.deriveSource(this.study, false, errorLogger);
                        if (null != this.proposalSource) {
                            this.proposalSource.channel = this.studyChannel;
                        }
                    }
                }
            }
            if (null != errorLogger && errorLogger.hasMessages()) {
                if (null != statusLogger) {
                    statusLogger.logMessage(errorLogger.getMessages());
                }
                errorLogger.clearMessages();
            }
            if (null != this.proposalSource) {
                int n3 = this.study.getMinimumChannel();
                int n4 = this.study.getMaximumChannel();
                if (this.proposalSource.channel < n3 || this.proposalSource.channel > n4) {
                    if (null != errorLogger) {
                        errorLogger.reportError("The proposal channel must be in the range " + n3 + " to " + n4);
                    }
                } else {
                    int n5;
                    ParameterEditData parameterEditData;
                    this.study.addOrReplaceSource(this.proposalSource);
                    if (null != this.cellSize && null != (parameterEditData = this.study.getParameter(4))) {
                        for (n5 = 0; n5 < parameterEditData.parameter.valueCount; ++n5) {
                            parameterEditData.value[n5] = this.cellSize;
                        }
                    }
                    if (null != this.profilePpk && null != (parameterEditData = this.study.getParameter(32))) {
                        for (n5 = 0; n5 < parameterEditData.parameter.valueCount; ++n5) {
                            parameterEditData.value[n5] = this.profilePpk;
                        }
                    }
                    if (this.buildStudyScenarios(statusLogger, errorLogger)) {
                        if (this.buildFullStudy) {
                            this.buildReport();
                            if (this.amSearchDistanceND > 0.0 && this.amSearchDistanceDA > 0.0) {
                                ExtDb.checkForAMStations(this.extDb, this.proposalSource.location, this.proposalSource.getDTSLocations(), this.amSearchDistanceND, this.amSearchDistanceDA, this.study.getKilometersPerDegree(), this.studyReport);
                            } else {
                                this.studyReport.append("Cannot run AM station check, missing configuration values\n\n");
                            }
                        }
                        if (null != statusLogger) {
                            statusLogger.reportStatus("Saving study...");
                            statusLogger.logMessage(this.timestampMessage("Build complete, saving study"));
                        }
                        this.study.isDataChanged();
                        if (this.study.save(errorLogger, this.studyReport.toString())) {
                            if (null != statusLogger) {
                                statusLogger.logMessage(this.timestampMessage("Done"));
                            }
                            bl = true;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            AppCore.log(3, "Unexpected error", throwable);
            if (null != errorLogger) {
                errorLogger.reportError("Unexpected error:\n" + throwable);
            }
            bl = false;
        }
        if (null != this.study) {
            study = this.study.study;
            this.study.invalidate();
        }
        if (this.isCanceled()) {
            if (null != errorLogger) {
                errorLogger.reportMessage("Study build canceled");
            }
            bl = false;
        }
        if (bl) {
            return study;
        }
        Study.deleteStudy(this.dbID, study.key, study.lockCount, errorLogger);
        this.study = null;
        return null;
    }

    private void buildReport() {
        int n;
        String string;
        if (this.protectPreBaseline || this.protectBaselineFromLPTV || this.protectLPTVFromClassA) {
            this.studyReport.append("Build options:\n");
            if (this.protectPreBaseline) {
                this.studyReport.append("Protect pre-transition records not on baseline channel\n");
            }
            if (this.protectBaselineFromLPTV) {
                this.studyReport.append("Protect baseline records from LPTV\n");
            }
            if (this.protectLPTVFromClassA) {
                this.studyReport.append("Protect LPTV records from Class A\n");
            }
            this.studyReport.append('\n');
        }
        if (this.excludeApps || this.includeAmendments || this.excludePending || null != this.filingCutoffDate || this.includeForeign || this.cpExcludesBaseline || this.excludePostTransition || this.excludeNewLPTV) {
            this.studyReport.append("Search options:\n");
            if (this.includeForeign) {
                this.studyReport.append("Non-U.S. records included\n");
            }
            if (this.cpExcludesBaseline) {
                this.studyReport.append("Baseline record excluded if station has CP\n");
            }
            if (this.excludeApps) {
                this.studyReport.append("All APP records excluded\n");
            }
            if (this.includeAmendments) {
                this.studyReport.append("All AMD records included\n");
            }
            if (this.excludePending) {
                this.studyReport.append("Pending license records excluded\n");
            }
            if (this.excludePostTransition) {
                this.studyReport.append("All post-transition APP, CP, and baseline records excluded\n");
            }
            if (this.excludeNewLPTV) {
                this.studyReport.append("All records for new LPTV stations excluded\n");
            }
            if (null != this.filingCutoffDate) {
                if (this.proposalSource.service.isLPTV()) {
                    this.studyReport.append("LPTV records on or after ");
                } else {
                    this.studyReport.append("All records on or after ");
                }
                this.studyReport.append(AppCore.formatDate(this.filingCutoffDate));
                this.studyReport.append(" excluded\n");
            }
            this.studyReport.append('\n');
        }
        if (null != this.includedSources) {
            this.studyReport.append("User records included:\n");
            for (SourceEditDataTV stationRecord : this.includedSources.values()) {
                string = stationRecord.getRecordID();
                this.studyReport.append(string);
                for (n = 0; n < 8 - string.length(); ++n) {
                    this.studyReport.append(' ');
                }
                this.studyReport.append(stationRecord.getCallSign());
                this.studyReport.append(' ');
                this.studyReport.append(stationRecord.getChannel());
                this.studyReport.append(' ');
                this.studyReport.append(stationRecord.getServiceCode());
                this.studyReport.append(' ');
                this.studyReport.append(stationRecord.getStatus());
                this.studyReport.append(' ');
                this.studyReport.append(stationRecord.getCity());
                this.studyReport.append(", ");
                this.studyReport.append(stationRecord.getState());
                this.studyReport.append(' ');
                this.studyReport.append(stationRecord.getFileNumber());
                this.studyReport.append('\n');
            }
            this.studyReport.append('\n');
        }
        if (null != this.excludedRecords) {
            this.studyReport.append("Individual records excluded:\n");
            for (ExtDbRecordTV extDbRecordTV : this.excludedRecords.values()) {
                string = extDbRecordTV.getARN();
                this.studyReport.append(string);
                for (n = 0; n < 14 - string.length(); ++n) {
                    this.studyReport.append(' ');
                }
                this.studyReport.append(extDbRecordTV.getCallSign());
                this.studyReport.append(' ');
                this.studyReport.append(extDbRecordTV.getChannel());
                this.studyReport.append(' ');
                this.studyReport.append(extDbRecordTV.getServiceCode());
                this.studyReport.append(' ');
                this.studyReport.append(extDbRecordTV.getStatus());
                this.studyReport.append(' ');
                this.studyReport.append(extDbRecordTV.getCity());
                this.studyReport.append(", ");
                this.studyReport.append(extDbRecordTV.getState());
                this.studyReport.append(' ');
                this.studyReport.append(extDbRecordTV.getFileNumber());
                this.studyReport.append('\n');
            }
            this.studyReport.append('\n');
        }
        if (this.protectedList.isEmpty()) {
            this.studyReport.append("No protected stations found.\n");
        } else {
            this.studyReport.append("Stations potentially affected by proposal:\n\n");
            this.studyReport.append("IX   Call      Chan       Svc Status  City, State               File Number             Distance\n");
            boolean bl = true;
            double d = this.study.getKilometersPerDegree();
            for (Protected protected_ : this.protectedList) {
                if (protected_.receivesIX) {
                    this.studyReport.append("Yes  ");
                } else {
                    this.studyReport.append("No   ");
                }
                SourceEditDataTV sourceEditDataTV = protected_.source;
                StudyBuildIxCheck.reportSource(sourceEditDataTV, this.proposalSource.location, d, bl, this.studyReport);
                bl = false;
            }
        }
        this.studyReport.append("\n");
    }

    private static void reportSource(SourceEditDataTV sourceEditDataTV, GeoPoint geoPoint, double d, boolean bl, StringBuilder stringBuilder) {
        int n;
        String string = sourceEditDataTV.getCallSign();
        stringBuilder.append(string);
        for (n = 0; n < 10 - string.length(); ++n) {
            stringBuilder.append(' ');
        }
        string = sourceEditDataTV.getChannel();
        stringBuilder.append(string);
        for (n = 0; n < 11 - string.length(); ++n) {
            stringBuilder.append(' ');
        }
        string = sourceEditDataTV.getServiceCode();
        stringBuilder.append(string);
        for (n = 0; n < 4 - string.length(); ++n) {
            stringBuilder.append(' ');
        }
        string = sourceEditDataTV.getStatus();
        stringBuilder.append(string);
        for (n = 0; n < 8 - string.length(); ++n) {
            stringBuilder.append(' ');
        }
        string = sourceEditDataTV.getCity() + ", " + sourceEditDataTV.getState();
        stringBuilder.append(string);
        for (n = 0; n < 26 - string.length(); ++n) {
            stringBuilder.append(' ');
        }
        string = sourceEditDataTV.getFileNumber();
        stringBuilder.append(string);
        for (n = 0; n < 24 - string.length(); ++n) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(String.format(Locale.US, "%5.1f", sourceEditDataTV.location.distanceTo(geoPoint, d)));
        if (bl) {
            stringBuilder.append(" km");
        }
        stringBuilder.append('\n');
    }

    private boolean buildStudyScenarios(StatusLogger statusLogger, ErrorLogger errorLogger) {
        Object object4;
        Serializable serializable;
        double d = this.study.getKilometersPerDegree();
        boolean bl = this.study.getCheckIndividualDTSDistance();
        int n = this.study.getMinimumChannel();
        int n2 = this.study.getMaximumChannel();
        if (this.didSetBefore) {
            if (null != this.beforeSource) {
                this.proposalBeforeSource = (SourceEditDataTV)this.beforeSource.deriveSource(this.study, true, errorLogger);
                if (null == this.proposalBeforeSource) {
                    return false;
                }
                this.study.addOrReplaceSource(this.proposalBeforeSource);
            } else if (null != this.beforeRecord) {
                this.proposalBeforeSource = this.getOrMakeSource(this.beforeRecord, errorLogger);
                if (null == this.proposalBeforeSource) {
                    return false;
                }
            }
        }
        ArrayList<SourceEditDataTV> arrayList = null;
        if (this.buildFullStudy) {
            if (null != this.baselineDate) {
                this.baselineIndex = ExtDbRecordTV.getBaselineIndex(this.extDb, errorLogger);
                if (null == this.baselineIndex) {
                    return false;
                }
                if (this.isCanceled()) {
                    return false;
                }
            }
            if (null != this.includeUserRecords) {
                serializable = new StringBuilder("user_record_id IN (");
                object4 = "";
                for (Integer iterator : this.includeUserRecords) {
                    ((StringBuilder)serializable).append((String)object4);
                    ((StringBuilder)serializable).append(String.valueOf(iterator));
                    object4 = ",";
                }
                ((StringBuilder)serializable).append(')');
                this.userRecordSources = SourceEditData.findUserRecords(this.dbID, 1, ((StringBuilder)serializable).toString(), errorLogger);
                if (null == this.userRecordSources) {
                    return false;
                }
                if (this.userRecordSources.isEmpty()) {
                    this.userRecordSources = null;
                }
                if (this.isCanceled()) {
                    return false;
                }
            }
            if (null != statusLogger) {
                statusLogger.reportStatus("Searching for protected stations...");
                statusLogger.logMessage(this.timestampMessage("Searching for protected stations"));
            }
            if (null == (arrayList = this.makeDesiredList(d, bl, n, n2, errorLogger))) {
                return false;
            }
            if (this.isCanceled()) {
                return false;
            }
            if (null != errorLogger && errorLogger.hasMessages()) {
                if (null != statusLogger) {
                    statusLogger.logMessage(errorLogger.getMessages());
                }
                errorLogger.clearMessages();
            }
        }
        serializable = new ArrayList<Scenario.SourceListItem>();
        ((ArrayList)serializable).add(new Scenario.SourceListItem(this.proposalSource.key, true, false, true));
        if (null != this.proposalBeforeSource) {
            ((ArrayList)serializable).add(new Scenario.SourceListItem(this.proposalBeforeSource.key, true, false, true));
        }
        this.proposalScenario = new ScenarioEditData(this.study, "Proposal_NoIX", "Proposal record only, no undesireds", 2, true, (ArrayList<Scenario.SourceListItem>)serializable);
        this.study.scenarioData.addOrReplace(this.proposalScenario);
        if (!this.buildFullStudy) {
            return true;
        }
        object4 = new HashSet();
        if (!arrayList.isEmpty()) {
            if (null != statusLogger) {
                statusLogger.logMessage(this.timestampMessage("Found " + String.valueOf(arrayList.size()) + " records"));
                statusLogger.logMessage(this.timestampMessage("Checking proposal interference"));
            }
            serializable = new ArrayList();
            for (SourceEditDataTV sourceEditDataTV : arrayList) {
                ((ArrayList)serializable).add(new Scenario.SourceListItem(sourceEditDataTV.key, true, false, false));
            }
            ((ArrayList)serializable).add(new Scenario.SourceListItem(this.proposalSource.key, false, true, false));
            if (null != this.proposalBeforeSource) {
                ((ArrayList)serializable).add(new Scenario.SourceListItem(this.proposalBeforeSource.key, false, true, false));
            }
            this.study.scenarioData.addOrReplace(new ScenarioEditData(this.study, "probe", "", false, (ArrayList<Scenario.SourceListItem>)serializable));
            int n3 = this.study.scenarioData.getLastRowChanged();
            this.probeRunDescription = "Checking proposal interference";
            this.runStatusTotal = arrayList.size();
            if (!this.doProbeRun(statusLogger, errorLogger)) {
                return false;
            }
            this.study.scenarioData.remove(n3);
            if (!this.proposalSource.isLocked) {
                this.study.addOrReplaceSource(this.proposalSource);
            }
            if (this.proposalBeforeSource != null && !this.proposalBeforeSource.isLocked) {
                this.study.addOrReplaceSource(this.proposalBeforeSource);
            }
            for (IXProbeResult iXProbeResult : this.probeRunResult) {
                if (!iXProbeResult.causesIX) continue;
                ((HashSet)object4).add(iXProbeResult.desiredSourceKey);
            }
            if (null != statusLogger) {
                statusLogger.logMessage(this.timestampMessage(String.valueOf(((HashSet)object4).size()) + " records with interference from proposal"));
            }
        } else if (null != statusLogger) {
            statusLogger.logMessage(this.timestampMessage("No protected station records found"));
        }
        if (null != statusLogger) {
            statusLogger.reportStatus("Searching for undesireds...");
        }
        this.protectedList = new ArrayList();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        int n3 = 0;
        for (SourceEditDataTV sourceEditDataTV : arrayList) {
            Protected protected_ = new Protected();
            protected_.source = sourceEditDataTV;
            this.protectedList.add(protected_);
            if (!((HashSet)object4).contains(sourceEditDataTV.key)) continue;
            protected_.receivesIX = true;
            if (null != statusLogger) {
                statusLogger.logMessage(this.timestampMessage("Searching for undesireds to " + sourceEditDataTV.getCallSign() + " " + sourceEditDataTV.getChannel() + " " + sourceEditDataTV.getStatus()));
            }
            if (!this.makeUndesiredList(protected_, false, d, bl, n, n2, errorLogger)) {
                return false;
            }
            if (this.isCanceled()) {
                return false;
            }
            if (null != errorLogger && errorLogger.hasMessages()) {
                if (null != statusLogger) {
                    statusLogger.logMessage(errorLogger.getMessages());
                }
                errorLogger.clearMessages();
            }
            serializable = new ArrayList();
            ((ArrayList)serializable).add(new Scenario.SourceListItem(sourceEditDataTV.key, true, false, true));
            protected_.undesiredMap = new HashMap();
            if (!protected_.undesiredList.isEmpty()) {
                hashMap.put(sourceEditDataTV.key, protected_);
                for (Object object : protected_.undesiredList) {
                    protected_.undesiredMap.put(((Undesired)object).source.key, object);
                    ((ArrayList)serializable).add(new Scenario.SourceListItem(((Undesired)object).source.key, false, true, false));
                }
            }
            String string = (sourceEditDataTV.fileNumber.length() > 0 ? (sourceEditDataTV.fileNumber.length() > 22 ? sourceEditDataTV.fileNumber.substring(0, 22) : sourceEditDataTV.fileNumber) : (sourceEditDataTV.callSign.length() > 0 ? sourceEditDataTV.callSign : "UNKNOWN")) + "_" + sourceEditDataTV.status;
            String string2 = "Potential undesireds to " + sourceEditDataTV.toString();
            protected_.buildScenario = new ScenarioEditData(this.study, string, string2, false, (ArrayList<Scenario.SourceListItem>)serializable);
            this.study.scenarioData.addOrReplace(protected_.buildScenario);
            ++n3;
        }
        if (null != statusLogger) {
            statusLogger.logMessage(this.timestampMessage("Searching for undesireds to proposal"));
        }
        Protected protected_ = new Protected();
        protected_.source = this.proposalSource;
        if (!this.makeUndesiredList(protected_, true, d, bl, n, n2, errorLogger)) {
            return false;
        }
        if (this.isCanceled()) {
            return false;
        }
        if (null != errorLogger && errorLogger.hasMessages()) {
            if (null != statusLogger) {
                statusLogger.logMessage(errorLogger.getMessages());
            }
            errorLogger.clearMessages();
        }
        serializable = new ArrayList();
        ((ArrayList)serializable).add(new Scenario.SourceListItem(this.proposalSource.key, true, false, true));
        protected_.undesiredMap = new HashMap();
        if (!protected_.undesiredList.isEmpty()) {
            hashMap.put(this.proposalSource.key, protected_);
            for (Undesired undesired : protected_.undesiredList) {
                protected_.undesiredMap.put(((Undesired)undesired).source.key, undesired);
                ((ArrayList)serializable).add(new Scenario.SourceListItem(((Undesired)undesired).source.key, false, true, false));
            }
        }
        protected_.buildScenario = new ScenarioEditData(this.study, "Proposal coverage", "Proposal coverage", false, (ArrayList<Scenario.SourceListItem>)serializable);
        this.study.scenarioData.addOrReplace(protected_.buildScenario);
        ++n3;
        if (!hashMap.isEmpty()) {
            if (null != statusLogger) {
                statusLogger.logMessage(this.timestampMessage("Checking undesired interference"));
            }
            this.probeRunDescription = "Checking undesired interference";
            this.runStatusTotal = n3;
            if (!this.doProbeRun(statusLogger, errorLogger)) {
                return false;
            }
            for (IXProbeResult iXProbeResult : this.probeRunResult) {
                Undesired undesired;
                Protected protected_2;
                if (!iXProbeResult.causesIX || null == (protected_2 = (Protected)hashMap.get(iXProbeResult.desiredSourceKey)) || null == (undesired = (Undesired)protected_2.undesiredMap.get(iXProbeResult.undesiredSourceKey))) continue;
                undesired.causesIX = true;
            }
            for (Protected protected_3 : hashMap.values()) {
                Object object;
                object = ((Protected)protected_3).buildScenario.sourceData;
                for (int i = 0; i < ((SourceListData)object).getRowCount(); ++i) {
                    Undesired undesired = (Undesired)protected_3.undesiredMap.get(((SourceListData)object).get((int)i).key);
                    if (null == undesired || undesired.causesIX) continue;
                    ((SourceListData)object).setIsUndesired(i, false);
                }
            }
        }
        if (null != statusLogger) {
            statusLogger.reportStatus("Building interference scenarios...");
        }
        this.builder = new ScenarioBuilder();
        this.builder.study = this.study;
        this.builder.proposalSource = this.proposalSource;
        for (Protected protected_4 : this.protectedList) {
            if (!protected_4.receivesIX) continue;
            if (null != statusLogger) {
                statusLogger.logMessage(this.timestampMessage("Building IX scenarios for " + protected_4.source.getCallSign() + " " + protected_4.source.getChannel() + " " + protected_4.source.getStatus()));
            }
            this.builder.proposalBeforeSource = this.proposalBeforeSource;
            if (null != this.proposalBeforeSource && null != protected_4.source.getAttribute("-isPreBaseline") && null != this.proposalBeforeSource.getAttribute("isBaseline")) {
                this.builder.proposalBeforeSource = null;
            }
            this.builder.desiredSource = protected_4.source;
            this.builder.undesiredList = protected_4.undesiredList;
            this.builder.buildScenario = protected_4.buildScenario;
            if (this.builder.makeScenarios(null, statusLogger, errorLogger)) continue;
            return false;
        }
        if (null != statusLogger) {
            statusLogger.logMessage(this.timestampMessage("Building MX scenarios"));
        }
        this.builder.proposalBeforeSource = null;
        this.builder.desiredSource = this.proposalSource;
        this.builder.undesiredList = protected_.undesiredList;
        this.builder.buildScenario = protected_.buildScenario;
        return this.builder.makeScenarios(this.proposalScenario, statusLogger, errorLogger);
    }

    private ArrayList<SourceEditDataTV> makeDesiredList(double d, boolean bl, int n, int n2, ErrorLogger errorLogger) {
        SourceEditDataTV sourceEditDataTV;
        boolean bl2;
        ArrayList<ExtDbRecordTV> arrayList = this.doChannelSearch(this.proposalSource.channel, false, n, n2, errorLogger);
        if (null == arrayList) {
            return null;
        }
        boolean bl3 = this.proposalSource.service.isLPTV();
        boolean bl4 = 0 == this.proposalSource.statusType || 5 == this.proposalSource.statusType;
        boolean bl5 = this.proposalSource.service.isClassA();
        ArrayList<SourceEditDataTV> arrayList2 = new ArrayList<SourceEditDataTV>();
        for (ExtDbRecordTV object : arrayList) {
            Integer n3;
            Integer n4;
            bl2 = object.service.isLPTV();
            if (!this.didSetBefore && bl3 && this.proposalSource.service.isDigital() && bl2 && !object.service.isDigital() && 2 == object.statusType && object.facilityID == this.proposalSource.facilityID && object.channel == this.proposalSource.channel) {
                this.proposalBeforeSource = this.getOrMakeSource(object, errorLogger);
                if (null != this.proposalBeforeSource) continue;
                return null;
            }
            if (bl2 && !bl3 && !bl4 && (!bl5 || !this.protectLPTVFromClassA) || !bl2 && null != this.baselineDate && !this.protectPreBaseline && (1 == object.country.key || 2 == object.country.key && this.baselineIndex.hasCA || 3 == object.country.key && this.baselineIndex.hasMX) && (null == (n4 = this.baselineIndex.index.get(object.facilityID)) || object.channel != n4) && (object.sequenceDate.before(this.baselineDate) || object.isSharingHost && null != (n3 = this.baselineIndex.preIndex.get(object.facilityID)) && n3 == object.channel) || object.extRecordID.equals(this.proposalSource.extRecordID) || ExtDbRecordTV.areRecordsMX(object, this.proposalSource, true, 0.0, 0.0) || !this.doRecordsMatchRules(object, this.proposalSource, d, bl)) continue;
            sourceEditDataTV = this.getOrMakeSource(object, errorLogger);
            if (null == sourceEditDataTV) {
                return null;
            }
            arrayList2.add(sourceEditDataTV);
        }
        if (null != this.userRecordSources) {
            for (SourceEditData sourceEditData : this.userRecordSources) {
                sourceEditDataTV = (SourceEditDataTV)sourceEditData;
                bl2 = sourceEditDataTV.service.isLPTV();
                if (!bl2 && (2 == sourceEditDataTV.statusType || this.cpExcludesBaseline && 1 == sourceEditDataTV.statusType)) {
                    this.baselineExcludedIndex.add(sourceEditDataTV.facilityID * 100 + sourceEditDataTV.channel);
                }
                if (bl2 && !bl3 && !bl4 && (!bl5 || !this.protectLPTVFromClassA) || sourceEditDataTV.userRecordID.equals(this.proposalSource.userRecordID) || ExtDbRecordTV.areRecordsMX(sourceEditDataTV, this.proposalSource, true, 0.0, 0.0) || !this.doRecordsMatchRules(sourceEditDataTV, this.proposalSource, d, bl)) continue;
                if (null == this.includedSources) {
                    this.includedSources = new TreeMap();
                }
                if (null == (sourceEditDataTV = (SourceEditDataTV)this.study.findSharedSource(sourceEditDataTV.userRecordID))) {
                    sourceEditDataTV = (SourceEditDataTV)sourceEditData.deriveSource(this.study, true, errorLogger);
                    if (null == sourceEditDataTV) {
                        return null;
                    }
                    this.study.addOrReplaceSource(sourceEditDataTV);
                    this.includedSources.put(sourceEditDataTV.userRecordID, sourceEditDataTV);
                }
                arrayList2.add(sourceEditDataTV);
            }
        }
        if ((!bl3 || bl4 || this.protectBaselineFromLPTV) && !this.excludePostTransition) {
            arrayList = this.doBaselineSearch(this.proposalSource.channel, false, n, n2, errorLogger);
            if (null == arrayList) {
                return null;
            }
            for (ExtDbRecordTV extDbRecordTV : arrayList) {
                int n5 = extDbRecordTV.replicateToChannel > 0 ? extDbRecordTV.replicateToChannel : extDbRecordTV.channel;
                if (extDbRecordTV.facilityID == this.proposalSource.facilityID && !this.proposalSource.isDRT) {
                    if (this.didSetBefore || bl3 || n5 != this.proposalSource.channel || extDbRecordTV.extRecordID.equals(this.proposalSource.extRecordID)) continue;
                    this.proposalBeforeSource = this.getOrMakeSource(extDbRecordTV, errorLogger);
                    if (null != this.proposalBeforeSource) continue;
                    return null;
                }
                if (this.baselineExcludedIndex.contains(extDbRecordTV.facilityID * 100 + n5) || !this.doRecordsMatchRules(extDbRecordTV, this.proposalSource, d, bl)) continue;
                sourceEditDataTV = this.getOrMakeSource(extDbRecordTV, errorLogger);
                if (null == sourceEditDataTV) {
                    return null;
                }
                arrayList2.add(sourceEditDataTV);
            }
        }
        Comparator<SourceEditDataTV> comparator = new Comparator<SourceEditDataTV>(){

            @Override
            public int compare(SourceEditDataTV sourceEditDataTV, SourceEditDataTV sourceEditDataTV2) {
                int n = 0;
                if (sourceEditDataTV.country.key < sourceEditDataTV2.country.key) {
                    n = -1;
                } else if (sourceEditDataTV.country.key > sourceEditDataTV2.country.key) {
                    n = 1;
                } else if (sourceEditDataTV.channel < sourceEditDataTV2.channel) {
                    n = -1;
                } else if (sourceEditDataTV.channel > sourceEditDataTV2.channel) {
                    n = 1;
                } else {
                    n = sourceEditDataTV.state.compareToIgnoreCase(sourceEditDataTV2.state);
                    if (0 == n) {
                        n = sourceEditDataTV.city.compareToIgnoreCase(sourceEditDataTV2.city);
                    }
                }
                return n;
            }
        };
        Collections.sort(arrayList2, comparator);
        return arrayList2;
    }

    private boolean makeUndesiredList(Protected protected_, boolean bl, double d, boolean bl2, int n, int n2, ErrorLogger errorLogger) {
        Undesired undesired;
        boolean bl3;
        Integer n3;
        Cloneable cloneable;
        Integer n4;
        SourceEditDataTV sourceEditDataTV = protected_.source;
        ArrayList<ExtDbRecordTV> arrayList = this.doChannelSearch(sourceEditDataTV.channel, true, n, n2, errorLogger);
        if (null == arrayList) {
            return false;
        }
        boolean bl4 = sourceEditDataTV.service.isLPTV();
        boolean bl5 = sourceEditDataTV.service.isClassA();
        boolean bl6 = false;
        if (!(bl4 || null == this.baselineDate || null != (n4 = this.baselineIndex.index.get(sourceEditDataTV.facilityID)) && sourceEditDataTV.channel == n4)) {
            cloneable = AppCore.parseDate(sourceEditDataTV.getAttribute("sequenceDate"));
            if (null != cloneable && ((Date)cloneable).before(this.baselineDate)) {
                bl6 = true;
                sourceEditDataTV.setAttribute("-isPreBaseline");
            } else if (null != sourceEditDataTV.getAttribute("isSharingHost") && null != (n3 = this.baselineIndex.preIndex.get(sourceEditDataTV.facilityID)) && n3 == sourceEditDataTV.channel) {
                bl6 = true;
                sourceEditDataTV.setAttribute("-isPreBaseline");
            }
        }
        cloneable = new ArrayList();
        for (ExtDbRecordTV iterator : arrayList) {
            bl3 = iterator.service.isLPTV();
            if (bl3 && (!bl5 ? !bl4 : !bl)) continue;
            if (!bl3 && !bl6 && null != this.baselineDate && (null == (n4 = this.baselineIndex.index.get(iterator.facilityID)) || iterator.channel != n4) && (iterator.sequenceDate.before(this.baselineDate) || iterator.isSharingHost && null != (n3 = this.baselineIndex.preIndex.get(iterator.facilityID)) && n3 == iterator.channel) || !this.excludePostTransition && bl6 && !bl3 && 2 != iterator.statusType && null != this.baselineDate && !iterator.sequenceDate.before(this.baselineDate) && null != (n4 = this.baselineIndex.index.get(iterator.facilityID)) && n4 == iterator.channel && (null == (n3 = this.baselineIndex.preIndex.get(iterator.facilityID)) || n3 != iterator.channel) || iterator.extRecordID.equals(sourceEditDataTV.extRecordID) || iterator.extRecordID.equals(this.proposalSource.extRecordID) || ExtDbRecordTV.areRecordsMX(iterator, sourceEditDataTV, true, 0.0, 0.0) || ExtDbRecordTV.areRecordsMX(iterator, this.proposalSource, true, 0.0, 0.0) || !this.doRecordsMatchRules(sourceEditDataTV, iterator, d, bl2)) continue;
            undesired = new Undesired();
            undesired.source = this.getOrMakeSource(iterator, errorLogger);
            if (null == undesired.source) {
                return false;
            }
            ((ArrayList)cloneable).add(undesired);
        }
        if (null != this.userRecordSources) {
            for (SourceEditData sourceEditData : this.userRecordSources) {
                Date date;
                Object object = (SourceEditDataTV)sourceEditData;
                bl3 = ((SourceEditDataTV)object).service.isLPTV();
                if (bl3 && (!bl5 ? !bl4 : !bl)) continue;
                if (!bl3 && !bl6 && null != this.baselineDate && (null == (n4 = this.baselineIndex.index.get(((SourceEditDataTV)object).facilityID)) || ((SourceEditDataTV)object).channel != n4) && (null != (date = AppCore.parseDate(((SourceEditData)object).getAttribute("sequenceDate"))) && date.before(this.baselineDate) || null != ((SourceEditData)object).getAttribute("isSharingHost") && null != (n3 = this.baselineIndex.preIndex.get(((SourceEditDataTV)object).facilityID)) && n3 == ((SourceEditDataTV)object).channel) || ((SourceEditDataTV)object).userRecordID.equals(sourceEditDataTV.userRecordID) || ((SourceEditDataTV)object).userRecordID.equals(this.proposalSource.userRecordID) || ExtDbRecordTV.areRecordsMX((SourceEditDataTV)object, sourceEditDataTV, true, 0.0, 0.0) || ExtDbRecordTV.areRecordsMX((SourceEditDataTV)object, this.proposalSource, true, 0.0, 0.0) || !this.doRecordsMatchRules(sourceEditDataTV, (SourceEditDataTV)object, d, bl2)) continue;
                if (null == this.includedSources) {
                    this.includedSources = new TreeMap();
                }
                if (null == (object = (SourceEditDataTV)this.study.findSharedSource(((SourceEditDataTV)object).userRecordID))) {
                    object = (SourceEditDataTV)sourceEditData.deriveSource(this.study, true, errorLogger);
                    if (null == object) {
                        return false;
                    }
                    this.study.addOrReplaceSource((SourceEditData)object);
                    this.includedSources.put(((SourceEditDataTV)object).userRecordID, (SourceEditDataTV)object);
                }
                undesired = new Undesired();
                undesired.source = (SourceEditDataTV)object;
                ((ArrayList)cloneable).add(undesired);
            }
        }
        if (!(bl4 || bl6 || this.excludePostTransition)) {
            arrayList = this.doBaselineSearch(sourceEditDataTV.channel, true, n, n2, errorLogger);
            if (null == arrayList) {
                return false;
            }
            for (ExtDbRecordTV extDbRecordTV : arrayList) {
                int n5 = extDbRecordTV.replicateToChannel > 0 ? extDbRecordTV.replicateToChannel : extDbRecordTV.channel;
                if (this.baselineExcludedIndex.contains(extDbRecordTV.facilityID * 100 + n5) || extDbRecordTV.facilityID == sourceEditDataTV.facilityID || extDbRecordTV.facilityID == this.proposalSource.facilityID || !this.doRecordsMatchRules(sourceEditDataTV, extDbRecordTV, d, bl2)) continue;
                undesired = new Undesired();
                undesired.source = this.getOrMakeSource(extDbRecordTV, errorLogger);
                if (null == undesired.source) {
                    return false;
                }
                ((ArrayList)cloneable).add(undesired);
            }
        }
        protected_.undesiredList = cloneable;
        return true;
    }

    private boolean doProbeRun(StatusLogger statusLogger, ErrorLogger errorLogger) {
        this.probeRunResult = null;
        this.study.isDataChanged();
        if (!this.study.save(errorLogger)) {
            return false;
        }
        if (this.isCanceled()) {
            return false;
        }
        Study study = this.study.study;
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        String string = null;
        try {
            dbConnection.update("LOCK TABLES study WRITE");
            dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + study.key);
            if (dbConnection.next()) {
                if (dbConnection.getInt(1) == study.studyLock && dbConnection.getInt(2) == study.lockCount) {
                    dbConnection.update("UPDATE study SET study_lock = 2, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + study.key);
                    study.studyLock = 2;
                    ++study.lockCount;
                } else {
                    string = "Could not update study lock, the lock was modified";
                }
            } else {
                string = "Could not update study lock, the study was deleted";
            }
        }
        catch (SQLException sQLException) {
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string) {
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(AppCore.libDirectoryPath.resolve("tvstudy").toString());
        arrayList.add("-w");
        arrayList.add(AppCore.workingDirectoryPath.toString());
        arrayList.add("-z");
        arrayList.add(AppCore.cacheDirectoryPath.toString());
        arrayList.add("-o");
        arrayList.add(this.outPath.toString());
        arrayList.add("-i");
        long l = this.getLogStartTime();
        if (l > 0L) {
            arrayList.add("-t");
            arrayList.add(String.valueOf(l));
        }
        arrayList.add("-h");
        arrayList.add(DbCore.getDbHostname(this.dbID));
        arrayList.add("-b");
        arrayList.add(DbCore.getDbName(this.dbID));
        arrayList.add("-u");
        arrayList.add(DbCore.getDbUsername(this.dbID));
        arrayList.add("-l");
        arrayList.add(String.valueOf(study.lockCount));
        arrayList.add("-k");
        arrayList.add("-p");
        arrayList.add(String.valueOf(study.key));
        this.runStatus = statusLogger;
        this.runErrors = errorLogger;
        this.runStatusRunning = 0;
        this.runStatusDone = 0;
        this.probeRunResult = new ArrayList();
        this.probeRun = new ProcessRun(arrayList, DbCore.getDbPassword(this.dbID));
        this.probeRun.setHandler(this);
        this.probeRun.run();
        boolean bl = this.probeRun.didFail();
        this.probeRun = null;
        this.runStatus = null;
        this.runErrors = null;
        if (bl || this.isCanceled()) {
            return false;
        }
        dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        try {
            dbConnection.update("LOCK TABLES study WRITE");
            dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + study.key);
            if (dbConnection.next()) {
                if (dbConnection.getInt(1) == study.studyLock && dbConnection.getInt(2) == study.lockCount) {
                    dbConnection.update("UPDATE study SET study_lock = 1, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + study.key);
                    study.studyLock = 1;
                    ++study.lockCount;
                } else {
                    string = "Could not update study lock, the lock was modified";
                }
            } else {
                string = "Could not update study lock, the study was deleted";
            }
        }
        catch (SQLException sQLException) {
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string) {
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return false;
        }
        return true;
    }

    @Override
    public void processOutput(ProcessRun processRun, String string, boolean bl) {
        if (processRun == this.studyRun) {
            if (null != this.runErrors) {
                this.runErrors.reportError(string);
            }
            return;
        }
        if (processRun == this.probeRun) {
            if (null != this.runStatus) {
                if (bl) {
                    this.runStatus.showMessage(string);
                } else {
                    this.runStatus.logMessage(string);
                }
            }
            return;
        }
    }

    @Override
    public void processMessage(ProcessRun processRun, String string, String string2) {
        if (string.equals("runcount")) {
            if (this.runStatusRunning > 0) {
                this.runStatusDone += this.runStatusRunning;
            }
            this.runStatusRunning = 0;
            try {
                this.runStatusRunning = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (processRun == this.studyRun) {
            if (string.equals("runcount")) {
                long l;
                if (null != this.runStatus && (l = System.currentTimeMillis()) - this.lastRunStatusUpdate > 2950L) {
                    this.runStatus.reportStatus("Study running, " + this.runStatusDone + " of " + this.runStatusTotal + " items done");
                    this.lastRunStatusUpdate = l;
                }
                return;
            }
            if (string.equals("outfile")) {
                this.outputFiles.add(string2);
                return;
            }
            if (string.equals("report")) {
                this.studyReport.append(string2);
                this.studyReport.append('\n');
                return;
            }
            return;
        }
        if (processRun == this.probeRun) {
            if (string.equals("result")) {
                String[] stringArray = string2.split(",");
                if (stringArray.length >= 3) {
                    IXProbeResult iXProbeResult = new IXProbeResult();
                    try {
                        iXProbeResult.desiredSourceKey = Integer.valueOf(stringArray[0]);
                        iXProbeResult.undesiredSourceKey = Integer.valueOf(stringArray[1]);
                        iXProbeResult.causesIX = Integer.parseInt(stringArray[2]) != 0;
                        this.probeRunResult.add(iXProbeResult);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return;
            }
            if (null == this.runStatus) {
                return;
            }
            if (string.equals("runcount")) {
                if (this.runStatusDone < this.runStatusTotal) {
                    this.runStatus.reportStatus(this.probeRunDescription + ", " + this.runStatusDone + " of " + this.runStatusTotal + " items done");
                } else if (this.runStatusRunning < 0) {
                    this.runStatus.reportStatus(this.probeRunDescription + ", running");
                } else {
                    this.runStatus.reportStatus(this.probeRunDescription + ", run complete");
                }
                return;
            }
            if (string.equals("progress")) {
                this.runStatus.showMessage(string2);
                return;
            }
            return;
        }
    }

    @Override
    public String getProcessResponse(ProcessRun processRun, String string) {
        return null;
    }

    @Override
    public void processResponseConfirmed(ProcessRun processRun) {
    }

    @Override
    public void processFailed(ProcessRun processRun) {
    }

    @Override
    public void processComplete(ProcessRun processRun) {
    }

    private SourceEditDataTV getOrMakeSource(ExtDbRecordTV extDbRecordTV, ErrorLogger errorLogger) {
        SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)this.study.findSharedSource(this.extDb.key, extDbRecordTV.extRecordID);
        if (null == sourceEditDataTV) {
            sourceEditDataTV = SourceEditDataTV.makeSourceTV(extDbRecordTV, this.study, true, errorLogger);
            if (null == sourceEditDataTV) {
                return null;
            }
            this.study.addOrReplaceSource(sourceEditDataTV);
        }
        if (extDbRecordTV.replicateToChannel > 0) {
            SourceEditDataTV sourceEditDataTV2 = sourceEditDataTV;
            sourceEditDataTV = this.study.findSharedReplicationSource(sourceEditDataTV2.extDbKey, sourceEditDataTV2.extRecordID, extDbRecordTV.replicateToChannel);
            if (null == sourceEditDataTV) {
                sourceEditDataTV = sourceEditDataTV2.replicate(extDbRecordTV.replicateToChannel, errorLogger);
                if (null == sourceEditDataTV) {
                    return null;
                }
                this.study.addOrReplaceSource(sourceEditDataTV);
            }
        }
        return sourceEditDataTV;
    }

    private ArrayList<ExtDbRecordTV> doChannelSearch(int n, boolean bl, int n2, int n3, ErrorLogger errorLogger) {
        int n4;
        int n5;
        Integer n6 = n * 10 + (bl ? 1 : 0);
        ArrayList<ExtDbRecordTV> arrayList = this.searchCache.get(n6);
        if (null != arrayList) {
            return arrayList;
        }
        int n7 = n3 - n2 + 1;
        boolean[] blArray = new boolean[n7];
        boolean[] blArray2 = new boolean[n7];
        for (IxRule ixRule : this.rules) {
            n5 = bl ? n + ixRule.channelDelta.delta : n - ixRule.channelDelta.delta;
            if (n5 < n2 || n5 > n3) continue;
            if (n < 5) {
                if (n5 > 4) {
                    continue;
                }
            } else if (n < 7) {
                if (n5 < 5 || n5 > 6) {
                    continue;
                }
            } else if (n >= 14 ? n5 < 14 : n5 < 7 || n5 > 13) continue;
            if (!ixRule.channelDelta.analogOnly) {
                blArray[n5 - n2] = true;
            }
            blArray2[n5 - n2] = true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            CharSequence charSequence;
            boolean bl2 = ExtDbRecordTV.addRecordTypeQueryTV(this.extDb.type, this.extDb.version, false, stringBuilder, false);
            if (!this.includeForeign) {
                if (bl2) {
                    stringBuilder.append(" AND ");
                }
                stringBuilder.append('(');
                ExtDbRecord.addCountryQuery(this.extDb.type, this.extDb.version, 1, 1, stringBuilder, false);
                stringBuilder.append(" OR ");
                ExtDbRecordTV.addFacilityIDQueryTV(this.extDb.type, this.extDb.version, this.proposalSource.facilityID, stringBuilder, false);
                stringBuilder.append(')');
                bl2 = true;
            }
            if (this.excludeNewLPTV) {
                if (bl2) {
                    stringBuilder.append(" AND ");
                }
                stringBuilder.append("((NOT (");
                charSequence = "";
                for (Service service : Service.getAllServices()) {
                    if (!service.isLPTV()) continue;
                    stringBuilder.append((String)charSequence);
                    ExtDbRecordTV.addServiceQueryTV(this.extDb.type, this.extDb.version, service.key, stringBuilder, false);
                    charSequence = " OR ";
                }
                stringBuilder.append(")) OR (facility.facility_status <> 'CPAPP'))");
                bl2 = true;
            }
            if (bl2) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("((");
            ExtDbRecordTV.addServiceTypeQueryTV(this.extDb.type, this.extDb.version, 1, 1, stringBuilder, false);
            charSequence = new StringBuilder();
            n4 = 40;
            for (n5 = 0; n5 < n7; ++n5) {
                if (!blArray[n5]) continue;
                ((StringBuilder)charSequence).append((char)n4);
                ((StringBuilder)charSequence).append(String.valueOf(n5 + n2));
                n4 = 44;
            }
            ((StringBuilder)charSequence).append(')');
            ExtDbRecordTV.addMultipleChannelQueryTV(this.extDb.type, this.extDb.version, ((StringBuilder)charSequence).toString(), stringBuilder, true);
            stringBuilder.append(") OR (");
            ExtDbRecordTV.addServiceTypeQueryTV(this.extDb.type, this.extDb.version, 1, 2, stringBuilder, false);
            ((StringBuilder)charSequence).setLength(0);
            n4 = 40;
            for (n5 = 0; n5 < n7; ++n5) {
                if (!blArray2[n5]) continue;
                ((StringBuilder)charSequence).append((char)n4);
                ((StringBuilder)charSequence).append(String.valueOf(n5 + n2));
                n4 = 44;
            }
            ((StringBuilder)charSequence).append(')');
            ExtDbRecordTV.addMultipleChannelQueryTV(this.extDb.type, this.extDb.version, ((StringBuilder)charSequence).toString(), stringBuilder, true);
            stringBuilder.append("))");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorLogger.reportError(illegalArgumentException.toString());
            return null;
        }
        LinkedList<ExtDbRecordTV> linkedList = ExtDbRecordTV.findRecordsTV(this.extDb, stringBuilder.toString(), errorLogger);
        if (null == linkedList) {
            return null;
        }
        arrayList = new ArrayList();
        boolean bl3 = this.proposalSource.service.isLPTV();
        for (ExtDbRecordTV extDbRecordTV : linkedList) {
            if (this.isExcluded(extDbRecordTV)) continue;
            n4 = extDbRecordTV.service.isLPTV() ? 1 : 0;
            if (null != this.filingCutoffDate && (!bl3 || n4 != 0) && !extDbRecordTV.sequenceDate.before(this.filingCutoffDate)) continue;
            if (n4 == 0 && (2 == extDbRecordTV.statusType || this.cpExcludesBaseline && 1 == extDbRecordTV.statusType)) {
                this.baselineExcludedIndex.add(extDbRecordTV.facilityID * 100 + extDbRecordTV.channel);
            }
            arrayList.add(extDbRecordTV);
        }
        this.searchCache.put(n6, arrayList);
        return arrayList;
    }

    private ArrayList<ExtDbRecordTV> doBaselineSearch(int n, boolean bl, int n2, int n3, ErrorLogger errorLogger) {
        int n4;
        Integer n5 = n * 10 + (bl ? 1 : 0);
        ArrayList<ExtDbRecordTV> arrayList = this.baselineCache.get(n5);
        if (null != arrayList) {
            return arrayList;
        }
        int n6 = n3 - n2 + 1;
        boolean[] blArray = new boolean[n6];
        for (IxRule linkedList2 : this.rules) {
            if (linkedList2.channelDelta.analogOnly || (n4 = bl ? n + linkedList2.channelDelta.delta : n - linkedList2.channelDelta.delta) < n2 || n4 > n3 || (n < 5 ? n4 > 4 : (n < 7 ? n4 < 5 || n4 > 6 : (n < 14 ? n4 < 7 || n4 > 13 : n4 < 14)))) continue;
            blArray[n4 - n2] = true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (!this.includeForeign) {
                stringBuilder.append('(');
                ExtDbRecordTV.addBaselineCountryQuery(this.extDb.type, this.extDb.version, 1, stringBuilder, false);
                stringBuilder.append(" OR ");
                ExtDbRecordTV.addBaselineFacilityIDQuery(this.extDb.type, this.extDb.version, this.proposalSource.facilityID, stringBuilder, false);
                stringBuilder.append(") AND ");
            }
            StringBuilder illegalArgumentException = new StringBuilder();
            int n7 = 40;
            for (n4 = 0; n4 < n6; ++n4) {
                if (!blArray[n4]) continue;
                illegalArgumentException.append((char)n7);
                illegalArgumentException.append(String.valueOf(n4 + n2));
                n7 = 44;
            }
            illegalArgumentException.append(')');
            ExtDbRecordTV.addBaselineMultipleChannelQuery(this.extDb.type, this.extDb.version, illegalArgumentException.toString(), stringBuilder, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorLogger.reportError(illegalArgumentException.toString());
            return null;
        }
        LinkedList<ExtDbRecordTV> linkedList = ExtDbRecordTV.findBaselineRecords(this.extDb, stringBuilder.toString(), errorLogger);
        if (null == linkedList) {
            return null;
        }
        arrayList = new ArrayList();
        for (ExtDbRecordTV extDbRecordTV : linkedList) {
            if (this.isExcluded(extDbRecordTV)) continue;
            arrayList.add(extDbRecordTV);
        }
        this.baselineCache.put(n5, arrayList);
        return arrayList;
    }

    private boolean isExcluded(ExtDbRecordTV extDbRecordTV) {
        Integer n;
        if (this.excludeApps && 3 == extDbRecordTV.statusType) {
            return true;
        }
        if (4 == extDbRecordTV.service.serviceType.key) {
            return true;
        }
        if (0 == extDbRecordTV.statusType || 5 == extDbRecordTV.statusType) {
            return true;
        }
        if (!this.includeAmendments && 6 == extDbRecordTV.statusType) {
            return true;
        }
        if (this.excludePending && 2 == extDbRecordTV.statusType && extDbRecordTV.isPending) {
            return true;
        }
        if (!(!this.excludePostTransition || extDbRecordTV.service.isLPTV() || 2 == extDbRecordTV.statusType || null == this.baselineDate || extDbRecordTV.sequenceDate.before(this.baselineDate) || null == (n = this.baselineIndex.index.get(extDbRecordTV.facilityID)) || n != extDbRecordTV.channel || null != (n = this.baselineIndex.preIndex.get(extDbRecordTV.facilityID)) && n == extDbRecordTV.channel)) {
            return true;
        }
        boolean bl = false;
        if (null != this.excludeARNs) {
            bl = this.excludeARNs.contains(extDbRecordTV.appARN.toUpperCase());
        } else if (null != this.excludeFacilityIDs) {
            bl = this.excludeFacilityIDs.contains(extDbRecordTV.facilityID);
        } else if (null != this.excludeCallSigns) {
            bl = this.excludeCallSigns.contains(extDbRecordTV.callSign.toUpperCase());
        }
        if (bl) {
            if (null == this.excludedRecords) {
                this.excludedRecords = new TreeMap();
            }
            this.excludedRecords.put(extDbRecordTV.appARN, extDbRecordTV);
            return true;
        }
        return false;
    }

    private boolean doRecordsMatchRules(SourceEditDataTV sourceEditDataTV, ExtDbRecordTV extDbRecordTV, double d, boolean bl) {
        int n = extDbRecordTV.channel;
        if (extDbRecordTV.replicateToChannel > 0) {
            n = extDbRecordTV.replicateToChannel;
        }
        int n2 = n - sourceEditDataTV.channel;
        for (IxRule ixRule : this.rules) {
            double d2;
            if (ixRule.channelDelta.delta != n2 || ixRule.channelDelta.analogOnly && sourceEditDataTV.service.serviceType.digital) continue;
            if (n < 5) {
                if (sourceEditDataTV.channel > 4) {
                    continue;
                }
            } else if (n < 7) {
                if (sourceEditDataTV.channel < 5 || sourceEditDataTV.channel > 6) {
                    continue;
                }
            } else if (n >= 14 ? sourceEditDataTV.channel < 14 : sourceEditDataTV.channel < 7 || sourceEditDataTV.channel > 13) continue;
            if (sourceEditDataTV.isParent) {
                for (SourceEditDataTV sourceEditDataTV2 : sourceEditDataTV.getDTSSources()) {
                    if (sourceEditDataTV2.siteNumber <= 0) continue;
                    d2 = ixRule.distance + sourceEditDataTV2.getRuleExtraDistance();
                    if (extDbRecordTV.service.isDTS && bl) {
                        for (GeoPoint geoPoint : extDbRecordTV.getDTSLocations()) {
                            if (!(geoPoint.distanceTo(sourceEditDataTV2.location, d) <= d2)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!(extDbRecordTV.location.distanceTo(sourceEditDataTV2.location, d) <= d2)) continue;
                    return true;
                }
                continue;
            }
            d2 = ixRule.distance + sourceEditDataTV.getRuleExtraDistance();
            if (extDbRecordTV.service.isDTS && bl) {
                for (GeoPoint geoPoint : extDbRecordTV.getDTSLocations()) {
                    if (!(geoPoint.distanceTo(sourceEditDataTV.location, d) <= d2)) continue;
                    return true;
                }
                continue;
            }
            if (!(extDbRecordTV.location.distanceTo(sourceEditDataTV.location, d) <= d2)) continue;
            return true;
        }
        return false;
    }

    private boolean doRecordsMatchRules(ExtDbRecordTV extDbRecordTV, SourceEditDataTV sourceEditDataTV, double d, boolean bl) {
        int n = extDbRecordTV.channel;
        if (extDbRecordTV.replicateToChannel > 0) {
            n = extDbRecordTV.replicateToChannel;
        }
        int n2 = sourceEditDataTV.channel - n;
        for (IxRule ixRule : this.rules) {
            double d2;
            if (ixRule.channelDelta.delta != n2 || ixRule.channelDelta.analogOnly && extDbRecordTV.service.serviceType.digital) continue;
            if (sourceEditDataTV.channel < 5) {
                if (n > 4) {
                    continue;
                }
            } else if (sourceEditDataTV.channel < 7) {
                if (n < 5 || n > 6) {
                    continue;
                }
            } else if (sourceEditDataTV.channel >= 14 ? n < 14 : n < 7 || n > 13) continue;
            if (extDbRecordTV.service.isDTS) {
                for (ExtDbRecordTV extDbRecordTV2 : extDbRecordTV.dtsRecords) {
                    d2 = ixRule.distance + extDbRecordTV2.getRuleExtraDistance(this.study);
                    if (sourceEditDataTV.isParent && bl) {
                        for (GeoPoint geoPoint : sourceEditDataTV.getDTSLocations()) {
                            if (!(geoPoint.distanceTo(extDbRecordTV2.location, d) <= d2)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!(sourceEditDataTV.location.distanceTo(extDbRecordTV2.location, d) <= d2)) continue;
                    return true;
                }
                continue;
            }
            d2 = ixRule.distance + extDbRecordTV.getRuleExtraDistance(this.study);
            if (sourceEditDataTV.isParent && bl) {
                for (GeoPoint geoPoint : sourceEditDataTV.getDTSLocations()) {
                    if (!(geoPoint.distanceTo(extDbRecordTV.location, d) <= d2)) continue;
                    return true;
                }
                continue;
            }
            if (!(sourceEditDataTV.location.distanceTo(extDbRecordTV.location, d) <= d2)) continue;
            return true;
        }
        return false;
    }

    private boolean doRecordsMatchRules(SourceEditDataTV sourceEditDataTV, SourceEditDataTV sourceEditDataTV2, double d, boolean bl) {
        int n = sourceEditDataTV2.channel - sourceEditDataTV.channel;
        for (IxRule ixRule : this.rules) {
            double d2;
            if (ixRule.channelDelta.delta != n || ixRule.channelDelta.analogOnly && sourceEditDataTV.service.serviceType.digital) continue;
            if (sourceEditDataTV2.channel < 5) {
                if (sourceEditDataTV.channel > 4) {
                    continue;
                }
            } else if (sourceEditDataTV2.channel < 7) {
                if (sourceEditDataTV.channel < 5 || sourceEditDataTV.channel > 6) {
                    continue;
                }
            } else if (sourceEditDataTV2.channel >= 14 ? sourceEditDataTV.channel < 14 : sourceEditDataTV.channel < 7 || sourceEditDataTV.channel > 13) continue;
            if (sourceEditDataTV.isParent) {
                for (SourceEditDataTV sourceEditDataTV3 : sourceEditDataTV.getDTSSources()) {
                    if (sourceEditDataTV3.siteNumber <= 0) continue;
                    d2 = ixRule.distance + sourceEditDataTV3.getRuleExtraDistance();
                    if (sourceEditDataTV2.isParent && bl) {
                        for (GeoPoint geoPoint : sourceEditDataTV2.getDTSLocations()) {
                            if (!(geoPoint.distanceTo(sourceEditDataTV3.location, d) <= d2)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!(sourceEditDataTV2.location.distanceTo(sourceEditDataTV3.location, d) <= d2)) continue;
                    return true;
                }
                continue;
            }
            d2 = ixRule.distance + sourceEditDataTV.getRuleExtraDistance();
            if (sourceEditDataTV2.isParent && bl) {
                for (GeoPoint geoPoint : sourceEditDataTV2.getDTSLocations()) {
                    if (!(geoPoint.distanceTo(sourceEditDataTV.location, d) <= d2)) continue;
                    return true;
                }
                continue;
            }
            if (!(sourceEditDataTV2.location.distanceTo(sourceEditDataTV.location, d) <= d2)) continue;
            return true;
        }
        return false;
    }

    public static String makeReportPreamble(StudyEditData studyEditData) {
        if (2 != studyEditData.study.studyType || studyEditData.scenarioData.getRowCount() < 1) {
            return "Cannot write report, invalid study.\n\n";
        }
        ScenarioEditData scenarioEditData = studyEditData.scenarioData.get(0);
        if (2 != scenarioEditData.scenarioType) {
            return "Cannot write report, invalid study.\n\n";
        }
        SourceEditDataTV sourceEditDataTV = null;
        SourceEditDataTV sourceEditDataTV2 = null;
        for (SourceEditData object : scenarioEditData.sourceData.getSources(1)) {
            if (null != object.getAttribute("-isProposal")) {
                if (null != sourceEditDataTV) {
                    sourceEditDataTV = null;
                    break;
                }
                sourceEditDataTV = (SourceEditDataTV)object;
                continue;
            }
            if (null != sourceEditDataTV2) {
                sourceEditDataTV = null;
                break;
            }
            sourceEditDataTV2 = (SourceEditDataTV)object;
        }
        if (null == sourceEditDataTV) {
            return "Cannot write report, invalid study.\n\n";
        }
        StringBuilder stringBuilder = new StringBuilder();
        StudyBuildIxCheck.makeDescription(sourceEditDataTV, null, true, sourceEditDataTV2, null, stringBuilder, null);
        double d = studyEditData.getKilometersPerDegree();
        boolean bl = true;
        for (int i = 1; i < studyEditData.scenarioData.getRowCount(); ++i) {
            ScenarioEditData scenarioEditData2 = studyEditData.scenarioData.get(i);
            SourceEditDataTV sourceEditDataTV3 = (SourceEditDataTV)scenarioEditData2.sourceData.getDesiredSource();
            if (1 != scenarioEditData2.scenarioType || null == sourceEditDataTV3 || ExtDbRecordTV.areRecordsMX(sourceEditDataTV3, sourceEditDataTV, true, 0.0, 0.0)) continue;
            if (bl) {
                stringBuilder.append("Study has been edited.  Stations studied for impact of proposal:\n\n");
                stringBuilder.append("Call      Chan  Svc Status  City, State               File Number             Distance\n");
            }
            StudyBuildIxCheck.reportSource(sourceEditDataTV3, sourceEditDataTV.location, d, bl, stringBuilder);
            bl = false;
        }
        if (bl) {
            stringBuilder.append("Study has been edited.  No protected stations found in study.\n");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static void cacheReport(String string, Path path, StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            return;
        }
        ErrorLogger errorLogger = new ErrorLogger();
        File file = path.resolve(string).toFile();
        int n = 0;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT COUNT(*) FROM ix_check_status");
                if (dbConnection.next()) {
                    n = dbConnection.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(errorLogger, sQLException);
            }
            DbCore.releaseDb(dbConnection);
        }
        long l = 0L;
        int n2 = 0;
        File[] fileArray = file.listFiles();
        if (null != fileArray) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                l += AppCore.sizeOfDirectoryContents(fileArray[i]);
                ++n2;
            }
        }
        if (errorLogger.hasErrors()) {
            stringBuilder.append("<br><b>" + errorLogger.toString() + "</b><br>\n");
        }
        stringBuilder.append("<br>Cache status:<br><br>");
        stringBuilder.append("Study runs listed in cache index: ");
        stringBuilder.append(String.valueOf(n));
        stringBuilder.append("<br>\n");
        stringBuilder.append("Study output directories in cache: ");
        stringBuilder.append(String.valueOf(n2));
        stringBuilder.append("<br>\n");
        stringBuilder.append("Storage used: ");
        if (l >= 995000000L) {
            stringBuilder.append(String.format(Locale.US, "%.2f GB", (double)l / 1.0E9));
        } else if (l >= 950000L) {
            stringBuilder.append(String.format(Locale.US, "%.1f MB", (double)l / 1000000.0));
        } else if (l >= 500L) {
            stringBuilder.append(String.format(Locale.US, "%d kB", l / 1000L));
        } else {
            stringBuilder.append(String.format(Locale.US, "%d B", l));
        }
        stringBuilder.append("<br><br>\n");
    }

    public static void cacheCleanup(String string, Path path, StringBuilder stringBuilder) {
        int n;
        ErrorLogger errorLogger = new ErrorLogger();
        File file = path.resolve(string).toFile();
        HashSet<String> hashSet = new HashSet<String>();
        File[] fileArray = file.listFiles();
        if (null != fileArray) {
            for (n = 0; n < fileArray.length; ++n) {
                if (!fileArray[n].isDirectory()) continue;
                hashSet.add(fileArray[n].getName());
            }
        }
        int n2 = 0;
        n = 0;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.update("LOCK TABLES ix_check_status WRITE");
                ArrayList arrayList = new ArrayList();
                dbConnection.query("SELECT study_name FROM ix_check_status");
                while (dbConnection.next()) {
                    String string2 = dbConnection.getString(1);
                    if (hashSet.remove(string2)) continue;
                    arrayList.add(string2);
                }
                if (!arrayList.isEmpty()) {
                    StringBuilder stringBuilder2 = new StringBuilder("DELETE FROM ix_check_status WHERE study_name IN");
                    int n3 = stringBuilder2.length();
                    String string3 = " ('";
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        stringBuilder2.append(string3);
                        stringBuilder2.append(string4);
                        if (stringBuilder2.length() > 500000) {
                            stringBuilder2.append("')");
                            n2 += dbConnection.update(stringBuilder2.toString());
                            stringBuilder2.setLength(n3);
                            string3 = " ('";
                            continue;
                        }
                        string3 = "','";
                    }
                    if (stringBuilder2.length() > n3) {
                        stringBuilder2.append("')");
                        n2 += dbConnection.update(stringBuilder2.toString());
                    }
                }
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(errorLogger, sQLException);
                hashSet.clear();
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
        } else {
            hashSet.clear();
        }
        if (!hashSet.isEmpty()) {
            for (String string2 : hashSet) {
                AppCore.deleteDirectoryAndContents(new File(file, string2));
                ++n;
            }
        }
        if (null == stringBuilder) {
            return;
        }
        if (errorLogger.hasErrors()) {
            stringBuilder.append("<br><b>" + errorLogger.toString() + "</b><br><br>\n");
        }
        stringBuilder.append("<br>Cache cleanup results:<br><br>");
        stringBuilder.append("Index entries removed: ");
        stringBuilder.append(String.valueOf(n2));
        stringBuilder.append("<br>\n");
        stringBuilder.append("Output directories deleted: ");
        stringBuilder.append(String.valueOf(n));
        stringBuilder.append("<br><br>\n");
    }

    public static void cacheDelete(String string, Path path, int n, StringBuilder stringBuilder) {
        File[] fileArray;
        ErrorLogger errorLogger = new ErrorLogger();
        File file = path.resolve(string).toFile();
        int n2 = 0;
        int n3 = 0;
        HashSet<String> hashSet = null;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.update("LOCK TABLES ix_check_status WRITE");
                n2 = dbConnection.update("DELETE FROM ix_check_status WHERE (run_date < (NOW() - INTERVAL " + String.valueOf(n) + " DAY))");
                hashSet = new HashSet<String>();
                dbConnection.query("SELECT study_name FROM ix_check_status");
                while (dbConnection.next()) {
                    hashSet.add(dbConnection.getString(1));
                }
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(errorLogger, sQLException);
                hashSet = null;
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
        }
        if (null != hashSet && null != (fileArray = file.listFiles())) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                if (!fileArray[i].isDirectory() || hashSet.contains(string2 = fileArray[i].getName())) continue;
                AppCore.deleteDirectoryAndContents(new File(file, string2));
                ++n3;
            }
        }
        if (null == stringBuilder) {
            return;
        }
        if (errorLogger.hasErrors()) {
            stringBuilder.append("<br><b>" + errorLogger.toString() + "</b><br><br>\n");
        }
        stringBuilder.append("<br>Cache delete results:<br><br>");
        stringBuilder.append("Index entries removed: ");
        stringBuilder.append(String.valueOf(n2));
        stringBuilder.append("<br>\n");
        stringBuilder.append("Output directories deleted: ");
        stringBuilder.append(String.valueOf(n3));
        stringBuilder.append("<br><br>\n");
    }

    public static class ScenarioBuilder {
        private StudyEditData study;
        private SourceEditDataTV proposalSource;
        private SourceEditDataTV proposalBeforeSource;
        private ScenarioEditData buildScenario;
        private SourceEditDataTV desiredSource;
        private ArrayList<Undesired> undesiredList;
        private int scenarioCount;
        private boolean canceled;

        public void cancel() {
            this.canceled = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public boolean buildFromScenario(ScenarioEditData scenarioEditData, StatusLogger statusLogger, ErrorLogger errorLogger) {
            int n;
            if (null == scenarioEditData.study || 2 != scenarioEditData.study.study.studyType || null != scenarioEditData.parentScenarioKey || scenarioEditData.study.scenarioData.getRowCount() < 2 || 1 != scenarioEditData.scenarioType) {
                if (null != errorLogger) {
                    errorLogger.reportError("Cannot build interference scenarios, invalid study or scenario");
                }
                return false;
            }
            this.buildScenario = scenarioEditData;
            this.study = this.buildScenario.study;
            ScenarioListData scenarioListData = this.study.scenarioData;
            ScenarioEditData scenarioEditData2 = scenarioListData.get(0);
            SourceListData sourceListData = scenarioEditData2.sourceData;
            this.proposalSource = null;
            this.proposalBeforeSource = null;
            for (n = 0; n < sourceListData.getRowCount(); ++n) {
                SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceListData.getSource(n);
                if (null != sourceEditDataTV.getAttribute("-isProposal")) {
                    if (null != this.proposalSource) {
                        this.proposalSource = null;
                        break;
                    }
                    this.proposalSource = sourceEditDataTV;
                    continue;
                }
                if (null != this.proposalBeforeSource) {
                    this.proposalSource = null;
                    break;
                }
                this.proposalBeforeSource = sourceEditDataTV;
            }
            if (2 != scenarioEditData2.scenarioType || null == this.proposalSource) {
                if (null != errorLogger) {
                    errorLogger.reportError("Cannot build interference scenarios, invalid study");
                }
                return false;
            }
            this.undesiredList = new ArrayList();
            sourceListData = this.buildScenario.sourceData;
            this.desiredSource = null;
            for (n = 0; n < sourceListData.getRowCount(); ++n) {
                Scenario.SourceListItem sourceListItem = sourceListData.get(n);
                if (sourceListItem.isDesired) {
                    if (null != this.desiredSource) {
                        this.desiredSource = null;
                        break;
                    }
                    this.desiredSource = (SourceEditDataTV)sourceListData.getSource(n);
                    continue;
                }
                Undesired undesired = new Undesired();
                undesired.source = (SourceEditDataTV)sourceListData.getSource(n);
                undesired.causesIX = sourceListItem.isUndesired;
                this.undesiredList.add(undesired);
            }
            if (null == this.desiredSource) {
                if (null != errorLogger) {
                    errorLogger.reportError("Cannot build interference scenarios, invalid scenario");
                }
                return false;
            }
            if (null != this.proposalBeforeSource && null != this.desiredSource.getAttribute("-isPreBaseline") && null != this.proposalBeforeSource.getAttribute("isBaseline")) {
                this.proposalBeforeSource = null;
            }
            this.scenarioCount = 0;
            boolean bl = ExtDbRecordTV.areRecordsMX(this.desiredSource, this.proposalSource, true, 0.0, 0.0) ? this.makeScenarios(scenarioEditData2, statusLogger, errorLogger) : this.makeScenarios(null, statusLogger, errorLogger);
            if (this.isCanceled()) {
                if (null != errorLogger) {
                    errorLogger.reportMessage("Scenario build canceled");
                }
                return false;
            }
            return bl;
        }

        private boolean makeScenarios(ScenarioEditData scenarioEditData, StatusLogger statusLogger, ErrorLogger errorLogger) {
            int n;
            double d = this.study.getKilometersPerDegree();
            int n2 = this.undesiredList.size();
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                Undesired undesired = this.undesiredList.get(n);
                boolean bl = undesired.causesIX;
                for (int i = n + 1; i < n2; ++i) {
                    if (!ExtDbRecordTV.areRecordsMX(undesired.source, this.undesiredList.get(i).source, true, 0.0, 0.0)) continue;
                    if (null == undesired.excludes) {
                        undesired.excludes = new ArrayList();
                    }
                    undesired.excludes.add(i);
                    if (!this.undesiredList.get(i).causesIX) continue;
                    bl = true;
                }
                if (null == undesired.excludes || !bl) continue;
                ++n3;
            }
            if (n3 > 18) {
                if (null != errorLogger) {
                    errorLogger.reportError("MX record count is too high, canceling study build");
                }
                return false;
            }
            if (n3 > 15 && null != statusLogger) {
                statusLogger.logMessage("**High MX record count, build and run times may be long");
            }
            this.buildScenario.removeAllChildScenarios();
            boolean[] blArray = new boolean[n2];
            for (n = 0; n < n2; ++n) {
                blArray[n] = true;
            }
            this.scenarioCount = 0;
            if (!this.doMakeScenarios(blArray, 0, scenarioEditData)) {
                if (null != errorLogger) {
                    errorLogger.reportError("Scenario build failed");
                }
                return false;
            }
            return true;
        }

        private boolean doMakeScenarios(boolean[] blArray, int n, ScenarioEditData scenarioEditData) {
            if (this.isCanceled()) {
                return false;
            }
            int n2 = n + 1;
            boolean[] blArray2 = (boolean[])blArray.clone();
            if (n2 > blArray2.length) {
                ScenarioEditData scenarioEditData2;
                String string;
                String string2;
                ScenarioEditData scenarioEditData3;
                int n3;
                ++this.scenarioCount;
                ArrayList<Scenario.SourceListItem> arrayList = new ArrayList<Scenario.SourceListItem>();
                if (null != scenarioEditData) {
                    n3 = this.proposalSource.key;
                    scenarioEditData3 = scenarioEditData;
                    arrayList.add(new Scenario.SourceListItem(n3, true, false, true));
                    for (int i = 0; i < blArray.length; ++i) {
                        if (!blArray[i]) continue;
                        arrayList.add(new Scenario.SourceListItem(((Undesired)this.undesiredList.get((int)i)).source.key, false, true, true));
                    }
                    string2 = "MX_#" + this.scenarioCount;
                    string = "Interference to proposal, scenario " + this.scenarioCount;
                    scenarioEditData2 = this.buildScenario.addChildScenario(string2, string, 3, arrayList);
                } else {
                    n3 = this.desiredSource.key;
                    arrayList.add(new Scenario.SourceListItem(n3, true, false, true));
                    if (null != this.proposalBeforeSource) {
                        arrayList.add(new Scenario.SourceListItem(this.proposalBeforeSource.key, false, true, true));
                    }
                    for (int i = 0; i < blArray.length; ++i) {
                        if (!blArray[i]) continue;
                        arrayList.add(new Scenario.SourceListItem(((Undesired)this.undesiredList.get((int)i)).source.key, false, true, true));
                    }
                    string2 = "IX_" + this.buildScenario.name + "_#" + this.scenarioCount;
                    string = "Interference to " + this.desiredSource.toString() + ", scenario " + this.scenarioCount;
                    scenarioEditData3 = this.buildScenario.addChildScenario(string2 + "_before", string + ", before", 3, arrayList);
                    if (null != this.proposalBeforeSource) {
                        arrayList.remove(1);
                    }
                    arrayList.add(1, new Scenario.SourceListItem(this.proposalSource.key, false, true, true));
                    scenarioEditData2 = this.buildScenario.addChildScenario(string2 + "_after", string + ", after", 3, arrayList);
                }
                return this.study.scenarioData.addScenarioPair(string2, string, scenarioEditData3.key, n3, scenarioEditData2.key, n3);
            }
            Undesired undesired = this.undesiredList.get(n);
            boolean bl = undesired.causesIX;
            if (blArray2[n] && null != undesired.excludes) {
                int n4;
                boolean bl2 = false;
                for (Integer n5 : undesired.excludes) {
                    n4 = n5;
                    if (!blArray2[n4]) continue;
                    blArray2[n4] = false;
                    bl2 = true;
                    if (!this.undesiredList.get(n4).causesIX) continue;
                    bl = true;
                }
                if (bl2 && bl) {
                    if (!this.doMakeScenarios(blArray2, n2, scenarioEditData)) {
                        return false;
                    }
                    blArray2[n] = false;
                    for (Integer n5 : undesired.excludes) {
                        n4 = n5;
                        blArray2[n4] = blArray[n4];
                    }
                }
            } else if (!bl) {
                blArray2[n] = false;
            }
            return this.doMakeScenarios(blArray2, n2, scenarioEditData);
        }
    }

    public static class RunIndex {
        public String indexURLPath;
        public Date runDate;
    }

    private class IXProbeResult {
        private Integer desiredSourceKey;
        private Integer undesiredSourceKey;
        private boolean causesIX;

        private IXProbeResult() {
        }
    }

    private static class Undesired {
        private SourceEditDataTV source;
        private boolean causesIX;
        private ArrayList<Integer> excludes;

        private Undesired() {
        }
    }

    private class Protected {
        private SourceEditDataTV source;
        private boolean receivesIX;
        private ArrayList<Undesired> undesiredList;
        private ScenarioEditData buildScenario;
        private HashMap<Integer, Undesired> undesiredMap;

        private Protected() {
        }
    }
}

