/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.editdata.SourceEditData;

public abstract class StudyBuild {
    public final String dbID;
    public String studyName;
    public String studyDescription;
    public Integer studyFolderKey;
    public SourceEditData source;
    public ExtDbRecord record;
    public boolean replicate;
    public boolean changeChannel;
    public int studyChannel;
    protected boolean initialized;
    private long logStartTime;
    private boolean canceled;

    protected StudyBuild(String string) {
        this.dbID = string;
    }

    public boolean initialize() {
        return this.initialize(null);
    }

    public boolean initialize(ErrorLogger errorLogger) {
        if (this.initialized) {
            return true;
        }
        if (null != this.source) {
            if (!this.source.isDataValid()) {
                if (null != errorLogger) {
                    errorLogger.reportError("The selected record object is invalid");
                }
                return false;
            }
        } else if (null == this.record) {
            if (null != errorLogger) {
                errorLogger.reportError("No study record selected");
            }
            return false;
        }
        return true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void setLogStartTime() {
        if (0L == this.logStartTime) {
            this.logStartTime = System.currentTimeMillis();
        }
    }

    public long getLogStartTime() {
        return this.logStartTime;
    }

    public String timestampMessage(String string) {
        if (this.logStartTime > 0L) {
            long l = System.currentTimeMillis() - this.logStartTime;
            int n = (int)(l / 3600000L);
            int n2 = (int)(l % 3600000L / 60000L);
            int n3 = (int)(l % 60000L / 1000L);
            int n4 = (int)(l % 1000L);
            return String.format("%3d:%02d:%02d.%03d - %s", n, n2, n3, n4, string);
        }
        return string;
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Study buildStudy() {
        return this.buildStudy(null, null);
    }

    public Study buildStudy(ErrorLogger errorLogger) {
        return this.buildStudy(null, errorLogger);
    }

    public Study buildStudy(StatusLogger statusLogger) {
        return this.buildStudy(statusLogger, null);
    }

    public abstract Study buildStudy(StatusLogger var1, ErrorLogger var2);
}

