/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbCore;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;

public class ProcessRun {
    private ArrayList<String> arguments;
    private String password;
    private Process process;
    private boolean processStarted;
    private boolean processRunning;
    private boolean processStopped;
    private boolean processFailed;
    private Handler handler;
    private boolean inPromptedState;
    private String promptResponse;
    private long lastResponseTime;
    private static final long CONFIRMATION_TIMEOUT = 2000L;
    private int responseAttempts;
    private static final int MAX_RESPONSE_ATTEMPTS = 3;
    private static final int READ_BUFFER_SIZE = 10000;
    private BufferedInputStream processOutput;
    private byte[] readBuffer;
    private static final int MAX_READ_PER_POLL = 100000;
    private StringBuilder outputBuffer;
    private boolean skipNextLine;
    private long lastOutputTime;
    private long stuckTimeout = 600000L;
    private boolean wasAlive;
    private int processID;
    private long terminateSentTime;
    private static final long TERMINATE_WAIT = 10000L;
    public static final int POLL_INTERVAL = 200;

    public ProcessRun(ArrayList<String> arrayList, String string) {
        this.arguments = new ArrayList<String>(arrayList);
        this.password = string;
        this.outputBuffer = new StringBuilder();
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
        this.inPromptedState = false;
    }

    public void setStuckTimeout(long l) {
        this.stuckTimeout = l;
    }

    public void run() {
        while (this.poll()) {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean poll() {
        if (null != this.handler && !this.processStopped && this.handler.isCanceled()) {
            this.stop(true);
        }
        long l = System.currentTimeMillis();
        if (!this.processStarted) {
            this.processStarted = true;
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(this.arguments);
                Map<String, String> map = processBuilder.environment();
                String string = map.get("DYLD_LIBRARY_PATH");
                if (null == string) {
                    string = map.get("LD_LIBRARY_PATH");
                }
                string = null == string ? AppCore.libDirectoryPath.toString() : string + ":" + AppCore.libDirectoryPath.toString();
                map.put("DYLD_LIBRARY_PATH", string);
                map.put("LD_LIBRARY_PATH", string);
                if (null != DbCore.mysqlSocketFile) {
                    map.put("MYSQL_UNIX_PORT", DbCore.mysqlSocketFile);
                }
                processBuilder.redirectErrorStream(true);
                this.process = processBuilder.start();
                this.processRunning = true;
                this.wasAlive = true;
            }
            catch (Throwable throwable) {
                AppCore.log(3, "Could not start process", throwable);
            }
            if (!this.processRunning) {
                this.processFailed = true;
                if (null == this.handler) return false;
                this.handler.processFailed(this);
                return false;
            }
            this.processOutput = new BufferedInputStream(this.process.getInputStream(), 10000);
            this.readBuffer = new byte[10000];
            this.lastOutputTime = l;
        }
        if (!this.processRunning) {
            return false;
        }
        if (this.terminateSentTime > 0L && l - this.terminateSentTime > 10000L) {
            this.stop(false);
            return false;
        }
        boolean bl = false;
        if (!this.collectOutput()) {
            if (!this.process.isAlive()) {
                if (this.wasAlive) {
                    this.wasAlive = false;
                    return true;
                }
                if (this.process.exitValue() != 0) {
                    this.processFailed = true;
                }
                this.processRunning = false;
                if (null == this.handler) return false;
                if (this.processFailed) {
                    this.handler.processFailed(this);
                    return false;
                }
                this.handler.processComplete(this);
                return false;
            }
        } else {
            this.lastOutputTime = l;
            if (null != this.password && this.outputBuffer.toString().toLowerCase().contains("password")) {
                bl = true;
            }
            int n = 0;
            int n2 = this.outputBuffer.length();
            String string = null;
            while (n < n2) {
                char c;
                while ('\n' != (c = this.outputBuffer.charAt(n)) && '\r' != c && ++n < n2) {
                }
                if (n >= n2) continue;
                boolean bl2 = '\r' == c;
                string = this.outputBuffer.substring(0, n++);
                this.outputBuffer.delete(0, n);
                n2 -= n;
                n = 0;
                if (null != this.password || this.skipNextLine) {
                    this.skipNextLine = false;
                    continue;
                }
                if (null != this.handler) {
                    if (this.inPromptedState) {
                        if (this.responseAttempts <= 0) {
                            AppCore.log(3, "Unexpected output '" + string + "' from controlled process");
                            this.stop(false);
                            return false;
                        }
                        this.handler.processResponseConfirmed(this);
                        this.inPromptedState = false;
                    } else if (string.startsWith("#*#*#")) {
                        this.promptResponse = this.handler.getProcessResponse(this, string);
                        if (null == this.promptResponse) {
                            AppCore.log(3, "Unexpected prompt '" + string + "' from controlled process");
                            this.stop(false);
                            return false;
                        }
                        this.inPromptedState = true;
                        this.lastResponseTime = 0L;
                        this.responseAttempts = 0;
                        continue;
                    }
                }
                if (string.startsWith("$$")) {
                    int n3 = string.indexOf(61);
                    if (n3 < 0) continue;
                    String string2 = string.substring(2, n3);
                    String string3 = string.substring(n3 + 1);
                    if (string2.equals("pid")) {
                        try {
                            this.processID = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (null == this.handler) continue;
                    this.handler.processMessage(this, string2, string3);
                    continue;
                }
                if (null == this.handler) continue;
                this.handler.processOutput(this, string, bl2);
            }
        }
        if (this.stuckTimeout > 0L && l - this.lastOutputTime > this.stuckTimeout) {
            AppCore.log(3, "Process stalled, no output for timeout interval");
            this.stop(false);
            return false;
        }
        if (bl) {
            try {
                OutputStream outputStream = this.process.getOutputStream();
                outputStream.write(this.password.getBytes());
                outputStream.write(13);
                outputStream.flush();
            }
            catch (IOException iOException) {
                this.stop(false);
                return false;
            }
            this.password = null;
            this.skipNextLine = true;
            return true;
        }
        if (!this.inPromptedState) return true;
        if (l - this.lastResponseTime <= 2000L) return true;
        if (++this.responseAttempts > 3) {
            AppCore.log(3, "No output from controlled process after sending prompt response");
            this.stop(false);
            return false;
        }
        this.lastResponseTime = l;
        try {
            OutputStream outputStream = this.process.getOutputStream();
            outputStream.write(this.promptResponse.getBytes());
            outputStream.write(13);
            outputStream.flush();
            return true;
        }
        catch (IOException iOException) {
            this.stop(false);
            return false;
        }
    }

    private boolean collectOutput() {
        boolean bl = false;
        if (null == this.processOutput) {
            return bl;
        }
        int n = 0;
        try {
            while (this.processOutput.available() > 0 && n < 100000) {
                int n2 = this.processOutput.read(this.readBuffer);
                if (n2 <= 0) continue;
                this.outputBuffer.append(new String(this.readBuffer, 0, n2));
                bl = true;
                n += n2;
            }
        }
        catch (IOException iOException) {
            this.stop(false);
        }
        return bl;
    }

    public synchronized void stop(boolean bl) {
        if (this.processStarted && !this.processRunning) {
            return;
        }
        if (!this.processStarted) {
            this.processStarted = true;
            this.processStopped = true;
            return;
        }
        if (bl && this.processID > 0) {
            if (this.terminateSentTime > 0L) {
                return;
            }
            this.terminateSentTime = System.currentTimeMillis();
            this.processStopped = true;
            this.processFailed = true;
            try {
                new ProcessBuilder("/bin/kill", "-TERM", String.valueOf(this.processID)).start();
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.process.destroyForcibly();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.processStopped = true;
        this.processFailed = true;
        this.processRunning = false;
        this.wasAlive = false;
        if (null != this.handler) {
            this.handler.processFailed(this);
        }
    }

    public synchronized boolean isRunning() {
        if (this.processStarted) {
            return this.processRunning;
        }
        return true;
    }

    public synchronized boolean wasStopped() {
        return this.processStopped;
    }

    public synchronized boolean didFail() {
        return this.processFailed;
    }

    public static interface Handler {
        public void processOutput(ProcessRun var1, String var2, boolean var3);

        public void processMessage(ProcessRun var1, String var2, String var3);

        public boolean isCanceled();

        public String getProcessResponse(ProcessRun var1, String var2);

        public void processResponseConfirmed(ProcessRun var1);

        public void processFailed(ProcessRun var1);

        public void processComplete(ProcessRun var1);
    }
}

