/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;

public class OutputConfig {
    public static final int CONFIG_TYPE_FILE = 1;
    public static final int CONFIG_TYPE_MAP = 2;
    public static final String UNSAVED_CONFIG_NAME = "(custom)";
    public static final String NULL_CONFIG_NAME = "(not set)";
    public static final String NO_OUTPUT_CODE = "_";
    public static final String DEFAULT_CODES_FILE = "an";
    public static final String DEFAULT_CODES_MAP = "_";
    private static final String LAST_USED_NAME_FILE = "outputName";
    private static final String LAST_USED_CODES_FILE = "outputCodes";
    private static final String LAST_USED_NAME_MAP = "mapOutputName";
    private static final String LAST_USED_CODES_MAP = "mapOutputCodes";
    private static final int MAX_FLAG_COUNT = 26;
    public static final int REPORT_FILE_DETAIL = 0;
    public static final int REPORT_FILE_SUMMARY = 1;
    public static final int CSV_FILE_DETAIL = 2;
    public static final int CSV_FILE_SUMMARY = 3;
    public static final int CELL_FILE_DETAIL = 4;
    public static final int CELL_FILE_SUMMARY = 5;
    public static final int CELL_FILE_PAIRSTUDY = 6;
    public static final int CELL_FILE_CSV = 7;
    public static final int POINTS_FILE = 10;
    public static final int PARAMS_FILE = 11;
    public static final int SETTING_FILE = 13;
    public static final int LOG_FILE = 14;
    public static final int IXCHK_DEL_PASS = 15;
    public static final int IXCHK_MARG_CSV = 16;
    public static final int POINT_FILE_PROF = 17;
    public static final int DERIVE_HPAT_FILE = 18;
    public static final int COMPOSITE_COVERAGE = 19;
    public static final int IXCHK_PROP_CONT = 20;
    public static final int IXCHK_REPORT_WORST = 21;
    public static final int POINT_NOTCALC = 22;
    public static final int SELFIX_CSV = 23;
    private static final String[][] FLAG_NAMES_FILE = new String[][]{{"Detailed results, text", "Only IX undesireds", "All undesireds"}, {"Summary results, text"}, {"Detailed results, CSV", "Only IX undesireds", "All undesireds"}, {"Summary results, CSV"}, {"Detailed cell data, CEL", "No Census points", "With Census points"}, {"Summary cell data, CEL"}, {"Pair study cell data, CEL"}, {"Detailed cell data, CSV"}, {"(reserved)"}, {"(reserved)"}, {"Study points, CSV"}, {"Parameters, CSV", "All stations", "Desired only"}, {"(reserved)"}, {"Settings file, text"}, {"Run output, text", "Log", "Report", "Log + Report"}, {"TV IX check: Failed scenarios only", " ", "+ all MX"}, {"TV IX check: D/U margins, CSV", "1-degree totals", "1-deg ignore 0 pop", "All points", "All ignore 0 pop"}, {"Points mode: Terrain profiles, CSV"}, {"Derived azimuth patterns, CSV"}, {"Report composite coverage"}, {"TV IX check: Proposed contour, CSV", " ", "+ shapefile", "+ KML"}, {"TV IX check: Report worst-case IX"}, {"Points mode: Exclude not-computed"}, {"DTS self-interference, CSV", "IX points", "IX ignore 0 pop", "All points", "All ignore 0 pop"}};
    private static final int[][] FLAG_LIST_FILE = new int[][]{{0, 1, 2, 3, 11, 14}, {4, 5, 7, 10, 18, 23, 20, 16, 17}, {19, 15, 21, 22}};
    private static final String[] FLAG_GROUPS_FILE = new String[]{"Reports", "Data", "Options"};
    public static final int MAP_OUT_AREAPOP = 0;
    public static final int MAP_OUT_DESINFO = 1;
    public static final int MAP_OUT_UNDINFO = 2;
    public static final int MAP_OUT_MARGIN = 3;
    public static final int MAP_OUT_WLINFO = 4;
    public static final int MAP_OUT_SELFIX = 5;
    public static final int MAP_OUT_RAMP = 6;
    public static final int MAP_OUT_CLUTTER = 7;
    public static final int MAP_OUT_NOSERV = 8;
    public static final int MAP_OUT_NOPOP = 9;
    public static final int MAP_OUT_CENTER = 10;
    public static final int MAP_OUT_SHAPE = 11;
    public static final int MAP_OUT_KML = 12;
    public static final int MAP_OUT_IMAGE = 13;
    public static final int MAP_OUT_COORDS = 14;
    public static final int MAP_OUT_COLORS = 15;
    public static final int MAP_OUT_HEIGHT = 16;
    public static final int MAP_OUT_SHP_CMP = 17;
    public static final int MAP_OUT_SHP_PTS = 18;
    public static final int MAP_OUT_KML_CPT = 19;
    public static final int MAP_OUT_KML_KMZ = 20;
    private static final String[][] FLAG_NAMES_MAP = new String[][]{{"Area, population, households"}, {"Desired signal and margin"}, {"Worst undesired D/U and margin"}, {"Smallest margin"}, {"Wireless signal, D/U, and margin"}, {"DTS self-interference points", "IX points", "All points"}, {"Ramp/alpha (uncapped)"}, {"Land cover and clutter"}, {"Exclude no-service study points"}, {"Exclude no-population study points"}, {"Map point at grid cell center"}, {"Shapefile map output"}, {"KML map output", "Combined", "By station"}, {"Image output", "Desired signal margin", "Worst-case D/U margin", "Wireless D/U margin", "Self-interference D/U margin", "Smallest margin", "Desired signal"}, {"Study point coordinates"}, {"Image color map"}, {"Study point ground height"}, {"Composite coverage points"}, {"Unique study points"}, {"Coverage points"}, {"Create KMZ file"}};
    private static final int[][] FLAG_LIST_MAP = new int[][]{{-11, 17, 18}, {-12, 13, 15, 19, 5, 20}, {8, 9, 10}, {14, 0, 16, 7, 1, 2, 4, 3, 6}};
    private static final int[][] FLAG_LIST_MAP_NOIMAGE = new int[][]{{-11, 17, 18}, {-12, 19, 20}, {8, 9, 10}, {14, 0, 16, 7, 1, 2, 4, 5, 3, 6}};
    private static final String[] FLAG_GROUPS_MAP = new String[]{"Shapefile", "KML", "Options", "Point Metadata"};
    public final int type;
    public String name;
    public int[] flags;
    private static HashMap<String, TreeMap<String, OutputConfig>> dbCache = new HashMap();

    public OutputConfig(int n, String string) {
        this.type = n;
        this.name = UNSAVED_CONFIG_NAME;
        this.flags = new int[26];
        this.setCodes(string);
    }

    public OutputConfig(int n, String string, String string2) {
        this.type = n;
        this.name = string;
        this.flags = new int[26];
        this.setCodes(string2);
    }

    private OutputConfig(int n) {
        this.type = n;
    }

    public OutputConfig copy() {
        OutputConfig outputConfig = new OutputConfig(this.type);
        outputConfig.name = this.name;
        outputConfig.flags = (int[])this.flags.clone();
        return outputConfig;
    }

    public String toString() {
        if (null == this.name) {
            return "";
        }
        return this.name;
    }

    public int hashCode() {
        if (null == this.name) {
            return 0;
        }
        return (this.name + String.valueOf(this.type)).hashCode();
    }

    public boolean equals(Object object) {
        return null != object && null != this.name && this.type == ((OutputConfig)object).type && this.name.equalsIgnoreCase(((OutputConfig)object).name);
    }

    public static String getTypeName(int n) {
        switch (n) {
            default: {
                return "Output Files";
            }
            case 2: 
        }
        return "Map Files";
    }

    public static int[][] getFlagList(int n) {
        switch (n) {
            default: {
                return FLAG_LIST_FILE;
            }
            case 2: 
        }
        if (AppCore.showImageOptions) {
            return FLAG_LIST_MAP;
        }
        return FLAG_LIST_MAP_NOIMAGE;
    }

    public static String[] getFlagGroups(int n) {
        switch (n) {
            default: {
                return FLAG_GROUPS_FILE;
            }
            case 2: 
        }
        return FLAG_GROUPS_MAP;
    }

    public static String[][] getFlagNames(int n) {
        switch (n) {
            default: {
                return FLAG_NAMES_FILE;
            }
            case 2: 
        }
        return FLAG_NAMES_MAP;
    }

    public boolean isUnsaved() {
        return this.name != null && this.name.equalsIgnoreCase(UNSAVED_CONFIG_NAME);
    }

    public boolean isNull() {
        return this.name != null && this.name.equalsIgnoreCase(NULL_CONFIG_NAME);
    }

    public String getCodes() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 26; ++i) {
            if (this.flags[i] <= 0) continue;
            stringBuilder.append(Character.forDigit(i + 10, 36));
            if (this.flags[i] <= 1) continue;
            stringBuilder.append(String.valueOf(this.flags[i]));
        }
        return stringBuilder.toString();
    }

    public void setCodes(String string) {
        int n;
        int n2;
        int n3 = -1;
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < 26; ++n2) {
            this.flags[n2] = 0;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            n2 = Character.digit(c, 36);
            if (n2 < 10) {
                if (n2 >= 0) {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.setLength(0);
                continue;
            }
            if (stringBuilder.length() > 0) {
                if (n3 >= 0) {
                    try {
                        n = Integer.parseInt(stringBuilder.toString());
                        if (n > 0) {
                            this.flags[n3] = n;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                stringBuilder.setLength(0);
            }
            if ((n2 -= 10) < 26) {
                this.flags[n2] = 1;
                n3 = n2;
                continue;
            }
            n3 = -1;
        }
        if (stringBuilder.length() > 0 && n3 >= 0) {
            try {
                n = Integer.parseInt(stringBuilder.toString());
                if (n > 0) {
                    this.flags[n3] = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (2 == this.type) {
            if (this.flags[13] > 0) {
                if (0 == this.flags[15]) {
                    switch (this.flags[13]) {
                        default: {
                            this.flags[15] = 1;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            this.flags[15] = 2;
                            break;
                        }
                        case 6: {
                            this.flags[15] = 3;
                            break;
                        }
                    }
                }
            } else {
                this.flags[15] = 0;
            }
        }
    }

    public boolean matchesConfig(OutputConfig outputConfig) {
        if (this.type != outputConfig.type) {
            return false;
        }
        for (int i = 0; i < 26; ++i) {
            if (this.flags[i] == outputConfig.flags[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        if (null == this.name || 0 == this.name.trim().length()) {
            return false;
        }
        return 2 != this.type || this.flags[13] <= 0 || 0 != this.flags[15];
    }

    public boolean save(String string) {
        return this.save(string, null);
    }

    public synchronized boolean save(String string, ErrorLogger errorLogger) {
        DbConnection dbConnection;
        if (null != this.name) {
            this.name = this.name.trim();
        }
        if (null == this.name || 0 == this.name.length() || this.name.equalsIgnoreCase(UNSAVED_CONFIG_NAME) || this.name.equalsIgnoreCase(NULL_CONFIG_NAME)) {
            if (null != errorLogger) {
                errorLogger.reportError("Settings save failed, invalid name");
            }
            return false;
        }
        if (this.name.length() > 245) {
            this.name = this.name.substring(0, 245);
        }
        if (null == (dbConnection = DbCore.connectDb(string, errorLogger))) {
            return false;
        }
        String string2 = null;
        try {
            dbConnection.update("LOCK TABLES output_config WRITE");
            dbConnection.update("DELETE FROM output_config WHERE type = " + this.type + " AND UPPER(name) = '" + DbConnection.clean(this.name.toUpperCase()) + "'");
            dbConnection.update("INSERT INTO output_config VALUES (" + this.type + ",'" + DbConnection.clean(this.name) + "', '" + DbConnection.clean(this.getCodes()) + "')");
        }
        catch (SQLException sQLException) {
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string2) {
            if (null != errorLogger) {
                errorLogger.reportError(string2);
            }
            return false;
        }
        TreeMap<String, OutputConfig> treeMap = dbCache.get(string);
        if (null == treeMap) {
            treeMap = OutputConfig.loadCache(string);
        } else {
            treeMap.put(this.name.toUpperCase() + String.valueOf(this.type), this.copy());
        }
        return true;
    }

    public void saveAsLastUsed(String string) {
        if (null != this.name) {
            this.name = this.name.trim();
        }
        if (null != this.name && 0 != this.name.length() && !this.name.equalsIgnoreCase(NULL_CONFIG_NAME)) {
            switch (this.type) {
                default: {
                    DbCore.setProperty(string, LAST_USED_NAME_FILE, this.name);
                    DbCore.setProperty(string, LAST_USED_CODES_FILE, this.getCodes());
                    break;
                }
                case 2: {
                    DbCore.setProperty(string, LAST_USED_NAME_MAP, this.name);
                    DbCore.setProperty(string, LAST_USED_CODES_MAP, this.getCodes());
                }
            }
        }
    }

    public static synchronized ArrayList<OutputConfig> getConfigs(String string, int n) {
        ArrayList<OutputConfig> arrayList = new ArrayList<OutputConfig>();
        TreeMap<String, OutputConfig> treeMap = dbCache.get(string);
        if (null == treeMap) {
            treeMap = OutputConfig.loadCache(string);
        }
        for (OutputConfig outputConfig : treeMap.values()) {
            if (n != outputConfig.type) continue;
            arrayList.add(outputConfig.copy());
        }
        return arrayList;
    }

    public static OutputConfig getConfig(String string, int n, String string2) {
        String string3;
        OutputConfig outputConfig;
        if (null != string2) {
            string2 = string2.trim();
        }
        if (null == string2 || 0 == string2.length() || string2.equalsIgnoreCase(UNSAVED_CONFIG_NAME) || string2.equalsIgnoreCase(NULL_CONFIG_NAME)) {
            return null;
        }
        TreeMap<String, OutputConfig> treeMap = dbCache.get(string);
        if (null == treeMap) {
            treeMap = OutputConfig.loadCache(string);
        }
        if (null == (outputConfig = treeMap.get(string3 = string2.toUpperCase() + String.valueOf(n)))) {
            outputConfig = OutputConfig.loadCache(string).get(string3);
        }
        if (null != outputConfig) {
            outputConfig = outputConfig.copy();
        }
        return outputConfig;
    }

    public static OutputConfig getOrMakeConfig(String string, int n, String string2, String string3) {
        if (null == string2 || null == string3 || 0 == string2.length() || string2.equalsIgnoreCase(NULL_CONFIG_NAME)) {
            return OutputConfig.getNullObject(n);
        }
        OutputConfig outputConfig = null;
        if (!string2.equalsIgnoreCase(UNSAVED_CONFIG_NAME)) {
            TreeMap<String, OutputConfig> treeMap = dbCache.get(string);
            if (null == treeMap) {
                treeMap = OutputConfig.loadCache(string);
            }
            if (null != (outputConfig = treeMap.get(string2.toUpperCase() + String.valueOf(n)))) {
                outputConfig = outputConfig.copy();
            }
        }
        if (null == outputConfig) {
            outputConfig = new OutputConfig(n, string2, string3);
        }
        return outputConfig;
    }

    public static OutputConfig getDefaultObject(int n) {
        switch (n) {
            default: {
                return new OutputConfig(1, DEFAULT_CODES_FILE);
            }
            case 2: 
        }
        return new OutputConfig(2, "_");
    }

    public static OutputConfig getNullObject(int n) {
        return new OutputConfig(n, NULL_CONFIG_NAME, "");
    }

    private static TreeMap<String, OutputConfig> loadCache(String string) {
        TreeMap<String, OutputConfig> treeMap = new TreeMap<String, OutputConfig>();
        DbConnection dbConnection = DbCore.connectDb(string);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT type, name, codes FROM output_config");
                while (dbConnection.next()) {
                    OutputConfig outputConfig = new OutputConfig(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3));
                    treeMap.put(outputConfig.name.toUpperCase() + String.valueOf(outputConfig.type), outputConfig);
                }
                dbCache.put(string, treeMap);
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
        }
        return treeMap;
    }

    public static OutputConfig getLastUsed(String string, int n) {
        String string2;
        String string3 = null;
        String string4 = null;
        switch (n) {
            default: {
                string3 = DbCore.getProperty(string, LAST_USED_NAME_FILE);
                string4 = DbCore.getProperty(string, LAST_USED_CODES_FILE);
                break;
            }
            case 2: {
                string3 = DbCore.getProperty(string, LAST_USED_NAME_MAP);
                string4 = DbCore.getProperty(string, LAST_USED_CODES_MAP);
            }
        }
        if (null != string3 && null != string4) {
            OutputConfig outputConfig = OutputConfig.getConfig(string, n, string3);
            if (null == outputConfig) {
                outputConfig = new OutputConfig(n, string3, string4);
            }
            return outputConfig;
        }
        if (1 == n && null != (string2 = AppCore.getProperty("outputFlags"))) {
            OutputConfig outputConfig = new OutputConfig(1, "");
            outputConfig.setLegacyCodes(string2);
            return outputConfig;
        }
        return OutputConfig.getDefaultObject(n);
    }

    public static boolean deleteConfig(String string, int n, String string2) {
        return OutputConfig.deleteConfig(string, n, string2, null);
    }

    public static synchronized boolean deleteConfig(String string, int n, String string2, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        try {
            dbConnection.update("DELETE FROM output_config WHERE type = " + n + " AND UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "'");
            DbCore.releaseDb(dbConnection);
        }
        catch (SQLException sQLException) {
            DbCore.releaseDb(dbConnection);
            DbConnection.reportError(errorLogger, sQLException);
            return false;
        }
        TreeMap<String, OutputConfig> treeMap = dbCache.get(string);
        if (null != treeMap) {
            treeMap.remove(string2.toUpperCase() + String.valueOf(n));
        }
        return true;
    }

    public void setLegacyCodes(String string) {
        int n;
        if (1 != this.type) {
            return;
        }
        for (n = 0; n < 26; ++n) {
            this.flags[n] = 0;
        }
        this.flags[13] = 1;
        block29: for (n = 0; n < string.length(); ++n) {
            block0 : switch (n) {
                case 0: {
                    switch (string.charAt(n)) {
                        case '1': {
                            this.flags[0] = 1;
                            break;
                        }
                        case '2': {
                            this.flags[1] = 1;
                        }
                    }
                    continue block29;
                }
                case 1: {
                    switch (string.charAt(n)) {
                        case '1': {
                            this.flags[2] = 1;
                            break;
                        }
                        case '2': {
                            this.flags[3] = 1;
                        }
                    }
                    continue block29;
                }
                case 2: {
                    switch (string.charAt(n)) {
                        case '1': {
                            this.flags[4] = 1;
                            break;
                        }
                        case '2': {
                            this.flags[5] = 1;
                            break;
                        }
                        case '4': {
                            this.flags[7] = 1;
                        }
                    }
                    continue block29;
                }
                case 3: {
                    continue block29;
                }
                case 4: {
                    switch (string.charAt(n)) {
                        case '1': {
                            this.flags[10] = 1;
                        }
                    }
                    continue block29;
                }
                case 5: {
                    switch (string.charAt(n)) {
                        case '1': {
                            this.flags[11] = 2;
                            break block0;
                        }
                        case '2': {
                            this.flags[11] = 1;
                        }
                    }
                }
            }
        }
    }

    public static String updateLegacyCodes(String string) {
        OutputConfig outputConfig = new OutputConfig(1, "");
        outputConfig.setLegacyCodes(string);
        return outputConfig.getCodes();
    }
}

