/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;

public class ExtDbSearch {
    public static final int SEARCH_TYPE_DESIREDS = 1;
    public static final int SEARCH_TYPE_UNDESIREDS = 2;
    public static final int SEARCH_TYPE_PROTECTEDS = 3;
    public static final String DEFAULT_DESIREDS_SEARCH_NAME = "Desireds";
    public static final String DEFAULT_UNDESIREDS_SEARCH_NAME = "Undesireds";
    public static final String DEFAULT_PROTECTEDS_SEARCH_NAME = "Protecteds";
    public final int studyType;
    public String name;
    public int recordType;
    public int searchType;
    public boolean disableMX;
    public boolean mxFacilityIDOnly;
    public boolean preferOperating;
    public boolean desiredOnly;
    public HashSet<Integer> serviceKeys;
    public HashSet<Integer> countryKeys;
    public HashSet<Integer> statusTypes;
    public double radius;
    public GeoPoint center;
    public int minimumChannel;
    public int maximumChannel;
    public boolean includeSharingGuests;
    public String additionalSQL;
    public boolean autoRun;
    private static HashMap<String, TreeMap<String, ExtDbSearch>> dbCache = new HashMap();

    public ExtDbSearch(int n) {
        this.studyType = n;
        this.name = "";
        this.recordType = Study.getDefaultRecordType(n);
        this.searchType = 1;
        this.serviceKeys = new HashSet();
        this.countryKeys = new HashSet();
        this.statusTypes = new HashSet();
        this.center = new GeoPoint();
        this.additionalSQL = "";
    }

    public ExtDbSearch copy() {
        ExtDbSearch extDbSearch = new ExtDbSearch(this.studyType);
        extDbSearch.name = this.name;
        extDbSearch.recordType = this.recordType;
        extDbSearch.searchType = this.searchType;
        extDbSearch.disableMX = this.disableMX;
        extDbSearch.mxFacilityIDOnly = this.mxFacilityIDOnly;
        extDbSearch.preferOperating = this.preferOperating;
        extDbSearch.desiredOnly = this.desiredOnly;
        for (Integer n : this.serviceKeys) {
            extDbSearch.serviceKeys.add(n);
        }
        for (Integer n : this.countryKeys) {
            extDbSearch.countryKeys.add(n);
        }
        for (Integer n : this.statusTypes) {
            extDbSearch.statusTypes.add(n);
        }
        extDbSearch.radius = this.radius;
        extDbSearch.center.setLatLon(this.center);
        extDbSearch.minimumChannel = this.minimumChannel;
        extDbSearch.maximumChannel = this.maximumChannel;
        extDbSearch.includeSharingGuests = this.includeSharingGuests;
        extDbSearch.additionalSQL = this.additionalSQL;
        extDbSearch.autoRun = this.autoRun;
        return extDbSearch;
    }

    public String toString() {
        if (null == this.name) {
            return "";
        }
        if (this.autoRun) {
            return this.name + " (auto)";
        }
        return this.name;
    }

    public int hashCode() {
        if (null == this.name) {
            return 0;
        }
        return (this.name + String.valueOf(this.studyType)).hashCode();
    }

    public boolean equals(Object object) {
        return null != object && null != this.name && this.studyType == ((ExtDbSearch)object).studyType && this.name.equalsIgnoreCase(((ExtDbSearch)object).name);
    }

    public boolean save(String string) {
        return this.save(string, null);
    }

    public synchronized boolean save(String string, ErrorLogger errorLogger) {
        Serializable serializable;
        DbConnection dbConnection;
        if (null != this.name) {
            this.name = this.name.trim();
        }
        if (null == this.name || 0 == this.name.length() || this.name.equalsIgnoreCase(DEFAULT_DESIREDS_SEARCH_NAME) || this.name.equalsIgnoreCase(DEFAULT_UNDESIREDS_SEARCH_NAME) || this.name.equalsIgnoreCase(DEFAULT_PROTECTEDS_SEARCH_NAME)) {
            if (null != errorLogger) {
                errorLogger.reportError("Search save failed, invalid name");
            }
            return false;
        }
        if (this.name.length() > 245) {
            this.name = this.name.substring(245);
        }
        if (null == (dbConnection = DbCore.connectDb(string, errorLogger))) {
            return false;
        }
        String string2 = null;
        try {
            serializable = new StringBuilder();
            String string3 = "";
            for (Integer object22 : this.serviceKeys) {
                ((StringBuilder)serializable).append(string3);
                ((StringBuilder)serializable).append(String.valueOf(object22));
                string3 = ",";
            }
            String string4 = ((StringBuilder)serializable).toString();
            serializable = new StringBuilder();
            string3 = "";
            for (Integer n : this.countryKeys) {
                ((StringBuilder)serializable).append(string3);
                ((StringBuilder)serializable).append(String.valueOf(n));
                string3 = ",";
            }
            String string5 = ((StringBuilder)serializable).toString();
            serializable = new StringBuilder();
            string3 = "";
            for (Integer n : this.statusTypes) {
                ((StringBuilder)serializable).append(string3);
                ((StringBuilder)serializable).append(String.valueOf(n));
                string3 = ",";
            }
            String string6 = ((StringBuilder)serializable).toString();
            dbConnection.update("LOCK TABLES ext_db_search WRITE");
            dbConnection.update("DELETE FROM ext_db_search WHERE study_type = " + this.studyType + " AND UPPER(name) = '" + DbConnection.clean(this.name.toUpperCase()) + "'");
            dbConnection.update("INSERT INTO ext_db_search VALUES (" + this.studyType + ", '" + DbConnection.clean(this.name) + "', " + this.recordType + ", " + this.searchType + ", " + this.disableMX + ", " + this.mxFacilityIDOnly + ", " + this.preferOperating + ", " + this.desiredOnly + ", '" + (String)string4 + "', '" + string5 + "', '" + string6 + "', " + this.radius + ", " + this.center.latitude + ", " + this.center.longitude + ", " + this.minimumChannel + ", " + this.maximumChannel + ", " + this.includeSharingGuests + ", '" + DbConnection.clean(this.additionalSQL) + "', " + this.autoRun + ")");
        }
        catch (SQLException sQLException) {
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string2) {
            if (null != errorLogger) {
                errorLogger.reportError(string2);
            }
            return false;
        }
        serializable = dbCache.get(string);
        if (null == serializable) {
            serializable = ExtDbSearch.loadCache(string);
        } else {
            ((TreeMap)serializable).put(this.name.toUpperCase() + String.valueOf(this.studyType), this.copy());
        }
        return true;
    }

    public static synchronized ArrayList<ExtDbSearch> getSearches(String string, int n) {
        ArrayList<ExtDbSearch> arrayList = new ArrayList<ExtDbSearch>();
        TreeMap<String, ExtDbSearch> treeMap = dbCache.get(string);
        if (null == treeMap) {
            treeMap = ExtDbSearch.loadCache(string);
        }
        for (ExtDbSearch extDbSearch : treeMap.values()) {
            if (n != extDbSearch.studyType) continue;
            arrayList.add(extDbSearch.copy());
        }
        return arrayList;
    }

    public static ExtDbSearch getSearch(String string, int n, String string2) {
        ExtDbSearch extDbSearch;
        if (null != string2) {
            string2 = string2.trim();
        }
        if (null == string2 || 0 == string2.length()) {
            return null;
        }
        TreeMap<String, ExtDbSearch> treeMap = dbCache.get(string);
        if (null == treeMap) {
            treeMap = ExtDbSearch.loadCache(string);
        }
        if (null != (extDbSearch = treeMap.get(string2.toUpperCase() + String.valueOf(n)))) {
            extDbSearch = extDbSearch.copy();
        }
        return extDbSearch;
    }

    private static TreeMap<String, ExtDbSearch> loadCache(String string) {
        TreeMap<String, ExtDbSearch> treeMap = new TreeMap<String, ExtDbSearch>();
        DbConnection dbConnection = DbCore.connectDb(string);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT study_type, name, record_type, search_type, disable_mx, mx_facility_id_only, prefer_operating, desired_only, service_keys, country_keys, status_types, radius, latitude, longitude, minimum_channel, maximum_channel, include_sharing_guests, additional_sql, auto_run FROM ext_db_search");
                while (dbConnection.next()) {
                    ExtDbSearch extDbSearch = new ExtDbSearch(dbConnection.getInt(1));
                    extDbSearch.name = dbConnection.getString(2);
                    extDbSearch.recordType = dbConnection.getInt(3);
                    extDbSearch.searchType = dbConnection.getInt(4);
                    extDbSearch.disableMX = dbConnection.getBoolean(5);
                    extDbSearch.mxFacilityIDOnly = dbConnection.getBoolean(6);
                    extDbSearch.preferOperating = dbConnection.getBoolean(7);
                    extDbSearch.desiredOnly = dbConnection.getBoolean(8);
                    for (String string2 : dbConnection.getString(9).split(",")) {
                        try {
                            extDbSearch.serviceKeys.add(Integer.valueOf(string2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    for (String string2 : dbConnection.getString(10).split(",")) {
                        try {
                            extDbSearch.countryKeys.add(Integer.valueOf(string2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    for (String string2 : dbConnection.getString(11).split(",")) {
                        try {
                            extDbSearch.statusTypes.add(Integer.valueOf(string2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    extDbSearch.radius = dbConnection.getDouble(12);
                    extDbSearch.center.setLatLon(dbConnection.getDouble(13), dbConnection.getDouble(14));
                    extDbSearch.minimumChannel = dbConnection.getInt(15);
                    extDbSearch.maximumChannel = dbConnection.getInt(16);
                    extDbSearch.includeSharingGuests = dbConnection.getBoolean(17);
                    extDbSearch.additionalSQL = dbConnection.getString(18);
                    extDbSearch.autoRun = dbConnection.getBoolean(19);
                    treeMap.put(extDbSearch.name.toUpperCase() + String.valueOf(extDbSearch.studyType), extDbSearch);
                }
                dbCache.put(string, treeMap);
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
        }
        return treeMap;
    }

    public static boolean deleteSearch(String string, int n, String string2) {
        return ExtDbSearch.deleteSearch(string, n, string2, null);
    }

    public static synchronized boolean deleteSearch(String string, int n, String string2, ErrorLogger errorLogger) {
        if (null == string2 || 0 == string2.length()) {
            return true;
        }
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        try {
            dbConnection.update("DELETE FROM ext_db_search WHERE study_type = " + n + " AND UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "'");
            DbCore.releaseDb(dbConnection);
        }
        catch (SQLException sQLException) {
            DbCore.releaseDb(dbConnection);
            DbConnection.reportError(errorLogger, sQLException);
            return false;
        }
        TreeMap<String, ExtDbSearch> treeMap = dbCache.get(string);
        if (null != treeMap) {
            treeMap.remove(string2.toUpperCase() + String.valueOf(n));
        }
        return true;
    }

    public String makeQuery(ExtDb extDb, boolean bl) {
        return this.makeQuery(extDb, bl, null);
    }

    public String makeQuery(ExtDb extDb, boolean bl, ErrorLogger errorLogger) {
        if (!Study.isRecordTypeAllowed(this.studyType, this.recordType)) {
            errorLogger.reportError("Record type is not allowed for study type");
            return null;
        }
        if (!extDb.canProvide(this.recordType)) {
            errorLogger.reportError("Record type is not provided by station data");
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = bl && extDb.hasBaseline();
        boolean bl3 = extDb.isGeneric();
        boolean bl4 = false;
        try {
            if (!bl2 && !bl3) {
                bl4 = ExtDbRecord.addRecordTypeQuery(extDb.type, extDb.version, this.recordType, false, stringBuilder, false);
            }
            boolean bl5 = true;
            for (Integer object : this.countryKeys) {
                Country country = Country.getCountry(object);
                if (null == country) continue;
                if (bl5) {
                    if (!bl4) {
                        stringBuilder.append('(');
                    } else {
                        stringBuilder.append(" AND (");
                    }
                    bl5 = false;
                } else {
                    stringBuilder.append(" OR ");
                }
                if (bl2) {
                    ExtDbRecordTV.addBaselineCountryQuery(extDb.type, extDb.version, country, stringBuilder, false);
                    continue;
                }
                if (bl3) {
                    SourceEditData.addCountryQuery(extDb.type, country, stringBuilder, false);
                    continue;
                }
                ExtDbRecord.addCountryQuery(extDb.type, extDb.version, this.recordType, country, stringBuilder, false);
            }
            if (!bl5) {
                stringBuilder.append(')');
                bl4 = true;
            }
            bl5 = true;
            for (Integer n : this.serviceKeys) {
                Service service = Service.getService(n);
                if (null == service) continue;
                if (bl5) {
                    if (!bl4) {
                        stringBuilder.append('(');
                    } else {
                        stringBuilder.append(" AND (");
                    }
                    bl5 = false;
                } else {
                    stringBuilder.append(" OR ");
                }
                if (bl2) {
                    ExtDbRecordTV.addBaselineServiceQuery(extDb.type, extDb.version, service.key, stringBuilder, false);
                    continue;
                }
                if (bl3) {
                    SourceEditData.addServiceQuery(extDb.type, service.key, stringBuilder, false);
                    continue;
                }
                ExtDbRecord.addServiceQuery(extDb.type, extDb.version, this.recordType, service.key, stringBuilder, false);
            }
            if (!bl5) {
                stringBuilder.append(')');
                bl4 = true;
            }
            if (!bl2) {
                bl5 = true;
                for (Integer n : this.statusTypes) {
                    if (bl5) {
                        if (!bl4) {
                            stringBuilder.append('(');
                        } else {
                            stringBuilder.append(" AND (");
                        }
                        bl5 = false;
                    } else {
                        stringBuilder.append(" OR ");
                    }
                    if (bl3) {
                        SourceEditData.addStatusQuery(extDb.type, n, stringBuilder, false);
                        continue;
                    }
                    ExtDbRecord.addStatusQuery(extDb.type, extDb.version, this.recordType, n, stringBuilder, false);
                }
                if (!bl5) {
                    stringBuilder.append(')');
                    bl4 = true;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (null != errorLogger) {
                errorLogger.reportError(illegalArgumentException.toString());
            }
            return null;
        }
        if (this.additionalSQL.length() > 0) {
            if (!bl4) {
                stringBuilder.append('(');
            } else {
                stringBuilder.append(" AND (");
            }
            stringBuilder.append(this.additionalSQL);
            stringBuilder.append(')');
            bl4 = true;
        }
        return stringBuilder.toString();
    }
}

